## Breaking changes

- [BREAKING] Fix [#480](https://github.com/biojppm/rapidyaml/issues/480) ([PR#489](https://github.com/biojppm/rapidyaml/pull/489)):
  - Deserializing an empty quoted string *will not* cause an error.
  - Deserializing an empty string *will* cause an error: the empty string is read in as an empty scalar.
  - Ensure keys are deserialized using all the rules applying to vals.
  - Added `KEYNIL` and `VALNIL` to `NodeType_e`, used by the parser to mark the key or val as empty. This changed the values of the `NodeType_e` enumeration.
  - Added `NodeType::key_is_null()` and `NodeType::val_is_null()`.
- [BREAKING] Fix [#477](https://github.com/biojppm/rapidyaml/issues/477) ([PR#479](https://github.com/biojppm/rapidyaml/pull/479)): changed `read<std::map>()` to overwrite existing entries. The provided implementations had an inconsistency between `std::map` (which wasn't overwriting) and `std::vector` (which *was* overwriting).


## Fixes

- [PR#488](https://github.com/biojppm/rapidyaml/pull/488):
  - add workarounds for problems with codegen of gcc 11,12,13.
  - improve CI coverage of gcc and clang optimization levels.
- [PR#496](https://github.com/biojppm/rapidyaml/pull/496) and [c4core PR#148](https://github.com/biojppm/c4core/pull/148): Add CI-proven support for CPU architectures:
  - mips, mipsel, mips64, mips64el
  - sparc, sparc64
  - riscv64
  - loongarch64
- Fix [#476](https://github.com/biojppm/rapidyaml/issues/476) ([PR#493](https://github.com/biojppm/rapidyaml/pull/493)): add handling of Byte Order Marks.
- [PR#492](https://github.com/biojppm/rapidyaml/pull/492): fix emit of explicit keys when indented:
  ```yaml
  fixed:
      ? explicit key
      : value
  previously:
      ? explicit key
  : value   # this was not indented
  ```
- [PR#492](https://github.com/biojppm/rapidyaml/pull/492): fix parser reset for full reuse (`m_doc_empty` was not resetted), which would cause problems under specific scenarios in subsequent reuse.
- [PR#485](https://github.com/biojppm/rapidyaml/pull/485): improve the CI workflows (thanks to @ingydotnet):
  - amazing code reuse and organization, thanks to the use of YamlScript to generate the final workflows
  - all optimization levels are now covered for gcc, clang and Visual Studio.
- [PR#499](https://github.com/biojppm/rapidyaml/pull/499): fix warnings with `-Wundef`.


## Thanks

- @ingydotnet
- @perlpunk
- @Delian0
