// --- Generated by AidaCxxStub ---

// --- Custom Includes ---
#ifndef __AIDA_UTILITIES_HH__
#include "widget.hh"
#endif


#ifndef AIDA_CHECK
#define AIDA_CHECK(cond,errmsg) do { if (cond) break; throw std::runtime_error (std::string ("AIDA-ERROR: ") + errmsg); } while (0)
#endif

namespace { // Anon
using Rapicorn::Aida::uint64;

namespace __AIDA_Local__ {
using namespace Rapicorn::Aida;

// types
typedef ServerConnection::EmitResultHandler EmitResultHandler;
typedef ServerConnection::MethodRegistry    MethodRegistry;
typedef ServerConnection::MethodEntry       MethodEntry;

static_assert (std::is_base_of<Rapicorn::Aida::ImplicitBase, Rapicorn::BaseObject>::value,
               "IDL interface base 'Rapicorn::BaseObject' must derive 'Rapicorn::Aida::ImplicitBase'");

// connection
static Rapicorn::Aida::ServerConnection *server_connection = NULL;
static Rapicorn::Init init_server_connection ([]() {
  server_connection = ObjectBroker::new_server_connection (":Rapicorn1307:AidaServerConnection:CxxStub:idl_file=ui/interfaces.idl:");
});

// EmitResultHandler
static inline void erhandler_add (size_t id, const EmitResultHandler &function)
{
  return server_connection->emit_result_handler_add (id, function);
}

// objects
template<class Target> static inline Target* id2obj (uint64 oid)
{
  Rapicorn::Aida::ImplicitBase *instance = server_connection->orbid2instance (oid);
  return dynamic_cast<Target*> (instance);
}

static inline uint64 obj2id  (Rapicorn::Aida::ImplicitBase *obj)
{
  return server_connection->instance2orbid (obj);
}

template<class Object> static inline Object*
smh2obj (const SmartHandle &sh)
{
  return id2obj<Object> (sh._orbid());
}

template<class SMH> static inline SMH
obj2smh (Rapicorn::BaseObject *self)
{
  const uint64 orbid = obj2id (self);
  SMH target;
  struct Broker : ObjectBroker { using ObjectBroker::tie_handle; };
  Broker::tie_handle (target, orbid);
  return target;
}

// messages
static inline void
post_msg (FieldBuffer *fb)
{
  ObjectBroker::post_msg (fb);
}

static inline void
add_header1_discon (FieldBuffer &fb, size_t signal_handler_id, uint64 h, uint64 l)
{
  fb.add_header1 (Rapicorn::Aida::MSGID_DISCONNECT, ObjectBroker::connection_id_from_signal_handler_id (signal_handler_id), h, l);
}

static inline void
add_header1_emit (FieldBuffer &fb, size_t signal_handler_id, uint64 h, uint64 l)
{
  fb.add_header1 (Rapicorn::Aida::MSGID_EMIT_ONEWAY, ObjectBroker::connection_id_from_signal_handler_id (signal_handler_id), h, l);
}

static inline void
add_header2_emit (FieldBuffer &fb, size_t signal_handler_id, uint64 h, uint64 l)
{
  fb.add_header2 (Rapicorn::Aida::MSGID_EMIT_TWOWAY, ObjectBroker::connection_id_from_signal_handler_id (signal_handler_id),
                  server_connection->connection_id(), h, l);
}

static inline FieldBuffer*
new_call_result (FieldReader &fbr, uint64 h, uint64 l, uint32 n = 1)
{
  return ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_CALL_RESULT, ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), h, l, n);
}

static inline FieldBuffer*
new_connect_result (FieldReader &fbr, uint64 h, uint64 l, uint32 n = 1)
{
  return ObjectBroker::renew_into_result (fbr, Rapicorn::Aida::MSGID_CONNECT_RESULT, ObjectBroker::receiver_connection_id (fbr.field_buffer()->first_id()), h, l, n);
}

// slot
template<class SharedPtr, class R, class... Args> std::function<R (Args...)>
slot (SharedPtr sp, R (*fp) (const SharedPtr&, Args...))
{
  return [sp, fp] (Args... args) { return fp (sp, args...); };
}

} } // Anon::__AIDA_Local__


// --- Implementations ---

namespace Rapicorn {

ListModelIface::ListModelIface ()
{}
ListModelIface::~ListModelIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, ListModelIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ListModelIface* &obj)
{
  obj = __AIDA_Local__::id2obj<ListModelIface> (fbr.pop_object());
}
ListModelIface*
operator->* (ListModelHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<ListModelIface> (sh);
}
ListModelHandle
operator->* (ListModelIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<ListModelHandle> (obj);
}
Rapicorn::Aida::BaseConnection*
ListModelIface::__aida_connection__()
{
  return __AIDA_Local__::server_connection;
}
void
ListModelIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x87df0968192d4892ULL, 0xd8aa6bcd9795c903ULL)); // ListModel
}
const Rapicorn::Aida::PropertyList&
ListModelIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, Rapicorn::BaseObject::__aida_properties__());
  return property_list;
}

ListModelRelayIface::ListModelRelayIface ()
{}
ListModelRelayIface::~ListModelRelayIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, ListModelRelayIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ListModelRelayIface* &obj)
{
  obj = __AIDA_Local__::id2obj<ListModelRelayIface> (fbr.pop_object());
}
ListModelRelayIface*
operator->* (ListModelRelayHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<ListModelRelayIface> (sh);
}
ListModelRelayHandle
operator->* (ListModelRelayIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<ListModelRelayHandle> (obj);
}
Rapicorn::Aida::BaseConnection*
ListModelRelayIface::__aida_connection__()
{
  return __AIDA_Local__::server_connection;
}
void
ListModelRelayIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3e993ff1349c815cULL, 0x7280939def52d4e9ULL)); // ListModelRelay
}
const Rapicorn::Aida::PropertyList&
ListModelRelayIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, Rapicorn::BaseObject::__aida_properties__());
  return property_list;
}

WidgetIface::WidgetIface ()
{}
WidgetIface::~WidgetIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, WidgetIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, WidgetIface* &obj)
{
  obj = __AIDA_Local__::id2obj<WidgetIface> (fbr.pop_object());
}
WidgetIface*
operator->* (WidgetHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<WidgetIface> (sh);
}
WidgetHandle
operator->* (WidgetIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<WidgetHandle> (obj);
}
Rapicorn::Aida::BaseConnection*
WidgetIface::__aida_connection__()
{
  return __AIDA_Local__::server_connection;
}
void
WidgetIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
}
const Rapicorn::Aida::PropertyList&
WidgetIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
    RAPICORN_AIDA_PROPERTY (WidgetIface, name, _("Name"), _("Identification name of the widget"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, width, _("Requested Width"), _("The width to request from its container for this widget, -1=automatic"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, height, _("Requested Height"), _("The height to request from its container for this widget, -1=automatic"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hexpand, _("Horizontal Expand"), _("Whether to expand this widget horizontally"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vexpand, _("Vertical Expand"), _("Whether to expand this widget vertically"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hspread, _("Horizontal Spread"), _("Whether to expand this widget and all its parents horizontally"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vspread, _("Vertical Spread"), _("Whether to expand this widget and all its parents vertically"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hshrink, _("Horizontal Shrink"), _("Whether the widget may be shrunken horizontally"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vshrink, _("Vertical Shrink"), _("Whether the widget may be shrunken vertically"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, visible, _("Visible"), _("Whether this widget is visible"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, sensitive, _("Sensitive"), _("Whether this widget is sensitive (receives events)"), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hposition, _("Horizontal Position"), _("Horizontal layout position for the widget"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hspan, _("Horizontal Span"), _("Horizontal span for widget layout"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vposition, _("Vertical Position"), _("Vertical layout position for the widget"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vspan, _("Vertical Span"), _("Vertical span for widget layout"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, left_spacing, _("Left Spacing"), _("Amount of spacing to add at the widget's left side"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, right_spacing, _("Right Spacing"), _("Amount of spacing to add at the widget's right side"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, bottom_spacing, _("Bottom Spacing"), _("Amount of spacing to add at the widget's bottom side"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, top_spacing, _("Top Spacing"), _("Amount of spacing to add at the widget's top side"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hanchor, _("Horizontal Anchor"), _("Horizontal position of child anchor, 0=left, 1=right"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vanchor, _("Vertical Anchor"), _("Vertical position of child anchor, 0=bottom, 1=top"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, halign, _("Horizontal Alignment"), _("Horizontal position within extra space when unexpanded, 0=left, 1=right"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, hscale, _("Horizontal Scale"), _("Fractional horizontal expansion within extra space, 0=unexpanded, 1=expanded"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, valign, _("Vertical Alignment"), _("Vertical position within extra space when unexpanded, 0=bottom, 1=top"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, vscale, _("Vertical Scale"), _("Fractional vertical expansion within extra space, 0=unexpanded, 1=expanded"), "Prw"),
    RAPICORN_AIDA_PROPERTY (WidgetIface, color_scheme, _("Color Scheme"), _("Color scheme to render this widget"), "rw"),
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, Rapicorn::BaseObject::__aida_properties__());
  return property_list;
}

ContainerIface::ContainerIface ()
{}
ContainerIface::~ContainerIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, ContainerIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ContainerIface* &obj)
{
  obj = __AIDA_Local__::id2obj<ContainerIface> (fbr.pop_object());
}
ContainerIface*
operator->* (ContainerHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<ContainerIface> (sh);
}
ContainerHandle
operator->* (ContainerIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<ContainerHandle> (obj);
}
void
ContainerIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
  thl.push_back (Rapicorn::Aida::TypeHash (0x5bab3a4c9bcaeca4ULL, 0x0be9b6d2440be3c0ULL)); // Container
}
const Rapicorn::Aida::PropertyList&
ContainerIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, WidgetIface::__aida_properties__());
  return property_list;
}

ButtonAreaIface::ButtonAreaIface ()
{}
ButtonAreaIface::~ButtonAreaIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, ButtonAreaIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ButtonAreaIface* &obj)
{
  obj = __AIDA_Local__::id2obj<ButtonAreaIface> (fbr.pop_object());
}
ButtonAreaIface*
operator->* (ButtonAreaHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<ButtonAreaIface> (sh);
}
ButtonAreaHandle
operator->* (ButtonAreaIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<ButtonAreaHandle> (obj);
}
void
ButtonAreaIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
  thl.push_back (Rapicorn::Aida::TypeHash (0x5bab3a4c9bcaeca4ULL, 0x0be9b6d2440be3c0ULL)); // Container
  thl.push_back (Rapicorn::Aida::TypeHash (0xd4eba9953fe88dd9ULL, 0x084b6a3a8f6103afULL)); // ButtonArea
}
const Rapicorn::Aida::PropertyList&
ButtonAreaIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
    RAPICORN_AIDA_PROPERTY (ButtonAreaIface, on_click, _("On CLick"), _("Action to carry out on button1 clicks."), "rw"),
    RAPICORN_AIDA_PROPERTY (ButtonAreaIface, on_click2, _("On CLick"), _("Action to carry out on button2 clicks."), "rw"),
    RAPICORN_AIDA_PROPERTY (ButtonAreaIface, on_click3, _("On CLick"), _("Action to carry out on button3 clicks."), "rw"),
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, ContainerIface::__aida_properties__());
  return property_list;
}

DrawableIface::DrawableIface ()
{}
DrawableIface::~DrawableIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, DrawableIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, DrawableIface* &obj)
{
  obj = __AIDA_Local__::id2obj<DrawableIface> (fbr.pop_object());
}
DrawableIface*
operator->* (DrawableHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<DrawableIface> (sh);
}
DrawableHandle
operator->* (DrawableIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<DrawableHandle> (obj);
}
void
DrawableIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
  thl.push_back (Rapicorn::Aida::TypeHash (0x4c89f0cb4cc5fd40ULL, 0x6176a2cb29385095ULL)); // Drawable
}
const Rapicorn::Aida::PropertyList&
DrawableIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, WidgetIface::__aida_properties__());
  return property_list;
}

WidgetListIface::WidgetListIface ()
{}
WidgetListIface::~WidgetListIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, WidgetListIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, WidgetListIface* &obj)
{
  obj = __AIDA_Local__::id2obj<WidgetListIface> (fbr.pop_object());
}
WidgetListIface*
operator->* (WidgetListHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<WidgetListIface> (sh);
}
WidgetListHandle
operator->* (WidgetListIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<WidgetListHandle> (obj);
}
void
WidgetListIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
  thl.push_back (Rapicorn::Aida::TypeHash (0x5bab3a4c9bcaeca4ULL, 0x0be9b6d2440be3c0ULL)); // Container
  thl.push_back (Rapicorn::Aida::TypeHash (0x4d8f55734db02590ULL, 0xb0027c1cf106e90eULL)); // WidgetList
}
const Rapicorn::Aida::PropertyList&
WidgetListIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
    RAPICORN_AIDA_PROPERTY (WidgetListIface, model, _("Model"), _("Source locator for the data to be displayed."), "rw"),
    RAPICORN_AIDA_PROPERTY (WidgetListIface, selection_mode, _("Selection Mode"), _("None - allow no selected rows<br/>Single - allow a single selected row<br/>Browse - always select a single row<br/>Multiple - allow any row selection combinations<br/>"), "rw"),
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, ContainerIface::__aida_properties__());
  return property_list;
}

WindowIface::WindowIface ()
{}
WindowIface::~WindowIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, WindowIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, WindowIface* &obj)
{
  obj = __AIDA_Local__::id2obj<WindowIface> (fbr.pop_object());
}
WindowIface*
operator->* (WindowHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<WindowIface> (sh);
}
WindowHandle
operator->* (WindowIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<WindowHandle> (obj);
}
void
WindowIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
  thl.push_back (Rapicorn::Aida::TypeHash (0x5bab3a4c9bcaeca4ULL, 0x0be9b6d2440be3c0ULL)); // Container
  thl.push_back (Rapicorn::Aida::TypeHash (0x1eb140f8125ad2ebULL, 0xbf9a6a7ebeee4b3eULL)); // Window
}
const Rapicorn::Aida::PropertyList&
WindowIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
    RAPICORN_AIDA_PROPERTY (WindowIface, title, _("Window Title"), _("User visible title to be displayed in the window title bar"), "rw"),
    RAPICORN_AIDA_PROPERTY (WindowIface, auto_focus, _("Auto Focus"), _("Automatically set focus widget when the window is shown initially"), "rw"),
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, ContainerIface::__aida_properties__());
  return property_list;
}

ApplicationIface::ApplicationIface ()
{}
ApplicationIface::~ApplicationIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, ApplicationIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, ApplicationIface* &obj)
{
  obj = __AIDA_Local__::id2obj<ApplicationIface> (fbr.pop_object());
}
ApplicationIface*
operator->* (ApplicationHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<ApplicationIface> (sh);
}
ApplicationHandle
operator->* (ApplicationIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<ApplicationHandle> (obj);
}
Rapicorn::Aida::BaseConnection*
ApplicationIface::__aida_connection__()
{
  return __AIDA_Local__::server_connection;
}
void
ApplicationIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0xe5f9548043408aa5ULL, 0x6908b766da2ce656ULL)); // Application
}
const Rapicorn::Aida::PropertyList&
ApplicationIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, Rapicorn::BaseObject::__aida_properties__());
  return property_list;
}

IdlTestWidgetIface::IdlTestWidgetIface ()
{}
IdlTestWidgetIface::~IdlTestWidgetIface ()
{}
void
operator<<= (Rapicorn::Aida::FieldBuffer &fb, IdlTestWidgetIface *obj)
{
  fb.add_object (__AIDA_Local__::obj2id (obj));
}
void
operator>>= (Rapicorn::Aida::FieldReader &fbr, IdlTestWidgetIface* &obj)
{
  obj = __AIDA_Local__::id2obj<IdlTestWidgetIface> (fbr.pop_object());
}
IdlTestWidgetIface*
operator->* (IdlTestWidgetHandle &sh, Rapicorn::Aida::_ServantType)
{
  return __AIDA_Local__::smh2obj<IdlTestWidgetIface> (sh);
}
IdlTestWidgetHandle
operator->* (IdlTestWidgetIface *obj, Rapicorn::Aida::_HandleType)
{
  return __AIDA_Local__::obj2smh<IdlTestWidgetHandle> (obj);
}
void
IdlTestWidgetIface::__aida_typelist__ (Rapicorn::Aida::TypeHashList &thl) const
{
  thl.push_back (Rapicorn::Aida::TypeHash (0x3da86581a5b52b19ULL, 0x84b2d8e05389bdd5ULL)); // Widget
  thl.push_back (Rapicorn::Aida::TypeHash (0x817eedabcc71a18dULL, 0x6d0ebd54c6f76d87ULL)); // IdlTestWidget
}
const Rapicorn::Aida::PropertyList&
IdlTestWidgetIface::__aida_properties__ ()
{
  static Rapicorn::Aida::PropertyList::Property *properties[] = {
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, bool_prop, "bool_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, int_prop, "int_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, float_prop, "float_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, string_prop, "string_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, enum_prop, "enum_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, record_prop, "record_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, sequence_prop, "sequence_prop", "", ""),
    // RAPICORN_AIDA_PROPERTY (IdlTestWidgetIface, self_prop, "self_prop", "", ""),
  };
  static const Rapicorn::Aida::PropertyList property_list (properties, WidgetIface::__aida_properties__());
  return property_list;
}

// --- Method Dispatchers & Registry ---
static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModel____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ListModelIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x7d38659266bcc806ULL, 0x7150e9f047ddfeedULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModel__count (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ListModelIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->count ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x9093828fc77e641aULL, 0x7e188ef4a3a95df1ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModel__row (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ListModelIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_index;
  fbr >>= arg_index;
  Rapicorn::Aida::Any  rval = self->row (arg_index);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x0daa87bb937470ceULL, 0xac2cfd46e1de2fe3ULL);
  rb <<= rval;
  return &rb;
}
class __AIDA_Closure__ListModel__updated {
  size_t handler_id_;
public:
  typedef std::shared_ptr<__AIDA_Closure__ListModel__updated> SharedPtr;
  __AIDA_Closure__ListModel__updated (size_t h) : handler_id_ (h) {}
  ~__AIDA_Closure__ListModel__updated()
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
    __AIDA_Local__::add_header1_discon (fb, handler_id_, 0xed8b8e157d8e8b09ULL, 0x40f08ab74596907eULL);
    fb <<= handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
  static void
  handler (const SharedPtr &sp,
           const UpdateRequest &arg_urequest)
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1 + 0);
    __AIDA_Local__::add_header1_emit (fb, sp->handler_id_, 0xed8b8e157d8e8b09ULL, 0x40f08ab74596907eULL);
    fb <<= sp->handler_id_;
    fb <<= arg_urequest;
    __AIDA_Local__::post_msg (&fb);
  }
};
static Rapicorn::Aida::FieldBuffer*
__aida_connect__ListModel__updated (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  ListModelIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  size_t handler_id;
  Rapicorn::Aida::uint64 signal_connection, result = 0;
  fbr >>= handler_id;
  fbr >>= signal_connection;
  if (signal_connection)
    result = self->sig_updated() -= signal_connection;
  if (handler_id) {
    __AIDA_Closure__ListModel__updated::SharedPtr sp (new __AIDA_Closure__ListModel__updated (handler_id));
    result = self->sig_updated() += __AIDA_Local__::slot (sp, sp->handler);
  }
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_connect_result (fbr, 0xed8b8e157d8e8b09ULL, 0x40f08ab74596907eULL);
  rb <<= result;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModelRelay____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ListModelRelayIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x6f68d0e884a2ebdbULL, 0xdd54f615e10593caULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModelRelay__model (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ListModelRelayIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  ListModelIface *rval = self->model ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x1e82ea1bf240ad5fULL, 0x2c8e4f655a3f3e8fULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModelRelay__fill (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  ListModelRelayIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_first;
  fbr >>= arg_first;
  AnySeq  arg_asq;
  fbr >>= arg_asq;
  self->fill (arg_first, arg_asq);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__ListModelRelay__update (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ListModelRelayIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  UpdateRequest  arg_urequest;
  fbr >>= arg_urequest;
  self->update (arg_urequest);
  return NULL;
}
class __AIDA_Closure__ListModelRelay__refill {
  size_t handler_id_;
public:
  typedef std::shared_ptr<__AIDA_Closure__ListModelRelay__refill> SharedPtr;
  __AIDA_Closure__ListModelRelay__refill (size_t h) : handler_id_ (h) {}
  ~__AIDA_Closure__ListModelRelay__refill()
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
    __AIDA_Local__::add_header1_discon (fb, handler_id_, 0xfc80c8eeadcb6268ULL, 0x14b0db287fc04b3dULL);
    fb <<= handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
  static void
  handler (const SharedPtr &sp,
           const UpdateRequest &arg_urequest)
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 1 + 0);
    __AIDA_Local__::add_header1_emit (fb, sp->handler_id_, 0xfc80c8eeadcb6268ULL, 0x14b0db287fc04b3dULL);
    fb <<= sp->handler_id_;
    fb <<= arg_urequest;
    __AIDA_Local__::post_msg (&fb);
  }
};
static Rapicorn::Aida::FieldBuffer*
__aida_connect__ListModelRelay__refill (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  ListModelRelayIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  size_t handler_id;
  Rapicorn::Aida::uint64 signal_connection, result = 0;
  fbr >>= handler_id;
  fbr >>= signal_connection;
  if (signal_connection)
    result = self->sig_refill() -= signal_connection;
  if (handler_id) {
    __AIDA_Closure__ListModelRelay__refill::SharedPtr sp (new __AIDA_Closure__ListModelRelay__refill (handler_id));
    result = self->sig_refill() += __AIDA_Local__::slot (sp, sp->handler);
  }
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_connect_result (fbr, 0xfc80c8eeadcb6268ULL, 0x14b0db287fc04b3dULL);
  rb <<= result;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__Widget____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x1eb6c5178436ad26ULL, 0x9f4a4699676886d5ULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__name (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->name ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x031285308fcdf2a6ULL, 0xe4751a850e1e28fdULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__name (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_name;
  fbr >>= arg_name;
  self->name (arg_name);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__width (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->width ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x84994bfcea433d65ULL, 0x11da4bfc5c624c8fULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__width (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_width;
  fbr >>= arg_width;
  self->width (arg_width);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__height (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->height ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x35f842828c2bfa77ULL, 0x1884ebea3e98dbbfULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__height (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_height;
  fbr >>= arg_height;
  self->height (arg_height);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hexpand (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->hexpand ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xddc9455b83b5c9e3ULL, 0x673d77bbb37b6468ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hexpand (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_hexpand;
  fbr >>= arg_hexpand;
  self->hexpand (arg_hexpand);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vexpand (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->vexpand ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xf0a4b0e20f0cd5fdULL, 0xdfabca8039302e55ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vexpand (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_vexpand;
  fbr >>= arg_vexpand;
  self->vexpand (arg_vexpand);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hspread (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->hspread ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x5ac252d6317e7d36ULL, 0x98a184e2844406e8ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hspread (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_hspread;
  fbr >>= arg_hspread;
  self->hspread (arg_hspread);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vspread (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->vspread ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x391f095f19534988ULL, 0xf4867a2ebaa3c794ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vspread (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_vspread;
  fbr >>= arg_vspread;
  self->vspread (arg_vspread);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hshrink (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->hshrink ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x251603c131c31f86ULL, 0x5dff639bd6c70e19ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hshrink (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_hshrink;
  fbr >>= arg_hshrink;
  self->hshrink (arg_hshrink);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vshrink (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->vshrink ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x43c07cf21c154377ULL, 0x499474085275cd26ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vshrink (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_vshrink;
  fbr >>= arg_vshrink;
  self->vshrink (arg_vshrink);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__visible (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->visible ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x70842a509744bcb9ULL, 0xc07e68d369809582ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__visible (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_visible;
  fbr >>= arg_visible;
  self->visible (arg_visible);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__sensitive (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->sensitive ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x480267748b1cbcccULL, 0xc09ac65197b64c3bULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__sensitive (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_sensitive;
  fbr >>= arg_sensitive;
  self->sensitive (arg_sensitive);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hposition (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->hposition ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x26e5b794bb960060ULL, 0x8680536d636a3351ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hposition (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_hposition;
  fbr >>= arg_hposition;
  self->hposition (arg_hposition);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hspan (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->hspan ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x5eeb1641d7c3b52dULL, 0xb9dc0b7b3ea6e31aULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hspan (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_hspan;
  fbr >>= arg_hspan;
  self->hspan (arg_hspan);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vposition (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->vposition ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x74aeb757e09afcfdULL, 0x968359ce2c9c7849ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vposition (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_vposition;
  fbr >>= arg_vposition;
  self->vposition (arg_vposition);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vspan (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->vspan ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x2a12130db96b5ae9ULL, 0x00d0b705609fd4feULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vspan (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_vspan;
  fbr >>= arg_vspan;
  self->vspan (arg_vspan);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__left_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->left_spacing ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x969c1084b85dd454ULL, 0xf16cdb02bbacbb3bULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__left_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_left_spacing;
  fbr >>= arg_left_spacing;
  self->left_spacing (arg_left_spacing);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__right_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->right_spacing ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x4c38330e86f21375ULL, 0xa3c2608930578e4dULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__right_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_right_spacing;
  fbr >>= arg_right_spacing;
  self->right_spacing (arg_right_spacing);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__bottom_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->bottom_spacing ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x1c7b00a54d4cab7eULL, 0xb2946b8d608eb312ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__bottom_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_bottom_spacing;
  fbr >>= arg_bottom_spacing;
  self->bottom_spacing (arg_bottom_spacing);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__top_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->top_spacing ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xe7c94f940a362078ULL, 0xbfc0002e602aab18ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__top_spacing (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_top_spacing;
  fbr >>= arg_top_spacing;
  self->top_spacing (arg_top_spacing);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hanchor (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->hanchor ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xbaedd681aec0abc2ULL, 0x5cbd3da8d0dff05cULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hanchor (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_hanchor;
  fbr >>= arg_hanchor;
  self->hanchor (arg_hanchor);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vanchor (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->vanchor ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x4421c5e41bc6ac93ULL, 0x1feaa29a57b54407ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vanchor (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_vanchor;
  fbr >>= arg_vanchor;
  self->vanchor (arg_vanchor);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__halign (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->halign ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x2b61614a4e727c24ULL, 0x49420277ff5bc98bULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__halign (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_halign;
  fbr >>= arg_halign;
  self->halign (arg_halign);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__hscale (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->hscale ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x84016e98460561a1ULL, 0xdfe2267757460248ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__hscale (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_hscale;
  fbr >>= arg_hscale;
  self->hscale (arg_hscale);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__valign (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->valign ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x311f02f1f9878086ULL, 0x3c26a48be3bb42d5ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__valign (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_valign;
  fbr >>= arg_valign;
  self->valign (arg_valign);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__vscale (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->vscale ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x4673932466b5324fULL, 0x119e3992a3be264fULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__vscale (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_vscale;
  fbr >>= arg_vscale;
  self->vscale (arg_vscale);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Widget__color_scheme (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  ColorSchemeType  rval = self->color_scheme ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x7670b7ba59b09d8fULL, 0xf67517302113137fULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Widget__color_scheme (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  ColorSchemeType  arg_color_scheme;
  fbr >>= arg_color_scheme;
  self->color_scheme (arg_color_scheme);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Widget__match_selector (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_selector;
  fbr >>= arg_selector;
  bool  rval = self->match_selector (arg_selector);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x50ee99f8844291f4ULL, 0x3f72b3646a1a7bc7ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Widget__query_selector (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_selector;
  fbr >>= arg_selector;
  WidgetIface *rval = self->query_selector (arg_selector);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xb6980840cde71811ULL, 0xb14e1aa50e08cfd8ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Widget__query_selector_all (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_selector;
  fbr >>= arg_selector;
  WidgetSeq  rval = self->query_selector_all (arg_selector);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x2a5a8ff0a59cad2eULL, 0x26413f36b146fff0ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Widget__query_selector_unique (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_selector;
  fbr >>= arg_selector;
  WidgetIface *rval = self->query_selector_unique (arg_selector);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x715164b16827bbd1ULL, 0xcebbbc9e7141d970ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Widget__test_dump (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->test_dump ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x75dec9a4cbbbb05dULL, 0xfb37a5dfc1f63ea7ULL);
  rb <<= rval;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__Container____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ContainerIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x9c4a47a4b32f090eULL, 0x8aa78fc1673af212ULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Container__create_child (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  ContainerIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_widget_identifier;
  fbr >>= arg_widget_identifier;
  StringSeq  arg_args;
  fbr >>= arg_args;
  WidgetIface *rval = self->create_child (arg_widget_identifier, arg_args);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xc81e0c8eda464c21ULL, 0xf8e1a41941ea388aULL);
  rb <<= rval;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__ButtonArea____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x7d902f094f7403e7ULL, 0x815021369aaa2481ULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__ButtonArea__on_click (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->on_click ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xbe7282d89a4d4db2ULL, 0xb502688e28a880f6ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__ButtonArea__on_click (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_on_click;
  fbr >>= arg_on_click;
  self->on_click (arg_on_click);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__ButtonArea__on_click2 (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->on_click2 ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x27fae01da2300e44ULL, 0x3751b59e63d8e18fULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__ButtonArea__on_click2 (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_on_click2;
  fbr >>= arg_on_click2;
  self->on_click2 (arg_on_click2);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__ButtonArea__on_click3 (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->on_click3 ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x647626f32ffb2149ULL, 0xc0dbd63ec713a0eeULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__ButtonArea__on_click3 (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ButtonAreaIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_on_click3;
  fbr >>= arg_on_click3;
  self->on_click3 (arg_on_click3);
  return NULL;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__Drawable____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  DrawableIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xee9c9cb8c4d1307cULL, 0xd09e7006446b4901ULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Drawable__draw_rect (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 3);
  DrawableIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_x;
  fbr >>= arg_x;
  int  arg_y;
  fbr >>= arg_y;
  Pixbuf  arg_pixbuf;
  fbr >>= arg_pixbuf;
  self->draw_rect (arg_x, arg_y, arg_pixbuf);
  return NULL;
}
class __AIDA_Closure__Drawable__redraw {
  size_t handler_id_;
public:
  typedef std::shared_ptr<__AIDA_Closure__Drawable__redraw> SharedPtr;
  __AIDA_Closure__Drawable__redraw (size_t h) : handler_id_ (h) {}
  ~__AIDA_Closure__Drawable__redraw()
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
    __AIDA_Local__::add_header1_discon (fb, handler_id_, 0xd532d8c1fad1e432ULL, 0xf03f2c52dfc54458ULL);
    fb <<= handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
  static void
  handler (const SharedPtr &sp,
           int arg_x,
           int arg_y,
           int arg_w,
           int arg_h)
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 4 + 0);
    __AIDA_Local__::add_header1_emit (fb, sp->handler_id_, 0xd532d8c1fad1e432ULL, 0xf03f2c52dfc54458ULL);
    fb <<= sp->handler_id_;
    fb <<= arg_x;
    fb <<= arg_y;
    fb <<= arg_w;
    fb <<= arg_h;
    __AIDA_Local__::post_msg (&fb);
  }
};
static Rapicorn::Aida::FieldBuffer*
__aida_connect__Drawable__redraw (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  DrawableIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  size_t handler_id;
  Rapicorn::Aida::uint64 signal_connection, result = 0;
  fbr >>= handler_id;
  fbr >>= signal_connection;
  if (signal_connection)
    result = self->sig_redraw() -= signal_connection;
  if (handler_id) {
    __AIDA_Closure__Drawable__redraw::SharedPtr sp (new __AIDA_Closure__Drawable__redraw (handler_id));
    result = self->sig_redraw() += __AIDA_Local__::slot (sp, sp->handler);
  }
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_connect_result (fbr, 0xd532d8c1fad1e432ULL, 0xf03f2c52dfc54458ULL);
  rb <<= result;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__WidgetList____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x3c0806880c00ee21ULL, 0xba294ea0987c7747ULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__WidgetList__model (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->model ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x4999e64ab90f03a7ULL, 0xd525a0168740dd66ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__WidgetList__model (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_model;
  fbr >>= arg_model;
  self->model (arg_model);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__WidgetList__selection_mode (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  SelectionMode  rval = self->selection_mode ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x5572708a0378ba2eULL, 0xfd88c7c5701a1722ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__WidgetList__selection_mode (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  SelectionMode  arg_selection_mode;
  fbr >>= arg_selection_mode;
  self->selection_mode (arg_selection_mode);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__WidgetList__set_selection (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  BoolSeq  arg_selection;
  fbr >>= arg_selection;
  self->set_selection (arg_selection);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__WidgetList__get_selection (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  BoolSeq  rval = self->get_selection ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x0eb72284726bafd2ULL, 0xc342e747310feaadULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__WidgetList__select_range (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_first;
  fbr >>= arg_first;
  int  arg_length;
  fbr >>= arg_length;
  self->select_range (arg_first, arg_length);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__WidgetList__unselect_range (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  WidgetListIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_first;
  fbr >>= arg_first;
  int  arg_length;
  fbr >>= arg_length;
  self->unselect_range (arg_first, arg_length);
  return NULL;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__Window____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x6b4ee5cb5ac8b0a5ULL, 0x25beb0b83c4fab4bULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Window__title (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->title ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x7385d837fddf4fc3ULL, 0x911665dbc59fd048ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Window__title (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_title;
  fbr >>= arg_title;
  self->title (arg_title);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__Window__auto_focus (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->auto_focus ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x918fdef4f4ee722bULL, 0xb5bf9280f27e1b14ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__Window__auto_focus (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_auto_focus;
  fbr >>= arg_auto_focus;
  self->auto_focus (arg_auto_focus);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__viewable (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->viewable ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xe0170f6a2d0c589aULL, 0xa3d2fa8184318ffcULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__show (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  self->show ();
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__closed (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->closed ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xeb10e015ba34c84dULL, 0x4f4b8541207e754dULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__close (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  self->close ();
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__snapshot (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_pngname;
  fbr >>= arg_pngname;
  bool  rval = self->snapshot (arg_pngname);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x7d9839fc1a8fc039ULL, 0x48afcf806e3f4ca8ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__synthesize_click (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 4);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  WidgetIface *arg_widget;
  fbr >>= arg_widget;
  int  arg_button;
  fbr >>= arg_button;
  double  arg_xalign;
  fbr >>= arg_xalign;
  double  arg_yalign;
  fbr >>= arg_yalign;
  bool  rval = self->synthesize_click (*arg_widget, arg_button, arg_xalign, arg_yalign);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x4f10f82b1f848a99ULL, 0x1a95300acb24ac2cULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__synthesize_enter (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_xalign;
  fbr >>= arg_xalign;
  double  arg_yalign;
  fbr >>= arg_yalign;
  bool  rval = self->synthesize_enter (arg_xalign, arg_yalign);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xf3e41fc141e2f661ULL, 0x8fcbc461d2bfec4dULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__synthesize_leave (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->synthesize_leave ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xa4318a90eb7b22a7ULL, 0xce24499e920f9204ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Window__synthesize_delete (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->synthesize_delete ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x73a213ef280c28abULL, 0x190baa31ddaee3a4ULL);
  rb <<= rval;
  return &rb;
}
class __AIDA_Closure__Window__commands {
  size_t handler_id_;
public:
  typedef std::shared_ptr<__AIDA_Closure__Window__commands> SharedPtr;
  __AIDA_Closure__Window__commands (size_t h) : handler_id_ (h) {}
  ~__AIDA_Closure__Window__commands()
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
    __AIDA_Local__::add_header1_discon (fb, handler_id_, 0x036b33fe77a44de3ULL, 0x1defbbcde7bdeb68ULL);
    fb <<= handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
  static std::future<bool>
  handler (const SharedPtr &sp,
           const std::string &arg_cmdname,
           const StringSeq &arg_args)
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 2 + 1);
    __AIDA_Local__::add_header2_emit (fb, sp->handler_id_, 0x036b33fe77a44de3ULL, 0x1defbbcde7bdeb68ULL);
    fb <<= sp->handler_id_;
    auto promise = std::make_shared<std::promise<bool>> ();
    auto future = promise->get_future();
    const size_t lambda_id = 1 + size_t (promise.get());
    auto lambda = [promise] (Rapicorn::Aida::FieldReader &frr) {
      bool  retval;
      frr >>= retval;
      promise->set_value (retval);
    };
    __AIDA_Local__::erhandler_add (lambda_id, lambda);
    fb <<= lambda_id;
    fb <<= arg_cmdname;
    fb <<= arg_args;
    __AIDA_Local__::post_msg (&fb);
    return future;
  }
};
static Rapicorn::Aida::FieldBuffer*
__aida_connect__Window__commands (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  size_t handler_id;
  Rapicorn::Aida::uint64 signal_connection, result = 0;
  fbr >>= handler_id;
  fbr >>= signal_connection;
  if (signal_connection)
    result = self->sig_commands() -= signal_connection;
  if (handler_id) {
    __AIDA_Closure__Window__commands::SharedPtr sp (new __AIDA_Closure__Window__commands (handler_id));
    result = self->sig_commands().connect_future (__AIDA_Local__::slot (sp, sp->handler));
  }
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_connect_result (fbr, 0x036b33fe77a44de3ULL, 0x1defbbcde7bdeb68ULL);
  rb <<= result;
  return &rb;
}
class __AIDA_Closure__Window__displayed {
  size_t handler_id_;
public:
  typedef std::shared_ptr<__AIDA_Closure__Window__displayed> SharedPtr;
  __AIDA_Closure__Window__displayed (size_t h) : handler_id_ (h) {}
  ~__AIDA_Closure__Window__displayed()
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
    __AIDA_Local__::add_header1_discon (fb, handler_id_, 0x365ae114cf8798c3ULL, 0x94974b0699c1d4afULL);
    fb <<= handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
  static void
  handler (const SharedPtr &sp)
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0 + 0);
    __AIDA_Local__::add_header1_emit (fb, sp->handler_id_, 0x365ae114cf8798c3ULL, 0x94974b0699c1d4afULL);
    fb <<= sp->handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
};
static Rapicorn::Aida::FieldBuffer*
__aida_connect__Window__displayed (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  WindowIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  size_t handler_id;
  Rapicorn::Aida::uint64 signal_connection, result = 0;
  fbr >>= handler_id;
  fbr >>= signal_connection;
  if (signal_connection)
    result = self->sig_displayed() -= signal_connection;
  if (handler_id) {
    __AIDA_Closure__Window__displayed::SharedPtr sp (new __AIDA_Closure__Window__displayed (handler_id));
    result = self->sig_displayed() += __AIDA_Local__::slot (sp, sp->handler);
  }
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_connect_result (fbr, 0x365ae114cf8798c3ULL, 0x94974b0699c1d4afULL);
  rb <<= result;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__Application____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x4caa06dd27701476ULL, 0x39a2f7b2a184e208ULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__auto_path (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 3);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_file_name;
  fbr >>= arg_file_name;
  std::string  arg_binary_path;
  fbr >>= arg_binary_path;
  bool  arg_search_vpath;
  fbr >>= arg_search_vpath;
  std::string  rval = self->auto_path (arg_file_name, arg_binary_path, arg_search_vpath);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x883ef87a829e0944ULL, 0x195491c8d0bf4e7eULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__auto_load (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 4);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_defs_domain;
  fbr >>= arg_defs_domain;
  std::string  arg_file_name;
  fbr >>= arg_file_name;
  std::string  arg_binary_path;
  fbr >>= arg_binary_path;
  std::string  arg_i18n_domain;
  fbr >>= arg_i18n_domain;
  StringSeq  rval = self->auto_load (arg_defs_domain, arg_file_name, arg_binary_path, arg_i18n_domain);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x1831a495b8387eb5ULL, 0x96aaaaedfb2c16faULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__factory_window (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_factory_definition;
  fbr >>= arg_factory_definition;
  bool  rval = self->factory_window (arg_factory_definition);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xc8ba1f022ffb00bfULL, 0x1e91863bdd87f4caULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__load_string (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 3);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_defs_domain;
  fbr >>= arg_defs_domain;
  std::string  arg_xml_string;
  fbr >>= arg_xml_string;
  std::string  arg_i18n_domain;
  fbr >>= arg_i18n_domain;
  self->load_string (arg_defs_domain, arg_xml_string, arg_i18n_domain);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__create_window (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_window_identifier;
  fbr >>= arg_window_identifier;
  StringSeq  arg_arguments;
  fbr >>= arg_arguments;
  WindowIface *rval = self->create_window (arg_window_identifier, arg_arguments);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xe46b57832b6c8e39ULL, 0xd41fd199a8c671c7ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__finishable (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->finishable ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xfc8cccc767334738ULL, 0xb40c63a6f7fecea2ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__close_all (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  self->close_all ();
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__query_window (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_selector;
  fbr >>= arg_selector;
  WindowIface *rval = self->query_window (arg_selector);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xc529acfc083f761dULL, 0x5a7fff7c86242aa1ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__query_windows (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_selector;
  fbr >>= arg_selector;
  WindowList  rval = self->query_windows (arg_selector);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xb8d47414e9b43b0dULL, 0x14fb61db88caa2abULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__list_windows (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  WindowList  rval = self->list_windows ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x5704e595ccb696c3ULL, 0x902917d3af754af9ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__create_list_model_relay (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_name;
  fbr >>= arg_name;
  ListModelRelayIface *rval = self->create_list_model_relay (arg_name);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xa9e92d7520533508ULL, 0x561da3801e9cffb3ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__test_counter_set (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_val;
  fbr >>= arg_val;
  self->test_counter_set (arg_val);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__test_counter_add (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_val;
  fbr >>= arg_val;
  self->test_counter_add (arg_val);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__test_counter_get (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->test_counter_get ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x767abbc55034366fULL, 0x0bc3b39445195e98ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__test_counter_inc_fetch (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->test_counter_inc_fetch ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x3d42918d44218250ULL, 0xbfaa70498ef80c6eULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_call__Application__test_hook (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 0);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::int64  rval = self->test_hook ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x278a60c0598177c9ULL, 0x5a503b69fd381e47ULL);
  rb <<= rval;
  return &rb;
}
class __AIDA_Closure__Application__missing_primary {
  size_t handler_id_;
public:
  typedef std::shared_ptr<__AIDA_Closure__Application__missing_primary> SharedPtr;
  __AIDA_Closure__Application__missing_primary (size_t h) : handler_id_ (h) {}
  ~__AIDA_Closure__Application__missing_primary()
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1);
    __AIDA_Local__::add_header1_discon (fb, handler_id_, 0x090deb4506e6fb55ULL, 0x78791c7dd48e0029ULL);
    fb <<= handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
  static void
  handler (const SharedPtr &sp)
  {
    Rapicorn::Aida::FieldBuffer &fb = *Rapicorn::Aida::FieldBuffer::_new (3 + 1 + 0 + 0);
    __AIDA_Local__::add_header1_emit (fb, sp->handler_id_, 0x090deb4506e6fb55ULL, 0x78791c7dd48e0029ULL);
    fb <<= sp->handler_id_;
    __AIDA_Local__::post_msg (&fb);
  }
};
static Rapicorn::Aida::FieldBuffer*
__aida_connect__Application__missing_primary (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 2);
  ApplicationIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  size_t handler_id;
  Rapicorn::Aida::uint64 signal_connection, result = 0;
  fbr >>= handler_id;
  fbr >>= signal_connection;
  if (signal_connection)
    result = self->sig_missing_primary() -= signal_connection;
  if (handler_id) {
    __AIDA_Closure__Application__missing_primary::SharedPtr sp (new __AIDA_Closure__Application__missing_primary (handler_id));
    result = self->sig_missing_primary() += __AIDA_Local__::slot (sp, sp->handler);
  }
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_connect_result (fbr, 0x090deb4506e6fb55ULL, 0x78791c7dd48e0029ULL);
  rb <<= result;
  return &rb;
}

static Rapicorn::Aida::FieldBuffer*
__aida_call__IdlTestWidget____aida_typelist__ (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Rapicorn::Aida::TypeHashList thl;
  self->__aida_typelist__ (thl);
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x417c418d764daf5cULL, 0x3add344ba015b4ecULL, 1 + 2 * thl.size());
  rb <<= Rapicorn::Aida::int64 (thl.size());
  for (size_t i = 0; i < thl.size(); i++)
    rb <<= thl[i];
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__bool_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  rval = self->bool_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x99948d69ebc2a1c7ULL, 0x1992a2b3a67b8eefULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__bool_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  bool  arg_bool_prop;
  fbr >>= arg_bool_prop;
  self->bool_prop (arg_bool_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__int_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  rval = self->int_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x40380baa71a4cee4ULL, 0xeea7f61a3a41412fULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__int_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  int  arg_int_prop;
  fbr >>= arg_int_prop;
  self->int_prop (arg_int_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__float_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  rval = self->float_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x69a313a068ce58d6ULL, 0x73e909580fbaa5e1ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__float_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  double  arg_float_prop;
  fbr >>= arg_float_prop;
  self->float_prop (arg_float_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__string_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  rval = self->string_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x339c39407627875eULL, 0x6d257fd8991d9804ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__string_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  std::string  arg_string_prop;
  fbr >>= arg_string_prop;
  self->string_prop (arg_string_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__enum_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  TestEnum  rval = self->enum_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0xfe0fd06847a75335ULL, 0xb5b012d4698a175dULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__enum_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  TestEnum  arg_enum_prop;
  fbr >>= arg_enum_prop;
  self->enum_prop (arg_enum_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__record_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Requisition  rval = self->record_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x1fe3a9975e8acac8ULL, 0x9cc5b5ca0a6faeacULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__record_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  Requisition  arg_record_prop;
  fbr >>= arg_record_prop;
  self->record_prop (arg_record_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__sequence_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  StringSeq  rval = self->sequence_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x27b9e3914e473bb1ULL, 0xfa4c3b85c49b3e4cULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__sequence_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  StringSeq  arg_sequence_prop;
  fbr >>= arg_sequence_prop;
  self->sequence_prop (arg_sequence_prop);
  return NULL;
}
static Rapicorn::Aida::FieldBuffer*
__aida_get__IdlTestWidget__self_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  IdlTestWidgetIface *rval = self->self_prop ();
  Rapicorn::Aida::FieldBuffer &rb = *__AIDA_Local__::new_call_result (fbr, 0x32a9f87045663ba1ULL, 0x04d55d5dcf8ad486ULL);
  rb <<= rval;
  return &rb;
}
static Rapicorn::Aida::FieldBuffer*
__aida_set__IdlTestWidget__self_prop (Rapicorn::Aida::FieldReader &fbr)
{
  AIDA_ASSERT (fbr.remaining() == 3 + 1 + 1);
  IdlTestWidgetIface *self;
  fbr.skip_header();
  fbr >>= self;
  AIDA_CHECK (self, "self must be non-NULL");
  IdlTestWidgetIface *arg_self_prop;
  fbr >>= arg_self_prop;
  self->self_prop (&*arg_self_prop);
  return NULL;
}

} // Rapicorn
static const __AIDA_Local__::MethodEntry _aida_stub_entries[] = {
  { 0x7d38659266bcc806ULL, 0x7150e9f047ddfeedULL, Rapicorn::__aida_call__ListModel____aida_typelist__, },
  { 0x9093828fc77e641aULL, 0x7e188ef4a3a95df1ULL, Rapicorn::__aida_call__ListModel__count, },
  { 0x0daa87bb937470ceULL, 0xac2cfd46e1de2fe3ULL, Rapicorn::__aida_call__ListModel__row, },
  { 0xed8b8e157d8e8b09ULL, 0x40f08ab74596907eULL, Rapicorn::__aida_connect__ListModel__updated, },
  { 0x6f68d0e884a2ebdbULL, 0xdd54f615e10593caULL, Rapicorn::__aida_call__ListModelRelay____aida_typelist__, },
  { 0x1e82ea1bf240ad5fULL, 0x2c8e4f655a3f3e8fULL, Rapicorn::__aida_call__ListModelRelay__model, },
  { 0x0bed2f670b7f4b6fULL, 0x46b9d94fd813c92dULL, Rapicorn::__aida_call__ListModelRelay__fill, },
  { 0x9690b77b0d6f60e8ULL, 0x096dab753c1eac81ULL, Rapicorn::__aida_call__ListModelRelay__update, },
  { 0xfc80c8eeadcb6268ULL, 0x14b0db287fc04b3dULL, Rapicorn::__aida_connect__ListModelRelay__refill, },
  { 0x1eb6c5178436ad26ULL, 0x9f4a4699676886d5ULL, Rapicorn::__aida_call__Widget____aida_typelist__, },
  { 0x031285308fcdf2a6ULL, 0xe4751a850e1e28fdULL, Rapicorn::__aida_get__Widget__name, },
  { 0x5026ef8ea4009c59ULL, 0xb565349b095e6e11ULL, Rapicorn::__aida_set__Widget__name, },
  { 0x84994bfcea433d65ULL, 0x11da4bfc5c624c8fULL, Rapicorn::__aida_get__Widget__width, },
  { 0x0cd03fe5fa594ec6ULL, 0x91842d18a1c6ebd6ULL, Rapicorn::__aida_set__Widget__width, },
  { 0x35f842828c2bfa77ULL, 0x1884ebea3e98dbbfULL, Rapicorn::__aida_get__Widget__height, },
  { 0x44727037ddf45655ULL, 0x944fff4d9b1cc0a5ULL, Rapicorn::__aida_set__Widget__height, },
  { 0xddc9455b83b5c9e3ULL, 0x673d77bbb37b6468ULL, Rapicorn::__aida_get__Widget__hexpand, },
  { 0x724a878f038650dcULL, 0x8e3a406bfebdc7d5ULL, Rapicorn::__aida_set__Widget__hexpand, },
  { 0xf0a4b0e20f0cd5fdULL, 0xdfabca8039302e55ULL, Rapicorn::__aida_get__Widget__vexpand, },
  { 0x333e8c0864c70ff0ULL, 0x83dd04bc7aac68beULL, Rapicorn::__aida_set__Widget__vexpand, },
  { 0x5ac252d6317e7d36ULL, 0x98a184e2844406e8ULL, Rapicorn::__aida_get__Widget__hspread, },
  { 0xe6dd3929668db66cULL, 0x9da336ba53f08a18ULL, Rapicorn::__aida_set__Widget__hspread, },
  { 0x391f095f19534988ULL, 0xf4867a2ebaa3c794ULL, Rapicorn::__aida_get__Widget__vspread, },
  { 0x508f008b21de58c9ULL, 0xcc23c5365cf017f6ULL, Rapicorn::__aida_set__Widget__vspread, },
  { 0x251603c131c31f86ULL, 0x5dff639bd6c70e19ULL, Rapicorn::__aida_get__Widget__hshrink, },
  { 0xc357c2e04f0cc762ULL, 0x2bd324458ce3b86bULL, Rapicorn::__aida_set__Widget__hshrink, },
  { 0x43c07cf21c154377ULL, 0x499474085275cd26ULL, Rapicorn::__aida_get__Widget__vshrink, },
  { 0x89ca7aa832131675ULL, 0x8084f9d24773b4cfULL, Rapicorn::__aida_set__Widget__vshrink, },
  { 0x70842a509744bcb9ULL, 0xc07e68d369809582ULL, Rapicorn::__aida_get__Widget__visible, },
  { 0xae2e9f4866d97f9eULL, 0x4683fac44e7200deULL, Rapicorn::__aida_set__Widget__visible, },
  { 0x480267748b1cbcccULL, 0xc09ac65197b64c3bULL, Rapicorn::__aida_get__Widget__sensitive, },
  { 0x8464c27dd920075aULL, 0xe21827b12655c61dULL, Rapicorn::__aida_set__Widget__sensitive, },
  { 0x26e5b794bb960060ULL, 0x8680536d636a3351ULL, Rapicorn::__aida_get__Widget__hposition, },
  { 0xddfa6b7010466243ULL, 0xd82688a5e9656bd1ULL, Rapicorn::__aida_set__Widget__hposition, },
  { 0x5eeb1641d7c3b52dULL, 0xb9dc0b7b3ea6e31aULL, Rapicorn::__aida_get__Widget__hspan, },
  { 0x91985befb9eea32dULL, 0x3ec215657b01a35cULL, Rapicorn::__aida_set__Widget__hspan, },
  { 0x74aeb757e09afcfdULL, 0x968359ce2c9c7849ULL, Rapicorn::__aida_get__Widget__vposition, },
  { 0xccab42e4e4499f3aULL, 0x301bc5a7a254f720ULL, Rapicorn::__aida_set__Widget__vposition, },
  { 0x2a12130db96b5ae9ULL, 0x00d0b705609fd4feULL, Rapicorn::__aida_get__Widget__vspan, },
  { 0xd64f52c7e4ffa97bULL, 0x95b7e3fb29643c1aULL, Rapicorn::__aida_set__Widget__vspan, },
  { 0x969c1084b85dd454ULL, 0xf16cdb02bbacbb3bULL, Rapicorn::__aida_get__Widget__left_spacing, },
  { 0x4f438c0e21c50f88ULL, 0x222e4001cce7a184ULL, Rapicorn::__aida_set__Widget__left_spacing, },
  { 0x4c38330e86f21375ULL, 0xa3c2608930578e4dULL, Rapicorn::__aida_get__Widget__right_spacing, },
  { 0xd715d734aed172deULL, 0x5a4a1e8fccef99b5ULL, Rapicorn::__aida_set__Widget__right_spacing, },
  { 0x1c7b00a54d4cab7eULL, 0xb2946b8d608eb312ULL, Rapicorn::__aida_get__Widget__bottom_spacing, },
  { 0x53a63624185de070ULL, 0xd6a284ee64e16a6eULL, Rapicorn::__aida_set__Widget__bottom_spacing, },
  { 0xe7c94f940a362078ULL, 0xbfc0002e602aab18ULL, Rapicorn::__aida_get__Widget__top_spacing, },
  { 0xc12ba3fcd5434db4ULL, 0x498fe76a23fe2f0cULL, Rapicorn::__aida_set__Widget__top_spacing, },
  { 0xbaedd681aec0abc2ULL, 0x5cbd3da8d0dff05cULL, Rapicorn::__aida_get__Widget__hanchor, },
  { 0x1f1291c258eb0675ULL, 0x83123a4f1a6fb70bULL, Rapicorn::__aida_set__Widget__hanchor, },
  { 0x4421c5e41bc6ac93ULL, 0x1feaa29a57b54407ULL, Rapicorn::__aida_get__Widget__vanchor, },
  { 0x19ba251d69d93619ULL, 0xb211d94cbd2b506dULL, Rapicorn::__aida_set__Widget__vanchor, },
  { 0x2b61614a4e727c24ULL, 0x49420277ff5bc98bULL, Rapicorn::__aida_get__Widget__halign, },
  { 0x59e6d2545ef9bd6eULL, 0xfc3cea9abfb4bb2dULL, Rapicorn::__aida_set__Widget__halign, },
  { 0x84016e98460561a1ULL, 0xdfe2267757460248ULL, Rapicorn::__aida_get__Widget__hscale, },
  { 0x06426644521ee976ULL, 0x91a45c0cb7fe67ccULL, Rapicorn::__aida_set__Widget__hscale, },
  { 0x311f02f1f9878086ULL, 0x3c26a48be3bb42d5ULL, Rapicorn::__aida_get__Widget__valign, },
  { 0xe2f20a1445d3a32bULL, 0xeb1ea30552ffe2b9ULL, Rapicorn::__aida_set__Widget__valign, },
  { 0x4673932466b5324fULL, 0x119e3992a3be264fULL, Rapicorn::__aida_get__Widget__vscale, },
  { 0x65ab326ea2d56bd4ULL, 0x3177534f494db9e5ULL, Rapicorn::__aida_set__Widget__vscale, },
  { 0x7670b7ba59b09d8fULL, 0xf67517302113137fULL, Rapicorn::__aida_get__Widget__color_scheme, },
  { 0x955c720e722e97ddULL, 0x605fd029288e16baULL, Rapicorn::__aida_set__Widget__color_scheme, },
  { 0x50ee99f8844291f4ULL, 0x3f72b3646a1a7bc7ULL, Rapicorn::__aida_call__Widget__match_selector, },
  { 0xb6980840cde71811ULL, 0xb14e1aa50e08cfd8ULL, Rapicorn::__aida_call__Widget__query_selector, },
  { 0x2a5a8ff0a59cad2eULL, 0x26413f36b146fff0ULL, Rapicorn::__aida_call__Widget__query_selector_all, },
  { 0x715164b16827bbd1ULL, 0xcebbbc9e7141d970ULL, Rapicorn::__aida_call__Widget__query_selector_unique, },
  { 0x75dec9a4cbbbb05dULL, 0xfb37a5dfc1f63ea7ULL, Rapicorn::__aida_call__Widget__test_dump, },
  { 0x9c4a47a4b32f090eULL, 0x8aa78fc1673af212ULL, Rapicorn::__aida_call__Container____aida_typelist__, },
  { 0xc81e0c8eda464c21ULL, 0xf8e1a41941ea388aULL, Rapicorn::__aida_call__Container__create_child, },
  { 0x7d902f094f7403e7ULL, 0x815021369aaa2481ULL, Rapicorn::__aida_call__ButtonArea____aida_typelist__, },
  { 0xbe7282d89a4d4db2ULL, 0xb502688e28a880f6ULL, Rapicorn::__aida_get__ButtonArea__on_click, },
  { 0x88e789a391ea37c1ULL, 0x0434df5f75f1e2bcULL, Rapicorn::__aida_set__ButtonArea__on_click, },
  { 0x27fae01da2300e44ULL, 0x3751b59e63d8e18fULL, Rapicorn::__aida_get__ButtonArea__on_click2, },
  { 0x2e918c010d23b831ULL, 0xc38a590f18096fa4ULL, Rapicorn::__aida_set__ButtonArea__on_click2, },
  { 0x647626f32ffb2149ULL, 0xc0dbd63ec713a0eeULL, Rapicorn::__aida_get__ButtonArea__on_click3, },
  { 0x9175e48a1888ca49ULL, 0xb545bdc3a3d046caULL, Rapicorn::__aida_set__ButtonArea__on_click3, },
  { 0xee9c9cb8c4d1307cULL, 0xd09e7006446b4901ULL, Rapicorn::__aida_call__Drawable____aida_typelist__, },
  { 0x427a0b8bb25f6a0bULL, 0xa6474d1708083aefULL, Rapicorn::__aida_call__Drawable__draw_rect, },
  { 0xd532d8c1fad1e432ULL, 0xf03f2c52dfc54458ULL, Rapicorn::__aida_connect__Drawable__redraw, },
  { 0x3c0806880c00ee21ULL, 0xba294ea0987c7747ULL, Rapicorn::__aida_call__WidgetList____aida_typelist__, },
  { 0x4999e64ab90f03a7ULL, 0xd525a0168740dd66ULL, Rapicorn::__aida_get__WidgetList__model, },
  { 0x39a6bb1dc5eff4f9ULL, 0x42c05f294d1b00f3ULL, Rapicorn::__aida_set__WidgetList__model, },
  { 0x5572708a0378ba2eULL, 0xfd88c7c5701a1722ULL, Rapicorn::__aida_get__WidgetList__selection_mode, },
  { 0x2f02df4c7a4eff82ULL, 0x72f84ea8f7e123c9ULL, Rapicorn::__aida_set__WidgetList__selection_mode, },
  { 0x932e82327a246153ULL, 0x53f25bb2a40e9493ULL, Rapicorn::__aida_call__WidgetList__set_selection, },
  { 0x0eb72284726bafd2ULL, 0xc342e747310feaadULL, Rapicorn::__aida_call__WidgetList__get_selection, },
  { 0x4a4be90ab0872e85ULL, 0xeeb47b4e4aad638eULL, Rapicorn::__aida_call__WidgetList__select_range, },
  { 0x5e82a812571a8217ULL, 0x098fb142226cddbdULL, Rapicorn::__aida_call__WidgetList__unselect_range, },
  { 0x6b4ee5cb5ac8b0a5ULL, 0x25beb0b83c4fab4bULL, Rapicorn::__aida_call__Window____aida_typelist__, },
  { 0x7385d837fddf4fc3ULL, 0x911665dbc59fd048ULL, Rapicorn::__aida_get__Window__title, },
  { 0x843eb5873003739bULL, 0x36826a9d2e9a0580ULL, Rapicorn::__aida_set__Window__title, },
  { 0x918fdef4f4ee722bULL, 0xb5bf9280f27e1b14ULL, Rapicorn::__aida_get__Window__auto_focus, },
  { 0xc57f5c7ac8896aa7ULL, 0xf59a1654889d2eacULL, Rapicorn::__aida_set__Window__auto_focus, },
  { 0xe0170f6a2d0c589aULL, 0xa3d2fa8184318ffcULL, Rapicorn::__aida_call__Window__viewable, },
  { 0xe1063b18ff934735ULL, 0xe5ee95b1c597896dULL, Rapicorn::__aida_call__Window__show, },
  { 0xeb10e015ba34c84dULL, 0x4f4b8541207e754dULL, Rapicorn::__aida_call__Window__closed, },
  { 0x2b8bf0726c952d0fULL, 0x1b49d505c740ba23ULL, Rapicorn::__aida_call__Window__close, },
  { 0x7d9839fc1a8fc039ULL, 0x48afcf806e3f4ca8ULL, Rapicorn::__aida_call__Window__snapshot, },
  { 0x4f10f82b1f848a99ULL, 0x1a95300acb24ac2cULL, Rapicorn::__aida_call__Window__synthesize_click, },
  { 0xf3e41fc141e2f661ULL, 0x8fcbc461d2bfec4dULL, Rapicorn::__aida_call__Window__synthesize_enter, },
  { 0xa4318a90eb7b22a7ULL, 0xce24499e920f9204ULL, Rapicorn::__aida_call__Window__synthesize_leave, },
  { 0x73a213ef280c28abULL, 0x190baa31ddaee3a4ULL, Rapicorn::__aida_call__Window__synthesize_delete, },
  { 0x036b33fe77a44de3ULL, 0x1defbbcde7bdeb68ULL, Rapicorn::__aida_connect__Window__commands, },
  { 0x365ae114cf8798c3ULL, 0x94974b0699c1d4afULL, Rapicorn::__aida_connect__Window__displayed, },
  { 0x4caa06dd27701476ULL, 0x39a2f7b2a184e208ULL, Rapicorn::__aida_call__Application____aida_typelist__, },
  { 0x883ef87a829e0944ULL, 0x195491c8d0bf4e7eULL, Rapicorn::__aida_call__Application__auto_path, },
  { 0x1831a495b8387eb5ULL, 0x96aaaaedfb2c16faULL, Rapicorn::__aida_call__Application__auto_load, },
  { 0xc8ba1f022ffb00bfULL, 0x1e91863bdd87f4caULL, Rapicorn::__aida_call__Application__factory_window, },
  { 0x53c7aaf3f9d757d1ULL, 0xf1baf1ac14b72027ULL, Rapicorn::__aida_call__Application__load_string, },
  { 0xe46b57832b6c8e39ULL, 0xd41fd199a8c671c7ULL, Rapicorn::__aida_call__Application__create_window, },
  { 0xfc8cccc767334738ULL, 0xb40c63a6f7fecea2ULL, Rapicorn::__aida_call__Application__finishable, },
  { 0xf1206e509f98f4b9ULL, 0x45cdee6fda852de5ULL, Rapicorn::__aida_call__Application__close_all, },
  { 0xc529acfc083f761dULL, 0x5a7fff7c86242aa1ULL, Rapicorn::__aida_call__Application__query_window, },
  { 0xb8d47414e9b43b0dULL, 0x14fb61db88caa2abULL, Rapicorn::__aida_call__Application__query_windows, },
  { 0x5704e595ccb696c3ULL, 0x902917d3af754af9ULL, Rapicorn::__aida_call__Application__list_windows, },
  { 0xa9e92d7520533508ULL, 0x561da3801e9cffb3ULL, Rapicorn::__aida_call__Application__create_list_model_relay, },
  { 0x26752905d7f09528ULL, 0x54a6f5a27c92ce19ULL, Rapicorn::__aida_call__Application__test_counter_set, },
  { 0x3316624539ea4447ULL, 0x11e9c67949d113ffULL, Rapicorn::__aida_call__Application__test_counter_add, },
  { 0x767abbc55034366fULL, 0x0bc3b39445195e98ULL, Rapicorn::__aida_call__Application__test_counter_get, },
  { 0x3d42918d44218250ULL, 0xbfaa70498ef80c6eULL, Rapicorn::__aida_call__Application__test_counter_inc_fetch, },
  { 0x278a60c0598177c9ULL, 0x5a503b69fd381e47ULL, Rapicorn::__aida_call__Application__test_hook, },
  { 0x090deb4506e6fb55ULL, 0x78791c7dd48e0029ULL, Rapicorn::__aida_connect__Application__missing_primary, },
  { 0x417c418d764daf5cULL, 0x3add344ba015b4ecULL, Rapicorn::__aida_call__IdlTestWidget____aida_typelist__, },
  { 0x99948d69ebc2a1c7ULL, 0x1992a2b3a67b8eefULL, Rapicorn::__aida_get__IdlTestWidget__bool_prop, },
  { 0x2d2d2b095c0cf7ffULL, 0x6362f30aafa731b4ULL, Rapicorn::__aida_set__IdlTestWidget__bool_prop, },
  { 0x40380baa71a4cee4ULL, 0xeea7f61a3a41412fULL, Rapicorn::__aida_get__IdlTestWidget__int_prop, },
  { 0x70567417a8035bd3ULL, 0xa531d42041c0bab8ULL, Rapicorn::__aida_set__IdlTestWidget__int_prop, },
  { 0x69a313a068ce58d6ULL, 0x73e909580fbaa5e1ULL, Rapicorn::__aida_get__IdlTestWidget__float_prop, },
  { 0x285d6b0165a2feafULL, 0x2cdc39a1797c38d7ULL, Rapicorn::__aida_set__IdlTestWidget__float_prop, },
  { 0x339c39407627875eULL, 0x6d257fd8991d9804ULL, Rapicorn::__aida_get__IdlTestWidget__string_prop, },
  { 0xa7c21f819acfe836ULL, 0xcd5dd7e8d63620d0ULL, Rapicorn::__aida_set__IdlTestWidget__string_prop, },
  { 0xfe0fd06847a75335ULL, 0xb5b012d4698a175dULL, Rapicorn::__aida_get__IdlTestWidget__enum_prop, },
  { 0x2621c4f924f8e7bcULL, 0xf49816311b6ba886ULL, Rapicorn::__aida_set__IdlTestWidget__enum_prop, },
  { 0x1fe3a9975e8acac8ULL, 0x9cc5b5ca0a6faeacULL, Rapicorn::__aida_get__IdlTestWidget__record_prop, },
  { 0x9e0276bbb2bc5241ULL, 0x3609a090062cf622ULL, Rapicorn::__aida_set__IdlTestWidget__record_prop, },
  { 0x27b9e3914e473bb1ULL, 0xfa4c3b85c49b3e4cULL, Rapicorn::__aida_get__IdlTestWidget__sequence_prop, },
  { 0x2cb8c5f7d175d477ULL, 0xbd63e685f3372e4cULL, Rapicorn::__aida_set__IdlTestWidget__sequence_prop, },
  { 0x32a9f87045663ba1ULL, 0x04d55d5dcf8ad486ULL, Rapicorn::__aida_get__IdlTestWidget__self_prop, },
  { 0x386aca93cbab61deULL, 0xb13176c3748e715cULL, Rapicorn::__aida_set__IdlTestWidget__self_prop, },
};
static __AIDA_Local__::MethodRegistry _aida_stub_registry (_aida_stub_entries);


