% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hooks.R
\name{Hooks}
\alias{Hooks}
\title{Hooks class}
\description{
Helps define new hooks, hold hooks, and accessors to get and
use hooks.
}
\details{
\strong{Private Methods}
\describe{
\item{\code{make_hook(x, plac, fun)}}{
Make a hook.
- x (character) Hook name
- plac Placement, one of "start" or "end"
- fun a function/callback
}
}
}
\examples{
\dontrun{
(x <- Hooks$new())
x$hooks
x$define_hook(hook_type = "foo", fun = function(x) x ^ 2)
x$hooks$foo(4)
x$clear_hooks()
x$hooks
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hooks}}{intenal use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-invoke_hook}{\code{Hooks$invoke_hook()}}
\item \href{#method-clear_hooks}{\code{Hooks$clear_hooks()}}
\item \href{#method-define_hook}{\code{Hooks$define_hook()}}
\item \href{#method-clone}{\code{Hooks$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invoke_hook"></a>}}
\subsection{Method \code{invoke_hook()}}{
invoke a hook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hooks$invoke_hook(hook_type, args)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hook_type}}{(character) Hook name}

\item{\code{args}}{(named list) Args passed when invoking a hook}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
executes hook
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_hooks"></a>}}
\subsection{Method \code{clear_hooks()}}{
clear all hooks
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hooks$clear_hooks()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
no return
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-define_hook"></a>}}
\subsection{Method \code{define_hook()}}{
define a hook
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hooks$define_hook(hook_type, fun, prepend = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hook_type}}{(character) Hook name}

\item{\code{fun}}{A function}

\item{\code{prepend}}{(logical) Whether to prepend or add to the end
of the string. Default: \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
no return; defines hook internally
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hooks$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
