% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_effect_regression.R,
%   R/single_effect_regression_rss.R, R/single_effect_regression_ss.R
\name{single_effect_regression}
\alias{single_effect_regression}
\alias{single_effect_regression_rss}
\alias{single_effect_regression_ss}
\title{Bayesian single-effect linear regression}
\usage{
single_effect_regression(
  y,
  X,
  V,
  residual_variance = 1,
  prior_weights = NULL,
  optimize_V = c("none", "optim", "uniroot", "EM", "simple"),
  check_null_threshold = 0
)

single_effect_regression_rss(
  z,
  Sigma,
  V = 1,
  prior_weights = NULL,
  optimize_V = c("none", "optim", "uniroot", "EM", "simple"),
  check_null_threshold = 0
)

single_effect_regression_ss(
  Xty,
  dXtX,
  V = 1,
  residual_variance = 1,
  prior_weights = NULL,
  optimize_V = c("none", "optim", "uniroot", "EM", "simple"),
  check_null_threshold = 0
)
}
\arguments{
\item{y}{An n-vector.}

\item{X}{An n by p matrix of covariates.}

\item{V}{A scalar giving the (initial) prior variance}

\item{residual_variance}{The residual variance.}

\item{prior_weights}{A p-vector of prior weights.}

\item{optimize_V}{The optimization method to use for fitting the
prior variance.}

\item{check_null_threshold}{Scalar specifying threshold on the
log-scale to compare likelihood between current estimate and zero
the null.}

\item{z}{A p-vector of z scores.}

\item{Sigma}{\code{residual_var*R + lambda*I}}

\item{Xty}{A p-vector.}

\item{dXtX}{A p-vector containing the diagonal elements of
\code{crossprod(X)}.}
}
\value{
A list with the following elements:

\item{alpha}{Vector of posterior inclusion probabilities;
  \code{alpha[i]} is posterior probability that the ith coefficient
  is non-zero.}

\item{mu}{Vector of posterior means (conditional on inclusion).}

\item{mu2}{Vector of posterior second moments (conditional on
  inclusion).}

\item{lbf}{Vector of log-Bayes factors for each variable.}

\item{lbf_model}{Log-Bayes factor for the single effect regression.}

\code{single_effect_regression} and \code{single_effect_regression_ss}
additionally output:

\item{V}{Prior variance (after optimization if \code{optimize_V !=
  "none"}).}

\item{loglik}{The log-likelihood, \eqn{\log p(y | X, V)}.}
}
\description{
These methods fit the regression model \eqn{y = Xb +
  e}, where elements of e are \emph{i.i.d.}  \eqn{N(0,s^2)}, and b is
  a p-vector of effects to be estimated. The assumption is that b has
  exactly one non-zero element, with all elements equally likely to
  be non-zero. The prior on the coefficient of the non-zero element
  is \eqn{N(0,V)}.
}
\details{
\code{single_effect_regression_ss} performs single-effect
linear regression with summary data, in which only the statistcs
\eqn{X^Ty} and diagonal elements of \eqn{X^TX} are provided to the
method.

\code{single_effect_regression_rss} performs single-effect linear
regression with z scores. That is, this function fits the
regression model \eqn{z = R*b + e}, where e is \eqn{N(0,Sigma)},
\eqn{Sigma = residual_var*R + lambda*I}, and the b is a p-vector of
effects to be estimated. The assumption is that b has exactly one
non-zero element, with all elements equally likely to be non-zero.
The prior on the non-zero element is \eqn{N(0,V)}. The required
summary data are the p-vector \code{z} and the p by p matrix
\code{Sigma}. The summary statistics should come from the same
individuals.
}
\keyword{internal}
