% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{st_precision}
\alias{st_precision}
\alias{st_set_precision}
\alias{st_precision<-}
\title{Get precision}
\usage{
st_precision(x)

st_set_precision(x, precision)

st_precision(x) <- value
}
\arguments{
\item{x}{object of class \code{sfc} or \code{sf}}

\item{precision}{numeric, or object of class \code{units} with distance units (but see details); see \link{st_as_binary} for how to do this.}

\item{value}{precision value}
}
\description{
Get precision

Set precision
}
\details{
If \code{precision} is a \code{units} object, the object on which we set precision must have a coordinate reference system with compatible distance units.

Setting a \code{precision} has no direct effect on coordinates of geometries, but merely set an attribute tag to an \code{sfc} object.
The effect takes place in \link{st_as_binary} or, more precise, in the C++ function \code{CPL_write_wkb}, where simple feature geometries are being serialized to well-known-binary (WKB).
This happens always when routines are called in GEOS library (geometrical operations or predicates), for writing geometries using \link{st_write} or \link{write_sf}, \code{st_make_valid} in package \code{lwgeom}; also \link{aggregate} and \link{summarise} by default union geometries, which calls a GEOS library function.
Routines in these libraries receive rounded coordinates, and possibly return results based on them. \link{st_as_binary} contains an example of a roundtrip of \code{sfc} geometries through WKB, in order to see the rounding happening to R data.

The reason to support precision is that geometrical operations in GEOS or liblwgeom may work better at reduced precision. For writing data from R to external resources it is harder to think of a good reason to limiting precision.
}
\examples{
x <- st_sfc(st_point(c(pi, pi)))
st_precision(x)
st_precision(x) <- 0.01
st_precision(x)
}
\seealso{
\link{st_as_binary} for an explanation of what setting precision does, and the examples therein.
}
