% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optims.R
\name{NR}
\alias{NR}
\title{Newton-Raphson method}
\usage{
NR(
  start,
  objective = NULL,
  gradient = NULL,
  hessian = NULL,
  control,
  args = NULL,
  ...
)
}
\arguments{
\item{start}{Starting value}

\item{objective}{Optional objective function (used for selecting step length)}

\item{gradient}{gradient}

\item{hessian}{hessian (if NULL a numerical derivative is used)}

\item{control}{optimization arguments (see details)}

\item{args}{Optional list of arguments parsed to objective, gradient and hessian}

\item{...}{additional arguments parsed to lower level functions}
}
\description{
Newton-Raphson method
}
\details{
\code{control} should be a list with one or more of the following components:
\itemize{
\item{trace} integer for which output is printed each 'trace'th iteration
\item{iter.max} number of iterations
\item{stepsize}: Step size (default 1)
\item{nstepsize}: Increase stepsize every nstepsize iteration (from stepsize to 1)
\item{tol}: Convergence criterion (gradient)
\item{epsilon}: threshold used in pseudo-inverse
\item{backtrack}: In each iteration reduce stepsize unless solution is improved according to criterion (gradient, armijo, curvature, wolfe)
}
}
\examples{
# Objective function with gradient and hessian as attributes
f <- function(z) {
   x <- z[1]; y <- z[2]
   val <- x^2 + x*y^2 + x + y
   structure(val, gradient=c(2*x+y^2+1, 2*y*x+1),
             hessian=rbind(c(2,2*y),c(2*y,2*x)))
}
NR(c(0,0),f)

# Parsing arguments to the function and
g <- function(x,y) (x*y+1)^2
NR(0, gradient=g, args=list(y=2), control=list(trace=1,tol=1e-20))


}
