% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvisWordTree.R
\name{gvisWordTree}
\alias{gvisWordTree}
\title{Google Word Tree with R
\Sexpr{googleChartName <- "wordtree"}
\Sexpr{gvisChartName <- "gvisWordTree"}}
\usage{
gvisWordTree(data, textvar = "", sizevar = "", stylevar = "",
  idvar = "", parentvar = "", options = list(),
  method = "implicit", chartid)
}
\arguments{
\item{data}{\code{data.frame} that contains the data to be visualised}

\item{textvar}{a string that refers to the column name in \code{data} that
contains the text to be used.}

\item{sizevar}{a string that refers to the column name in \code{data} that
contains the size of the words in the word tree.}

\item{stylevar}{a string that refers to the column name in \code{data} that
contains the stlye of the text. 
For no warning message in plot, should be called \code{<textvar>.style}.}

\item{idvar}{(only when format is explicit) a string that refers to the 
column name in \code{data} that contains the unique ID of the text.}

\item{parentvar}{(only when format is explicit) a string that refers to the 
column name in \code{data} that contains the ID of the parent of the text.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName,
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOptions.txt")))}}

\item{method}{a string to say whether the word tree is either:
\itemize{
\item{\code{implicit}}{ - will weight and connect automatically, or} 
\item{\code{explicit}}{ - can specify weights and connections}
}}

\item{chartid}{character. If missing (default) a random chart id will be 
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list 
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst", 
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
A word tree depicts multiple parallel sequences of words. It could be used to 
show which words most often follow or precede a target word 
(e.g., "Cats are...") or to show a hierarchy of terms (e.g., a decision tree).
}
\section{Warning}{

The word tree chart may be undergoing substantial revisions in 
future Google Charts releases.
}

\examples{
## Please note that by default the googleVis plot command
## will open a browser window and requires Internet
## connection to display the visualisation.

wt1 <- gvisWordTree(Cats, textvar = "Phrase")
plot(wt1)

Cats2 <- Cats
Cats2$Phrase.style <- ifelse(Cats$Sentiment >= 7, "green", 
                             ifelse(Cats$Sentiment <= 3, "red", "black"))
                             
wt2 <- gvisWordTree(Cats2, textvar = "Phrase", stylevar = "Phrase.style",
                    options = list(fontName = "Times-Roman",
                                   wordtree = "{word: 'cats'}",
                                   backgroundColor = "#cba"))
plot(wt2)

# Explicit word tree
exp.data <- data.frame(id = as.numeric(0:9),
                       label = letters[1:10],
                       parent = c(-1, 0, 0, 0, 2, 2, 4, 6, 1, 7),
                       size = c(10, 5, 3, 2, 2, 2, 1, 1, 5, 1),
                       stringsAsFactors = FALSE)

wt3 <- gvisWordTree(exp.data, idvar = "id", textvar = "label", 
                    parentvar = "parent", sizevar = "size",
                    options = list(wordtree = "{format: 'explicit'}"),
                    method = "explicit")
plot(wt3)

}
\references{
Google Chart Tools API: 
\Sexpr[results=rd]{gsub("CHARTNAME", 
googleChartName, 
readLines(file.path(".", "inst",  "mansections", 
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\author{
Ashley Baldry
}
\keyword{iplot}
