#! /bin/bash

# update branches
git checkout experimental
git pull -v

git checkout INSTALL

VERSION=`grep <configure.ac "AC_INIT" | perl -p -e "s/.*AC_INIT\(//" | awk -F ',' '{print $2}'`
DATE=`date +"%Y%m%d%H%M%S"`
RELEASE=${VERSION}-release-${DATE}

echo "VERSION $VERSION"
echo "DATE $DATE"
echo "RELEASE $RELEASE"

git checkout master
git pull -v

# merge
git checkout master
git merge -m "Merge experimental branch into master branch" experimental
git push -v

# add release tag/branch
git checkout master

# check out temp branch
git checkout -b ${RELEASE}-branch master
autoreconf -i -f
ADDFILES="INSTALL Makefile.in aclocal.m4 autom4te.cache compile config.guess config.h.in config.sub configure depcomp install-sh ltmain.sh m4/libtool.m4 m4/ltoptions.m4 m4/ltsugar.m4 m4/ltversion.m4 m4/lt~obsolete.m4 missing src/Makefile.in test/Makefile.in"
mv .gitignore .gitignore_
git add ${ADDFILES}
git commit -m "Release ${RELEASE}"
mv .gitignore_ .gitignore
git tag ${RELEASE}
git push -v origin ${RELEASE}

# back to master branch
git checkout master

# remove temp branch
git branch -D ${RELEASE}-branch

# back to experimental branch
git checkout experimental

