/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.fir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/fir/multiModule")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class FirMultiModuleResolveTestGenerated extends AbstractFirMultiModuleResolveTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInMultiModule() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/fir/multiModule"), Pattern.compile("^([^\\.]+)$"), TargetBackend.ANY, false);
    }

    @TestMetadata("basic")
    public void testBasic() throws Exception {
        runTest("idea/testData/fir/multiModule/basic/");
    }

    @TestMetadata("basicWithJava")
    public void testBasicWithJava() throws Exception {
        runTest("idea/testData/fir/multiModule/basicWithJava/");
    }

    @TestMetadata("basicWithJavaFakeOverride")
    public void testBasicWithJavaFakeOverride() throws Exception {
        runTest("idea/testData/fir/multiModule/basicWithJavaFakeOverride/");
    }

    @TestMetadata("mppFakeOverrides")
    public void testMppFakeOverrides() throws Exception {
        runTest("idea/testData/fir/multiModule/mppFakeOverrides/");
    }

    @TestMetadata("mppMemberType")
    public void testMppMemberType() throws Exception {
        runTest("idea/testData/fir/multiModule/mppMemberType/");
    }

    @TestMetadata("mppMembers")
    public void testMppMembers() throws Exception {
        runTest("idea/testData/fir/multiModule/mppMembers/");
    }

    @TestMetadata("mppSuperTypes")
    public void testMppSuperTypes() throws Exception {
        runTest("idea/testData/fir/multiModule/mppSuperTypes/");
    }

    @TestMetadata("overrideWithJava")
    public void testOverrideWithJava() throws Exception {
        runTest("idea/testData/fir/multiModule/overrideWithJava/");
    }
}
