---
id: 'Card view'
section: patterns
---## Examples

### Card view

```html isFullscreen
<div class="pf-v6-c-page" id="card-view-basic-example">
  <div class="pf-v6-c-skip-to-content">
    <a
      class="pf-v6-c-button pf-m-primary"
      href="#main-content-card-view-basic-example"
    >
      <span class="pf-v6-c-button__text">Skip to content</span>
    </a>
  </div>
  <header class="pf-v6-c-masthead" id="card-view-basic-example-masthead">
    <div class="pf-v6-c-masthead__main">
      <span class="pf-v6-c-masthead__toggle">
        <button
          class="pf-v6-c-button pf-m-hamburger pf-m-plain"
          type="button"
          aria-label="Global navigation"
        >
          <span class="pf-v6-c-button__icon">
            <svg
              viewBox="0 0 10 10"
              class="pf-v6-c-button--hamburger-icon pf-v6-svg"
              width="1em"
              height="1em"
            >
              <path class="pf-v6-c-button--hamburger-icon--top" d="M1,1 L9,1" />
              <path
                class="pf-v6-c-button--hamburger-icon--middle"
                d="M1,5 L9,5"
              />
              <path
                class="pf-v6-c-button--hamburger-icon--arrow"
                d="M1,5 L1,5 L1,5"
              />
              <path
                class="pf-v6-c-button--hamburger-icon--bottom"
                d="M9,9 L1,9"
              />
            </svg>
          </span>
        </button>
      </span>
      <div class="pf-v6-c-masthead__brand">
        <a class="pf-v6-c-masthead__logo" href="#">
          <svg height="37px" viewBox="0 0 679 158">
            <title>PF-HorizontalLogo-Color</title>
            <defs>
              <linearGradient
                x1="68%"
                y1="2.25860997e-13%"
                x2="32%"
                y2="100%"
                id="linearGradient-card-view-basic-example-masthead"
              >
                <stop stop-color="#2B9AF3" offset="0%" />
                <stop
                  stop-color="#73BCF7"
                  stop-opacity="0.502212631"
                  offset="100%"
                />
              </linearGradient>
            </defs>
            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
              <g
                transform="translate(206.000000, 45.750000)"
                fill="var(--pf-t--global--text--color--regular)"
                fill-rule="nonzero"
              >
                <path
                  d="M0,65.25 L0,2.25 L33.21,2.25 C37.35,2.25 41.025,3.135 44.235,4.905 C47.445,6.675 49.98,9.09 51.84,12.15 C53.7,15.21 54.63,18.72 54.63,22.68 C54.63,26.46 53.7,29.865 51.84,32.895 C49.98,35.925 47.43,38.31 44.19,40.05 C40.95,41.79 37.29,42.66 33.21,42.66 L15.48,42.66 L15.48,65.25 L0,65.25 Z M15.48,29.88 L31.41,29.88 C33.69,29.88 35.52,29.22 36.9,27.9 C38.28,26.58 38.97,24.87 38.97,22.77 C38.97,20.61 38.28,18.855 36.9,17.505 C35.52,16.155 33.69,15.48 31.41,15.48 L15.48,15.48 L15.48,29.88 Z"
                />
                <path
                  d="M77.04,66.06 C73.68,66.06 70.695,65.43 68.085,64.17 C65.475,62.91 63.435,61.17 61.965,58.95 C60.495,56.73 59.76,54.18 59.76,51.3 C59.76,46.74 61.485,43.215 64.935,40.725 C68.385,38.235 73.2,36.99 79.38,36.99 C83.1,36.99 86.7,37.44 90.18,38.34 L90.18,36 C90.18,31.26 87.15,28.89 81.09,28.89 C77.49,28.89 72.69,30.15 66.69,32.67 L61.47,21.96 C69.15,18.48 76.56,16.74 83.7,16.74 C90.3,16.74 95.43,18.315 99.09,21.465 C102.75,24.615 104.58,29.04 104.58,34.74 L104.58,65.25 L90.18,65.25 L90.18,62.37 C88.26,63.69 86.235,64.635 84.105,65.205 C81.975,65.775 79.62,66.06 77.04,66.06 Z M73.62,51.03 C73.62,52.53 74.28,53.7 75.6,54.54 C76.92,55.38 78.75,55.8 81.09,55.8 C84.69,55.8 87.72,55.05 90.18,53.55 L90.18,47.43 C87.42,46.71 84.54,46.35 81.54,46.35 C79.02,46.35 77.07,46.755 75.69,47.565 C74.31,48.375 73.62,49.53 73.62,51.03 Z"
                />
                <path
                  d="M137.25,65.88 C125.73,65.88 119.97,60.84 119.97,50.76 L119.97,29.79 L110.34,29.79 L110.34,17.64 L119.97,17.64 L119.97,5.4 L134.55,2.25 L134.55,17.64 L147.87,17.64 L147.87,29.79 L134.55,29.79 L134.55,47.88 C134.55,49.98 135.015,51.465 135.945,52.335 C136.875,53.205 138.51,53.64 140.85,53.64 C143.01,53.64 145.2,53.31 147.42,52.65 L147.42,64.44 C146.1,64.86 144.42,65.205 142.38,65.475 C140.34,65.745 138.63,65.88 137.25,65.88 Z"
                />
                <path
                  d="M177.57,65.88 C166.05,65.88 160.29,60.84 160.29,50.76 L160.29,29.79 L150.66,29.79 L150.66,17.64 L160.29,17.64 L160.29,5.4 L174.87,2.25 L174.87,17.64 L188.19,17.64 L188.19,29.79 L174.87,29.79 L174.87,47.88 C174.87,49.98 175.335,51.465 176.265,52.335 C177.195,53.205 178.83,53.64 181.17,53.64 C183.33,53.64 185.52,53.31 187.74,52.65 L187.74,64.44 C186.42,64.86 184.74,65.205 182.7,65.475 C180.66,65.745 178.95,65.88 177.57,65.88 Z"
                />
                <path
                  d="M217.62,66.15 C212.76,66.15 208.365,65.055 204.435,62.865 C200.505,60.675 197.4,57.72 195.12,54 C192.84,50.28 191.7,46.11 191.7,41.49 C191.7,36.87 192.795,32.7 194.985,28.98 C197.175,25.26 200.16,22.305 203.94,20.115 C207.72,17.925 211.92,16.83 216.54,16.83 C221.22,16.83 225.36,17.955 228.96,20.205 C232.56,22.455 235.395,25.53 237.465,29.43 C239.535,33.33 240.57,37.8 240.57,42.84 L240.57,46.44 L206.64,46.44 C207.6,48.66 209.1,50.475 211.14,51.885 C213.18,53.295 215.58,54 218.34,54 C222.42,54 225.6,52.8 227.88,50.4 L237.51,58.95 C234.51,61.47 231.435,63.3 228.285,64.44 C225.135,65.58 221.58,66.15 217.62,66.15 Z M206.37,36.27 L226.26,36.27 C225.48,33.99 224.205,32.16 222.435,30.78 C220.665,29.4 218.61,28.71 216.27,28.71 C213.87,28.71 211.8,29.37 210.06,30.69 C208.32,32.01 207.09,33.87 206.37,36.27 Z"
                />
                <path
                  d="M247.41,65.25 L247.41,17.64 L261.99,17.64 L261.99,22.41 C265.23,18.51 269.4,16.56 274.5,16.56 C277.08,16.62 278.91,17.01 279.99,17.73 L279.99,30.42 C277.95,29.46 275.64,28.98 273.06,28.98 C270.78,28.98 268.665,29.505 266.715,30.555 C264.765,31.605 263.19,33.09 261.99,35.01 L261.99,65.25 L247.41,65.25 Z"
                />
                <path
                  d="M286.29,65.25 L286.29,17.64 L300.87,17.64 L300.87,20.88 C304.47,18.12 308.73,16.74 313.65,16.74 C317.37,16.74 320.655,17.55 323.505,19.17 C326.355,20.79 328.59,23.04 330.21,25.92 C331.83,28.8 332.64,32.13 332.64,35.91 L332.64,65.25 L318.06,65.25 L318.06,37.89 C318.06,35.25 317.28,33.15 315.72,31.59 C314.16,30.03 312.06,29.25 309.42,29.25 C305.76,29.25 302.91,30.51 300.87,33.03 L300.87,65.25 L286.29,65.25 Z"
                />
                <polygon
                  points="342 65.25 342 2.25 392.04 2.25 392.04 15.66 357.48 15.66 357.48 27.45 380.52 27.45 380.52 40.41 357.48 40.41 357.48 65.25"
                />
                <polygon
                  points="399.96 65.25 399.96 2.25 414.54 0 414.54 65.25"
                />
                <path
                  d="M429.21,84.69 C428.07,84.69 426.96,84.645 425.88,84.555 C424.8,84.465 423.9,84.33 423.18,84.15 L423.18,71.73 C424.38,71.97 425.88,72.09 427.68,72.09 C432.36,72.09 435.51,70.05 437.13,65.97 L437.13,65.88 L418.86,17.64 L434.97,17.64 L445.5,47.61 L457.74,17.64 L473.49,17.64 L452.16,67.68 C450.42,71.82 448.5,75.135 446.4,77.625 C444.3,80.115 441.87,81.915 439.11,83.025 C436.35,84.135 433.05,84.69 429.21,84.69 Z"
                />
              </g>
              <g transform="translate(0.000000, 0.000000)">
                <path
                  d="M61.826087,0 L158,0 L158,96.173913 L147.695652,96.173913 C100.271201,96.173913 61.826087,57.7287992 61.826087,10.3043478 L61.826087,0 L61.826087,0 Z"
                  fill="#0066CC"
                />
                <path
                  d="M158,3.43478261 L65.2608696,158 L138,158 C149.045695,158 158,149.045695 158,138 L158,3.43478261 L158,3.43478261 Z"
                  fill="url(#linearGradient-card-view-basic-example-masthead)"
                />
                <path
                  d="M123.652174,-30.9130435 L30.9130435,123.652174 L103.652174,123.652174 C114.697869,123.652174 123.652174,114.697869 123.652174,103.652174 L123.652174,-30.9130435 L123.652174,-30.9130435 Z"
                  fill="url(#linearGradient-card-view-basic-example-masthead)"
                  transform="translate(77.282609, 46.369565) scale(1, -1) rotate(90.000000) translate(-77.282609, -46.369565) "
                />
              </g>
            </g>
          </svg>
        </a>
      </div>
    </div>
    <div class="pf-v6-c-masthead__content">
      <div
        class="pf-v6-c-toolbar pf-m-static"
        id="card-view-basic-example-masthead-toolbar"
      >
        <div class="pf-v6-c-toolbar__content">
          <div class="pf-v6-c-toolbar__content-section">
            <div
              class="pf-v6-c-toolbar__group pf-m-align-end pf-m-spacer-none pf-m-spacer-md-on-md pf-m-action-group-plain"
            >
              <div
                class="pf-v6-c-toolbar__group pf-m-hidden pf-m-visible-on-lg pf-m-action-group-plain"
              >
                <div class="pf-v6-c-toolbar__item">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Application launcher"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-th" aria-hidden="true"></i>
                    </span>
                  </button>
                </div>
                <div class="pf-v6-c-toolbar__item">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-settings pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Settings"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-cog" aria-hidden="true"></i>
                    </span>
                  </button>
                </div>
                <div class="pf-v6-c-toolbar__item">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Help"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-question-circle" aria-hidden="true"></i>
                    </span>
                  </button>
                </div>
              </div>

              <div class="pf-v6-c-toolbar__item pf-m-hidden-on-lg">
                <button
                  class="pf-v6-c-menu-toggle pf-m-plain"
                  type="button"
                  aria-expanded="false"
                  aria-label="Actions"
                >
                  <span class="pf-v6-c-menu-toggle__icon">
                    <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                  </span>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </header>
  <div class="pf-v6-c-page__sidebar">
    <div class="pf-v6-c-page__sidebar-body">
      <nav
        class="pf-v6-c-nav"
        id="card-view-basic-example-expandable-nav"
        aria-label="Global"
      >
        <ul class="pf-v6-c-nav__list" role="list">
          <li class="pf-v6-c-nav__item pf-m-expanded">
            <button
              class="pf-v6-c-nav__link"
              aria-expanded="true"
              id="card-view-basic-example-expandable-nav-link1"
            >
              <span class="pf-v6-c-nav__link-text">System panel</span>
              <span class="pf-v6-c-nav__toggle">
                <span class="pf-v6-c-nav__toggle-icon">
                  <i class="fas fa-angle-right" aria-hidden="true"></i>
                </span>
              </span>
            </button>
            <section
              class="pf-v6-c-nav__subnav"
              aria-labelledby="card-view-basic-example-expandable-nav-link1"
            >
              <ul class="pf-v6-c-nav__list" role="list">
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Overview</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a
                    href="#"
                    class="pf-v6-c-nav__link pf-m-current"
                    aria-current="page"
                  >
                    <span class="pf-v6-c-nav__link-text">Resource usage</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Hypervisors</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Instances</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Volumes</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Networks</span>
                  </a>
                </li>
              </ul>
            </section>
          </li>
          <li class="pf-v6-c-nav__item">
            <button
              class="pf-v6-c-nav__link"
              aria-expanded="false"
              id="card-view-basic-example-expandable-nav-link2"
            >
              <span class="pf-v6-c-nav__link-text">Policy</span>
              <span class="pf-v6-c-nav__toggle">
                <span class="pf-v6-c-nav__toggle-icon">
                  <i class="fas fa-angle-right" aria-hidden="true"></i>
                </span>
              </span>
            </button>
            <section
              class="pf-v6-c-nav__subnav"
              aria-labelledby="card-view-basic-example-expandable-nav-link2"
              hidden
              inert
            >
              <ul class="pf-v6-c-nav__list" role="list">
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Subnav link 1</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Subnav link 2</span>
                  </a>
                </li>
              </ul>
            </section>
          </li>
          <li class="pf-v6-c-nav__item">
            <button
              class="pf-v6-c-nav__link"
              aria-expanded="false"
              id="card-view-basic-example-expandable-nav-link3"
            >
              <span class="pf-v6-c-nav__link-text">Authentication</span>
              <span class="pf-v6-c-nav__toggle">
                <span class="pf-v6-c-nav__toggle-icon">
                  <i class="fas fa-angle-right" aria-hidden="true"></i>
                </span>
              </span>
            </button>
            <section
              class="pf-v6-c-nav__subnav"
              aria-labelledby="card-view-basic-example-expandable-nav-link3"
              hidden
              inert
            >
              <ul class="pf-v6-c-nav__list" role="list">
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Subnav link 1</span>
                  </a>
                </li>
                <li class="pf-v6-c-nav__item">
                  <a href="#" class="pf-v6-c-nav__link">
                    <span class="pf-v6-c-nav__link-text">Subnav link 2</span>
                  </a>
                </li>
              </ul>
            </section>
          </li>
        </ul>
      </nav>
    </div>
  </div>
  <div class="pf-v6-c-page__main-container" tabindex="-1">
    <main
      class="pf-v6-c-page__main"
      tabindex="-1"
      id="main-content-card-view-basic-example"
    >
      <section class="pf-v6-c-page__main-breadcrumb pf-m-limit-width">
        <div class="pf-v6-c-page__main-body">
          <nav class="pf-v6-c-breadcrumb" aria-label="breadcrumb">
            <ol class="pf-v6-c-breadcrumb__list" role="list">
              <li class="pf-v6-c-breadcrumb__item">
                <a href="#" class="pf-v6-c-breadcrumb__link">Section home</a>
              </li>
              <li class="pf-v6-c-breadcrumb__item">
                <span class="pf-v6-c-breadcrumb__item-divider">
                  <i class="fas fa-angle-right" aria-hidden="true"></i>
                </span>

                <a href="#" class="pf-v6-c-breadcrumb__link">Section title</a>
              </li>
              <li class="pf-v6-c-breadcrumb__item">
                <span class="pf-v6-c-breadcrumb__item-divider">
                  <i class="fas fa-angle-right" aria-hidden="true"></i>
                </span>

                <a href="#" class="pf-v6-c-breadcrumb__link">Section title</a>
              </li>
              <li class="pf-v6-c-breadcrumb__item">
                <span class="pf-v6-c-breadcrumb__item-divider">
                  <i class="fas fa-angle-right" aria-hidden="true"></i>
                </span>

                <a
                  href="#"
                  class="pf-v6-c-breadcrumb__link pf-m-current"
                  aria-current="page"
                >Section landing</a>
              </li>
            </ol>
          </nav>
        </div>
      </section>
      <section class="pf-v6-c-page__main-section pf-m-limit-width">
        <div class="pf-v6-c-page__main-body">
          <h1 class="pf-v6-c-content--h1 pf-m-page-title">Main title</h1>
          <p class="pf-v6-c-content--p">This is a full page demo.</p>
        </div>
      </section>
      <section class="pf-v6-c-page__main-section">
        <div class="pf-v6-c-page__main-body">
          <div class="pf-v6-c-toolbar" id="card-view-basic-example-toolbar">
            <div class="pf-v6-c-toolbar__content">
              <div class="pf-v6-c-toolbar__content-section pf-m-nowrap">
                <div
                  class="pf-v6-c-toolbar__group pf-m-show-on-xl pf-m-toggle-group"
                >
                  <div class="pf-v6-c-toolbar__toggle">
                    <button
                      class="pf-v6-c-menu-toggle pf-m-plain"
                      type="button"
                      aria-expanded="false"
                      aria-label="Show filters"
                      aria-controls="card-view-basic-example-toolbar-expandable-content"
                    >
                      <span class="pf-v6-c-menu-toggle__icon">
                        <i class="fas fa-filter" aria-hidden="true"></i>
                      </span>
                    </button>
                  </div>
                  <div class="pf-v6-c-toolbar__item pf-m-bulk-select">
                    <div
                      class="pf-v6-c-menu-toggle pf-m-split-button"
                      id="card-view-basic-example-toolbar-check"
                    >
                      <label
                        class="pf-v6-c-check pf-m-standalone"
                        for="card-view-basic-example-toolbar-check-check-input"
                      >
                        <input
                          class="pf-v6-c-check__input"
                          type="checkbox"
                          id="card-view-basic-example-toolbar-check-check-input"
                          name="card-view-basic-example-toolbar-check-check-input"
                          aria-label="Standalone check"
                        />
                      </label>
                      <button
                        class="pf-v6-c-menu-toggle__button"
                        type="button"
                        aria-expanded="false"
                        id="card-view-basic-example-toolbar-menu-toggle-toggle-button"
                        aria-label="Menu toggle"
                      >
                        <span class="pf-v6-c-menu-toggle__controls">
                          <span class="pf-v6-c-menu-toggle__toggle-icon">
                            <i
                              class="fas fa-caret-down fa-fw"
                              aria-hidden="true"
                            ></i>
                          </span>
                        </span>
                      </button>
                    </div>
                  </div>

                  <div class="pf-v6-c-toolbar__item">
                    <button
                      class="pf-v6-c-menu-toggle"
                      type="button"
                      aria-expanded="false"
                      id="card-view-basic-example-toolbar-select-checkbox-status"
                    >
                      <span class="pf-v6-c-menu-toggle__text">Status</span>
                      <span class="pf-v6-c-menu-toggle__controls">
                        <span class="pf-v6-c-menu-toggle__toggle-icon">
                          <i class="fas fa-caret-down fa-fw" aria-hidden="true"></i>
                        </span>
                      </span>
                    </button>
                  </div>
                </div>

                <div
                  class="pf-v6-c-overflow-menu"
                  id="card-view-basic-example-toolbar-overflow-menu"
                >
                  <div
                    class="pf-v6-c-overflow-menu__content pf-v6-u-display-none pf-v6-u-display-flex-on-lg"
                  >
                    <div class="pf-v6-c-overflow-menu__group pf-m-button-group">
                      <div class="pf-v6-c-overflow-menu__item">
                        <button
                          class="pf-v6-c-button pf-m-primary"
                          type="button"
                        >
                          <span class="pf-v6-c-button__text">Create instance</span>
                        </button>
                      </div>
                    </div>
                  </div>
                  <div class="pf-v6-c-overflow-menu__control">
                    <button
                      class="pf-v6-c-menu-toggle pf-m-plain"
                      type="button"
                      aria-expanded="false"
                      aria-label="Menu toggle"
                      id="card-view-basic-example-toolbar-overflow-menu-toggle"
                    >
                      <span class="pf-v6-c-menu-toggle__icon">
                        <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                      </span>
                    </button>
                  </div>
                </div>

                <div class="pf-v6-c-toolbar__item pf-m-pagination">
                  <div class="pf-v6-c-pagination pf-m-compact">
                    <div class="pf-v6-c-pagination__page-menu">
                      <button
                        class="pf-v6-c-menu-toggle pf-m-text pf-m-plain"
                        type="button"
                        aria-expanded="false"
                        aria-label="Menu toggle"
                        id="card-view-basic-example-toolbar-top-pagination"
                      >
                        <span class="pf-v6-c-menu-toggle__text">
                          <b>1 - 10</b>&nbsp;of&nbsp;
                          <b>36</b>
                        </span>
                        <span class="pf-v6-c-menu-toggle__controls">
                          <span class="pf-v6-c-menu-toggle__toggle-icon">
                            <i
                              class="fas fa-caret-down fa-fw"
                              aria-hidden="true"
                            ></i>
                          </span>
                        </span>
                      </button>
                    </div>
                    <nav
                      class="pf-v6-c-pagination__nav"
                      aria-label="Toolbar top pagination"
                    >
                      <div class="pf-v6-c-pagination__nav-control pf-m-prev">
                        <button
                          class="pf-v6-c-button pf-m-plain"
                          type="button"
                          disabled
                          aria-label="Go to previous page"
                        >
                          <span class="pf-v6-c-button__icon">
                            <i class="fas fa-angle-left" aria-hidden="true"></i>
                          </span>
                        </button>
                      </div>
                      <div class="pf-v6-c-pagination__nav-control pf-m-next">
                        <button
                          class="pf-v6-c-button pf-m-plain"
                          type="button"
                          aria-label="Go to next page"
                        >
                          <span class="pf-v6-c-button__icon">
                            <i class="fas fa-angle-right" aria-hidden="true"></i>
                          </span>
                        </button>
                      </div>
                    </nav>
                  </div>
                </div>
              </div>

              <div
                class="pf-v6-c-toolbar__expandable-content pf-m-hidden"
                id="card-view-basic-example-toolbar-expandable-content"
                hidden
              ></div>
            </div>
          </div>
        </div>
      </section>
      <section class="pf-v6-c-page__main-section">
        <div class="pf-v6-c-page__main-body">
          <div class="pf-v6-l-gallery pf-m-gutter">
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-empty-state"
            >
              <div class="pf-v6-l-bullseye">
                <div class="pf-v6-c-empty-state pf-m-xs">
                  <div class="pf-v6-c-empty-state__content">
                    <i class="fas fa-plus-circle pf-v6-c-empty-state__icon"></i>
                    <div class="pf-v6-c-card__title">
                      <h2
                        class="pf-v6-c-card__title-text pf-m-md"
                      >Add a new card to your page</h2>
                    </div>
                    <button class="pf-v6-c-button pf-m-link" type="button">
                      <span class="pf-v6-c-button__text">Add card</span>
                    </button>
                  </div>
                </div>
              </div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-1"
            >
              <div class="pf-v6-c-card__header">
                <img src="/assets/images/PF-IconLogo.svg" alt="PatternFly logo" />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-1-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-1-check"
                      name="card-view-basic-example-gallery-card-1-check"
                      aria-labelledby="card-view-basic-example-gallery-card-1-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-1-check-label"
                >Patternfly</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >PatternFly is a community project that promotes design commonality and improves user experience.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-2"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/activemq-core_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-2-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-2-check"
                      name="card-view-basic-example-gallery-card-2-check"
                      aria-labelledby="card-view-basic-example-gallery-card-2-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-2-check-label"
                >ActiveMq</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >The ActiveMQ component allows messages to be sent to a JMS Queue or Topic; or messages to be consumed from a JMS Queue or Topic using Apache ActiveMQ.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-3"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/camel-spark_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-3-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-3-check"
                      name="card-view-basic-example-gallery-card-3-check"
                      aria-labelledby="card-view-basic-example-gallery-card-3-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-3-check-label"
                >Apache Spark</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >This documentation page covers the Apache Spark component for the Apache Camel.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-4"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/camel-avro_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-4-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-4-check"
                      name="card-view-basic-example-gallery-card-4-check"
                      aria-labelledby="card-view-basic-example-gallery-card-4-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-4-check-label"
                >Avro</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >This component provides a dataformat for avro, which allows serialization and deserialization of messages using Apache Avro’s binary dataformat. Moreover, it provides support for Apache Avro’s rpc, by providing producers and consumers endpoint for using avro over netty or http.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-selected-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-5"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/FuseConnector_Icons_AzureServices.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-5-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-5-check"
                      name="card-view-basic-example-gallery-card-5-check"
                      aria-labelledby="card-view-basic-example-gallery-card-5-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-5-check-label"
                >Azure Services</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >The Camel Components for Windows Azure Services provide connectivity to Azure services from Camel.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-non-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-6"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/camel-saxon_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-6-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-6-check"
                      name="card-view-basic-example-gallery-card-6-check"
                      disabled
                      aria-labelledby="card-view-basic-example-gallery-card-6-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-6-check-label"
                >Crypto</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >For providing flexible endpoints to sign and verify exchanges using the Signature Service of the Java Cryptographic Extension.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-7"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/camel-dropbox_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-7-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-7-check"
                      name="card-view-basic-example-gallery-card-7-check"
                      aria-labelledby="card-view-basic-example-gallery-card-7-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-7-check-label"
                >DropBox</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >The dropbox: component allows you to treat Dropbox remote folders as a producer or consumer of messages.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-8"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/camel-infinispan_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-8-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-8-check"
                      name="card-view-basic-example-gallery-card-8-check"
                      aria-labelledby="card-view-basic-example-gallery-card-8-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-8-check-label"
                >JBoss Data Grid</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >Read or write to a fully-supported distributed cache and data grid for faster integration services.</div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-9"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/FuseConnector_Icons_REST.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-9-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-9-check"
                      name="card-view-basic-example-gallery-card-9-check"
                      aria-labelledby="card-view-basic-example-gallery-card-9-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-9-check-label"
                >Rest</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div class="pf-v6-c-card__body">
                The rest component allows to define REST endpoints (consumer) using the Rest DSL and plugin to other Camel components as the REST transport.
                From Camel 2.18 onwards the rest component can also be used as a client (producer) to call REST services.
              </div>
            </div>
            <div
              class="pf-v6-c-card pf-m-selectable-raised pf-m-compact"
              id="card-view-basic-example-gallery-card-10"
            >
              <div class="pf-v6-c-card__header">
                <img
                  src="/assets/images/camel-swagger-java_200x150.png"
                  width="60px"
                  alt="Logo"
                />
                <div class="pf-v6-c-card__actions">
                  <button
                    class="pf-v6-c-menu-toggle pf-m-plain"
                    type="button"
                    aria-expanded="false"
                    aria-label="Menu toggle"
                    id="card-view-basic-example-gallery-card-10-toggle"
                  >
                    <span class="pf-v6-c-menu-toggle__icon">
                      <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
                    </span>
                  </button>
                  <div class="pf-v6-c-check pf-m-standalone">
                    <input
                      class="pf-v6-c-check__input"
                      type="checkbox"
                      id="card-view-basic-example-gallery-card-10-check"
                      name="card-view-basic-example-gallery-card-10-check"
                      aria-labelledby="card-view-basic-example-gallery-card-10-check-label"
                    />
                  </div>
                </div>
              </div>
              <div class="pf-v6-c-card__title">
                <h2
                  class="pf-v6-c-card__title-text"
                  id="card-view-basic-example-gallery-card-10-check-label"
                >SWAGGER</h2>
                <div class="pf-v6-c-content">
                  <small>Provided by Red Hat</small>
                </div>
              </div>
              <div
                class="pf-v6-c-card__body"
              >Expose REST services and their APIs using Swagger specification.</div>
            </div>
          </div>
        </div>
      </section>
      <section class="pf-v6-c-page__main-section pf-m-sticky-bottom">
        <div class="pf-v6-c-page__main-body">
          <div class="pf-v6-c-pagination pf-m-bottom">
            <div class="pf-v6-c-pagination__page-menu">
              <button
                class="pf-v6-c-menu-toggle pf-m-top pf-m-text pf-m-plain"
                type="button"
                aria-expanded="false"
                aria-label="Menu toggle"
                id="pagination-menu-toggle-bottom-example"
              >
                <span class="pf-v6-c-menu-toggle__text">
                  <b>1 - 10</b>&nbsp;of&nbsp;
                  <b>36</b>
                </span>
                <span class="pf-v6-c-menu-toggle__controls">
                  <span class="pf-v6-c-menu-toggle__toggle-icon">
                    <i class="fas fa-caret-down fa-fw" aria-hidden="true"></i>
                  </span>
                </span>
              </button>
            </div>
            <nav class="pf-v6-c-pagination__nav" aria-label="Pagination">
              <div class="pf-v6-c-pagination__nav-control pf-m-first">
                <button
                  class="pf-v6-c-button pf-m-plain"
                  type="button"
                  disabled
                  aria-label="Go to first page"
                >
                  <span class="pf-v6-c-button__icon">
                    <i class="fas fa-angle-double-left" aria-hidden="true"></i>
                  </span>
                </button>
              </div>
              <div class="pf-v6-c-pagination__nav-control pf-m-prev">
                <button
                  class="pf-v6-c-button pf-m-plain"
                  type="button"
                  disabled
                  aria-label="Go to previous page"
                >
                  <span class="pf-v6-c-button__icon">
                    <i class="fas fa-angle-left" aria-hidden="true"></i>
                  </span>
                </button>
              </div>
              <div class="pf-v6-c-pagination__nav-page-select">
                <span class="pf-v6-c-form-control">
                  <input
                    aria-label="Current page"
                    type="number"
                    min="1"
                    max="4"
                    value="1"
                  />
                </span>
                <span aria-hidden="true">of 4</span>
              </div>
              <div class="pf-v6-c-pagination__nav-control pf-m-next">
                <button
                  class="pf-v6-c-button pf-m-plain"
                  type="button"
                  aria-label="Go to next page"
                >
                  <span class="pf-v6-c-button__icon">
                    <i class="fas fa-angle-right" aria-hidden="true"></i>
                  </span>
                </button>
              </div>
              <div class="pf-v6-c-pagination__nav-control pf-m-last">
                <button
                  class="pf-v6-c-button pf-m-plain"
                  type="button"
                  disabled
                  aria-label="Go to last page"
                >
                  <span class="pf-v6-c-button__icon">
                    <i class="fas fa-angle-double-right" aria-hidden="true"></i>
                  </span>
                </button>
              </div>
            </nav>
          </div>
        </div>
      </section>
    </main>
  </div>
</div>

```

## Documentation
