*** Settings ***
Documentation       HPE Primera Storage REST API

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Start Mockoon    ${MOCKOON_JSON}
Suite Teardown      Stop Mockoon
Test Timeout        120s

*** Variables ***
${MOCKOON_JSON}     ${CURDIR}${/}hpe-primera.mockoon.json
${HOSTNAME}             127.0.0.1
${APIPORT}              3000
${CMD}              ${CENTREON_PLUGINS} 
...                 --plugin=storage::hp::primera::restapi::plugin
...                 --mode=volume-usage
...                 --hostname=${HOSTNAME}
...                 --api-username=toto
...                 --api-password=toto
...                 --proto=http
...                 --port=${APIPORT}
...                 --custommode=api

*** Test Cases ***
Volumeusage ${tc}
    [Tags]    storage     api    hpe    hp
    ${output}    Run    ${CMD} ${extraoptions}

    ${output}    Strip String    ${output}

    Should Be Equal As Strings
    ...    ${output}
    ...    ${expected_result}
    ...    Wrong output result for command:\n${CMD} ${extraoptions}\n\nObtained:\n${output}\n\nExpected:\n${expected_result}\n
    ...    values=False
    ...    collapse_spaces=True

    Examples:    tc       extraoptions                                       expected_result   --
        ...      1        ${EMPTY}                                           OK: All volumes are ok | '.mgmtdata#volume.space.usage.bytes'=549755813888B;;;0;549755813888 '.mgmtdata#volume.space.free.bytes'=0B;;;0;549755813888 '.mgmtdata#volume.space.usage.percentage'=100.00%;;;0;100 '.shared.SSD_r6_0#volume.space.usage.bytes'=166599852032B;;;0;70368744177664 '.shared.SSD_r6_0#volume.space.free.bytes'=70202144325632B;;;0;70368744177664 '.shared.SSD_r6_0#volume.space.usage.percentage'=0.24%;;;0;100 '.srdata#volume.space.usage.bytes'=225485783040B;;;0;225485783040 '.srdata#volume.space.free.bytes'=0B;;;0;225485783040 '.srdata#volume.space.usage.percentage'=100.00%;;;0;100 'DR-WOO-SSD01#volume.space.usage.bytes'=4327029604352B;;;0;6047313952768 'DR-WOO-SSD01#volume.space.free.bytes'=1720284348416B;;;0;6047313952768 'DR-WOO-SSD01#volume.space.usage.percentage'=71.55%;;;0;100 'DR-WOO-SSD02#volume.space.usage.bytes'=1137753194496B;;;0;5497558138880 'DR-WOO-SSD02#volume.space.free.bytes'=4359804944384B;;;0;5497558138880 'DR-WOO-SSD02#volume.space.usage.percentage'=20.70%;;;0;100 'JHDFB_NL01#volume.space.usage.bytes'=537547243520B;;;0;5497558138880 'JHDFB_NL01#volume.space.free.bytes'=4960010895360B;;;0;5497558138880 'JHDFB_NL01#volume.space.usage.percentage'=9.78%;;;0;100 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;;;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;;;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;;;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;;;0;100 'QUPODHDG01#volume.space.usage.bytes'=74894540800B;;;0;343597383680 'QUPODHDG01#volume.space.free.bytes'=268702842880B;;;0;343597383680 'QUPODHDG01#volume.space.usage.percentage'=21.80%;;;0;100 'Quorum-.0#volume.space.usage.bytes'=424673280B;;;0;107374182400 'Quorum-.0#volume.space.free.bytes'=106949509120B;;;0;107374182400 'Quorum-.0#volume.space.usage.percentage'=0.40%;;;0;100 'Quorum-.1#volume.space.usage.bytes'=3145728B;;;0;107374182400 'Quorum-.1#volume.space.free.bytes'=107371036672B;;;0;107374182400 'Quorum-.1#volume.space.usage.percentage'=0.00%;;;0;100 'YLBQFC#volume.space.usage.bytes'=2059163140096B;;;0;4398046511104 'YLBQFC#volume.space.free.bytes'=2338883371008B;;;0;4398046511104 'YLBQFC#volume.space.usage.percentage'=46.82%;;;0;100 'YLBQG01#volume.space.usage.bytes'=357328486400B;;;0;1099511627776 'YLBQG01#volume.space.free.bytes'=742183141376B;;;0;1099511627776 'YLBQG01#volume.space.usage.percentage'=32.50%;;;0;100 'YLBQYLBQ01#volume.space.usage.bytes'=13838988607488B;;;0;21990232555520 'YLBQYLBQ01#volume.space.free.bytes'=8151243948032B;;;0;21990232555520 'YLBQYLBQ01#volume.space.usage.percentage'=62.93%;;;0;100 'admin#volume.space.usage.bytes'=10737418240B;;;0;10737418240 'admin#volume.space.free.bytes'=0B;;;0;10737418240 'admin#volume.space.usage.percentage'=100.00%;;;0;100
        ...      2        --filter-name=LZRFEE_NL03                          OK: Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) | 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100
        ...      3        --filter-counters='^usage$'                        OK: All volumes are ok | '.mgmtdata#volume.space.usage.bytes'=549755813888B;;;0;549755813888 '.shared.SSD_r6_0#volume.space.usage.bytes'=166599852032B;;;0;70368744177664 '.srdata#volume.space.usage.bytes'=225485783040B;;;0;225485783040 'DR-WOO-SSD01#volume.space.usage.bytes'=4327029604352B;;;0;6047313952768 'DR-WOO-SSD02#volume.space.usage.bytes'=1137753194496B;;;0;5497558138880 'JHDFB_NL01#volume.space.usage.bytes'=537547243520B;;;0;5497558138880 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;;0;32985348833280 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;;0;6034429050880 'QUPODHDG01#volume.space.usage.bytes'=74894540800B;;;0;343597383680 'Quorum-.0#volume.space.usage.bytes'=424673280B;;;0;107374182400 'Quorum-.1#volume.space.usage.bytes'=3145728B;;;0;107374182400 'YLBQFC#volume.space.usage.bytes'=2059163140096B;;;0;4398046511104 'YLBQG01#volume.space.usage.bytes'=357328486400B;;;0;1099511627776 'YLBQYLBQ01#volume.space.usage.bytes'=13838988607488B;;;0;21990232555520 'admin#volume.space.usage.bytes'=10737418240B;;;0;10737418240
        ...      4        --warning-usage-prct='70' --filter-name=LZRFEE     WARNING: Volume 'LZRFEE_NL01' (#12) Used : 73.01 % - Volume 'LZRFEE_NL02' (#13) Used : 77.07 % | 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;;;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;0:70;;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;0:70;;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;0:70;;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;0:70;;0;100
        ...      5        --critical-usage-prct='70' --filter-name=LZRFEE    CRITICAL: Volume 'LZRFEE_NL01' (#12) Used : 73.01 % - Volume 'LZRFEE_NL02' (#13) Used : 77.07 % | 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;;;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;;0:70;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;;0:70;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;0:70;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;;0:70;0;100
        ...      6        --warning-usage='70' --filter-name=LZRFEE          WARNING: Volume 'LZRFEE_NL01' (#12) Usage Total: 30.00 TB Used: 21.90 TB (73.01%) Free: 8.10 TB (26.99%) - Volume 'LZRFEE_NL02' (#13) Usage Total: 30.00 TB Used: 23.12 TB (77.07%) Free: 6.88 TB (22.93%) - Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) - Volume 'LZRFEE_NL2024' (#15) Usage Total: 5.49 TB Used: 430.56 GB (7.66%) Free: 5.07 TB (92.34%) | 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;0:70;;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;;;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;;;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;0:70;;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;;;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;0:70;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;0:70;;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;;;0;100
        ...      7        --critical-usage='70' --filter-name=LZRFEE         CRITICAL: Volume 'LZRFEE_NL01' (#12) Usage Total: 30.00 TB Used: 21.90 TB (73.01%) Free: 8.10 TB (26.99%) - Volume 'LZRFEE_NL02' (#13) Usage Total: 30.00 TB Used: 23.12 TB (77.07%) Free: 6.88 TB (22.93%) - Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) - Volume 'LZRFEE_NL2024' (#15) Usage Total: 5.49 TB Used: 430.56 GB (7.66%) Free: 5.07 TB (92.34%) | 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;0:70;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;;;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;;;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;0:70;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;;;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;0:70;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;0:70;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;;;0;100
        ...      8        --warning-usage-free='10:' --filter-name=LZRFEE    OK: All volumes are ok | 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;10:;;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;;;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;10:;;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;;;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;10:;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;10:;;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;;;0;100
        ...      9        --critical-usage-free='10:' --filter-name=LZRFEE   OK: All volumes are ok | 'LZRFEE_NL01#volume.space.usage.bytes'=24082603048960B;;;0;32985348833280 'LZRFEE_NL01#volume.space.free.bytes'=8902745784320B;;10:;0;32985348833280 'LZRFEE_NL01#volume.space.usage.percentage'=73.01%;;;0;100 'LZRFEE_NL02#volume.space.usage.bytes'=25421404962816B;;;0;32985348833280 'LZRFEE_NL02#volume.space.free.bytes'=7563943870464B;;10:;0;32985348833280 'LZRFEE_NL02#volume.space.usage.percentage'=77.07%;;;0;100 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;10:;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100 'LZRFEE_NL2024#volume.space.usage.bytes'=462308769792B;;;0;6034429050880 'LZRFEE_NL2024#volume.space.free.bytes'=5572120281088B;;10:;0;6034429050880 'LZRFEE_NL2024#volume.space.usage.percentage'=7.66%;;;0;100
        ...     10        --warning-usage='70' --filter-id='^14$'            WARNING: Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) | 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;0:70;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100
        ...     11        --critical-usage='70' --filter-id='^14$'           CRITICAL: Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) | 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;0:70;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100
        ...     12        --warning-usage-free='10:' --filter-id='^14$'      OK: Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) | 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;10:;;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100
        ...     13        --critical-usage-free='10:' --filter-id='^14$'     OK: Volume 'LZRFEE_NL03' (#14) Usage Total: 5.50 TB Used: 1.60 TB (29.05%) Free: 3.90 TB (70.95%) | 'LZRFEE_NL03#volume.space.usage.bytes'=1756681469952B;;;0;6047313952768 'LZRFEE_NL03#volume.space.free.bytes'=4290632482816B;;10:;0;6047313952768 'LZRFEE_NL03#volume.space.usage.percentage'=29.05%;;;0;100
