*** Settings ***
Documentation       HPE Primera Storage REST API

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Suite Setup         Start Mockoon    ${MOCKOON_JSON}
Suite Teardown      Stop Mockoon
Test Timeout        120s


*** Variables ***
${MOCKOON_JSON}     ${CURDIR}${/}hpe-primera.mockoon.json
${HOSTNAME}             127.0.0.1
${APIPORT}              3000
${CMD}              ${CENTREON_PLUGINS} 
...                 --plugin=storage::hp::primera::restapi::plugin
...                 --mode=capacity
...                 --hostname=${HOSTNAME}
...                 --api-username=toto
...                 --api-password=toto
...                 --proto=http
...                 --port=${APIPORT}
...                 --custommode=api

*** Test Cases ***
Capacity ${tc}
    [Tags]    storage     api    hpe    hp
    ${output}    Run    ${CMD} ${extraoptions}

    ${output}    Strip String    ${output}
    Should Be Equal As Strings
    ...    ${output}
    ...    ${expected_result}
    ...    Wrong output result for command:\n${CMD} ${extraoptions}\n\nObtained:\n${output}\n\nExpected:\n${expected_result}\n
    ...    values=False
    ...    collapse_spaces=True


    Examples:    tc        extraoptions                                              expected_result   --
        ...      1        --filter-type=allCapacity                                  OK: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%), unavailable: 0.00 B, failed: 0.00 B - compaction: 1.66, deduplication: 1.02, compression: 1.37, data reduction: 1.37, overprovisioning: 0.45 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      2        --filter-type=FCCapacity                                   OK: storage 'FCCapacity' space usage total: 104.72 TB used: 25.69 TB (24.53%) free: 79.03 TB (75.47%), unavailable: 0.00 B, failed: 0.00 B - compaction: 1.98, deduplication: 0, data reduction: 0, overprovisioning: 0.39 | 'FCCapacity#storage.space.usage.bytes'=28242631196672B;;;0;115139483271168 'FCCapacity#storage.space.free.bytes'=86896852074496B;;;0;115139483271168 'FCCapacity#storage.space.usage.percentage'=24.53%;;;0;100 'FCCapacity#storage.space.unavailable.bytes'=0B;;;0; 'FCCapacity#storage.space.failed.bytes'=0B;;;0; 'FCCapacity#storage.space.compaction.ratio.count'=1.98;;;0; 'FCCapacity#storage.space.deduplication.ratio.count'=0;;;0; 'FCCapacity#storage.space.data_reduction.ratio.count'=0;;;0; 'FCCapacity#storage.space.overprovisioning.ratio.count'=0.39;;;0;
        ...      3        --filter-type=SSDCapacity                                  OK: storage 'SSDCapacity' space usage total: 24.43 TB used: 10.23 TB (41.88%) free: 14.20 TB (58.12%), unavailable: 0.00 B, failed: 0.00 B - compaction: 2.12, deduplication: 1.02, compression: 1.37, data reduction: 1.37, overprovisioning: 0.54 | 'SSDCapacity#storage.space.usage.bytes'=11250666831872B;;;0;26862872952832 'SSDCapacity#storage.space.free.bytes'=15612206120960B;;;0;26862872952832 'SSDCapacity#storage.space.usage.percentage'=41.88%;;;0;100 'SSDCapacity#storage.space.unavailable.bytes'=0B;;;0; 'SSDCapacity#storage.space.failed.bytes'=0B;;;0; 'SSDCapacity#storage.space.compaction.ratio.count'=2.12;;;0; 'SSDCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'SSDCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'SSDCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'SSDCapacity#storage.space.overprovisioning.ratio.count'=0.54;;;0;
        ...      4        --filter-type=NLCapacity                                   OK: storage 'NLCapacity' space usage total: 249.45 TB used: 91.19 TB (36.55%) free: 158.27 TB (63.45%), unavailable: 0.00 B, failed: 0.00 B - compaction: 1.51, deduplication: 0, data reduction: 0, overprovisioning: 0.47 | 'NLCapacity#storage.space.usage.bytes'=100261716557824B;;;0;274276611522560 'NLCapacity#storage.space.free.bytes'=174014894964736B;;;0;274276611522560 'NLCapacity#storage.space.usage.percentage'=36.55%;;;0;100 'NLCapacity#storage.space.unavailable.bytes'=0B;;;0; 'NLCapacity#storage.space.failed.bytes'=0B;;;0; 'NLCapacity#storage.space.compaction.ratio.count'=1.51;;;0; 'NLCapacity#storage.space.deduplication.ratio.count'=0;;;0; 'NLCapacity#storage.space.data_reduction.ratio.count'=0;;;0; 'NLCapacity#storage.space.overprovisioning.ratio.count'=0.47;;;0;
        ...      5        --filter-type=allCapacity --warning-compaction=2:          WARNING: storage 'allCapacity' compaction: 1.66 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;2:;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      6        --filter-type=allCapacity --critical-deduplication=2:      CRITICAL: storage 'allCapacity' deduplication: 1.02 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;2:;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      7        --filter-type=allCapacity --warning-data-reduction=2:      WARNING: storage 'allCapacity' data reduction: 1.37 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;2:;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      8        --filter-type=allCapacity --critical-overprovisioning=20   OK: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%), unavailable: 0.00 B, failed: 0.00 B - compaction: 1.66, deduplication: 1.02, compression: 1.37, data reduction: 1.37, overprovisioning: 0.45 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;0:20;0;
        ...      9        --critical-deduplication=2:                                CRITICAL: storage 'FCCapacity' deduplication: 0 - storage 'NLCapacity' deduplication: 0 - storage 'SSDCapacity' deduplication: 1.02 - storage 'allCapacity' deduplication: 1.02 | 'FCCapacity#storage.space.usage.bytes'=28242631196672B;;;0;115139483271168 'FCCapacity#storage.space.free.bytes'=86896852074496B;;;0;115139483271168 'FCCapacity#storage.space.usage.percentage'=24.53%;;;0;100 'FCCapacity#storage.space.unavailable.bytes'=0B;;;0; 'FCCapacity#storage.space.failed.bytes'=0B;;;0; 'FCCapacity#storage.space.compaction.ratio.count'=1.98;;;0; 'FCCapacity#storage.space.deduplication.ratio.count'=0;;2:;0; 'FCCapacity#storage.space.data_reduction.ratio.count'=0;;;0; 'FCCapacity#storage.space.overprovisioning.ratio.count'=0.39;;;0; 'NLCapacity#storage.space.usage.bytes'=100261716557824B;;;0;274276611522560 'NLCapacity#storage.space.free.bytes'=174014894964736B;;;0;274276611522560 'NLCapacity#storage.space.usage.percentage'=36.55%;;;0;100 'NLCapacity#storage.space.unavailable.bytes'=0B;;;0; 'NLCapacity#storage.space.failed.bytes'=0B;;;0; 'NLCapacity#storage.space.compaction.ratio.count'=1.51;;;0; 'NLCapacity#storage.space.deduplication.ratio.count'=0;;2:;0; 'NLCapacity#storage.space.data_reduction.ratio.count'=0;;;0; 'NLCapacity#storage.space.overprovisioning.ratio.count'=0.47;;;0; 'SSDCapacity#storage.space.usage.bytes'=11250666831872B;;;0;26862872952832 'SSDCapacity#storage.space.free.bytes'=15612206120960B;;;0;26862872952832 'SSDCapacity#storage.space.usage.percentage'=41.88%;;;0;100 'SSDCapacity#storage.space.unavailable.bytes'=0B;;;0; 'SSDCapacity#storage.space.failed.bytes'=0B;;;0; 'SSDCapacity#storage.space.compaction.ratio.count'=2.12;;;0; 'SSDCapacity#storage.space.deduplication.ratio.count'=1.02;;2:;0; 'SSDCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'SSDCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'SSDCapacity#storage.space.overprovisioning.ratio.count'=0.54;;;0; 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;2:;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      10       --filter-type=allCapacity --warning-space-usage=180        WARNING: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%) | 'allCapacity#storage.space.usage.bytes'=139755014586368B;0:180;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      11       --filter-type=allCapacity --critical-space-usage-free=180  CRITICAL: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%) | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;0:180;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      12       --filter-type=allCapacity --warning-space-usage-prct=20    WARNING: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%) | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;0:20;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      13       --filter-type=allCapacity --critical-space-unavailable=20  OK: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%), unavailable: 0.00 B, failed: 0.00 B - compaction: 1.66, deduplication: 1.02, compression: 1.37, data reduction: 1.37, overprovisioning: 0.45 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;0:20;0; 'allCapacity#storage.space.failed.bytes'=0B;;;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
        ...      14       --filter-type=allCapacity --critical-space-failed=20       OK: storage 'allCapacity' space usage total: 378.60 TB used: 127.11 TB (33.57%) free: 251.50 TB (66.43%), unavailable: 0.00 B, failed: 0.00 B - compaction: 1.66, deduplication: 1.02, compression: 1.37, data reduction: 1.37, overprovisioning: 0.45 | 'allCapacity#storage.space.usage.bytes'=139755014586368B;;;0;416278967746560 'allCapacity#storage.space.free.bytes'=276523953160192B;;;0;416278967746560 'allCapacity#storage.space.usage.percentage'=33.57%;;;0;100 'allCapacity#storage.space.unavailable.bytes'=0B;;;0; 'allCapacity#storage.space.failed.bytes'=0B;;0:20;0; 'allCapacity#storage.space.compaction.ratio.count'=1.66;;;0; 'allCapacity#storage.space.deduplication.ratio.count'=1.02;;;0; 'allCapacity#storage.space.compression.ratio.count'=1.37;;;0; 'allCapacity#storage.space.data_reduction.ratio.count'=1.37;;;0; 'allCapacity#storage.space.overprovisioning.ratio.count'=0.45;;;0;
