from __future__ import absolute_import, division, print_function
from iotbx import pdb
from mmtbx.conformation_dependent_library.testing_utils import get_geometry_restraints_manager
from six.moves import range

pdb_1ehz = '''HEADER    RIBONUCLEIC ACID                        23-FEB-00   1EHZ
TITLE     THE CRYSTAL STRUCTURE OF YEAST PHENYLALANINE TRNA AT 1.93 A
ATOM     68  P     G A   4      65.295  47.868  51.793  1.00 79.34           P
ATOM     69  O1P   G A   4      66.538  48.562  52.246  1.00 80.87           O
ATOM     70  O2P   G A   4      64.193  48.679  51.209  1.00 79.00           O
ATOM     71  O5*   G A   4      65.720  46.752  50.724  1.00 75.17           O
ATOM     72  C5*   G A   4      66.789  45.843  51.019  1.00 68.95           C
ATOM     73  C4*   G A   4      66.749  44.634  50.114  1.00 65.13           C
ATOM     74  O4*   G A   4      65.484  43.939  50.258  1.00 61.83           O
ATOM     75  C3*   G A   4      66.881  44.840  48.611  1.00 62.79           C
ATOM     76  O3*   G A   4      68.230  44.977  48.176  1.00 61.75           O
ATOM     77  C2*   G A   4      66.318  43.538  48.064  1.00 60.58           C
ATOM     78  O2*   G A   4      67.283  42.514  48.122  1.00 59.59           O
ATOM     79  C1*   G A   4      65.192  43.241  49.051  1.00 58.29           C
ATOM     80  N9    G A   4      63.923  43.716  48.500  1.00 53.36           N
ATOM     81  C8    G A   4      63.204  44.843  48.842  1.00 49.19           C
ATOM     82  N7    G A   4      62.140  45.013  48.107  1.00 46.88           N
ATOM     83  C5    G A   4      62.144  43.926  47.243  1.00 45.95           C
ATOM     84  C6    G A   4      61.246  43.573  46.206  1.00 43.95           C
ATOM     85  O6    G A   4      60.182  44.136  45.874  1.00 42.46           O
ATOM     86  N1    G A   4      61.672  42.428  45.540  1.00 40.34           N
ATOM     87  C2    G A   4      62.788  41.686  45.867  1.00 42.60           C
ATOM     88  N2    G A   4      63.034  40.588  45.135  1.00 38.91           N
ATOM     89  N3    G A   4      63.612  41.994  46.850  1.00 44.40           N
ATOM     90  C4    G A   4      63.239  43.117  47.480  1.00 48.65           C
ATOM     91  P     A A   5      68.530  45.722  46.789  1.00 59.03           P
ATOM     92  O1P   A A   5      69.991  45.842  46.548  1.00 60.84           O
ATOM     93  O2P   A A   5      67.685  46.959  46.834  1.00 60.64           O
ATOM     94  O5*   A A   5      67.957  44.735  45.675  1.00 57.14           O
ATOM     95  C5*   A A   5      68.648  43.529  45.323  1.00 53.41           C
ATOM     96  C4*   A A   5      67.927  42.844  44.191  1.00 50.63           C
ATOM     97  O4*   A A   5      66.589  42.480  44.646  1.00 48.70           O
ATOM     98  C3*   A A   5      67.665  43.715  42.964  1.00 50.77           C
ATOM     99  O3*   A A   5      68.747  43.769  42.051  1.00 52.86           O
ATOM    100  C2*   A A   5      66.455  43.024  42.355  1.00 48.94           C
ATOM    101  O2*   A A   5      66.864  41.798  41.731  1.00 48.54           O
ATOM    102  C1*   A A   5      65.646  42.719  43.615  1.00 44.50           C
ATOM    103  N9    A A   5      64.779  43.843  44.021  1.00 42.01           N
ATOM    104  C8    A A   5      64.938  44.803  45.016  1.00 39.75           C
ATOM    105  N7    A A   5      63.925  45.649  45.113  1.00 41.58           N
ATOM    106  C5    A A   5      63.049  45.220  44.115  1.00 38.26           C
ATOM    107  C6    A A   5      61.796  45.688  43.683  1.00 35.83           C
ATOM    108  N6    A A   5      61.110  46.688  44.232  1.00 32.66           N
ATOM    109  N1    A A   5      61.233  45.057  42.644  1.00 35.14           N
ATOM    110  C2    A A   5      61.870  44.017  42.074  1.00 38.97           C
ATOM    111  N3    A A   5      63.024  43.467  42.399  1.00 36.02           N
ATOM    112  C4    A A   5      63.571  44.119  43.437  1.00 39.04           C
ATOM    113  P     U A   6      69.150  45.179  41.392  1.00 55.09           P
ATOM    114  O1P   U A   6      70.511  44.926  40.836  1.00 56.37           O
ATOM    115  O2P   U A   6      68.953  46.283  42.381  1.00 51.00           O
ATOM    116  O5*   U A   6      68.119  45.358  40.184  1.00 50.38           O
ATOM    117  C5*   U A   6      67.912  44.271  39.258  1.00 48.10           C
ATOM    118  C4*   U A   6      66.579  44.400  38.565  1.00 47.17           C
ATOM    119  O4*   U A   6      65.486  44.324  39.513  1.00 46.61           O
ATOM    120  C3*   U A   6      66.344  45.708  37.850  1.00 45.27           C
ATOM    121  O3*   U A   6      66.964  45.696  36.590  1.00 45.77           O
ATOM    122  C2*   U A   6      64.833  45.733  37.727  1.00 45.88           C
ATOM    123  O2*   U A   6      64.431  44.864  36.684  1.00 44.33           O
ATOM    124  C1*   U A   6      64.413  45.113  39.057  1.00 41.32           C
ATOM    125  N1    U A   6      64.065  46.111  40.079  1.00 39.88           N
ATOM    126  C2    U A   6      62.798  46.658  39.977  1.00 36.06           C
ATOM    127  O2    U A   6      62.021  46.333  39.099  1.00 38.25           O
ATOM    128  N3    U A   6      62.487  47.582  40.924  1.00 34.15           N
ATOM    129  C4    U A   6      63.272  48.002  41.975  1.00 37.36           C
ATOM    130  O4    U A   6      62.822  48.829  42.752  1.00 39.30           O
ATOM    131  C5    U A   6      64.583  47.395  42.032  1.00 39.23           C
ATOM    132  C6    U A   6      64.926  46.497  41.084  1.00 35.72           C
ATOM    133  P     U A   7      67.463  47.074  35.969  1.00 44.37           P
ATOM    134  O1P   U A   7      68.318  46.756  34.822  1.00 48.09           O
ATOM    135  O2P   U A   7      67.945  47.948  37.077  1.00 45.68           O
ATOM    136  O5*   U A   7      66.104  47.724  35.455  1.00 40.88           O
ATOM    137  C5*   U A   7      65.285  47.024  34.459  1.00 37.89           C
ATOM    138  C4*   U A   7      64.055  47.852  34.101  1.00 35.74           C
ATOM    139  O4*   U A   7      63.297  48.107  35.326  1.00 38.13           O
ATOM    140  C3*   U A   7      64.317  49.197  33.459  1.00 36.87           C
ATOM    141  O3*   U A   7      63.402  49.394  32.378  1.00 37.45           O
ATOM    142  C2*   U A   7      64.097  50.171  34.624  1.00 36.55           C
ATOM    143  O2*   U A   7      63.595  51.417  34.246  1.00 35.54           O
ATOM    144  C1*   U A   7      63.015  49.475  35.442  1.00 37.23           C
ATOM    145  N1    U A   7      63.056  49.858  36.864  1.00 36.91           N
ATOM    146  C2    U A   7      62.011  50.628  37.343  1.00 34.52           C
ATOM    147  O2    U A   7      61.087  50.966  36.653  1.00 34.65           O
ATOM    148  N3    U A   7      62.112  50.993  38.659  1.00 37.03           N
ATOM    149  C4    U A   7      63.131  50.684  39.541  1.00 40.15           C
ATOM    150  O4    U A   7      63.105  51.143  40.699  1.00 36.62           O
ATOM    151  C5    U A   7      64.179  49.865  38.971  1.00 36.52           C
ATOM    152  C6    U A   7      64.106  49.490  37.691  1.00 36.25           C
ATOM    153  P     U A   8      63.884  49.282  30.858  1.00 36.77           P
ATOM    154  O1P   U A   8      62.852  49.899  29.952  1.00 38.95           O
ATOM    155  O2P   U A   8      64.442  47.955  30.547  1.00 38.70           O
ATOM    156  O5*   U A   8      65.171  50.254  30.733  1.00 35.95           O
ATOM    157  C5*   U A   8      64.994  51.676  30.500  1.00 33.53           C
ATOM    158  C4*   U A   8      66.105  52.236  29.628  1.00 34.33           C
ATOM    159  O4*   U A   8      67.428  52.119  30.261  1.00 31.81           O
ATOM    160  C3*   U A   8      66.269  51.519  28.297  1.00 30.21           C
ATOM    161  O3*   U A   8      65.321  51.887  27.314  1.00 32.41           O
ATOM    162  C2*   U A   8      67.685  51.906  27.900  1.00 31.37           C
ATOM    163  O2*   U A   8      67.743  53.224  27.433  1.00 27.02           O
ATOM    164  C1*   U A   8      68.407  51.830  29.255  1.00 30.28           C
ATOM    165  N1    U A   8      68.914  50.469  29.501  1.00 28.11           N
ATOM    166  C2    U A   8      70.125  50.078  28.931  1.00 29.25           C
ATOM    167  O2    U A   8      70.835  50.819  28.278  1.00 27.81           O
ATOM    168  N3    U A   8      70.481  48.778  29.170  1.00 25.94           N
ATOM    169  C4    U A   8      69.808  47.856  29.922  1.00 27.37           C
ATOM    170  O4    U A   8      70.215  46.704  29.963  1.00 32.58           O
ATOM    171  C5    U A   8      68.612  48.328  30.490  1.00 29.58           C
ATOM    172  C6    U A   8      68.214  49.592  30.265  1.00 30.40           C
ATOM    173  P     A A   9      64.755  50.731  26.311  1.00 32.05           P
ATOM    174  O1P   A A   9      63.287  50.736  26.312  1.00 36.52           O
ATOM    175  O2P   A A   9      65.447  49.415  26.519  1.00 31.33           O
ATOM    176  O5*   A A   9      65.221  51.270  24.948  1.00 28.22           O
ATOM    177  C5*   A A   9      64.646  52.433  24.369  1.00 32.91           C
ATOM    178  C4*   A A   9      64.531  52.215  22.904  1.00 32.49           C
ATOM    179  O4*   A A   9      65.887  52.090  22.406  1.00 35.09           O
ATOM    180  C3*   A A   9      63.820  50.923  22.466  1.00 34.41           C
ATOM    181  O3*   A A   9      63.140  51.180  21.236  1.00 36.11           O
ATOM    182  C2*   A A   9      64.979  49.997  22.155  1.00 32.37           C
ATOM    183  O2*   A A   9      64.686  49.016  21.194  1.00 35.87           O
ATOM    184  C1*   A A   9      65.985  50.969  21.571  1.00 28.79           C
ATOM    185  N9    A A   9      67.376  50.497  21.585  1.00 23.84           N
ATOM    186  C8    A A   9      67.851  49.356  22.159  1.00 25.84           C
ATOM    187  N7    A A   9      69.149  49.195  22.010  1.00 26.83           N
ATOM    188  C5    A A   9      69.527  50.298  21.288  1.00 23.87           C
ATOM    189  C6    A A   9      70.730  50.663  20.793  1.00 30.26           C
ATOM    190  N6    A A   9      71.797  49.922  20.994  1.00 30.95           N
ATOM    191  N1    A A   9      70.817  51.794  20.072  1.00 28.29           N
ATOM    192  C2    A A   9      69.701  52.547  19.932  1.00 32.68           C
ATOM    193  N3    A A   9      68.469  52.287  20.369  1.00 25.13           N
ATOM    194  C4    A A   9      68.446  51.117  21.026  1.00 26.68           C
'''

def main():
  pdb_inp = pdb.input(lines=pdb_1ehz, source_info='model_1ehz')
  pdb_hierarchy = pdb_inp.construct_hierarchy()
  geometry_restraints_manager = get_geometry_restraints_manager(raw_records=pdb_1ehz)
  pdb_hierarchy.reset_i_seq_if_necessary()
  from mmtbx.conformation_dependent_library import generate_dna_rna_fragments
  for k in range(2,3):
    for j, threes in enumerate(generate_dna_rna_fragments(
      pdb_hierarchy,
      geometry_restraints_manager,
      length=k,
      #verbose=True,
      )):
      print(k,j,threes)
      print(threes.get_base_types())
      print(threes.get_ntc_angles())

if __name__ == '__main__':
  main()
