if (typeof Test === 'undefined') require('../tester');

Test('toString', function () {
    //var alphabet = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$_';

    function t(expected, value, base) {
        //if (base) BigNumber.config({ ALPHABET: alphabet.slice(0, base) });
        Test.areEqual(expected, new BigNumber(value).toString(base))
    }

    BigNumber.config({
        DECIMAL_PLACES: 20,
        ROUNDING_MODE: 4,
        RANGE: 1E9,
        EXPONENTIAL_AT: 1E9,
        ALPHABET: '0123456789abcdefghijklmnopqrstuvwxyz'
    });

    t('NaN', NaN);
    t('Infinity', 1/0);
    t('-Infinity', -1/0);
    t('0', 0);
    t('9', 9);
    t('90', 90);
    t('90.12', 90.12);
    t('0.1', 0.1);
    t('0.01', 0.01);
    t('0.0123', 0.0123);
    t('111111111111111111111',   '111111111111111111111');
    t('1111111111111111111111',  '1111111111111111111111');
    t('11111111111111111111111', '11111111111111111111111');
    t('0.00001', 0.00001);
    t('0.000001', 0.000001);

    BigNumber.config({EXPONENTIAL_AT: 0});

    t('1e-7', 0.0000001);
    t('1.2e-7', 0.00000012);
    t('1.23e-7', 0.000000123);
    t('1e-8', 0.00000001);
    t('1.2e-8', 0.000000012);
    t('1.23e-8', 0.0000000123);
    t('-1e-7', -0.0000001);
    t('-1.2e-7', -0.00000012);
    t('-1.23e-7', -0.000000123);
    t('-1e-8', -0.00000001);
    t('-1.2e-8', -0.000000012);
    t('-1.23e-8', -0.0000000123);

    BigNumber.config({EXPONENTIAL_AT: 60});

    t('0', -0);
    t('-9', -9);
    t('-90', -90);
    t('-90.12', -90.12);
    t('-0.1', -0.1);
    t('-0.01', -0.01);
    t('-0.0123', -0.0123);
    t('-111111111111111111111',  '-111111111111111111111');
    t('-1111111111111111111111', '-1111111111111111111111');
    t('-11111111111111111111111', '-11111111111111111111111');
    t('-0.00001', -0.00001);
    t('-0.000001', -0.000001);

    t('NaN', NaN, 16);
    t('Infinity', 1/0, 16);
    t('-Infinity', -1/0, 16);
    t('0', 0, 16);
    t('9', 9, 16);
    t('5a', 90, 16);

    t('0', -0, 16);
    t('-9', -9, 16);
    t('-5a', -90, 16);
    t('4294967296', Math.pow(2,32), undefined);
    t('ffffffff', Math.pow(2,32)-1, 16);
    t('11111111111111111111111111111111', Math.pow(2,32)-1, 2);
    t('100000000000000000000000000000000', Math.pow(2,32), 2);
    t('100000000000000000000000000000001', Math.pow(2,32) + 1, 2);
    t('-11111111111111111111111111111111', -(Math.pow(2,32)-1), 2);
    t('-100000000000000000000000000000000', -Math.pow(2,32), 2);
    t('-100000000000000000000000000000001', -(Math.pow(2,32) + 1), 2);

    t('5yc1z', 10000007, 36);
    t('0', 0, 36);
    t('0', 0, 16);
    t('0', 0, 10);
    t('0', 0, 8);
    t('0', 0, 2);

    t('-5yc1z', -10000007, 36);
    t('1000', 1000, undefined);
    t('0.00001', 0.00001, undefined);
    t('1000000000000000128', '1000000000000000128', undefined);
    t('0.000001', 0.000001, undefined);
    t('8.8', 8.5, 16);
    t('-8.8', -8.5, 16);

    // 1000 toString to exponential format tests

    BigNumber.config({EXPONENTIAL_AT: 0});

    t('5.73447902457635174479825134e+14', '573447902457635.174479825134');
    t('1.07688e+1', '10.7688');
    t('3.171194102379077141557759899307946350455841e+27', '3171194102379077141557759899.307946350455841');
    t('4.924353466898191177698653319742594890634579e+37', '49243534668981911776986533197425948906.34579');
    t('6.85558243926569397328633907445409866949445343654692955e+18', '6855582439265693973.28633907445409866949445343654692955');
    t('1e+0', '1');
    t('2.1320000803e+7', '21320000.803');
    t('5.0878741e+4', '50878.741');
    t('5.1932898288391e+8', '519328982.88391');
    t('5.690616778176956027307884725933410349604387915634524e+49', '56906167781769560273078847259334103496043879156345.24');
    t('3.25099780528575457273246693147645e+15', '3250997805285754.572732466931476450');
    t('3e+0', '3');
    t('2.5811494197573291905990947355226e+13', '25811494197573.291905990947355226');
    t('5.60372259169833930471746454125e+13', '56037225916983.3930471746454125');
    t('1.2615810663732236602461593613783e+7', '12615810.663732236602461593613783');
    t('1.4654366449266911507705477499035407722184965108377032e+11', '146543664492.66911507705477499035407722184965108377032');
    t('6.4986735507448912857131832908423940757e+38', '649867355074489128571318329084239407570.0');
    t('3.6146989180120676857245474944e+3', '3614.6989180120676857245474944');
    t('9.928654762302286149994896625074e+4', '99286.54762302286149994896625074');
    t('3.46424170787806074650506079e+3', '3464.24170787806074650506079');
    t('1.25934313355319666474752550204680303068865719647e+33', '1259343133553196664747525502046803.03068865719647');
    t('1.23014105337660651106978059198916100450966081493207e+27', '1230141053376606511069780591.98916100450966081493207');
    t('1.386164712267169624993434287237e+23', '138616471226716962499343.4287237');
    t('2.66076369930322488334961932e+3', '2660.76369930322488334961932');
    t('9.37582568e+4', '93758.2568');
    t('1.39853642894726883996875746770529e+28', '13985364289472688399687574677.0529');
    t('3.19099e+5', '319099.0');
    t('3.04557106798789396303998723e+19', '30455710679878939630.3998723');
    t('1.3024612569115368830867934222004329653604418e+9', '1302461256.9115368830867934222004329653604418');
    t('2.358787483447172786e+5', '235878.7483447172786');
    t('5.10614446965318674547416709785208086304398889160563e+28', '51061444696531867454741670978.5208086304398889160563');
    t('1.46685947134456101512731611558e+23', '146685947134456101512731.6115580');
    t('3.69960105771344554151928256518906564810300119e+25', '36996010577134455415192825.6518906564810300119');
    t('2.68683153074628e+10', '26868315307.4628');
    t('2.35656504568492312232737219553793859212e+15', '2356565045684923.12232737219553793859212');
    t('7.753292442361215e+14', '775329244236121.5');
    t('1.56e+0', '1.56');
    t('1.272818730367215461852227991200704e+21', '1272818730367215461852.227991200704');
    t('1.13900700292988027871648046839423153789e+7', '11390070.0292988027871648046839423153789');
    t('3.3431e+0', '3.3431');
    t('1.4546654966819402705e+14', '145466549668194.02705');
    t('3.05345735395805567424714891401667575466462830113819e+48', '3053457353958055674247148914016675754664628301138.19');
    t('5.1218945854639324441304933666460587e+2', '512.18945854639324441304933666460587');
    t('9.95299900896e+5', '995299.9008960');
    t('1.21564537151562431991786620635e+0', '1.21564537151562431991786620635');
    t('4.016e+1', '40.16');
    t('1.86570326e+7', '18657032.6');
    t('1.3381001727e+5', '133810.01727');
    t('2.639841700687441886800225725227e+12', '2639841700687.441886800225725227');
    t('2.45e+0', '2.45');
    t('2.8945e+2', '289.45');
    t('1.23e+0', '1.23');
    t('1.559806666149836070330006415033e+24', '1559806666149836070330006.415033');
    t('3.14984566145310751826289711761375061645611777700983e+3', '3149.84566145310751826289711761375061645611777700983');
    t('3.0940691333892283249774116223987e+5', '309406.91333892283249774116223987');
    t('6.572766274013360381079275191108732606370177179594282e+5', '657276.6274013360381079275191108732606370177179594282');
    t('1.470126973337024e+6', '1470126.973337024');
    t('5.6499e+2', '564.99');
    t('2.8416297367859233303497847667971781197616950846e+28', '28416297367859233303497847667.971781197616950846');
    t('2.1364951568189836563102481625533538320051163977e+41', '213649515681898365631024816255335383200511.63977');
    t('8.76108618687537137080904679797e+19', '87610861868753713708.0904679797');
    t('6.27683573474251182408654509953633505286e+6', '6276835.73474251182408654509953633505286');
    t('8.91411e+0', '8.91411');
    t('9.034542832410912578330021146413119399e+28', '90345428324109125783300211464.13119399');
    t('7.026094393430852002585511641212897686956090955e+39', '7026094393430852002585511641212897686956.090955');
    t('1.8812221093491505758565988678062e+11', '188122210934.91505758565988678062');
    t('9.435538492497050138580201734902181057468044875e+43', '94355384924970501385802017349021810574680448.75');
    t('5.36793419620790391866461e+20', '536793419620790391866.461');
    t('2.315089265590404012562599592854156357726817712e+26', '231508926559040401256259959.2854156357726817712');
    t('7.499170741828885273030006066196546588710962e+17', '749917074182888527.3030006066196546588710962');
    t('3.3962128305986e+5', '339621.28305986');
    t('8.17980456510031304e+9', '8179804565.10031304');
    t('4.394575876858124185382e+13', '43945758768581.24185382');
    t('7.881617323629751701107428e+9', '7881617323.629751701107428');
    t('4.89e+0', '4.89');
    t('9.85209894663520857685703881781194082356123765e+39', '9852098946635208576857038817811940823561.23765');
    t('6.849329685e+5', '684932.9685');
    t('2.8262252277815736355279617243060700437627773361e+7', '28262252.277815736355279617243060700437627773361');
    t('1.503736721902e+9', '1503736721.902');
    t('2.65213505469049775997232325076980590625670234690917845e+41', '265213505469049775997232325076980590625670.234690917845');
    t('4.23752645959719196604760963802412828187442060555521e+2', '423.752645959719196604760963802412828187442060555521');
    t('9.023159535576504097005203913521871601640521009e+36', '9023159535576504097005203913521871601.640521009');
    t('4.69339457186380276410136272120035011198438772754725e+14', '469339457186380.276410136272120035011198438772754725');
    t('1.2819429130391792511503973184804508867728894e+6', '1281942.9130391792511503973184804508867728894');
    t('1.9778e+3', '1977.8');
    t('2.456680359828937628024631306792185367572610021e+43', '24566803598289376280246313067921853675726100.21');
    t('5.25389225018085571689046925802871155628e+1', '52.5389225018085571689046925802871155628');
    t('1.733700532107e+8', '173370053.2107');
    t('1.9561099921e+5', '195610.99921');
    t('3.3409e+2', '334.09');
    t('6.09858715556186e+0', '6.09858715556186');
    t('3.20634106832106387482375790792609337383007782520694e+24', '3206341068321063874823757.90792609337383007782520694');
    t('1.46347126003930100207988814e+20', '146347126003930100207.98881400');
    t('2.717780449744210117995586561524987067807146882e+43', '27177804497442101179955865615249870678071468.82');
    t('2.86757572635270377540170639151e+22', '28675757263527037754017.0639151');
    t('3.3652257e+4', '33652.2570');
    t('1.161511687e+2', '116.1511687');
    t('3.38745832e+4', '33874.5832');
    t('1.2392653444609372603987061e+0', '1.2392653444609372603987061');
    t('3.2863728114574403555642096129516601553115371e+19', '32863728114574403555.642096129516601553115371');
    t('1.08862827358094757110520739146065028362703e+30', '1088628273580947571105207391460.65028362703');
    t('1.3488325541508602487577920722101277063863557818e+14', '134883255415086.02487577920722101277063863557818');
    t('1.96013732736436392e+13', '19601373273643.6392');
    t('4.798185890466e+2', '479.8185890466');
    t('1.696622337138949329874242519485119916519994150606e+39', '1696622337138949329874242519485119916519.994150606');
    t('5.50000572984970761183142593570950897913860587074643e+13', '55000057298497.0761183142593570950897913860587074643');
    t('4.9e+1', '49');
    t('2.353405108244768666141e+9', '2353405108.2447686661410');
    t('1.237978927714857736527530290155529e+0', '1.237978927714857736527530290155529');
    t('5.54113012e+1', '55.411301200');
    t('1.639709023131e+11', '163970902313.1');
    t('6.771810210029143571341e+20', '677181021002914357134.1');
    t('3.3659315728946599002939955548637694037e+13', '33659315728946.599002939955548637694037');
    t('5.448485697437811e+14', '544848569743781.1');
    t('2.93450799e+0', '2.93450799');
    t('4e+0', '4');
    t('5.751e+0', '5.751');
    t('7.61737213065110411e+15', '7617372130651104.110');
    t('4.958075942313945962737499249994583773691625306e+36', '4958075942313945962737499249994583773.691625306');
    t('1.358378342e+8', '135837834.20');
    t('2.048052995889503e+13', '20480529958895.03');
    t('6.79076388323848653822758720940258493627501e+10', '67907638832.38486538227587209402584936275010');
    t('8.67210047206219429882716380856729877038463e+37', '86721004720621942988271638085672987703.8463');
    t('3.5856103826876870700739098996695255188137082852345623e+4', '35856.103826876870700739098996695255188137082852345623');
    t('1.90496213987796617338452467459794976917964545462658e+15', '1904962139877966.17338452467459794976917964545462658');
    t('9.63174575036950144769050367165741e+0', '9.63174575036950144769050367165741');
    t('2.0768e+0', '2.0768');
    t('1.456779888489820409831915e+18', '1456779888489820409.831915');
    t('3.17858204994255447e+11', '317858204994.255447');
    t('1e+0', '1');
    t('1.9096483361096593551745691e+3', '1909.64833610965935517456910');
    t('1.06782878549e+8', '106782878.5490');
    t('1.939e+2', '193.9');
    t('1.35467074874780607458660332165839e+30', '1354670748747806074586603321658.39');
    t('1.3477262091e+0', '1.3477262091');
    t('1.310111103174762e+6', '1310111.103174762');
    t('1.3244499e+5', '132444.99');
    t('6.328608643684925104652431120058467829483124155656848e+5', '632860.86436849251046524311200584678294831241556568480');
    t('1.323139209814658927313821930784171e+3', '1323.1392098146589273138219307841710');
    t('4.47797097399588837e+9', '4477970973.995888370');
    t('1.443414e+4', '14434.14');
    t('1.913095284076879e+12', '1913095284076.879');
    t('2.51586474e+0', '2.51586474');
    t('2.9838935573505166030799e+9', '2983893557.3505166030799');
    t('1.573964479962393720481520537831844728449363575e+7', '15739644.79962393720481520537831844728449363575');
    t('2.496378e+2', '249.6378');
    t('1.484378e+0', '1.484378');
    t('5.21963089810195859130639819168579622e+24', '5219630898101958591306398.19168579622');
    t('1.8688440918945220036354844302195749309220888e+26', '186884409189452200363548443.02195749309220888');
    t('1.41126696817890014e+9', '1411266968.17890014');
    t('1.293182137273764465174297382284293177743591308e+15', '1293182137273764.465174297382284293177743591308');
    t('1.27466702071873897014853508266774e+7', '12746670.2071873897014853508266774');
    t('2.556582211914618427489836174964272160475e+25', '25565822119146184274898361.74964272160475');
    t('7.4140139575523848563560806694561950037847e+26', '741401395755238485635608066.94561950037847');
    t('1.9191049758936644006660416648962209488e+24', '1919104975893664400666041.66489622094880');
    t('2.31987505124515790876372807554587171781e+6', '2319875.05124515790876372807554587171781');
    t('1.15157815434449204928983e+10', '11515781543.4449204928983');
    t('3e+0', '3');
    t('2.917143980403974745273363447e+0', '2.917143980403974745273363447');
    t('4.191515340588519451276037876335997588593916166223e+8', '419151534.0588519451276037876335997588593916166223');
    t('1.5893308320910765122063972428358196502e+36', '1589330832091076512206397242835819650.2');
    t('1.564871863334923e+9', '1564871863.334923');
    t('3.4443994941943243107512237423766787557718741016702e+7', '34443994.941943243107512237423766787557718741016702');
    t('2.082688546929e+2', '208.2688546929');
    t('2.9839569879261869701414e+14', '298395698792618.69701414');
    t('1.18e+0', '1.18');
    t('4.649099416086369391962725101452597532757447601493062e+15', '4649099416086369.391962725101452597532757447601493062');
    t('5.1e+1', '51.0');
    t('1.350769554904381289856048945926109233407469025099095e+35', '135076955490438128985604894592610923.3407469025099095');
    t('1.28e+0', '1.28');
    t('1.686998748044557678256738078e+11', '168699874804.4557678256738078');
    t('2.725058665831622653286e+15', '2725058665831622.653286');
    t('3.4955955888709903930650733178004053283303e+27', '3495595588870990393065073317.8004053283303');
    t('2.71792743712e+3', '2717.92743712');
    t('3.765499741127994356229674741445362678695091917e+28', '37654997411279943562296747414.453626786950919170');
    t('8.48094736645795433828545542478643430012741252784e+2', '848.0947366457954338285455424786434300127412527840');
    t('3.252259575976e+8', '325225957.5976');
    t('3.6168564360780068610016611e+13', '36168564360780.0686100166110');
    t('1.3606305591180828419826623450927437361732403593e+14', '136063055911808.28419826623450927437361732403593');
    t('3.770936274989628272472264790077542e+21', '3770936274989628272472.264790077542');
    t('7.2511003873049904808574871389e+2', '725.11003873049904808574871389');
    t('6.62710314240271241900085261e+21', '6627103142402712419000.85261');
    t('7.5663149e+5', '756631.49');
    t('1.2062059e+1', '12.0620590');
    t('1.316934076085443594506478729911134464048168888698e+42', '1316934076085443594506478729911134464048168.888698');
    t('1.202953883353175026243055281903766950596e+16', '12029538833531750.26243055281903766950596');
    t('5.15639495337093127431811770279915335410152998e+4', '51563.9495337093127431811770279915335410152998');
    t('1.8e+1', '18');
    t('2.9510339604105305444519680156145845428324011e+35', '295103396041053054445196801561458454.28324011');
    t('9.991e+0', '9.991');
    t('2.32664625710064626302675792506518986748623800519362825e+45', '2326646257100646263026757925065189867486238005.19362825');
    t('1.15155883503801901e+9', '1151558835.03801901');
    t('2.3143e+1', '23.143');
    t('2.260422939172634138149555333552819e+1', '22.60422939172634138149555333552819');
    t('1.77998238e+7', '17799823.8');
    t('3.70098549253330116100410970723706977e+9', '3700985492.53330116100410970723706977');
    t('9.05841068683497571038524585222884373e+29', '905841068683497571038524585222.884373');
    t('2.104525700707071438146923949322482428742115356534e+28', '21045257007070714381469239493.22482428742115356534');
    t('7.024685053227353728838050757013069476546171879163e+24', '7024685053227353728838050.757013069476546171879163');
    t('4.46125872195266e+10', '44612587219.5266');
    t('1.5784e+0', '1.5784');
    t('7.2863751084180259357725026103712116366349e+23', '728637510841802593577250.26103712116366349');
    t('3.8320639752835419309258317842615e+19', '38320639752835419309.258317842615');
    t('5.022803549739540204835955185781e+8', '502280354.9739540204835955185781');
    t('1.52375875990883568458394783820252654691082e+8', '152375875.990883568458394783820252654691082');
    t('6.3061015767881141717464891e+15', '6306101576788114.1717464891');
    t('9.71891517062070497407760297561206525471485e+27', '9718915170620704974077602975.61206525471485');
    t('1.734234585265201766712574126945236309508118634425837e+0', '1.734234585265201766712574126945236309508118634425837');
    t('8.5765119797384477995e+4', '85765.119797384477995');
    t('5.13287988277059925228486890851140970386425187274e+8', '513287988.2770599252284868908511409703864251872740');
    t('1.658649165479737672749860660622867246548e+15', '1658649165479737.672749860660622867246548');
    t('3.4292698700438468428249935453830307216008845443e+3', '3429.2698700438468428249935453830307216008845443');
    t('6.4741508681889057488168545664375944171354681e+23', '647415086818890574881685.45664375944171354681');
    t('1.6942797476135028024654429183339522530812281e+31', '16942797476135028024654429183339.522530812281');
    t('4.2751009447385333857937408636958425779826e+4', '42751.009447385333857937408636958425779826');
    t('8.171245315549501039363411728044907e+8', '817124531.5549501039363411728044907');
    t('2.63956757213151457264967446772106e+14', '263956757213151.457264967446772106');
    t('5.613736432461e+9', '5613736432.461');
    t('4.78814e+3', '4788.14');
    t('4e+0', '4');
    t('4.37173137694e+3', '4371.73137694');
    t('2.2510403748584e+3', '2251.0403748584');
    t('5.06031783713235771e+6', '5060317.83713235771');
    t('1.33505152823751921282350949461e+18', '1335051528237519212.82350949461');
    t('7.600277071910098554342026310498032154036e+17', '760027707191009855.4342026310498032154036');
    t('1.876325989370064932735123485260012703584e+17', '187632598937006493.27351234852600127035840');
    t('3.87899618892199653560586133205982498365799449e+27', '3878996188921996535605861332.05982498365799449');
    t('6.2615173898555524447350478811537912100608066376e+42', '6261517389855552444735047881153791210060806.6376');
    t('9.413311009646174266728687126e+7', '94133110.09646174266728687126');
    t('1.2598016462494915983919933836115811e+13', '12598016462494.915983919933836115811');
    t('7.9083335654128601227093e+3', '7908.3335654128601227093');
    t('1.1816683721169472338636e+3', '1181.6683721169472338636');
    t('2.75369819574089239438702064921012202e+10', '27536981957.4089239438702064921012202');
    t('8.23458259735325932383e+10', '82345825973.5325932383');
    t('9.79385e+1', '97.9385');
    t('1e+0', '1');
    t('1.054786033040309868462e+15', '1054786033040309.868462');
    t('1.39529250356370349e+10', '13952925035.6370349');
    t('3.287519212843337e+8', '328751921.2843337');
    t('2.931680954526563928e+2', '293.1680954526563928');
    t('8.34563827640030036035405e+22', '83456382764003003603540.5');
    t('3.205638487e+0', '3.205638487');
    t('8.347784116251624503148e+14', '834778411625162.4503148');
    t('8.0108273810982547100003003762e+5', '801082.73810982547100003003762');
    t('5.41874345499627242543460793e+17', '541874345499627242.543460793');
    t('1.015683737878128e+2', '101.56837378781280');
    t('2.978259746276619202256565093853146061976952e+15', '2978259746276619.202256565093853146061976952');
    t('9.698293249507073809003898936542180557347147e+18', '9698293249507073809.003898936542180557347147');
    t('5.73284757676406662905522205317450204e+31', '57328475767640666290552220531745.0204');
    t('1.09314948671137385444979381052e+26', '109314948671137385444979381.052');
    t('6.657213e+1', '66.57213');
    t('5.442667e+0', '5.442667');
    t('1.497094368112928522082161622117e+17', '149709436811292852.2082161622117');
    t('8.86015267575800230944962406406137570452e+28', '88601526757580023094496240640.6137570452');
    t('8.7435115902725784785213467357972025071925716822259e+38', '874351159027257847852134673579720250719.25716822259');
    t('3.758112653964719298306554363807932e+15', '3758112653964719.298306554363807932');
    t('3.083180493316158e+7', '30831804.93316158');
    t('6.6753482e+1', '66.753482');
    t('1.511686617338690801597376192985164124335711475e+36', '1511686617338690801597376192985164124.335711475');
    t('2.561637088433158358807278932196e+1', '25.61637088433158358807278932196');
    t('9.7542804053855981164860021065e+18', '9754280405385598116.4860021065');
    t('3.862183052662673704009308528932528900914181684535e+42', '3862183052662673704009308528932528900914181.684535');
    t('1.735e+0', '1.735');
    t('1.68459549759090470803341044524240531008376812e+5', '168459.549759090470803341044524240531008376812');
    t('5.7719373345538594618757e+18', '5771937334553859461.8757');
    t('3.6601007679275500170303e+18', '3660100767927550017.0303');
    t('8.33735150265611827e+5', '833735.150265611827');
    t('1.01871087828059263083e+9', '1018710878.28059263083');
    t('1.730763e+3', '1730.763');
    t('2.0215513523e+6', '2021551.3523');
    t('3.169677580608477341e+6', '3169677.580608477341');
    t('1.36121484062885200254669e+8', '136121484.062885200254669');
    t('1.864593865698e+11', '186459386569.8');
    t('3.862360154857656116978304538802550298055142749413e+37', '38623601548576561169783045388025502980.55142749413');
    t('6.344348248e+6', '6344348.248');
    t('8.67366546264e+2', '867.366546264');
    t('4.29318860328279804558512081958216849305249e+4', '42931.8860328279804558512081958216849305249');
    t('4.5767492969936218926613265e+5', '457674.92969936218926613265');
    t('9.965617933646541e+10', '99656179336.46541');
    t('7.664031929445646163953676864248019955392457435e+19', '76640319294456461639.53676864248019955392457435');
    t('1.7557601024183018471184139748851879933153788645e+26', '175576010241830184711841397.48851879933153788645');
    t('3.59958e+1', '35.9958');
    t('3.128356271716333383085523918507809249225814121e+6', '3128356.271716333383085523918507809249225814121');
    t('1.9075527480204423875673047345572289921671553543e+7', '19075527.480204423875673047345572289921671553543');
    t('4.1705118500557863903425612212241828e+28', '41705118500557863903425612212.241828');
    t('1.18254857176614357421149713005254203068839516120630636e+10', '11825485717.6614357421149713005254203068839516120630636');
    t('7.02259913337121409861924646773988297e+3', '7022.599133371214098619246467739882970');
    t('1.146737732876241016454570289690559455455987995125423e+18', '1146737732876241016.454570289690559455455987995125423');
    t('1.355148008848587e+12', '1355148008848.587');
    t('1.015453056007471546100232031232797626130792432862e+30', '1015453056007471546100232031232.797626130792432862');
    t('2.8538363119129962635325743474766089129608347262536e+29', '285383631191299626353257434747.660891296083472625360');
    t('4.2227811926947467182312527e+0', '4.2227811926947467182312527');
    t('6.62781300059578283068526676555702438949382809379e+11', '662781300059.578283068526676555702438949382809379');
    t('7.132543524075010321e+11', '713254352407.5010321');
    t('2.6891265922739405441935129011630558514535121113e+0', '2.6891265922739405441935129011630558514535121113');
    t('2.6553300042224839703e+7', '26553300.042224839703');
    t('1.326288516626807519348228004e+12', '1326288516626.807519348228004');
    t('0e+0', '0');
    t('6.02519526915223e+9', '6025195269.15223');
    t('3.624787029215766960931977e+8', '362478702.9215766960931977');
    t('2.2216785095018655042906319049394e+10', '22216785095.018655042906319049394');
    t('1.42167287636895617482014385649865679412e+27', '1421672876368956174820143856.49865679412');
    t('1.41165522278933908893e+0', '1.41165522278933908893');
    t('9.6100608486394273371410715209128478362564609e+29', '961006084863942733714107152091.28478362564609');
    t('6.628723659367639746219006678948604246e+24', '6628723659367639746219006.678948604246');
    t('2.7977956855247594e+5', '279779.56855247594');
    t('2.031549e+5', '203154.9');
    t('1.255931797e+8', '125593179.7');
    t('5.6205236102596850984322041097e+16', '56205236102596850.9843220410970');
    t('2.03142821417788742960492e+19', '20314282141778874296.0492');
    t('1.91781433973790573018323517395847264353e+35', '191781433973790573018323517395847264.35300');
    t('6.8634738969456114664748639548209064365603770815e+10', '68634738969.456114664748639548209064365603770815');
    t('2.4116354386327449757134801702e+5', '241163.54386327449757134801702');
    t('3.36834833123607650204419305291838348810644243e+42', '3368348331236076502044193052918383488106442.43');
    t('1.2854387e+1', '12.854387');
    t('1.71911767411984485012054040057806822618e+28', '17191176741198448501205404005.7806822618');
    t('5.974376678071807862297048158076713536908142505051762e+0', '5.974376678071807862297048158076713536908142505051762');
    t('1.75040573368172e+0', '1.75040573368172');
    t('7.59296739794577295967023894e+19', '75929673979457729596.7023894');
    t('5.9387271258615e+0', '5.9387271258615');
    t('1.41e+1', '14.1');
    t('6.520718977022294517603438651524e+13', '65207189770222.94517603438651524');
    t('4.0504464748488527e+13', '40504464748488.527');
    t('4.9339025e+4', '49339.025');
    t('6.5436938338545276642922e+5', '654369.38338545276642922');
    t('6.614070881259392274974020452736433936484946441479e+14', '661407088125939.2274974020452736433936484946441479');
    t('3.6562357737624542715177216071738074863798786e+36', '3656235773762454271517721607173807486.3798786');
    t('4.483580186204558328366014e+16', '44835801862045583.28366014');
    t('8.786e+1', '87.86');
    t('3.2320103419855255742057273942480043987e+6', '3232010.3419855255742057273942480043987');
    t('4.46656766000098808044857967014414e+16', '44665676600009880.8044857967014414');
    t('1.02292056093528342365e+13', '10229205609352.8342365');
    t('8.57520635819763350659219863901837233e+21', '8575206358197633506592.19863901837233');
    t('1.245913688722124452316952395765916246e+21', '1245913688722124452316.9523957659162460');
    t('8.8964578294856908705314945178917896807516003057782324e+46', '88964578294856908705314945178917896807516003057.782324');
    t('8.7449512208056038986439889808e+7', '87449512.208056038986439889808');
    t('2.3e+2', '230.0');
    t('1.5579884689150031101693496143656840264980386818704e+23', '155798846891500311016934.961436568402649803868187040');
    t('8.5051864582679908692564183699252612773409509082078e+37', '85051864582679908692564183699252612773.409509082078');
    t('8.8798692074080075787375315447486123809923959833e+26', '887986920740800757873753154.47486123809923959833');
    t('6.77345401358539738139850599762127933983100324110805558e+4', '67734.5401358539738139850599762127933983100324110805558');
    t('2.347749726836225014840282995092832754e+20', '234774972683622501484.0282995092832754');
    t('7.429558958688e+0', '7.429558958688');
    t('1.7882214813873e+0', '1.7882214813873');
    t('4.193192196e+6', '4193192.196');
    t('4.749767618513507376588211479214898450387625965e+9', '4749767618.513507376588211479214898450387625965');
    t('1.977391043687779e+5', '197739.1043687779');
    t('2.6484576511218782036901501152986249531234497168718e+40', '26484576511218782036901501152986249531234.497168718');
    t('1.920439145880135238583976259936021e+3', '1920.439145880135238583976259936021');
    t('1.51897109592862249460404e+8', '151897109.592862249460404');
    t('5.0235407304542145031825034116450744076803325e+15', '5023540730454214.5031825034116450744076803325');
    t('7.6404110248649153016903650163544816581006668605e+23', '764041102486491530169036.50163544816581006668605');
    t('3.7874929502138e+0', '3.7874929502138');
    t('1.41787251451628994917275472e+24', '1417872514516289949172754.72');
    t('4.2104854597998748621925225253125873386e+31', '42104854597998748621925225253125.87338600');
    t('1.26567160108986726661104934542275915987889e+7', '12656716.0108986726661104934542275915987889');
    t('2.8968894398808777e+4', '28968.894398808777');
    t('2.8297292e+2', '282.97292');
    t('2.603742338988784570262735209585265906786049e+12', '2603742338988.784570262735209585265906786049');
    t('4.62131e+2', '462.131');
    t('2.22735863520665290933246331848e+24', '2227358635206652909332463.31848');
    t('4.53886361459e+10', '45388636145.9');
    t('6.6860727859954777667223002708162369e+32', '668607278599547776672230027081623.69');
    t('2.8062722e+0', '2.8062722');
    t('6.0842062525063451016806e+10', '60842062525.063451016806');
    t('6.8357371699714755863090081855483865237790749503e+22', '68357371699714755863090.081855483865237790749503');
    t('3.35802101243809011e+10', '33580210124.3809011');
    t('8.43490001143656777280840623008615269579365614931775e+0', '8.43490001143656777280840623008615269579365614931775');
    t('1.9235808728891520564223264242417980260344158021186e+8', '192358087.28891520564223264242417980260344158021186');
    t('1.41994286356037056979411e+12', '1419942863560.37056979411');
    t('1.78557003827723798504978687588959254956675353035516771e+37', '17855700382772379850497868758895925495.6675353035516771');
    t('1.2918168334241255620676751949906289e+11', '129181683342.41255620676751949906289');
    t('3.9318765130442377729598885e+1', '39.318765130442377729598885');
    t('3.88694369953891826304770521327308322619393047272853992e+29', '388694369953891826304770521327.308322619393047272853992');
    t('1.0841221160385599396e+8', '108412211.60385599396');
    t('2.927924105979441123308231e+10', '29279241059.79441123308231');
    t('9.793009327446332791991220439204599563053527e+23', '979300932744633279199122.0439204599563053527');
    t('9.423287306701960190921439346729208723159342075073e+5', '942328.7306701960190921439346729208723159342075073');
    t('9.32095532579704529e+14', '932095532579704.529');
    t('4e+0', '4');
    t('6.53989976127167541385228442576702092890124e+35', '653989976127167541385228442576702092.89012400');
    t('1.19250623478e+7', '11925062.3478');
    t('1.865458672e+0', '1.865458672');
    t('3.316183057661896194198642778725380227773158022030233e+12', '3316183057661.896194198642778725380227773158022030233');
    t('8.5601184555567625475596670332086089588e+15', '8560118455556762.5475596670332086089588');
    t('1.80118254923064703459780878790624318318152203e+37', '18011825492306470345978087879062431831.8152203');
    t('8.31702685620470833413491412813875698623351991849704e+45', '8317026856204708334134914128138756986233519918.49704');
    t('4.158534334648275764e+11', '415853433464.8275764');
    t('2.19723302477e+0', '2.19723302477');
    t('2.029177448999173372119989892440779088e+22', '20291774489991733721199.89892440779088');
    t('4.645682747987148208758271e+14', '464568274798714.8208758271');
    t('2.6112628e+6', '2611262.8');
    t('1.27260908637e+0', '1.27260908637');
    t('2.386528806365172395257137e+5', '238652.88063651723952571370');
    t('2.64450278721870797393766005966148238494e+8', '264450278.721870797393766005966148238494');
    t('1.988688294222795007e+6', '1988688.294222795007');
    t('7.078660611250891118657496594735238821341408353e+35', '707866061125089111865749659473523882.1341408353');
    t('0e+0', '0');
    t('1.096715852238427070115466117322983113926e+36', '1096715852238427070115466117322983113.926');
    t('8.3033913e+4', '83033.913');
    t('4.015204714209691387124917361818013823115690954e+5', '401520.4714209691387124917361818013823115690954');
    t('1.18391666839775944e+9', '1183916668.39775944');
    t('2.2995421984176008066735e+7', '22995421.984176008066735');
    t('9.03e+0', '9.03');
    t('5.332359881257917566876361208399e+0', '5.3323598812579175668763612083990');
    t('7.102133e+3', '7102.133');
    t('1.1483640369724895747740049e+19', '11483640369724895747.740049');
    t('2.86532834287791967206284176556306849118939923884e+42', '2865328342877919672062841765563068491189399.23884');
    t('9.076417888165894607318040129e+17', '907641788816589460.7318040129');
    t('7.3646447223309353153091289569473837758243e+14', '736464472233093.53153091289569473837758243');
    t('2.181883e+4', '21818.83');
    t('3.386300476012467818859167684043147659263155e+9', '3386300476.012467818859167684043147659263155');
    t('2.51484028084025506424805997802620148071482e+13', '25148402808402.55064248059978026201480714820');
    t('9.4435575887407391033782269887533990447300682186075521e+24', '9443557588740739103378226.9887533990447300682186075521');
    t('1.6886715415033e+8', '168867154.15033');
    t('2.5034373528604861134460194872790430617196344388725e+11', '250343735286.04861134460194872790430617196344388725');
    t('2.196175657558897384981748559894e+29', '219617565755889738498174855989.4');
    t('9.76199813364186117286131817353e+8', '976199813.364186117286131817353');
    t('2.19717393409454748689882068559316753929782544245361e+9', '2197173934.09454748689882068559316753929782544245361');
    t('3.458346873044019889e+14', '345834687304401.98890');
    t('1.7224191355912435440309996131683233957399227e+29', '172241913559124354403099961316.83233957399227');
    t('2.9118304597001059668e+13', '29118304597001.0596680');
    t('8.089765204288655830674576596713309516483099e+31', '80897652042886558306745765967133.09516483099');
    t('4.238609505643148138368920789804547924618071e+16', '42386095056431481.38368920789804547924618071');
    t('6.632956460328161742904032219604e+9', '6632956460.328161742904032219604');
    t('5.149280532588990421575423306958842719315081438104696e+2', '514.9280532588990421575423306958842719315081438104696');
    t('2.07166412218470429605806831507e+24', '2071664122184704296058068.31507');
    t('3.074159e+0', '3.074159');
    t('8.881411022677226686076012925366e+8', '888141102.2677226686076012925366');
    t('1.4327673900218857772756403845335511690820534667844161e+25', '14327673900218857772756403.845335511690820534667844161');
    t('8.11258981514701594464134633523542919936061665628845e+9', '8112589815.14701594464134633523542919936061665628845');
    t('5.96685124808828989098666066158574653883332e+34', '59668512480882898909866606615857465.3883332');
    t('5.57183574e+6', '5571835.74');
    t('6.8501903843096e+0', '6.8501903843096');
    t('1.5942819569037073307050366953094e+20', '159428195690370733070.50366953094');
    t('2.27330909197482e+2', '227.330909197482');
    t('2.982752994e+1', '29.82752994');
    t('2.6621448010147457294e+3', '2662.14480101474572940');
    t('1.086669601366824519299e+5', '108666.9601366824519299');
    t('1.18736e+1', '11.8736');
    t('2.529e+2', '252.9');
    t('9.53927547001352070346930665292474419009985922637627e+0', '9.53927547001352070346930665292474419009985922637627');
    t('1.41547817128845761243461584e+17', '141547817128845761.243461584');
    t('4.913427130278990825751597676478e+5', '491342.7130278990825751597676478');
    t('1.92247886737227536336e+7', '19224788.67372275363360');
    t('3.1497590158477647299507840130228337905235603e+22', '31497590158477647299507.840130228337905235603');
    t('1.68055184413854558094765106936369527289778050531295766e+40', '16805518441385455809476510693636952728977.8050531295766');
    t('1.8255321351888780569641286767450275327e+7', '18255321.351888780569641286767450275327');
    t('1.56201751119240301681993262341142444952941e+6', '1562017.51119240301681993262341142444952941');
    t('5.122704714291e+9', '5122704714.291');
    t('3.82474822197843e+12', '3824748221978.43');
    t('1.525347830613268824053492683517588e+9', '1525347830.613268824053492683517588');
    t('6.145278e+4', '61452.78');
    t('4.99832566753824717449034e+0', '4.99832566753824717449034');
    t('1.308323895602314056642638704891037710277185276986927e+40', '13083238956023140566426387048910377102771.85276986927');
    t('5.18915522348e+4', '51891.5522348');
    t('1.4209994e+6', '1420999.4');
    t('1.503265451278288e+7', '15032654.51278288');
    t('3.152117986796142139453802611094289123987929469e+9', '3152117986.796142139453802611094289123987929469');
    t('2.978007679998703216707397018589782695e+13', '29780076799987.03216707397018589782695');
    t('5.8512931044e+7', '58512931.044');
    t('3.295254020832544012761679098484189727227833e+41', '329525402083254401276167909848418972722783.3');
    t('8.72742250969672731429969186796754051463901e+14', '872742250969672.731429969186796754051463901');
    t('2.9072795594202554837396927026502083307998e+35', '290727955942025548373969270265020833.07998');
    t('2.34518496092800925568908809696371538989759e+27', '2345184960928009255689088096.96371538989759');
    t('4.02951776768e+4', '40295.17767680');
    t('1.3689991541714377699994556138826283759e+29', '136899915417143776999945561388.26283759');
    t('5.375319663285375407847169258e+20', '537531966328537540784.71692580');
    t('2.4838816191142589e+0', '2.4838816191142589');
    t('1e+1', '10');
    t('1.32118e+2', '132.118');
    t('3.167368488391197862244748797056311701e+1', '31.6736848839119786224474879705631170100');
    t('1.2923240005675836581430542022e+7', '12923240.005675836581430542022');
    t('2.45198799455822803503200760843340001104401687715e+1', '24.5198799455822803503200760843340001104401687715');
    t('5.017419011122159795604649952660143561601682847055e+9', '5017419011.122159795604649952660143561601682847055');
    t('1.528293223258e+9', '1528293223.258');
    t('3.36806306935615523082781617061106400210297708457466e+40', '33680630693561552308278161706110640021029.7708457466');
    t('2.24276e+4', '22427.6');
    t('1.452908e+5', '145290.8');
    t('1.730864210471288302007789478210233615399858e+21', '1730864210471288302007.789478210233615399858');
    t('1.98572237681530700377986658329680798e+32', '198572237681530700377986658329680.798');
    t('5.3625630032708e+2', '536.25630032708');
    t('1.279811707773498944767714003821019551877654490239992e+40', '12798117077734989447677140038210195518776.54490239992');
    t('1.13478473099428793759e+1', '11.3478473099428793759');
    t('3.8084703153428358911632007387325702215541573567757e+45', '3808470315342835891163200738732570221554157356.7757');
    t('1.63132182288401410656e+16', '16313218228840141.0656');
    t('1.2883403439965987126193143646e+8', '128834034.39965987126193143646');
    t('1.1337344058722593784502983693368481614e+2', '113.3734405872259378450298369336848161400');
    t('1.3810837466649418967673665311541682533151e+37', '13810837466649418967673665311541682533.151');
    t('3e+0', '3');
    t('1.77729190576542704583828487792283968438443988677e+27', '1777291905765427045838284877.92283968438443988677');
    t('1.75045497942020277400523024600228150483494020715374e+39', '1750454979420202774005230246002281504834.94020715374');
    t('9.4295017753469131679077273e+2', '942.95017753469131679077273');
    t('3.854570457401828825080672674176371617252885568525e+42', '3854570457401828825080672674176371617252885.568525');
    t('6.976781259116059962789065637569e+19', '69767812591160599627.89065637569');
    t('1.983953867384017752e+8', '198395386.7384017752');
    t('8.18621623940664383e+3', '8186.21623940664383');
    t('4.678566e+5', '467856.6');
    t('4.37454863655836062626765123683424e+5', '437454.863655836062626765123683424');
    t('7.6e+1', '76');
    t('1.356170189773197190024227714709209e+20', '135617018977319719002.42277147092090');
    t('2.524007970392697273821209419290910149e+32', '252400797039269727382120941929091.0149');
    t('2.2996e+1', '22.996');
    t('9.19536554437673037098591509995026767872538589562761e+45', '9195365544376730370985915099950267678725385895.62761');
    t('7.52981388027044914e+7', '75298138.8027044914');
    t('6.0233392042283e+4', '60233.3920422830');
    t('1.197371690422415645601906387900091876e+8', '119737169.0422415645601906387900091876');
    t('2.5e+0', '2.50');
    t('3.0513e+3', '3051.3');
    t('3.4378929513006354001139704e+1', '34.378929513006354001139704');
    t('2.7688798583863475634e+16', '27688798583863475.634');
    t('3.70733017769177e+3', '3707.33017769177');
    t('1.183552401830090152504539986275312716505e+23', '118355240183009015250453.9986275312716505');
    t('5.5532923555574e+0', '5.5532923555574');
    t('1.007309381e+2', '100.7309381');
    t('4.26e+0', '4.26');
    t('3.49082770706667347770412719905221035269e+36', '3490827707066673477704127199052210352.69');
    t('1.09667668559108738350612984427121459528827e+35', '109667668559108738350612984427121459.528827');
    t('6.7117017423837651934e+2', '671.17017423837651934');
    t('3.5513336510667288609743743e+5', '355133.36510667288609743743');
    t('2.733911637796059758003823848720999245e+12', '2733911637796.059758003823848720999245');
    t('4.7727335155560138656406364912e+21', '4772733515556013865640.6364912');
    t('7.1707742358130425165e+15', '7170774235813042.5165');
    t('1.2373e+0', '1.2373');
    t('1.95864917284678233803922075321436e+16', '19586491728467823.3803922075321436');
    t('1.39511686402859313308703279767446898138923566399e+34', '13951168640285931330870327976744689.8138923566399');
    t('5.45166767236394220015660379974682e+18', '5451667672363942200.15660379974682');
    t('5.7e+1', '57');
    t('2.008185112618419540343890697023120161916064586e+15', '2008185112618419.5403438906970231201619160645860');
    t('1.83547377703310193838625323613810597146659646688e+38', '183547377703310193838625323613810597146.659646688');
    t('1.86963380149e+6', '1869633.80149');
    t('9.0643926657221127599225e+0', '9.0643926657221127599225');
    t('3.387626848249516099010371969816649097243645e+35', '338762684824951609901037196981664909.7243645');
    t('2.38574e+4', '23857.4');
    t('4.854485927348228918413753679671472155071e+35', '485448592734822891841375367967147215.5071');
    t('1.1145412703080371165560398973334199e+32', '111454127030803711655603989733341.99');
    t('1.272285349955021228893214839127637825683e+4', '12722.85349955021228893214839127637825683');
    t('9.4315857521037576638711244118020078159357613e+2', '943.15857521037576638711244118020078159357613');
    t('2.130358009562539933673297313517219743395888826178226e+42', '2130358009562539933673297313517219743395888.826178226');
    t('1.788350524694006198162174980034358528e+19', '17883505246940061981.621749800343585280');
    t('1.26860370623505030126846090707878e+22', '12686037062350503012684.6090707878');
    t('2e+0', '2');
    t('7.97066672594e+7', '79706667.2594');
    t('2.0152e+2', '201.52');
    t('5.00637717193322215204e+6', '5006377.17193322215204');
    t('3.01590120278994390749132552334544583e+0', '3.01590120278994390749132552334544583');
    t('3.717693087339892916526272044454e+24', '3717693087339892916526272.044454');
    t('2.54829661524758873955898224553317416437e+3', '2548.29661524758873955898224553317416437');
    t('7.9072523913538861636033504135822e+1', '79.072523913538861636033504135822');
    t('1.866503037113138887457365815904225e+28', '18665030371131388874573658159.04225');
    t('1.3950429e+5', '139504.29');
    t('1.0207356655e+5', '102073.56655');
    t('3.2360853090691879699503619670118780802618636754e+9', '3236085309.0691879699503619670118780802618636754');
    t('5.47452697575793862266267385061152164e+19', '54745269757579386226.6267385061152164');
    t('6.1014855783682768e+15', '6101485578368276.8');
    t('5.31612911388139343797172e+0', '5.31612911388139343797172');
    t('5.91082171916830390736766017658603922e+26', '591082171916830390736766017.658603922');
    t('2.8172659641631766440010830065e+19', '28172659641631766440.010830065');
    t('4.1202100041496082281283466e+5', '412021.00041496082281283466');
    t('1.976856495373097710107538467325977284465274416e+19', '19768564953730977101.07538467325977284465274416');
    t('1.171504106314324317761655700166834e+32', '117150410631432431776165570016683.4');
    t('1.027537448230010431061775478e+10', '10275374482.30010431061775478');
    t('2.341237435879754661702897098867289936e+3', '2341.237435879754661702897098867289936');
    t('1.0588321785973619575e+15', '1058832178597361.9575');
    t('4.2335454826279360873889814771443479909805203261e+39', '4233545482627936087388981477144347990980.5203261');
    t('4.9e+1', '49');
    t('1.4101138066556191e+0', '1.4101138066556191');
    t('1.3899701029842433287999040786946262e+11', '138997010298.42433287999040786946262');
    t('2.14e+1', '21.4');
    t('2.575344258e+6', '2575344.258');
    t('1.3691520780202966734596879557205614425e+23', '136915207802029667345968.79557205614425');
    t('1.079727307987010933702e+19', '10797273079870109337.02');
    t('7.0961299409455830259875773863405485e+3', '7096.1299409455830259875773863405485');
    t('6.071949209634075943049707175059387500694121405338866e+45', '6071949209634075943049707175059387500694121405.338866');
    t('9.688112361029101083207689619288615989e+17', '968811236102910108.3207689619288615989');
    t('2.80923460488873864236890941794609081552183193e+41', '280923460488873864236890941794609081552183.193');
    t('1.83294035069640418182259900657124e+15', '1832940350696404.181822599006571240');
    t('1.330407118626933239746930889885854606102e+7', '13304071.18626933239746930889885854606102');
    t('8.614745245083701401256805923197041044646493828616208e+22', '86147452450837014012568.05923197041044646493828616208');
    t('1.021162949761147474655069846e+15', '1021162949761147.474655069846');
    t('2.22124197e+6', '2221241.97');
    t('1.9269783432665189582619e+12', '1926978343266.5189582619');
    t('2.4458042e+3', '2445.8042');
    t('1.24442787448470619843211196913235e+6', '1244427.87448470619843211196913235');
    t('6.5795027200660039322532e+7', '65795027.200660039322532');
    t('2.124371034489911604376156663456697624832e+36', '2124371034489911604376156663456697624.832');
    t('4.7518554e+3', '4751.8554');
    t('5.577243873330495803e+5', '557724.3873330495803');
    t('1.4411990735775980636079874248393636e+28', '14411990735775980636079874248.393636');
    t('3.532984961283621176064142e+22', '35329849612836211760641.42');
    t('6.41099968454591750260016248126e+14', '641099968454591.750260016248126');
    t('1.876802099566385814736323517234163782171196608110171e+38', '187680209956638581473632351723416378217.1196608110171');
    t('2.712536235933694424272454724983924750851e+6', '2712536.235933694424272454724983924750851');
    t('1.819734474513556013e+8', '181973447.4513556013');
    t('3.0320484961616175305658133728e+14', '303204849616161.75305658133728');
    t('1.9739814652160018980576469874802639653674373e+38', '197398146521600189805764698748026396536.74373');
    t('6.0551922025938302e+10', '60551922025.938302');
    t('3.323596297e+8', '332359629.7');
    t('5.7458544961785021027335254905977754345607e+38', '574585449617850210273352549059777543456.07');
    t('3.43869507567190104395123310443283792e+2', '343.869507567190104395123310443283792');
    t('3.964855738823341944355183015e+26', '396485573882334194435518301.5');
    t('4.75631864588339215e+12', '4756318645883.39215');
    t('3.1e+1', '31');
    t('3.750923398533815812530175e+17', '375092339853381581.2530175');
    t('1.25649942741256e+2', '125.649942741256');
    t('5.4854980319307537893979503491381982942042465844747093e+45', '5485498031930753789397950349138198294204246584.4747093');
    t('1.2940661791311373e+14', '129406617913113.73');
    t('2.90385571775480031587051447549374193061077e+10', '29038557177.5480031587051447549374193061077');
    t('9.1040729817423482924856979976434906087350486636207e+3', '9104.0729817423482924856979976434906087350486636207');
    t('1.57834489e+4', '15783.4489');
    t('2.319e+2', '231.9');
    t('5.522835788261589143141105742945478589362e+16', '55228357882615891.43141105742945478589362');
    t('8.7417851321101080306727e+15', '8741785132110108.0306727');
    t('9.96e+0', '9.96');
    t('1.343046943929639e+14', '134304694392963.9');
    t('2.21577825581227700070639623743724540952019026803e+0', '2.21577825581227700070639623743724540952019026803');
    t('5.64651860171575748936148456309414e+12', '5646518601715.75748936148456309414');
    t('2.71790519140131463205484467292975145e+33', '2717905191401314632054844672929751.450');
    t('2.46128778261687122384096383441327463273586448997789422e+8', '246128778.261687122384096383441327463273586448997789422');
    t('1.51e+0', '1.510');
    t('1.34417538839677e+6', '1344175.38839677');
    t('1.1967386179518011766805527782003e+0', '1.1967386179518011766805527782003');
    t('3.1240079864434111687577043352352970435153e+8', '312400798.64434111687577043352352970435153');
    t('3.125225939e+3', '3125.2259390');
    t('2.6130649e+4', '26130.649');
    t('6.3203802234999588e+14', '632038022349995.88');
    t('1.300191903723243249151204409158028743867e+5', '130019.1903723243249151204409158028743867');
    t('1.5457655328224382807201057293747835e+28', '15457655328224382807201057293.747835');
    t('2.09985076272906724e+4', '20998.50762729067240');
    t('2.2982784786e+6', '2298278.4786');
    t('2.73013672764e+2', '273.013672764');
    t('7.15593e+3', '7155.93');
    t('1.05530065668194919764462354032281e+20', '105530065668194919764.462354032281');
    t('7.067238e+5', '706723.8');
    t('7.101666481976457556024951459e+20', '710166648197645755602.49514590');
    t('1.98927384634532163e+13', '19892738463453.2163');
    t('9.29554688795640972981057180708607820032179861e+37', '92955468879564097298105718070860782003.2179861');
    t('6.357e+2', '635.7');
    t('3.840652373682260866164588121591718905795553491603e+8', '384065237.3682260866164588121591718905795553491603');
    t('9.648833805019588496096876819771292813546e+29', '964883380501958849609687681977.1292813546');
    t('1.01396650233101861694092927e+7', '10139665.0233101861694092927');
    t('1.1003348820123809214388166064277331414286102008e+3', '1100.3348820123809214388166064277331414286102008');
    t('2.36753216678948394164594831443879485957e+22', '23675321667894839416459.4831443879485957');
    t('4.793420545453058844039438100377715257448e+3', '4793.420545453058844039438100377715257448');
    t('2.8594271318287473088601837035675887941e+16', '28594271318287473.08860183703567588794100');
    t('1.6206370599062305392884719395678561e+31', '16206370599062305392884719395678.561');
    t('8.37074216450166132786697142264216365e+10', '83707421645.0166132786697142264216365');
    t('5.72070708e+6', '5720707.08');
    t('3.44337507384153235321301316699932527121036236885e+7', '34433750.7384153235321301316699932527121036236885');
    t('5.1e+1', '51');
    t('2.1015822918024812834120182488777123107013633378167186e+42', '2101582291802481283412018248877712310701363.3378167186');
    t('1.6372374238765434156758128e+15', '1637237423876543.4156758128');
    t('3.3419685364707547838979720464860359274118133481936e+14', '334196853647075.47838979720464860359274118133481936');
    t('2.8068807310597786792e+3', '2806.8807310597786792');
    t('4.845691098565776387667111068909874902599225606796909e+22', '48456910985657763876671.11068909874902599225606796909');
    t('4.63492511826172e+7', '46349251.1826172');
    t('8.25120492e+0', '8.25120492');
    t('2.5871391624943067662520803430464711250480700861462709e+13', '25871391624943.067662520803430464711250480700861462709');
    t('6.862831873483024223892481752e+21', '6862831873483024223892.4817520');
    t('4.270995713570409133606448268988455e+6', '4270995.713570409133606448268988455');
    t('3.21689066758930720484611614541085683569991722e+1', '32.1689066758930720484611614541085683569991722');
    t('4.2006919228915e+6', '4200691.9228915');
    t('2.111647930356982460265657710379876346e+34', '21116479303569824602656577103798763.46');
    t('4.87551174669e+5', '487551.174669');
    t('1.5091257783488078659575278297164846061663847e+26', '150912577834880786595752782.97164846061663847');
    t('1.237701316659693172445623860334e+1', '12.37701316659693172445623860334');
    t('5.3635904e+4', '53635.904');
    t('1.5977967842379292197961047064611986628e+22', '15977967842379292197961.047064611986628');
    t('6.834482866e+0', '6.8344828660');
    t('3.9109e+3', '3910.9');
    t('2.05461117535930705870869638710707996175293568e+5', '205461.117535930705870869638710707996175293568');
    t('1.2070553345143881176541757184e+18', '1207055334514388117.6541757184');
    t('9.04753411072173104408842163075173270844e+2', '904.753411072173104408842163075173270844');
    t('3.639101145152501183326810611536036936191190074e+10', '36391011451.525011833268106115360369361911900740');
    t('1.994669617516385887919849012130839536463335664239342e+50', '199466961751638588791984901213083953646333566423934.2');
    t('9.7856070170986006874778e+3', '9785.6070170986006874778');
    t('6.1871253720389630778712195614969724340856119729e+35', '618712537203896307787121956149697243.40856119729');
    t('1.208e+1', '12.08');
    t('1.198080560663539944762503564196454e+22', '11980805606635399447625.03564196454');
    t('2.5328238533704762297890589157e+22', '25328238533704762297890.5891570');
    t('5.552e+2', '555.2');
    t('2.01773928527273821442e+12', '2017739285272.738214420');
    t('7.1036358731897125539910962e+19', '71036358731897125539.910962');
    t('3.01168351390557005880750701501256409e+28', '30116835139055700588075070150.1256409');
    t('8.873816195265370349563768092711378467e+0', '8.873816195265370349563768092711378467');
    t('5.31989959593655063323434328335073160690174981170061e+33', '5319899595936550633234343283350731.60690174981170061');
    t('1.170061672875437e+9', '1170061672.875437');
    t('2.631e+0', '2.631');
    t('6.992802197718685e+6', '6992802.197718685');
    t('6.4873437617951852808027501577341488220457588954e+3', '6487.3437617951852808027501577341488220457588954');
    t('4.1846611240468792953070738254513e+26', '418466112404687929530707382.54513');
    t('9.65827406708491826272070488217543356756570950537e+5', '965827.406708491826272070488217543356756570950537');
    t('2.680770183874090982680392187869e+13', '26807701838740.909826803921878690');
    t('6.7565808330233111784457537072905e+7', '67565808.330233111784457537072905');
    t('2.38408874905822388315809187608e+17', '238408874905822388.315809187608');
    t('2.447793231118383053396286312152e+27', '2447793231118383053396286312.152');
    t('4.412e+0', '4.412');
    t('6.9222338533800975058347547493064339259e+10', '69222338533.800975058347547493064339259');
    t('1.72125107835943e+12', '1721251078359.4300');
    t('6.607121e+4', '66071.21');
    t('7.03864465898721081635229140790621289565513e+24', '7038644658987210816352291.40790621289565513');
    t('5.7060362541741681216530676958032280095247281014555554e+31', '57060362541741681216530676958032.280095247281014555554');
    t('2.7482039096119173840576395905241256e+28', '27482039096119173840576395905.241256');
    t('6.4362e+2', '643.62');
    t('1.72406543968787e+12', '1724065439687.87');
    t('3.7500096080724676535769717e+8', '375000960.80724676535769717');
    t('3.3903249492445e+4', '33903.249492445');
    t('3.985710962147295694116665218405340482945689e+6', '3985710.962147295694116665218405340482945689');
    t('5.9597233999e+2', '595.972339990');
    t('5.065730949256446196418568178865493e+9', '5065730949.256446196418568178865493');
    t('1.6265740670254208186e+10', '16265740670.254208186000');
    t('2.471885430096e+2', '247.1885430096');
    t('9.764510566491700832916679297457385114302061622402e+27', '9764510566491700832916679297.457385114302061622402');
    t('1.100445271296546289546e+20', '110044527129654628954.6');
    t('8.561528590365492629836625093938e+28', '85615285903654926298366250939.38');
    t('7.31603872157247934437172663482574448376720106618697e+0', '7.31603872157247934437172663482574448376720106618697');
    t('2.75299872462131924258265574524762989786191459317e+7', '27529987.2462131924258265574524762989786191459317');
    t('6.7303660756133592428732533499288191492268777722116295e+8', '673036607.56133592428732533499288191492268777722116295');
    t('5.44277296e+3', '5442.77296');
    t('1.727400264734055421671805513613990565159952e+17', '172740026473405542.16718055136139905651599520');
    t('1.410636835060372309578742278281108273215901435e+42', '1410636835060372309578742278281108273215901.435');
    t('4.92125270107294889416151811122942461554e+6', '4921252.70107294889416151811122942461554');
    t('8.263574210550744338917479e+4', '82635.74210550744338917479');
    t('3.301295895927052871052e+18', '3301295895927052871.052');
    t('2.8345346500631739e+9', '2834534650.0631739');
    t('2.18804350994050349e+5', '218804.350994050349');
    t('3.383e+2', '338.30');
    t('7.581461444218101096345865e+3', '7581.461444218101096345865');
    t('1.584289425751937525462e+15', '1584289425751937.525462');
    t('1.202636592001646399174824119297846262e+35', '120263659200164639917482411929784626.2');
    t('1.72579256998649794e+15', '1725792569986497.94');
    t('1.109e+0', '1.109');
    t('6.40345690864260982946869972537190219e+32', '640345690864260982946869972537190.219');
    t('7.5479229773185178963182361773e+8', '754792297.73185178963182361773');
    t('7.78534635586647281e+15', '7785346355866472.81');
    t('4.5177508859669314863310078725e+4', '45177.508859669314863310078725');
    t('8.488973363671775235458481e+7', '84889733.63671775235458481');
    t('4e+0', '4');
    t('2.160257894346090658681225233774014977725364e+11', '216025789434.6090658681225233774014977725364');
    t('1.607e+1', '16.07');
    t('2.0206643483788145768022873735045719015739162865885754e+19', '20206643483788145768.022873735045719015739162865885754');
    t('1e+0', '1');
    t('6.086027486877e+4', '60860.27486877');
    t('6.49464610960956342354353921e+18', '6494646109609563423.5435392100');
    t('9.043087147437339975894215149e+5', '904308.7147437339975894215149');
    t('9.1415795e+4', '91415.795');
    t('1.27325e+3', '1273.25');
    t('1.1457620373836988522455309158001309e+23', '114576203738369885224553.09158001309');
    t('3.5258358268876488e+3', '3525.8358268876488');
    t('5.903854119252757788054640537784867975213379818757043e+12', '5903854119252.757788054640537784867975213379818757043');
    t('2.85971614953528217489857558639088593436284e+10', '28597161495.352821748985755863908859343628400');
    t('6.32147605459582535823869726726906892032424730199715e+12', '6321476054595.82535823869726726906892032424730199715');
    t('1.66883e+3', '1668.83');
    t('8.77804543701627148053590314981878177298945834797e+34', '87780454370162714805359031498187817.7298945834797');
    t('1.12758900853879813587345336618836e+24', '1127589008538798135873453.366188360');
    t('2.650452875488521637e+15', '2650452875488521.637');
    t('9.81e+1', '98.1');
    t('9.4897220794023859948771e+7', '94897220.794023859948771');
    t('8.2072647415486658112286228544358927e+27', '8207264741548665811228622854.4358927');
    t('1.2676e+1', '12.676');
    t('2.6048528862310648794425199635976449765151357e+40', '26048528862310648794425199635976449765151.357');
    t('1e+0', '1');
    t('2.2e+1', '22');
    t('1.3672902326585293252722797324062e+4', '13672.902326585293252722797324062');
    t('8.2594112194437e+4', '82594.112194437');
    t('0e+0', '0');
    t('1.21895563609362455802176301e+3', '1218.95563609362455802176301');
    t('3.7463929411575183690242615828695666e+19', '37463929411575183690.242615828695666');
    t('3.28403622335683751121762619033739817557846187135037e+37', '32840362233568375112176261903373981755.7846187135037');
    t('7.0543560548522121622953708263633228563e+22', '70543560548522121622953.708263633228563');
    t('1.739819e+3', '1739.819');
    t('2.15324060127001207725970506357881e+19', '21532406012700120772.5970506357881');
    t('2.373532121822929762731612214095513784533409e+29', '237353212182292976273161221409.5513784533409');
    t('4.5883026736677354807679611737881799804e+16', '45883026736677354.807679611737881799804');
    t('2.5996714820346689325468319633061e+21', '2599671482034668932546.8319633061');
    t('8.22641928e+6', '8226419.280');
    t('2.56006014528479284199702229871263269e+20', '256006014528479284199.702229871263269');
    t('4.301260132991159779386275268219519443685e+24', '4301260132991159779386275.268219519443685');
    t('1.052721790360165649330888881e+22', '10527217903601656493308.88881');
    t('6.85257703973809064426443728e+0', '6.85257703973809064426443728');
    t('1.341206836e+5', '134120.6836');
    t('1.293696083809745995580141432072678134217648017629e+25', '12936960838097459955801414.32072678134217648017629');
    t('9.81886611183e+9', '9818866111.83');
    t('1.3e+1', '13');
    t('2.185212134168411755342025405260683400574952243371e+1', '21.8521213416841175534202540526068340057495224337100');
    t('5.09812942277266e+1', '50.9812942277266');
    t('1.15841228150473459450904593187073359993e+37', '11584122815047345945090459318707335999.3');
    t('2.946408e+1', '29.46408');
    t('7.8843253757257e+6', '7884325.3757257');
    t('4.149829532631829e+7', '41498295.32631829');
    t('9.76844406944663415436782518894675931581135161845733e+46', '97684440694466341543678251889467593158113516184.5733');
    t('1.320634109357604978481e+7', '13206341.09357604978481');
    t('1.2300117044692162331376535732386421937e+8', '123001170.44692162331376535732386421937');
    t('1.79343822239530391558796001578394154846951511735e+42', '1793438222395303915587960015783941548469515.11735');
    t('3.46227335968923941657647562338569e+7', '34622733.5968923941657647562338569');
    t('3.6081901133629252234652167e+18', '3608190113362925223.4652167');
    t('3.41769614577210353834283168068494e+24', '3417696145772103538342831.68068494');
    t('1.036693895e+8', '103669389.5');
    t('9.840862048026534392868878603161623504069221701e+27', '9840862048026534392868878603.161623504069221701');
    t('2.56437211238605e+10', '25643721123.86050');
    t('2.645333616435501e+6', '2645333.616435501');
    t('3.75834254646606787747061360998e+1', '37.5834254646606787747061360998');
    t('1.21582101247e+6', '1215821.01247');
    t('5.43e+1', '54.3');
    t('3.1461380403028457753654142032015e+27', '3146138040302845775365414203.2015');
    t('2.73039e+4', '27303.9');
    t('3.349112077000398203735762417e+25', '33491120770003982037357624.170');
    t('2.293912475527946909960963698602754526495697363e+31', '22939124755279469099609636986027.54526495697363');
    t('7.800578368e+8', '780057836.8');
    t('3.503304265046835170500513083432983735273e+28', '35033042650468351705005130834.32983735273');
    t('6.521027589563589728e+9', '6521027589.563589728');
    t('1.26604818273232e+3', '1266.04818273232');
    t('4.5844253800756959854340115e+7', '45844253.800756959854340115');
    t('2.5103887704609158215979351198183e+20', '251038877046091582159.79351198183');
    t('6.5170765018089001398157674630438543e+17', '651707650180890013.98157674630438543');
    t('7.85679659655762637941070216699747e+18', '7856796596557626379.41070216699747');
    t('6.55113755834849587145e+18', '6551137558348495871.45');
    t('1.37856413555592382324487860882977704999616e+32', '137856413555592382324487860882977.704999616');
    t('7.51530486314140193e+5', '751530.486314140193');
    t('1.3712642461229590011e+7', '13712642.4612295900110');
    t('8.945222111405724e+2', '894.5222111405724');
    t('1.74501389497524149414213254563953197394499747444317e+44', '174501389497524149414213254563953197394499747.444317');
    t('7.1583294041845987824307132e+11', '715832940418.45987824307132');
    t('1.282007923703783860923747442697572540049e+13', '12820079237037.83860923747442697572540049');
    t('5.660625174793381639446229222e+11', '566062517479.3381639446229222');
    t('2.094745267e+4', '20947.45267');
    t('8.4497877437844686621097450218313191175e+13', '84497877437844.6866210974502183131911750');
    t('1.7e+1', '17');
    t('1.707217105197425488000493702652714920318758323999364e+23', '170721710519742548800049.3702652714920318758323999364');
    t('2.5487434814078948112667918801256335353406914111636153e+36', '2548743481407894811266791880125633535.3406914111636153');
    t('7.975944255792483246376368330364e+8', '797594425.5792483246376368330364');
    t('1.1038710051127692465453332862048e+20', '110387100511276924654.53332862048');
    t('2.0214122542287381656860062564183697682e+13', '20214122542287.381656860062564183697682');
    t('7.853012025112e+4', '78530.12025112');
    t('7.97061651146928e+3', '7970.61651146928');
    t('1.5712956919727392305361179349388e+10', '15712956919.727392305361179349388');
    t('8.2480059e+3', '8248.0059');
    t('2.71929146422591231877279340940781443961397491e+19', '27192914642259123187.7279340940781443961397491');
    t('2.131e+2', '213.10');
    t('5.53443299017925367e+6', '5534432.99017925367');
    t('9.0599636453e+8', '905996364.53');
    t('2.86841011915001378943e+0', '2.86841011915001378943');
    t('3.50691916034642635201767965866239485795145676493e+28', '35069191603464263520176796586.6239485795145676493');
    t('1.20268235416561427028396813141142129291e+18', '1202682354165614270.283968131411421292910');
    t('4.8878729e+4', '48878.7290');
    t('9.04344910891e+4', '90434.4910891');
    t('3.87232843764031e+2', '387.232843764031');
    t('2.246212201353343e+11', '224621220135.33430');
    t('4.92916234816086643529027167741689023e+4', '49291.6234816086643529027167741689023');
    t('2.1773818234639052045922630496e+22', '21773818234639052045922.630496');
    t('4.78705362683815125848e+0', '4.787053626838151258480');
    t('2.700762078698436846755198719005e+28', '27007620786984368467551987190.05');
    t('3.04897901998664513240359358574664525651334171e+36', '3048979019986645132403593585746645256.51334171');
    t('3.807300704307638993582e+18', '3807300704307638993.582');
    t('7.9846840795076707340124614425632613353204e+3', '7984.6840795076707340124614425632613353204');
    t('6.69918558928e+4', '66991.8558928');
    t('5.11e+1', '51.1');
    t('1.8e+1', '18');
    t('2.629676971e+2', '262.9676971');
    t('6.8402048967767212280354493672372347369800788279670097e+39', '6840204896776721228035449367237234736980.0788279670097');
    t('4.684145127602661593941009299096573092581e+21', '4684145127602661593941.009299096573092581');
    t('1.3010133600355313564757759338788842e+18', '1301013360035531356.4757759338788842');
    t('1.58527974113934732993372979240170059e+30', '1585279741139347329933729792401.70059');
    t('1.8249338722142728063286e+2', '182.49338722142728063286');
    t('1.5941e+0', '1.59410');
    t('2.0337546838170082473539926326926478252219475e+29', '203375468381700824735399263269.26478252219475');
    t('4.626173e+3', '4626.173');
    t('6.04857e+0', '6.04857');
    t('9.55039030589038069713466331e+0', '9.55039030589038069713466331');
    t('3.13977842e+6', '3139778.42');
    t('4.4046554138751e+10', '44046554138.751');
    t('2.27133088062335544441002965096e+25', '22713308806233554444100296.5096');
    t('1.72895143e+4', '17289.5143');
    t('2.59665963383099309886519729836757e+20', '259665963383099309886.5197298367570');
    t('5.42804375404301025317704270939778493719619031067122726e+24', '5428043754043010253177042.70939778493719619031067122726');
    t('4.0526054186532354119711729303068171063825508e+2', '405.26054186532354119711729303068171063825508');
    t('1.26960267394273418410687782475849e+9', '1269602673.94273418410687782475849');
    t('5.657206212494798707700546288522044895183104747814298e+7', '56572062.12494798707700546288522044895183104747814298');
    t('4.80834664047405196104320584899449259286e+21', '4808346640474051961043.20584899449259286');
    t('5.6639294733687553228095e+12', '5663929473368.7553228095');
    t('3.08469899797006019074738182718775120203832280411e+44', '308469899797006019074738182718775120203832280.4110');
    t('6.7324018330891115163882850963905830707247414517739e+20', '673240183308911151638.82850963905830707247414517739');
    t('7.8e+1', '78');
    t('3.7511576e+4', '37511.576');
    t('4.9744737445922007872559411117007e+20', '497447374459220078725.59411117007');
    t('1.4264855114407053894401398660016825255242638071603e+2', '142.64855114407053894401398660016825255242638071603');
    t('1.7972e+1', '17.972');
    t('1.08223075909551421423442320791403363148864e+12', '1082230759095.51421423442320791403363148864');
    t('1.27992032328728568e+16', '12799203232872856.8');
    t('3.23410998756876789482263723951851692122375679e+9', '3234109987.56876789482263723951851692122375679');
    t('8.309058187826413886051933894555524364e+5', '830905.8187826413886051933894555524364');
    t('5.9126904485324084868266487306831291316268437628598e+40', '59126904485324084868266487306831291316268.437628598');
    t('3.579918283412251816470339246643e+16', '35799182834122518.16470339246643');
    t('8.292403288e+1', '82.92403288');
    t('7.39431e+2', '739.431');
    t('3.880259e+2', '388.0259');
    t('8.356612898392420429137009991722851e+18', '8356612898392420429.137009991722851');
    t('9.45261313e+6', '9452613.13');
    t('3.3127850701711548546e+12', '3312785070171.1548546');
    t('7.883085682938156731330453228115e+0', '7.883085682938156731330453228115');
    t('7.8019561298380079335847245119645e+18', '7801956129838007933.5847245119645');
    t('1.162986351331516344668182075630641387e+5', '116298.63513315163446681820756306413870');
    t('1.28721291829552168e+9', '1287212918.29552168');
    t('6.1228832015e+5', '612288.32015');
    t('7.093619563532718270358988194610140484e+4', '70936.19563532718270358988194610140484');
    t('2.301304548870898223195731e+19', '23013045488708982231.95731');
    t('7.8447233503822258690539142204913891e+33', '7844723350382225869053914220491389.1');
    t('1.0090353662689425563590122399240645713114036952885e+26', '100903536626894255635901223.99240645713114036952885');
    t('2.6e+1', '26');
    t('2.015599e+5', '201559.9');
    t('3.1885351403871521971462599368214857856505297484e+33', '3188535140387152197146259936821485.78565052974840');
    t('3.6914534995202995808748962e+15', '3691453499520299.5808748962');
    t('1.2184696326401127654851812133097e+7', '12184696.326401127654851812133097');
    t('1.320231321916575882279815969200269836e+33', '1320231321916575882279815969200269.836');
    t('6.9618612891393774e+15', '6961861289139377.4');
    t('1.413827890310425450368036252350406468114295965313e+11', '141382789031.0425450368036252350406468114295965313');
    t('7.2883e+0', '7.2883');
    t('4.39128379250644938491985214e+17', '439128379250644938.491985214');
    t('4.08749008923147560205987e+12', '4087490089231.47560205987');
    t('1.2963755286285698528172931273502071438656e+36', '1296375528628569852817293127350207143.8656');
    t('1.748593351151123699414e+1', '17.48593351151123699414');
    t('9.734881140813067568986787719510123722831153669e+35', '973488114081306756898678771951012372.2831153669');
    t('2.32721108706388120897763e+11', '232721108706.388120897763');
    t('2.362273992041095475822632722018109548e+22', '23622739920410954758226.327220181095480');
    t('9.127306952822127691560865985866475e+18', '9127306952822127691.560865985866475');
    t('2.4e+1', '24');
    t('9.33725589231422920537799340863789387113892e+31', '93372558923142292053779934086378.9387113892');
    t('2.8683466985317806508353476e+6', '2868346.6985317806508353476');
    t('1.96167065035164685305509057685021959865228913867e+40', '19616706503516468530550905768502195986522.8913867');
    t('2.1513e+3', '2151.3');
    t('3.65316922559843117188159177065637844e+19', '36531692255984311718.8159177065637844');
    t('5.87971958699076454900383524e+21', '5879719586990764549003.835240');
    t('1.29414973913652368531805363331786105e+14', '129414973913652.368531805363331786105');
    t('1.68007422270052611738598e+22', '16800742227005261173859.8');
    t('2.9465419082779898714713969973e+4', '29465.4190827798987147139699730');
    t('2.865456717594117060964538744726484002e+28', '28654567175941170609645387447.26484002');
    t('1.2781496e+0', '1.2781496');
    t('5.395903069e+4', '53959.03069');
    t('2.084656696443025813e+12', '2084656696443.025813');
    t('7.54671420639507228408101673007042651462774881888e+46', '75467142063950722840810167300704265146277488188.8');
    t('1.436685520447262044600029e+14', '143668552044726.2044600029');
    t('6.9e+1', '69');
    t('8.921e+2', '892.10');
    t('2.51196408e+4', '25119.6408');
    t('4.2502325992166027236666111862782e+15', '4250232599216602.7236666111862782');
    t('1.48181688637265610577148846528720697801886e+17', '148181688637265610.577148846528720697801886');
    t('6.578849006577789439801702e+0', '6.578849006577789439801702');
    t('4.346905625146927213132990652e+22', '43469056251469272131329.90652');
    t('5.5037893e+0', '5.5037893');
    t('2.47731675267438120023934691987e+15', '2477316752674381.20023934691987');
    t('3.37487366652276710575333974697197457e+9', '3374873666.52276710575333974697197457');
    t('1.0385387059229329627650733271e+0', '1.0385387059229329627650733271');
    t('9.83004944893186643985967600066862369294062e+17', '983004944893186643.985967600066862369294062');
    t('4.24581658127100743607231740518633563667839856744e+26', '424581658127100743607231740.518633563667839856744');
    t('3.14222253457223322124561584676953981561133e+2', '314.222253457223322124561584676953981561133');
    t('1.1553833141891499623566322265502695096447390786748e+48', '1155383314189149962356632226550269509644739078674.8');
    t('5.2811e+1', '52.811');
    t('9.925202445922857021945001443270353221818473047344e+2', '992.5202445922857021945001443270353221818473047344');
    t('1.5758941e+4', '15758.9410');
    t('6.6630010328564980059488916358767e+30', '6663001032856498005948891635876.7');
    t('1.49898377473153728100588907982263779724221092732531e+44', '149898377473153728100588907982263779724221092.732531');
    t('4.175238908185616536855e+20', '417523890818561653685.5');
    t('1.192838736272799853174021036238e+21', '1192838736272799853174.021036238');
    t('1.145038e+3', '1145.038');
    t('4.0973786626728889384598402998014750474268e+9', '4097378662.6728889384598402998014750474268');
    t('5.5038104e+4', '55038.104');
    t('6.83895535917805849194871290958068199407518e+2', '683.895535917805849194871290958068199407518');
    t('2.9716066182e+0', '2.9716066182');
    t('1e+0', '1');
    t('1.78063428481384259205331358231117935e+0', '1.780634284813842592053313582311179350');
    t('6.277714976103425712837719e+22', '62777149761034257128377.1900');
    t('1.37376909692642287134486582232200547809845780076e+26', '137376909692642287134486582.232200547809845780076');
    t('7.0255659498942180908195e+16', '70255659498942180.908195');
    t('1.36758412477e+6', '1367584.12477');
    t('2.8993016541323392639291954727329719281958174e+23', '289930165413233926392919.54727329719281958174');
    t('2.44e+0', '2.44');
    t('5.39870374073212675286058196342904027304008232e+40', '53987037407321267528605819634290402730400.8232');
    t('6.4507160654825e+9', '6450716065.4825');
    t('1.21664e+3', '1216.64');
    t('3.13108416362400780440861428855476299376486503e+0', '3.13108416362400780440861428855476299376486503');
    t('7.2960499529336221198242592384915903149558006256202995e+17', '729604995293362211.98242592384915903149558006256202995');
    t('5.67239328846178836850536139916737284448973e+0', '5.67239328846178836850536139916737284448973');
    t('7.20020305957519743064e+3', '7200.203059575197430640');
    t('1.85115423780064073715032545790701546649748120114e+27', '1851154237800640737150325457.90701546649748120114');
    t('1.25021250836778893386687012660759710902e+21', '1250212508367788933866.87012660759710902');
    t('2.3323707491301665555664068537483355865980611e+25', '23323707491301665555664068.5374833558659806110');
    t('2.5088131581298507401113299236e+4', '25088.131581298507401113299236');
    t('9.612326850563943155774866e+17', '961232685056394315.5774866');
    t('1.54114517176248297154289225338049499367447824e+22', '15411451717624829715428.9225338049499367447824');
    t('5.22e+0', '5.22');
    t('4.04698305476309533783897e+21', '4046983054763095337838.97');
    t('2.620876536774240989563272117908814902188002596311e+24', '2620876536774240989563272.117908814902188002596311');
    t('1.7290754650750439926458970782158e+10', '17290754650.750439926458970782158');
    t('8.570789332248e+6', '8570789.332248');
    t('1.21e+1', '12.1');
    t('9.749134061639126502181192178140679940393318673720443e+45', '9749134061639126502181192178140679940393318673.720443');
    t('1.26878e+5', '126878.0');
    t('1.2391599841950849289559651456348e+9', '1239159984.1950849289559651456348');
    t('1.72220118427662724614289256133342842086e+22', '17222011842766272461428.9256133342842086');
    t('1.512063585971680294584184272035496e+15', '1512063585971680.294584184272035496');

    BigNumber.config({EXPONENTIAL_AT: 1E9});

    // 10000 integer base conversions generated from java BigInteger.toString(radix) with random values

    t('440155688144172', '101725686101180', 9);
    t('101012012002102211212101002012121211210112201112022122012110220101', '11665560554201545341275846801989', 3);
    t('16g621gjdfj387g8f', '878682490721226942575', 20);
    t('23296228463551556aa7a803294013169936813630895547', '20254039346778828988686906345231844106054371456414', 11);
    t('86', '294', 36);
    t('j6angf77m93m', '29321388122089630', 24);
    t('171634571716400543513334300705612071133717535572246575453160', '364584667335183828987221775272570428237696628507956848', 8);
    t('79ih09ddbmoj6chgi', '5317189538963113735021341', 31);
    t('17140110747560', '1043696177008', 8);
    t('5mf9glgacka1oj', '8798568215457188744', 25);
    t('14i0i1bijh5bb66318hjbe39el8ed7', '1038225938103094195672715196371622399149', 22);
    t('3779577535435531065475', '3779577535435531065475', 10);
    t('1101000100001000000110100100011100000101001', '7182272837673', 2);
    t('v1r0gswws8mg7rg877gua', '132336254343195067504822207481070', 34);
    t('1caiusm1ngmh8', '1101263079273875608', 31);
    t('bcd583cc3014846', '132516316064365582', 14);
    t('1656', '942', 8);
    t('2iq2q6a', '1046997262', 27);
    t('s0tb0wwdorr1don43twqe', '65743744003104369805298454218408', 33);
    t('4', '4', 17);
    t('13eb7d6c25678', '2652301005605213', 19);
    t('63595846315682339605641914681670020', '63595846315682339605641914681670020', 10);
    t('3192', '53640', 26);
    t('18jd4fccghe', '86689784393126', 24);
    t('ahn8jmcronn1imiwqqf6894boecrwtt', '92552461943195873402655551990866403102200950223', 34);
    t('732a68649252780573256384a0762a874827823929485545', '64359755261128349657756381355778457151559256253657', 11);
    t('o0502ci441waab54sxss84sdbiq3', '5373042738281691949642803579987183092210407', 34);
    t('1021112001100000210210', '13373890500', 3);
    t('40202343000', '39887250', 5);
    t('8720081b5e09269094e56202843449cb', '24377982076224740260643696757107121341', 15);
    t('1iomc2mqsn5qpt8h1f569gs852', '13789591701124129450628724568456423352', 30);
    t('1eom414n8l1d9nfel48f1bmqmm0nmle0j3', '266719145838127409543902693002813822731463432657', 27);
    t('13k56oq3m631lo954n2ohok7', '2181841744266177308465040173350263', 28);
    t('454023134354435330523150501153110052125254133003305331', '863587285752958267795174798408995811866775', 6);
    t('1d6ekejh1ik9hk6k718', '2338861492105483120978650', 22);
    t('2', '2', 29);
    t('1e6c', '15573', 21);
    t('g57c69', '52060929', 20);
    t('12020002010112222111002201112002020022001101201021102000', '303840883816576562846336400', 3);
    t('117e081886a2b7dhh6b7ddc9g9dah881', '4703193157526229832838915604553828591088', 19);
    t('120', '48', 6);
    t('r3ph9dgk57p', '74774633365798895', 35);
    t('8a0a2kj0d87f3m42i17h31kl60k28e4de70', '167827516964906460076306119782216338842769448945', 23);
    t('2l055f3b4noi9po87stgqmchln5387', '18531519454051111130681336099858607562067947', 30);
    t('421062013993955192a2221428707a96575292bb', '115579778299459540087492544347756755742382977', 13);
    t('1bibgea4if', '526155599692', 19);
    t('1497d29d3476a2a9780b34d03dd8d7b', '32297467668609167750315214037242897', 14);
    t('1100', '12', 2);
    t('3', '3', 10);
    t('aj768i29h4hiaa4c21ehiad1ejcia8ig', '235542570596088783891401514707500777363576', 20);
    t('0', '0', 26);
    t('1057782', '1057782', 10);
    t('10110000100', '67806', 3);
    t('130301232102', '7543698', 4);
    t('3iuna', '5311190', 35);
    t('12120101010001002202210212202210210222212101010111220211201121001202001', '4647047674765599509161881404042506', 3);
    t('19c1p4e5sc', '77422104704616', 34);
    t('20jd875f0sb7eob641f2j2rogg5i22f', '150648633114646195779853741265975908572439118', 29);
    t('fe5pdnmr6agww3hvvh1m5y6084tkm4qi', '11317796537927193164907314114830625186030646924078', 35);
    t('115gekg30bl34558', '144730350757318919194', 22);
    t('3fagc3b8m35ahj6346g1mbkh885b5159g2', '3176675255123809025734896069538375765072180396', 23);
    t('5686he7d5bb824gci8i3e78c7j0ih', '14283076803292405590664992623911672377', 20);
    t('1jmnldb1lfkrjoe75k7o3rednhb1f8h0', '1242551650400204544842102196394576048943170972', 28);
    t('60bf8d3f1cb70827109c', '456880688358819786854556', 16);
    t('340432530435433213034435253441422121', '6339719167942344530566282177', 6);
    t('i38g07j7ie95b2g3533dfi075', '982752454390853323739173663368665', 21);
    t('1h6t', '42509', 30);
    t('642677755550042022420042650122720673705371422153432', '9341223088519577080757976073309527669316572954', 8);
    t('4ddho197n710a2m273kka0e23l4g0h85b', '2462195801283263655162466534079464545810817636', 25);
    t('1243240323034002400230042343332120411442100332', '45148599779050957102730921831342', 5);
    t('88scnc9d', '228014337833', 31);
    t('1170484020308451032231073707375108400760815', '14346468379928007582608703547513785950258', 9);
    t('4823304938154542868234529244227621001', '4823304938154542868234529244227621001', 10);
    t('1651372117475740354637456547', '4427164671782016593583463', 8);
    t('7i2233ggjhb94938eb1bjeh9ah01c', '21220547440397899830782173177438536032', 20);
    t('38e2f51l5226upuurq', '212488028484539189554322396', 33);
    t('2302012223231313010303032233111031210011020131110321321303332231113103032', '62060333685205067717083070636012166725334222', 4);
    t('978074cbc72b612330461c399a6cd9a5246e', '1383648770009475636965471306920429322557754', 15);
    t('ttla4bfhg8ogcqe72ur1432jjo76ghc', '42713337532562165277151943846110614488089838124', 32);
    t('61482faj92i2287770b', '1588859334544847514778811', 20);
    t('3053066362454436563436414156651113001465631', '970611871710418073313798574789753891', 7);
    t('28b74a2sl5cr8s1ki0sro011', '9881987714990620033551204066568469', 29);
    t('9alod3a4n9ncieiqihlpehs8cqd1sd10dj2mb', '415054010142313409024004868502578691674339253356722226', 29);
    t('120131131131201001210300133101113223032122100210332221130303031030', '2080853698331650615760995253176321127244', 4);
    t('ihk308048gi1', '6604552742887513', 21);
    t('a', '10', 28);
    t('41179', '2854566', 29);
    t('h0qpo1102o4h2k', '69043303761626479331', 27);
    t('9g4baafceihhgf518g7bm7h20nkhed8b07m64', '471227319810157894343865948670273836507237979925524', 24);
    t('dho5eqfqowsqv1meq8bquhml', '4406294486817687943635096558491220991', 35);
    t('29bb5fdpe1kes', '1813313296055953458', 31);
    t('8ff84083f', '62334898476', 17);
    t('70a2g249a1da182if3bhf4db31b', '167580219569043944485242667799058497', 21);
    t('5fl2a1id1b2jolhmhjlk7na7g', '51071422881267420196649258348708342', 26);
    t('100022', '251', 3);
    t('432', '282', 8);
    t('3wr3swm6ubjrkvt', '16294970748730625951364', 35);
    t('17168', '11807', 9);
    t('35584293177335052090482862003912891468038390', '35584293177335052090482862003912891468038390', 10);
    t('7998aldd', '33899695237', 24);
    t('4kij6bl8043lpba7', '8045734455699535180463', 26);
    t('4gla1701h5602l588', '29045123944032022935020', 23);
    t('4krb3', '3804633', 30);
    t('3211002241324002022113342004130434213023003244232433', '1531292744433422364552476748786320993', 5);
    t('27', '39', 16);
    t('3o6qpgd0', '104034477683', 31);
    t('5dg2c119a0892cb61353d9b1', '116223645530706451323585167475', 17);
    t('1156036607174723020034543345673164620146641', '103357460209213083948351046056291650977', 8);
    t('41ib89ghdgeidg0039be199c3a4', '27490663465965934673955627614337404', 20);
    t('e7k93m5', '6879430493', 28);
    t('120223324040024130101444123240111221103312343230410102202103302323', '3849970071333132024959950921403659216898884713', 5);
    t('jg36bjg950j6i9m8oi8glle21kh3j1kfc', '10649691942461568427422892625442894260778934762', 25);
    t('4w4a6teferq6r5ik5ut62fual', '13835986798310811924322665391394254965', 33);
    t('312490955c70', '5539379829789', 13);
    t('emtaesbe76h7dk71h4bt3h8kg3bn69', '101339233480279275559007163118630302631547889', 30);
    t('3p619b5fmg0l1632dd7dlo2kh', '88631790446416440440286264005548442', 27);
    t('1341', '2757', 13);
    t('f43426ggb18h6510e7fe84fh310b', '511382471492848290663092376073298210', 19);
    t('6j41em7raogenfrjhgjkfkfh3eu', '3945233626117535310773506175958783010154', 31);
    t('111641556162423641100614510003', '3807645289032672695383142', 7);
    t('2696427c2f1cad979g08685g71f0h7h4hbh48289f4f', '124382154384973091480024194947893719797603463814945307', 18);
    t('11845026586657305823549960872429', '11845026586657305823549960872429', 10);
    t('1h64s71x4rusnjlx5s7', '9260237785040115157604241362', 35);
    t('10311042615', '300721440', 7);
    t('2451143b5ba7ca6943a', '262895985819802223782', 13);
    t('jo11nn24j791mg1i8j1mhc47p255', '3189124189951034463858246698569851705767', 26);
    t('10011232230103110332', '281029981502', 4);
    t('iaa7a6e611gih', '41068316481138638', 19);
    t('1912f60k5nd203ej1', '58775002826689939438559', 26);
    t('2459b78a913708732', '438882964276198934', 12);
    t('308258662', '133548968', 9);
    t('347175', '118397', 8);
    t('2l383movaqq6vge0t51d1asb5', '3534985310385748495852148058236481893', 32);
    t('1002011011221201220110020010111000021211000120100020001121', '1695352250587759269039520513', 3);
    t('121', '25', 4);
    t('a0480880954109d', '292517771808862273', 15);
    t('3g5c6881d68a6g3g7ded8f00ddc3', '6605800905697912313930823429368376', 17);
    t('g9bnclea0di628jg02k69b75iaf6mld17akh', '33275613302454138474042464061355756382668628304497', 24);
    t('3410345247354238502664518577282', '146560013392255863392167155830', 9);
    t('21121101020212000010110210100', '58005313126803', 3);
    t('2331003220030000131011220331231', '3405742490204409709', 4);
    t('kepi6h75hclp6o', '210478662369536496313', 29);
    t('14320202403220110112112043411443103144334124004312122302230433132031244204244', '256316960412695093498974392340639287985576426301944324', 5);
    t('21oh0', '812300', 25);
    t('637302200571726036177', '78099699617401957027', 9);
    t('3h8nrbxu09bl9y59qd0x76mh', '2169701554867548714090537334110301769', 36);
    t('5ei5i1ji6hf23g10036fbcgh9kg7b2c8cace9e', '265177220460106545362048683909814340097671193815436', 22);
    t('2il', '1605', 24);
    t('md18bbl3ikih980m8ijjm5hk37aboh7i26c4', '190769957856763978202455746822271950952451735582179', 25);
    t('49a947b15', '11910266120', 15);
    t('5563068134037605066000072214445077281483844846461', '35846490510257461400361080273583563758784437804', 9);
    t('2326og3ij7pqp6nrqmbkkh6d4', '5822237723786017480562091732598915027', 33);
    t('120133110323003200013220212133103302121120320212', '30316511656490491221060718118', 4);
    t('16mdhr19sd5c5d5c0jjav97fu9o1', '267673848646358103096813679060486949796693', 34);
    t('jga1bjl82k4ah11179fk5', '33833463661666075552032677215', 23);
    t('c20kujdb', '514029069323', 33);
    t('11226540043034355', '39624784159854', 7);
    t('v', '31', 34);
    t('14502011231234', '23602310374', 6);
    t('kgl06leab96536b72hh13b4gd12', '5267876931068834999207837763071495773', 23);
    t('jl7of6l89i2iabafma', '22471829516120804540402146', 26);
    t('1450007a44290518221a532', '114367864225072949311955', 11);
    t('298fe1gbg9c72', '1491696784725786', 17);
    t('250711224523642463565466455623', '408358568053857594342267795', 8);
    t('9flo2bq373qjcgkp3e6k71qnonehh', '316990433419229469352412547876129922440461', 28);
    t('1203662265620020640221323330644160123013', '1179984859885559189864263643508373', 7);
    t('16x9ld', '72095953', 36);
    t('67d8i74a4e8gg43', '73378543709714711958', 23);
    t('58398378841218155357', '58398378841218155357', 10);
    t('dy3hf3dta7', '1101392127345132', 35);
    t('ko6nkrons9d0fc0bil4i3qi63e8ff816f302', '31822762789078625728496093591661767305613028321798487', 29);
    t('198g4ec36ah639', '31806677232541503', 18);
    t('45243354620633', '461990081612', 7);
    t('775823b0c15', '4319863197095', 15);
    t('g28he7j4icef0bcbjgj8', '1201572315079967980347229812', 23);
    t('g4d4dqb4', '169104269893', 27);
    t('18jc9hh8c8im15d8a09i8', '5496196321990395030043538936', 24);
    t('4g9282g604cbh7da78c99ca7', '365574202021938047866967922307', 18);
    t('e5rf3kpheo', '206076021040648', 29);
    t('713414314586b73', '27941755511268212', 13);
    t('619739902555681054508877700190814647189340192531531', '619739902555681054508877700190814647189340192531531', 10);
    t('20111011002200122', '93082868', 3);
    t('100230221211233101331231031001203331331003102231102112012330112112330000132301133133021', '6247333955182528679256744382669521818617928418195401', 4);
    t('31464741215652662410302172736', '61905218854453628692395486', 8);
    t('708nesooj9eefjp', '3352746100369361432095', 30);
    t('8fidd470c39jbio0fqbmo4r8ad', '12923744867491474626257779584052881637', 28);
    t('1151171074647051031165674252760067', '764101851531641191689328779319', 8);
    t('11043032215231230545441315401541344541210241405152211', '34556143670121676351099193602542355133167', 6);
    t('7451b5a50511996bac9b28b0', '306395754266354995755659445', 13);
    t('13ir12f', '2389675047', 36);
    t('2e', '72', 29);
    t('112551341310022250543503544424133243522435', '100211013146144877918564374426903', 6);
    t('15g4rioci4g3qfn9da47hln', '177378797438603886266961020628820', 29);
    t('313qoor3rl62hs', '111971617480570505788', 32);
    t('11be338996c3222d74125b207e1c94c74384dc344', '123816432746013151845557555294618280342247674364', 15);
    t('510151', '1885261', 13);
    t('al5ra6h4', '293932103440', 31);
    t('7p7gq6ao', '171498767724', 30);
    t('4aip7ke83a0mnoa31e9hc64c', '3668246283124124964717547932816798', 27);
    t('26ffmuj7qfj5urc', '2600404271332517411692', 32);
    t('1228jnkc879102l6klfmhgeh7b3k9kjem3chmk', '1271226839086861348134838781391638338414049937252452', 24);
    t('3m1dkpcjl6se25ees', '941019906537302808213671', 29);
    t('nvk4t2ijr0pt6a', '885016896759055316170', 32);
    t('353463695235911', '353463695235911', 10);
    t('2592c02eb41095d60c7b3ae4c19254bcb7e451', '77783442256833108339948757455065770782318226', 15);
    t('101001110010100101010011101100111001101001100111101111111000101011011111000010011111', '12630360807685587318206623', 2);
    t('10a94b226bd2a3cb347d8239a354494baa876d3c', '7719527647026016534723119044578909360854733857', 15);
    t('10112100000101212222210120202020120022212020022002012220222222110100101012200010201221221112010100', '22465908588350531170561340022119338184319644550', 3);
    t('3526', '1294', 7);
    t('trqchmprtris8jhmt53mgfph2bqlk1rdlj', '166379098618921452590839536518689519047997516551349', 30);
    t('amqtg5blk7b3', '540363976066013685', 33);
    t('5bb8f0da136651ih36if43c9', '1446604699008863640297362261438', 19);
    t('169095c1igm9lagle03', '18254265908591826520258753', 25);
    t('5ca72lphe8b1g6na87l028nk7', '49874912506100858512179674721524459', 26);
    t('db2hm3or5qm99cejggihbqj24o', '20227071482916596230414576969129951720', 28);
    t('3e06d7bed9cl3hmcdh4rk6d', '518456522736295870554795311386837', 29);
    t('3783552669408621336694762820722', '3783552669408621336694762820722', 10);
    t('8plkxhiid9r48fmxut8j', '1097250217160493743377273093271', 34);
    t('114c00b88e376egfab533', '4369484999824057755698184', 17);
    t('14983603362604292572455838465420099066461810', '14983603362604292572455838465420099066461810', 10);
    t('509d164ce8562017ac87ed954c322aabb3eee76', '2478749182617286136760963476865027709609349886', 15);
    t('3fkhedjllk072h2jdi0722fndca0nm2jh9d', '309586105474608741121591603678170578618026772773', 24);
    t('1iq6sj905ic2n1b75s3bhc97qjj82iclshg7', '2522966691781107980265563729308641205273869137106927', 29);
    t('2a6cba18b56b3', '155884237022909', 14);
    t('8bddeba1aaa3c4d55a4b1496ae4556aa273d', '1280685511801156504844254243757080956139633', 15);
    t('2cd', '2733', 34);
    t('8n6fnlac07f83b3hl5a2cdnjen9fig989', '1316884479548601245836236435764995581418738953', 24);
    t('6fj39908aajh0f7eici5g653270g2', '18248065317134624862612052897609976322', 20);
    t('100442024203540041', '17296877228281', 6);
    t('864lljmcga', '14895956013429', 23);
    t('ida78k0lnm720jk42co06325dndfincdcf', '251216020257140411511559806773250633017763086565', 25);
    t('2202302331132212020233000022322031121', '12012243725278503478105', 4);
    t('6i6jabi6j', '532166217509', 23);
    t('6cmh6r7doponp2ajcjoo2pn87eakbgg', '167803056903383062748024010526394587708233856', 28);
    t('2360598122619478480207180074620237', '2360598122619478480207180074620237', 10);
    t('4fdgfae5ai1dfggc57jb56gfdhh', '32108887594999276898768884821885557', 20);
    t('30316cbc668127583b5c359b17195c7680c', '225869808340726521462856371477325948274', 13);
    t('b0a4c9igh1d34258f', '33188485929923604704131', 22);
    t('9b81ii', '75424770', 24);
    t('150j0jm2n63ana812', '27968036853522567739402', 25);
    t('2rxjdeshl7hv031gh8x8tal1', '913145329049266795302812350123389486', 35);
    t('11ba64655696c81c01230a5c4', '622476147856099856056476548', 13);
    t('2if7c15b64menb5f381mbffsq5552gb4d22pn', '116879749441690585814553354811233856559766636508284681', 29);
    t('a89d1e8ba7d4b79c033a15d0d12e', '600946350698036566145005181087894', 15);
    t('65kkch4kkab51720gk72de14i4m1i65j1h5j', '2863074376250121461194200964351550106115034432936', 23);
    t('hq9iq11x71vufsis5', '141103623069429330755986709', 36);
    t('31352441130112145', '9239969893601', 6);
    t('1e6g5c3c8', '63619126397', 21);
    t('32bcbi7d25g42l', '880900685973582625', 22);
    t('111627132417321114752432320745434507337525667340540534056666', '220880699124044497678574383774865426395965086166441398', 8);
    t('31ajm2h13k3kcceeb9', '432180494217866849859531', 23);
    t('30hj3', '848956', 23);
    t('h2eaee905c464gh13c1g3a24bffbd7b157a7d8243', '2788179404237205827575664664460917404793610485107907', 18);
    t('6l5fmeo4r8q9ksh0e16dqs2a', '29054682041642997983411270167870486', 29);
    t('9bgeg983a9gb072ia', '2776374479824499829805', 19);
    t('427303573032681547102347847', '27865476405856977419599954', 9);
    t('58186560531623536388240774584465008', '1644634101768983314712700937410068', 9);
    t('gud5evq5j', '23798093687167', 33);
    t('273989b4c4b2b65507308785c9601b1991866b1', '5472576971132404535367740776182484421987974', 13);
    t('52e226', '3945861', 15);
    t('c4bg1f73', '5037578485', 17);
    t('0', '0', 7);
    t('2ga84ck3k8lf1b6g81e4d1o10adildo4fb73d3', '14063518582163403576381156810721420380483851225111578', 25);
    t('18398a17693a99a73829311597a8009a998', '449495260282451489496065134468852961', 11);
    t('0', '0', 10);
    t('2322cb943a7c0e49c0adecc89ae8c8', '28247920028932853396658049010936738', 15);
    t('4a7lmeeehee0m0e2f88h3fhi9jae36', '13754660732035427506299787750012455330113', 23);
    t('66om3l', '61326346', 25);
    t('1jaxmqc44xcgutokt3', '440143628927856861597987927', 36);
    t('43402144002311022321023', '11357849767776388', 5);
    t('f1q', '15418', 32);
    t('94bm3khgmeh6h666e51h4hkb1ba70lb0', '15037888711417055917959334087989947554028156', 23);
    t('468836dc5e0921dc805d0ca944655824a80', '43081374214668891982097847922924570176495', 15);
    t('7aia5ft68j2ah9tdnij8hbf2436', '1869214551753119688855382398317532507696', 30);
    t('14a3b3', '1352627', 16);
    t('upklpfh648l1', '1555511519818102177', 33);
    t('3642604410156200265653560662320144226060043062566313031', '17044221773211127840838069782217144740567292173', 7);
    t('11111001010110010000011011010110111010011011110010100101011010010000111011110110011011011100001110000001110010101000001101', '5178750376444939350710857550952606221', 2);
    t('25914', '69645', 13);
    t('22201121210', '171768', 3);
    t('1299ea6145a33955gg494827fgfb4', '160233176579923489744786615302245782', 18);
    t('2404400303345455302', '273021872765366', 6);
    t('2780589741896838784693', '2780589741896838784693', 10);
    t('120051666651454430105', '102765715947351287', 7);
    t('go', '488', 29);
    t('7hdkmh4echjjf94fc851b7cm9a6309he06fhk', '81727387424011034101131466677491869453894982060018', 23);
    t('33313031310333101301210101232121100102032301201220123220033121130222032003202122', '1448964781656315513831338629339319660846289270938', 4);
    t('1f4ejan70ggb73lk5bia4djdjelig6', '17342687637043286986515244372299021023238', 24);
    t('9', '9', 22);
    t('100110', '38', 2);
    t('101010011010001001110001110111110010010100011100110100001101101110100100001101001', '1602153026925525548353641', 2);
    t('dce94', '701914', 15);
    t('1ecgdk4ch2ki2gal6geikc9fmgm6gc8a8mb', '135755121543031059870445637631947092289577070619', 24);
    t('hviu8xaubwr6cba0mkh6xhcmkgrudf98np4', '563888921489815885331467969078334098692735774824158929', 35);
    t('16b72', '32774', 12);
    t('3fkd07k', '2106600098', 29);
    t('121344424133143434114024144', '2193410290272017424', 5);
    t('ej561m9bckcn7i03ja6mj2a1m1alm85ej9mhc', '720924047901203102542178589784759717033703825426724', 24);
    t('6dkib54b13fncbkcefo7lafkdkae78m59l', '88812159262476475867698690215386920230540581496', 25);
    t('5947916744591013134669825015156762693936309', '5947916744591013134669825015156762693936309', 10);
    t('97fj791568miadhqtj6dci02', '87089150165580623669373687837670202', 30);
    t('3ocb5459mcgps', '2026781564861859178', 30);
    t('828g6fdkbfje1kaji14fk361', '20909317220805593816802833365225', 21);
    t('q5', '941', 36);
    t('8alo9sgaa', '4187460686272', 29);
    t('5j6nf244ahl3k83f24l5imff20a0ik2ij45', '490788188097844322838594090172370516724231182117', 24);
    t('4kfem4ifgc376m7fhfiab7ji51n', '78208441448030014437846328864355857976', 27);
    t('22ga1if26hi9', '5021678125886084', 25);
    t('6h8110747bb4ec5', '5526770097051812790', 19);
    t('3kmiao', '64421584', 28);
    t('35b2ef5i09feda6bf2dfg56cfhc54123h74573h', '90100642513830363534883950760191394857528151082877', 20);
    t('4j10knam', '29062827147', 25);
    t('9dj8geg', '620710696', 20);
    t('100100101111011101011001111110000010001001100010101110000010010011111100100011110010001010000110100000010111011111110', '95386528077312833528510117745536766', 2);
    t('37odmlq4t1cphe42', '46784748191707671321722', 30);
    t('3cg8jhkdc1b1dd644hf6g3ff4fhbc', '37974153903814605133910844090810871839', 21);
    t('2d90a4719837dbaca346e54796196aa4c39a29d7028', '72320014326190529207268511298086237053386258031788', 15);
    t('221112010143201440041132340304141040211331000103002002341243330240031303', '103772284529022914388035430657679022322741387814578', 5);
    t('234', '123', 7);
    t('1gbj8j3f3g4fc7afcg', '23985271553951719606256', 20);
    t('16dhfi679ge8cdahc0f5c3de64', '126062950519944159766121561159030', 19);
    t('2110001020000212001221110002112102201001012101102121211212111212200211202111112122101002222112', '576441067410056461483703142176818271029941704', 3);
    t('1400010200522020432130022505551242315132004422311315214250500552', '17595958038682732910920374172787533846127463600692', 6);
    t('1100', '36', 3);
    t('132133002330203222133230301300333012000022322212301213111003301031330013313211', '43509780485649606280607371868487166230944316901', 4);
    t('111111220020010200200211011122002020002221111000112101211122021112110021011010120000011110110011', '3184810401058738852989667333232201616049894969', 3);
    t('p2190d2m471f14c7m5jinn', '128683057515715021320115217552355', 29);
    t('66607051535464671602731746325356021372265', '9099202145653789818834446363266512053', 8);
    t('rxxwxwhb9cp2sndulf513ch', '137941140090442856448979588513676333', 34);
    t('5v1as3h7gkt', '9098519834770439', 33);
    t('23323330311211123313232', '52498284264942', 4);
    t('1j6l4lj3lda2ah', '927009955843875697', 23);
    t('10u4an3sxhdjqbpdd1', '111253813312875559803626727', 34);
    t('n65aacems59afhei0i128qcjobg', '5898638281362823389060707803600314054946', 30);
    t('1c69', '16597', 22);
    t('472035076601272777773466260770745221025541771310455547267433', '940021031620376267748547570264155096359926520862306075', 8);
    t('72', '79', 11);
    t('19398c170gfcg64f843af17bgaa1a241947c', '129947852827238055712040360831603626896491442', 18);
    t('101418606067268463402226345262270255081', '1857887598344404806997185438936620857', 9);
    t('81mgdn230a75egkmiald7995gagm911', '2059707806285597627503761733243610129021017', 24);
    t('2gllk780bm04e8lfmcekjgcfh07d27', '286479826696535775464273610901096241568391', 26);
    t('122120012022201210200121222211001112112110221211212120212010011011001', '542747711299361252116322470317832', 3);
    t('36bjnnofqm2f7ibl0n8hel8re350b7ff', '2349614933088599651464732173196752378742407779', 28);
    t('2', '2', 17);
    t('1901f2f75eddf8bif1dai18d2d', '486612954588567587212842937829253', 20);
    t('fpr72ngapr11bdjarrjra8m3q0idnhcg7', '324494898071507461877053978943272748028566739783', 28);
    t('mriospvubhhkbhhknl2', '84091461121613338404016434744', 34);
    t('1gbxzhqfotpmsr', '247967926192484011179', 36);
    t('171c43', '1119888', 15);
    t('719d9ae0j06dc5k', '148475592775622801804', 24);
    t('bfacgjw4l', '16123175442252', 33);
    t('27nc9ja3ildcbpu92tmf', '48762307359506883152233969612', 31);
    t('35100215607256233370100157131103657413347736114726441', '332554887108209374458014391052845453182019808545', 8);
    t('2d', '43', 15);
    t('61g7883dd3a55cfamm4307l26gd5qn', '1958734810273792705789246918934822143371545', 27);
    t('jaa6397qhgfh47nj48ad3f4pg', '436699483716932159117919657451490464', 27);
    t('7a9e8u030c2mlmislh2iq', '4925854031564503132850322969410', 31);
    t('8dc', '3147', 19);
    t('165130926947488295413682234912291953857277202438', '165130926947488295413682234912291953857277202438', 10);
    t('2', '2', 35);
    t('g7n4l', '15007121', 31);
    t('2000201212021200110122', '21205710026', 3);
    t('256e27c683g7e28444fe68dfg37', '227373590164376719118580707971549', 17);
    t('3589ma16bn', '8514389402783', 24);
    t('peqek92fb83fml55k4f7qa567ja', '1079505469268043886172306636663444862734', 28);
    t('i6okun8rle5lgo2klrg7r24l1o48r9', '812263483616430907150828319601346058339361641', 32);
    t('ffjb', '167409', 22);
    t('16899758c5637027cc4509197a0806151b1b', '1472124298781451615642290787701974764196', 13);
    t('dk50dq28hq0b9', '7265988549586872339', 30);
    t('79f', '2191', 17);
    t('69', '99', 15);
    t('72da992618353861841c01d4687073a8d516', '93886242244818385595059361163892476186560', 14);
    t('aki9bbh89fh87m8l1aa4a9l5g7bffm0h88385', '114763233555248086785759194797816098143926938310370', 23);
    t('184b51amh5', '3542898368285', 24);
    t('10034412103112330433111411132332013242104321130404032331313343', '4474599918067555064654041662068659458463598', 5);
    t('rj5hgcjcce4heh0bafh', '5821635304368037800119927690', 29);
    t('i237h1j32f357', '232647752169124233', 22);
    t('23127102426b', '4010576357201', 13);
    t('111111101111110011111000011001110101001101110000000011000', '143545575800234008', 2);
    t('676884', '405319', 9);
    t('42k68dbf4fcc250l5k282505m4imcfc', '293284630414438750039663958568928524711326', 23);
    t('g31j84ai', '20678305818', 20);
    t('0', '0', 3);
    t('1ar451i41igd3prsian71prim0lseslbh', '86238754807491960819075362998411526539819962332', 29);
    t('111011100110001111100001101100100100', '63992372004', 2);
    t('bc053tka9gjboqptfug8764vteewhtn', '40826388795618571128129367769621369352492615884', 33);
    t('bb972', '248486', 12);
    t('i1qamkq1pfuin9eo', '3989956977379744422840672', 36);
    t('361524917', '361524917', 10);
    t('57b08jkec82938i3khak1b6c', '13806151720864861977227556530364', 21);
    t('6ech2h1890', '94263489226286', 29);
    t('1j5o5jmn9jafbdn4nn', '6738409255222242873889819', 28);
    t('15cmpsn09too2c', '43116122218866434124', 32);
    t('811', '980', 11);
    t('4', '4', 9);
    t('3492n', '2546183', 30);
    t('c503f', '1026883', 17);
    t('c8841d8a3e0c3184a1d13f24b7c8abcbf36', '1091713357762058306584556087055815769112374', 16);
    t('101111111110', '3070', 2);
    t('crsczl5y5f6wtp9lh3gh798ir8lusu', '17339136471721411584933213471118181624608588590', 36);
    t('1fq5bta3pagdp8okhgs53f7clioamk37ko8', '255008927803374998828799238728878199583965626637728', 30);
    t('210873084153651612242427773566076226832', '3874424403685633658520167970745713578', 9);
    t('3db0523a24e245743553', '86803771432248580685703', 15);
    t('40324414', '323734', 5);
    t('5d6ka3abcc68880h', '767243912601976420529', 22);
    t('c38lqjl46kabetl5qlj1r9oitjij', '92343694633170266121595556492720749580659', 30);
    t('40552355236034366411121260630', '1894076705177959214150189', 7);
    t('f8o42sl1bgh8oefa73djm5nbcqj2pfkiqd', '250697214887739481273552937511044544495638076630497', 31);
    t('ldb4lgkib', '30103008932711', 33);
    t('2', '2', 19);
    t('pk06i2ceg0', '272020641434528', 28);
    t('1010001000100010110011010000100001000001111010001100001000000001011001110100101110101000001010001110101011100111111100100001010010110010000011001000110101100011100000110001', '3791391092894496185657389426598978260806574313715761', 2);
    t('2930', '4788', 12);
    t('11011011001101101111100101010011000101000100', '15064322355524', 2);
    t('4nz549mpd2ekdoe', '28653665664075364608062', 36);
    t('k1b3b27gf1', '15943538449567', 21);
    t('1fl9ian76dblfa44hgkle1j2la', '145148177867836192856283849258501785', 25);
    t('5sr', '6759', 34);
    t('0', '0', 10);
    t('f9h', '12029', 28);
    t('30ijdbbc1fb48dqb5h0a54ij3', '163061899281675414544508578695564599', 28);
    t('11499i6bb7j9jcl22gfc691jkaijl9g70644hjf5', '23854750315423368837146215349983736231413256524952211', 22);
    t('1os4p3n5ytmn', '164971754456015943', 35);
    t('gbek5ifl9uvccwl', '29691120613113956443083', 33);
    t('244668499127028e83bb4181', '2565913383528918683684970721', 15);
    t('4t3cdnbdu3hi', '125493059871385556', 31);
    t('33444410431312132044442214340', '141551939616015585595', 5);
    t('f0e18mang1ckb83o6d02lm5p7mo4a2j4', '1098667950936590953496178062298824527159019274', 26);
    t('10000010110111110100000101001001001011110100001100011111011011000110110011100000000101101', '316429297174908011263148077', 2);
    t('10010111000101010011011101101001010010011100110100111100001', '340208393737103841', 2);
    t('4455190b50557152a56aa689', '28956950424301470445177161', 12);
    t('30178a990619211a65284', '2027761131843662253152', 11);
    t('32adibdic3507e964', '904264457185802878114', 19);
    t('1402203332505114241034521554031304', '80106131292450875184746488', 6);
    t('1b7e6bfdgaf8h618hh396d94gf99660f2ah3', '140638185851643426335154839361249634663210461', 18);
    t('4n02qr0qcjn', '1428131533975659', 28);
    t('722062570016143', '32030085618787', 8);
    t('12h1wrii6xf1isrxgxotoxf0k4rs', '240306175962933523255986233934776980691330', 34);
    t('271132ed2156b56ba2264090d5', '624075202158401303369210786825', 15);
    t('cbbe0ifb0ecg0eefifca0861754ad2gi2e5acc9af', '17820079854097348669358676176262454365377640065197275', 19);
    t('d488h34b78i092jn5ki28d4hd0a2def3', '80631173055200461094000840558382509399473899', 24);
    t('kai', '14868', 27);
    t('74663674130162363012065031725670307006351247702', '2650448086139415170144453379569169365028802', 8);
    t('410ek648686h', '3853830909449054', 23);
    t('112122110102210020020200021022102221202202200122111210110112201002', '16764033406503354998216612366594', 3);
    t('5a9ag0c99d9faad76g1eg9egegg3b6bc98d4140', '2801521663446241132823944236302962625699717089212', 18);
    t('bfbi5a6afj45iah666dk760bd509af6', '219330264685128598444241632527479365312816', 22);
    t('oi3j09e1m2dd9498c12fd1', '5622045359644445263576289494076', 25);
    t('1403606123334625332112530636430620636042', '1439558915530889901212705116835520', 7);
    t('111111100100110000000000001000101001001001101101011000001011100001010001100110111110010111111101000100000010001001111000111011111000100101000100000100000001111100011011101011101000', '1522300117779563676992926268294212750701795813499189992', 2);
    t('32f9e995', '1301412242', 17);
    t('2l900ee2', '9976339380', 23);
    t('v998ik9huu', '1451808320253717', 33);
    t('20460428a2a42366480a4650481749aa', '391102418677365044663717119852919', 11);
    t('111111000111011011001001111100100111', '67770294055', 2);
    t('50ce3', '4629574', 31);
    t('54ig18iqae2tph', '606662590569600162167', 35);
    t('4f4jav5ke8j9w', '10607946018036371326', 34);
    t('435gmb5r5s9bbkbqo8pn8nis', '17742072943258762084938672774179567', 29);
    t('210010022141321034344014413321311333243103213404021224344141321142101100141', '11655341046605487362673272556680098862550253021893796', 5);
    t('11703652371245327270875136818411753701245105114621364', '50015363250812413592978674160611932885342581878621', 9);
    t('100110111011000001111100110000100110011010001010000000100000011101101011110100000100010110011101001000010000100101010101010011111010110100011101', '13562459849657731179062132755251654390951197', 2);
    t('f55ch081bgiqjfoi580i5027j5ibnm4g', '93717655210173870936123983046544755878321950936', 30);
    t('14c7bd9g8fgegf4598ig78db559egei', '286902761703352399115713383654173395387', 19);
    t('if9644b9hjb53je550iggh2095h', '125985325474900384130099682358723717', 20);
    t('436j48e17g8hhbad8l02', '309158322644714941880361057', 23);
    t('19395107722a624381360a3a37388491485545493', '837334765628822776393052128437254413732612', 11);
    t('2f2ebnnd84moej1fh5g', '284114881218993578999222252', 28);
    t('2266ce3388fee3c292256', '2599310186932964178862678', 16);
    t('12f09b', '2839808', 19);
    t('3v1lrp1nu0', '139695817285568', 32);
    t('26234', '26234', 10);
    t('8546683557740281816235016708082647838436361741010513', '39956203753802223948047814344332292828203738992921', 9);
    t('224130321113431331234124334203030021101242314334043412423133', '446347968128646822230071497717582810279793', 5);
    t('122784354735470573734278130737225806820754754778367', '648246815949675714466794273511802263245293730952', 9);
    t('522bb0cac72011727319b7ab67075037aba2', '5030349684335489902148585919042821411528', 13);
    t('784afb326df4e14f44919e903da2daab2c6a8c2b7', '10988016479801545098971638340838655979698598232759', 16);
    t('1', '1', 6);
    t('1a', '40', 30);
    t('1140625615021215040452466121535636111', '3254092286706201839308923015042', 7);
    t('15oonil2fhic899aaec4im0hpda0ghi', '3458063037512129270731260341461940831158412', 26);
    t('5qf0e4a8gcpyoh', '680672672565382003132', 35);
    t('r6t5mdbk2bhbksd79sk267f7kj6etr76ch2', '13843573438903736667979936265567288587972581206329575', 31);
    t('5i5a32b13if5hd6b27ie1abd4d7831fb83335fh', '23338871699861348992667980731442144357549336414583', 19);
    t('965h512b2a26efd4hihi4h7ch5deb10ig', '776421006283852166648096674359365276607441', 19);
    t('23cc00a57842c825b2b73', '190753980657808903079377', 14);
    t('84fgd0b838027260hghf3b1i', '6911861868573500849174840828438', 20);
    t('32024343310', '33434205', 5);
    t('2g25ae07b9bd0d8953dgg9c9', '215312595589787196108811324581', 18);
    t('2c7516b990ec844c7a113d5gc84977g6', '380417281882594767106673659584705172801', 17);
    t('3937e11053978eaa8b', '356239468690396944881', 15);
    t('423540545131050354211054225420050220141241010244114235255451', '36191168862496053559216924657081367445614940343', 6);
    t('1mq', '1349', 27);
    t('41336630208066014426507600014561516256045788602138888685', '126394964103942872413285726629499765226015930689454252', 9);
    t('23812465082116078023663065846540105844417', '359745322984251038213859961958548558564', 9);
    t('32731602b73c56641e0a549720ac684047dc186d2e', '5250067280281468268057767492160429729760400843844', 15);
    t('207', '457', 15);
    t('221016156567502', '9966232203074', 8);
    t('3', '3', 4);
    t('149390610a9a', '5397912566784', 14);
    t('1', '1', 31);
    t('1100210011201102102100222212220201010222002011211211201', '79222020471668857707359281', 3);
    t('oumnfcjqawvoiu2umob4hel', '63683659777115454000636977806709805', 33);
    t('121a8gdf0bg5ee492017d', '4565149191282994738546034', 17);
    t('101100010010', '2834', 2);
    t('sfb31qelcjas', '348085994301840276', 29);
    t('761570133215525640271', '8966391655604633785', 8);
    t('k6ljbii1b950a29q', '290193032454717352772096', 30);
    t('14444133312304020024142413311244142024204432230212103022143102', '8669102161750148059985951449842543267771652', 5);
    t('4fg703204ae6653c6b3j4a9jf2ej1j', '257208195071681839222502187276784439639', 20);
    t('1c0f6se081r4nf9rfr9te43d1e5c13', '24646533503075931130110785406893472989210500', 31);
    t('5855387560621204', '1226716470634171', 9);
    t('256907', '3289405', 17);
    t('99igokmb20gb41jlqag2731bjn641pa8m11', '149265576178669580878869535449967114241115964835709', 28);
    t('17g40f10cl36712efi6bc47g777e801bm77421fi', '170939473992155811269351752741318276877107096372302484', 23);
    t('64647672689', '64647672689', 10);
    t('1643632561314231340041002365410010553', '5171467731134228257724052634904', 7);
    t('47d', '1149', 16);
    t('393ba729770d6505a3118287502dcc939639a85a1803', '70352045253191285526358196586767060137043932511707', 14);
    t('1khg50kik085caak5a', '59864078118328974774637', 21);
    t('5tcqa', '4844590', 30);
    t('4bn43k601jd9rsbjtjelutf1u5krrthabjc', '2226709914233178306419196997863309807078435719529623', 31);
    t('j21c171a63p', '21463980112681081', 32);
    t('735f0a94g0', '853457045557', 17);
    t('31', '58', 19);
    t('11303315150321412253104251022353441041322125054241231155444320242', '79348974866336815279783368738596691903140624659106', 6);
    t('emtnivvcvpbofbjwx00q5r', '7042313029555078022883072758212719', 36);
    t('1111111011110011111100001011100110001010100001111100110011010001101011000001000000001100000011101000111101100011000110111111110111111111111111010101011', '2842819740151363791267849959009928040708832939', 2);
    t('11124', '789', 5);
    t('263460', '160029', 9);
    t('132020230022232233001012312110000320', '2223628314707328843832', 4);
    t('qmatp6x7x0i7kwww9ru3g74fg31u', '13041558211114994891605591496874198058411615', 35);
    t('1212432456235400016312330136544614313425566221424415544351423', '667449638793600765524787631521077125935234478926704', 7);
    t('613b8b5', '101955765', 16);
    t('1nbehnbn3k7io1e9h6', '2156225812589011334673092', 26);
    t('101530101442425775517477023774', '158785455373148008304355324', 8);
    t('8393265877750', '8393265877750', 10);
    t('gejki8ped057na8', '1068784882324809922800', 26);
    t('35524gbcgd415cg72e5385a3a687bbfa', '2698475481148714592199279711100304788108', 18);
    t('1li6168emf0glp8b74bcgnf49', '16707705100794731252094321598976869', 26);
    t('4ujg9feb5lsbwn83p1ftqv85a966nujwd', '19276486249671857007076018238589272537818685313529', 33);
    t('7k', '167', 21);
    t('bbwtg5482u5u125jwaw4grahxsl2wv6', '99870770755356292494097529732122977160595962180', 34);
    t('12102302311130033133311221232311233111030032222222300300020200302332222313211130221', '36792782803022052519563878572962189298755425949481', 4);
    t('39fd0kdiglo6f1', '13594585461735594178', 27);
    t('30214311524250615152333025534506', '480518635808621857675890962', 7);
    t('33736082402621341865465256743878261', '952533655583805522673631866039924', 9);
    t('15536323540072537510214740648724651474', '328944392163793117310283327346967335', 9);
    t('baajk2e9jcgcbk4a', '783476238643207986019', 21);
    t('78s0h42a7', '3656391077499', 29);
    t('5jipugkahalhjqpash1', '3937423681465917065890170274', 31);
    t('aba12217aa326a16084a45', '505448814884269683427541', 12);
    t('g8db2dff76', '5311016260900', 19);
    t('fblgab2', '4774316536', 26);
    t('cw0b3rp0nqac6rkqjm1a', '2807837344213103415524527607870', 35);
    t('2220221212200221020001120101000021222', '438934738823378954', 3);
    t('853iy2c2t9n5skt9ncntdinxj9hw', '8528601144540421131583349837423197612512212', 36);
    t('enld1pqd72iiaah331p4c31sjricj', '8459371819370199255275975857354512812858013', 31);
    t('374160464102717737077444644401061474361141636', '21456498302081433312710883059235111093150', 8);
    t('5bnlih4kc679j7c1g4k3hak8eanfk2cd75', '74243343685087721564583592254567964316602539555', 25);
    t('i291e', '2362778', 19);
    t('ff4e0b01g44379g699bgc30c8gb2a1e393a01b', '53454133794642577998107664307448664264718891224', 17);
    t('h6g', '19872', 34);
    t('hff', '6437', 19);
    t('201301132320130302211011203213010', '38937807697351162308', 4);
    t('el2i1c1kvnf4n9a', '17306001852428266396970', 32);
    t('llor', '586647', 30);
    t('18f0l3un7hx6v3l6xu6whg0c854kolmeb', '12695193933193179158621509296985565216876568630503', 34);
    t('2ehm00rlkmf', '1053398216187932', 29);
    t('60lb29l4bkkbb6bnlccd5557h43h78', '209357188819429378059650212593873946932683', 25);
    t('r4b', '33226', 35);
    t('31222304042332433414413402401331030144230123012203422141033420300', '1789049338874374103059075210410623287931935700', 5);
    t('13abbda6aa99c3c209c60266c69080c', '30726786430113013257219600561452028', 14);
    t('262643168493430786031', '262643168493430786031', 10);
    t('1100122100212202211210011021210022012211112201000122102110221222202200012220101210', '601798443643669936350054442563165420687', 3);
    t('14otqenu046jhlxo4ptmng1u', '190810415328770416971685556952127736', 34);
    t('da4h7jm2gf386iojnaq5ce1d25gl', '15818738612601844466551284963021649225125', 28);
    t('100110100000100110110110010101000101011000001100010101011110100101000010101001100000001110111010100101010010', '195266285040805814110355923380562', 2);
    t('488342231251751346242311', '44247487379947531811290', 9);
    t('2h8bfc33dhb130bgd6d37', '37877193351326116690267633', 18);
    t('3r2q2kd0md', '135336655487693', 32);
    t('23332231413342023', '7332327145311', 6);
    t('265735ecgdd4b353h3472743a3', '56608285630040709994361807982867', 18);
    t('36gq75xn8dkj1vgvsz00l', '42502936499191450526350062396117', 36);
    t('eh7dtarl9r36qaa4mhmk7', '9778676538945889058686790375871', 31);
    t('14803558684458a2993a0a32099467a0614194730', '647203408320127342024090091627696455000077', 11);
    t('1451431412002040323331043104330', '400960425098607615886590', 6);
    t('297p13lh5gepa3ecdhhco', '99373684147185210906053364513', 27);
    t('1301432143220', '394412310', 5);
    t('33', '87', 28);
    t('432231350515154632', '1041384299764405', 7);
    t('313121410300242022022133', '39718036029485918', 5);
    t('6b63', '27491', 16);
    t('682b3', '189426', 13);
    t('7219653551a624979495a91a8', '70891355956396038181400257', 11);
    t('33002231111131', '252368221', 4);
    t('4d88ggej8i58d', '59239205589626625', 22);
    t('34451601353532653611436161142566545211336115564531652', '323278188886248967529158547940775990624674072', 7);
    t('1is5noptlnirtdb3fvp5n', '2015588554685716212306054997175', 32);
    t('bha5cgdkjk0d', '4144765439844616', 21);
    t('27a25d8j516cdi4d7b', '70786447958357042929196', 21);
    t('1586', '2030', 11);
    t('31342760667031767334646421766116726252335314714', '1108212082493888677367272229520408961194444', 8);
    t('28546553', '14143782', 9);
    t('257jd0p4o', '460207294324', 26);
    t('2lafklt78vxkn9xllik', '9683449653483437263505971556', 34);
    t('2d3777760a984a21c97a0d20c628c419cab2bfc67f', '66084232243819558824679961490043082487366953191039', 16);
    t('2eqb5xje', '127870218160', 34);
    t('272343723733570133550665013', '880462300728651545799179', 8);
    t('3kji6mhdk8no7jc8a9emhqr', '552688352219570858171515412726536', 29);
    t('45472185506624743014572972163525387956841', '45472185506624743014572972163525387956841', 10);
    t('27330316426437424646561612652414263301414200342717', '522342837272716004737400194551917026620851663', 8);
    t('2b32df51f67de8g8834c19eec0c3c9320bbc943a4c6', '12688544036802134995824223195793070866654304069676611', 17);
    t('101214044003251242303202220534005133043421420054520404513042300402350', '85236281669632536888419124917731749716268802441235130', 6);
    t('33', '27', 8);
    t('22014g67ff8bf1c644c2081d17bed81171c6526e75', '594721012934655345095358079862004270167442813594302', 17);
    t('2uejffgbg594', '75792588512668236', 31);
    t('6hedef5cg89aehbg029334ehibff5b', '84126707114035006726317668787251510718', 19);
    t('12c9942167ae93c737fc5ff39d', '1488492491002839592133151683485', 16);
    t('c2c44', '797764', 16);
    t('22112301432130424314234114214121144302343011224233033111040443413213434424', '2596351663106652674437417994841482826828643522405614', 5);
    t('447886b857b4442ae33e07b9c620', '244322955053028014376497119444380', 15);
    t('fe787f84cf0ae7655d44db4e793b2a98ae8f', '22167524012235587957931446373184044722073231', 16);
    t('ce00gfa61b35502ddea6ae08fa9e3c', '32311970180252432302213442175559249026', 18);
    t('6410235531675374505654365627', '15755268886904815024728983', 8);
    t('10421g292f1g86520b7g99743ffg', '1691511665188307722429188808830042', 17);
    t('hfhae73', '608398905', 18);
    t('1b02pnbb9fk2kt7hgejkfghaarsm03', '9380211704840395733125589366849221945645803', 30);
    t('1cmfc4mbkho', '303773375379894', 27);
    t('1011201211112002120002000021221000200212210122022200221211100002211020111201222', '19303102056479652797750726699461962392', 3);
    t('fmf7k2vvfli7js7qddj08lrrsvjjkqhlqp', '734369787776964304691750078309244157228282267883353', 32);
    t('b9r33ab', '10045230494', 31);
    t('2144b7bc8951804726196a6a744886dcc1ba41ad002cb', '563023243497677865341196187925034677481508487973787', 14);
    t('ab7', '1579', 12);
    t('11111101111011111000010011100001100110110110000101100', '8934565388446764', 2);
    t('121201210112011002210112122011102121100111200121201121221210210101', '19152206217272003533575256015003', 3);
    t('87ike7hc4c4e4csrtrunnah4', '165014231640248173568866466973234731', 31);
    t('6f40aa9gd3529589f6d6e8', '4857078092896960066845279294', 19);
    t('1000112300233023320333000013301220131002213013133010032002130232121200112', '22424670700759204990548756345478151954602006', 4);
    t('12010020202022011121200110122022012210210002011121220002010110220200022221212120022', '2270509037526981909994030317330177692336', 3);
    t('jtcrk8briibmd1', '734874456187380029857', 32);
    t('323ab6b303a0kh2cg', '4439310393102239451589', 21);
    t('132213311303211212102223130230213013330011030112320113113131211020222200130222310101', '179019401287519987440897017633826802507494397750545', 4);
    t('10421aa279', '10865826370', 13);
    t('28cbajpejjf18u', '264768966115047556535', 35);
    t('1u7nolh6bd6v0', '4507977116539696462', 34);
    t('54wmga17c', '7244724152205', 33);
    t('13uviq1i1r00087sqj8qncs9lo8', '1529924306777719202810742088266389182216', 32);
    t('5ds4b7nu00morbk', '6415012024329735794036', 32);
    t('34410186233', '12187121115', 9);
    t('47a1c4hbmma0gjf3b5kn914n4n', '381569904666915560937256750088358248', 25);
    t('54ttopkk9fmtu6764m54', '111825156831061493422412579685', 31);
    t('mgn', '18989', 29);
    t('10505055444011541442103154442231040330004242', '3299912455302280343771981626079042', 6);
    t('7g38gcdfb0972cd176561eff', '587323076724641878770901613469', 18);
    t('49106l58aqblku24m2mc62shsm30p9q5j3', '1474965748795651704391869363110766509836712354573853', 34);
    t('50258', '192550', 14);
    t('5025aa24a', '4090471668', 13);
    t('17515037027696b9a135497bab85868', '384282956567691349139467954115216', 12);
    t('573j1fe75j8a9f29ii7d34cb3jbbf', '14387834859916761337851572818723836635', 20);
    t('186b6b31486165c0bc8c778fd49af12ea08f7dad332', '571028668500605890623232664155788301681845784466226', 16);
    t('2313123220321101131302220130003331201011233103120', '227077642865109202959441786072', 4);
    t('7eejonl537c40faim9b', '222874151472317796433717213', 26);
    t('8k0oy5j231dhtdv5t8q7w5', '2283030198732051810335111155170075', 35);
    t('435045040612115113266114321225361030034215', '202006427408006640757853847254122093', 7);
    t('2akkgn3g1jsabehm6kgnnrpl26s2t4b', '3329280104777703639665143207138900680219128971', 32);
    t('20', '40', 20);
    t('111101011111010111100011011101010001111100010010110111101111010111011010000', '36297363457553334775504', 2);
    t('3222123012301022200330013311022', '4222998842413448522', 4);
    t('a2587983019413965124039', '832724865093143284531509', 11);
    t('akej63bg59kj4okd4oh5il012j8j0p', '1167589559975024794478346165128293255822901', 26);
    t('23c2he446d2g0a6gdi0fdee2gb6e5c', '26583275300599088108871698596507139368', 19);
    t('1jkeh637ms7gofnk8ood5i5kk1j22d', '4312562387308133742326791929397236729866296', 29);
    t('78837f5f773015da983e', '1792798252228672996730116', 17);
    t('1416c69100c21b05a22264796b', '9291730109537657404686437398', 13);
    t('93d8a93d28', '191813134864', 14);
    t('394a2167461768638586b2914b0b80667386548658', '667335229599904318812161808924349330646817188', 12);
    t('1wdsuoqsut7um45fo7d4', '140917464962232105605575506580', 33);
    t('4icn278aa75564g6j2olk7kl7fl5ga1n', '102797064941780765797751135934146317345959423', 25);
    t('9i002055a4hi6jaaadg3', '51904577968178133729685523', 20);
    t('1cvfqsut', '72490601641', 34);
    t('fj2je594k1j0bhf93b2de72373', '18079705921653558686576826974593824', 21);
    t('4240320213321034004', '17415886111754', 5);
    t('711966f187geaeb5bc7d207e32a43da8265e186864g5', '573279130756576280449162350505323079502754368266400507', 17);
    t('49271274804b36c488411958c67c8bb9c1486455', '130788357055261430585631300892818257979129537', 13);
    t('2dj4ib63771dfig859hcc0ab17hc03j', '2897080031583056937886505492750169216079', 20);
    t('2aef3ee6f864b26772c23cf6', '13287600730756091106849602806', 16);
    t('frcnn9hib7eog6f34l23', '628128512915374991101180138563', 32);
    t('1010111000111110100011011011100101010011110000101011000000010000010011101001010001111101111001110000010100010000111100100110001011001011110010100010111010010010100', '7958075089772384277251993017934409136873707500692', 2);
    t('46h51n7bh5n7n86njh37fhihc3d79cj8h', '628335332219766512635376856539379172420010897', 24);
    t('pciq4mdi1q9q22q9n3g', '2848254632326814305960656020', 28);
    t('1', '1', 29);
    t('2f826f687ie3h5h39', '1815538753739148366869', 20);
    t('85224600844450714154447', '8452979833566085087057', 9);
    t('2ncrhr4rasjjeqaajq4341jr09r', '1642784213600589272925380877043975840644', 31);
    t('a00', '1210', 11);
    t('56c717da4g7863c4127229b838b42dgbbf7g1132', '5242908799066029717292077136248328396959421188623', 17);
    t('293684b63150b4456438340064cbc788c4b01', '34310245908660290962930216560562702368986', 13);
    t('40cc56abcc240', '94978404251094', 13);
    t('218903cf27a47178b456e4cea5e470f7ae51670db5', '586417501992499293536891609375926193432812131092364', 17);
    t('d15wq1nleg7u549dadd0718e', '2183292000236241138234881147030692666', 34);
    t('1113023440200122202434101414400101', '147253000878996390387526', 5);
    t('193c4c1a69add29d9a5101ced0568697d923', '2198325248780085112365807036920470754023715', 16);
    t('11a507516c68d662f15d9', '1333191524844399246644697', 16);
    t('138246022172800612014535', '12723226204164688321097', 9);
    t('2f', '67', 26);
    t('n9bbffps4ij483m9p4lfeon74jmdernad', '4319880888388973123665036793081840398907295990013', 30);
    t('9nrr20re0e90il9hi49fijfrk3el', '11668527008401372147103143919940731784397', 28);
    t('110200020222202010012012000002001020120022212111121202111121101021', '14508751609178069453862292358287', 3);
    t('401014110441023423013340310213213401002003324434144220111030', '701341637605553414959898651614073338832015', 5);
    t('16d1438563c3dab89cac1b8a2b02c9ab92652cd016087', '402145454893768368538070238910742261904151734958103', 14);
    t('16c430ih94bdgcd', '1078369041154387027', 19);
    t('6rrmvjny73f40mqhlbav2u92ly8xhs0yl', '174704136528249902816525420461236150502024477152961', 35);
    t('6h0g8ijlelligfeh699i4lfm4', '8948723159164161623690376517243348', 24);
    t('909697005b', '186948429217', 14);
    t('205ftjhgh6bthp9i71h51r9mrade01sii1jkr', '301112010317868572084712100360200322156165974734024727', 30);
    t('20ij24h4d1j9jj50', '1890604943011908121375', 25);
    t('221011001021222000210020222201200120101000', '101921456153063705544', 3);
    t('m2nhkcpq0r16jd3jgm', '160361482760888867774119965', 29);
    t('14065304637358947988886', '14065304637358947988886', 10);
    t('jg2ii78j380j', '6924453033870937', 21);
    t('mi0m64bfip6rsb53ol2oscllcoe', '2381613436643734921316429121959549049180', 29);
    t('11101000111010011101011001100100101001110111101110110100011001011111101111100100111011111100010011101111001010001100', '75584728662217792152893436906631820', 2);
    t('90169650', '90169650', 10);
    t('0', '0', 23);
    t('9m7fl', '4504599', 26);
    t('462207311743', '41106117603', 8);
    t('apjbn7lln0l9xau8pxi', '39637920958143725832613021304', 34);
    t('127dc0ab6f59gd8955b', '16097431569685397455342', 17);
    t('273h4fd', '81667075', 18);
    t('1isgbdtssth73e6es382gs5k13rci6ob9u', '74377241800512845181909478165136810275516650892606', 32);
    t('3', '3', 25);
    t('ad4684a', '124002745', 15);
    t('4aa54680539bb5a81c6a665694717a30a525a0045', '1744843150071734423605691580172448713985937039', 13);
    t('5c8n1tpje68ud2mu125nttg62entnlc', '7683611140873419478117143666838299771020435116', 32);
    t('fa7f', '187971', 23);
    t('22215', '3107', 6);
    t('52a326814a947496353844318285bb39b066903', '534626397264431225021347981842706300601235', 12);
    t('322011015154252234042', '12393630663355754', 6);
    t('a2669c148f4ea9e', '731388268367899294', 16);
    t('5d10e2dd05007', '12587319228711547', 19);
    t('ed2a498f218583395d57871', '4587441849070983049702111345', 16);
    t('16bdq35kl27kdjj71no6sf4k0', '152793950271880209148219854505487346', 29);
    t('10431071513a9ck3iaa47hdgecchf9he29', '43381023423292724420039310610763756891127936', 21);
    t('5dbf71b1', '7269656621', 20);
    t('10011010111100000001000010101000111000100111', '10647241395751', 2);
    t('jpkpcjbvt1kvasvw0o3', '42599410634040128543688914739', 33);
    t('128308731332831865326', '16111972802247011835', 9);
    t('35434021473746', '2030987278310', 8);
    t('127cc6cdaf7qa1kc', '3203387745871429565940', 27);
    t('10766710063735420744724674434722341532775011206477', '200309946175742618027595387139557376886377791', 8);
    t('32112213201233103231130113312210200302012032213313131032', '4657944669466625109696536299665230', 4);
    t('1bn51ig3p6da10fi41e', '83689955139542057791275209', 27);
    t('14j0emmo11eae3de0agnk4ff', '169171441207698617319338544456015', 25);
    t('1102002220022000112001222221211021202000220200', '4169673548357936837733', 3);
    t('7', '7', 14);
    t('340204213', '6175089', 6);
    t('1e', '32', 18);
    t('18c7c1610d38c2a024785', '136841031302109468114513', 14);
    t('31ueglor3822uu3gf35hm7gje1qj9jt6pe', '50259653982330318278094715762420803895196428266256', 31);
    t('236321451394c64', '8928832987449509', 13);
    t('5cslpmcp2rs872s2fr8rc2d2squils2w2', '21087793377200031159635076834353655172712568202115', 33);
    t('10gf', '7178', 19);
    t('7d0i834f9lbf8dl7977c1066d', '3633925888734055009195256007865654', 23);
    t('7iswwap4lp8p8j6i3pu2qnd04', '21064442780596247994135825814304247484', 33);
    t('1101001000000100000001010101100110000010101111011111001011110100000010011011101011110011000111101001111001101110110011000101001101100111011111111111011001111010000000000', '613876598207563084074184752663166261629198587982848', 2);
    t('r38bdsmlfkj5o5fgpn2sr37fh', '3394192241536374888033574057729932943', 29);
    t('pen', '24482', 31);
    t('1000100010101010011110010010110101110000011100110', '300531517677798', 2);
    t('374680', '1894648', 14);
    t('8a814d4d17641016e7', '857434943927347654942', 15);
    t('995aia8i7i534cd5a', '407923137231020478898464', 26);
    t('2', '2', 10);
    t('ei0k088eed6b8baak8863593jk5jg2f3bj0ce', '5914160321016074730951144567079146927255110936222', 21);
    t('605d40ca01bba94b5807', '36039226245164182578223', 14);
    t('2691817922ahd8h70hgfg450i6c', '15587210948018755081634733837607332', 20);
    t('22i4', '22664', 22);
    t('292529d755fcad39c17', '35683399481751866213677', 17);
    t('37a1997195385c7547', '31127908670407785724', 13);
    t('3cfh6q7qs3e8jee6tkjlpqq9a5i8itae', '21107782523772991850229603406241369125689392414', 30);
    t('7258001566030', '2060303030955', 9);
    t('1003141020014213142400041342114334000420', '1868009637795830437567875110', 5);
    t('2610ijgk2', '86541700184', 21);
    t('1msi', '47658', 30);
    t('3411241353543406436103214661', '236290896186624501227090', 7);
    t('kqqku6nh', '886989350792', 33);
    t('9dg966gcfea13ibihfhbi5ab3dh91189652h', '33298588133944531766622520550241012455771090057', 20);
    t('126d4x7', '1644209985', 34);
    t('b38kcknna398q', '12799947735241434394', 32);
    t('119597325350', '333730723810', 11);
    t('44toq1pb0t6sg08i2s76clauklu2ma', '73890216568631498105831170089909975464059440', 31);
    t('10100001111011110000000110100110101010010101001001111011110000101000110111000010000000100010111011', '200464110595405607835630307515', 2);
    t('qpkff9xbvnrd1n8t', '3872892307770646972701359', 35);
    t('15c07e8c84e0c2bi', '19681700319754445162', 19);
    t('13575006b4598b303a5410114ab2769b9578a58a237', '2728161815957558299608324450916107759586273483', 12);
    t('17l9ag', '18489184', 27);
    t('5m05rwmt4y', '443630110370824', 35);
    t('3ci69diccggg440b5', '2389318437192755872225', 20);
    t('1idml3gk', '80950718952', 34);
    t('127928787d5515718a438393d750a759455ca565b34', '1621680550245507449770648650226492957703885128306', 14);
    t('6t0gwhcj9gtqhtqv1e8vwinisj5r83mng', '26914594023358001953145365010867100117166476629602', 33);
    t('66rfq', '10393190', 36);
    t('l666idhbjuae0g3068871ejrtsokejq', '30248459681883725436709460504274517072248715898', 32);
    t('150620403643664355463463322516301634404212612006326044340316311', '43130882606292506635424332740606360103280488114152080', 7);
    t('41862475647386600025768161687222', '1609441597409751564405007398428', 9);
    t('265bb6js6mfj0thebap9qw3poall', '2273949182220992377824887028606074878128297', 36);
    t('2e80b229c', '145582396026', 22);
    t('448hp32fj2m6dg3fm759hf7mljjpn67n1h6fmo', '94146978337401409225278981432841045277813022960667856', 26);
    t('c530a0916607a5c2671239577c4a97', '2499620725800614133816439595702949', 13);
    t('97k68ef0g5jaj5d423nm3823', '518314667420525656062603410445363', 24);
    t('1252', '320', 6);
    t('754125931534429694233291', '754125931534429694233291', 10);
    t('3fg8dg94585b3940c4cb6e07f41bfcf61aea', '334073125271035216894226588458437368734495030', 18);
    t('1010662343214312332313544054462240410550513026053443303634422611', '178309037555490506292600092100168566672657290807577202', 7);
    t('30wc', '129757', 35);
    t('4320aaac', '266240883', 13);
    t('1539a246a76a609648858', '26736559541986486658071', 13);
    t('4', '4', 33);
    t('29gefgf8fg2bbc0j2gae2dfdg5aab081g7523edbad', '547963388106591613005337267146277208966777017739948613', 20);
    t('92d6a085a2c34a7428ed', '203795832889664860683148', 15);
    t('264652754111247167745300734100146216146065', '30046186741840723600384513771105209397', 8);
    t('23b62849704471426559815', '1286298360248279428215377', 12);
    t('222h1338d29055hgif', '11581651006107396744198', 19);
    t('8b7e0', '4473522', 27);
    t('1717051362601647', '67007056380839', 8);
    t('420547635403', '36601543427', 8);
    t('4n11affqj', '1822050938139', 28);
    t('101001100001010001110111111101100110001101100111011011101110000011111111011100', '196072603810916493443036', 2);
    t('kjj3ich1hi8927', '3235928371344402790', 21);
    t('1026cbcceedf14b4084c26ddb8d60', '28586225584974591487797016899842612', 17);
    t('5100303210200143452311', '113393272692833971', 6);
    t('31c', '3312', 33);
    t('b8a04fb11aadbgcd194aebfcaa140fg85aha', '986969674191993486338612160880717878632568844', 18);
    t('qx25up2', '41667188532', 34);
    t('2042243400202111330011234030111430404114414112200340102313410330022024', '3694289161066978099428391349384630089650597110889', 5);
    t('7e4cib6408d', '128053581918877', 21);
    t('3dkla1bq60rov4', '400737723756673959989', 35);
    t('1112001210', '29937', 3);
    t('11000022220202112001012222221012122202100012010210220211221201112011000021', '90389162760212801316792406240633498', 3);
    t('104402113303233132403332320314443334301340343223200420040204122102', '3232890541201633751697810007380727413369989027', 5);
    t('31347902', '31347902', 10);
    t('du', '472', 34);
    t('111000100110111111111101111111100010111000011111110101000111011000110010110000100100010110010100101000101000111100010011110101010011101110011011100', '157803884622143105853315584471057717069995228', 2);
    t('2la86sdx095fp9olfp3cd', '34638184595229945075220814528557', 36);
    t('mbppcgg', '16326236296', 30);
    t('ik3heeah89k44040852hcbjdad1bd0dgj26356d', '3328101869145288095897995482276848932558602785015740', 21);
    t('248lhk5e9bh6', '2087440191630642', 23);
    t('48b381a9cc6bd2259838e067176d166b03de75b48b52', '1710407976429394820093761786315250202911786143975802', 15);
    t('11120241101421342112022021114234', '5852950522529808769944', 5);
    t('10a86b3888445869a814001084b9b71a27b8854486', '189496275017394315065342874001655116260299430', 12);
    t('113650166605747526017701737745742053073656134564465203303', '443294363845688739540957905727674168806539626088131', 8);
    t('1403535540244734200354', '13901404808061976812', 8);
    t('oi2e0u6dv564iip091kv1svcs', '279954224614775983979370462509946073923', 35);
    t('3m81k0kg3dk87dhgk8e605k9c', '1907459221327034327466909784285991', 23);
    t('122463220110011161460202464352', '4317537278759647032243456', 7);
    t('12a2112333a', '32837849428', 11);
    t('343e', '55524', 26);
    t('7', '7', 9);
    t('5340a04h093ha55', '8454246524189420105', 20);
    t('1t6597dtoc6a60r96asbjt2kkdkmdhgdg', '365699081636314950725064929820331423361435603806', 30);
    t('70accd12646c3668ad5a94bcb5a46a9594d615dbb4', '691498804549708730481403267581768571471127086226', 14);
    t('14231502342125123444', '1058783927560948', 6);
    t('h16uh99gks0oke4jm1', '1112042758022780182454147425', 33);
    t('180235996184901794802', '180235996184901794802', 10);
    t('199eqcuo494p', '33035755412380307', 31);
    t('15vcnwm360nhtrsdcg170j95ic9', '16344915028963724309159916980885883220604', 35);
    t('1fbbac5129573', '558254565528947', 16);
    t('74712131706533505237435313', '287567912644119793384139', 8);
    t('2120102201101112121220222000121120121200212022010202121020200001022', '79471474421937214637587196749697', 3);
    t('6k56ciqjbp09cecihitc2s9ci401s1o', '1373800350782015189643171446697543684559252254', 30);
    t('483911671045098021', '483911671045098021', 10);
    t('6ls4rklq68eg57k39771ongp5', '1901116087770507341357362812137376155', 30);
    t('62534342550506655221142232301622406', '346261030417237040471354955721', 7);
    t('3d3gi2aec6h4iaj274341ij04b8adb5i6424', '12574335526418428815722193942856616209362929644', 20);
    t('9dhgbffi73bm8ig6j6gmb465bgfg', '56087289901202292671877462355609399160', 23);
    t('jo0mgo65i01d2', '1189795222467969702', 25);
    t('2fmgko7cif2id3n4', '7641584157166496651380', 27);
    t('11ers038dn31h4q0jwwitaigbls', '6861444888213865174920042415409636982706', 34);
    t('38204aa633aa43727a069aba97ab5495546', '18117724934806126020578044715213143494', 12);
    t('4383536346071054764058653730600', '188091218363927447542822724322', 9);
    t('16195113650897769995630', '16195113650897769995630', 10);
    t('b07264b2abe1878a5340ceead0', '2785665573207221854518665183445', 15);
    t('2sfd3nd98gbq14g7j1q57csr07p3eenjlcr', '492057936249730728996372928617044050859159675362287', 30);
    t('5b5192543b4a303561a88b728', '473197943789271561906525776', 12);
    t('1b91780b06a70cf46e5fa0fa8e63407e80030f027a', '40291024919626546988689644749021723762456102109818', 16);
    t('1hvatyxzin2h7omp4c2vx1ngdnegv7pzju', '3412107642788556261980502714401988369603559696843578', 36);
    t('4bjd23t2r9gpt2dbrjpwtuw', '11115017221742953718461821513987449', 33);
    t('8302a02', '14659515', 11);
    t('p5rfvi61d3hfog2h9tabq5lbaa8h9lr', '35942528587984060838184369332151588523281524411', 32);
    t('4g34hp2kfaa79kk3dgfo0emn528609', '499893475952157966556029154241504867485217', 26);
    t('9k8kf4kea69420f4b85h42gf9if75', '104943512895974446884235378529723561312', 21);
    t('3gdjkct3qhipsqae8uz', '35635251197434521507651851867', 36);
    t('66kk1e4bk592m8dk', '1679888991376791562911', 23);
    t('3', '3', 20);
    t('10h6pig', '316807208', 26);
    t('iq49obnbtrfnr97tl', '22747999482124841946226613', 32);
    t('5136777371700436', '182450142019870', 8);
    t('23gddce4e', '15588339003', 17);
    t('53', '93', 18);
    t('366abb213203b8f4cd9e1788f81deegc664cb', '5191961241144177945785597152999737524951590787', 18);
    t('5c171421', '2343354801', 17);
    t('5', '5', 36);
    t('110113511313646244303100', '31375848110336055984', 7);
    t('d62116b5b5eba94c98e1', '297260523753065332755511', 15);
    t('25a90a2b75d596836e10d26ec831', '763841862190387816235893777156145', 16);
    t('25142514424542535314551544304432', '3822616861518711367435556', 6);
    t('1', '1', 22);
    t('60gcc66e9d5h7i96g84', '629571193297266217720396', 19);
    t('557', '2537', 22);
    t('57b890a83c6a982606918', '106570504349447291847546', 13);
    t('1ko1l0ioi13ml70237k46e', '418030558143625054474397580789', 25);
    t('gjq69grls56a81maharg3k1h9ne80k3gb8', '92627603492627444203230902129810925855579328295738', 30);
    t('198e45c5b8957ca80347ee693c5', '6210993456975719701341596528735', 15);
    t('1c622c6a62cbcb908073c', '37242012395034880960188', 13);
    t('8067bcggh07c550c58312f4gf730feajdgg0', '27542586791389756078137842819468361236131150720', 20);
    t('1339017669669006742006795785006474', '1339017669669006742006795785006474', 10);
    t('110110010011000000100001111100110101001101010111100100111001000111000001011100011001111011010100100000010100101101110000110010', '72173098483072489213930426080106306610', 2);
    t('1akbifk7n24n', '11471452525560295', 28);
    t('11010011001001100111100101011100111011011110100100', '928648793405348', 2);
    t('692a2496995', '419167655681', 12);
    t('374e3f2798d3b581c2335f3cc', '4554993763503222341647341469656', 18);
    t('5rsbkqfkfcoj29ajdi', '630903110773372341792602744', 34);
    t('33300232000244330423420200441024144200431020022134234241320011403', '2017080979900182548533705442612218309222032103', 5);
    t('d8e68i33ekfb03hli', '40331655796578387904428', 22);
    t('9ckk1o6p70dhgk60a3kjkekfjn05mef3g8oh7h', '214478514683523014526073551129543814424042054284209707', 26);
    t('du9ofj3b04aecjm6i8uk222wnj67mumte', '54453279705597662566198782922581780169626751344881', 33);
    t('a985nf1qf87n8f938gfp3gr4k81g9gjca1o', '165026316421448486404656724055483635522214133933780', 28);
    t('44554275695', '114358237746', 11);
    t('6c70a1aa65089aab372c819690a90c6898', '40090597115431771839762779123955361890', 13);
    t('86044b053d0daaa6b', '18360481564891608503', 14);
    t('b9g0kjlh7ic1gd503k4he', '8071692227413319882891853540', 22);
    t('6b6lgm8glf152jl0ki91aldk2lo5n9c', '475619065001030234952948540234894886223466110', 29);
    t('87a7a8', '1405170', 11);
    t('1a7a31c5863d7402', '272823800502213130', 14);
    t('jcjj6h518h1472jaj', '12877770189538637943819', 20);
    t('1cfxr1lh5ox', '4919839455772689', 36);
    t('310288811367762633415531745156071681653', '5684663159794685190217985404311834111', 9);
    t('14037', '9511', 9);
    t('21304440200313123441220313012000130041114333011322430023430432130', '1261979446859029545623380849346186459988139665', 5);
    t('fbd45cc9e2', '1081599642082', 16);
    t('519c09d40a70404490053c29b986', '45172525747251864110145361563666', 14);
    t('19', '45', 36);
    t('j58dfca6dnhf0ncbn49gkgbm69a2nlb0j9ch0', '936333578326698695534344960444912288238423306547864', 24);
    t('1120000152232022252110140241032312245311023234334032342030250', '59734827155605610430522117739886928577205767446', 6);
    t('18kakpghglhn6hnp7', '58343831352748592126197', 26);
    t('3204102231020302334334000041132202', '399742489157707275724052', 5);
    t('76r7khersf2irrlc07pm', '44183444942343119517736482557', 29);
    t('10110011010100010000101111100010111', '24067464983', 2);
    t('9049021262545393024579091866492398542902', '9049021262545393024579091866492398542902', 10);
    t('3', '3', 26);
    t('3veoda0voe2luvu4k', '12515452726305126989433740', 34);
    t('1s8uc49044sv7fuccu7', '18407131120081731496593356287', 36);
    t('5dbb78e8bkl9', '8462954128212225', 24);
    t('31k43g71i6l49knimql', '342583482343807445741585613', 28);
    t('kik9bjahj6ego855e4p747mcnj46ej11h49763', '468224983002703595759182810826586464545958811319348899', 26);
    t('13442134313121140343404', '4281453440168604', 5);
    t('7j3l8g4pm64k892n3dpbfpl1', '2709736655099210675851690721591311', 26);
    t('24cg6b802a04fcdg5ae11fe7fg6ffdbg4cf0c7', '7666093592391929958225523158661060374109385283', 17);
    t('29752369384011377360244601230116502477113293803222359', '29752369384011377360244601230116502477113293803222359', 10);
    t('5c7ch4dcfjl3m5ca7c4dd180ac5', '4235317763416835730488450279827445669', 24);
    t('2035677377165', '141448576629', 8);
    t('1014', '6882', 19);
    t('50amqhdu1dahb479ah6hefe0p18abc1', '2759244699893958338366015509269119092121474036', 31);
    t('31solno38be6ms7z0l32lezy', '1902149044738223750663383610950532398', 36);
    t('51vaai09fb1a015ap7ic8e2dkdid0d13', '599793397183230055183156703483234422199767481181', 33);
    t('ef9g06g61ga899g028ahi376hfb5ad', '179724417572923541328982412809644535193', 19);
    t('30461305635630120110', '35333469582885698', 7);
    t('304320404024431014001134123224020123023411323323310331123', '4423498436624887900904435210623464152038', 5);
    t('5tchpra8cb7gljnqmln', '12687862955738067803782907150', 33);
    t('1a9c03j1ifa7bccc9gj407lj3ma0d46akbp', '21869065306730387940320360093107271014796230532621', 28);
    t('90ag62b53a29861ge4h90', '115163310974925364653762918', 18);
    t('621e835f12ad64e909cf7', '7413676543182627283180791', 16);
    t('2', '2', 7);
    t('7630b7863d3f7j2dgd5bhc200d0f68gb5i', '313413466559810937691188229453692824598698991', 21);
    t('73g65db', '460210271', 20);
    t('89a53768777804667091962684a82141855084708827488a283', '104534620147629781560246588908903729115824398664090794', 11);
    t('4nehl018cm4eha03ch2nhc7qr0o4sk', '12351795250155371862634726792610964318320229', 29);
    t('36472233456', '12991747029', 9);
    t('32d0113076633053bg7b3709g318g996c6f7', '36792759299975206676907084433244583181437716', 17);
    t('13mkp5t2fulgpft1', '66633458682354245995171', 33);
    t('ait1ia1bl303ms1spcn2nr2iiboj9ent', '65672776682779904820651918660598404908077846319', 30);
    t('3abhdcj86', '90360583766', 20);
    t('6225d58f7849kc20437131', '35642008659327399615108918817', 21);
    t('53pl04gjp4hag07ahf6gqqml', '22162199821100339000975528379110427', 29);
    t('g06', '5190', 18);
    t('20p98o15if0p78l6720837', '1055700859046956086847060755701', 26);
    t('53i8', '48014', 21);
    t('epk6lkjbak073be', '1636219455447096840209', 27);
    t('222bbibi7c8gfg30664781e67i953j', '113089149702236219736580991019929354079', 20);
    t('216qomeeo9db41m6k03bbb1j9e', '1244900192918777003082880510514807396', 27);
    t('11b93e', '849209', 15);
    t('7mifim9aek5b', '12095932884795779', 24);
    t('b4b46h7bae18d8bg7deb', '7972552227341225059016915', 18);
    t('207551b6c0195', '115523483441287', 14);
    t('3p', '103', 26);
    t('197f9idk9iig0l3bke9d1k62cgc8j5a79h', '284292035870134579813298295972717503315861875', 22);
    t('155963d4d8h4f8i1hbgcb', '132504736945942923398014651', 20);
    t('304801222557410412641765610074071503', '7660601613972756521838449165642178', 9);
    t('a5f39b2250eff541ech35162ea4', '4476738604960162450815500774841664', 18);
    t('54a88663121c64617d71b4a122209cd2c0390', '11605880739459970698798281924031905080986435', 15);
    t('4ab695565b5', '666873944885', 13);
    t('5ca1md', '78319993', 27);
    t('3qslq250dvz741jhl8', '1072784063532716370614632652', 36);
    t('185230488c4261398a2544cb00c34742bcb23288', '45731671516320241574807720089017159625203497', 13);
    t('24141422340244200340140401', '856829699562036976', 5);
    t('17de6483675cb29063c', '7044803064789933295164', 16);
    t('429850987a9175209439859143545288466071015673385618', '4548955205287866147144947183033535389148611528651380', 11);
    t('83gc50deckf7g2i95i3fk2f8jjjb7hlc5dg36', '17356768087450686226472673111107289905971168186576', 22);
    t('7344c055395b32a41819c', '137912936874177212298706', 13);
    t('1011010001011000101010000000000110111101010000111101010101000011001110001001011101011100001101101110011011110101101010011000100110101111', '61368670450547755504412274420309228620207', 2);
    t('1000011111100010111001111100000100000000111001111111100100011100110101001010011010100111110100101001000100101000100010100000001100111001001101001110011111100000000111001010010111', '203364476148734435560803274724374642023080004086166167', 2);
    t('ah3g35d548ea4bfh9d1fc292h94e193feg2e75dfb', '1780619835592323113116024582457203219155826657157669', 18);
    t('855mqlyozhw069jiod', '2333132714739048924227135053', 36);
    t('102022201201110020112212212022121021200011000220200', '903223172393847799242732', 3);
    t('9bhy9w1e41l55fw61', '74170005765265656927173017', 36);
    t('h592d8637d2dd0k5163gj', '4801712957170939177303758961', 21);
    t('5', '5', 22);
    t('2', '2', 29);
    t('12000150142656341264053255555626', '202870200111145673769893502', 7);
    t('257e51f', '107482369', 19);
    t('2ecc612', '49071634', 16);
    t('15355035253621352061261230366305602135543424420434543365', '54172534486662629705202470905166502672672269648', 7);
    t('249h996cke9b0be5nc3l70fnc93h20ibg', '320569955418628440453489001255451094189328792', 24);
    t('f3adom1ngq3u4irb01s2j4', '314624319053987691295478037262950', 31);
    t('27a12175892a7a0160424168a35996613950b421869823b5', '1397433081866498613503527062681137551712252447761337', 12);
    t('340632544630522633415662322031104260443650626022261224', '2214784384390370140259383269354114041805894388', 7);
    t('6q6nce5eecdqkdkmjnje4mpchc', '4241070534916309906119738425533045869', 27);
    t('113235054406626436112', '96665647902597209', 7);
    t('12101301021001012300301111100123103322132000323213300011001223332331322131313', '8959721927373131398259946028619287042425595767', 4);
    t('16kr4', '762808', 28);
    t('2854737432023865746217633237845436746', '66621795309306392625749774020755759', 9);
    t('19cb300183bb', '3169302143434', 13);
    t('1012555568138a1b741846165585aa7b35a3b49475a', '2134175130500831128858578786794170081433983030', 12);
    t('271106223317652510470133141417013436324344447232', '8063865882119118770028661617297344888458906', 8);
    t('1j1', '1317', 28);
    t('14bb4a5d83f3d4bf43b66adada6b0e993784', '1805977369681030296729705669300424034301828', 16);
    t('1c83c397a04ac034190703b42b8a86c20119ac58', '54795371938228469135901266442543827602116802', 13);
    t('49i16f5i7j2d76egccdde1c66ji93i82276731bd', '2471244346578176698373748682028711809826870228344633', 20);
    t('131132', '5167', 5);
    t('3e72bc538', '139294601405', 21);
    t('111342330121004', '7759223254', 5);
    t('g35', '4680', 17);
    t('jj0h5371ddah0iahf6bh1', '5538389688853463873501657539', 21);
    t('22pirudfu9e7mgq5ki34m731h9fngq6', '1151434291285406691472999364496269523410514631', 31);
    t('79jcqqap3nbjkdb74jdc80qi1rl', '310580897107477820585107874712335706009', 28);
    t('1p', '59', 34);
    t('l84m984fde6354hgf936ug56kb8ntuo4q6', '348786713144351173808729528284372110071543438511290', 31);
    t('5e0jot7ec7fa', '521409833288888610', 35);
    t('20120222120202001200221101201011011000002122021022201010120111010122121222221222021100212021210202', '41942954018106129338036588729324918948010233105', 3);
    t('93809gd4ghg1e170a', '1116205695833217173038', 18);
    t('446230341604256064105154511213003600435153634235', '24648873732798551638045236958735680691288', 7);
    t('1e1f', '15471', 21);
    t('12520004233203303235', '902764818264263', 6);
    t('13434033002003004402141124302242203344214233214324410224001421242', '970702797270984391835801113220919489871123322', 5);
    t('5522220135303151503503131051350101251', '60854636647067381415610435615', 6);
    t('r3178ou9caakpsh7bhbe', '587232889506503339619803819571', 31);
    t('11344b48925c928590a9b65965790a531ab71ac0181456', '147070368225022849438278483344224755447603064318709', 13);
    t('11132233130311012310113133213321303', '404377318206700682867', 4);
    t('21243103211203011430314411440423000341224401022424403242114230442442334232', '2453393003559216570036598154088578511990647212855567', 5);
    t('77138783429395', '77138783429395', 10);
    t('e0hi', '378528', 30);
    t('1sfro', '2720469', 35);
    t('10a803a13b3aacb313d20ad45d79895db83072', '2688774325186814939420907831934492554488940', 14);
    t('28c33418ca402312012c065c', '604690168281921446532949930', 14);
    t('184', '349', 15);
    t('2571c597721b', '20456544556601', 15);
    t('kk6sqj7rr4hme2lhds', '150208264567193002800858826', 29);
    t('566bdhgd6gf6f3i325i3eid7i6adf4h1h7382h', '1098869380632307597689024002479488625096341992121', 19);
    t('48cvcjovvcps6w5ih0vvgg1ebtfsrm', '463163236652429988640359361211359679555574220', 33);
    t('958baz1ki4nyqglpbas5lh1qksb7zikeivp', '750728967818084621222424385256922764057494617052439317', 36);
    t('86151740892663982775089', '86151740892663982775089', 10);
    t('213b', '4613', 13);
    t('r7k5rw7lm1vngtxhj', '86816834093372879138789857', 34);
    t('217025023377545890216047915201', '217025023377545890216047915201', 10);
    t('28216429043406a128001999103968938669743', '10267451898484492247566507299193901416802', 11);
    t('ikn5rh010c', '198281469065244', 28);
    t('cdn3t8', '302754578', 30);
    t('4a2681940051031157a53278652494885604968a144380017571', '636699130425199233901707564276961890453203238857370317', 11);
    t('214001300333', '115259468', 5);
    t('1bdec674867daeb454bedc3125b72e1582686e0c', '13235662457450871047945698439432593046607531537', 15);
    t('1461101624363430103541030526563133043332334410035661345255', '2513783613053608388287524826007109061198917911061', 7);
    t('1fdc0qd1nfs2j', '3466820238745915791', 34);
    t('1ec2fd96j50ll', '21357449083341579', 22);
    t('1021722', '271314', 8);
    t('cj9ea1c3dd12880g3hei6c13fc1gk5e1gj192d', '108044509832522390985019647621567967006917730046839', 21);
    t('22022a15a1242a4050a4a5802758aa2', '514622640579936481914636293866778', 12);
    t('1d8d052c67dd79a1a2754', '165172435194406497470358', 14);
    t('5f', '185', 34);
    t('68771d2b5d82g', '3784863040815843', 17);
    t('35116201514255324122021325201040', '590116123779691041518146077', 7);
    t('7036036165443146', '248356246275686', 8);
    t('b5ik3rusjxloun0e7nwk22bd0afic50jnwn', '351480021513874030859064287892370214007546506744437693', 35);
    t('4457450hil348', '53898766295660932', 22);
    t('hd1oj4rtqlkdf98x4vmxj0h3xx', '6943386874692972087645952788769858758738', 35);
    t('3mao2pk4o2', '29204186262374', 27);
    t('2n4cnm9w7j2g7s6kw5h5u1tz36knpqdbj', '167360655322446028749706425278701718029623161912047', 36);
    t('264026a0ac626cd3b644714478899c', '4233598300815455570056021723238862', 14);
    t('1132004131214141022204432310342112034223000012120', '4747410412074476042164830201172785', 5);
    t('14c69b7', '6669566', 13);
    t('6i8jh5495mljld5imn', '1967338742655672740382887', 24);
    t('11011010100100111010010', '7162322', 2);
    t('2sacrn05cl5dn81476l6pg3g0jkldgltrtn', '491130187805084132256352213258420044325768153618193', 30);
    t('7629eg25216062g0bhccc54f310g475gf2d851h02', '1193072249536776238087255066419340494300241692433118', 18);
    t('5110242554012351311222', '113996815429002782', 6);
    t('3pih350290ji1ba39npfee1b67nadop', '11222243968353715216614952364432075435971389', 26);
    t('g351f93h270h7b7hki', '4691673247887821898764850', 24);
    t('6470565', '1732981', 8);
    t('5335763184182038172006046108484131152678603', '64393019391265736471397626369582559266481', 9);
    t('10000100100110110001000101100111011100111010011011001101110010111100101111001001100001', '40077624010777577544413793', 2);
    t('d37d676ed324d97e91', '28833401401805729291779', 18);
    t('2111db1644e3db18d1ef1e0d61gdgaee5c6', '1411526454880979898913723256921011458189878', 17);
    t('35bacc513809d', '193736987400347', 14);
    t('14l0ii8ci49k14i991el2j18997ai', '47432159257624618593218965255177560530', 22);
    t('4kfshu6linig20uv100p44ds0emo3npg0a0u', '222236758510407484956912068045177884120458517136025630', 32);
    t('3h66nirrqm0i7uf35145j8', '74031708866092624643936753260340', 31);
    t('1kcnj2glh16sc9cl5b5db31o61oirjc', '126951344107855183929498621767034725464772792', 29);
    t('1', '1', 27);
    t('40h0kg91a5ldc', '88364370457256098', 23);
    t('2kgb8kg39ajji17bhagd9mc1f578mbk7o', '5312546317931594372611431312678286944856393334', 26);
    t('106454014536a137614909484877aa42a8318', '32549768237359567248289108586482266373', 11);
    t('102020022121120220010200010122201201000102120101212112102021202121021101', '9373515480802386787336379528216869', 3);
    t('113jamevd0ea', '52240096897795498', 33);
    t('4dbb076838d50e5b00b29235081314e9ec', '3183265672012968496848943540783648620747', 15);
    t('2236k2ihi51', '35074324315654', 21);
    t('2044', '460', 6);
    t('8i787d5ge3dopd9p48f1', '13622774573376163046429858386', 27);
    t('111', '7', 2);
    t('1012645216266112554320010312', '67619419391382234277050', 7);
    t('3103801', '1656208', 9);
    t('25a3g8b0ggja0bc0g', '1491257047471328092816', 20);
    t('100100011011111000010110101011000000011101100010001110110111', '656366019324289975', 2);
    t('2hy6l5cg1dt4ggq62', '19885494590425537842223226', 36);
    t('gm0nqp0hpr4200fnkk9n', '102288227674562835100668366757', 29);
    t('t9q0hhsxm67aglisrrvnl', '124812001386691713133980119986343', 34);
    t('1757193', '1757193', 10);
    t('8b63e2dca39c336b18', '2571294983995377543960', 16);
    t('pjai3cvvbrto2t7s7vv5', '1014281637785517689396544143333', 32);
    t('2l', '91', 35);
    t('27a', '565', 15);
    t('164qesjrk8v565v75ffd6wnf909to5h767k', '13879928000835241925467631555592155788584903540287490', 34);
    t('9b8d19742d4', '2843752747826', 14);
    t('b30f159f05chc4h', '4186384634788528049', 18);
    t('2dbq', '102086', 35);
    t('12f67hg2a8i64jbfhlhfk5', '17420544768736569554233288737', 22);
    t('1100', '12', 2);
    t('hari895bivb6v7ur8uhti8b5mnaq0j55to', '2237261580805951883828359760940720036427289454035019', 33);
    t('1731mf3', '604246471', 28);
    t('377e2roj', '137186257447', 33);
    t('161d6be75eb7926a271576e8e6a07e67513bea4c6', '155734848943868815828395124475901609082268815461', 15);
    t('200212032120020222230330311120311003232310222230102113323103000322230302220301231111032', '12196082923051903043941661056550160063059733091112270', 4);
    t('31bl50i5hfnj2g92205knjn8m26aoni1i4n969', '16193982856683928575461552404913450912093921320287034', 25);
    t('66h', '3053', 22);
    t('3uqesuhcjwdakwf4g', '7780167401827423762290433', 33);
    t('2eop91d5nt5193i92xfin7oiam1f9w3uvc4', '28605886795171609313172129799075303081247927522208376', 34);
    t('129828a42a1a983', '479396571777467', 11);
    t('qo5fjm47e83j', '149519533662546148', 27);
    t('120930d30a1c6cca9c9c85d68a9d', '10109362297846202081439662847219', 14);
    t('433434112303022113322421334420042341432322243420342410412010213', '103176224496584812657695985895438714073938183', 5);
    t('2aa745d38106c55880246', '231591415358075620700166', 14);
    t('10a23548709447811b5468951600', '147092018792966563018352675616', 12);
    t('1muuqpq6h', '2989050560877', 34);
    t('105h58mn7cho3e6ao1e8n8lnj3cj9k3539f', '341896959260587485518394721610662378353223908365', 25);
    t('121a5813986070394bb7144864aa7329b9301ba', '120406122800356790683822388154769546350622', 12);
    t('11100010020210011200001011221110201100212001011121020120012011211000002002101100102120012222', '37860101293024691849726322460894592104690511', 3);
    t('2uaofdemihchuxnsi22cl3i60goox', '22006538653225073786749125118104638524377073', 34);
    t('d329q', '8058230', 28);
    t('26686dhpl7e1p9lb1qrlpn3fbmj8e4f96q', '1267711441005450956992875908126805624422712405650', 28);
    t('2pjkq', '3291644', 33);
    t('5ne50bnhcg8jh63h4b8gak89', '332489330535230011694478313343433', 24);
    t('42d', '4173', 32);
    t('7ncf8namfjbg1kk97p70j8j524ioddmg5fo6m', '6868243522317166196967869805047542008508489290755130', 26);
    t('3c1440de515e09b31f73cdd0da6e2', '19496787444412678571409607909811938', 16);
    t('4ml9dlae0ci8kbladibmmd62mi7bk79mack8', '2286569324205503763236162887597617701852950700129', 23);
    t('i5g1c1039jc3bfbj3jg6250g15g51h8e398g', '62844649752973800818784289497153800322395867776', 20);
    t('7427745', '3975116', 9);
    t('54153260107451562218510277555707018420', '54153260107451562218510277555707018420', 10);
    t('5aee981853bc993326395be', '428950049262896681474864804', 15);
    t('add56j4b9hcai87c357j8ga5i', '576203698240315171997261396983665', 21);
    t('25ea2g068b67dh1f1h9bch38f0g8h', '326308845239382288473188087950535697', 18);
    t('1a12f68igh7e1ha195db27g5i9247g7a59', '2417780901753180332851584091382890457838743', 19);
    t('dqgoc94ej889u5pcvhcnvmhlt5ohscn', '19737221570425505289342027022964526059214139799', 32);
    t('2246d7744eb3e897', '942853654698726067', 15);
    t('2', '2', 28);
    t('2dclih6geh7hib9f1i8mjib5lf8i0ibicmh01ij', '14418043617625234175059607245813179917796405933128627', 23);
    t('4w5q', '210901', 35);
    t('112112113201334001133324303214103244132203441240131112102002404130442240443', '6830926531027276927950105054067971781356898029258873', 5);
    t('156d6c3431108a479a72d969727', '877359658879832942505464566647', 14);
    t('206143367232576283626041763949358536', '206143367232576283626041763949358536', 10);
    t('3ntm', '145508', 34);
    t('61216176216205012773031', '454507717401133184537', 8);
    t('de94dkh6425m06qhqe2attru6bceaq', '599730557272586153217330707522770691809491290', 32);
    t('8k77renk7g72pf3j5o45qorep14aj6b', '226691682861596196794798492778633822748918883', 28);
    t('2jhf51dde7d0i38cfc9bh0c64c060i3', '3215219793828568936375294331195174448363', 20);
    t('22h8460gcde', '13203582611224', 19);
    t('91464b7740a664b76346b166b0b6', '1252108265251775177482532735178', 12);
    t('lak3bifhtb6', '12610316079035436', 30);
    t('1470998178', '7132969964', 12);
    t('16hi0mjk1lpe1j0hd37c', '963405816410883410946327686', 26);
    t('913b33b1474ba887bb9810409b9', '104295075607044617523054107037', 12);
    t('161100013125365301651212042603023364211204566300621264341445', '136474139311752213668130631029378317696922594692639', 7);
    t('7tc1le9kf', '6778801564928', 31);
    t('8i837bdb2cc5951', '7167109876485719255', 19);
    t('168a3egd44528f5861bfa0d474', '7979073806747005263453716304209', 17);
    t('23bd94833', '3357993565', 14);
    t('jfhcvjdllusom', '32474670588429458224', 33);
    t('t5qb0g', '709461916', 30);
    t('d39570c80caa28598ea432085259', '4291428326751199011126676862554713', 16);
    t('807a81976166987b1', '17509808255778732167', 14);
    t('48631823380828816', '9204637946118855', 9);
    t('1223466603257252468314540667812301184', '28199983454052965359351624334678314', 9);
    t('380h5kb7e3hurkfa4', '2370411015159854211757261', 31);
    t('1440141506864757812308430315687726770760773493695949582', '1440141506864757812308430315687726770760773493695949582', 10);
    t('1rls0b2jrpx9', '127252119185280215', 34);
    t('7856f7b676ee2', '4363430111213756', 17);
    t('2sq3johrljsw10qzoq8zdjf7u8', '2261502733792759669833591306474349874288', 36);
    t('3002513066606060620347136440362562046653642', '255651532540391785253392875614499461026', 8);
    t('3k9bk96jfj', '7002080842657', 23);
    t('2ra', '3405', 35);
    t('8oe8d7', '127827592', 27);
    t('155504503336160624601362', '50117236696639403363', 7);
    t('1201221010100002', '24940793', 3);
    t('4313403103333003042400241154454214031542', '10125479020346114991096697847126', 6);
    t('1ec3298g37f1a5di954cd42527cdh10246', '2798816910510266638276958183897932081056861', 19);
    t('1en6ggipmk2fpmgndjp39q6md2dg', '1810736445109522104704252771239936966748', 28);
    t('8', '8', 23);
    t('37634546500bb245b039a5b1735089983763', '214232450284525132996750864907535178875', 12);
    t('100001010110000111111010000011000100111100000100011111011011010010110110010010100101001100001101', '41279952929416973510169481997', 2);
    t('122423221304033404101141043320442014321432131110421342', '16834509131210666326342619688068842097', 5);
    t('1020131', '4637', 4);
    t('klx3aeefvxnyodkn34o2d', '275488914248612801544646762918357', 36);
    t('112211002222011102200100100', '4185291549411', 3);
    t('4to0ahwqd18wpl114oxxmbkoq7', '1937666241171363939533759101938045719692', 35);
    t('1135', '418', 7);
    t('249', '249', 10);
    t('121312302423213040021142110333333331102401', '66685945228939713462829550351', 5);
    t('1625356215252', '26494122069', 7);
    t('anwdkfr2m3dg48rdwbw0modm', '904249144970472511877809144186597204', 33);
    t('113ki80ilh', '1271990411687', 22);
    t('1530304232122121415550005004031544233425532424030304403', '2010294933256617576397318672085330157825939', 6);
    t('104072459a38346d3ee7dad37496a609076921c', '500243084593242089330407721774970862086353352', 15);
    t('18gbeee10bd80613e1b25ba0989dda3af21429', '5138521665544916194033529092059378256571453963', 17);
    t('10101010101111010010000111011111110100001010110000111101100', '384469593819013612', 2);
    t('b8a63049983a0654ba6778a469072297596926489102', '298161575681388874506973967749374933332233147730', 12);
    t('1d54a95161a44ae4d216da350d20954f13992a85', '167448744619550277927636746527062265701749828229', 16);
    t('1b8i6bff3538', '322005234426068', 20);
    t('7gf7d819f8cc8f51bd98b226a8d4067ccc0', '5470961222003556575284943473483752741364570', 17);
    t('2003040245545114430003204351', '2061732724911322435435', 6);
    t('206740', '123075', 9);
    t('b71g35500e8185fcfcf9gb3ded4339c567320dd', '652632768758471633033004484042049552510007932968', 17);
    t('8d4dae81737a49469edbf0ag44119c95fef5c2fd715', '41919359081724970340005698065286668228554601347266486', 17);
    t('5264349b37283231740', '138729190626813625824', 12);
    t('456', '302', 8);
    t('a1dafd83a744eaf49gfbf592bg05ffcg9b166', '1998673178276656072855040019793637333390949546', 17);
    t('17004753588212207815125616470722317780142872376105688', '74245187234283454851664056978383868771198848737133', 9);
    t('2211211011212001222020111010111010120012011220212111112010010110110122010102120001201001', '919746263988110720330734195365089255014915', 3);
    t('2ai04fj3i27690f5c81j35b7c2hcgcf4d5bf', '8744656450668874412129805378468279112496746235', 20);
    t('101100000001000100101100001000111011100010100111001101110011001101100111001001001011010010110010111010011111110100110100110101100001001101110100011100000100011', '502582666714640400473511879468920658557790730275', 2);
    t('458b14g5ff2ki11ak43o64bl0mie6d', '146185391432846819540888318943706307712038', 25);
    t('8453nb9ien1n12689c3a7i42aieg2g', '86825542084489172944843999109269881698368', 24);
    t('101221012', '72262', 4);
    t('17065041017173527170644622577111123272557633404173157515', '88295987850015910722625103099562923405439709011789', 8);
    t('1010134331130134001334443233314112431111111043141002214131242344311202', '1766678229765066235739620315143368730448384369552', 5);
    t('l8g1mja9aeehcme5m46109', '843832827267550590415898815954', 23);
    t('16d687ff52f', '13653016922055', 20);
    t('2jad9ic7hh8gj96ci73eh9g0bjbd2jb6524', '511390944414014194229800955887738666430610044', 20);
    t('6614048801073688628406604411830070546726', '109782278237026239880293845889313820712', 9);
    t('1jcej88b218fbd7412', '58088627120868089575496', 21);
    t('17nkctjba7jdw43auam4', '450272045225207253826494727996', 36);
    t('2000325253334254251300', '43932904281041364', 6);
    t('acaqvr4', '13397132632', 33);
    t('32200130031020032023121203230330001013022030331131222333123012201210033201313132212000010', '347370908365053402115400890112019448640793233522843652', 4);
    t('2t7e5vi3n0b2q59gwn0mf1h25j5jgx17', '855292840092541663219061040782700655334518789309', 34);
    t('223c6bgi7i80b024g8b3f7152d53a7jh882cd', '144932207807299978358573285607434907402231745053', 20);
    t('21bk2h3iq62gon0deskjk6rb', '8842310846155518916223348697373797', 29);
    t('43812c330990036289588b377110b0001c3a', '4162225291349057804333124544154752098422', 13);
    t('kd', '673', 33);
    t('153111155020052013155231500442433215421053021', '33301389716284423546912957799031589', 6);
    t('1fk00c2842k0', '1610232270940190', 23);
    t('15cd3', '734191', 28);
    t('1210002122002102222011201021112122110012122122012121012110021110001020210220022010111020', '575848262380687269510769585003227729853005', 3);
    t('23aa3133417', '61292676947', 11);
    t('q3kt6q79an40st27dc3w5r', '3782702939054610713945575733531133', 34);
    t('89gpanae', '112571410966', 28);
    t('3odl2odo173g9oioe961n5m18a1fpgegif76d0', '89103898368780329843843213967906565582206158676623346', 26);
    t('57l5tc9s9vp02t2l19j3j77fw2iw5hq0', '620246157108817541536543733311579693819651519455', 33);
    t('1fl41tuf27cii', '4885706799284972973', 35);
    t('3h62g4eh760f73c8h', '481320829720357766009', 18);
    t('1000101011', '555', 2);
    t('q57bwbthwkspaj2ucs6jlwcvq07k4', '86297743847844103494926974103414975911710346', 33);
    t('21ce07f1b511gg0f0f57599c95713b', '1013676859489927884538566004602431047', 17);
    t('3oskac9r2i9tf65', '2879424166264572649417', 31);
    t('121101240224333112303121202113413123400342034344023', '128652690811737711862977258490543638', 5);
    t('1422424401304142', '58085572422', 5);
    t('6085281a33b1389aa68', '161299549199109190256', 12);
    t('c', '12', 27);
    t('54523528783185940853887445327908196165978268324', '54523528783185940853887445327908196165978268324', 10);
    t('111110100201102211220100110220011100210121101110202212020100011201021202110', '303182193417511432321441108708547007', 3);
    t('1536gd20h0fhhg5d55436c0ha63e29c60ahg', '726145947704576858453585758674557404546198173', 19);
    t('22022010221000100202211222102202021002220222001201001111111011202212011122101022220212', '99392017799768645924361603871458701456597', 3);
    t('53adce4b028fgcd7hf548e', '1193207787087913909236098534', 18);
    t('a4', '144', 14);
    t('ho2er', '14420247', 30);
    t('e3ffcc64277a78a8256d7e1d7c05eaa9bf', '77584111689906087598180624752236124875199', 16);
    t('1g7n7lo5io37ce9mp2b', '328524151751122058961202483', 29);
    t('2030102214012423403324030304243103001403324042420010414232', '14722655319890169268088222422460420013692', 5);
    t('613563354021145663036162612061303', '6871051676078235862437063776', 7);
    t('gjhlfm5lknn95bkn84b1con012o8jd6g7', '31867442134261188923108513411199647167070822199', 26);
    t('llhf1m42ch6mg6kc6e45ppc9', '18191151044159190019737039426392154', 27);
    t('5e8dipbabapt0nodg85kmnoms0o2', '41758231678994811795607253224155508776722', 30);
    t('621anm95ho73m0', '15082986714813289376', 26);
    t('1e702hldk8l734b5f12e8dle', '33866826604275005079924066683978', 23);
    t('22f4736', '36652854', 16);
    t('15448784483296', '15448784483296', 10);
    t('1jnoq4673ll4', '20540068473952319', 29);
    t('4421014224404214202301000', '291383814569181375', 5);
    t('1332402323133230', '53179114815', 5);
    t('22455201354420531414254341553042333144110314033330011503431000114', '156559057575824331523615397895706894115565285344494', 6);
    t('b07b1426d', '16292352313', 14);
    t('16caa4d1d594aab6b98ab0b1b14264a9', '506098807791173960954389695213967701', 14);
    t('220220321220320011330201211001230333102010121303332222311323021110121213033021', '58002021669943215882437485089516366950604108745', 4);
    t('460175', '460175', 10);
    t('rm92t4nmi39j', '704301162993180277', 31);
    t('2c35e4d05c0', '3038123984320', 16);
    t('3ahdutj9mbmtr086foui53gu0hx', '21785718654104569515056333343275862936563', 34);
    t('14087634143410782327333780148640301877', '295332466513866374270920611186627388', 9);
    t('43b171h0e87eg945ic7563b5cg64fd', '50806559075581748348880564861624437804', 19);
    t('16ckpwbk9b3i275h5d8338a058ck1alg', '141489416893679296818740151228347362930888733302', 33);
    t('k78iostc2pua', '1950965634957774935', 35);
    t('4aa54j21df8hkcgkgp20mh9d931b', '5173226992447654665422544156091087390231', 28);
    t('4eb942t', '8105266499', 35);
    t('101011100101101001010111111110010111011010010100010100110101000001001101111111111111010111000110111010001010101100101101111001110111001101000010101110001010111011010', '31852131995136650015824448712052459356282756208090', 2);
    t('171860g48cahf92064', '7521304142338550340336', 19);
    t('1024', '361', 7);
    t('e', '14', 32);
    t('f', '15', 31);
    t('cji2g2ynilowjpau9sxl2525vz9v7iy', '612959941037504203320865072390685049444312906970', 36);
    t('6j92bc252e1pa6n5foeo4dphrr7', '282842955335866464220455210371442191467', 28);
    t('754721358689534984612281', '754721358689534984612281', 10);
    t('106nh39bc8a1dbd9efibf', '4068759645359915205371605911', 24);
    t('8dfg4ha5g8e79i4k7e0', '5460155756354332817482965', 21);
    t('4312506613443045610152261106065301405562361602421616', '56109700415530612765613834518456450896421741', 7);
    t('42230004031210204341024234214114343400044000', '5120515292918450620552927346750', 5);
    t('11010011110000101001111110011100100101011000110001000000110001110011011010110001010101010110100001010110111011010001100100001110001101111011', '1152932454441681553686105050801467624055675', 2);
    t('gc35a15gh0e6hbfa344ci6h60d1756d3i', '7133162389260283421788216763773968727253278', 20);
    t('ped56s09o4os2e', '261629936007586831748', 29);
    t('b00', '5819', 23);
    t('204a8kjg27l7kgelna', '1168264197453743365857460', 25);
    t('1284b58363a24248816a', '391391876041895186146', 12);
    t('1a6glmf9i6ld6', '31721821241462604', 23);
    t('1100000001001001000111010001111010010111001011100111101110000101111110001011111', '454021537654527488097375', 2);
    t('ktuv02o8h0dh8memwvf', '129541724909808086439236801675', 35);
    t('3400040104213424322133232220302111041324', '6914515487235712203520018339', 5);
    t('6e5jf09', '429758009', 20);
    t('dppb2e9nnjn96jfbd293bc7d', '4903303064412360643152733423833467', 26);
    t('2bdhki1c4cdjg8d92hh48e5930945b95b3g9', '48428996090391084590565126593313973435696979409', 21);
    t('5nsrllolb0ncn3', '59794172529212348462', 29);
    t('4j47', '58818', 23);
    t('1101001101000111001011011000010111000111110010011011101101011101011101010011001100100111000010011100111001101111100010011001011111111100001110010001001', '2355828849861155012884780223410671381544574089', 2);
    t('5h18fkuqeobprbtgdphncwcnb9nqi14p74e', '23502944357360874074985050551823304242402482605470882', 33);
    t('430e68bd9ad4952', '301994663360678226', 16);
    t('83mybdyfk', '18250265709570', 35);
    t('345632h7po7bfnl419273c3h', '1107369755793636209889847907168631', 26);
    t('155hmdm10qao8rfp5f29fnn06691nm24rfclp5', '415761194832301392698634884108004928012396592720849681', 28);
    t('75376b8a021b20131b48b637182292202a', '3052560053832658763100020747136367522', 12);
    t('252bf74645b4k1eb2f1cidb6k8gac4jg', '218675971817632327166089471412035111563445', 21);
    t('1041630262513110000365330', '208292689407845958902', 7);
    t('8ipcnej3bm5e1lj03k3d76d9kkp273', '944588256140958917841550791402929957368041', 26);
    t('21122220112200101011011220112111022022210110201011001002112100120100211222120001220', '3398109006511352612217149313338598854505', 3);
    t('11221211111111102230023113113121303102202013003202300031132232223', '480626689266491150511095172309208918955', 4);
    t('3baaa8682ijg9hg6jiiegkk2e77', '84652263531904780964938488704665624', 21);
    t('7027910070685774862975771344292902196641813764924732', '7027910070685774862975771344292902196641813764924732', 10);
    t('14nmi4940e3cdr', '7628443576261703047', 28);
    t('29714113449495030180067704', '29714113449495030180067704', 10);
    t('16027026131232476667231251', '66325667775824613159593', 8);
    t('0', '0', 22);
    t('166452ac011c2116a421ac5bc3c023b6bc4990', '246444225807161486770221362501829463826523', 13);
    t('10312410044054404422165523342606411123616622336034061556043', '11043975746401930269143716067439560851383524557870', 7);
    t('1iea4l97c0i553k3b64e9k9jhb9bkj7k5566', '178448019454450986199237722696936967229476033686', 22);
    t('1478139520', '1478139520', 10);
    t('1d854cf1f48c4529d864b686f2d', '37421939842938093643010520149805', 16);
    t('1a7129b0cb220c0c496b03233', '983122173959444998093229449', 13);
    t('61637976999142621145200538', '665607201960195049612272036', 11);
    t('b437bb812dc0198d5a011a2aa866151bc83add0d20b', '15509757582610193893018549990835987906527184363915', 14);
    t('m23o33o2ml072aamjic75jgg68aa016544an4o', '116924132032633647730209472607114957774639320109155124', 25);
    t('62c4hnh0i1hgaa6ki4cccb3g0f9pr01t', '103732044580983310247443658362576131853311657763', 31);
    t('2mkv65', '105113750', 33);
    t('222678eca86eddc939b60848b7b8316828608e2', '1053714680554554231365359188076002075988224512', 15);
    t('2g7db1dd4f496b8503cccdc3089bd', '84151059017237335236726835977283846', 17);
    t('11356664335110632222416260423353223124562262661224650210151051611', '1490024421959891167700411423106906579208279293688323560', 7);
    t('8lfgf', '11533971', 34);
    t('8gf0h', '2051693', 22);
    t('21h9mlbfh1cfaml7ahfnn513925k46j26', '304178596755743063799400356490104291373592310', 24);
    t('222020120014433', '15156798118', 5);
    t('a737gcfagg0ee030af20537e209h57d13f', '2760612480391619308046997847062410963259009', 18);
    t('bf475f0e5ed9ggg433b1a7', '822034344011337163185436487', 17);
    t('11010122002222211221222010200112111201222220111011221010122022000121000111022210200012', '49501356081468652681886134573393140563711', 3);
    t('0', '0', 22);
    t('1j221dh95aj9ed83b5e4kaf22ej9', '956853653611900643236190963151594750', 21);
    t('48d1', '40846', 21);
    t('266359b8b969632b6ac86695403a8be8c3a2c2', '79536364099052136307674191123580292528001882', 15);
    t('7bc4edj25jg8fb3dhmb63in40f', '662536092600660719641563026403877515', 25);
    t('2123b9378a3e', '17962722130559', 15);
    t('1vb1rg21fp9tf', '6402729056965380805', 35);
    t('90507i0f54gk4b2g0gc108520j8m3m8k9', '338836712441591160747477280351050302149052875', 23);
    t('23h48496g', '447052385744', 26);
    t('3322002', '16002', 4);
    t('2ej6jk0i', '84396331026', 32);
    t('35gkbg9', '281020980', 21);
    t('477ba0g4qq4himbr2delgbibcpjnr', '141181564767286604205256660712659301710991', 28);
    t('16625630637244103026266171376764352575040', '2457838121719672737744590760418408992', 8);
    t('12772', '8651', 9);
    t('3334e2ff48e42igd0a18e49fee8i7g1cdf9d2f', '652404784229042811789503804111388997324151029358', 19);
    t('390312a922213a8a64714a01061249a60a7a57903894', '2301485456077975760943477454917012552590331798', 11);
    t('4kfc692l3', '534994898043', 24);
    t('f6ei0o93q62gtjc3o9eefdad31c6aa3p', '259600317350324790376664305311377927792105345844', 31);
    t('77jeli', '47252368', 23);
    t('1818a46', '3086518', 11);
    t('jlul2c5fu75ctck2', '462484928590385125215962', 31);
    t('2kdbs53vman', '2970189100472663', 32);
    t('18ba40257c006787249025dc132901035373', '21233179223979726392280273913614195304377', 14);
    t('12tq8', '890888', 30);
    t('mcgnpml3i3', '171328946260377', 27);
    t('5su0gr41uohmu73i9c', '133822801190393847297321403', 31);
    t('10042553121242502132252422', '29022304271575587422', 6);
    t('68e3f619263', '13143928745961', 17);
    t('cdteiu0u3iffuohsbsiqupa1uscjpcm7p', '18173795688393997715594261305551967041493744900345', 32);
    t('10ee5sidfeljo8clrcp6nk4d0j0mkam32k48j', '45055395262449121673024204762282471724687471901724826', 29);
    t('1561736223610', '118371198856', 8);
    t('4hion', '7535831', 36);
    t('3bdh6671139d1288bdb9d8e06b7bc9bg', '2993926724680335312809084195839710840298', 18);
    t('49b4a2104b545b2439baa986099927bbb251419703', '851737504589717022185417748267818774777893299', 12);
    t('3f2ac50eehakjh4a05cdjlh5b67m9fa', '259979250004821542868763765100327385014666', 23);
    t('32021113132120213020101103112220220223032312122', '17512340678477455793664617882', 4);
    t('34iihadc', '2916834773', 19);
    t('tgcaenh22', '41483651434205', 33);
    t('h8', '484', 28);
    t('1345013', '179399', 7);
    t('1hfi5', '302365', 20);
    t('1837046a2692d423b', '3461408270213809773', 14);
    t('2423b8895916', '19692665799546', 15);
    t('37l2grtlcaek6h1i3407', '37852085679981001127651964607', 30);
    t('5306200451262252', '25859506488363', 7);
    t('cijg0', '2071920', 20);
    t('3223131302032121211300021332322023033313232022211002002202101001320002202320221112211303', '88098060436515295647388763871409380266783398231894387', 4);
    t('7mgg6lii29f52l7f82d22kl25no6m4elbhf', '2678874370559434952680139408552413555034712835440', 25);
    t('blrmrcir7mk12fbckpetiwg', '29790101256737754545389640825091289', 33);
    t('73m028wm4wdf0', '33643976305588152300', 36);
    t('46h49d5e', '5559117314', 20);
    t('2h94b5961k6k33f4j62b3d2', '347276697125022380759656573571', 21);
    t('iir6o954dn6d', '472825548883025356', 31);
    t('15056662412721204036161014', '61822867030969079620108', 8);
    t('e8g6s2ier6', '501934442756966', 32);
    t('hmrire23hk12dot2906e1ttgf6hkj3npdb', '98751340425225592010077526066776177092708434773901', 30);
    t('18gflnnl7gcreqms0u3', '4606469246867644935544977535', 34);
    t('14232313010113323034040302131444113021324402231301144403120243324', '1034471412400084913926462730158583111529852964', 5);
    t('339188b1b51529b83204', '1058597104025846215012', 12);
    t('5b6igfike9', '4399870445952', 21);
    t('68476024a7', '15953876374', 11);
    t('1llad2', '18303452', 25);
    t('10111111022112002220002220200220', '720566895785271', 3);
    t('82082726527757034455488080404806838654330250467537202641', '250570007137020818998373455622683381347427919884630129', 9);
    t('lj1lc7m', '4165081534', 24);
    t('4dg8p9ia1160g5ppg9t', '1724578545171269121406439699', 30);
    t('kimpiadg8qpdf3amf65h61n52h52', '9178107846544020627692598732858329684582', 27);
    t('12443301242243', '19142651475', 6);
    t('506s2b6', '2979045190', 29);
    t('21211101111122222000011002210222210011101210020200102110210210111210222202002210', '128580978328817621464532250583984291620', 3);
    t('349e7g5d20b4e0a765721dacbbd737cgfgfee', '646586583890294574021104159470580456873235673', 17);
    t('79c', '2710', 19);
    t('1231300233324230142304044004233200', '178445501100086472727300', 5);
    t('5db3324efd09a682cd', '1728459668785308533453', 16);
    t('62bbe37605981730a0651b', '30853873199744823817849526', 15);
    t('2db62d70d086egffd30a5e464hjklfl750', '521541774356940252445618700157719013899814514', 22);
    t('m96', '22822', 32);
    t('187708h7k8', '1110072620903', 21);
    t('17ce9ldjd8934gc2b9a3chc1d744i703jkd935', '62826943015042400290867266302428296777642741341475', 22);
    t('11443312400322012223000', '3332757738398500', 5);
    t('1hqjh7ttioeg3', '848328945650941083', 30);
    t('2be94375a', '66205466910', 20);
    t('221330320311200333302212213320111201', '3095465187976224408929', 4);
    t('1059486961', '1059486961', 10);
    t('1f74g8g613iggbic54d5c1666b3354853ci55', '19620313041727143313210925539501308523593302666', 19);
    t('2b80691b78400b3b875986849c456785a6', '16656663317340963020300085481646403927', 13);
    t('105503321454253531533345552515052013033050251424524110022331215545011', '95428095959296366124948006431032808833093168473760031', 6);
    t('63c22g38f64bd23576d563c98a', '35884274494603924587117723372126', 17);
    t('100000443142103030421444', '11924694146732749', 5);
    t('ggb57935h39jrjohipp0rmqdi', '894389162868447514060089400627116702', 28);
    t('2q2dn6b09n80d9k2g93ap6npnea', '48717964930141503475483909108219387417', 27);
    t('43614541525400501036656560325626334530352123112304543351', '137711359489426689304557831808873617418940236797', 7);
    t('13323bh1bebi114agffj24c1h711bhdcif0e60dd3', '89008124624321806307999787004805853614563072139070876', 21);
    t('1', '1', 4);
    t('7fb2ajiw2hgrnoeb0vhsa', '99256366762497264660825409804234', 36);
    t('149a672ab00124427a47b2636aba00a80b724a159b66', '35605955455380818029558322811688734791059784766', 12);
    t('3ad', '2645', 28);
    t('2222', '312', 5);
    t('102124304003114232', '833650441817', 5);
    t('7w092wmu58es1prcdq0498nb6q', '1537695760778926711856163192898098505322', 34);
    t('27f', '2025', 30);
    t('2fib6i3', '308401327', 22);
    t('5241360402442352621410122040100421346264560451615162662345006', '2729029317009007107739107745937257680991457741019081', 7);
    t('2c1a7b4270fgc467ed689a6g', '54141458195409785751855946358', 17);
    t('1010101011001011000110110010001011101011111101100', '375578620712940', 2);
    t('5', '5', 22);
    t('790ul96r', '309988654893', 33);
    t('1022653165254525421460266331000356', '8113458137413116173799745960', 7);
    t('3114306040302713076119191937545', '3114306040302713076119191937545', 10);
    t('1633654452405530', '9162556072418', 7);
    t('gabapnjpf1tf80bs2b7qd38981gr', '710991831783491714221384954071153594598939', 32);
    t('2', '2', 25);
    t('18c5', '23301', 26);
    t('1213330331231123', '1744034651', 4);
    t('1b60d2a23a53bc5a', '1972808230993378394', 16);
    t('4pavtk4kwc2g0r3sz', '37428329950762094839639043', 36);
    t('g1bbecabg532781dd572bcc45f85a1a835f17a', '54127394101584857904914717532946479324272494182', 17);
    t('101021210012022200121', '3985912249', 3);
    t('13iqmcb60d3l6qn9af41o3jldo5cqoqelb6kf', '14166929345174532589732691260929644735007809841979615', 28);
    t('2518135184834132752870818455702810', '79701961075331499851002499212929', 9);
    t('210110010012000122202102122011011122201012201120000202211201012021100021112200020120121020112', '187204475327792704723082910911246163138644555', 3);
    t('ha1gnkhng', '3630888091418', 26);
    t('12g655b423e00675ag9g7b6b28hhfbf4b22e3h1bfch', '61163427224627665999001017285634740702868701629011309', 18);
    t('3b', '50', 13);
    t('18', '22', 14);
    t('ab15c03638359ad93da63a0ac', '34690700872343342065779519544', 14);
    t('1g085f52a1g721f56949c1679ag376ec102e40', '6532133482571135978509596041353302889104298965', 17);
    t('1t6bar8271g65th5hr89nk3mqrlq6i4tff', '10972219189140165833792184350100087874831084514565', 30);
    t('64y', '7954', 36);
    t('101110201221010200', '150258663', 3);
    t('c', '12', 13);
    t('iaec11ceic9320cbb8h8', '245219574798540725794780433', 21);
    t('c4gf859id03c5g676a13e5dbhe', '1140847745113516444764873661865817', 19);
    t('1beik1nyofl440ag7gkcjl6hc', '15143452013784185315179545005102573332', 35);
    t('76689e9e8754', '64261061415529', 15);
    t('236oh8q7m88m1vmbwbwtl', '4919241811255159457064943728087', 33);
    t('212303367410485756685340683385777821', '212303367410485756685340683385777821', 10);
    t('ia8d2l548mr69jp', '3344051649396076528445', 28);
    t('5b46jc6n0sxni8xvpercfiqt', '892299334153828813360735264583249649', 34);
    t('6wjkpdrd1l1eq6ev75lw2dqt7k', '2769821915598289015754184942663874264915', 35);
    t('2dk43cneaa38bde9il6lk6', '248598248682430883472103621926', 24);
    t('2dt2ep3auv4', '4969992251611066', 34);
    t('h5eg38u5ob9g1lwao', '33951757895785755222148470', 33);
    t('c64b2aaa24b8c1cbc1a6a116a687a520893c9010b801b47', '21775469720607548784649620095270581236726101794248269', 13);
    t('5fh1274cjdf3h55020a74c5', '705854882662235548477311540560', 21);
    t('lb69k81d', '73171113401', 23);
    t('epmjfo2h3g2g2e36b6c8n34kpe29gp6dp79lg1', '338817707971967615907480318364523251504671071025089101', 26);
    t('240440323120014132430403102121201024012100040001003200142014230300142', '961763898207535652839231078700423730480243212547', 5);
    t('m2jhe8i', '6828900850', 26);
    t('11101111110110011011001010101101010000001100111010010010100101', '4320760375549338789', 2);
    t('1045205104430132440520024411321142422540353410133210445340142121120', '2590167532599341334614211172458659924849693395596552', 6);
    t('g36jd1oe92jn86aai3jkklcoeq3obp92e4p4', '253854072983617271692860022272463002824013138562756141', 31);
    t('8dkooqd4zn', '850775103673475', 36);
    t('15120343551355124445525435232555231033521151050423243335402', '2539878326431426452775761994842902860886262746', 6);
    t('298lgil5k5kcgili6lg3kihb23gc203l7cb63c', '113456079349387858220556248154469725980796810803534', 22);
    t('1lei632qmoefkm31p6imh065fa7j', '797240105544041247670463126344319732926', 27);
    t('5j5lid3cq1t97vkphbce1pdsc0ad50', '249736734398750751548236560945594271892059296', 32);
    t('3477263035715376447112210', '17112580757759444423816', 8);
    t('156448734843a1a32b376aa2654087b6', '4161327287906171047830726268271226', 12);
    t('34433515140021245052211514423', '23302817098029688581807', 6);
    t('1j', '51', 32);
    t('51471b55a0724a95b6a5c7338993303081ac', '4964947861806473401365128050047846101681', 13);
    t('c24h0hghhe534338cfd8135c', '901568719507789440497671591386', 18);
    t('bir31dee2n4q3kiqncidbhqksllce8', '206194968967125424489569046312454402749360697', 31);
    t('120022100000120120111100022111120222122011001200120022202222022101021200110122211222', '6788270345480080438329192354621823378457', 3);
    t('174fa72d10hf8f8h2e3g99cag8h', '608727676666149236358796734219473', 18);
    t('a1h8432ih885f9', '424773876852211679', 19);
    t('nojm2d4ns71v37ugm0qf06gbcmpnw', '78337300498913437512813545723950687423977167', 33);
    t('161037100117541', '7769478438753', 8);
    t('3', '3', 9);
    t('1b7b2cc91769682ad42af60ef67c77c99ac81d227197', '10281919698706053870205728976619722313496732052386199', 16);
    t('afh25f80e4ph82gp1fr67hmrgpn7i3nq89h', '168629703795331360132747588030374114678927773055501', 28);
    t('3323341402104', '905809654', 5);
    t('1wd9i2gb5x51qwn0i3uf1s1ve27wjpvj', '584082364118340230826335224432353183683007501197', 34);
    t('32577073350883554', '6105022583908099', 9);
    t('a9bee35057d1i71ffe8a0ja643h54bhfa58ii', '720134659347610141900482413183484695157617643578', 20);
    t('121210122100221002202202210000201121202001210111011200111002110210', '19230462838832172623888006401599', 3);
    t('2hfgf7f293d9bacc79ef', '2120195472437110473202983', 18);
    t('5ihjghqni4g96j554pe5fc5okg71de', '14486130945303122393368850677450427863143234', 29);
    t('1', '1', 5);
    t('8iw9sg6afo8s0k8uf01e8vsbdiagnfiaqh', '2958988238033921612788754062346621852633413272634125', 34);
    t('4beubn95hjpt4r9e0ci7usc7', '366449081183766477979316652536458765', 33);
    t('d48a2d77b1b60940c800003621010101a61763d28549b', '3584857812230806937337786075261982505145054504278321', 14);
    t('0', '0', 12);
    t('g7a3', '112464', 19);
    t('10111111200110221021121120', '988574822682', 3);
    t('1r4y316lix1qw2umka60k5rhzz9lww', '2380985708564990921650705038323328729070310960', 36);
    t('10110512330112515662324231', '1372761603510037086403', 7);
    t('16a9c4841a0c959526650301a7b5caa2a65597', '3783858424048742348429335229654291816630417', 14);
    t('fgrg85nfo4947li3dqj', '33409143920842372353926257681', 33);
    t('78a9c9d91cb45ec86599f1b402f6635265b69a0317', '176349517282896190364726424897935661923732528169751', 16);
    t('1408fdc9f191a9be2efbc3846be66cd47ea391b', '70707899311965473818711332151924460200296539144', 17);
    t('11', '6', 5);
    t('32183b04e5e72ed8c76582a5e', '52862848155929840288075992214', 15);
    t('1140302201413440103242033313203', '1271212993476215135428', 5);
    t('30xh2uypo0ito62vbqbntsiq', '987701737110790082032413714393048956', 35);
    t('1c6b943a8603ab486e082d6a4a6762', '23395026406105011370375736268800042', 15);
    t('12ff86h', '790162397', 30);
    t('1s7lqds33eengipiipxqqa', '858343047434452825500670693844626', 36);
    t('4f6e67b1114hcac24d7i79c995', '447528954470338933744428432073566', 19);
    t('5636664', '698688', 7);
    t('mafk7830dc', '121664093929910', 26);
    t('768gsjk4gsm7pl1ot75grodpfj0t', '133120656483903774436059010594997642935901', 31);
    t('4313442301430144333034333224310301432040323222210030044222211411421331344304', '123662770604980307050783935056941063117742366185028079', 5);
    t('f977ljj', '1748806177', 22);
    t('eg38ke7fk1', '79381095454493', 26);
    t('2i7p4t8fpceetf4dnlq', '1010667644618526459089112356', 30);
    t('12c4g4', '2171092', 18);
    t('2', '2', 31);
    t('gn2r2eopa9ssql', '267366244724756072001', 30);
    t('b28ana08k94f596m0h9hi7n', '25697606312564649510807036677951', 24);
    t('16ps4ug6m2ba2r', '29801816306000563900', 31);
    t('5926b', '284051', 15);
    t('51263426046122444503052060226', '2393161862759116724273865', 7);
    t('8247054749346666208174a1', '7360587857824675562554214', 11);
    t('ka4jnb62g8cmlf', '17902323632911891335', 24);
    t('4de9276993hgb8a6echc3ef224b38cg5dh', '1265428646069784687854510709176092917599183', 18);
    t('42gd1k2jj', '322506363396', 23);
    t('1hn5kpf05fb4o0a6hr301', '143595453719112771974614666609', 28);
    t('4e603fcjm32086ng194n', '7107200633977689504284025944', 27);
    t('qfjhf7t644i8rcprlhja28br', '249684275564201049491161041832861557', 30);
    t('10o3mixxqcq', '2812826818986546', 35);
    t('1202111021110211021102202120202012101001201111021200210001112201202200110221121122101', '21059093384477202862416737568527737310314', 3);
    t('2ji33jfcje7ci63a7j74658cf4eic4', '160814309330846460265100741771056759444', 20);
    t('1kjf2ige0j', '2353894887979', 22);
    t('47534897688907458', '215057061551555682', 11);
    t('4175', '7145', 12);
    t('52', '57', 11);
    t('2061405345251056213423263560600313464103414350261551220366453223', '370646419200904248631530204999374005994255272808697624', 7);
    t('1a7fhdtcdpl', '3563463934771321', 35);
    t('33dj', '111526', 33);
    t('39894', '79024', 12);
    t('7e1d1ed059a1e146138', '11736928073492751232403', 15);
    t('159197a68aa2525674259a8995014b69b43267906', '21755721404512460507158581208182125061497430', 12);
    t('lgfi9r5hunkcmir8tclqh6tb1pqf33q', '11856112170670785902649247238864725820665462048', 31);
    t('221a2ac80c43003a864a93561a33', '2581136407529861197214154837507', 13);
    t('15k97k6h2k5k8ejkh4jf35fh6c014ed', '10587821536977531443888357135531651418988564', 27);
    t('1rcd8', '1739821', 31);
    t('3c2aqh', '152433373', 34);
    t('13dp547hbmkbq39', '123667923481065503379', 27);
    t('77425744122551307334650320055405680842741484675143', '448423853223269792174799411068423443678773482313', 9);
    t('4sockf2l157f8hb17ddr2hn9', '21560188551982844171137848011861038', 29);
    t('3juflq4b8kdr8f21p00c0t357l2t5j8bs', '1928545001966571247157174149144121166575881998307', 31);
    t('ghp116oj9ld85dm24m3fhp', '19072941993100916686445846260174', 27);
    t('2hi0977bg554', '998426859590521', 21);
    t('dmq1t205zcsi', '1794163292538515586', 36);
    t('kjck7akab8f6lg35g3i7h7g', '7132544457923014075211392976822', 22);
    t('2d3ceebhei36e', '5963519500590381', 19);
    t('a4q63wkuhu5ew942ns1ep76i4', '28222639869071829322012344499963435954', 33);
    t('6o0jiguur7dnbl1usfp1d87u6fdu0ltisl4', '28664748020226432037191687849395173254239302974652396', 33);
    t('t0l2snlanhd02t33k0nj9c0sc88tis1', '5975669526488595725702933777554273527309680041', 30);
    t('2fmjlnb9ol7', '368530312010049', 26);
    t('qhhvd3umkjbqw9tv7', '52479183082258753819239127', 33);
    t('2500403606135212325430122365142624450522464122104', '99685783804159217515113789269706714123131', 7);
    t('67qam7pealp2tbtr7c7', '2426267332304775510672525667', 30);
    t('32556410147661251456104752223004', '33072622383942794561666491908', 8);
    t('1c4ba716175b6355c7a', '219526637401960896784', 13);
    t('5f1biddjbgdb988d7i73dgg0j9iid3411', '2471320652055149744926174715249139131705621', 20);
    t('1388d574ca446bab251b87412c45352', '30454263653289721532545707133349100', 14);
    t('7gj62q9ggf07fng3jebko3heolfp8hhd', '5526886878277522528388980899464600768775115001', 28);
    t('357609f72f993e', '32878913632422200', 17);
    t('292357a4a7ca0a4648512acaa416', '3226641593686507554429950032194', 13);
    t('13hog', '1313053', 33);
    t('aks3be893ugctq81jr25n8', '823004494027615294747011449706584', 33);
    t('1901201228993448243', '1901201228993448243', 10);
    t('10pe57shgkj0salrufuot8', '21377178212418820499882165050214', 31);
    t('1h056a5d68', '385881101936', 18);
    t('s1q88msiur9c5', '46791653096466186782', 33);
    t('214256605b5b68173072b55a286678a78809b8a1b9123', '643841400834614066547345702859283739566239655019', 12);
    t('225934566430252988213108187132502829348539', '225934566430252988213108187132502829348539', 10);
    t('d46c910d58ac7136d30353803945d705d2c686b94a4b88c', '702141078557834674338031856012906248646954470735486212', 14);
    t('60561454833387506208577187677017606400252625684525728', '253403574031753766760677099922706298646581738014040', 9);
    t('5855c280622b208', '22237016075348836', 13);
    t('551243031044335040041414252402143313230452031', '101760249517059532483322747468911891', 6);
    t('43fia', '1164224', 23);
    t('5ffn', '163858', 31);
    t('150c7d4ab18bef2ef5f6732d9c2e43', '624946142089881488416245393484485342', 17);
    t('1622555136441511413165355262403631420051', '1733785303380199232372666440606372', 7);
    t('35gdh2332d44c44fe61beib', '44909929802583956335572418047', 19);
    t('1a2', '553', 19);
    t('6l23gp1o0d5lllh0h0cdg8phhooc8le', '19160300206063055542614858497172997898567024', 26);
    t('356555', '861329', 12);
    t('121121', '448', 3);
    t('cn81glehb1bj731', '272882629276550119945', 24);
    t('310f7e944db1e20ca7d4db559be74aafcd', '16694431636419175813863637436681440374733', 16);
    t('1c50o3fo032p9dlma2984c2m1n5', '9043264155154723194686490722280250127', 26);
    t('2r4je4q2dgrcwof3ha10riwtv2i', '38819957816824364031051480668637630210813', 35);
    t('1bsa21se9qifdeljkhl8t', '487505004229099904116267378169', 30);
    t('6hra982l6rcia40f233gc6623kndbhi7', '4832827139354482206384048706613262325658834511', 28);
    t('54c1te5y52hryxhw8dqfw', '38992453646077977693451503497907', 35);
    t('111001110101100110110110001001100011101011000110110110001110111111010110110101110010100100001101101100111011011100110000110111100000011100011', '2519183162360903506191281057447758087831779', 2);
    t('7je5fa763i628f2261ed4527cb', '2679563654580342682033196365619051', 20);
    t('3dn6l79c9i41', '5450807136767713', 24);
    t('f9766807', '52451515394', 23);
    t('88ed0197de', '1684047406892', 18);
    t('52h1b8218gdc40ad5i310cgag863ag', '276096404325838933546263152968372529416', 20);
    t('52t9r2u77vbvf40efm68bawfi2h', '33471177559078492055448775316984931198101', 34);
    t('200hd', '210271', 18);
    t('1f1v242ndsl7lvirbmm58el7', '122766495427277981800542186078046723', 33);
    t('5h', '192', 35);
    t('a7538d005092a0', '8355305185328108', 14);
    t('1211474324420476530235671057512302', '804188130270400499435404432578', 8);
    t('36007574066667272553066076615170250031017703', '2553404178224213798051876650192088604611', 8);
    t('5e358', '487347', 17);
    t('1303322003313332132023030213123123210311132201113000000201300133220032030023213310031203', '43366030506223289335027745955530792181104257171145571', 4);
    t('13579e8b8g5c1ii6c63102', '581965839975794432039894464766', 26);
    t('een2b8gn5a0akreg', '74066109426399607206216', 28);
    t('373734g9481fe1bd3808ebg66f', '19756375071243592050789033494286', 17);
    t('1122000020200011200202100120112021222202012201021212012120002222112122210212112201', '722771278211345591971149292885640595157', 3);
    t('22rod', '1295069', 28);
    t('q5odfp9f43b1c50qjqpl6r75', '50477571992047059200316127648900857', 28);
    t('3acw01ki1tllmf', '268187445649566046567', 34);
    t('179h9bpefc02l4', '3184639878779111822', 26);
    t('603076927928855a459', '33500247475513964715', 11);
    t('b7937246a973707756360997bbc4a1add265359b332a', '221810527222776063188868345414589959484754657616362', 14);
    t('11a4ae80f151dad1752e32c310a41dae552c37b7b4', '25785693883194456949802584063055012266517133244340', 16);
    t('1q0s0ct3a', '1993804772458', 32);
    t('305b07aac599939a5c2a7', '253475774098192811736459', 14);
    t('3e7c04g60291a4g4c9f8h6fce634ccba', '3114555919530851258064228685168186383232', 18);
    t('94nl1m3ak53p4it388jf6l3mq', '5679054267841124072813695563380516908', 31);
    t('1e9e77gdcg8999dh501deb4b1a8', '783953025310755506835756788250680', 18);
    t('lomhb6bfinkeke7jghdjnhibdi', '1953665391422082290906397636706147843', 25);
    t('2116596779495229974441934380827118544653435', '2116596779495229974441934380827118544653435', 10);
    t('368d9', '174129', 15);
    t('1agh7h9ae43hi1af8k8kghdhfkc08dbhff66dg', '12657253320720905806182288358437536765226473490475', 21);
    t('320abd803f00618b853f0f4ad06d76e5ead8eb20d', '4571024861681675091071130733403917525672421929485', 16);
    t('13s8nnc8bsk2d', '1862804681403965620', 33);
    t('1d1f67lnfl0l2d54e8pd4fdld2q1f2i00m2', '6881652679580574557491455550605507870404485512536', 27);
    t('200e0d886dg8dc3b3b2bae2b5fe030egfe843', '396106131924337983787092625578393234401506110', 17);
    t('nnik4kneo3', '252246525060547', 28);
    t('opgbb9o1gvdiijz8jg721c39untg', '25881420507156207174185940935514686366771476', 36);
    t('1837bbb0c0b3aa5', '17663579102091025', 14);
    t('9jief28l04mka1lle8', '2856790240918270335561368', 24);
    t('7tp3jdgcfd32', '141621578705936792', 30);
    t('4', '4', 30);
    t('222300022013300210200', '2937927436576', 4);
    t('11100000111001110001000011110101010101100011', '15455189161315', 2);
    t('1ha43j30df6io8438bq9slk1', '31199374101388173422454285941010092', 31);
    t('10jbjaf26fgjiffg64fded9e9i5', '24920507465295692091626238401086277', 21);
    t('87h9ij5dlhhcjh1hk60galgb7c', '92091778011039547451374958750302842', 23);
    t('2784592431917088379783455384035660971125128970527148', '2784592431917088379783455384035660971125128970527148', 10);
    t('3f440273754699dfg5bb4e74', '77813808595431029263623003362', 17);
    t('1533i', '947808', 30);
    t('c681cb1744269d1db3976001b16d3818c2b64839dd4', '17109878266190272366632308176425149995679950565718', 14);
    t('60v', '6565', 33);
    t('shn5ajab50en3smbga0d5s076', '3582012633407680801468180717971425010', 29);
    t('e3j6q9ic5', '3992855661140', 27);
    t('irhcdao47803hhdpeu9e89ed', '378032942792617127943658071456183506', 31);
    t('g256ch64c0b74idagf1ab1ifhi4i737e6627', '9199059457373375499891835079838688223060102043', 19);
    t('10111010101101', '11949', 2);
    t('117005335301204024246205442614352033070314715177', '846676850563380044165463437005588987127070916', 9);
    t('4f4a32024611g26g2264f6', '338430706762087113025482959', 17);
    t('5ksu', '169073', 31);
    t('11mrnnlfebrg7raer', '152018401101654203204227', 28);
    t('83ioaci', '3152456595', 27);
    t('9e6142b038a', '34978108072150', 18);
    t('1emawv26mw212hnqtpcwl4j99s', '566817147004008119440688047613652334743', 35);
    t('29sh6pr5181di802j6t', '14165634085464252520185940514', 35);
    t('7462320173122283772726810', '599983522402508738369613', 9);
    t('3wrotodvd4dgo8sn2epehwf8vdoh9685c', '15630856736175398255351237559386715772597049203092', 33);
    t('2095151352baa52614a53a0421205491386524a32b20b', '629494720198763535790368010310014455139220124011', 12);
    t('909848', '909848', 10);
    t('1e1b700ag1gf8eea9b3488gf6a8g', '3050765026582250489151628861107884', 17);
    t('17f27d4daa32a', '421284028261162', 16);
    t('3fd14203387143ed10002039a6fed', '20709934734392064809458286974365677', 16);
    t('111010040102014022442422222032420002341024101300144343101412134', '26924030592936765055391026801687634225029044', 5);
    t('4wiojwnbrlkl8pg9foo23uu9a1qpbmlac', '126760787317043868804119267318859978950162615116837', 35);
    t('210320022332330111223223020320012020', '2721092611678604067208', 4);
    t('n7ku5i7ckrca9k83bvdh', '920599639906328717359960161713', 32);
    t('17b220gb2623f405b0', '18058612030620400642220', 20);
    t('606mb55', '3573729571', 29);
    t('9d59e66704633dg70ag8gfbf7998831ge1', '2585365443584252475016853533056335340761269', 18);
    t('11111120331110311113221201203001223223111320230121232310100232011333011220123123130', '31183875195251062246636964788521888205106734806748', 4);
    t('11012202012112221210020112000110210121122201111011121222010', '6614437174755192747904170297', 3);
    t('4566b69a3b1567574178164a4394616b309890b373a', '9444463089320211225317858853703681134950130526', 12);
    t('pkiga3j55qn', '5305045276825646', 27);
    t('hb78bcc8ced66de45f14c04ae8d6hfeg42a', '84259895898473468702361264132957044004367294', 18);
    t('30436028074514706633323564703107103255261676805352', '174908702299661723007314223174052884313545177020', 9);
    t('6klbn2j2eln', '5464796003103282', 31);
    t('7j3pcw6nfmhr9fxocg1wxkenrnkt7we5m49', '88904461013157334884357042737148269672311351079065265', 34);
    t('r82v5q', '914455738', 32);
    t('34ad769763ec2b7', '96777760100981122', 15);
    t('gmposxc78rakn', '39780003905171575839', 34);
    t('a73268168a75548674124697', '9548080180583883175964866', 11);
    t('1237051', '343593', 8);
    t('q6u777k1', '1376248631213', 34);
    t('10010111010010010011111011111011000101100010011010101110111000010', '21802627242312687042', 2);
    t('14dmjh7bjlc4d47dmfae09kcj524505mjd', '1038322928472978173076737040174508852100751669', 23);
    t('11317560a17393ab6a99a582195a678aa749193a39b9a0', '4041658781234719016719043489530302116978697137352', 12);
    t('3120122333011103321221103210310332213020023023220112001000', '70232841201518207453336540043894848', 4);
    t('119bb65631559198409a47456871003ca715548c33', '5332093690285257080851788740211348309400491181', 13);
    t('1m2rec', '36143234', 29);
    t('366237621254212707310212730126632527636236606', '20953914213183846148388529652331213045126', 8);
    t('5tt1f2duo4glotq8vsfkr1os', '246514271200574513800096210368694044', 32);
    t('34e1bcb5gb53cibjmb6b3', '5492559329232323890310212939', 23);
    t('3hb44ahgj6d304fic32bjc8heh7lhk', '3232709760711829349820278323781274358774', 22);
    t('346ffj4208je', '7559300332817989', 25);
    t('1d73nf4c2ic64', '223833191887270462', 27);
    t('225024242331044121344', '9046573709095648', 6);
    t('1049hebe2f', '201147941571', 18);
    t('230kc5cc2bbffi6h6003fie16aafdd8bd67dj', '4542385341584792754115882088702313332812815292781', 22);
    t('1f9b1tk7v7qsb5um73klta', '59949796791943622919687088265130', 32);
    t('4184b1l3d96gbngkgi0bg50mk2m1', '74780513187896152341086440607818686097', 24);
    t('okmg182dn4q7r', '8745053305431694017', 29);
    t('53ae7173b79042ed481ba175e034e38e1d0', '50951535169205935843174191126575047980795', 15);
    t('222i8fc3cjb789c995511jde1g9', '14141883645422057031570049406992729', 20);
    t('aeiaou79juj3tkj5ga2k5qchh3ahce', '185979506581766660458072557764185061403967977', 31);
    t('eacae9856ijgj3242678egf9', '12189771867978125139049367798709', 20);
    t('2433113434303102021443032400412244243442443342242', '10466909999621086883955370845684072', 5);
    t('2ae0fggc6c6g', '878502187845025', 21);
    t('180845968a3226a8a253479619663', '250001325233535979152109394821', 11);
    t('hj3tdd8slhdf', '2307423515301123891', 36);
    t('ddf93c33cbe97520fb19a19', '4293593374816726677147720217', 16);
    t('10013104402044003311220402002301031430001044', '1151854194727926643451204922024', 5);
    t('1124210334', '2569469', 5);
    t('7451704923b3ba8647a8c6b375402115658417212a4963', '984073049999829873728964883865033372424530670574289', 13);
    t('1ij8n0u5', '54333768645', 32);
    t('463cojq1oo', '44627322572360', 28);
    t('1g2509ced735611b3bf0dd25egd1383ia5i', '55515377175716442946588772750863162331336647', 19);
    t('10a099149225276aa0308163405854426a4546969042', '652590329197497894293981277355838911625689415', 11);
    t('37bc13d810602438ce47db31c0e7a87e6b7831', '1242924848237600517379561065653635852461111345', 16);
    t('676337572246445153657', '8042293848523986863', 8);
    t('1g68836b967fgf9421011', '24334561727939858364932923', 18);
    t('6b6620b97ac6a6b6', '352387246281540515', 13);
    t('12776426', '6309843', 9);
    t('24b0c6885ab8b8a892', '228166923738350465687', 15);
    t('2', '2', 35);
    t('15a', '346', 16);
    t('300134022400134213344140000102213323042404311040243310312000343103042342', '127652641370367962998095582336792086908935738721597', 5);
    t('3lfs4fgwbvj2wghyh740xh4oirg', '104622608267093965118263270976335121345788', 36);
    t('157423050242731427202356723', '526719833217016133180883', 8);
    t('1b15hp8lt9ju2rh8dqp', '2874344460549394391885632870', 33);
    t('533921', '5454113', 16);
    t('7732111706233511415326631451', '19164044677656856523125545', 8);
    t('3dd0h9f7637i95fac3heh40c', '959218007315210960375525274067', 19);
    t('881w1kydu9j4phfb2c07u94ghigb', '4029435105852318664830504263789530818302121', 35);
    t('51', '181', 36);
    t('2eh', '917', 18);
    t('ca16b71428aig5i579j5jfb0ie2de4j95e5a52aj', '6873773388658232174414133826827672181606125713641019', 20);
    t('20486090530289807472885277534944595036578390a', '13514447539625782711007863489274523595153330080', 11);
    t('ioq5s4bdalj52flkt', '22698271406125036937402013', 32);
    t('7a', '150', 20);
    t('hfhrlg3rrnnwks8kws5qksp1la', '1603852442098792332083147036848732541416', 33);
    t('5700507927296a1058a55a90235789278085068346', '28062460682476336947447786622579009202128233', 11);
    t('959787104', '4077788116', 12);
    t('2a7dda271d5i2j31eh72387daf31c639hchb84h74', '27699000410590034444165195331712291767536579684518944', 20);
    t('111100101010101010000101011000001001110000100110111000010111110010111101101000110111011111101011000001001101111111110111011100010011100011111', '2642399810851701674212632837439227993925407', 2);
    t('fbcim4p3nsgtjo1r03vfr2j3iqe4s0s0', '701339888089764999500469781844563368651453760384', 32);
    t('64lzp05nduwcdnr0noygfcm85az', '178315640220328504562173918873277402530523', 36);
    t('35lqm90bgico0a4bm5pm76qr8q6iibfph', '65327914287307331894331060275333284488697055741', 28);
    t('83a2c22', '62241790', 14);
    t('89ebae1173d48a4', '252977067390654829', 15);
    t('770d01b680082f7c23db6444c14f885dacb63824', '679659960629478197799609320106784570818809968676', 16);
    t('44', '60', 14);
    t('133574562456214335435', '1652705792533576477', 8);
    t('hjc4g2j5l13o8j194g4cak2fg4448d5lo0606b', '94123874693313956619727979886115180204328649160250161', 25);
    t('153301155', '3242879', 6);
    t('20db9n21fq5ibaapk90chaof', '1684131408222169123186744163051184', 27);
    t('8908560898716681919534923549712841926366', '8908560898716681919534923549712841926366', 10);
    t('110101010010011100111000100001100100101101000111000001000111101010100010010111001000001100001100100100101111100', '2161630318713979730472184517642620', 2);
    t('164r7nnhmtvtn5dqm9vwb3sjam16', '118591147821330046156032931950921969681024', 33);
    t('jm78unrb447ll9146j29fbu2njvmfgbl', '899490746363646305757921797948267020154887979381', 32);
    t('2419413757519055953413373253672626060250908979623', '2419413757519055953413373253672626060250908979623', 10);
    t('78i', '4593', 25);
    t('dc1', '12866', 31);
    t('2jci759g3516', '610774111386026', 20);
    t('8824059425840339a993058b86957230870716058427784746', '658484467757378126049963737243666805178029770173426470', 12);
    t('20', '30', 15);
    t('12fnrrcj2g3dnbj0uvd3lqwfrs215hlt6', '4206028108501355290972496973094116936076368376680', 33);
    t('11682eaa9a50b5bcc234b90342bb9d82e10da8cd55e87', '6133831849997371600782799052395677700841654445348277', 15);
    t('224', '224', 10);
    t('1kplfagn', '18578948909', 27);
    t('167110ac751f4fe', '2158807311824281914', 20);
    t('1d35', '7477', 16);
    t('aa906c1dabfebe6da', '196647076124632540890', 16);
    t('a9692a0a76714aa83b9088424a3955232971b8a618aab2b58', '68234402305157694365438746604458604774416341282072308', 12);
    t('57g5', '156183', 31);
    t('1ghp8v317z7', '5331055013092771', 36);
    t('3b4ho477oeopclmi', '5753023344951280573362', 26);
    t('640a34c4d5bca61b85d8255ba0', '1583171296199874175043612916375', 15);
    t('655', '1621', 16);
    t('4713001873693116544881662', '4713001873693116544881662', 10);
    t('6gl3bca0', '30744845808', 24);
    t('60644mi3d', '917033167588', 25);
    t('21151054205203166605404660561', '1001991791616520586906319', 7);
    t('129qr11chmnjfbix', '235017795197032514991897', 36);
    t('244bd93174aa753ba6c202185776cb', '3994077758483075041207284320967331', 14);
    t('10b4cdbc67791d914b4835190', '3400360668240333886096375178', 14);
    t('1gjm2b566fl5e52133930k7088b82ijgb90c0', '18243047800946255257397415707493803164371776970538', 23);
    t('3c3031a86910bc6256', '118078665313660741892', 14);
    t('5k0u43zh6', '15674653708890', 36);
    t('80137052', '38347634', 9);
    t('5783jfdm426d5lh4h', '64288507756051477652657', 24);
    t('1debef5dc8c2g4ccg2b1effc389', '178108250891112116916624674314670', 17);
    t('rn4b', '1289675', 36);
    t('96bghh4a66fk3g7ehh13c', '2590902696974891660626840167', 21);
    t('556423035126405021416221205151', '18834557073762345117422046', 7);
    t('1ed6e1bi4b9c13', '74595097394557912', 19);
    t('3d8e3ijff6f8g1656f92hc2dcha67ik9363hg', '1448249031707035880952506340806153721615337546525', 21);
    t('9ok43ekhol', '75619493880060', 27);
    t('11af668734ef7a60033c5f518c530', '5739161962048683655238213338449200', 16);
    t('hro9lido58n6', '149244549072792522', 28);
    t('2yelbnsxotdubg6p2j', '846844061507274550621896811', 36);
    t('3f8a', '86024', 29);
    t('fcxqpdu0', '988921967600', 35);
    t('kohlm', '8198672', 25);
    t('cc57148', '62535637', 13);
    t('12151', '5225', 8);
    t('3375365cdde3db711375ae895d85d271d3cb25', '105909922550502800264613611713682806644035510', 15);
    t('21031424', '1772495', 7);
    t('4j3nl0517f9m0m301ganfm233l', '153601615041435840934780931557446429', 24);
    t('4310255062420466600245524221213133235464365030', '476197169299254422116266555387455712335', 7);
    t('4244423244041424242212043102240041314210000322', '130719114900175165281529950078212', 5);
    t('nkoba1m6iajaofd2e18qgr7irlcrao6h8', '483767596088912028670249928507167976393694305348', 28);
    t('2bf51ahb70i08dd7dc', '76858429135673573387403', 21);
    t('9035964bc6d843d71d2ef9124632b039ca9ad9d6062cd', '863281823741412484448091339719676346358410323679011533', 16);
    t('30lln67g83icilejifnfc257chemea', '105297837315708788148863073871950075232860', 25);
    t('34rlrbnqcogal48', '578637984758229207624', 28);
    t('210', '105', 7);
    t('4g', '84', 17);
    t('b384950cd1e16f', '16589581301885375790', 25);
    t('8d9bhgdf3930', '562480785855234', 18);
    t('570b40885', '5738449608965', 32);
    t('1o97ac9d17j9b20ojeg5lnn4b2afddlen8i46j', '10454900498332552068488800154275426413110941145987044', 25);
    t('9ldj9cic03oom4', '14695585287355078054', 25);
    t('53287c', '1947997', 13);
    t('134kd7hi96jd', '404274808381030', 21);
    t('5fm21mdph4behl0a478jki5', '1733653126898384929528694793111545', 30);
    t('11001101011011110101111100000111110011011001101110110010101100110101100101001111100101100110110010010001110001100000010011100110010101000011001111001001000111101000010', '150121826439470624887536282475629271619430756159298', 2);
    t('4', '4', 13);
    t('4d1631d4942f63e89279', '1140237935084465937312261', 17);
    t('1372066706', '199781830', 8);
    t('11hhc23551e866ib6812h7g23ad', '7346411878504474781966365272977413', 20);
    t('101111000010001110110001111111100110010111000100010100010111111100100011010110101011110000010000100001110011100101111010011100111000100010000000011100110111000111', '4296345185753731570217826010182320032993209601479', 2);
    t('b84d8a8i32', '3689641436737', 19);
    t('821ro50fcuctkgot33m90ob09tucvv1f', '368313190889612097541983506195312358021535890479', 32);
    t('1742eikl8lom1h71ad2', '37595040685294737585118388', 26);
    t('37324076026320245555326737570636206', '19911177604481197795113399696518', 8);
    t('320023020321233320302211200320322222033103201322110011320211', '1166689340508182807089736390989078053', 4);
    t('vikd2pt8101fd9eil04sq7cvi6l', '441068211140868982000952250746004390824531', 35);
    t('442123', '15288', 5);
    t('711i3khj96m9511mfn20c5bjemc13kfn93', '24821870043582444752692478195243347378957786779', 24);
    t('51lmp8tqwo2ihznbv47n39v8wk05', '5284244405211887591129226457353248485630277', 36);
    t('28ia', '25574', 22);
    t('1bcr3flr9a26qiocbai0g3na4p3a7kd', '36624769937531720777599142004807101241462829', 28);
    t('14460a28a41383802814154aca2c71c5cc4391791c33aca', '2325888630013449576179969978508312620979962590691472', 13);
    t('e708234759a6db8944ee0a6e1b6', '1413966030986819590654632803896888', 17);
    t('q4iad60645grlf0coh7ajunj', '2203400666051301621545431516042922668', 33);
    t('1220112101122000120220201222121201222002112000212001', '4110612146620826410819909', 3);
    t('3', '3', 15);
    t('65f8bc89d60a7011dcdb80539f104c2cf2894', '1255404535660022776668629518669612407348698590', 17);
    t('17d0c2897b9hk96aj', '1949684990803549976380', 21);
    t('2g5fed38ik06ii4e1c3bhdc0b513fe01753ddf6c', '10228352956451115239173172361471341616481366320264027', 21);
    t('6bohd4bgt0eeonfjajubo4sojmfnms2mcv', '297805807713638700732162989593992480395200752081311', 32);
    t('5df5a6eg3h2b2', '12674703290992823', 19);
    t('30331120101023202223220032313030032223212233022223222202220', '269148936607402430897888550064138408', 4);
    t('2a3nlbjoo40fbldn07d9n39p34p8alin9gqq', '297524222430407948715826730547173299573877425424600', 27);
    t('1h5cg9gld4h07i7bgh', '499570659694781114823761', 24);
    t('1framh4l', '41608063497', 31);
    t('131', '1405', 36);
    t('74m9lo2h16651b4bb922capfn', '386718113062216498663314663422184395', 28);
    t('10101211101010001110020002220011101002010120100211', '271290657968780557694368', 3);
    t('10201210211111010000110211011102121', '20755601360118862', 3);
    t('o8m10fgn2jiu48go9sm6og1mlhooht9', '13369563582584175800565573934107108011510398039', 31);
    t('11101000101000110001101001011101110010011110011101011011011001001010011111100101110101110011000100111001101111110101100110000000000111001001001101', '81062205635532331055236284929003822323364429', 2);
    t('11010111', '215', 2);
    t('6b792a454071b65717222968a031a81782b1b9856636', '177037493461561410531659133074253146230898913546', 12);
    t('6311c13b75126da75ba7ba4485863726', '2107483404556464441066229583431654982', 14);
    t('cpnpj5hmoj5a1nigpfld', '9961795419078247375796458163', 26);
    t('10121452100213303532013451014132100303230445', '2998363768314347289377629629426269', 6);
    t('20', '8', 4);
    t('1ccp559ip8j1s70q8ab2c0227rgs', '25883719710063102259022735893679879209136', 31);
    t('h780bg2q', '591900557402', 32);
    t('a84850aknhp9hrp29rjfpmflaa03ckann00', '164376078844886204368282401541329974440232267281584', 28);
    t('2c6c138b6024', '172705552710088', 18);
    t('2b7h335ca7917803hfe890', '604800599026530009611628162', 18);
    t('413kgak', '459596960', 22);
    t('5570634a7653209a864697327a77aa7a167654aa214aa46688', '5883232483921140121005021114807539284596199567869393', 11);
    t('fa3d98dfd239530c9a9556', '302522339292227790310118742', 16);
    t('110030202222212020231013312023111312012023330132313132201212111231202', '109957282949036883749941648777035608841058', 4);
    t('3oep1jk36mmc8pbj6pq06qdgg2c0', '1733516732758228053675351796432011366126', 27);
    t('1af9', '8067', 17);
    t('e92g', '224441', 25);
    t('1466104572263031', '68894276814035271', 13);
    t('10011000011011101000011000001101011000000110000101101000011101011110001010011100100011', '46069664430530648537081635', 2);
    t('11mm8ml58rari0e', '193855100598485237870', 28);
    t('1pfi7291d10t2bme00', '41101471466544183228950720', 31);
    t('6', '6', 12);
    t('f8b5889f095d', '1800044447610490', 19);
    t('62373d', '8703010', 17);
    t('10fdb7f', '17816447', 16);
    t('15073c8576a045', '420372672828997', 13);
    t('7f', '260', 35);
    t('1333433', '27368', 5);
    t('2244130132243425132044145124224415024451554010223151134204', '557550459764737171250298964345492919336144380', 6);
    t('8d68f68g2h8b9n7hdf', '4965201398478292577464090', 25);
    t('354313665111045406', '885233290237456', 7);
    t('d0jb1kf9idebf73gi0f61ek47563dkbdhkc', '11772703237518049717164718112135708535788508390', 21);
    t('1g0fw', '1761440', 33);
    t('1111101001110000110010000000001001000111100111000100101111101110001100001000100001010001010011101000111101000100000100110001010111110000001011010011011', '2792505467580338130476655688091490969863067291', 2);
    t('4kem1b33od5mfgmg', '109359135408139845817891', 31);
    t('252401220241235031123451', '2296208767961087095', 6);
    t('610k89dn', '63160332926', 27);
    t('16agb99g4d805j75831909a4ggd218b5ij6ci5', '1823913478028636622491544197209852539611260693165', 20);
    t('261a033075aaa9629248385a388', '3052545960208975734532191842', 11);
    t('t7a1tf2e7tgnb8imbdeedmtigi9gso', '39644969218663723727102891143612359344002477896', 36);
    t('7dl', '4023', 23);
    t('25533oih57blao7g4pkl08bn13ol8piaa4kg', '73530387775765582430116303708968126882088830298200', 26);
    t('519deeadj7la6fh80do', '148946600253514084380503194', 26);
    t('4pcj', '97300', 27);
    t('1ge2d9amf61k4l9e', '459233734124780611459', 23);
    t('1052fmo6cnm59p37149o3l597k13', '161266754400204723877757541169558797813', 26);
    t('2de4638', '33376778', 15);
    t('210010202222212210201102001021122', '4352520348668609', 3);
    t('5d24fc', '14090127', 19);
    t('18d260c9d8f110eea9d29', '1875481379014053338979625', 16);
    t('5joajar33labh4', '58322924858252306043', 29);
    t('4iaqqiwyaom1ce66e', '22936244757184115769387199', 35);
    t('69rr344rlel67mi7nflp87pmhgrp03', '43449918504438809554215800177138569914811503', 30);
    t('6dc6205912265fe68cb44ae5c', '543574178265693146271925448284', 16);
    t('43d54494ad5b05321084667b75d163d973a9d5a', '152956351019871496094981073356920240750506556', 14);
    t('ah12a9bhec53547ch1gffbd4ce', '1014336400315441401789662738444945', 19);
    t('2bd', '2699', 34);
    t('3aec56e9h2g', '12856803598240', 18);
    t('rq9uu', '25719242', 31);
    t('d4n0x51toa6qdt318fp', '81581464565230142757839048850', 35);
    t('jadsk62rh6ij31eo1ch3o0bhmhgj9jtnc4', '107561372102244760144971481381587972564573705894064', 30);
    t('2043276441110982538543', '2043276441110982538543', 10);
    t('20201210311332011322', '585807421818', 4);
    t('727kcili23kg3l5i828m7cf0lf', '78445700911564313828749219623193471', 23);
    t('36009102725393959984512648753051', '36009102725393959984512648753051', 10);
    t('8ukdkn', '349394354', 33);
    t('5ki8ke06mag1alck15hdfcbec6h3cga1e', '11023064368084528790974090237767391150220405232', 26);
    t('3000113322000200111111113300212023213010111013202003200322021133133330031120110302003011', '71975485293215942293184497039364273438587712328376517', 4);
    t('5a1a7b653b1a8a3171138a68', '38731186957000914147920624', 12);
    t('12112311232132232202132212302112123231131121', '122959685741398740635146073', 4);
    t('224224200440342044342040012141212202224032', '117352577650533752666371914267', 5);
    t('gslgybo3qge', '46391977465963549', 35);
    t('2uboe91cml1u7nj0', '69926702089025500890856', 31);
    t('1b12egkmfpk6ek4ci', '62129465622057070801946', 26);
    t('nnhs6', '31660330', 34);
    t('67pqqk6c0547', '52109078987080647', 28);
    t('1d1w7qp5k49pkew524aqk', '10447930959289958589155414670305', 35);
    t('9alklpr1npcnqi', '61021505045351897946', 28);
    t('a34jlmfhgco1mhe7i464e0a13p2fohm3g', '64375134650196903816516350557832247480646609606', 27);
    t('4abw', '155033', 33);
    t('2142033204210223322323142100114402142302', '4324065003615716467353162202', 5);
    t('60532043272968a94888952a68053751a363283518447b7', '264927210929454220225095471298215643100178078897019', 12);
    t('blqachpkchipk', '1773214262533625366', 27);
    t('6a8', '4992', 28);
    t('pcgo435a8', '7192807940789', 27);
    t('qp0pr0mqbbjk7d', '174868044459225160273', 28);
    t('5828156996331', '5828156996331', 10);
    t('26fkfcd083b8lpgch1b', '66450659287855347635773641', 26);
    t('8mmf63f0ia1ah5kdbjh99e9h9c977', '1209459278082656851165067356679983218550', 23);
    t('52i148', '104410274', 29);
    t('qk0tfb59r2qbln6o2sp8ugfboi31bt', '473285949705108395655138274449579397276795076', 31);
    t('205532300043402003003254103', '369253734666995461719', 6);
    t('879ab0', '235775925', 31);
    t('241624188370143088778102727584606422', '6171271817077031180028886241834420', 9);
    t('3255046123035', '47096682099', 7);
    t('1i0c4vdgr', '2174016088986', 33);
    t('146jkgfke909glk3ob6mdm58f8ilho', '40622675473823760328962580924562649904199', 25);
    t('jj8y8', '32810768', 36);
    t('1e4hkj6aa05cxq7m', '132784276644103297330004', 34);
    t('978564821b048', '223388964080485', 13);
    t('2436', '1310', 8);
    t('hhfmf3j0f5i', '736122101988364', 23);
    t('17267', '17267', 10);
    t('4664330262460243362665332443326246035423001202', '534251783398075165083933973334281628283', 7);
    t('b38gklnok0110c17n8mhoo010o5ag57j', '241427482360734538990839716374778906058847069', 25);
    t('f3e7pulssj', '916859590578979', 34);
    t('27d7555288d30272d', '5595200654400679125', 14);
    t('819q61r30e', '282911846534158', 32);
    t('480c9b46b994a5ba', '236539854099919419', 13);
    t('fwprhkg', '20654989624', 33);
    t('qpvqsoagbcxe1m9p4njcr3s1u5o8rilv', '8005304852449403198353189427839491405562792406601', 34);
    t('3otz8vcq51hb4x2049', '1057170856381011920131894809', 36);
    t('5c0d3086', '991652751', 15);
    t('77he9mc', '1399298652', 24);
    t('235325244120503340533314220240120541543313532314023214045251354045', '1009019759786137757734399255898805702011348236556717', 6);
    t('pen16ld2', '267263406983', 27);
    t('38da605fff560480g774a571914821fg4ce1b', '695692475188289760917741559372738544759806604', 17);
    t('2as88bci0t3u4peh32h43sbiol8msq', '41775863368398953273228305076503096642379144', 31);
    t('434b69658123b20626071b159419805b829bb', '3036841224924436585369140335673525677855', 12);
    t('1639ce13gg5jn8n799h2egb', '7079325759472298465468600431036', 25);
    t('223462807300306567156031813152503638585503736', '2197225859272539628269139500011586036340695', 9);
    t('103e8i5je409cfjij2gjj2', '5891431329615183110981153276', 21);
    t('27ehfd3mm1amb2', '2031041578695417482', 24);
    t('294a9a0194301a1347905a9a23', '309810801471710455254108235', 11);
    t('13410234243444343010', '33738914059130', 5);
    t('m96d02hpr8iq', '802992036207501914', 32);
    t('122101003320023331230132013130330312331033133310', '32516440874028879538684229620', 4);
    t('72gd3be26bald2', '6233639407268330618', 24);
    t('2d544bi4di8iee4bif6626hc7gbh6e6cig4dif81db', '72451765332560287083369602461296345124271516517829805', 19);
    t('3eg4d95c4af8g6901ee4h5ai', '975073009049557106375679720761', 19);
    t('382658c9903142c73aca3ab7cb65a9b03d1', '3332092804303405540969753019109086440851', 14);
    t('jmt3oqow11l3pmdn80', '1285457439759406193536144680', 33);
    t('224qna7', '1001249039', 28);
    t('436m9407fh314jmifj3i1deeg69m5nad', '971010955553278162770513965655919904558476747', 27);
    t('2satkskboq0b52lhqkmi4c5esc2l3', '673846076795500227422362618917964848206433', 30);
    t('1111101100001101110000001101101111010010011111111101100000010111010101110110101100110010110010101000010100000010011110100100100111101010011', '683433243524982240677777243476582452055891', 2);
    t('2914ian070b8148i4gj', '16589998566194339193968275', 24);
    t('3a749k6112hhak447jj781mmeac', '876069885826400018389776921704533226', 23);
    t('255872662234441388265248510244', '12384677052693094655070972427', 9);
    t('560090c1c7219aac49bc98723', '17449270853995006816160134795', 14);
    t('331hkjh2h222gd8j7f87053h0ekkg', '33116649224902344081270523395559561873', 21);
    t('19d6ad933a8e5', '454557212846309', 16);
    t('15576357436114241002422756773501074050', '4461159021738482150619844582864936', 8);
    t('4ctu84vr3pf0r07ccpln', '1617599669168190267768549135515', 36);
    t('45', '33', 7);
    t('trcrs9kqi8j1indmkpce9nhggn966', '17122684227038407228619197596494484876338236', 31);
    t('2buoook3nvs3kx7rsaxm5r4t0', '52296535133778210239758710339648429588', 36);
    t('14226054c26c7552445020a886b7760b5b5135', '217115666892653625414446286763519219185314', 13);
    t('204100', '6775', 5);
    t('25163361', '5564145', 8);
    t('3a7i5', '3481157', 32);
    t('409cddb354a247c953ba', '89645162802357578226475', 15);
    t('82701069295659144047712581742043369852863', '82701069295659144047712581742043369852863', 10);
    t('1m1cdch85eede', '42940540919670056', 23);
    t('8510a148870865416551266375119a8744402a37237554973a33', '1092891470413014298604369531468860344380942265185284043', 11);
    t('2o8q93w6wqfxlcyj', '591019503162075661873627', 36);
    t('1010101110101110001000111100111001110011001010011111001111101100', '12370864596035695596', 2);
    t('11000111110001100111001010011110011010110101010010111100011010111100101101101101101010', '60378345252763661786864490', 2);
    t('103334131441234433031414320224222030200141024110030322323443121443', '3117589328891536907605724784500236990408176498', 5);
    t('3osq24ebjht8b4ofmqo4h3rihibobeebp0n', '639082398725178107711437881596434023161974350859523', 30);
    t('4hwpetajtnef42hf6i7gk4ft1c56284h0', '284870293967456034800024507342384514579618737697444', 36);
    t('47nk79pdq08jkr03j68h48j14fhob24jnl', '7753840463194256229084069256136460485337725952889', 29);
    t('3e1ddad6b81e605', '279748388776437253', 16);
    t('14213123322410322220113041', '564245997485316646', 5);
    t('10101100111000000110001100101100001101101011010000111101100001111110100100011001000001010110001001110011111111101111111000000000000010000110110100111011100010001000100', '126329653589454952926638707222811823179996994585668', 2);
    t('1121013121130033133101030331223301230313330233123323132', '451869705599733348535930921533150', 4);
    t('2832526509886158185210a67196980527236826366270922', '267178313423247125602360439007441778151867246111079', 11);
    t('301112020122222002200213300023011011021302010030010310320221102023120230', '17194503433563229118380499993437205254682156', 4);
    t('69282098413186766083358437581101', '69282098413186766083358437581101', 10);
    t('4415457670585382436475220327776155226816666075213', '28405304143473153865445009451075313957752794595', 9);
    t('u55k6lj5rgfl57wgi31hvuqn4tf6hb1b4', '117985718169999606760995918723069839695453898058769', 33);
    t('b7x2jn', '589663013', 35);
    t('10126', '6666', 9);
    t('b5879a2a1b80a2901235433a292338bb37', '4707604586763280840085306433760750747', 12);
    t('n8jcfhcgkd97m599hckkej75midmgd696di93', '4944810674354559044783104703290657564535755949823978', 25);
    t('3m', '91', 23);
    t('2223210010100034424104121024440210422141112', '570144644155456680754503708907', 5);
    t('13124122112412134233312432', '495575953944432242', 5);
    t('e073b0188f2d6667b75f11f65a82fda', '18646734802776877837813543784990388186', 16);
    t('mbtf7g37f4vmntj5ucgkv14ibgs52c', '2434353097193477091898655577704481736864297392', 33);
    t('15d694d721', '29460575985', 14);
    t('260163345975', '9836790910595', 14);
    t('6uljaaspif4qcgv0w3r4s1d49i4gstwe', '821480362679083726187114504615763265574310553397', 33);
    t('5gab21g70h002da99d2c84b5h', '7924712928864678423214354832759', 18);
    t('39a6485c82b213cc4bc44409a44bb599a470a67a3a76b2', '503487028064289493492980947734948505492983138659732', 13);
    t('20002201222000101110020000222120101200112221201021100001111111002', '6983493499156781197462869089813', 3);
    t('10002412413200341022442444310143', '4677943423343013666298', 5);
    t('111001000110000010011110111001000111011101011111100111110111111101100100110010001000011001100001000111010000010010110010110100111101000011110000111', '159155836031631574967766651303670498797193095', 2);
    t('81f531048349c33f91627d55e1b6bdd8a78', '707557451293532648521737780488438655322744', 16);
    t('3lielemoqkwe6hy7x49h7e2wa1xx537h', '2655961913531425670206416089623348076947591148312', 35);
    t('563305225055677232242325342', '1753817655195311740136162', 8);
    t('7212497884a67328a', '330466724397412118', 11);
    t('0', '0', 25);
    t('32012123102210300020113012111210131102113212120100320013103', '292854113268474190487876694062629331', 4);
    t('56005640531166633533552031326403615010402', '37307044943970381141955666758261394', 7);
    t('11000110000110100101011010000011010110100101011000011101010000011010110001010100011110011100010100111111010110000101110110110110100000', '16852729444979725339524623444714796314016', 2);
    t('789g13febje5iejfa1ig8jf8c2aca4e83g', '63776033229698957310821624134744128800755276', 20);
    t('9i15l0njmgm82jkd85m9nklm7fb17pql', '59304813258620243353054039369424204841493322301', 30);
    t('13e4770aa6479a189h4ijhe7h', '19890160409189373966588476781757', 20);
    t('391', '1021', 17);
    t('2fu0b0cwrqnhk3g2', '148774633410591042263180', 33);
    t('5bga0ahccc26ha', '117904089797019172', 18);
    t('4aa8130208329129a05788a58233099034432a05816279a53258', '645369877978597708954154480649585042163183610604351956', 11);
    t('2422033234133422320321444021300', '2698216128927171860825', 5);
    t('4tpp5vh5bt6hek4g', '457274415287522823498216', 34);
    t('k17w5vb34d3138wefz5fattm5dg8j5', '27198023106008199799064230217875560645484318769', 36);
    t('2102013312101313322013123023202313023333130222031133013220323102212033032102100', '208553181918156893475157564867315522998449792144', 4);
    t('51332502222305150244505511341050032244223', '70394344811157929465865596540343', 6);
    t('12412251054223304020131354003520010333204354435', '904941860581497811835960794805811575', 6);
    t('3479681145ba9586574471', '16462881831354787246025131', 15);
    t('4ja2ighlhlc1', '2854140987850373', 22);
    t('2202221002000121120210101202121020220112100111202222000100000100011222111101', '1688023704896041845224562059363977918', 3);
    t('210000122110212221020111022121011222120000002200', '62111394465978849346782', 3);
    t('6pimx7e60eft5feqa8u4b4bw90', '1307284040175844778008871938774231576106', 34);
    t('1i16rl7r4oam1b5tean7rcu95tlt', '154612291629528044654847293969784668743598', 33);
    t('15110303', '7506030', 9);
    t('2016414121621263631244402455154', '45972634857804622561848566', 7);
    t('44432212443', '289844523', 6);
    t('58a4100974641092373572734330a556a85a3649335a64760887', '750631221647335681998791040547190909433022379938062625', 11);
    t('743b060c9e1ec97aaccb57a0b82b7273', '20948613103678762990462558732773459183', 15);
    t('1ajb3mdkf30l3ggp6n1a1', '59220428702663606276074957201', 27);
    t('19cg5o96p252mmgrrjrl4ilod', '165904775415412969849796184365702337', 29);
    t('3g74s6dirr87mm9foqlo7bfi582', '374825061004185779220292067103421684849', 29);
    t('a6giogfn4fh', '3031737957822773', 28);
    t('78b8be03f14', '8295928577812', 16);
    t('26n4banle87jn35feal1m6', '220963128547176781029291070038', 24);
    t('3h85d6b45gb6109f41d1728k9caacm7b1aji', '1718109577201049817604488911453241934701038840497', 23);
    t('bd09e98b82e633', '116544317962963279', 17);
    t('2110441420453022322540033154112020554313145001155131552512040', '107428364649645482426810419589588006553616123320', 6);
    t('6d01menkb1m6op', '16127757406621275713', 26);
    t('1730611463642631260026156435013323236764317226', '83774860480485487711819613225974439714454', 8);
    t('2100667557474081635521', '231108395393156176477', 9);
    t('eajmn8hsd1pjfm', '350223684312837767216', 31);
    t('c', '12', 35);
    t('3hh6bccn4457ag7adn', '1087094043870481997468111', 24);
    t('2cmfuigao1lx7crntyo1ugf9i8lfn4xintk', '74377881431362654774128391002848996423791130882315335', 35);
    t('ky425gzem0n0ly4at', '166714666329050622675578693', 36);
    t('1sg1pw6tb7354mkeo50qw9hw2kampcodl', '18686700577780102002056839220792859826440700702559', 34);
    t('3zk6unwmvk1cbbvs88gq87ir7zajx737', '7016346383200454479387022948900734227527567863075', 36);
    t('10322140422033432323113304140103031433203324313120022144', '316354577067079212853499387473063048424', 5);
    t('1aedc38e246a0a149337e0c21ce94312ab2a731', '851651713725780036567549303250491168513333496', 15);
    t('g28dhe5ec7gca2da009c0676b', '79014378046420572184971870226746', 19);
    t('sb63me5fg1ia384si46ls96olgbri43dbmh6', '141956865342110649337804593119630908073755164359747316', 30);
    t('2e0b0c44dbc73ff4e6cg89g20a', '16306506209387027589159612217900', 17);
    t('12dci8290ifa027fb7ejd6gh0195hga', '1217746749869313260112097211823364687130', 20);
    t('100593ba5a865981d02bdbc05ebcd1d0eeaca4bc4', '110757343351711672327388218706433958588903853659', 15);
    t('27519372626617950348722900682739422090', '27519372626617950348722900682739422090', 10);
    t('3uupshi4aagt21d7itr5', '157172315431494653918152587109', 32);
    t('2ep4', '50251', 27);
    t('m9h3', '664581', 31);
    t('110100000100110000001100110011111010100011011111011101010011110100011001010101001001100111', '1007262826627701209829823079', 2);
    t('4fdcaeffedcef169c7g9efdea3', '117447089342770251162409579295367', 18);
    t('6fh5eab56am5f61bl48l7c9b8me6icae840i2g92', '855997003648548335026652493309865049009850682381985715', 23);
    t('7c0n5d8jn3lpa8hp99', '8461593530418792315440287', 26);
    t('1tu322cusnnvoic90utms2kb8kpsffaopr', '90526131960565018083687339860055870929107749790523', 32);
    t('110122010001', '248671', 3);
    t('3fhh08ego0g82aj5dnk2q2kbn7idq3pm6', '22776756121219843287237037542642788102057852286', 27);
    t('17bj8da6fm3f', '1264125153712738', 23);
    t('f7543ch846', '7865867659286', 20);
    t('2ag041225dg8e40b86f5d563065721a22e80', '224048255295439918093318523708092978352301432', 18);
    t('152dgc8jh390j5b495gc', '6588878765500952675914332', 20);
    t('noi', '18722', 28);
    t('odb2603j2', '26846840229474', 32);
    t('1062em', '9860997', 25);
    t('24676', '16593', 9);
    t('1255403606425333320235315622513526506526044146610025', '17675708274550040406518050433158199000096421', 7);
    t('mc8cnmgceje46l2740j8ip1omjdk77o3', '5291886225857373516516815562816611072132097222', 27);
    t('143141023331223043333', '184512629893593', 5);
    t('1d1o6ko66e4ao2868mnibkee4dn2jf157c', '20642579270952330510501003581022184589302753312', 25);
    t('28advfy', '4112308409', 35);
    t('570310266815233921772669264379360250406802529', '570310266815233921772669264379360250406802529', 10);
    t('3m8k49hbc2', '14854779179052', 25);
    t('112265015661422606235430001553122514516430634002244346', '735500185117893335759658114968030927435658591', 7);
    t('1bx', '1563', 34);
    t('154198526b2676bb06962353abb66578266264812615421', '63438474644380821718834297112295766181334517357849', 12);
    t('1100210202021100110022010112', '10394984607800', 3);
    t('705373640815a38b6625734317272751745938838b66957931', '533650458267011464715178902445187808113331072099472757', 12);
    t('5mu0', '242375', 35);
    t('f412647bb', '106305216589', 17);
    t('8', '8', 16);
    t('rm9hate55nk5xr', '4711198898839826781711', 36);
    t('td0hcbh0ndskf9md', '422345416603914184013773', 30);
    t('343702712358238358', '58222225743441794', 9);
    t('6bee0', '1820611', 23);
    t('232530', '41769', 7);
    t('540444340443225024252235511251333122111303332222444045405203402', '10009287342414262691465339202517966834792921923866', 6);
    t('60535639204665261809056323', '60535639204665261809056323', 10);
    t('498g0', '1708525', 25);
    t('19j25i98e1ihd07224ka82eg', '78254066225000382046873246127584', 24);
    t('330330100323133221011332232003003211033310230111011301111102233112323133133132', '86978805378934327315465572304260470254359934942', 4);
    t('e32gfkiacklp3qeb8dahd973n', '317981536760764840843373569644467543', 27);
    t('1ibs79baql74', '19946951806298397', 29);
    t('gc2bafd1bfcfg8f8e6797cd872g40bbca786d', '3305765433031391380598054150042785559743311339', 17);
    t('jablfdo', '14103490914', 30);
    t('5dce26263c419372a4ebb00d424ba', '5048759171413629413482567787816575', 15);
    t('9pj1utgw6indocmuk3', '638053591604508936554605548', 33);
    t('39mm42fghqmj6rai4ms44a8jmaes', '10189567831237705666598526955508127749423', 29);
    t('e2c9ij3dl7d3idek5hamdke4b64bh', '1896357467030637609113345980127736335781', 23);
    t('s4n5pasy6ew75l2a1t', '4993163715460998736843408064', 35);
    t('658334577577241364255153', '5841024053232128589867558', 11);
    t('1404132402322011330243102041021123140304', '3337373674316685552024036954', 5);
    t('3lm', '3352', 30);
    t('18h9i9figeb0d243b8e097309b75fg8a0id', '44138855572089599578572255789371956709642686', 19);
    t('2241012304021323300241123210431301', '299011414865892653217701', 5);
    t('12022120121120000011112110210122210222102001000', '15710188707765121460544', 3);
    t('4e7kf6ccdp4il17', '495576709967367899179', 27);
    t('35i4', '50454', 25);
    t('hi1d7dg97k5b0ailflh1gagbfakjhf33f36kf8', '832882004590031466088018493593950259022003331850434', 22);
    t('6821545810481312184878830548787014204', '155801745935514050378370617627291164', 9);
    t('10300033231231031023033122220332', '5480800290149870142', 4);
    t('1011010110011101110010000110111110100010011000001', '399378554504385', 2);
    t('efc1ltd227dle8flfrqcwtcvkvs', '43822708871975185309034493996620102899735', 33);
    t('12832300405', '12832300405', 10);
    t('650595570247321885101265507780200498020021110989312', '650595570247321885101265507780200498020021110989312', 10);
    t('3124144616475210442326726176753', '3917395568817125518374141419', 8);
    t('19b1kgb252i8d05fdi2', '917130084420731730796550', 21);
    t('10110001001001000101010101010000101101000110100110000110001000001000010110100111000110101000010010100111010100011000100011101100111001110001010100000', '493799621713705665209661337050845053741490848', 2);
    t('65ajh2mc90inhcmd846g8i5ac3l3inc', '1587173922359823128666098525120017654586548', 24);
    t('keoej5b6', '125728425281', 25);
    t('7aqjhe8ne805qgosdh01fosn193nege651', '13396367124183589399343540124147227754242301295318', 29);
    t('200111111010212211010011210012210021121011120111200101001110011111110210220001111220201210122221011011112', '85808090717084077750326522417981797898295448342990', 3);
    t('28f06cc7ea7a819gf781e895a2b', '1080002582657621357238123894492239', 18);
    t('13da1526049c632g88525c75dgfg2dcfab7c2f5', '69930158209361480953961939859540779534596389301', 17);
    t('e9e51rloqsmtrleng4s7pq0jarfl', '109166094703871534700120128616442419684771', 30);
    t('34216063', '2979343', 7);
    t('6c063c35cb81dadc43adb1', '8034831935878348183255023', 14);
    t('989164hdf9b51geg8624chhc7g47h5377ab71', '14664682513456963530829234223873975820816166603', 18);
    t('145241986', '145241986', 10);
    t('122551245377370372510600247650271544', '52420971115555265131642802500452', 8);
    t('bba7aa6155a3014', '46889782002517822', 13);
    t('3deb3tkkhlamh89ljpprd2', '36080909083483453648852421649692', 30);
    t('4120104313404000512310', '92641744056051474', 6);
    t('4fg', '2477', 23);
    t('1eghg93c74j179gg56dd045id2ii86i', '1870702929919246989271587432599881427338', 20);
    t('51123225122335422566204631400', '2378354862895607406604402', 7);
    t('13577', '13577', 10);
    t('5kjbqd5ilhk6rsthb7aok056d3rm', '104710675709925942718275325006590464848210', 31);
    t('1l', '47', 26);
    t('g996104g1ef15e13cg4', '232909810115697952226467', 17);
    t('5dpcd6micqpf7c3rf', '2351027610634734415497525', 30);
    t('1q3r03saf7da72ogme3qsgol0ka', '1098670850837387299606462566653196917356', 31);
    t('6mabf7a4mdjk56265l8kka7i2j46', '40764485063999108303947012898651625672', 23);
    t('711265667352525777055750103304054072', '289883291844318827546712512419898', 8);
    t('181ah327cbh09bbdbi05gihdja3a6766cf1c89', '1929446677883376438181941961611633360059304812969', 20);
    t('683ao9qhn91f6ifj5ggnm48i20diinqama9', '330737041385586113625862339185409951588553481122988', 29);
    t('4z82fjb9rvrg0sfjrxoz330j2j4wym', '6758750673748428599831923455366157745143999198', 36);
    t('19218eb109', '1706298801557', 22);
    t('1xteget9vm7rmvt1qeleb', '8506448668267622326601389463723', 34);
    t('3i33kbg9cqg54jm2dfa', '213466100023939044330506035', 27);
    t('215h8f51db257ael57', '289767309771867327604947', 23);
    t('10110101110101110100000111010001011000111011010000101001110101111110110001011000000', '6869753008454091059192512', 2);
    t('58e', '3602', 26);
    t('659874ecb742089cd0f2fc72a2e912d48334f2d', '36250497918673919606249316600592246963107483437', 16);
    t('fecne', '6086214', 25);
    t('5kbn62hdf7wmwhk67dqk', '701711736487352936694557071892', 34);
    t('193418768773292279686a8766bb', '2041543002021168521235526438842', 13);
    t('b5f7p0qqnmk2h8qfjhgmb', '475042274550491463639138392813', 27);
    t('1okma06a16bp4ingkgf7o', '38938334164376358043955589354', 26);
    t('km3', '11089', 23);
    t('201', '51', 5);
    t('2e4yc5cjy2hj9jy', '9951741372023452880724', 35);
    t('13001304414442041212340', '3820949701507220', 5);
    t('2ie2bm03mioejrh1nd8ihi53hjj3bac', '196391064504813821616820420047441343526039222', 29);
    t('38a179006b409b755426146692007b083661', '220736472532747947341118345018618875881', 12);
    t('52eofqqb0rg4dijj7oir56gr', '9803633243543859078443703279727611', 28);
    t('10542528849006a4209977a245a6670844a65893a8', '5200046241474102735966912429570012726348257', 11);
    t('301222300033320033', '53330640399', 4);
    t('14k461i83b0kc', '71064921466188012', 25);
    t('11101001010111011000000010011000001110011111110011111000110011110011001111011111101111000100010110001110100101', '1183302363719122225851040665789349', 2);
    t('6aim7vpcb6nw0rtr9x74xowefjtnonisji8', '198480536455893007753383205691175236273156270478363788', 35);
    t('44957146989902980426789317', '44957146989902980426789317', 10);
    t('110205b4b61454d4b3b7803c', '246154487751049576297182022', 14);
    t('14ogjsp73do5', '14239859065452217', 29);
    t('1bd0nkar7jlf3bdp1', '349044193281529358817564', 29);
    t('5eo6ed6nmmcoc6qdh', '442845139356014267015909', 27);
    t('311000312203102002211302220033201323322001122212020301110332333131233222302032', '75663136060016606687972617399235327868190764174', 4);
    t('e0ji5u', '401391626', 31);
    t('1424357303022501420341156201', '3723432687881212284689537', 8);
    t('1ot26r1r25y6jshe21wni', '13008118169902415707339281796648', 35);
    t('1i2', '1685', 33);
    t('2fjhc5hif69dg6605d171eb7cjc7k729', '1122293919180819662380020426292955339311361', 22);
    t('386587ngd3dnln', '33687830964706424608', 29);
    t('6535', '4811', 9);
    t('595b11426b9c0704b17689d3b6', '255251373547377701279623680212', 14);
    t('6237m485ddjcnieokb4nc7oij2fbao558l', '82471258057252969989346717428147198122909847096', 25);
    t('43440d004a624a9aa5215926d127d0cd34000071555', '5812346158873879973339574652454563446486067283271', 14);
    t('3ml01ehme4niee4', '83156933475485244628', 24);
    t('3dd0foql9qr434', '22633155441925307864', 28);
    t('100011010000101111111110101011111111100111011111111000011101110010100000110001111000111100010111011110000101010100000101011100', '46870857086354303302378526158318027100', 2);
    t('5dd677042ad15hda283e0e3h0ci920c91', '475991049360626890704302602104214715388328', 19);
    t('2484222523', '987550482', 9);
    t('1o54o241he2d16m6fa2pl4n3c65gi4', '208907464043630568560284375825261087372160', 26);
    t('1014120211123113242013134132412222314312433034232212101102023124331133233', '227485273039510873413178482785035220246188554161693', 5);
    t('dm5lgtvb1p', '481781008542777', 32);
    t('8gq1c', '6070379', 29);
    t('2cj7llc4eg8f4k0higp57i4kgce48k3n5a6a', '83230479743519414484378889869266300543737457886886', 26);
    t('20', '36', 18);
    t('ext2p1il80v9lpv9ebwfhw3pufedgesl0k', '5185280930874834437412210154592858661728459849547240', 34);
    t('268732c65576481b112', '282507652502544897001', 13);
    t('2b38484aa35e0d64507ca723c15933b9b43', '26686868200702243883872800111367217352288', 15);
    t('43e48jkmxot2oy2fo017sfk72hnevbl1oo', '3687542753129712107602138468735370587663145861696839', 35);
    t('ojudi704tha6', '626181160658812467', 31);
    t('j5', '385', 20);
    t('103533241255410240323255355232043144540505', '88966569636637417158897456537305', 6);
    t('q0l7j2j7r0p6ae1baf6s', '563916309957339378866464786934', 31);
    t('5a7c53b2', '364964095', 13);
    t('1fjne9il8lkg3bh', '103626865036283572091', 26);
    t('30d7de9e033c54b451c6d3b51ec197329a6e0542', '22557901127642576391477860038224820219603000562', 15);
    t('20360161522501151310214311356463136125245245560521232311426', '21552877623292541132456573250632857116774507721475', 7);
    t('512350542042531015303442430241435053151310231500225235203315045314', '1991453522210060656872676051735126305923083736859310', 6);
    t('21121310020023020001103220', '2646808142550248', 4);
    t('9gf55f6rj8pd80r431be60rolg54oeqe', '20665197735276350815418661624870881870158116448', 29);
    t('6di7fnk1ka03ho5bmc43kld2de9', '106858530460627601101778247911433225126', 27);
    t('14d26a4b3a267', '8975609863073539', 21);
    t('28e98e7jc72', '98390517534444', 23);
    t('95', '158', 17);
    t('148b9f744h78h2b8h99b', '884510597649896304807737', 18);
    t('1136025406614a982932a2414233036646a259314a9690', '81653801636548512093768636534022656649699507364', 11);
    t('18b51h64hd398a', '30802810305582406', 18);
    t('1043243232004324343', '4534554761223', 5);
    t('5k6khbk8qmq1bd2nr5j7162d3dhmogs76pa', '2874134176824005398775676217605241490607568199781842', 31);
    t('e5b9vh77mseismvci6a', '30505084481497262094146130166', 33);
    t('544622661023252114032553653430635012455640216226', '29737930867189529595998234535940410116741', 7);
    t('c5g4m06c48d4530a409d4', '49190458509627322489392813436', 24);
    t('2jb0b2bnji', '10595811514868', 25);
    t('1001011100111010011100011010100000000100011101001101110110110010110100011001101000011110010000101110110101111110000000111100000101110100010100110100110001000000010110100011', '3536326453156193038031587123790239903142359400187299', 2);
    t('52bf9ld84dbblg', '1446598246008687106', 22);
    t('d3c5daj8ae7il', '169193485055337357', 22);
    t('101010100101101101010110000001111101000100001110000011010001', '767218737556283601', 2);
    t('1437', '16207', 24);
    t('114133340123233432103120012420300414231232242043303433332031141324311011321', '7273916554967523346010893023640093442791484794235211', 5);
    t('cdemrp1q1dfo5oaa9o552', '29104534648610198033358963191135', 33);
    t('hn4i0bh3lnh22dbpiie6nbnh', '34333773871855985124318946939651717', 28);
    t('10110110001111010100100101100010111000001010000111100100011110001011101000101100111001111011100111001111', '14438492881715694934558943721935', 2);
    t('588', '3333', 25);
    t('51adke15g1', '6117745845773', 22);
    t('v1cb8mieshuc6gua3nbswk', '2402909063962783729496267888203295', 33);
    t('154ad6bida8ch6350198e231f0i5hi7f94', '2016744827456637173074923253636234179984684', 19);
    t('4041103013000012302004', '1988313720822129', 5);
    t('343231343104143200023110332242214210120241412004213422100041430211002422', '166923575124772514544128066112153498600774395406612', 5);
    t('b8nkae4j', '52169931763', 24);
    t('102400633554632', '713852464334', 7);
    t('15230012004363225000152043112', '811351549236281156826172', 7);
    t('32221779b4b37b37513082406424450aa579a2a8834a', '80810046681505916793845914766512942540525426666', 12);
    t('2kmcp3r6qs1g5p245fqb0g8qa', '340045012651728420163296954517156597', 29);
    t('11110110001010000001011100110100101010001101010100100101000010101010001111101101110101100110100000111100101011001000010000000001101111', '20940687968317900181954981756671243649135', 2);
    t('10b9821c0db4bcb045262d98b761d2117a', '70367656624653783927494922061307165096', 14);
    t('231032232010133020300013323031302133220331310111301123312001312131321103331330', '64554409692052210685332500753625976302230388604', 4);
    t('1dk701j6d4baf96bf4iib1', '25341540144182484368121637707', 22);
    t('4edea9ba4', '12802842379', 15);
    t('ciffbbda77', '4192099035923', 19);
    t('3bcb854a520', '1113967604288', 14);
    t('1768433009ba79273507849b37b1949a0aa91', '1155230524818144260160287806949250060685', 12);
    t('21', '7', 3);
    t('12', '15', 13);
    t('a3dd53124a00bbc3a902c2b7c02', '6479682616939747273872424224938', 14);
    t('1rn0d8s4ror38g0bsimk', '11952637171366777777073055104', 29);
    t('2eg5ag969k30e', '34322046314733994', 22);
    t('df6i05bcl', '2837296447201', 26);
    t('d6hbff561gk039bm', '67475093532951335800346', 28);
    t('736135d12de0dc5197046', '2403172999591697203426191', 15);
    t('1917700k7b0798hlh7fj1a3l158il8c9k78fgkki', '31935326566626088190275112296683968556264917574568138', 22);
    t('110442', '19434', 7);
    t('a4f9451ce43j', '2096875845233679', 20);
    t('10pc0lrrod1ng7813ho6f1735ni4856nk9og13', '362001328932031510264970316722642804830244524894241823', 28);
    t('340', '95', 5);
    t('2', '2', 12);
    t('2u715wji0ksv', '276409078243593011', 35);
    t('p538go6b3sgsk2q05dh8499n5lg3', '76866731395524797035264473788165190998742', 29);
    t('10210322121301121330021', '20128796614409', 4);
    t('czprbjnb6c5va57wfojodh2s1b2phqt', '634971610203428324104731270997646500012871287829', 36);
    t('163351146232500134562615331', '18110985379078188834196', 7);
    t('6e4129jca7943b106ib8cfjb1421', '900619828463523710649738973182569641', 20);
    t('23230100001012100222023301223332133121311333112211232131113120312132203001122302001022200', '279953661912858509028227026934672011374168514476118688', 4);
    t('5jgr1tjenanafmgy02av80a4ju8nsh', '3332563710063599538714906051740573308676056547', 35);
    t('2a03a8a82cd13dc18b5', '12400430345351117674677', 16);
    t('11000001011111101100110101100110', '3246312806', 2);
    t('29a449404373294192348416192a795a064a9', '89775465256863804086218230386927370554', 11);
    t('68e76kcjm1afgdkmkm', '1848940629085999196683126', 24);
    t('2kbe3faaf7iegaa4e9b4f08a933fhciljk', '2501181635047310570015074845876633642933551437', 23);
    t('12344hbfe6', '359536823591', 19);
    t('143442112', '765282', 5);
    t('4a081317336a309149661ab942', '4615291648867282664377427330', 12);
    t('3jkk8128c64j9i', '1104902507111910404', 22);
    t('amo9tdefgwuecrqta7jpqfo6kg6jaw4', '223524633732333732706172640317287185870223150499', 35);
    t('21a58a0047a1884514880231963587a9aa5266571076574502', '2324252250359662008081886857169837234726499778719045', 11);
    t('2eg7g43878ag755id005efg87bhi1ihk0iggf9h', '474575893810580165151415734655919630427242773838537', 21);
    t('1253981930', '1253981930', 10);
    t('84f646c', '281267112', 18);
    t('699224148127737506438432736786719976879926194098083936', '699224148127737506438432736786719976879926194098083936', 10);
    t('130587969810795743976151248055472770225248488', '130587969810795743976151248055472770225248488', 10);
    t('7287697267041921400', '7287697267041921400', 10);
    t('12l', '749', 26);
    t('2blo1glbdeillcf0on2mk14h', '351738590084565988788756864375742', 25);
    t('49mfphl', '3828465983', 31);
    t('51147130442424172652616112', '194568628606971297864778', 8);
    t('602', '296', 7);
    t('g0fk7lla0ii5i7i2g288eegi2ke45nme', '347493304922004024159457621489970110001655564', 25);
    t('3427410030517411126776423004072314', '2247499600567123820908846806220', 8);
    t('11c0b422813e46a0704286bcc78e9ae64a4aac5', '550518894687870908612059469029958777652379310', 15);
    t('4mgrao8bnjmlfprj1g5k7o', '11809356002610908689865424701148', 28);
    t('16602427320624026652410144225431222411', '4788262207154170686928960302163209', 8);
    t('1133922820054976072a26336240128a97', '25979311751316593865740595613096134', 11);
    t('111130535130440515255305101002545525104205242311405241', '209770118829200105874769377203607523817689', 6);
    t('33410044421301', '4599998326', 5);
    t('g85cualojockutoj8l9i05fer', '10090207313826743038498352382093951180', 31);
    t('33ed24501e0ba9a810d3', '72404567612236270674198', 15);
    t('577nlao2jqemfps13laqti6av4o66', '7284410453812369054568448091009770033668294', 32);
    t('51380825345112415250165068281324', '1968364002188078831430803112511', 9);
    t('837101b3a0a907711987672759a2317b079', '40850603036144384752073171952853482909', 12);
    t('1irpsmnr2', '1070073795512', 30);
    t('bd7f3576f5875', '13588639558671227', 18);
    t('dd9h4', '7171636', 27);
    t('26w41a77diqu8', '5260279707492571244', 34);
    t('46144610334425521434631035561707752201423', '6346533567879985413095577825858618131', 8);
    t('5ba89cc62ab54', '137675765649465', 13);
    t('131534626543730752048834', '11992216206430875347086', 9);
    t('dl6dc8768f1ig42kh', '168255534771745044094577', 24);
    t('2eb9b59115mdikbhmc551dchgbf5', '143119111508435191417807312784059632255', 25);
    t('cssbedntprq7i', '21473268174365747109', 33);
    t('392s9qmrdqggnh7m1', '1421950054322530991895961', 30);
    t('3d235be4948269469821ee4ee8c659e073caa436488', '96444901326379451008420429583243171799035293288778', 15);
    t('c', '12', 18);
    t('161162230b89b81068276b63888013a3a715a35b2b47', '38295121533792138694595448876904917585402510055', 12);
    t('112012102101010200120', '5501676750', 3);
    t('ojk7jec5b56ijsr3fao8', '286565314487033509494400944728', 30);
    t('2a60j25ki993i6cc960ccadj92g11fgc5', '5095635099989024533935083494179547954150889', 21);
    t('nahoipcvslh8suq2qgtvitg4', '969084134162426052646973641814799876', 32);
    t('c7222hli0l3l6244945dcpqh', '10231322180811816357229624809826769', 27);
    t('3244223102234410102002134323340331322021444210142314143403233432', '389884100489780930202190481841298604587555492', 5);
    t('7327ef47l94j3e8', '2114488657647112742209', 29);
    t('cf9g1dahcdaf2026h91gh8c73d76g5ca54d', '61466270199599757540795294611578425158922457', 18);
    t('7f4h786d247ebca9', '52952122599419205189', 18);
    t('4302014423242240001311214131403014', '537446950702717645184759', 5);
    t('8ch8ff6ik', '325689693419', 21);
    t('50gg86980m5gom1qg', '2160248255368559193835696', 30);
    t('20122021021102112201221221211122110111121101202', '19615481787418378846121', 3);
    t('6214216998763', '6214216998763', 10);
    t('k5edi4w6y8rpf4jbd01k8i8na6v6k8db', '14807562688860562973809761754715067179928180924641', 35);
    t('g4h', '10937', 26);
    t('0', '0', 30);
    t('ac7a273b', '1851111506', 15);
    t('2200123440245032334125041530555505552', '24078438391794160644374978732', 6);
    t('1130215551', '157358953', 8);
    t('100144143000316540003233550024603', '1109765702355719674747590391', 7);
    t('30441204442400', '3899296600', 5);
    t('113695d064b657b6e38', '1599024751435436052203', 15);
    t('6dehkk21l55bjnoghjefaqsprdf59cj4fjdi', '9875112479907817915333605507323858110862750123273684', 29);
    t('141606qhkh847fg0', '5833789314492474260464', 28);
    t('2chgdbf1b3dg46dk4ebc70b0g9j3f8c8lh5aei', '120675412358469616349928651160190450670575079622934', 22);
    t('59agmj6uku8bv289o4d8koni8aqc3vqmc40', '165870499545712369328916058056499539367750790670918090', 35);
    t('2rbcn8lum', '6261797865422', 35);
    t('22m3v3fuu9emp5jna', '4116024592593979746814825', 33);
    t('366121646421620330410', '317849044022280631', 7);
    t('2116b48', '6253544', 12);
    t('25140718474428175265303486', '1847517948365808950428587', 9);
    t('4598i4c662g8ca070ijfd54cdb6', '28679737685086326785443322448741426', 20);
    t('1ao6m4o89llpgdc82kd9h9nrje9kph', '3527082557153952794613151020059372427454804', 29);
    t('32jnm0mmb3pssdd66an', '650845857248237485135874915', 29);
    t('111100012000222102122202200200101222011012212012101112001210212020000011200112121122202110', '4312338675736411168834113479404731768937986', 3);
    t('6112004b71a2b5434b77703651a347642a93b69b8771', '154708197486329491948970688330686826353013326149', 12);
    t('1042032441303342344224002110103322213421224333342', '4182077882904105022063063694371097', 5);
    t('29c68h1c7ede0jd09dffg0', '5202625875782390263071006320', 20);
    t('1e634adab5f805f52f70cac738dd261d7d6', '165447251922571882378062853693168471365590', 16);
    t('3jgalil961', '6947464731518', 23);
    t('1214401', '334081', 8);
    t('54860130871146444', '10286973227136298', 9);
    t('1030533234260', '14720402858', 7);
    t('100aa3e40361hfha8e248bfbb09h20h7a6c79h26ac', '2930615985226137047162398456800365754016041083603160', 18);
    t('43591767393031052388336018446089607834282371433', '43591767393031052388336018446089607834282371433', 10);
    t('1a42634db3a398440b0d143640b', '1093389394637381321001671261403', 14);
    t('1k92', '22956', 23);
    t('7ovd36cvh0mkqjfvfnuvbsq391cn9', '10844675681652928114870191782873626527707881', 32);
    t('15g1', '15181', 23);
    t('67b69b71b1717', '59413996339651', 12);
    t('30j57pimocqtilogto2d', '35115475354624111874465964673', 30);
    t('2d0b0ae2b685425d29b0ecb3b5edfa717cb1417', '16071927572096392119675195392748578598193665047', 16);
    t('11', '18', 17);
    t('112001000110021202210110201211122221220112122100101010011002100102020001020201000120001011', '4537785058981363374616512422509774739280043', 3);
    t('50ab6141b78600b83b78b88348b5a05131a91a', '43175432477484073434743334087258618678694', 12);
    t('eo9qocnoj90bor40al4p5479b7g4c1r1cb31', '6650244100026164587107322943956581111894985709587461', 28);
    t('2ad3kx1qktnu3vpnmo2ao6x1dv4x7xg', '20282628012647095397816411972962059191966263670', 34);
    t('222116623333265530440631564017304', '180929743300409204225159995076', 8);
    t('dbbg6mlmj33n0', '492243480903801576', 24);
    t('2b2ec06g3877d2791928b9ffd1746b', '1280577379796462921259686563546353143', 17);
    t('102101102211102021013144443014440303124104', '49494259261254501284171145529', 5);
    t('7a87c66768a00656e6143d364', '606741009919509661621760021348', 16);
    t('47767235803614822752211551670476', '1859353386668959678249738581726', 9);
    t('1', '1', 14);
    t('4hecd739h5679e7gd9029m08f', '2289177364521402481927372413403470', 23);
    t('6l3bh7f6o9gknn00f', '159385341670896444890640', 25);
    t('5e5kjlkvo5unf3dtwmmqrvik257j4w5w84', '700990942006311373479452989797165256937719202881105', 33);
    t('201', '33', 4);
    t('233203422520520454251431153344153122212110131402224331', '452721388389843317258206375087014173893951', 6);
    t('14n29lgjdc4rim3ornkjna8klilg59bdka', '668735111660092455694876539400574336368551464522', 28);
    t('b', '11', 20);
    t('oq', '722', 29);
    t('1', '1', 36);
    t('22421402200021542042515102115130343415021040433015141', '71435842509809622557607232355007569617093', 6);
    t('82a46ca7f2c27bifi76b123gg87f9ef0i3h6d', '88188580584290016425414330488192929012692460292', 19);
    t('cwvsjk3p2hdtr4bpc6bjsc0d2br4l00a', '3879212286333054912615124824551633983865683141266', 34);
    t('15g8jceb9g0402a30g48a8612', '21661444885578056193556763266422', 20);
    t('25r', '2509', 34);
    t('2288', '7328', 15);
    t('15005456104534360056661132626255212535602123', '3748858381866343201840235184540881558', 7);
    t('7lld', '96774', 23);
    t('112a8a77b453749a7996396a419b826b48a67', '782118792606829649781720121593080718319', 12);
    t('574b3345395446ab3a11a95127716a973b22b3', '47781483264575360443895323857628984548903', 12);
    t('10ae515da0e8b84e1e20004268c3d939357e3', '2290518350084555998421706774896373302739288', 15);
    t('a8g9b05eb591d3fg16eeb9940', '14045662689555135928086001793700', 18);
    t('1fi8bk0164hkb0b5bi61c', '2894983804002405037438210044', 23);
    t('4gg7ww428kg970rxm51xcpiergn2utyn', '7841808545231879066984143936817455941346408116527', 36);
    t('10054403136531256244562420403101530', '55009081778931754371153954089', 7);
    t('312202102122120111132101013111300030323012301121312222012320000011', '4639388111541284305176062560415061344261', 4);
    t('oo6wsed7h44idu7atc3eo5tebrp2bhdp6ok', '105381163294233046110304801048710957853696204404133202', 33);
    t('3skbj1l78pv7i', '4490496804454726898', 32);
    t('7975t25qbm14rr76', '275342913943535946165478', 32);
    t('8jdml6mamk5l02a0b5nh4c9l14jhd07f3', '16642540390807604641675529615883877432380047157', 26);
    t('100000110100001011111111101000110001111011011011101111101001100001001000011010001111001111001110000100110001011000010111101001110111', '2791627903658830465325077767573756541559', 2);
    t('4cuiv1vijcw8byyvt91x1yn2bk3', '126777211099543650145997525057934330115587', 36);
    t('1pb0kr2su503t7vfb5r0gare3o3k', '78053133845809892830118124009511471669364', 32);
    t('11011110001000000010111111000000000100001001000010010101111100110101100100011011011001010100011101000101100001110000001001010011000100101010101010011', '619196159474080554644191332764720245730596179', 2);
    t('1oj50', '891774', 26);
    t('6636451124501446361531', '3875098321019619443', 7);
    t('h6n02q8h3m', '250019766843768', 29);
    t('451ede25d199cae895e992118130', '246702729069387709295316838306020', 15);
    t('gc2c4lrbids9dvjt', '618717800012065820573309', 32);
    t('o0n5g9lnkc32u4', '1948944931869490633248', 34);
    t('ug5duads9tjl9t', '1125447236183519778109', 32);
    t('6dn54ifdh0j8p9468dkoc33h3hc3c5cl5g11d1', '594648027170439572811905861146439260035602841911119099', 27);
    t('gm5aek', '134776292', 24);
    t('1', '1', 30);
    t('0', '0', 27);
    t('43', '143', 35);
    t('lm98d', '9989473', 26);
    t('24ca595ac7a9bgbcc7f4g861afc1chf7814a11ae0', '367456433495521438883185813377166029060518959081788', 18);
    t('14660314530440163216346260243553125625015065133254552566', '51735077687650277604403201198662868237459984412', 7);
    t('510a75b6953b2128b51', '571468653948337229839', 13);
    t('2j8', '1394', 22);
    t('11111111100100100000010101000110100110011111111000001001001010000111010110011011100001101011011', '39547602794153772246742451035', 2);
    t('13d11h1lm539', '1746352709861265', 24);
    t('2j3h0n5lj1ldlgm2jhd3o28nl7mofb35q', '17234505762002327507626042985478124525535819504', 27);
    t('84158ebbagfd4fc814e8bb2l53gf2ag', '153343999117336060540862649308280733262460', 22);
    t('7g909e76cdeb0321bhi9c21dcgfeacd2i6e3f7806', '11116275700830490343102710037586110243685725571804348', 19);
    t('ib264o56m1n', '3790551468077834', 27);
    t('3qe', '4366', 34);
    t('5p', '200', 35);
    t('3130233402005135513010143100020201', '155289768167720086146598249', 6);
    t('1001001001110110001', '299953', 2);
    t('16fomoru8scj8qi6', '45444374663984422611526', 32);
    t('1002212012012122202112020220212002111111020202102122110010021100022', '34175452783248538685342138607785', 3);
    t('27a50c6be781d23639d548c74668abe9e94be3ce22', '4167412892319939194840854425277338372039201983057', 15);
    t('88a3780da4dbdd289baa01a811bc6517a', '40906542215241584358490557843916640488', 14);
    t('gqbold9ds9didvt57hbb8jf', '21838794139140707774087244457288303', 32);
    t('10b', '452', 21);
    t('ihk', '13601', 27);
    t('26252453157610233727260203', '1937319065301154692119358', 9);
    t('aa9895782cb87a165276477c', '452046848974584515631452537', 13);
    t('798233d41bd4d8570a55253c47760375b8ad22', '19604340805420393759398902048029147177522210', 14);
    t('2fiq2gfu', '129071446540', 34);
    t('1400512', '185131', 7);
    t('1b244a9ba6227462680836922985195', '43502077484194496821773474699946943', 14);
    t('412011433400334101043320401431213340122122234301220044344341432211331132312', '22669905856359456126837986263860586893462278431114707', 5);
    t('99jlbgcbm8l', '895669350576471', 25);
    t('2160778865276', '617500413969', 9);
    t('4619a48750a8a1388433820', '371293698754379801044722', 11);
    t('23b2a23b8ab1171549b81a523924944bba2b9451b979750a1', '14712614649874115297808648378077142784658853979174201', 12);
    t('1c9aa', '56586', 13);
    t('5accejj99akk1ah', '34098874640361347185', 22);
    t('20013312310323123', '8721747675', 4);
    t('7f841c807c4a4e9eb32eeg4963ai78888ff', '234637522959956493197663705686912406112573938', 19);
    t('32f102da079f77cac41', '15035262184397547023425', 16);
    t('1o', '56', 32);
    t('15567437201441347355454544146426241554605511544026607651', '80286234176563111847045853769570753921004267573161', 8);
    t('hjn18i8mqcbprs06jgfr5q3oo9bck', '1565631049924090657943692422085174312230242', 29);
    t('6j62l6sn11', '305449793742193', 33);
    t('1a92b1371017319959b372ab60ba2294679b45215', '27889304114434174647327312538513856310180593', 12);
    t('5839272560037068796091105463956029620211063950', '419776982872392388414731107567819482106312014038', 11);
    t('6', '6', 20);
    t('2c880d56k3a7li582622b5imekd0b', '341027304272170248894809973045388788348', 23);
    t('10100100101101011011010101000101001101001100101010110111110000100000101010011110010110001001001101000010001110110011110000111100010001001001101011010010', '3673151219411926241066396539539895097311402706', 2);
    t('111011100011111111000011011010110010010000111010100111001111001101110000', '4394919723391067681648', 2);
    t('4aa5', '13081', 14);
    t('2opifo52o8q32g8maod8l58md725mbrbd23', '46158568616582718889447630456685730068082636613195', 28);
    t('418j32fja719d73155', '53377690823861098744505', 20);
    t('20144632610464350', '67599832991439', 7);
    t('2kh493991i0g7khbf2f7kck4i96e9fh933', '587461139271908422337268964350415471317511729', 22);
    t('4a2n9f06i8b3tbik3ge2hl5jb39mom1hrcp', '723192498587288435855105790107635409475143071893685', 30);
    t('12113303030120222311111003', '1793522922116419', 4);
    t('24077', '16108', 9);
    t('4pjpv', '6350789', 34);
    t('322311323221313230132232233002003010013223213212310021203233123120002312231230', '83983092135187210616217933394923456110667721580', 4);
    t('29f4d7g5ch1mjb7h51f7jcfeg45hibg', '612063586663379541382996507678741140541336', 24);
    t('10pek1pldlia8p6oseke4p57cgqckj4g', '46807350154418933094997050205656695831893003408', 32);
    t('e3cc8jmq4qfi72', '91829383300393248806', 28);
    t('13c11i9545i088bddgk90lfe', '8722694663106063748286842646172', 22);
    t('22a42a6856d282i', '24416804218738314558', 23);
    t('5j5dvvf', '7207343895', 33);
    t('21423087479741957663258638136686693560b0717', '4470867495087534207987102294285398093469949699', 12);
    t('a440f8912c06198b', '11835733123122207115', 16);
    t('7124732', '3795770', 9);
    t('1mi6dae6p6n18p51j94pe7ac6dcngk94', '433566629754475119418916772536421104644424677', 27);
    t('1f4792hbih0e5', '3987607350745668', 19);
    t('1110011001100111011111001110111110', '15462167486', 2);
    t('1eb01360e00290e5366a042b85', '500540389147064575524034196225', 15);
    t('600196957607397725519151670801466183229598842', '39767779963727744076832805419657145468053323910', 11);
    t('1pfswthxe5tqbubhjjshgvdkiwf4ryitg', '44414159361977485248499214227052721453325811694581', 35);
    t('3a338ah6', '3159952098', 19);
    t('1a41af5dge63cdb70149eagb60df978adc19d', '316909217417428222992238303166579153231020418', 17);
    t('c008c78c61addc8e085ca3ff6e76fa13', '255257360887256236558111057213476239891', 16);
    t('aigg730gb9gg5b1i9ggch147b34daf4222d', '330203157939216599297841920141628505752777778', 19);
    t('21035126413112020231313', '8420857150186478861', 7);
    t('21011110201101001010201', '74954636299', 3);
    t('1043686460506176163', '1043686460506176163', 10);
    t('33ob8s2ob4abipqpbu7oq2338r2ic6kq4s', '1075138754438632694426396913632774320113838381374220', 34);
    t('2254120142306727111645063565', '5648689955684980442294133', 8);
    t('4c65b28hg', '51641173186', 18);
    t('189425b6', '62046426', 12);
    t('202222000', '15282', 3);
    t('2ix2460e7mc4yrfsyx16urp79', '29019140380746084875089897645108901004', 35);
    t('10001001101001101101010110001101011101100100001010101100000010000100001100000010101001101100101101011100101101111000110110010010001001001101100100110110111101011000111000110100', '51501613866007552548575243188268697652335512286236212', 2);
    t('72bai2lh5a5ige2c6h8j1pi7do6ph8po', '518863311245070128162706172824537578926308538', 26);
    t('1gg4e12gmdd9g34kldbkff6g', '36045469172509506032689305574493', 23);
    t('1d849l7924g24ge5k6k9nbgik8b6625j4', '228420120550953130629950010012173053917911308', 24);
    t('7f2n5pcj', '317806874668', 33);
    t('203252000343611312345016732574324517652170570536340103164002', '393097177469022242668976094291182082270851391919286274', 8);
    t('10c509a15ej1c8h2ceei3dh46d3h2agd85j6j7d2', '566593718328820186671679871086974063112535421915062', 20);
    t('0', '0', 35);
    t('96463a781475552277b', '253758635463416758223', 12);
    t('20101011102211012212200010200011010012111102122002', '508627374341025984624677', 3);
    t('3n', '122', 33);
    t('1332321215012153105302330', '7558638818512137102', 6);
    t('d78e53g7ao', '260656990368624', 30);
    t('10433235012112521331423540541', '6924859979187917170861', 6);
    t('jregrnbedbqvdh2kqlmuqwtt7o18ua7m', '2351190601646006071521498616875161108543841169408', 33);
    t('c6ae909740k7fbdhc61b4mied7bhia', '37961155295368021280681243879680158633940', 23);
    t('1b04754391', '9903375901', 12);
    t('448ccx0p3cjbx6hwiqa370ktmd3645', '1067333585305947578398968392489544974864772877', 34);
    t('id', '535', 29);
    t('3de2', '21962', 18);
    t('1i87e93lld2hmb5of61481a1p', '37803177566866222246047503937156379', 27);
    t('1d50bl1bg', '123317230093', 23);
    t('ed4fbpym9a02o', '48576469025418884469', 35);
    t('850ahc19dfc6cag09c3fe1a7', '615573849475122469837759021759', 18);
    t('2924844413578201a144433a54311938093312874', '1284588798112331415097636284287592444342524', 11);
    t('268spn0x9rkgrdn9mq', '386669665422099248737174821', 35);
    t('5hk231k5bacd3b8f1', '8376132966290213466637', 21);
    t('1p8og16j01fia6lc9r6k74336b', '2875139523028270878045249857146557219', 28);
    t('esmq', '488154', 32);
    t('5b9gb9b4', '56701257988', 27);
    t('c9o3l82q12ep0gpa9', '986427541756225676608461', 27);
    t('55388688a120a6849aa3', '1738783465109452015323', 12);
    t('11649c762', '4668901218', 16);
    t('1', '1', 25);
    t('183c9j7k2e6bcdej9h', '41731318811749061211776', 21);
    t('1101010000000101100111011110011110010', '113828412658', 2);
    t('1103200032222010132222130123311033221023310310113', '103372423190590343441776856343', 4);
    t('343', '938', 17);
    t('340033799252741465289305518413058425050058', '340033799252741465289305518413058425050058', 10);
    t('4503240112405112435055530202225400044402200153042', '108877380126556039702448219236071909458', 6);
    t('22410502071700760126344737773405044556536263663106274741', '108249648375668138579864767958324372334698552719841', 8);
    t('60471', '39754', 9);
    t('jqvj', '712159', 33);
    t('12b987ca3bc8c94588c3', '1788415352163649686935', 13);
    t('1f4h9ih4568', '44931985848560', 22);
    t('118g069313', '214821890121', 18);
    t('2vlc0hrwcjqk5qh', '17671005276271615582217', 36);
    t('1eaccg8b2', '12979996198', 17);
    t('21629b2b0b4a2366b9163b76b5aa3799049393531705a11', '93332007302941381029153257858901257592873163524973', 12);
    t('100202010011101022120020200002121112102200011001112000', '20987916954361515072077661', 3);
    t('lf81l1k4di2h8', '2060202423101314474', 26);
    t('11000010110111101110', '798190', 2);
    t('35464780031172685830831886', '2594420148586517707211619', 9);
    t('mjmbe1m', '13491665179', 29);
    t('e1q8siod631g8jl8e96q3ndsua89fepgeaf', '7149422266506896025400459577722689166265236529840392', 31);
    t('an8h5ufehm74gww4pwj33cwlq9nq1niww3k', '45609180326934639552795902886424593721591572949928264', 33);
    t('1174957d27585ca327c392a177a2', '9779753057084979308662475538114', 14);
    t('5qsfwtg879agqymabikny', '43877513087409382241114364600839', 35);
    t('2202944b4c47910367ca8013', '89983147789156215799431229', 13);
    t('448cniclj7j66205dnabj7jb2gc2m', '1850318014395914995109265267767209237318', 24);
    t('444240441312131031044040211011202221', '14501598914208195910256561', 5);
    t('1qe2prgrs1k', '2056183230623796', 32);
    t('12311306121012324000412325560306516', '73082607480360333686565698116', 7);
    t('39c4641c46b27b205a771ac', '12093715273566107607445694', 13);
    t('1dhkkglpcr7ffd7wbebr9w6d30tegw', '153518783138820389818290476576072446336105598', 33);
    t('9ao457cql7l2pajdjvbb', '1167566332972029419259805429445', 34);
    t('bne906ag9f7ibi0o2icoochhqi49linbfe4ko3', '1083840512907384568109778905809324323571508451103168731', 27);
    t('27gkfmsss', '1131180526362', 29);
    t('1kl14jp0ck6e6b874a9', '53073824937278508675447573', 26);
    t('1qblmfnmbc', '15092289265620', 27);
    t('291145005283226378a15', '1902201869880961210864', 11);
    t('98a3165430386919708314a69668019301122aaa08a8a333a0', '10471562781280726876191243734075742375342072600357397', 11);
    t('101001001111101100100111111000110000111010000', '22674826617296', 2);
    t('11100101111101100010000001111110011001100101111111111100000001101001011000100101000011110010111100001111', '18219421810715473011424793407247', 2);
    t('5012045354154511564663311145062010640462551253626443', '63280196142241745046302922172418725133921298', 7);
    t('d5ce0d6e6egj51ac8c4', '8369782607667375206621824', 21);
    t('6051440330403356333004250540', '401296487305318979784424', 7);
    t('100110101000101100100110100100100100111110100000100010110001111100111100000011111001100110011111111010100100001100011000110110011111001100001011000111100001000', '441143871171700310794467845617284706136179969800', 2);
    t('7b57878058a56a65', '122576051834583917', 12);
    t('6497912562474778656b110a8103302a371071056', '94070129616506972086443616132039643483737602', 12);
    t('gdjdxk185ppgrwkdfct', '101796127731034217658663835574', 35);
    t('1178977c0a6405a2163234a6cb718024c74312422b4a', '890596335029491966141847230958764595731490655195', 13);
    t('37088663068aa806731063a736661', '525351225612561927340747775978', 11);
    t('5171612706118415272715060137148', '220427209875590734018941429974', 9);
    t('3hml8b7kc1p4gm2hn74hhd6o7d1ll62', '31952120714648933153539685420949059951111594', 27);
    t('9je255g', '852236590', 21);
    t('2044434433132300230220130303341220144143144304323233423021', '15263322484434834405567371553028493264136', 5);
    t('9eeeg985656bcfgb5133b5eh5e4a1', '1380061401736935644143449342352895269', 18);
    t('15pn91facaj7o', '117436627306186186', 26);
    t('6h45h4b', '584858264', 21);
    t('b5b5aa526c4894a5b93355d135eg', '18900713795310413451403180379983325', 17);
    t('5572f75ca5f099eda', '98516089885791198938', 16);
    t('323603301632153011406266531651206501610', '437183320525590537223414014997897', 7);
    t('1a2d35e82eadaid548h6b7c1db', '142758553123601399605862815621287', 19);
    t('871', '1444', 13);
    t('7dabco9lff9ngn317m0', '109673961094915000469942425', 25);
    t('43092b9541b0079386931b2b36', '4059444959588416633123556058', 12);
    t('1boc7bh0olho8m4n02h6d78ih4a9k1', '465799410987253426014508176316492036379788', 27);
    t('6mg8915i', '116919428053', 29);
    t('822d188gc6c2d8bge4932b3bb7fb3672b5', '327157616726198043612671071851924507757009', 17);
    t('101jomm7el07sqf4rhm', '388135427144045277146082832', 30);
    t('1ajadffaqbk4nkho11fflbkdml27', '619452202075986493017080634500652444361', 27);
    t('159b420c8d4a7477ad5dd8a54cb565e0', '3959681364275325746089585349463518460', 15);
    t('7f243fd29c8ib9d39ebad', '293037388819465175740976997', 19);
    t('2859938585818baa4ba73924b97823a353b8a653739761', '9900376965008691067376961107831442209219200169977', 12);
    t('12464266411210', '134354404534', 7);
    t('fru1j0vpcftehqooiiv56bi27', '21098962974195274149815095570253334599', 32);
    t('daai9e9i2b18agdb4210fj6038h7', '78621573343485599235200018571738231605', 23);
    t('ffin61o2298eh', '931637737813427242', 25);
    t('116210618', '51143498', 9);
    t('m0iggpdj6lrcdl6o892l1ojt1d', '936545650234778704563539555026320618541', 32);
    t('bld30f5', '2895750380', 25);
    t('43516380211c6510c36c6ca2ba201cb6b78c', '4145070522657789681367338903946033748528', 13);
    t('2frhlapipo1jm9', '26165355055652545639', 29);
    t('eebihhhh8ic074d20c11', '29221406700141396291294443', 19);
    t('702464247710160725611573536407615231642232', '74869132891027108059075932498363368602', 8);
    t('6cddfjh43c091ck', '418124197863421976856', 26);
    t('14dqq6n4bhh5dehlh6i7jok7j', '709417662539059692087600073605499945', 31);
    t('1mc4o514q6g3icsfedhsm1cd20m', '1026878606225608766969967252663359647001', 31);
    t('af', '175', 16);
    t('2', '2', 9);
    t('7b84b19108bb07591b3753a3311b03', '157757817132486011855402897961459', 12);
    t('5g92l47cjl0n7ob932c9b9kokpi54p3', '15835098073858662949103316680483193845978405', 26);
    t('111100111101101111000010110010101', '8182531477', 2);
    t('c41a62e8bd1c7123c92220df', '60690961081480451125474894047', 16);
    t('3111330202313102310311201221301101332333333333132102113330213203322221313023020', '305353951579153096643759644208233327052754219720', 4);
    t('1e993o3ukos', '2194385828754565', 33);
    t('5231203324201232502321202321', '5550302446432876259113', 6);
    t('c531016e18898347ce', '1216498610182453367144', 15);
    t('vrd88', '42502932', 34);
    t('167233640813776470607127062215056', '6030750934980643551934540195509', 9);
    t('80911866', '80911866', 10);
    t('38', '92', 28);
    t('56966em0jce2e135odie7c488o', '18942697033508769047921405112915875394', 29);
    t('1ufv6t7m2qwda3im46wrvi63e4ee8eqe8', '19283761638158770938814497486670870733658376776828', 34);
    t('7j0nqi4dr3odrdrrif730bq2ijhskf', '19658598320579357039141641643837077460209654', 29);
    t('4f632ga542fd4c0ai8065fg2407b08d16b024g', '990186552886364408955753851129882315763213446878', 19);
    t('22211001121012112202021220001202200100222', '35731418813631116117', 3);
    t('5723918bdb28978d197bb99c96b78bc', '133387033950880025293297852372942078', 14);
    t('f', '15', 21);
    t('24k170e', '191770628', 21);
    t('113380473156115346053712477828402262444530753651827', '594483726000523306774625214331012707298970579092', 9);
    t('0', '0', 35);
    t('5nljfrvan0nc8g9ia22uc8b', '7450754896579357424627414612259083', 32);
    t('chgj01cdbafh5fj55bj83ia', '540745421736410580973158305570', 20);
    t('14301524', '7087036', 9);
    t('15i804kd9fjh42if69i0dlag2fied3245fh92fl', '1300847036023294222835276240403460067139304231007087', 22);
    t('3f', '75', 20);
    t('1cruxw1necvlj49oqtnxu7k9', '445548487845292717307860766038288034', 35);
    t('moke3taeim7qnhjto11o', '4935873699081075292509565948409', 35);
    t('765e3e05ca0c4b853679e80667d71bb51ec118c87c1', '2767923543808337676781898227256098432891809077954497', 16);
    t('fga', '6330', 20);
    t('7a172', '634187', 17);
    t('dfwq2av9tp2g61n9pvjyo9mmvg6q', '14080845047776418964900559740542764294594994', 36);
    t('23103303120101130120', '777177339672', 4);
    t('4p4eq0464bo6ocqh', '14571181667815526352455', 27);
    t('15m58b273dl', '79058625110541', 24);
    t('e7d2kg93kg66eh5ic6fc0h93', '107753610293001126855936969374669', 22);
    t('4544550314555030245131500001423553314', '51236655573337292293249788910', 6);
    t('44123343424431144042133134403210100301', '353761873626317393756721951', 5);
    t('14554315330320440350550251242124214503531444', '5290305465869465535101508124318804', 6);
    t('3j3015puqer2', '180865604805106619', 33);
    t('76706d53152137383626628b70d4ccc6c122344', '266602455093722056456430772081609665962697976', 14);
    t('13pif992g4658ch6j8ahgogpi60lp', '4800018957123587648437240307149790316011', 26);
    t('234a67c65a94c47', '8895403611426989', 13);
    t('gcikbqs4jjkr5q0aorqboa2c9obfk4s20e', '766678025667202009433846434100440635178484404979726', 32);
    t('643b91b0289fe98c02b3f790ed41085ba228ba4c', '572227512274253374435718937361849836268824345164', 16);
    t('3k20g', '3803152', 32);
    t('1312c4085', '1801106837', 14);
    t('8emmcmbp542l8l', '21269151478085207497', 26);
    t('1ic7ll37iije93k6b7m982dmdk8', '458805542302884920114146210861237128', 23);
    t('tmpt2qp4v10vic65b', '58727236794092214086891669', 33);
    t('6khk8ll2h7b40553', '1840683580393299686805', 23);
    t('63', '147', 24);
    t('202110021331103212003022032301', '618162844202738609', 4);
    t('721b60be132a6819c03d84861d836c15e0758a62e', '789621417226946084682961249654900691281833580769', 15);
    t('14', '16', 12);
    t('1jn', '2003', 36);
    t('20321034124130112312321020314230234', '1244390864496847188820694', 5);
    t('i32gde23mq7nfbl6cgfoqlf9n5kqfi', '16807844582918365513594352707748847318383958', 28);
    t('8da1c90b5b00bc0b805b125d953776d42876b25', '320741753186531118132849958969232281983489485', 14);
    t('111101', '61', 2);
    t('2gjmehabca7mmbjef0i30kcf', '5000975177520593103948512648993183', 28);
    t('148534683843', '409063381147', 11);
    t('10425635163828754608715', '1036960431474820128377', 9);
    t('98e015d5a8d7ad', '18674876444372488', 15);
    t('3489180081680194594039', '3489180081680194594039', 10);
    t('e68c', '152164', 22);
    t('hn1d16jak', '1977064226756', 24);
    t('cfeed95dfij9afgf8g5j7h4b8be3i8d19', '5491903449965714818143888948680411788549229', 20);
    t('1403243122140432204', '6975903061554', 5);
    t('4121443420114', '1048810659', 5);
    t('4o86g3', '99219965', 29);
    t('11101010000101100100100000011100101111100011001011010011001011011100110100011100000010011111010110010000001001111011', '75965586951977951466854946826683003', 2);
    t('418b1a918265a8452c7897c64966', '4924364715692255096187414788005', 13);
    t('8ln1hgc9n8045k', '7813942802430495116', 24);
    t('pr2lln', '867260087', 32);
    t('1fcn793f1gsn7isrq2bs', '32443969807482433165938998580', 31);
    t('71215302120100471557063', '528279067564974726707', 8);
    t('279dr', '2633658', 33);
    t('1k', '41', 21);
    t('g3c', '7822', 22);
    t('52unr90smo2unpsfaro4', '110445292972077630039222055408', 31);
    t('120212330303033103100222', '108229740540970', 4);
    t('5a42729b56b5327b5695', '1872989024756192416913', 12);
    t('3443452305237156410051107403', '8630515683508240645394179', 8);
    t('6d0e24f917cia4376dih37450h', '622334481357904649813944940629175', 19);
    t('70r16fpnf8fpach4bni1nhb9frlo1', '233162017149374796044403481642635719993649', 28);
    t('9g5b4c6fa8i5i1ba54chdad2h2b7diigeg', '84300792214158192051555299617411649772630696', 20);
    t('27kgj0c34g3p97i2jjfp1oaool62jnh9', '168212362913311220690364503904168199040526871', 26);
    t('10045661289', '10045661289', 10);
    t('568101442316503108', '96174458293818842', 9);
    t('12', '18', 16);
    t('10lg1mffqbgb6n', '4172603685173290148', 27);
    t('22h08f1j2aib4a56fghcija206753id7c3gbh0b3d', '23557638256623360938264238120003382902511416101924473', 20);
    t('6', '6', 9);
    t('3e1fhfh10', '138834297903', 21);
    t('540', '3484', 26);
    t('1122030011212013021130', '6197731684956', 4);
    t('3d6rdvev3i8smk56mqkf176sjqoru', '4756953400164035672859471330837978142303102', 32);
    t('28ea59cbb990457243147551fc12145', '3399121160718415003848736585359106373', 16);
    t('1750617616706657707114034617432306132573321272245040042711', '5850571219466548068012306893496891664635414265742793', 8);
    t('bk0ppwbbjolo9ukpeepe', '1452584125569882865183540835864', 34);
    t('a2i1kcki8i6afl0318gbi0c', '3458077475262704937982766014556', 22);
    t('105431041122515350205233534011145020140402052220000', '937497849037121623452661458994336348896', 6);
    t('17000472', '17000472', 10);
    t('500502757838694ab1678942205536b80267164a6b403ca17', '1473835956263371576873030907640706150910262129499406441', 13);
    t('316eee54be4c00b9a96a0c19e19a40a046db2508d55', '77069585133800346034958196432644102010796362311255', 15);
    t('cao9u61rkkfk0h45aoofof39ig18q4', '219321826067019903637853646593680142271461817', 31);
    t('1b21ce892bcdaecb887bbdd4b51', '6601064768543115590908820764801', 15);
    t('1c0bkk3ideb7id68ak', '47247687823294270861205', 21);
    t('bf7mgo6n4', '32224267177888', 36);
    t('4delmbr5pglab2c4rpnike', '11012871448891715561043207133854', 28);
    t('747373012741076272574334113131066623327', '158199639324663999178714767706236631', 8);
    t('1casd7p3p3a9d2jksh7b7p427', '867620324388850207003677149313386558', 31);
    t('73c4c569b6b25573bc331aa883a4745a6db34b', '18565516288910449123169494151650103860788871', 14);
    t('84444108680656169877651363', '84444108680656169877651363', 10);
    t('1bi8n3f3if4k6ncf420he5a9n3b7c95hah8fad', '1742086738914014097772398313856731491439635861267133', 24);
    t('ld12m8430bm8bfl35bbhjn', '2078522121514721270837067229727', 24);
    t('1aij577mdjag5b', '741129866732072277', 23);
    t('e06e5by0huf6wr78l2s77qqlrtgjt3qyi2g', '441167684426814513681312893751351585030041477675499261', 35);
    t('nc25kj9f3', '3583308896628', 25);
    t('2774470632043051240455350472340', '121680175780473175097234491455', 9);
    t('150115341123121222041335341030534511303335504141455340005003403044', '699070363336208570930399209135482486908535252991204', 6);
    t('10320123211204231240044311303042001210140422412120222012442011240122', '77011705597734437930150474763682977663080180662', 5);
    t('2ep2nubk6u7u95', '60499856765543229904', 31);
    t('27101471413489956474516936', '27101471413489956474516936', 10);
    t('205512131', '3633175', 6);
    t('1b5b00b1026b90354cc9b9905c931bc93c8b508b45515', '19401633096691683512551170208360848886053437418114', 13);
    t('3045540', '146436', 6);
    t('63ckmgig4kid768l9dj7fgdqd1nnp902dp3oc', '20723302228019764418200643552099428622221940273775183', 27);
    t('d8bb2364a8db15b1412576b6c124a1b49583', '177430658346563064062252894201653646474719', 14);
    t('8f0bbcioj1fe8mdk7ki8l4aonjk377g0gig83f', '45531903854689224866634237825158981669263098308067590', 25);
    t('2748709529c232f08g85dbac64f8d4665g03d', '480051529652914850587360519926185710690595373', 17);
    t('ak4tcr8j80noaam9sg', '240165757095163574519326269', 31);
    t('332167b6ee686ch36ga', '4577445810401469572747674', 22);
    t('93', '210', 23);
    t('1101012110122111102121002100221121122220112000122001210201100111212221000220201121202102110222221000021', '6391116759661421858380546864255293273592806783454', 3);
    t('3rx8d41dc8nzpg3buihq9k1005', '3051780930874321900947488047344884444741', 36);
    t('16bl61jc5cdhm9947ga', '4163579690872185402607781', 23);
    t('39mi77', '110840039', 32);
    t('8149468040947619516457530899555331641620787260864253', '8149468040947619516457530899555331641620787260864253', 10);
    t('3if6j38s2cgak3qg4', '910596518615709492487577', 29);
    t('240646541755015151746375314736543447343444475552143', '3586530035933343022858608741776409267984061539', 8);
    t('2lqj09278ea7ag2q54m', '579985127245834611445154934', 29);
    t('b2rggmqii5jb0odp7', '1585296695989924711356563', 28);
    t('2', '2', 21);
    t('2bdie', '592342', 22);
    t('thj2denh', '647086684307', 30);
    t('10hg5iimal1m', '984702139840031', 23);
    t('11111010111100001001110010100011011111111011001010000110011000010101110010100101110100110110011010000011110011101110011100011101010000011001001010000001011100100', '2865227033411954606371792440103294708104730837732', 2);
    t('12f6rr7mgeop2rtanem1', '12594149153851802918636434261', 30);
    t('6204661505100123631344312032141634623322531530342234621245631', '3200663074421335398837744308850619093123113632613932', 7);
    t('d02e51b2006c9aba507ee8078944483', '2495283013998564778170214002942629523', 15);
    t('6c8461h11c67j84', '10847089588583423764', 20);
    t('5jmek310gbmfldaemli', '19039589015004936268391471', 23);
    t('2bfgmh1', '371275868', 23);
    t('i1kicf7408ja', '43089829171489860', 25);
    t('kmg9vehm5uc5j', '49306200853105671213', 34);
    t('3', '3', 21);
    t('122222101101011012330310012021100322300021121331', '33004057764112427046850827901', 4);
    t('f54kak7e4cbomlcj74q1gjj8ima', '249496516505770436608106844531244644676', 27);
    t('6c0906a1a0571698c729481b4214', '8260906699678257716913660927911', 13);
    t('47565283104081157633720612', '3480763053212520433373009', 9);
    t('123301111223321011010131302322013313330310033133', '34378733037297577486842020831', 4);
    t('emi9p2agp5of4o6qj050q5embro4fkk7c8f', '236538829295639541371770226117340564376039956754927', 28);
    t('a6617a383d3630869c8c5b94', '2401408811388914735909033670', 14);
    t('h9hi3hfbf11ml9bl44ajk8c1eedc7hi20b559', '847811630497490086928088517877737870085926386752961', 24);
    t('6t2fmrdufe6cj0ttsf6cm', '4660945383740971389474445619601', 31);
    t('1c149ecb87796c6a9116eaa5', '8690508679745247747029527205', 16);
    t('50511214103014512415251153355121045141321231325212202024140', '6984297965964263483810433193107562554690235452', 6);
    t('713410438960822980645a5993', '771298716488835296229308646', 11);
    t('21111003233203000222133110131110220102003011312023311323112200111033333', '3250695581456803692625152484104902348461055', 4);
    t('3', '3', 18);
    t('11g2el2cd7ijmimdmj2', '3484028926865476565217908', 23);
    t('w1jn1pjy', '2061728269824', 35);
    t('fl9eiljddneo', '58071616717298104', 26);
    t('1012210331013523255213150253013335240310251413254533540213', '235028416077302984568423163498848184230924465', 6);
    t('21345516652054242646357330536124', '21600249893595093431386029140', 8);
    t('3516566ad8390f97fcah6167f6h3fcbhib', '5164130207340834274229128435944714360103739', 19);
    t('1celd6bb2d65i05m2gjn1bi9b7b82of', '1304319448692751655608515138766232006376865', 25);
    t('3d24cfd5a3d86612', '4405874851959039506', 16);
    t('437hoia6g4', '190186408481293', 33);
    t('4kt50of2od', '123618635333176', 31);
    t('fss67o7io263', '572949178706823363', 32);
    t('jecjjk7f97a3ej77hb2cf73kihe935ji', '8105008394473920878854794247558553077032448', 22);
    t('1bnorre7hl4tb7q9qpjfm25ksob', '4105331027918683625727596478007911896039', 33);
    t('du5i8vtbhj5dtwskns1gtgjx09uqdrx1', '10184138846438586443859407370042237810094945982856', 35);
    t('1210020000002100011101212222100120101112102000011112211211002222221121212110010112110212011100', '420882836067947584715454206106333480694711890', 3);
    t('35194576c4c38370b', '2258945736842956744', 13);
    t('c75b132g', '5101050905', 17);
    t('c921ss00d3csg', '58052666456572596352', 36);
    t('2jgajk9kj56c4bdh3j6', '1856193611885092871748090', 21);
    t('112020', '1416', 4);
    t('620i04ijh105p36ph5m', '179174918213489533732778468', 26);
    t('1kxvl05dwu06qqr79fhiseddrvm', '10649257859457410016272202703683336103832', 34);
    t('152445052135131354510404240340301115311014543', '33109388948224325760981254841111039', 6);
    t('55', '85', 16);
    t('1ghckb1ch96ad55h8ik0b21e0lgmad2gaaf', '143513343624647251275600679456062100442672338815', 24);
    t('3ii52g', '9899396', 19);
    t('2b6ul', '2464725', 32);
    t('7btk3xhm7s16wgi2e', '23436808404419636027088410', 34);
    t('8b656c', '3298632', 13);
    t('1201110111012211112100011211101011010001200020110211010110200221021211012212012022210220112110122', '10949138520677755464489045550877099321077567229', 3);
    t('1100', '12', 2);
    t('3052066107', '413690951', 8);
    t('e7fbo4m38pc', '2017574092397070', 26);
    t('40wsrr8g88ltx2qa7', '12846856175435338795665091', 34);
    t('4a13cb301dcad5701812', '28213021023084856900552', 14);
    t('33f50po', '4009779435', 33);
    t('433b40b7', '266911483', 13);
    t('8a555026628970838a79424521', '970195127281423746562878756', 11);
    t('4e01f7de0hcgjl8g6', '13962247025122105118382', 22);
    t('1jeo2h254hk0b9mldg', '1038391416567657581997841', 25);
    t('e46ch8078971g1hhf9f1b97531df2b929fgd3c938', '2314731369176522523922328092957556423672080265360978', 18);
    t('242717160430', '1747072738404', 12);
    t('121211122110102210121020011202002211101012121011221122211112212212221221022112021110222020012', '146968138778253529694918992051477705186343198', 3);
    t('2f2ajhrj3l7q46177onqegts', '409232179316426518796201876801844902', 34);
    t('3fkkeg', '61306072', 28);
    t('22343414021421424023041441331434124003402212320222104332421301224130332311232', '338574476822007917824757676170869262799211929767072692', 5);
    t('15058101388443184451253136358', '818332960438094029477243766', 9);
    t('114c1i96cjm8k9k0k63c5jil41bjfh4789dh', '481396998104028267082829096262079902077941433867', 23);
    t('92dac144110424d4c77d2b0c84cd321c67', '611833115355492218664994981758095135811', 14);
    t('5a6e26e2de56di3a08', '72309336910701228508008', 20);
    t('123791225460336062189914aa9098058a41a4989a27944', '972171175105408063075115872561973013135356652374', 11);
    t('1kj04p42grlk3ke6gehp1727plbfijfm4h', '991737689151806718971626022815597324840056300833', 28);
    t('2nkf524l41ld8plr6h', '11380730654120331785946409', 28);
    t('23335225', '728225', 6);
    t('k26ddnn863h2b98l3ai3d85h65m7d493fp', '993176059355328275357598675656866581607010932371', 26);
    t('4i', '122', 26);
    t('3n', '98', 25);
    t('848h21d7869hfg9g8f16', '16292644969781732195571684', 19);
    t('c05b090d0d716f41de31bh', '8581554053841462934818166374', 19);
    t('2324501355', '25979975', 6);
    t('116', '78', 8);
    t('a55096037a79274691', '5305434806751713910', 11);
    t('a8309vwwidpnc', '17087840760045903288', 33);
    t('bi403hqq3bhholr5k666knagopj', '1223933313842546154543619577505005775473', 29);
    t('2c6', '2876', 35);
    t('e5jb479g3h7b4c8idd244b3al86g1', '552313164311562243318741691899753694921', 22);
    t('388ehbf9a4ibk1d70nm6l3kg3e4hi5gn57', '11797601925594328234833479927518591099616355391', 24);
    t('8udnnwc', '16302304807', 35);
    t('29ul982l0le66', '1829153838816649769', 31);
    t('0', '0', 18);
    t('1000000110001111010010110000101010101011101111101011011101000000000101010100011100', '2447314272063451666863388', 2);
    t('19escb3098ff1ibb', '11460919535170071665494', 29);
    t('144142131212402102322221414212012024144131342412100', '175428218095062761572388134603091525', 5);
    t('12b9a0eiko', '5938407034584', 26);
    t('26n3f9pfb18b0l7f4eebh59po5', '536292074201521875899112083004836625', 26);
    t('p6i0aesfjm18oo5', '7506892679720214826271', 29);
    t('29674bcptat7dm06j7f5o5psi90', '1369393655999563288033729621327624087757', 31);
    t('14ekpb14sjd5kjacq3qsgpndjkf89rd4s6khi', '172557940720326178657618843389705196986384318987060528', 30);
    t('jhh95ebg93j58f2aedg2h8337gjiaa99d34d7189', '10936655689667291351153903966134856902763255246936569', 20);
    t('149819381691633a23a48', '971554154257673586069', 11);
    t('2o8g1jammj87cep0', '8569512661345976338857', 27);
    t('odoq', '877463', 33);
    t('rm4rnpim570475dkvnu2nn', '2141999355713822778715273015702793', 33);
    t('1ac69832157b88926', '1226565762593354124', 13);
    t('dl6nilan5q', '199215636869702', 29);
    t('243104323302040443431304423423442241042131', '133218548417027778287104627791', 5);
    t('ibgad688n1tt1no901c2kan51np67bk3or08', '289608891570140335427409811203476440142828467327116217', 31);
    t('244311300143314014024304440302004302233424031234444422441312430300100102', '126466804626308277778897937260691523506062725784402', 5);
    t('213248823315264041320', '26159069159933260464', 9);
    t('1aebpqb5gfrar0', '72444883332647710566', 33);
    t('0', '0', 2);
    t('c45', '5901', 22);
    t('2b1dc5d2236fc61848eb80e4032e842131c7ea1edd0', '1008232683040405259975519873135905613349630326730192', 16);
    t('1101000010010001111110110001011000000001101111000111011111000110', '15029069503449036742', 2);
    t('206dj8sanq7es6sb491g9pjc19c57o1fpi1g', '3066391464081196310306031655376750037586720973723086', 29);
    t('92', '209', 23);
    t('12478802aa0a687639b08595396b', '164695396078375004356316605091', 12);
    t('23eh13lemi', '16251531039963', 27);
    t('c50d1e2', '577020863', 19);
    t('coc4ouoeqjjltmun2t95q8d3emx', '177591866017908630546079893678723856610953', 35);
    t('20000011000210202100201102121111212201202102200222111121011100202102120120010211121221100111201010110120021', '752112721711477552473490297488694750786078293851581', 3);
    t('4e1ae4430cbaa1e317a76a2247d6', '280724852947932121003515360229026', 15);
    t('31341304005033501220015003320215500333312434105521550120133031533', '207103120854860196428042222092939291401063326967057', 6);
    t('0', '0', 5);
    t('2194', '3712', 12);
    t('aac7bc27dg81559gdbgbgd472938b54031g2bce9', '10329879133439956684984427194752281557369149598185', 17);
    t('1yu1qd5butqh93n5t9f268wi', '651203452267786771549026926235644438', 35);
    t('6ed6h1hbb5k9i5ai5h8387f694193', '70471388027526307133742046232328939096', 21);
    t('5em6875eptkhs', '12960542504353252646', 34);
    t('9', '9', 18);
    t('da', '205', 15);
    t('elle1baj3dg432c7icc775560h2eji272k87jb8', '15421675663335715158214679544236080147103750752169230', 22);
    t('1001012012202221220211011202222102222221111212', '3084861462391318124129', 3);
    t('3173', '4194', 11);
    t('1c232a352526b255a0', '16750443967049089622', 13);
    t('1h3s1irr2s6', '669313434447102', 29);
    t('4bcfgl', '125047759', 31);
    t('a132a469136450985a5397a768261a9304a71924a1', '50372232119853962785587827398768698622013630', 11);
    t('3a887gffeh1h50g3408d1fbhbgh4f5c7he5ag', '5544963555766448467377477277242334965699182968', 18);
    t('11012331313202110222120203021021211010131232210', '6324455456594725514532477860', 4);
    t('1279423', '2208638', 11);
    t('788ckp2qh', '2063972254859', 27);
    t('5775521126167057826022666', '468376935266933192169177', 9);
    t('snf3hoep3bqgon6dipu50vt5h', '38193381830725709155237943160568018097', 32);
    t('giflcil6n936fo', '405257343426048644637', 31);
    t('9hml5pj8b0pfdjgdob06748', '130505791364330545697626575212348', 26);
    t('81ebe6m2cd6lgi9j0ci98', '13850919497461336125687141375', 23);
    t('nn70fao', '5842587774', 25);
    t('2041331', '33966', 5);
    t('6te5to0lfrkbabtrd41c8ed0ee92e5p', '3826937530476055398947144233230431055942456846', 31);
    t('3050340627050765676451357427033162550', '999186955807785473462332939887976', 8);
    t('22', '14', 6);
    t('21a1g99c3ecd1ef4a25i5j390m9', '523989361127969369779528855785778858', 23);
    t('bpk', '11366', 31);
    t('1000100101100110011011000000101101001110011', '4721031010931', 2);
    t('ff7d64fc8fjaahccid9d5', '4376819508586761049622784008', 21);
    t('14h', '638', 23);
    t('3591a1d0aaaa14514d8a0a8826ee', '1086505871907198290436180679337710', 16);
    t('a0i75f', '605510835', 36);
    t('3001102543', '30288159', 6);
    t('1233', '111', 4);
    t('172013616177746634055145614015', '295033519224308286956705805', 8);
    t('24431111223333024222441130311332234341', '217260336465598947913555596', 5);
    t('61871645566813861858843771', '4465139885288479008513037', 9);
    t('2j99a2o6ig6kaenpr8ccc213o21ih', '236072821902099878272860191254755048167320', 29);
    t('20c82rj842r3sl5pngg1m30s1ns9lenblg2q2', '302235546226118472645257056192337633007044068331744582', 30);
    t('3bsnls', '113139388', 32);
    t('5ge5b00f1', '219154999267', 21);
    t('67542hgdflha6i6kgebk306l8je3i29j71ifad', '295779061503259490861711170029814187601403466252005', 22);
    t('2ci8om31pwctteuy619olu06813', '68305183746720942432677368181624371607079', 36);
    t('uj1f', '1201133', 34);
    t('70dd4ece07c4cadh88eg571ee00671fh299ff', '10902617491709320295309665615607760573150022665', 18);
    t('211133412100341030430344024122400212340404224043414124314044343', '48876580902143767369888221969372524247409348', 5);
    t('g8eg08ah1', '279586301292', 19);
    t('11830geefc83b4b495f02', '40418107783678577959278312', 19);
    t('g637b29bf9a', '32991498472403', 17);
    t('4f', '127', 28);
    t('60ahgkhg', '20498279068', 23);
    t('807dj3ia477k6540b2', '531044090253007204514148', 22);
    t('glo1dnold5a6fm1nnnbdfb0mrnjh2obi0nr', '2789545609120026862639750879216157236162178740596717', 30);
    t('20551660343300260022603032344543556365661', '13481349525083560101951990618981076', 7);
    t('11111000100111111001100001100100010001100110001101000110101001111111011011101010110110110101000100100101001100010011010110100100000101010010011100111000011100111010000000110011', '93021064714003304999209676659750808550526701882548275', 2);
    t('5ed', '1696', 17);
    t('21231203102002032200322312100032102333310033312230121202021202211020', '52875735012335675083325403253481232804168', 4);
    t('4a9g6d3285a0f71', '14592320917794115609', 21);
    t('2rkjar7bcgfjapl95hikel9bhpd1q', '261692392820668064199561442410427511575031', 29);
    t('v', '31', 36);
    t('870l0talhqlbocuut87rmnht', '164639756154616554672312658123494939', 31);
    t('166gg5cd', '829405561', 18);
    t('111111011110010111011101011101101101000100110001011011111001', '1143454535228004089', 2);
    t('7g335jhjiaeef11cdg9cigbd6cl7g8mk14', '6661914066616801000688433796989649066873498685', 23);
    t('729c210a63g9a0b87hb236e1e9i7095h3fi5a', '77328303793071910139493127832503020470265247731', 19);
    t('111110101010110100000011111001001010111110', '4306578150078', 2);
    t('270fl2fj7g06jh4bfebb7ad', '792003659981720720802552797405', 22);
    t('123240341121241110', '1176945883905', 5);
    t('609af0552gf9977067f10321ggb5067705e0gfa9c', '99658853369916214404971432082520573489936957319371', 17);
    t('3di3edkai068i8g0850d5dbj7b3', '914473354161724934676796320329532991', 23);
    t('60072304104', '20955430219', 9);
    t('9a3lpoi5h902hn8bodq', '3617529642401747033698699016', 30);
    t('283k0224f93f440chhidef1g7a66g875', '232905975079915676784494113568223597432899', 21);
    t('43010013142634444066025411', '5942944657464057117855', 7);
    t('7b1504d695414bc4b3367a537', '2597305124184055465506755532584', 17);
    t('a03d', '58387', 18);
    t('75746114788229445253810814861417162069', '75746114788229445253810814861417162069', 10);
    t('1517a25680a7a55381b18994b3204a13035644130417cd4', '71951788846356115851868854226027470196598485964814850', 14);
    t('ldxw2kod', '1675994868013', 36);
    t('cb7427fibhh580al3cbjh31d28960i', '10658187116944300172792431427417942701250', 22);
    t('g7dew', '19240946', 33);
    t('8480d1184c0264903c99019ba79a520', '201522207278301179690568435464536016', 14);
    t('13233020022320110000133221210031013222033313331121202132', '2510595482396899974505895592040606', 4);
    t('32mfbd43s65247pmjh4rc2okq8d5klii65l', '163041687824253430655263510014482606677780918948782', 29);
    t('100026126125431453044406321032314335211606643345035545012516', '72661785003425012140588523563139272506535099051702', 7);
    t('1f27p24anjbgrc', '15595560185780589258', 29);
    t('1ks2s86798bq3049a0ssd4n03m5l3dihqg', '3129227003843513763551368915590401778246667625712', 29);
    t('3', '3', 5);
    t('3ba953957', '1716304531', 12);
    t('124014322013143030122204204203124343100110121402423233030012244', '33894391020518795695192912235400479381094699', 5);
    t('110000100010000111110110110111100110111001001001111000110', '109286979318617030', 2);
    t('58166441445415768526440246567887125401', '1198377845109548748098572871264323582', 9);
    t('cb5bgbickjp7a3nadiw', '26576898192662296489123461908', 33);
    t('3b0ba610991', '530965728385', 13);
    t('404413nqd9fiqpnkfj', '16007373449287050500285495', 28);
    t('2121350320201502103345551021045003450201550321400113412420214551', '23539590020554430797855801628642485899381919626499', 6);
    t('53mlbddfag758gptf8', '66187385842518934543061558', 30);
    t('69gmek9m38ie3', '380697603731777228', 25);
    t('2i2g0ifgij0i6hfi3g90', '37935881359797264481717506', 21);
    t('ii0054mb', '195260028392', 27);
    t('1fjfei7b2g5dee5agcg51246d8ah9ib', '1932164313553377614588544011374939339971', 20);
    t('2e1aqjfd3fhk90mj491b49jed', '134908996318227926701481577799370629', 28);
    t('5pr4od8gcehj7qkd2mdalo834k3ffmg2', '12728449099802910729307024798552491911885534266', 29);
    t('2ekdpk4jcpq', '748235759126742', 28);
    t('d50ccg6jc38jae', '2045130355749296249', 21);
    t('3603gj7d46ngf8h94kl2020egbn8fmm31d', '11452231113764962902532730057716103944191773413', 24);
    t('2e', '44', 15);
    t('161654155547445343476406063530377171044513302703466', '2538635569062190223060841428161267358214358838', 8);
    t('1cba2a2f26dfe80b4c05d5f5496b9', '9322511400054499645799889634629305', 16);
    t('10000211001200211120211222122100112200000112110102100102002212002120220100000121020111111111', '26448038821401714118351547701564166386304908', 3);
    t('100001011110001110101100101110001101010010011110010010101101110110001000110101011101101000101101111110110111001111100101001000000001101010100000011111100011001000101000', '195679510499172126937950972652289628431931810918952', 2);
    t('22g547', '59586936', 31);
    t('87fggklhhg', '10081601679330', 22);
    t('14loc9q0brmnf2l3pjns', '13453999087631333376321422818', 30);
    t('16b120336097820377102ba1a6530694', '4492294931008813292353818571952848', 12);
    t('39gbh606nqc', '989997953401812', 28);
    t('1dig5', '226295', 19);
    t('1b3ka4g0c31if', '32556633457068098', 23);
    t('36173', '15483', 8);
    t('25mnkqg', '1597959796', 30);
    t('396ddbf310babd9b0124f477cif5j', '36237589250638277361694592995401437908', 21);
    t('101113023002', '51298502', 5);
    t('110', '56', 7);
    t('110001011001101100010101001101000111101010000010111101011011011011011101100', '29161467826175673743084', 2);
    t('132b5284b7468b042763b92848288906579115b7195a6a4a', '669106877176619840691504688183033278062755763332186', 12);
    t('2jbk', '78202', 31);
    t('36547444550627731264507057423205012330760602245415526634143', '91896719045463903069060584567797070657705215769917539', 8);
    t('2121342000144101', '70013678026', 5);
    t('how', '20500', 34);
    t('6', '6', 24);
    t('2r5mv', '3740439', 34);
    t('4cej5c3cj6j6h6a9h44g1ee0', '11865811719145171527617979234903', 21);
    t('1a', '25', 15);
    t('322311222203133013020010112003012001310321220002231100213132013232132123101011010', '5374536559442579875501675621431604976446648160580', 4);
    t('eehubjvg4wb05956wfr89p64b8llt5', '19553077057948292475181539283795939051996984745', 36);
    t('66', '138', 22);
    t('21e5', '25190', 23);
    t('5824gg', '7778723', 17);
    t('qhcic05m', '1392438529792', 34);
    t('70748', '103386', 11);
    t('dd2f83', '14495619', 16);
    t('269a83d0c1e15243ge7', '33557569767693937959458', 17);
    t('217a8j', '35197139', 28);
    t('2nqr8sm3l6dor7l06btp44g3q4opsp7hhto', '466388495687397034337875211314470597167886175645194', 30);
    t('919ha621d52e19dgefh8669', '37530506019880420547749751997', 18);
    t('1pije311bgqvpb5ekr73gsqm3emdg575o9', '229124521801149764060037079145996433176668172334504', 33);
    t('1515502220244213520322244000232533532', '19475372332703870864203147616', 6);
    t('3qep1fh4qwndwwwe5awp06cpsgoffdu69cu', '118279202173747931820139636011582054710456162076665600', 35);
    t('1ada80a134bd3cb309', '54410775990170265437', 14);
    t('8a97823751309916828', '49979715688154191266', 11);
    t('5gb6k8igf7gemfcm', '2870749420792582219510', 24);
    t('9n3b1mjinci0ni8l6gin2f724nmpbf3', '86027429526935179638753640862837929481681397', 27);
    t('a9698129d564ca424d1289a5cd3b641a1a4aa763d8', '1046398402135353288360947832509612205229878640394', 14);
    t('9', '9', 27);
    t('15f7', '23740', 27);
    t('e64g', '422980', 31);
    t('9ca76d75d5559', '1277567401473084', 15);
    t('78ed606o1j8fqhiidi6fkoi83j0n4c3iiqp', '33935317423077288563227681620299054243465830701883', 27);
    t('31cfej', '36322539', 26);
    t('1d5hn9ibgty', '3795546581559774', 35);
    t('22210011201122011202', '3403203221', 3);
    t('39c9ef36fd8d6d173e0dcef1548f', '5958639927430509319986930239964875', 17);
    t('1', '1', 20);
    t('1006602851715538236745820258681874447601432823308065764', '3412333354307507489911392031280207794163602060048483', 9);
    t('amhodl4nfajj525j0qm5px41bsa4os', '2758944573212546785156336043340023815551190796', 34);
    t('1200', '45', 3);
    t('2120040430001210430112021023230112121300222320220130', '1013117983252189204902772113159538790', 5);
    t('11111111110110000000100111111010011010000000001001', '1125213381697545', 2);
    t('14c0jb', '4973567', 21);
    t('16530fa17cif', '454442982820233', 21);
    t('a3a0adf4f85', '20585721319165', 17);
    t('203203033120031120201213113232300022323332032233', '44009547630098010676449502127', 4);
    t('bl1i9', '3334710', 23);
    t('8pc7240lvue8vuq37ywvx34j6ltmfl', '5232403222434712533947020919591570328338399621', 35);
    t('111011110101010010011000011101001010111001100000000110110111101110101110111000101011101000000001000110000111010000111101100101000011000000110', '2606077838126325794622812111329148470986246', 2);
    t('222022012110', '517737', 3);
    t('405934gifigga12739441giih0796c14b5c997ih0', '44130496382894991152875168789677354953126176798303540', 20);
    t('557ad083j4', '9422716142562', 23);
    t('304bdb166ac5edgab3d61e97b606250d5', '7142197345479876851613804398524943471095', 17);
    t('23020170177167056322724056253016211772161010110040067', '217303698775390775219268953665006962201726042167', 8);
    t('5fch', '60781', 22);
    t('rfeemi554rimeo2bt6lwrbe', '70166644768206913891123105929597662', 33);
    t('335a4441544334925626015a5261a88000604774798564', '242132208927109792755852728923466600488607984570', 11);
    t('1110110100000000001111001111001010000000000111000001000100000111101001001000011010100101100111', '18337058785747772841230707047', 2);
    t('j1l6qkgfntjef9vc32oc2g', '772839569513479974919512085246032', 32);
    t('gbi8', '114065', 19);
    t('i3da2hi80eb0ag8d9g912d7a', '1008543268485443569575877596092914', 24);
    t('1011001010011111110101100010010100111110101100001000111101111010011011101110001110000000101101010110111100001110000111111010110001000111011', '486261763761604150405408746183250518303291', 2);
    t('jijd51jhj1j95f4je54493jae2jmf81biaee', '9069209033129880269632627501828625587610894134746', 23);
    t('2hikdk67o4g7lmh1k9j', '39437368888777361305497119', 25);
    t('15c6f07', '22834951', 16);
    t('6581d19cb883a36', '1064511493807102328', 17);
    t('52', '107', 21);
    t('1p0qemoadmtnlgmecm6kbmn74i', '15541937980818601123360827036285747438', 30);
    t('1', '1', 4);
    t('21590025143', '21590025143', 10);
    t('d6sy36', '693030386', 35);
    t('11322122', '24218', 4);
    t('1110011010011010101000111100111010101111000001101010001110110001111110000100001001100011001100101100000010110110111000010000110001010', '9808812004949753301944141481962869891466', 2);
    t('2011346064205340121321043166651212640460403562264030', '25491520237430529777628523147054536052862839', 7);
    t('ucqqp06', '26993470385', 31);
    t('360364043226375763434734203', '1135619094464764138731651', 8);
    t('16a22ab29g6gag27d902i028h5a5h28ij26aa', '91071572231094736409429316734882921398332658610', 20);
    t('16bcdc134bd0175b6ba3c8b645b3a8acaa8653926', '10426556992801999163605089672879387047740400062', 14);
    t('101010110001010111100100111111100000100011001010110100111000011010101000100011110110111000111000010011000101101100101101101100001000', '3638586720469021421571505782203805260552', 2);
    t('140c5a387bc44a4b10aa460b7c7b206a12260722a190', '1042190142619938105857559249577611044384867548601', 13);
    t('796246846337819935321375455889727088', '796246846337819935321375455889727088', 10);
    t('4748365707045', '1366592978372', 9);
    t('18dqnic9l9d8lof0an83jhl8p', '161791385498298856077148137049891879', 29);
    t('e4enc1ry5e2fev5tn0puixpkat5hs3u', '690214300653731249034075248278056601286873317770', 36);
    t('12103332000040255055033214532003', '1809113997459018487166787', 6);
    t('4ov5o3bldn8i98vgsc68wq3ce0j6hgec', '563851485207171383268487747899059744066460463002', 33);
    t('122100200021100200201002001202112012200002120122212121020102212102010020001111020011121001201012211121102012201', '58695548546092379485949598870251325789565837785276340', 3);
    t('10011001012102121210111220101212021010211021100201001221211112200010100222110012211010', '37710977865302705162890164637672855056666', 3);
    t('168f56983', '14994285015', 18);
    t('lmil2egd65k87f', '54272692008795037013', 26);
    t('2335440145154021142020', '57257388878637468', 6);
    t('40101301132322244002210301221323411221140331223132341', '8976324511590349126560140575129895971', 5);
    t('mlg51b99bfc3fbg6jch8kaea93d3gbi31cbmi0', '5553841642984415591090623182299846227471263243529165', 23);
    t('1245412455512', '3201760196', 6);
    t('4503a22bbbeccbec347352979ce46918', '12466951961005062711489205571650902923', 15);
    t('10bfa7f775', '1236461192499', 22);
    t('382377804843587793924059644948380229143271542188852331', '382377804843587793924059644948380229143271542188852331', 10);
    t('f1o3nlnekf8h69cem6ep', '11553871160155818431289732717', 26);
    t('bkd7bkpi1415qbfghl9ifckcsf8sab1pkd9', '616479730153122276188583638809339600885956993018944', 29);
    t('297le48dg0ah3ab203cgge3l2a', '26579580179095250157256986137526036', 23);
    t('87530521065105884', '16387573292942836', 9);
    t('1201111202112221120110012120211222102002021212012011011220010212010222022222022', '28290291045491254023506261936179023326', 3);
    t('3b08l8bia9d618', '3031752476775111584', 24);
    t('902250c032b7g0f89bdaf178b', '3057545841520061381930994706945', 17);
    t('40047350077123034467287624460405518424571', '592212941919593143318170237785813532640', 9);
    t('f6ddad188bhgckedi58jf734191ifc9j7igi', '290294718982610863234917060711053043029223349512', 21);
    t('9kf6g5tphosttsn2i6bmjnmr4g4ra39io', '5112058191839606068411315609839936325831521670438', 31);
    t('17hc4ge9fhi71', '3136930029314922', 19);
    t('e', '14', 33);
    t('1', '1', 28);
    t('19385916362038001511974974352326061606', '19385916362038001511974974352326061606', 10);
    t('994hg2d2dhbh0gah', '64197081894248845109', 18);
    t('acbg60n772m1ea9irebfnqrao', '1305370225928181620545110631536852533', 29);
    t('14233136655362371400640556051237407411322356356326214052664', '36825078122035846824139359498863387810994115321025972', 8);
    t('92392b490301a664', '4006460987264335819', 15);
    t('167a115b4jif', '270081361799975', 20);
    t('1640200513276356713203217', '8561606752326371837583', 8);
    t('6fa8crom2v', '227951526041695', 32);
    t('4umsdr5ai26d8fmvbkvlb2mn2u6sqw1ipv', '636523307570103041146492708259627994295321250393266', 33);
    t('38u9003eaqm6mpnr467a62t', '8353799196317598820195931099074052', 33);
    t('skj4', '1028647', 33);
    t('63u6q9h8p6ahh6bmkb9mj82mgp0rjo46d3o', '9163926831552473156333325816156658696482771840480376', 32);
    t('374181045005367453', '63869760985078506', 9);
    t('gi77gs7t4c86svd44', '20031375747586205082956932', 32);
    t('idgcgg3iif306812456h377f56942aha1h1bi8de3', '26466184663410551722103090587444979074925601227697522', 19);
    t('1n8s7', '1811335', 32);
    t('1101111001100', '7116', 2);
    t('32032002233210222021330301320', '256154294077082744', 4);
    t('21d05e087118154801e38de0d0c9e836ee62', '309359469371419698329028550109463239304242', 15);
    t('7bnkba8727mao', '711734299233608012', 26);
    t('23122113350351205124402523114241022314241152131452310154403', '3446603390947454372499645215833941706110137379', 6);
    t('8fid35se7iqd8qp9jad33p88c4eshmrsn', '1578863152062103440946991148225491469855580789163', 30);
    t('866416783373441066298147461690874873461', '866416783373441066298147461690874873461', 10);
    t('6eq5an5rab06h', '1517176822531587577', 28);
    t('ud2svcuaqq4sr7jrqe2bre2hsa2e', '1324502565529099628698041478533401102133326', 32);
    t('6hm5pp81ik2pf1ii6hhl5jioc', '60893965774839245281672395269677740', 26);
    t('ee7744r3ad7', '6096626264406298', 29);
    t('1q6af87', '2316479689', 33);
    t('11111010111011101001100100100011100010110011000101011100', '70631085671395676', 2);
    t('6bgai2ib8jigfejj7akee7gkhcc', '1653728637039272131322974404967196079', 23);
    t('774k16nrl0naamuri4r0r70cnc6', '4311028221216091060938421206338050133954', 31);
    t('15464kh3m', '184142510722', 25);
    t('a3d7iil0k055ea2e5', '236120447734071099376605', 25);
    t('174svburisi05', '1410646341741070341', 32);
    t('6103526361624161311443517175371632412741737', '521666973443756820065064110478867547103', 8);
    t('103807464250446522257054681023194524538600', '103807464250446522257054681023194524538600', 10);
    t('3j35qafo5is9b46bon3r50k2lcgp', '797208106619573886168214719184124083800753', 34);
    t('kb5tm5ueho', '538338180669237', 31);
    t('gffi08e4l931g4fa4670c066me3pka4h1cgm', '554854175062937340737429653211079158274027725303326', 26);
    t('imsyw1tlimmvc1a84d82mb5v8gi3x', '702689747548001434279373592171391347865465773', 36);
    t('3cbj9ceddch0ca260b877', '1001161473757765639302563398', 21);
    t('0', '0', 35);
    t('247a679c84b4d', '298529370955423', 15);
    t('500313532362550151405060156664016331505660206001614462450', '1059924439122427863447760659387416953643785787762', 7);
    t('21104675576566636070802230712528334778338134', '228886256147665679004281010479547505677553', 9);
    t('nde6d3h4h7n9ndc', '877038302183182967837', 25);
    t('2f8f19d0d3ff', '52291659944959', 16);
    t('9po6he7l23n7b4', '40360148730545473327', 27);
    t('4vrcnav64my', '13539089772110454', 35);
    t('wt3f', '1407645', 35);
    t('2fff4h9i3026gh1397i10d5i8ae6c4f', '652969455080964332999891591145708320863', 19);
    t('1101001100111000100111000111101111110101101110011', '464480193997683', 2);
    t('6203', '95003', 25);
    t('lntorhe8qgtf', '1097991413515091385', 33);
    t('1dd4hhc', '80963249', 19);
    t('41076a3c610cd64', '45272036908151372', 14);
    t('33101330321210100311220302230010000011013000121332133011131113201013230301021222121', '89329862369401356626441467590629208479429264972441', 4);
    t('ow7tdn8yg3', '1964139743090213', 35);
    t('1q60sn55rc57k46jch376dbi18u', '1100010206904531923980306975025572612130', 31);
    t('al1cclajlg', '113737896778508', 28);
    t('5', '5', 12);
    t('36341540646206345106351653034450633650542255', '8584090170028289590539679646753255116', 7);
    t('1102033632151056', '5454472967691', 7);
    t('4c5nb2a31', '496481252041', 24);
    t('396rc6g1r9hf9aabkj42', '10434942490263324352574492834', 28);
    t('1c1', '406', 15);
    t('57rggzfac60l9nrn661pfq10u', '117102687392726624510030956959605426862', 36);
    t('38', '41', 11);
    t('1u2qm', '2034518', 32);
    t('1232053250', '14377278', 6);
    t('59', '119', 22);
    t('66877666510', '7045749564688', 16);
    t('101262042073', '34406946350220', 17);
    t('174406316667406655013647151755454742463', '40406618960600991640852771818947891', 8);
    t('381367303', '381367303', 10);
    t('fdd6hifi49ehhfagi', '4534655080747979804851', 19);
    t('293bo9drjuh', '8235734635761209', 36);
    t('4865260ac23b750a96', '40252545837442207366', 13);
    t('3m5gh8f9eiuii2i29da13dmhe3shrt8', '2045787934668186695600969415825357209406033909', 31);
    t('191803aa3382219136708a9508218', '264262054527282503748967555048', 11);
    t('1444052445552541441142310', '8514868572634010370', 6);
    t('15011400422413113112434241014421043155342445031005101', '53518774664077147625027648928085924722973', 6);
    t('1ddx5zi5bavp1', '6500361914360643061', 36);
    t('1di6j7cc6cc5e9afj9b42d5475hjba4k9f60e', '660940889065923867470806531240107647134213385615', 21);
    t('f6g4828730j', '157087239737219', 20);
    t('cgbck18cj6d30g231d3873had68b2c8gb', '115631796673116218055162703588567020964949739', 22);
    t('1b8g1adag10f', '57508815430230', 17);
    t('43236337121823529354644', '43236337121823529354644', 10);
    t('h59b7989d6c1280ia899ggibf2f', '115923326177989136223953138998174055', 20);
    t('55b585', '1367669', 12);
    t('855elbci61icfb', '12232290116758492261', 25);
    t('qf9s38bt2pqt8g', '1456565460716253297547', 33);
    t('4791940b5c8', '633114739642', 13);
    t('3nb1mukrb', '10289748946583', 36);
    t('2roq', '86299', 31);
    t('2j4m3ja8hj3bbjc13', '17388834727775714756395', 23);
    t('21210210200221000100011011021121122020110102', '854293782429088571072', 3);
    t('121886200777336076581247707653381174765200168442101338', '468460499850199466928527287592120617883229696652094', 9);
    t('63kwnf77bwut56ca', '572752155516297110798450', 34);
    t('ideh4if', '4527221715', 25);
    t('428427', '255499', 9);
    t('ce65d3144a87631c5d8d5e', '64651681400824332635469389', 15);
    t('1tirisssmcieq9jjem2ld4fpd001afe968gl', '9944720592415733461822502465141583653366986082659701', 30);
    t('27564631602344315060464577541', '1490731602885528882512419711', 9);
    t('1112222200201011020301023333113211313222223333203311000', '439439643250765496890620832005440', 4);
    t('ni5m4p3nkb8e7', '2261758525856544683', 26);
    t('bb5ha55hc1j5786c6gi3b0jf', '9701164395793552878907962168395', 20);
    t('1d8e03j1fcgggf93f5ef1c4e4ba8', '224378652645875278576698754063076608', 20);
    t('h1hvj0hqkglm', '1196363266840296960', 34);
    t('345ismnc7lr43jja1e2ff24', '985236942305240622053932671238564', 30);
    t('1e3iebb0', '5501850470', 23);
    t('coa782d6j67noe6koclci6ogoanlbkd9bkb', '4396598624432652113517535536299626773660112648011', 25);
    t('41002112043331422302240214202440223000312140422212', '74671149805376831258756652992904682', 5);
    t('djxmkk7v3s248gexm1gp', '1703151246313896607474774348861', 34);
    t('8646077885b0c2a21a112c29675749c57ab', '635151353519033987553420797933447242705', 13);
    t('bu441qf2akw2gtvd8qe7t7uu', '3869618174244179076226832622786813655', 35);
    t('7iur81phdrrfcnn97u4kkk79tj', '146414973454877334021181536955701659607', 31);
    t('a0', '120', 12);
    t('48ee59e90ac14e8e7c231ce875e6589419a0', '669783568562143349960735984002758784886175', 15);
    t('ge623etu1ob2q6buudk474je8sbe', '1642513449767667629299872543927786786403661', 33);
    t('43c3917a388969c28c304b4497c0a', '66716252264599355808678868874746', 13);
    t('2859b5a', '12788474', 13);
    t('7641714202176443731750235267341521674705251706234', '174307282119711580494340594082900153247173788', 8);
    t('jaf', '14136', 27);
    t('283k299hb26llbgchgb6l9', '36807839785608217611584893207', 22);
    t('33ol8dmma43g9e7kd5a', '45980645590797982073367635', 25);
    t('1i4e6ifai9ej', '1068011337586619', 22);
    t('133300022331010012301000210032002111201200121310122003302323031001133131103020023202', '185626342194041733951899580551736160422093201900258', 4);
    t('a3j87g1mqj0b0h9nj68odofglpm', '166491782431993148839670675364949059340', 27);
    t('7481370241361', '2130975455815', 9);
    t('502e75ea0c6d0c039', '32928634294384428054', 15);
    t('11011100010001001111010010110101001000001111000100101001001010111111001100011101011010101101110001001011101011100011100010101110100101010100111110101110011011010110011000', '1287696114982305806708561003677255537140522028742040', 2);
    t('1bqfb3dfpepng0kb445532e46i2k2plnerbl1', '17866045281194629714550510066941232047098126404456765', 28);
    t('1228541550535432070748521080570353154383164027640630', '5838445704235480390616223077573968603488172323015', 9);
    t('202120202', '15005', 3);
    t('2b15ses6j', '4151154643167', 34);
    t('1oletrcgbcq9b0ol6abg654', '572355626082756700069900296347554', 30);
    t('4d0l4fjnvdebtl12cyjt3', '33268500416963035715332927486418', 35);
    t('21684428648370560244556270286321625', '611004158938408181845575483482792', 9);
    t('22516578301431031712115715', '22516578301431031712115715', 10);
    t('ia8c746a5k698gb0ea0h25', '4186764807821527418737933604430', 25);
    t('552d4b5c5', '7928248585', 14);
    t('9962395855075', '9962395855075', 10);
    t('94o', '9368', 32);
    t('8l5p1gbpln7feh87180q30id4mh', '370245596672569805456573812561788398457', 28);
    t('c9s863pkoa6nm9k271s6agd5936622fij3', '22417592566417395601808617316485913816273476937652', 29);
    t('69jl39227g9jchi7fbh7k', '4550255795481192857394992106', 22);
    t('i3llek5pmb', '98532878244435', 26);
    t('27sr5g2k6lamc0jckdb9mf3l856gei9gc6n', '119857086374419767386831815250826945200461652035528', 29);
    t('5hq2j9i5nw6ohs3hvdoxhd', '800197957325309307636499187015299', 34);
    t('c5d885ldc2hd49jeg9gafaa6a6ke6i6e423', '53787528350697204358419391960520601829238505391', 22);
    t('5llrhq0bim40jagd8j27c7hi44aerb272a7pd', '72355247952723729282010000522046316637619366408542137', 28);
    t('ha1668kgjcf', '463661948026435', 22);
    t('h74bo7h93481mki8i9lj4fe', '98266163081048910410819920612264', 25);
    t('ak75ffj7d38bka4jh3h7gb', '64086606059975639770545476537', 21);
    t('1544451212224143030151322131521234453150350121040114141', '2060205073108919819474425853323987884294925', 6);
    t('740202262443263067454211712735764360631542423775344744', '5483538014645444559676878691527370323481540807140', 8);
    t('6a7de5g426252fdc28', '5472421497078469371086', 17);
    t('5473907070054b040932430b873', '61634926370145594667567575831', 12);
    t('4115450564572527160830368830000012742181361444838505', '19161272032820073281912521629778352968829319565898', 9);
    t('1', '1', 17);
    t('1440410431423404203', '7502669747428', 5);
    t('1', '1', 19);
    t('251460508961154488826737846', '251460508961154488826737846', 10);
    t('5n19ftqpc2ik5ia4shol4qfedbab3erk', '261244167379311148761203476835802681174819715956', 32);
    t('72ia1k5b8d5', '451134854378813', 24);
    t('176cefd755l41g0g4ik1ingdb1bcnhc7c7ii42', '115776909918913879948624420561685892929802962695482263', 27);
    t('122021102223121130311101313331131210010021212203020033200302031213222', '142347927402828237530224283047207824316906', 4);
    t('1195am2d29gld35edldn', '177161953608480500227591823', 24);
    t('12202112022120110102022212212202210000211102022200220200100011122201212222220201122101022122', '50276392565959796508087003591344035380000890', 3);
    t('195196760bb10d797632bc9ab92032ad43540604d99a608', '87971157221742030648612012232857353870163597460159360', 14);
    t('100110001011101010111011011011101100111001111011000', '1343422207521752', 2);
    t('5i0n32cm7gihpgomken4k', '113463368288089227639632223336', 26);
    t('m1iken16m494defec2jim8', '2129732956718515846300095237272', 24);
    t('352754440661731162345175142131150650044732105622163', '5239828571223832230977981455751540869256651891', 8);
    t('2h21g76gf6c4gcb1771hf25c3h37h560fa9d49', '82232560865623068409274522061107609432063075661', 18);
    t('18336631326266747387301843477103751556526163', '208077150063548931141427603913143139920977', 9);
    t('373127070001223103537740007213', '607292123862578721351274123', 8);
    t('a', '10', 32);
    t('2d54e7df', '3408755075', 20);
    t('4116705626b180469537aa157a4659', '80986654674608879103776539438245', 12);
    t('340021440031401103111001314240223132411342323331400412101243322420111334431', '20137295347910978050137678754715001634222372529793116', 5);
    t('153d9792e5b2bd96679de7bbee9f34cd131', '115644794069417523805676707579411471061297', 16);
    t('3kbean5c2', '790686787750', 26);
    t('190e6jhg36c0d', '5946547059732813', 20);
    t('pa4b5ocijnpckmbkio', '54653058302977747314709557', 27);
    t('5191999d6121cd2bdc01a33e38252b0e26', '3305144539726123107189696653194983953811', 15);
    t('630415b975cc33bb4c363b7be33517ea703195a3', '45712578593779552927926495716849553528442516653', 15);
    t('35115035', '1083263', 6);
    t('ik8ecg4647i4j', '139555487244430570', 21);
    t('413gfiabjgci37ggbhj167il2a6lj87k69a0', '1853468167532157988104259516068589250397587101519', 23);
    t('b45grd33e3rgagm', '46026603618605840281332', 35);
    t('3i', '90', 24);
    t('24032', '6197', 7);
    t('14643', '14643', 10);
    t('9mb0', '347754', 33);
    t('13120234334110400213502255541105350', '440476073103983155758151266', 6);
    t('15462416000664444652033602350030142433164413645004054633552531', '6452632018511786950986114433943476403580602805020808', 7);
    t('37572601640375442622771540474365322704464564070', '1382461219874045756706531331920884785145912', 8);
    t('1f6ce9be57023fe14fa060be4c01e7a', '2610723550735662335298250928784678522', 16);
    t('267g342l2c4fqdl4ajeb16073kn', '36667153627913303191726714912695388556', 27);
    t('c7a494d6c', '210541427015', 19);
    t('cs7tw02ho930capsvbscsc8rq8crl90', '46186547958524001279903376963371423125825316690', 33);
    t('1110101110100000101011000101111100101001110011100100001000110010001101110011101000011111101000110100011100101110000101100000010000100110001001', '5131515373500601241098729740846521305336201', 2);
    t('3no9lh6jcq6hj7fnm1tj9f7dql4g8hpk', '23432634258735773139507989470200385544339392070', 30);
    t('77202ccbd3bdb106c70a3c843815d', '927344578178019254002795633520519', 14);
    t('c9g73jc183o36oe5r', '1761650416053970767908743', 28);
    t('21001120111101010111201220221001200110010222102121001221010102020220220011100222010000121001000020', '44909696191691954741895603189242516933740673358', 3);
    t('af8301s', '19182618063', 35);
    t('afb3ej2cjdfg56ce8bea719b59eh8hd6920b6ej', '296262541658682380384776698481582878196565062490699', 20);
    t('1b29xn8g00941kgw', '289012521433739258455520', 36);
    t('2xtp', '117767', 34);
    t('1020112012122220201022201002120000010120100100110211220001222110211110121012100001121012121', '10837637600823066480493206482425734822338083', 3);
    t('22315001431055114221302441100', '14892771054125887454268', 6);
    t('bl31de', '455503007', 33);
    t('1442414261073074545327716347556337315543405616452064022', '9163205510581199876674535919032970590548216277010', 8);
    t('212202324042155400', '37777131521784', 6);
    t('12349640aaa944688139259530937033044', '309196066606488820168555372722983338', 11);
    t('fpgqcforjadl4m41hefa91o5k2', '24029402257540793970931286440247548034', 28);
    t('24102100001234302042410140240312000000202423233343230421014423', '12331802937444045464002527321771813605251238', 5);
    t('11a47138b132881731', '2563461905444852437', 12);
    t('85cb3b8659ac21af1a8', '117256916843717402630003', 17);
    t('530510315641333222253215315131453602302126013654335', '9790111583735606376490411560153169670670337', 7);
    t('10011101000011001000111010000101011111110111011101101001010010011000111101100010110010100011010100001000000001100000000011000010100010100001011100', '54723606892902481536500944335964133487421532', 2);
    t('1637342435475173653242473', '8554147181574260344123', 8);
    t('70b85a374348bb964492a19b784087048003', '418269954707700454074594450672126945795', 12);
    t('fe1d346amod6lrm9ljngm', '5393449861419496363652864244202', 30);
    t('1734425698429208702123875', '1734425698429208702123875', 10);
    t('1mh1lrj86jhfco6ce7', '12909789186113871807459532', 29);
    t('2h45bd450c7a32dfa2aa97f48caebfc1', '12727768324370554279947630389647616613795', 19);
    t('40vodsfi176dd7whnoe', '8678884792879959684067074146', 33);
    t('2n', '79', 28);
    t('3a506d', '2011449', 14);
    t('kugenh9ait4003ra6', '25331317463136730892856646', 32);
    t('3b01db', '5178823', 17);
    t('dmbepcheuoekosb36', '9981424586270997624379758', 31);
    t('3p0qqad0rbd3a0d1edi9qj', '9565860082877068038671133862651', 28);
    t('8xrc11wnvgd', '32677858720142077', 36);
    t('hb9pb74jv', '48841995735499', 36);
    t('2h4d0i45baf58', '60216197692422312', 23);
    t('102003023330021103223132320323203023202122311', '349133714394419821353510581', 4);
    t('9l41ldpj39nnj71m7l51he9idhqk2m8l', '2305496927225468830003959459450437448260834721', 27);
    t('15b74943a22560828b568aa6288a66b7a75', '7370244945567598717283130690155534393', 12);
    t('9e63632c0dca5485e48bee9ad1b5a28049aa157e307', '3703754566336033126591165191492065433661004773319431', 16);
    t('3ja1', '31801', 20);
    t('g42g1w4hpfd1uc3c9d8a20rouq1al7pma0i', '68696270202616562976167194676008006702228230750870258', 33);
    t('21230013102330032330322002201103203321120011301323120113033012202', '824272888453390045291865751777634480546', 4);
    t('9hilehjdf6lb36j5lecb67b10igid65i4f62am', '2366158544165559387606813664930337805770821698614502', 23);
    t('1nkhq7l94h4', '547299336104672', 28);
    t('12d', '973', 30);
    t('8371b0d9c54b9de08c7', '38795452173112617863367', 16);
    t('22g68fg8d03219h4dabfg83b1ee44', '303673527388065638076672857780213284', 18);
    t('97c0c3840dgee5g86fch6585d31a4ca2437c67ac', '85105391259450946493116320690718103848694691007404', 18);
    t('1101001110111010100010011100001', '1776108769', 2);
    t('d5j', '5319', 20);
    t('1a690', '51662', 13);
    t('343432441403012032', '3019525047767', 5);
    t('5kcjujtof3vggbr3pearj3csbgta81w8d1', '725293002341316327093764860114945003565348827512163', 33);
    t('384707362343836408736872363284', '18595584801040647198239186170', 9);
    t('23cdltgf5iop3i', '115711808465236512492', 33);
    t('a34fdfjgchh3c2g', '117542990081505966008', 23);
    t('2631935a01935aa659a8', '14608971021561178647344', 14);
    t('322002310130020410230120043200023330430400213012024320211340432412204203', '147419546263656400907418587687857873288933335663053', 5);
    t('282', '2042', 30);
    t('43ejf7c72d8f8088fbj3bih90f', '1405082153027789457088306150219615', 20);
    t('537377662473314366627013423', '1659910424702725658515219', 8);
    t('8ma60g4d77ogd7gl6l8d8j96i2b5o6bd', '648142815659880474199092122299949894688142195', 26);
    t('d3b35e07218e7b0c20bfc', '15995649127931990167915516', 16);
    t('3002232001101221323200221231313101100103031012231101330120230321', '258826027845063265069952010556344994617', 4);
    t('1qridbfjg80nkda01gp', '219762364301785223184857833', 28);
    t('1hdei9i3rgciqki4kk', '6491983373329676555100676', 28);
    t('3d166bc11', '26294890438', 17);
    t('1325694580866459008894526620', '1325694580866459008894526620', 10);
    t('d6d6bf6dljje', '20197332467018390', 24);
    t('p1ph4npc5ifhk1m4j2f', '1457942038136981020113858924', 27);
    t('4igf', '45333', 21);
    t('0', '0', 14);
    t('35a7757c09cd7a6a3099b0074b1bd0229dd7', '44396742597558682737158855425055583198089', 14);
    t('110540301053', '432804633', 6);
    t('fc1ar8b57hdr1mgek51b1ejaqc3l2j', '14320513748631668139007866084261399565403611', 28);
    t('9bg5mp1g6jbrbimdb3opeq1c3gbajbaia', '191782744327193344704269800684620420221378415330', 28);
    t('17m0rs', '30564838', 30);
    t('2024420615', '82897232', 7);
    t('92ja514', '1350637008', 23);
    t('11000011103131232110013', '21995927823623', 4);
    t('665ca2e5cce0h0763c794b14fg141fbc89b7b092', '57340876399944844035247195611985145713742306546252', 18);
    t('94cpak8nov5n5jsja3gk089n8asf', '913033666774297494496300127790730852112223', 33);
    t('242010412444', '140716624', 5);
    t('12010002200', '1589408', 4);
    t('8228i4a7kke940f9575620j95eiji0elkke37', '85158690741068950560220168929739588599306465964428', 23);
    t('1e9dk7d31g5ab', '12420927280751063', 21);
    t('100000001100000110111101111110000001100110101101000100111111001110011100010111101101011000101010101011111100000001010101111111', '42786787446528052699594039883348317567', 2);
    t('3k486j3c08fhj8iml41g3ga2', '3126146499527434483823713052690285', 27);
    t('bi6iisjvvlnkpsvkdwp8', '1445838597034929554695290655842', 34);
    t('126270344754', '126270344754', 10);
    t('334la43805b6j5k95f0a65', '123931244832514383361412135938', 23);
    t('184920bc8b1a070d606bbd', '1868511579146852493161699', 14);
    t('143031224020013310032213240120330021140214004304320142440', '2671868346315276990910773927582919302870', 5);
    t('4', '4', 5);
    t('1252554a990bb57b4787920719', '1147434430259691058685198853', 12);
    t('8kcn44n4n2k6akh6515m1ad6', '1253494409726106013840668026194081', 25);
    t('358aa040343b6b00c031674257b166cc38b', '257178834697945123965109260345022568295', 13);
    t('c6b6dfbdc40011198bd286c0', '61499113032079803212142642880', 16);
    t('13fufa8rfm7c9', '2629801716449273661', 34);
    t('3nfc8nf3ag9i19b1', '3673872814701266818401', 25);
    t('3166512513354164277266524513220176106234611', '274925189339848199032955327991581849993', 8);
    t('e7mr7pkubteges7ak7qma2o', '18485960290768871891830807896729688', 32);
    t('97mhfmoedpl16b81r313lslfb0d3ahrk55b', '488123867222855086416788166437659651327293157909633', 29);
    t('6', '6', 13);
    t('22bo080907cpgmo24h45oltclc20l4rs9734', '10405451217668484228774583686702481362996408865029394', 30);
    t('86b8cha148k0a1l718kj9hg9dhd0eh74fa', '1655125180972045181280611035879161485328995804', 22);
    t('31h16jd', '455317098', 23);
    t('3575735559093705164576928117947264010533599186', '3575735559093705164576928117947264010533599186', 10);
    t('3fo34cr8cmj0mbfcqf35b5gpdjm9222t4e', '19605601676847494221950277140066486701282651300234', 30);
    t('32', '98', 32);
    t('1ifq9j', '28624111', 28);
    t('11941375807', '30304915736', 11);
    t('64246753172171466452551711206021704632', '16980787914168592911515222526101914', 8);
    t('33220020032212223313011322312310220032221030112000101110003102020333222112100', '22303612305914145667368014737273431444860872080', 4);
    t('223', '63', 5);
    t('954', '11204', 35);
    t('c', '12', 36);
    t('j24mdeul5i0smbejpbg2mrwscb54wwmwkup', '600423386348711943943690378212372893459687681945626950', 35);
    t('bcd6jjlaab9jiofb6f6h6ha00g8', '25537871091880597881403599806322266033', 25);
    t('37s7tn0f6ig9tnk7c8c7rffc4q6m', '24895596590360112154229623928710499351602', 30);
    t('19751b6963975970b57bb7b746997b245983192a2', '26479394819881134034901962063085314419077978', 12);
    t('3', '3', 4);
    t('1043010421003143134023441324323114202400040000334203121104331321132402344242', '31350194075596081385648272410035836892718252280903072', 5);
    t('o4sglc4m9rcnj310m9nqm7611lrmqe9eo', '4477835046237745517249653886244954948658609046544', 30);
    t('ncdq', '918332', 34);
    t('114840453324568213742188', '10388126375431293821606', 9);
    t('1325642', '371618', 8);
    t('443111423431241321342101131402240', '114790435587670217450320', 5);
    t('7lpgsaosisg8arkmbcbd', '304282863628138208061599101293', 32);
    t('7ib76c6p3li2cj43t1dk5au5jlfcd', '57375933993952595073463711388407424935224025', 34);
    t('191e2a6lkeb8bjf5adi691', '132925541528054151438002596441', 24);
    t('l1aqdbjq69jatffbg8l587cb92climt', '30031891651603255389418074895566086243934194397', 32);
    t('40852838842682255543932763748781364902234498', '40852838842682255543932763748781364902234498', 10);
    t('10fh318cdcc5d4f0b418c8b6d8cdca9', '47758452381716675478875781477650034453', 18);
    t('f34a', '74640', 17);
    t('4511565631241654652431163010554550101105031254624', '173977603700328524810402269464951078727230', 7);
    t('5e7545h2668b5ail52a137fa1f', '20545488673771633172442655662596037', 22);
    t('b', '11', 33);
    t('327be62d5', '8119207775', 15);
    t('4ejfrjo1u91wnrwq7w30ft3wrmbnukwab9', '573523620056731492643942313246303569824330571405259', 33);
    t('127009363602697407785107082524162100683', '127009363602697407785107082524162100683', 10);
    t('1011', '31', 3);
    t('7cf9a45c21858e891798ad503930df741b93f61f127', '2922422513262668930583564242609727203228735133315367', 16);
    t('458436820017127712311344837258866175737864032873011734', '1750953219563250455758063124003504566473420077405224', 9);
    t('211112111201200021012000221110120020011101001002200202100002110020112012010202220202112002211102211110111202022', '76207615872454986906354894113586871317110730853497314', 3);
    t('1b77l3r4ano12a6cr7m', '1672233795439662833861029110', 32);
    t('pbc7jaab8ch0k0lcm3i9', '79612608910395590545180311985', 28);
    t('2', '2', 14);
    t('112321002011100100132031220333103333032113032102102330', '116071835591031872355033264235708', 4);
    t('2', '2', 18);
    t('48dfh22ibd8g686d6c7hg729gi2ii82g', '19527034789263406799378911097575104041422', 19);
    t('15p529opb1me5asxv0kvb92dhhmvyvxn00jn', '1282638969189853870845839507929770245008746776925221313', 35);
    t('dmo3cl', '237786773', 28);
    t('46304360250101432053612230414', '2263254868286362202605959', 7);
    t('324513a78b039aa624999b846c771339217883b781b56a3', '5543689730975453400411089215322289389594932504349843', 13);
    t('cr9q5isidqrtldskqr9o9c', '135053305512535595499609893934882', 30);
    t('panmd5okjtjqanieaj3o2', '8842387608432478043445480816422', 30);
    t('2klgjkhff6', '29004353292634', 28);
    t('865jbnbhee9h2kd9glj60', '33205472956554208933300869456', 24);
    t('203141101240402110133321', '25448656205552336', 5);
    t('67h54b429cjd8h', '984366776515330274', 21);
    t('678049c017727c47ff4cc7ba35a849365fd111', '2308152223994224783375970725248611287908208913', 16);
    t('3943a96100921', '12096243472017', 11);
    t('19587422557', '936904834207', 15);
    t('18ldm6jmneaao08l', '1261466197653666390846', 25);
    t('31332131332322011120122300003333100230310112203022023133333110332120213', '4869949642092297086513535782457768257250855', 4);
    t('6ds2g5facl671psmi9kopocsn3bfg0e2', '13996683735002911099235125659493455754164705769', 29);
    t('ep72dck6alenjbtdan08q36', '4657326369780155877897242059139496', 30);
    t('3ehpcnv1qmye2c61vyls1mjif', '76394919330212421657759781891604966727', 36);
    t('bkelggb44g84m', '260736168381814061', 23);
    t('9fijq01aj0ggkb31l3kp5lei6', '515503505760431112899810816546231966', 28);
    t('20iie0e1hede3c4g0c9590g6g82', '3629916012028800240382232462917311', 19);
    t('iobij7ij7j4jag8a', '17675386214341843525835', 25);
    t('lkua2se8mgeqhq', '529292255664993899534', 31);
    t('8d9840', '6765360', 15);
    t('1s5mm61fb3g6dq3oqfnh7dmd', '18261245306493429843745215527871373', 30);
    t('43034020201421421322412203422111122221223143323', '658038361800557817887307737318588', 5);
    t('1n6vgb45qtdf4ikjtj25fi', '131855452845673101428220026231241', 33);
    t('9a9717c775c2b36c6822a', '816836093782779632836942', 14);
    t('kai2rgecm5n316ete0tj61qa', '191613767525038384468665535800253690', 30);
    t('14401013144312402141400421441400330221110202204310', '34846925086734636841681380918788080', 5);
    t('2a9h20f471ai95h651faf460ah4i7', '6777022823748317540045163909505737967', 20);
    t('32j270nhc4bgekbd52k4gmjg7fm', '2394183168081128341140646193748287806', 24);
    t('12mhifvg4v4bye7begu5wl17gkpaaojn8', '27656181148017299182041086613371692124335836981213', 35);
    t('1c499a6b08497', '236220851334292', 15);
    t('59pbjsqeb', '3495838469831', 30);
    t('5fslkh97b6gr4ed830n0hbmbmdghh6poid', '10081808095888046930034956127945486656376182179651', 29);
    t('72b397d', '120273277', 16);
    t('11c4', '28264', 30);
    t('316015042241513211046541', '89387023411491791840', 7);
    t('19lcp7345b4r3qqd8m41l1ljeacij', '118276727933259686532854210784405707429767', 29);
    t('3460ba73227a7b12a3', '28923607142014134891', 13);
    t('1a0uln', '44071607', 32);
    t('2240', '812', 7);
    t('306cbr5cn81802r730gpmj', '31455598097537036058527866355179', 30);
    t('133h', '8016', 19);
    t('11000011111111011101011000111101101110010000101101000010101110101011', '225962873073433848747', 2);
    t('4352590526188669238249982a05a', '622402855647499439865384142241', 11);
    t('1313b872e4f69acbe969be1d71f982', '569050198457789316514154161677419564', 17);
    t('6c6b4gg9675b92af602cb2', '464915643818894184675253282', 17);
    t('j540fcg0b23', '197223400964443', 20);
    t('i3ajkm8f0nbn9ge88', '790683382405880428525952', 26);
    t('e66jfbkldf51lj3ff4cha92bh4i3h76eil', '2850287987851619314988966826056234683936420921', 22);
    t('2ggcrh6e6mb4hbfh', '13215306058649270742309', 28);
    t('89554664174942265124111587a6a7120', '18714353879248606802890337384240043', 11);
    t('g414b2dj', '40369454881', 22);
    t('b58368gh0g80lgi1gg2didl2ckfg04944gl0ab0', '11560775941796264717421207380163035997465478257097258', 22);
    t('f9445c1a', '4182006810', 16);
    t('5', '5', 24);
    t('1526560366610442265035362226254443423206210', '553765118614712852621627633491154163', 7);
    t('22202222011100002002200020112201101212020011020120012222002220211002000210220222210202122020200222', '55842912623697180438441630010534694569956648734', 3);
    t('44a492308724488a0854505895041a0205631753753', '243693813005521214827257950133961142324762188', 11);
    t('elkgaxe0nj7qcd52xc1fwh', '2120609821063037588735605933326453', 34);
    t('1gl23enhegdlhljb5ipq6f', '3926268391749797408627184401943', 28);
    t('2hg7egbhehahcc1f581d1a9', '39898359687999673183300054247', 19);
    t('172347572204054163707174', '1129426023321529454204', 8);
    t('6fbjh157eeid2ej4hidjg', '11454637245507530619115659086', 23);
    t('46a22ebd2d0308431234d1d7a5e799e27394583254b86c', '373239676623123985927471130783407252534116489001507152', 15);
    t('9fa2b1e', '3707379842', 27);
    t('34343034', '309144', 5);
    t('347687508325242200786366857', '22875086492752810114104388', 9);
    t('2e59b1caf7e91g4c9ffdb398cbe2', '4740961834842729902995635598127720', 17);
    t('d', '13', 21);
    t('1d05afafg0562g7e997c26g5142718c', '78434399249593842169745603723971856568', 18);
    t('4aff51f382c09c710fc5302d96b22', '24338029676537462451324711222209314', 16);
    t('2i545e8etdhk8d4l110gan6iibd61n8', '1423893027311604030720414601275162449842291280', 31);
    t('22001443021151101235211245245025454', '668923687080866304933463114', 6);
    t('111111100111001101011011100101111010010110100110011000000000010110100111100011', '300402265535819852900835', 2);
    t('100011111010111011011011111', '75331295', 2);
    t('1opgblfs8839mofi', '16032906358388861446368', 29);
    t('721b540a442b29b6b9a949371705b78076236394', '8794420240219128094357849185522299772425632', 12);
    t('1707337005035225145674', '17427769821173697468', 8);
    t('c169da5309db2363726965508991008', '292974756595688509640864085984168496', 14);
    t('2874nt95970r9', '2602121717242626921', 32);
    t('11850495657', '30108462611', 11);
    t('895990ln1nlaa0o96q623qd', '257752897790289617728328339560450', 27);
    t('8glm797oggo3g88jjgkdn57id06cii', '300975455472025404063790549176072636820468', 25);
    t('374180043761116258361480038233844323506212452340241234', '1438877121553870492092518259559470761109318218910430', 9);
    t('117j8g2g7kakh7e7bcbl0c9k4b65ag0', '19892904511763002652899252931188965080000', 22);
    t('3167272', '847546', 8);
    t('2na2aqadr6ftc6hhofi63m1lrnqn', '21182882506854980579454759175462290060503', 30);
    t('29qu9npnpxs7cadd12', '248079850896649443598509984', 34);
    t('4amr', '106631', 29);
    t('28007349a873a53156493531a8a7104523525a3774188182a39', '32021550905735198309451788837892104007319202888697839', 11);
    t('463511040000003430154003656024', '15885165020452488943863244', 7);
    t('173486', '399846', 12);
    t('133231001202043243140', '166046488649795', 5);
    t('4016115014064440351', '6576217459168862', 7);
    t('9c12flhfo75i23ia4q7pre8bp469dgq', '701074624625567608345494904482202635893993684', 29);
    t('1091hic4fh383ia8bg3034h12df80diab7', '1620628900580902524870029713957325210730956', 19);
    t('o8ioef0lde0bk138gc6agc57i5', '466926356481357301921407566566243000411', 31);
    t('156166233517641635777855368480178700372231307125', '1153782478383987344932810256184711436759925846', 9);
    t('i1hc0f8gdc8d613g31c', '4743234800984285827809232', 20);
    t('353f272adf56cd1', '556923195492411264', 17);
    t('63aj808b1j9i2l3752h2c8f', '2102800826252539448210723171375', 22);
    t('hjl1da7gi3rdangpujtt50pp93in4h', '10531702766622824424209314777731567825942451957', 35);
    t('3w', '131', 33);
    t('95bmloc', '2250748112', 25);
    t('k22vpihhfj99hk6e4iagot4tnf3td', '152675756450524691112514516843247633696893691', 34);
    t('mdg36', '20720220', 31);
    t('10459598a086ea0f535900e70abab1e2ce7377', '362873575854611890806983645493404163992613751', 16);
    t('2376477566636626564635', '23033650866571372957', 8);
    t('13914986769550370259286637241021842091', '13914986769550370259286637241021842091', 10);
    t('11000100111000000111011111010101000010111001', '13529272635577', 2);
    t('5ch4711k39hj9m10h3cc6lm19218k47eh9l663', '1344478086630991461378463072455217839508892798663492', 23);
    t('63459562', '63459562', 10);
    t('h4lbal07', '42968523451', 22);
    t('35417144376113077', '1038983257167423', 8);
    t('2isi9763jab3835ab', '1898862177205082054043291', 31);
    t('1e97ga2aj3h09be', '2823746625228323834', 20);
    t('2gmewjc0nsk4jug3dgwscu7', '6400228217909621185741059682632718', 33);
    t('6', '6', 35);
    t('3121331021101301211', '234027818085', 4);
    t('3712ehigg25d5fcfh191d8f8de5a6f4j672f', '11520281194133048656485798164515576584655890855', 20);
    t('434111433421313440000042101330304314030013001221322421003', '6620016156139174966816882667786009185753', 5);
    t('2uaw', '113660', 34);
    t('406', '1302', 18);
    t('690tmau1brdkfyixuh7h4q0jg', '140340864443150170969873647334684597564', 36);
    t('7hajj8r1e6e2g', '4027528437578814676', 30);
    t('1fk83h78ei', '2081221039806', 22);
    t('97', '205', 22);
    t('21', '55', 27);
    t('13j1oidkd2q', '335135749046306', 28);
    t('0', '0', 5);
    t('2een4crrde9s32jkqb6knn4m0r', '21038850143660963827557680221477657827', 30);
    t('12loaj2940nebcem7l0', '16227765522388241333942400', 25);
    t('2111100212300112320221331022013012032132213112003011213202121110311110231113030323', '13633934239202886688012669467423495607469030601531', 4);
    t('d4d6hny4if4ascj159owdnfl8oblrxlvpty', '413441877376397794445086151818809162820265897964345799', 35);
    t('8', '8', 33);
    t('2220022133231011332120002011022211103321210113011101123030223230113', '14305810169077546460171468395578819525399', 4);
    t('fid80b9icb16gdh3c1ici19eb879f6c619609', '173312570072706487103248993376364065928773435527', 19);
    t('u5p39lqrcw82l0y9dpd', '311064991681509310112389324705', 36);
    t('5788ebbbd', '59674095031', 18);
    t('22322022211100011011323110102123130120132030331132000001021012322', '928020921651814319185701793477052109242', 4);
    t('1020002001020111220102010211121212201202111', '134041409755206311668', 3);
    t('61kgqe6qh7j6h5dmbhcpagg', '187437974023295879369323694043814', 27);
    t('1525f4c59842083h36cch3a6acc92dh', '58487425566031862638196589521131679819', 18);
    t('1323310230013310310020130332222000133132321203003331033322310230122133132213033030221300', '46327786194880935021662331012705260961479696272116336', 4);
    t('1222112121002201101211021101112011002201122202201012001110220211212222021012201021210102002121', '467300445568875369947037784070967420441399325', 3);
    t('8qonvegdmnu0aw5hw', '69568665577613648606318036', 36);
    t('220020120220012211201202201211221022020002021', '2652757109859326311312', 3);
    t('106327541747664237656046756411744551632275412233636062531656', '210781807562814008194311763577265460650228437440181166', 8);
    t('19id0d164f6a26b01a8787cd386i66c3djf63bii3', '16455610792247832827316755327263321154889574099775563', 20);
    t('3763572416255254335772542046235033', '2520123204503077543365320456731', 8);
    t('14304746133086816270030', '1459645652707714950813', 9);
    t('1001101100100010000010100000000111000110011111111000111010110101001000011101100011011101000100011110111100000110101010011010101110010011000011100011001', '1729790364338742795479957074258010329122965273', 2);
    t('13640c20a010754124', '357697310375837778212', 16);
    t('707506qs04orhsrerdppi1', '35973675807994335426304181530113', 29);
    t('ce2a8529a4dchf72i9560j1687i9d', '133351074897666171754903799213958249001', 21);
    t('24e51ifi4b152e', '94621388214723936', 19);
    t('kf2792h1ei6ha1ehfhcb478671l50j', '17617644517562941018851095704171110933039', 22);
    t('1kqn50ronep3ik2as71c', '10506891875702197951637673937', 29);
    t('8fcgm2cc191v2k5m94q3d2jr0t53g6k8m', '12394963354787525293292048856772126140028495810838', 32);
    t('1221203303301202', '1770994786', 4);
    t('11024430224454000050552153331515000154434145', '3405930454233930313833095643386321', 6);
    t('1ae3o0iklelbnlb7a5afldgoog94', '78973134539990265721524279153730463354', 25);
    t('2dce3eb5f', '30433782453', 18);
    t('12201db5b511f9fc661a8225f4f6ea3bc71e884g', '1092702138296823636859142055508527236195490782052', 17);
    t('10222101', '2899', 3);
    t('1a8j0feg5iefjah96dd0765a6adb96aeig', '13077143928228900070839845463145745373845976', 20);
    t('r9354', '40906604', 35);
    t('121024024241140131404411041240331403404323421413014', '128298909408254408631675074392372884', 5);
    t('n', '23', 26);
    t('okpcf7kj6gkaibogc87l755jk9', '5873631648722461721096776636076218101', 26);
    t('120221112021201112010200202021111012202111101122002002', '34341775954281462267693056', 3);
    t('351fbdagg58d05f37dg95b0', '3876964600282154058560351240', 17);
    t('ab606kkfrbm0b43vt', '20450089454749253433872162', 33);
    t('cg01k4h6e8edhf7j4jk3kgg4', '95601159367307880683256564463092', 22);
    t('2313170567182781514845334162722086585', '52943234894452629237397323708821327', 9);
    t('210012402421430434433211224202', '410248229704577054927', 5);
    t('110001101', '397', 2);
    t('230101001110120222121210110222233301023222023101213120123102130', '58839535885482273625594904155393209500', 4);
    t('55e23b1cbcgehhe4def6685041h908g4h13ff5g', '2669182359503479925557363322521478498996957386414', 18);
    t('1fc9hc27fm7f0b9gi05m2k7jaa1hbke0cm7', '33337457252900489495176823888495821992491880369', 23);
    t('1699dd9a1d1861703c0557d', '107958390441765319600724368', 15);
    t('14147e01ca6501f252ca', '94825344299726024102602', 16);
    t('11c34b4ebfcggcfhae2953e13geg0b14fb8bggh45d35', '1036090998997567837002071965020056914329981363019169015', 18);
    t('14a0291a2b388628531aa718388b5209', '3996214153071564773412011127782889', 12);
    t('75362616525327077427633563743155774', '38963888713731612415310433147900', 8);
    t('1a23264b6a079082734834885a08532421930329a553b62', '81150864498278616239579438837878483217874994006970', 12);
    t('452', '371', 9);
    t('144ma40bogqkpeo', '209181900230345710384', 28);
    t('183252c3b36ab7abaa032914698b66740344135b3989', '1296812461469385668481395148233683766030915189997', 13);
    t('n2c24d82a117md8mf', '1841858623472597640997953', 27);
    t('1', '1', 34);
    t('54a73437b957356ac721c801463275c6b763c2c5abac761', '9362287370778203876248441483257901259174776145134802', 13);
    t('3dlfl87mc821m8pjbmts6fpo0u7kpfdpeo6l', '54254596415880694426461637870882068424348153030146597', 31);
    t('4e7f9a6gd97b30798f976c761d2bgd412', '70818459574521833397436206841144875444908', 18);
    t('14', '31', 27);
    t('ai1hkchj', '19562256754', 21);
    t('7968575b87c588b7c80ebb7cab7955a046255', '16663308132245987253286598155041222107098280', 15);
    t('6g2626t1rdjf', '165622971742904452', 31);
    t('3100548104371332670708', '340507102097498147585', 9);
    t('13ec29c517d286454bde140c8c9', '4794553784351603034387761189364', 15);
    t('20031330213232323031021000030101132211210133', '158957787606405250851428639', 4);
    t('213131110022331020201132203013123012110013330010', '48846699476025920364315967236', 4);
    t('2twkozg6fu4c249o5f5zyeec9czwqepc7', '179296745079015573585380066754316589663143881114055', 36);
    t('26a7a2cc7339074', '9938939755610350', 13);
    t('1401406016234566024656', '13862291742387612078', 8);
    t('1a628b5613bb840750538548c20', '1099860000407698314785972483372', 14);
    t('466', '1126', 16);
    t('11021320220101031233302313012032302', '380331316042715128754', 4);
    t('389hf883', '2127638811', 18);
    t('29ie3ff4am2gmk8c3g5m6e21konfgj4m457aaob', '316274860130420327338945579781478121794869214895475611', 25);
    t('202002310133032023', '36554535819', 4);
    t('2d6g', '86245', 33);
    t('3335430431155012310211122333325135535301201033251432425000540', '176432506934097595361072713115592833769129404172', 6);
    t('28hh02ahb827dehd2e8425gb6469ff5', '113785157165293467441651522676088088311', 18);

    /*
    t('lbe799x', '46401410229', 36);
    t('542042344044043434516560152013305605', '2126711221789406518733117742978', 7);
    t('14cc2eih1qbp7m1lcl1jgk9fr46383sm3vjp', '54455663158870289665155251942993016244412111864856185', 32);
    t('301120302123222001', '53029223041', 4);
    t('21002212001122001102111', '74328205351', 3);
    t('6c3b796a99801633c', '4622054283778099219', 13);
    t('527298604', '7643923564', 14);
    t('ffaada51296f61e1e68gcf903', '5403735448335965376083431828872', 17);
    t('470', '1577', 19);
    t('rnail5l1bn85jq8bh7g8ln0kohp9fqlkepb', '1464423638887609511501651149716898849286416176934312', 29);
    t('1eaicc6ocfph097440gjrr', '15465211311476430886891003649937', 30);
    t('456655fiend21i0e618m4mm07bbg', '4955855013263935561852905206907470889780', 28);
    t('10c69ba2fbc7250aba4', '14665823570079359829194', 17);
    t('69971c', '5043852', 15);
    t('1id9l4k6i8hke4n2d74e1d9baaij7llg8gbed', '368762199829326281974893275218436743619213050257238', 25);
    t('5061106542532243626312166650455043365554255346431466040', '22133959010696779781390318938330831551505973337', 7);
    t('5', '5', 34);
    t('42224339b0580a7b7067022a', '27704115985298623082217538', 12);
    t('74c698493dd81930c415', '551457940709438745789461', 16);
    t('1cbi34hg3521e104i1hc729', '22589935080941762817906922306', 19);
    t('13b0q6gqemo3dcj5l06f7', '197625953235284830356426908706', 29);
    t('230e5471ql17ronr6cl', '235869451232670303532443141', 28);
    t('3ea2ijlp8cjmp1', '14315135597535072655', 27);
    t('242172304552', '21775354218', 8);
    t('23705742311920354491610', '23705742311920354491610', 10);
    t('40325421556234466622163363452036405', '220223274809854189346586380853', 7);
    t('ecflnj2', '2776273802', 24);
    t('33509', '506009', 20);
    t('1d01a5hgjl7cbgkah3eilbhi', '11951010251677826156024965580908', 22);
    t('kbbmei7l403b22c80jke192789k1jfldih', '17733393536564264087317496003121331121456941743', 23);
    t('21b45224568eg22ebdgdcb', '144938388338383501238036430', 17);
    t('8d6gezyo1r7kgunyh6gyo3vwlrv7n', '315495151231056477198722506140404177883380675', 36);
    t('22221001143240330002123400003234100102313423234421344304343302', '10831690462680924247665518681482540721949827', 5);
    t('2u62foj1jxdqq58n3dj8ksqkst', '1143893514844433004546634072814737767134', 35);
    t('10325355', '2206445', 8);
    t('12520777811783201841298519685547286', '12520777811783201841298519685547286', 10);
    t('17e8083a944a58d2135204de1d42a2e4', '4404340011548131300800772375526798164', 15);
    t('1118a2416aa6553752761a', '8183802068176534960841', 11);
    t('fj0bbckn6mh7', '24031145125734175', 24);
    t('4mdje', '3846284', 30);
    t('dj0k7665ccfg4fh5ld73kej2gh73f0feb74i3j', '648001720001923293019461828150893010954852476585805', 22);
    t('14443534015344414233131041354', '11049599345097890843494', 6);
    t('35c274a509b72011851c279b1205', '4122336741698498861081854592794', 13);
    t('e0e56b076bdba54babbb651486838bcd107826b1c9', '23326277500217281890367493168426531936362798766289', 15);
    t('2achhbd88bfcc090f339c6dd4gffbe9bc245h3', '72332440899007196422573251018352913217544180617', 18);
    t('aud0e484rtppi5k', '12927724743456282429620', 32);
    t('1893b577b113ca2', '6577012154487127', 13);
    t('150414855', '2005058907', 14);
    t('323614332751473698986062206774a17305686a63090457150', '37696720390064545358579042379279742922532057398473550', 11);
    t('e8', '344', 24);
    t('2e5f2b623ba0cfee63689d427bad6eb6be5', '252471852786048400736119714699808445524965', 16);
    t('79c6i0j6k19ml660j1c0', '553239859980946859861014156', 23);
    t('0', '0', 13);
    t('50030224252340154430425145221531101235', '310311840929542538031369361751', 6);
    t('d0ae9ed728d186863961d16b1222c198687', '126669789677015144972609639930049865196602', 15);
    t('c48dweo2roi3gkg1dc0hum03a6lji3jj', '3626814969878210822526263491353744863308498468613', 34);
    t('34', '100', 32);
    t('118b8a7ac2ea6941525103d16a8bbc5ee845d3d00db635', '92837971948140306642985790446832742660953864264056025', 15);
    t('10011100001001100111110000111', '327470983', 2);
    t('75c76616828b228bd7455c2c999219c236c4a7797917ca', '27940171295879883706960540178285471388494888097624886', 14);
    t('kg179j06cnn1jh6glmrk3s141h7f', '156589475611419217431593938280129049582525', 30);
    t('a5b4480b333', '649859623959', 12);
    t('2991ermf1od46m', '36829745558819094802', 30);
    t('16d5jf82kec707f9fec5df91i9k2b7', '3974871017260808935849561835122343397100', 23);
    t('7287daf9101b1baa352ge5g50a15a2735eaa2ceefh', '20878363680987496322793600785003364424501723901933639', 18);
    t('553423232610330161355053636604102414210315', '257966622392557728002609223143145240', 7);
    t('1geeiakd63', '2121886850779', 22);
    t('151oid', '60097918', 35);
    t('1554db786111ab83632c0c3569728d55', '469086419082028176209975038936729727', 14);
    t('6d2cce94ec843ac0', '218122797689114268240', 20);
    t('ehkhjkfaf33r5n8r5srmth', '303423269013943738843820005454771', 31);
    t('17', '17', 10);
    t('1f0f5867d98ch1aeba8hc69dced97a413f', '487366045647121584986060742937193428723689', 18);
    t('10200011000220120222', '1422685484', 3);
    t('0', '0', 35);
    t('2dfq4gemi4r9llwr0tujr', '5649561877814315213511808712184', 33);
    t('1205ndan1', '224960838103', 26);
    t('2afjnmenha35', '8837961904857363', 26);
    t('1d51ii94186ifc1d5a5ih301h2', '557924059465873457492743606880742', 20);
    t('r5n4g0no6ps5gs', '279088576244954004402', 29);
    t('3j12unn6frsvwwb', '21668993189574689558603', 36);
    t('37knjjig9rjji', '760884044919918742', 28);
    t('1foo8qbpu42m7vim', '317396884789932427278670', 36);
    t('2bh', '1893', 28);
    t('112041514360454142431252232315620204503134442616', '6215681033732759258603480209777352275820', 7);
    t('10100101011', '1323', 2);
    t('22013130002200100013310001333230', '11663208147409969132', 4);
    t('15c19888b148407823b9c1828b344b8c4a4b9478c846078', '2539097207098298474524756002937168478008339494491634', 13);
    t('38100741b0ba7', '32754548919727', 12);
    t('pqhp4un27wniedjg342ce4ssn18kj', '441373172882700032180399107069795794985758394', 35);
    t('1gagg188890fjbc94jhh1k4g0e52', '895153322821681750246160888581105058', 21);
    t('4h319bckj0xomusrreu4e', '19188647657289503363275186769038', 34);
    t('1001100110010000000111010100111101011110101111101000110100', '172896507987163700', 2);
    t('1f2rp6t0eftije2', '2646676016339395366328', 33);
    t('ef2ahd7bgg654e7hh94bc7f1', '3815003844814091481285089876188', 19);
    t('13o6kk4kl8bn846', '125216551882870328787', 27);
    t('33210310231123020200311132220320203', '1149259353017133207075', 4);
    t('114hda3c9758i3f80', '1514391907433723410974', 21);
    t('6f6j846ai9ssd62qsek1a1', '33492652261548954183529841322978', 29);
    t('27724823338b9431001b31a7b13237ab48b41188850a3b20', '1386830760394607501538378708339339174927213150934152', 12);
    t('6jbln8sfg9bmr1gi3iqtmgi6c3sn6pbhbd', '36947529442995940436549729882382448862333593362643', 30);
    t('8764hg81h7h15f7deh', '18379721313637192662857', 18);
    t('811gj5gfidgpeb8mb', '2011069496924051490676563', 29);
    t('aaxe', '405736', 34);
    t('305383c510aaa4228', '6592270467788129132', 14);
    t('5503607200750620360575714717560', '6972513910589491335440605040', 8);
    t('116645642868217044018', '14517737883366084548', 9);
    t('dhahqnlrok4pl2m', '2479775577014041842782', 28);
    t('cpf25ffg8l3p1ib1n8ga96j2drl32rf8', '9394972520892725333788219596291929339951668956', 28);
    t('6kpvicpldai0n7rnaoe9m9x5', '1107286946452408105661642622788152587', 34);
    t('261ifm0bpih8irntbt3enr4isa4bn8l3rtb', '367197720067086066449024042284301785272031948516181', 30);
    t('2032022213100210301323023223230232111333113222333230001112', '46135451060314504303355529120366678', 4);
    t('cekd17j1k0nai35oaila6f', '6512290589845536947166047665595', 26);
    t('1sa9ql0k6vq', '6528811470402518', 36);
    t('2788515c1744b', '144221635071147', 14);
    t('38a52cc273671b0b8b078ec7f7f17102c9bd8c', '1263230489190036409842245570352830262209527180', 16);
    t('66f56', '535030', 17);
    t('197c7cb589c999e015eca97a72ad491c9ad586d019ec', '610090894842715166825622127314166839310002841580622', 15);
    t('2guc902a8t7jun5pb7pb7ps', '3283701567832717695895623064461116', 32);
    t('78655d620287e6db76141a906c5701bdc47', '655497934873142286500331809443840511433799', 16);
    t('4640170a8e173a17c97c572dc4ae', '250998262368302692675285521015314', 15);
    t('2133433400401001132230143432411300', '273762691502915134653950', 5);
    t('147876bd8h', '623895453377', 20);
    t('5462cg16c5d87aadca1f734dce9e926', '1204772766075379104025376180982802601691', 19);
    t('6eecb9a0d2fdd3b9a541f3', '134099742883823958727410163', 16);
    t('gmjc8gd6ld67j1hcg', '205382570774701498109296', 24);
    t('1', '1', 33);
    t('2523014035132512253315120521134522513331043435134415550024255', '141880014505703112137860189697781827375878410347', 6);
    t('11m0cjg02nme2e96a6kdfmoodi83h7p', '3013031187307321824945581807606052286997163', 26);
    t('10110101100110011101011011001111000000100011011110001110101100110111011111000010010101100010100110101101101111011', '7366609054351701610086110120336251', 2);
    t('1dfgb3f7dbb948e856b4a8c2fcac6203f0b1b54egc', '5181812657853529080935299746837888070235867612047476', 18);
    t('54', '159', 31);
    t('mc8b5e3gepf1q233', '525523234314787298854260', 31);
    t('4sisanoghph8mc4r8ko0tclu1hokowgra8kv', '684135811180224801018880221858811529488221626606104369', 33);
    t('d4c232c5h1', '2630171232487', 18);
    t('7hc2h7i1e2b1e36cce06745954i7552430hd', '27076706386804313773324111944537138361927064353', 20);
    t('149256bc3f1g624487', '1048037012773290717716', 17);
    t('102210223032321301303033111130', '334582412443710812', 4);
    t('ypasamqyaijh238', '143737877066768893777688', 35);
    t('6ltpq9plna', '177369251586825', 31);
    t('2f8fa201f5vl6bfy', '352859176463170667696909', 35);
    t('1132608609770787564030397938212', '1132608609770787564030397938212', 10);
    t('2dnwsieep7q9', '122108426181152211', 33);
    t('10729856', '37631874', 12);
    t('332b67', '1205900', 13);
    t('54bd61680d7ceb5beb37894e46599ef77', '1802215542237292717156325458542562242423', 16);
    t('3623770788ce585c3', '22397781910457053308', 15);
    t('6', '6', 33);
    t('1jepg0je5o6n78eoc4cbhchbk1fmg1i5m7', '86673579277719196099662870496657925074641748567', 26);
    t('7', '7', 34);
    t('c06k2k4eb0g2el16jled', '896355371037423667067354202', 23);
    t('3a847dfcee83cd860720c8c0d8b53c7fda25d77', '20879758636120455697847204680129815020870720887', 16);
    t('70', '189', 27);
    t('79526679b2739b383954', '168988259175985567289104', 15);
    t('4c328a9i09ign', '267323824394683548', 25);
    t('eb6n6p2bkhqi2q3d07jef4', '16500933193925506222917225700348', 27);
    t('a78345b8a3ceaa785c69b82b86c47d0b8d3', '101958714004435870099940928484001465270373', 15);
    t('52a1a7655a049a554107197757', '570549577195104508415580932', 11);
    t('8l0nl0fl', '150507080301', 29);
    t('1cia018de01h0gffh28622eada3ie5c55fc7a7', '346689972196368767502452114289967602936650680304', 19);
    t('bc86c2dh', '7158384323', 18);
    t('beb66h1b42h1g6ff', '796506101028725304813', 21);
    t('264701463721526107175255711722057442604571730762750705256542', '541396336231392418293871062570279037186171679825812834', 8);
    t('34d17g', '6164890', 18);
    t('7n5frqj6lbsfoshfh4267b91n45qf8f54', '488443138181884558426267360141962918059414061401', 29);
    t('1bfj5h5mzx13z6slkfsw1mwypqlsmgs15', '83453369282181797046231963508586180290313617770473', 36);
    t('1b668259809mpno6edljmi34n', '13043612843565239822455698795540027', 26);
    t('10', '9', 9);
    t('22b658253657', '1669392598243', 12);
    t('10312223132113013103211020001011302202', '22924085214109545815202', 4);
    t('e8a3gc9b39qkfhn7a877k8', '73337537709170036461394725372187', 29);
    t('5ep0b0q81j7mhmg3lklhhd5joil2qq71qfih', '695418668680819693407024988950834157396053624624518', 27);
    t('7113127129610017826894813814734722', '7113127129610017826894813814734722', 10);
    t('504833417050a175571a00033306070375784003', '207340641858777856714830237467106311988385', 11);
    t('78qc24hl01o32nl1b9obkagkl6f8ei7gp', '149119393785412110406988347201245769764862541001', 28);
    t('fhh78b21', '14250920874', 19);
    t('4b5164fbm0317kei7mh2jldnn12c2ckk', '27325910626851946593723470147559719546669300', 24);
    t('5e0ggb1f199fgbg7hd6i68439bhgc99e95g4g1e33', '8109668848249742565130771662601144027802596607563179', 19);
    t('3', '3', 36);
    t('97a8liq839q2jk1a2ecnpcdnalfp3j6iq', '188719129529654657714378849535242845096426504370', 28);
    t('169d38a3a649737433d7c36863d9ed3c981346a8632c', '538850185854491322031700163636042819763278649644717', 15);
    t('5rc06oo7', '248431717321', 33);
    t('4mjch40iina71khi374n0iln5k75d89', '42256608840244945294489743371747073478088568', 27);
    t('12221111112122221210211121102011120110110220000111101120212101121010101212121000210102022000200102001222202', '744470241433567593087124994714749545239291673387755', 3);
    t('2db9303w76pg3tf0om982eub', '202678684562832691213375034394009638', 33);
    t('8us3ppu', '16323958905', 35);
    t('76eb310380a6f577f166b90d28c3b107a', '2529121398079147937688504401561827086458', 16);
    t('6zi4pwsxbopeuo0', '42901925859461436709824', 36);
    t('4wtm0l6op452g5d0ukfuef6up', '13900763662628056937835621763527325033', 33);
    t('1jnih9p6qjf7546jp0q0l8ckc5d4cmd', '44403896952339670058436709191269479548991285', 28);
    t('d912314e0j7d945', '22041016952382027685', 20);
    t('e6h28', '23816672', 36);
    t('b73dda2c', '3074284076', 16);
    t('264dhk7f', '4135804884', 21);
    t('804274228116773141152427814054250885', '20158575172598902835228115918096347', 9);
    t('23ib3bjdijk8k4bb5410a', '607873769279078604965999731', 21);
    t('a6hb4dbg6e7gm42nbiem972baal8d', '4549058722674037827068667071194505505805', 24);
    t('45d7233ed9d3b02ab1faa0f0d9bf18ac5dfe5dd', '248086945188765744497478402146757696039664616427', 17);
    t('3122203153014053123250405454054141255311243322', '336066208633979782737442344609629378', 6);
    t('4301669926304aa373740a46326790932a036', '132118669959027389980112041611329718317', 11);
    t('adrp', '341881', 32);
    t('3233212220212010212210020020122021312100310230101', '296614965335263805059597814545', 4);
    t('34j62ge2m30kk97jfj2ade', '126716918529588548517026652077', 23);
    t('2dd8', '16118', 18);
    t('cbi6cklacc4qmhpeicgk92l4ecna5dio49294', '155480057705826337198133385077759543587893171560517344', 28);
    t('1cc9', '38169', 30);
    t('421625631535034357267563', '2525290811852796555123', 8);
    t('1qj838bk869igobhjoc', '115685339404443983601600810', 27);
    t('54cb071386a641e2036589bd90e3d49a6d6b7a37', '39240766526100951032727242882830164365238920302', 15);
    t('2ei963c32bcc9f34g2ia66f91eh17h3', '642555509107905840901107486734813888017', 19);
    t('57aif0f59', '293069958531', 22);
    t('21066a6d790df66edfc', '2982109405734959108902426', 22);
    t('240789669949708542904a12267392', '3758762420368146985528482557394', 11);
    t('3766050301207656231423150647646364447', '1291785946520991837632125610879271', 8);
    t('151310021205105422405525412313052003545043034123332302', '327490019360437760098446140776026159705902', 6);
    t('1df4260b790d60490a8gfab1c4cbbgg12', '4303564154827738667782109938928048999136', 17);
    t('145066c034296c1', '14572212708973081', 14);
    t('2cm4jma6gk9', '727710161344441', 28);
    t('270423591a8477593a978265860659850482952a2629a', '17490584572350116403287038674890859126167019559', 11);
    t('8brgm', '7742334', 31);
    t('136q2', '1301126', 33);
    t('be2b9', '1873029', 20);
    t('4o23p0d6an', '37303140766586', 27);
    t('srf62prb7tl7qk7t73dte986otnittnlkca', '43189112923977571782711948149497678772791160765862282', 32);
    t('110110010111101111010001001101010001011101101010001001001101111111011', '501483179338306460667', 2);
    t('7agbe97851ffc36f1a99489162b52eafb5', '307786361732642783601055064914331084965166', 17);
    t('9401c316a2c5708b', '476467776395576743', 13);
    t('48217637502968090', '48217637502968090', 10);
    t('3fon0jpk1jo5p9pgr6f4c4pp7so6nhd95pb', '588290809092568702675103575771741647312948810878261', 30);
    t('702dk92kdad23k6ljd9i910', '2391852600323744303903407333754', 22);
    t('25dfea9dgg42c49che64f7bc8771idih', '10077817429629058832781708059900951083873', 19);
    t('5dc14757bb61aec90e3143c2b14ee', '5045511542117661075208474024001999', 15);
    t('bo6k19juf873a9ibk5t09fgolpol9q', '209254750018939653487646684289205340364736495', 31);
    t('7', '7', 19);
    t('eifh4b0dfheg19fbad12jb', '87013738359168431501653737926', 21);
    t('mgjdhbaaih094b46ojn80l', '5154851507795871179377927708146', 25);
    t('2go8sf6in0img386olmhfbmblrop1e08c', '161607556749841399584405686305215260945437777544', 29);
    t('6', '6', 29);
    t('7mpkn8g3o0j9pik6fa3ib23n9ia9', '1261958045881925421127437894220522481101', 26);
    t('212231022023030131223130221120310223333', '182782071163972676176639', 4);
    t('2613203210505455264415513332655241663040344635106556455', '12467081099669883703235113908035091968240448895', 7);
    t('1630720467054635751474753253627460422', '583694432446675939525765785084178', 8);
    t('94hejakd137n48k', '342285102160921065220', 25);
    t('167od46an4pkpsi3hl9erab6fcb7s0ebnb', '2208752247116288312429398287096265138047341117708', 29);
    t('1a6kf5n4jb8fdfihm56km4183mmic', '632147076529030884714528591446221784892', 24);
    t('1160605164826248954349876602042464161647577454', '1160605164826248954349876602042464161647577454', 10);
    t('hc0f09', '33387237', 18);
    t('3964660993859239689981872620682101954389246037065', '3964660993859239689981872620682101954389246037065', 10);
    t('3fd278b8d795a', '1122771216988506', 16);
    t('0', '0', 22);
    t('12a572492dadb4c41419e14e5e1d3e93689a410b8c90', '440134561263388299663890810636098917176789570414835', 15);
    t('3cat5h5ksknnnq30b2scq', '2283068063004048177101847374756', 31);
    t('aa58b190195b8a2b242c856', '34697005906923003886801890', 13);
    t('22v0inp', '2247117561', 32);
    t('9c2a9e3dc0a71', '1273077348403606', 15);
    t('if5', '22580', 35);
    t('l9yagt4k1l7sppxkiv0bf', '161971068528812396345997940762650', 35);
    t('41opx0v48cr1gj9uvnlpufako9abd80q5w', '1400711475411842935054148452748722383058297214051090', 34);
    t('66odf78si3pdk3i63forppb1lgll2b86dgr48', '276206081640004784888361976308196895753527959765633826', 29);
    t('6ac7e0cd1808d2e6154b93134ecae5e', '1289018068112858182387369331118635114', 15);
    t('310111212000103', '878075923', 4);
    t('14555f77ja2h486d', '39752861388169155333', 20);
    t('140102440103002143132302400040001223232103134111223143040111130223220401231404', '1197061222107197331414639288099046337494969650509398979', 5);
    t('222012020000022211112012200101011012112200120121', '77383589757349523721532', 3);
    t('gm3hjn22oors', '204516082482475075', 29);
    t('11001000121202110101001012000222012001212201210210110000211222200112001222121212111021000', '1305279370208619893883805792602512582417319', 3);
    t('51b6c7a9820878798897', '7521848979002189462794', 13);
    t('2584a257', '88684771', 12);
    t('9622831859834a72a75a2', '6434216029758043315681', 11);
    t('10121110102012010', '51794130', 3);
    t('95607761058a3876984a1474768133331', '20067921113189362115162324154987500', 11);
    t('1308584667613a4a2a51451862', '138590144081857578198409796', 11);
    t('303124303051000610137231406655066133635770174121', '8500626221290107216014710817942733884291153', 8);
    t('3b1j1ea29icf93e1h52ac21db04b9g', '190851477248266851912684038197347236596', 20);
    t('b7b3c9a57487c1c39c51a44c4884847', '30405998793962949996970230863617614', 13);
    t('23956aa67a1c0902a7142c5a42a289a', '5990721395892835344544973452522160', 13);
    t('n2dro68c276c1ao36m29', '500136698154468954862520957409', 31);
    t('mgh9n462o2da6iikmh3b2b2gme8mgoci', '491530325873995573329061908191309647059640318', 25);
    t('4l38xf6', '8460907706', 35);
    t('d5f1ab1c85421854', '201983925762344371011', 19);
    t('6272990055345011144532205391668424858014', '6272990055345011144532205391668424858014', 10);
    t('127il6blnag6mhokrg42585i6feb9pj6h53lq0', '379103572560507898585828059072007254689097272767096168', 28);
    t('3b62hnjnf2ag543c5eokdgllejg8kkf59hicc', '730518050516683388784082123629631983409244437386562', 25);
    t('8nnheh9l0906mgjb00cjgggg4inh2k3b9d', '31709631306533183931103075528584558673938676645', 24);
    t('132', '132', 10);
    t('3h3e4c00eiih1i5eebifh2h4k4b43', '40175422326439172482436371700536055298', 21);
    t('2121434132', '4483667', 5);
    t('3gse47h8l2j25172', '30940800974512039283108', 29);
    t('341000443044511215010354204103', '136127973237647033674695', 6);
    t('778da0c24f47774967183e20f8b1827299f', '650909720313013143267150228395755917748639', 16);
    t('qb564jneaor2otdhc68gqs123cfuk92s3', '13948377585746116315226679137884300625553492956545', 31);
    t('25ld', '48425', 28);
    t('gkec3qp6mrsi5jhjmef7no', '174506635997402423118687087352014', 30);
    t('3j', '109', 30);
    t('11211102100101100011220020122000121211112020210220222100102212220202011112102000210012111', '1561458763443428746693446798877497187904716', 3);
    t('145454052052432542224044220140403512204050112451433414045020354033532', '150096937333395628734778900213563908439843747504734720', 6);
    t('10101110110111001100101001110000100100101001011100101010111010101110010000000100001110', '52848936898297944277057806', 2);
    t('5736c9b7f9a', '32971047415618', 19);
    t('1674507585', '1674507585', 10);
    t('24hb0b4gbjf7cgj8', '73527411112945222788', 20);
    t('1al5bea9j3kd3i3fb871eljb13kkk043gc', '1275824033146566143960476806758461477943738798', 23);
    t('8b2', '10766', 36);
    t('ba6bbb26802b2a8a95420b97781a2058791572601506226', '521464466313915762537835346317353826045525484287422', 12);
    t('110100101110001101101000000010100010010010000010110011110111100110111001010010111000101100100101111001111000011011100100011110101100111110001101011011111100', '75247462135135296147483304900271494532907456252', 2);
    t('1113562110102132653505161654522056473771101354321312031', '6710609582342689120085581704302230873683253367833', 8);
    t('23400502', '44933836', 11);
    t('228vicgd', '71168504333', 32);
    t('3003414434123423022213024230441220102414322224430411', '1346050865149295997081509487231483231', 5);
    t('m30phl4khx84xsj34wcdqne5itfnjjtk4ep', '259691039455794091563131654919327983964194791661478421', 34);
    t('22461a6cifde', '432283541270274', 20);
    t('1464600512311275', '56401597141693', 8);
    t('2121122202120101111210020220210', '538808295256851', 3);
    t('3330012300031114401330014013441', '3464973034967461079246', 5);
    t('550', '660', 11);
    t('33020323332302311', '16256068789', 4);
    t('1dlol893q3853m48g92636r414dg7', '49459728783752884863701490260561300521367', 28);
    t('6bmb2mip8fhq6bghjd78', '10108171592176668723712485818', 27);
    t('959m42ii3jc', '878888942861737', 25);
    t('1063bg6bn14mfk3e3o1', '29746944359805875726720509', 26);
    t('35261605356', '3938913006', 8);
    t('4bf373d19052eb5b393b58', '1068860929333821354151303382', 18);
    t('752a4gp58hf3pog9mngpebo2', '13831046927668991950153094727269842', 28);
    t('4211', '556', 5);
    t('433500525', '7737317', 6);
    t('4gb9ad76g2d4af481022d256929dg4dc87675', '985133603874828141261886573157932023568227394', 17);
    t('1dpn0de8fbj6l2ckd567ge8maj45p2jmfo', '76060515087749557754895067969401915547233012014', 26);
    t('6500d', '413709', 16);
    t('1000100111100011101111100111010111110011101110011001100111111000011001010010101011', '2604661372805165686559915', 2);
    t('759oe0fl', '156973518471', 30);
    t('4h2op13e963hnhn1l', '369608946272770491801516', 27);
    t('et76apcban3', '54151698158762655', 36);
    t('85a47b903a7', '50835737401094', 19);
    t('70b49g9382g', '25117276340860', 18);
    t('6816593j79822edi3h7jjbaj5i7', '152330705063267926722130069067111965', 21);
    t('8h50j6cji851dcf3c90h6b', '51537232193150669639514304916', 21);
    t('b1uvn6m8cvfd6of', '67867262563984521850383', 36);
    t('122221233120313213321122322320210031031', '125861429895573339784013', 4);
    t('2595gh6a7628705i332884f51c9ec', '300353510882507195422219641808364360941', 23);
    t('200212120111110221202222101', '5330324508112', 3);
    t('15iji6dk13d61ah4a91m4eecej67l2lac', '47125646686754897581267667193187325517140225', 23);
    t('12ho', '26588', 29);
    t('4j', '115', 24);
    t('110000000011011011111101100001100000010100011110111001010101010000111000010000101110010100000111000000010110111011111001011011110111111100111101111010000', '8573066822280330509997029656969204484303387600', 2);
    t('3e58agf9190dc826cb8gige5hc', '1246066562583123755485476924274352', 20);
    t('3706961c2b', '5952582721395', 23);
    t('106502144', '6555497', 7);
    t('3451a499a56354705154686763a3a37138', '79114710272261003126294782198609671', 11);
    t('9p169c8ehho986chmfpe0', '420843323139258346157240672220', 27);
    t('14eg266a', '776416222', 18);
    t('116502640400620343322', '102138755603486562', 7);
    t('28355677004068874128443313', '2106070737272795731626021', 9);
    t('nqel8nnfk2e99k3id1m1kf299h5k', '10634808758829298719295188434620358556776', 27);
    t('i', '18', 27);
    t('501514303011045351151043045025413430140043211223124', '4083661748572002344042581553196268202332', 6);
    t('51jc67gtmj92p0rqg51w', '1096729190801416843188189049067', 35);
    t('5a1bf29425c38c8f22a81fc3f105169ce4907acbb7', '131694699796400245476746024523885969905255483886519', 16);
    t('c2a33e', '22944128', 18);
    t('7f5a8b16ad9c9b6gbfg608186agf38b91', '115776634518774027784211063476397070420703', 18);
    t('1e946da5ed27825dff2', '9025563349429600509938', 16);
    t('8856957692761177368973855070651649a103aa', '360994117177708368729629428077578463699360', 11);
    t('2010211102200001110000', '22404845025', 3);
    t('5379a6cc3748', '9456611769938', 13);
    t('3a4b04cb4b528e10c566a180c9477c5e10d277318008', '1376197964280137220342614148681543675554523110918258', 15);
    t('8vs5renyzluyc8rl34fib3ui5wppiggae80', '729183516825929850436740277863751712823686402504398464', 36);
    t('5827701587706499416955', '5827701587706499416955', 10);
    t('42591fk220i9', '2396927578798245', 22);
    t('oajpedj1e17q5dkge', '1946120213098978975238603', 27);
    t('1111000010000101010011110111001010001110101010010110011011010110110001101100011001101001101', '2326173895977887311754310477', 2);
    t('7cj1ah4n4mdde4f', '483161982916646045703', 26);
    t('10hcg8f0c722giai9cb70fci7f6ag', '669672956840092248394431297216875488', 19);
    t('20212212102', '135497', 3);
    t('52d16bjjk5b2gkghibk4', '164105040092908202550049352', 22);
    t('5a5c32b3b39ca1c272c0aca32025182b0', '2570064118523150975450771620831844886', 13);
    t('23d288aea4', '153856028324', 16);
    t('116050533116030', '859603851575', 7);
    t('66ci8if75644500i0f23chdag341fb59j49', '1087881863946554468036969878132901480676079689', 20);
    t('6384llfdke9fh5419hlg93b', '34862705286427416058205496740086', 25);
    t('d0frhs4ruangmm5jhp', '293524371757655532307398620', 31);
    t('1ba588dd51c1235d25d2bb97ddc97300050bb38da27', '2522944524206913556204355519010579773376112207235', 14);
    t('ae5ffic9a021fa', '452195817972105538', 19);
    t('26444016101', '833900621', 7);
    t('33233113022222331113010', '69225388168644', 4);
    t('4bdc3b2b93e8cb0967b92', '5731840537208636428417938', 16);
    t('102jd5j8ejebfd265k0mg833g8gbhb', '3107718466423767292009122732909038798627', 23);
    t('74difk793cb96h7c3d6fl7kjc', '3457816970788290910213733483049600', 23);
    t('30221001210002312311001220210', '227720131173947940', 4);
    t('b6ba0a739c89b435660e8134449e3060de60', '1667517158964041521729990635459641284368990', 15);
    t('df86plbcntpfs51eje4nwg4ihv', '1235835514259777075839888411102059589165', 33);
    t('506132050005635323464330614633642404063404361136411512640', '1084754468050903323226297755149960657030618207525', 7);
    t('12202000222102211212200220', '1621734114201', 3);
    t('51j2c9b1085a5b98679e65i0gg1', '406702206426087714623273688096310561', 22);
    t('22g1e05fd98e04', '21526429538375015', 17);
    t('152305713596150626771408a7766a35065348310122012', '1181335871352138289886257270048037267074936415136', 11);
    t('10717758873411', '2768061987676', 9);
    t('85b83816a07b493083721288', '56296106638600534110367304', 12);
    t('5j2bbmeba3gfeja', '121922415384534240082', 24);
    t('8', '8', 31);
    t('10277607558022478675857166831738961', '10277607558022478675857166831738961', 10);
    t('101010110000111000011000100111111000000100110110', '188077030998326', 2);
    t('5kpm5tc', '7270492758', 33);
    t('2506a714784', '63800374554', 11);
    t('34043042242013301344041302332230031124003430303014131313322004244', '2080090103990504899666426994140445994059953699', 5);
    t('2263011b5698730859524510806838b7aa365bb83863b92', '96993840751786125665886676025172179431233429573854', 12);
    t('m6m84kdc', '75938273001', 23);
    t('38758513458382788045178062860185381467215842186888002', '166292428083754702524723009147547249346798940043838', 9);
    t('4bhnimqepln5fa16g', '630260532539082351528008', 28);
    t('1555100535210245322041304141135342035015443', '960612721329969379046956918521267', 6);
    t('18b984126ba54378a409197b61b33228772b5b4', '178481932192815614023496736965622010377112', 12);
    t('85c3ec713a41b3a91', '55094814325358219386', 15);
    t('e45', '12725', 30);
    t('460844611766389887ba8ba4a2b211079714', '266086624761556754577648371384666605504', 12);
    t('225624015211256062001324334062320', '2657607429475613454644488243', 7);
    t('686i87fbad4c59a8a6f7da1abhg', '510102928348460205068613539295917522', 22);
    t('120354645453413557275444611571627313424176417756144520333753', '240836899455748097083887093250256470467559683019356139', 8);
    t('3dqg99g70qop9ie', '384933516113618232755', 27);
    t('h92ioci8loamk', '2602196299100018423', 27);
    t('3', '3', 12);
    t('1473631257945483', '5949114354201252', 11);
    t('8aqne3kd8mhhr0k8b418473ei', '1048637133019307092199604836008301958', 29);
    t('20213', '2673', 6);
    t('1gi3ib2hi775h58918', '24189219409084535267628', 20);
    t('29dc54fe38ig3f5669fbde1ij0', '833503078428796826688762347855580', 20);
    t('1325d509c65da973839227b8c5143d6c43d993cbba7b5', '329881289130026584178299136878593170302229089677819', 14);
    t('14g49i7j7fe3cc7j2c17jg7bhgje4b3g2fh70i3097', '272802468690487870109445646857507298063115670210904187', 20);
    t('1c57b1', '1857457', 16);
    t('100hd142c72ef166a6h9h445h', '4911395571502197789470629148686', 19);
    t('8piopdl60m7c7p3hmlpsb5kho5amsh', '156766692402888022009790158482742306168035518', 31);
    t('124b6bb98c1280c5c053155cb58ca9a7b', '523703265361788077644933507150951633', 13);
    t('15dgfi8756e5647c3h73be76', '335597289586138002689108049036', 19);
    t('123c', '21234', 27);
    t('264453362706666107438146787', '17589366337294688071335514', 9);
    t('1000001000110100001000111000111110101100101010100100110111000001000011110011010001100001101010001101111111010100001100011110010100101110000100001', '22684678246378182819785716745165465876847649', 2);
    t('1fcgaha8g23db586i49ifd5chc063', '1165185085777837851964737766554067371', 19);
    t('7pxo', '331929', 35);
    t('f68dg44m5kp8gpn', '1666876518883127367662', 27);
    t('a09281016407aa888667282461b42b069599a9a', '1027211842920428183779353394595382499256278', 12);
    t('on2hn9rpaemeadihgljn6m54agjhb045hdah', '11102396046178622275186103353743351877958935735136185', 28);
    t('11k180j1fekgi8sfcf63gfdhnfghq8c6hbkng', '46875230493473105664159872712226948600083973055131500', 29);
    t('1a369a2616a711306a6434287723024', '33835620048560993311538138158584', 11);
    t('415043345230010025122031405052354214145335205523543225245522', '35100339098704592825154927338841645808437394490', 6);
    t('1re38adrm94', '587148820026528', 28);
    t('7m2g6oc0lhenclidom2kagg5kfjg4oina5', '106851402006098786130154554561772902036425686505', 25);
    t('332728', '332728', 10);
    t('1101100111111101001001001100011001000011101001001100000001000111110000101001100010011011011100101100000010001000100110010111111010011111000000001000001001011010101111110101', '5097456801022432585476312678303126165684672742665205', 2);
    t('6g98kb47i93am', '147121554856091277', 23);
    t('6lml', '218837', 32);
    t('3fe26f336209d592efh3d10bb394', '30258541260323091988380754480565626', 18);
    t('110100102002202221', '177188389', 3);
    t('b6dab6e4caceab483d2085d9d1766a088a19', '15928860703021466826033711809396661962705433', 16);
    t('1c671a9cmkljh4739491kg32eh09f8k337', '1326625039330667581969787383813804136095791793', 23);
    t('160b6959844a8ab23b27a69001', '1437328315622303205888330433', 12);
    t('407280517b355977843723144a93686a45298640701', '8572038042461765480971133069199082943420256241', 12);
    t('h975age91371hhbe43chiia2d', '85698406450142962437373788380907', 19);
    t('0', '0', 7);
    t('20013045354031552445055', '264171391963599131', 6);
    t('38a2de70alnb0', '122375305409282760', 24);
    t('3c9e2c9d', '1016999069', 16);
    t('0', '0', 8);
    t('eb6j293', '932312983', 20);
    t('10101011211221111220222000', '953771059485', 3);
    t('14ly', '48544', 35);
    t('4a52p0016af1', '16120814872832879', 26);
    t('160daa1h41jj04i628', '17061519740979136786448', 20);
    t('32fqepsd95teekq70pbo', '667470048911505020976383369784', 35);
    t('410jnn8bjoeomk74fn4ja6d', '124788397270763513083091234145493', 27);
    t('3ef3fa7740eb1252gg5fd99', '4552875972769088346240367764', 17);
    t('7775561', '4183462', 9);
    t('3jou26ds5l3kfobk967jve6hbduuq8b8kkr', '15332447576016846623868933715298495290279226254477197', 33);
    t('3akfed5xjcd7ixqmjbjlo', '25129890463803560823611370723159', 35);
    t('66cbhh9b922gg5jfg47h6j', '13278090021200453785331902939', 20);
    t('27eedlhdg8d', '1836671735070828', 31);
    t('1020102102110112', '17762423', 3);
    t('3fqsn2n', '3116816190', 31);
    t('827a806c27934197c39516c1a260a581b689a5882a', '38503176957765921865456861356760222362428149559', 13);
    t('2iok0f136a', '51715272179890', 30);
    t('fe41l5eaqnchh1ebi346j0e4980i6oipe', '969883696027169474847827349317450953078655187235', 29);
    t('14a2b930036b0644a86880ab148250891604977aa', '20642983383491072302934026303675112606383282', 12);
    t('457513c7', '745963612', 15);
    t('10027766104635746057', '1356176112501203917', 9);
    t('152545504843833807110608416814641251026576331823857', '818321316273512555089438042552450294648569716128', 9);
    t('100022102012211220200122111101200201', '51764207569214860', 3);
    t('3bdf42r16fkgn6qn3ja1g70bl25knl', '3164854049998441022423696324674875839621785', 28);
    t('5d569k4de58i504i2hjfbk52l4eee2gi4h574i41', '126711396842379940031754324715276160248231187472784721', 22);
    t('2elrjoj7fttds1kj1eqe05924mkeg17jr', '9563118598851333187355892107063110561421940440136', 33);
    t('76320618nf9en4355818i', '29166440299227823085424378642', 24);
    t('274hoc18', '13962101283', 25);
    t('3', '3', 33);
    t('a085993656a6731351278a0261496b9', '2387749458635635883908416654291117', 12);
    t('18bp', '57445', 36);
    t('44605ba', '13064542', 12);
    t('6j47fh3', '445502343', 20);
    t('3140021040032442034032142420324101102421103121431111202023134014422311022111', '88957367186178880784956669030745448554566774878220281', 5);
    t('6775333741557561774067363222030024220313353605226', '155993258459571709305776966445938258645813910', 8);
    t('7b410ha9adh2d4dbbfgb15145ddf7', '1071007184595736715355171202846231105', 18);
    t('4bl486be', '27306379039', 25);
    t('2d047117ed235996e16cb8', '54422637554743220665150648', 16);
    t('2g178gi7h371bdgabc4h9i024jkd00di1j80', '52404222604294956540188715269674775463381424101', 21);
    t('327okdlg', '24807760006', 26);
    t('148', '445', 19);
    t('67886851384', '411369168340', 12);
    t('1a7882a8178a98298920a653aa0', '2352073067567029324464577191', 11);
    t('6bkkd7o2f4ipbmtt6lfss01l97sblpi', '1315571448647629811709487168066391442124096668', 30);
    t('52104143220101400504102332405300', '7115605410380560227795492', 6);
    t('p6hhicpff2ch097ai', '3602154508749776816617050', 28);
    t('ddefh9mmog050', '3130965055875579020', 28);
    t('1eb8d81a8cd02825b628918358307e2c5dbc77de937', '49381329097323571281085427147300803948474329819952', 15);
    t('5g6j8of586ebi9en6am60ica64dj76acgl446', '1196611703139037684394056082836814593197976197986981', 25);
    t('145301455322303124543303144112202100010', '675682273892366920630205240550', 6);
    t('1332', '126', 4);
    t('d2hqmv4pkhpis4kwil17sh', '1894404209949516584414030849488509', 34);
    t('9c1', '6886', 27);
    t('114dda1g9f4377h6', '72084475607353599207', 21);
    t('1111000101001100001000111101001001110001110000011100100101000000111001000010100010000110110100010001011010101001000011000110010101000010001111001110110000100110110000111011', '5642505228059227244247414269863757684704851232189499', 2);
    t('508fh1aaf1c0e9f4h52c', '9940527316953908325812962', 19);
    t('707582405746100557868862537622284066', '17758735160295117568970479831136394', 9);
    t('24774bk74l8im54cd3j6n5mge5d2a27m86aj1', '106152337767157132554701435127389724414365801045065', 24);
    t('lha7bbb0g693i7f2hb7c28ib61l8l3', '18560795418562899773775421028146824268153', 22);
    t('anoq', '457791', 35);
    t('ig04h50me1', '33674426643383', 23);
    t('4521045140035435334320', '107362640409615336', 6);
    t('14ci84egi8905e0i507015e72783hecb042c588', '4878804467161002434134901366333118155781387556615', 19);
    t('8qcg4bli', '120689031950', 28);
    t('bd827aa941c4', '102957760172659', 15);
    t('fch0db7685f8e5a47jjgi30b1g9e80291gf', '2687375605960327268686364570667231480832392735', 20);
    t('1cbc96', '2479779', 17);
    t('4123860810563631873', '621577956977422779', 9);
    t('9cca75000ac59287564b4900', '2277995890851753018758808052', 14);
    t('9ggj7xjgjsi3q9qry0m3h6e4qjn', '132479614685652095506805037318263627015913', 35);
    t('4vgp', '227401', 36);
    t('x3y740258u2xqas0', '7319695651559802393895440', 36);
    t('13100833188435435125150061085463661600516', '198924198766645592728442581078146274410', 9);
    t('f7bc4b91d86c645df413c359e5751fgb2g', '622025592428355872931685309924438488611961', 17);
    t('11100011100111110000110111101111011111110001101101110101000110101100011100', '16795487938751986166556', 2);
    t('g1ehkkl5ld', '28947072317388', 23);
    t('132003011111302133121322221302000112', '2217164258386481979414', 4);
    t('10120021102122', '1894985', 3);
    t('1325505836763333045651420073434683647446736780', '11919401481124430210661735944237867636702382', 9);
    t('49791378b016636074608922783ab261aab07ab308b63', '1464088016751655045075255651768104776706515226747', 12);
    t('3m76k2jbo5719da6487kmap51', '35123523959570521061791470079350967', 26);
    t('4fh5a15sv', '12497226572191', 36);
    t('336765172584422549579974190155368820349813775', '336765172584422549579974190155368820349813775', 10);
    t('c0587a820625', '21565963607297', 13);
    t('1k93o', '708849', 25);
    t('f5fm9dh2cp4l2oeas9jcdqk', '4764950243508633926985496746426500', 30);
    t('d9soeeuqk2ofds3a', '502812647839703693193322', 32);
    t('6b825n1gjjhbdn4ih1f2o8h4i4ld', '358210303755108885399620686031173721788', 25);
    t('283xtndhybuwkml6di3d897khpv641rc', '3915242572217002753616152125461650495415068480488', 36);
    t('6soqo98im8ie11i3ar5', '2696831302220222960747970815', 30);
    t('11li3j9pe1bb1ojcmj55ml81ic6fb8b642m5n', '3607150919906347032136744566385373723352731718670814', 27);
    t('q4gm28vepfmd', '1320994706837332870', 33);
    t('fj1cj5fh2he05j36a', '47781006865064491040978', 22);
    t('24febc915dfc243g620d6chc6f17d', '319045853086479420376719648609675175', 18);
    t('axjeq4oscj230g0e9nrlxc7ukt0', '153295229065424111605138505063212510938015', 35);
    t('1310113002212031201323001312121331212323233311132233111320223', '2416702837718654938336064508044074539', 4);
    t('eg5h8tkm0ou', '16331639907615518', 32);
    t('612b5fcgfg251857213eej2f01', '2032194356980031603784734383862001', 20);
    t('11111001101101111001100110000101001000001111100100001011001100101100100001110100100110010110011010100111100010100111111110101000100110001011011001011000101011101000001011011', '11678786451764002081049400473764762680882990476021851', 2);
    t('1a85ffkq5jtqqabjrfr11g9nn', '825825047012895137626767704923066737', 31);
    t('e3c7i8hf6o5d1e90b1a4o0p88a9', '232026393767377308312827755103218776666', 27);
    t('316c6ec7195e44b347955', '1029840967122771047178230', 15);
    t('8legb275511j26', '2541054341067686758', 22);
    t('83821342401386120262277735280270866873166', '1246775385198205735853522756093577523023', 9);
    t('1333a1570743a16175a20a62266554a517766', '40200921314714807799085888577859275397', 11);
    t('47j24pkin8', '23333085707030', 26);
    t('26319444a9a30142989750291785a9a8088727505830635', '2061929969794917702400557105886923348678232898726', 11);
    t('7q3p1', '4234708', 27);
    t('1kej3a62l3d23g6525he408c930hh81631l9ghehi', '965311996501533239723956354548870830282992813453656632', 22);
    t('30223103202020302120133313230101102', '935371222603691639890', 4);
    t('88i2899dh1igc3fc3ge9ba2828ghg7e700id', '4834199907401772810967464568465313588983170258', 19);
    t('hmbf7jk276f7fojedr1p6gl5q976geajbb3', '284317650265820333891656626427162630405435211338279', 28);
    t('1676422201112714661607652471073', '2317596989962208644778586683', 8);
    t('32200020323332100330223231033', '261248084065041231', 4);
    t('9n6pnuwemvcmb6smt0v2b', '41262690485679650990706863602139', 34);
    t('dc2b0efhb9722i67g57163a2ee073a0689g533', '2809681747620610587259840399694397347937589951716', 19);
    t('8ngc8lewylbsnsatjhndyi7vyjbqkom3', '6370199031623917343971300162836561169065317503923', 35);
    t('2mk52j2b8a5587d84dhpn1udvmmhlj', '689449600810762543106689709493580073372350929', 34);
    t('5208d0737609053ab026ca28186d02941625c3947dbc11', '19374960955601935508953122309385766256870298527229847', 14);
    t('51af', '34861', 19);
    t('dda0ed04ef2e2b22a78e6455b862865ce', '4713519390205494839540473117533526320590', 16);
    t('2c25mufgyjnptg0prr6a801gnt2u5aso', '1722590891706429392707864779225562562261184133879', 35);
    t('2ks2sb6abmm1226bemg', '573090129852773147595705184', 29);
    t('1851849181066300127651593990', '1851849181066300127651593990', 10);
    t('7c4243ba2c42626d5', '17158768285212739043', 14);
    t('3', '3', 27);
    t('2kn', '3335', 36);
    t('fqlr27m00m19rfp17c', '63771501247128679770543776', 28);
    t('irqod2oc1pbe0s4dnhch9q7q3soc8rhd5aj', '998706528151123858219009078845461735670084733546613', 29);
    t('4z26tntpn3q2er9pwri1ovygbmsc', '5210334327381751818125703692230802722918428', 36);
    t('38rcbbetbf5f36uj084ps51fqbka4p', '355736129774653976136192164359376778173186929', 33);
    t('1q3iwgn8occfg446ds', '191677272763836654973524750', 34);
    t('1683', '1290', 9);
    t('1ed170582a62cb2ac6c31c4c843913ed3568801ce6378', '11148226317787355356748077765017756339753205698186038', 15);
    t('9019bj0j23id037a71d2f818a', '151057014706796380851381320864570', 20);
    t('2e6nm', '2562806', 32);
    t('5d4jin3sdcerj9j25ibg3', '3643909555936028919787218032171', 31);
    t('5pc8hlj06m086i24njhggeli04aoa51dlb2e', '744260236987988475505418299871418940910369537440256', 27);
    t('20130132323123223323201321021202031222113', '2552360031161222970268311', 4);
    t('5da2y6ut99g', '14840050365248481', 35);
    t('1083802151385314311018533036227557457058382761215181306', '3733408597840360399737721104598784068927221985247670', 9);
    t('1453174752703234014531654704472633215271161761475347123730', '4742538088234854254854687216429269914428692374530008', 8);
    t('3514356630112412504223242652361506044035016524224453444224', '5551155566932115229579274888281173021908256673491', 7);
    t('9we3kreite6hf59jaxdtohv202y', '138846389291496608664050011275340367383354', 35);
    t('b15ai5h94960g978431c984', '150193634897414415974425816748', 19);
    t('30341416404222', '297793923408', 7);
    t('ea944gi43hf7c8kih76a6gi7gd457', '152552752071312514741382931890385578071', 21);
    t('k3cac62899efcgkde', '28856302935223233143555', 21);
    t('1o7gg6w1c75ct1rc91g5tt0dnfcz63c6gnl', '137287343769800626880929715047781191933283098618048977', 36);
    t('25e', '2091', 31);
    t('g3592kdhll95dnbfg0ob', '5867544395796906365592047486', 25);
    t('36ljlm6k7hlbhj24g34iljjbkca6kj', '34917605806636558754409253491187290532723', 24);
    t('2013331213110201030220232320001301111010031211331331132312003112313330', '740251484693542342168090012177869705145852', 4);
    t('71l3xyfox', '15866279172623', 35);
    t('3g', '112', 32);
    t('3f9f8a0d243e0fb51b2cb5ac85181c892287d599e5c0', '317847259344191067119088327577099421993210660703648585', 17);
    t('a', '10', 16);
    t('g7bhf3k0tkqjj56iisl', '6294112241758545358107863061', 30);
    t('uudfufj6tp2', '34847370150901538', 32);
    t('77fk260mc7demfo25il8c2n81717a682c9', '99005083348240474978989079910691552284523954684', 25);
    t('393b', '6527', 12);
    t('17', '16', 9);
    t('7172b7g1d6cb1503520590483f1g', '11813382188355814044195049379459867', 17);
    t('2prc6kn3266c6n7g28el5a', '7192303509446282093103429808486', 28);
    t('95ogfxje7ls', '25276108149452713', 35);
    t('4bfu5onl45ilrx9alz34jimt75t1', '4523010860648796756968176777170199400173093', 36);
    t('7j5j65f6e8b0h97i30b0096h0e1agaj', '8552261610768542589195104260783405046619', 20);
    t('79533920b86a94445760532769035154b330018205', '1373349827844291882840401376619651400305985573', 12);
    t('1a245455c83151a3184a64938389322a55a6', '1734548256184785741768296183872320983247', 13);
    t('984e5039808eb14e793dd95', '2946024784801310608062668181', 16);
    t('53154012227153364107323333356132334', '27388210321734783241567604356316', 8);
    t('o0qu28952r6jprsxdo6cput', '118349942107141459621585048529740925', 34);
    t('3462ede96a29390b3', '21637787906719251168', 15);
    t('18b', '395', 16);
    t('673308785538823746262395', '673308785538823746262395', 10);
    t('35225503612770774201320011176174535217542332620333552', '334458377978261177426569028332297268603291547498', 8);
    t('376695373779076933422509ab99ab365a9246a8b08b2', '1105994899549067482501897563124358078250931847174', 12);
    t('3869261a7405a666a4433a416748710960', '87879253530807463519018010147091126', 11);
    t('7d9539285610896be3di4aajcc', '2574680758226813621572702606487852', 20);
    t('eom9', '630429', 35);
    t('ctnpgfics204j7lifau74', '30261420041988892749003398105371', 33);
    t('1e30c76d4c3babeded1eb9d54', '149496328017603561036003908948', 16);
    t('2g49l8ejj322oko8o1237li', '15046627139453716262719493020543', 25);
    t('lac1ai4002i9m', '3210059280216614719', 27);
    t('1002102222011110100112211002202021202110211010220021211102012002001010121212021102102001', '352510346325299817822890694447040983131473', 3);
    t('1tf6fn7i5di6ge5u', '175030739395576483074272', 34);
    t('282wcq3vpdit7gl8er4ww81jp4lagquja', '22759143758885240102880787824974474168226886339160', 34);
    t('1e', '47', 33);
    t('168009a43e598232cdg9cdg1a063587c35ac', '16061623027950486410325718902752796011029361', 17);
    t('1a007541183e0822315a57de1158e0', '21307529572089996579521941688891385', 15);
    t('3djeag7eibcdc6d87', '2424384796123691573367', 20);
    t('230301023011114232204234331140040120224432024241342400200433404001440223', '111145690113580800793934548266340600396757527374438', 5);
    t('10520860a57581009a8126046695028a524810847a01481461', '1112948582926775947692302960456787691406066035576488', 11);
    t('82de71e9ebi78529h6', '2357479348054666852291038', 24);
    t('318669479760997a65444728', '2831351356374386128515581', 11);
    t('3270247822563079013554888236298a158711461511477', '2597684729342955847047035976952888032696181844728', 11);
    t('551232202', '33100972', 7);
    t('hlsoqgnnhlol86302lmbpc1o1v7cn39f', '2094068282660026545502003357264798290330943200753', 33);
    t('17ag7ck44ei4cc0', '4404516346410619761', 21);
    t('944dpkcbk68i6agk0d', '10386492460212205943074365', 26);
    t('2sfgvqs01wmc0hpi3honfnq078b5', '635009624927118482002742877780185972981715', 34);
    t('414365504624046053220263710402064311', '170169261032326095162398418168009', 8);
    t('13hgdibii4e17k553j9gkhce0if5bc5ceai94hi4', '4361265005863822570682081694079725185789054191122793', 21);
    t('lgg1jccj55ls9rm2ajrrq5cs', '430943296004749884742945946753353589', 31);
    t('11101001011010111111100100000111101100010100011100001111011010010011111011011101000101001010111001100010001100000110000011000011010001111110010001101100000100010000111', '170573148533121700284914386034471572584747624695943', 2);
    t('13413125266103565462344013350460103615501162', '3307282268566056426163788875674325818', 7);
    t('3j', '106', 29);
    t('b349008315969b8ccc7052a43c57b5b29142939c7704a801', '255164047256623112253163706181586265330065889629470557', 13);
    t('94dc8b4cab1b6b3dec5gd6beceega62', '76058492450972753054531985019222386368', 17);
    t('1ab27cfd2a77eh0b50ab24g2f', '7628045918745194687434147924866', 19);
    t('34rkmn6on56piqq4345crmroc4m08', '105344564607152675293550922255989496280680', 28);
    t('6420543526040821082041501606040060756238112101624', '41166399030228549347833032744913546219462846120', 9);
    t('759075c552136629a36146a', '23890078166204400503313568', 13);
    t('7ak705g0lje0d29h6l1hdfgijba35fba79d17h', '350347689943364175900597066972947125277514426393207', 22);
    t('4d1fb3fde8905', '1356776945387781', 16);
    t('c6e46gkiem1eiahck493g9k4c', '43565766401935427989245632115778237', 25);
    t('63721g686be16e1e526', '87206911321780393529297', 17);
    t('25045cc77b4debh4h916h8', '1616816419392758474839845354', 19);
    t('5eaok0n30e0e1m6gd29e4a9f0m56j', '7740457295545283166939800698000390972044', 25);
    t('1c6ad164b71af7cf0a92d7c2cf97ac3539cf4a190a6', '664509895940083432745213666480332815238360970924198', 16);
    t('9605629834738021029786a867a158511013a52a8405a72462', '10191274996495287729155135548072159517142616697156216', 11);
    t('3352cmj', '1500429243', 28);
    t('10001100111100111110001010', '36949898', 2);
    t('h3hh0g2c85bh7396gg', '94303598818479768768188', 19);
    t('20141443402241032211400201334013114442204204132042', '36862688956020216748269194930536522', 5);
    t('6mkq', '261962', 34);
    t('457ggif1m1bl2ee98303l59b', '88366118125435849323789834859634', 23);
    t('5147bf2lga7f7069', '2549101427903154350745', 24);
    t('1c32affbg6cj1e15ce', '21073984633002181450254', 20);
    t('p8cra2eidd65ph9fo8n397k', '7933449586075462280012611659119330', 30);
    t('4c129h0fhb58211aic7ai6e6a927dabd5236fc', '954786819466789784055108938545862635435383874674', 19);
    t('82033830', '82033830', 10);
    t('1010010100010010011110001110011111100001', '708979517409', 2);
    t('42478377375073344992', '42478377375073344992', 10);
    t('24292893d565157b8dc04379c076919d0a67d0080dda1', '618333628399653605854827547452825613797180483032025', 14);
    t('12021032452513221510441200345501434243555230315414240', '39091544699662086629498022647413959018000', 6);
    t('lahi07', '254389623', 26);
    t('dmrf4tjrc668037', '6583228333332288876097', 30);
    t('18d32b6bdd20482a56', '49972933524301416292', 14);
    t('31b2hd51f35d1d8966fbad2d17fe07112eg', '14764753272450920274778007595847767027142732', 18);
    t('474370686', '1001518425', 11);
    t('4cbb8nr0ga4e20m32ak0jn1rhl2ef69', '329672291129572906563643430219747967931125305', 29);
    t('tads6deu8nl7wsluarmb', '2083847353511862075875525723903', 33);
    t('3i9360ehd0f2941h', '60311321989193348951', 19);
    t('11101000001111110011000101110101110011011011110110011110000000111111111011110011101111110001110101100100101111111100010101010011110011001110001010010011011001000001000101000101001', '695150897721330668961198822938644201466146242961639977', 2);
    t('1012111122021000000112111200100010100200012011210021220100002201002022121210010010200002112211012212122010', '150771843971952583323861645995496523521380113647165', 3);
    t('7jb1ijfii2cf4j3b3ef3', '41826352819841414347389903', 20);
    t('5t1n3', '4834593', 30);
    t('12', '33', 31);
    t('27ejhdlpeek1acpp57jif5kh56ikpliedhi', '2945305406573061366174441740050992970724142349520', 26);
    t('17bb10407140593873565730389587876a2438811b26', '42315982694007165665825252379784192339494272526', 12);
    t('n0gq7e71hoa7jibe3kcjljid537', '973294813025943583919577094627375341675', 28);
    t('57f1a732hje05bd5g8ef', '28247010766435335146531495', 20);
    t('2fkb331cc1f4enclm0hbn', '10695289997958612784724248415', 24);
    t('940jymc', '16755335182', 35);
    t('23b5a42785b', '144253937159', 12);
    t('332332', '4030', 4);
    t('133336431314111040125445650165', '4830459607356940965265100', 7);
    t('6ec41', '882361', 19);
    t('22', '22', 10);
    t('0', '0', 26);
    t('373pbof59iq41ja80np3h1hb66c0a', '39086275552205397897730850178810132407635', 27);
    t('1cee21f1ce8gf26g6e0b8105cg5he4415db2hff2', '15459905127505680786167890226971872272009384340116', 18);
    t('87dgdwg1renuvkoeavwbim8lpxgv4vb', '401000049256626858774368667583141736311922306663', 36);
    t('3isj14grpphjnc1nfpi', '1407040022579438811290045268', 30);
    t('lotrwre8ar', '1711090616092927', 35);
    t('1gsqeka2jl1b976qi8ehc6', '16374903938406169822980318273666', 30);
    t('4dnqe3', '148629955', 32);
    t('d3dkdfd7nj9qigq12i6cffd34q', '7986534045217039049966056077355386629', 27);
    t('30015015540350210153424450312551312411', '186187559266853112245008019767', 6);
    t('jul8cg1ela0e4edfg0', '3527382384060143413865828810', 35);
    t('110122101100221202120201211212122200220201020120122120222111202001122120010221202110210011210122020', '80448857968083617554152347697248793494050049616', 3);
    t('9vemie00f9u3rnk4o4mrf1v254vu9ns3b5', '466890651064760271528412966235388536094543461616997', 32);
    t('111121313111310122021311332010123110123202033302202330211020113121332102232231313031', '125128719044623689856157423015050011081778094857677', 4);
    t('240451003255052453254351310432552514340023252', '46587982443617743794995947075156496', 6);
    t('k5o510ef', '272684166231', 28);
    t('bf10gnal8c8l50fgbk', '46108402152178609412805768', 28);
    t('42324441444331403351355513', '125935341458202497061', 6);
    t('75gdpii', '4277974110', 29);
    t('10153514333', '63726609', 6);
    t('1h1g', '29110', 26);
    t('393b41a3143a454943', '8380580329886369091', 12);
    t('59304176726473587130612', '59304176726473587130612', 10);
    t('137d5j42h356jed8caa21jahh9ie44b28c', '10043027274116397234553163118775038349528972', 20);
    t('49u64', '5733968', 34);
    t('165a8273521956a4', '6662096633605824', 11);
    t('65ggfd2h200', '6949479788349440', 32);
    t('9', '9', 28);
    t('1j', '42', 23);
    t('an11', '290731', 30);
    t('32504342124451030441114503214444040214143430154453032220413050500002', '47554002877149413362434118805244987488297716371458402', 6);
    t('430200', '14425', 5);
    t('3094a85981a027626759a77870223658270a055', '11513511128194690284501911822638050206045', 11);
    t('8jj7ad301acg769fjghhbc9ccdi2aa53c7f', '1545920497099530665176555768420891600032828955', 20);
    t('23142012635205', '238490986074', 7);
    t('3p23slu2or2lkqci8', '4573755691405244852154952', 32);
    t('560c11b6845a072c0c22ba28144472650a753ab9', '151894844910815511057842865133583436415605129', 13);
    t('5688884955', '5688884955', 10);
    t('9v1bex484u9g', '954561932219597956', 35);
    t('13699363090125374585452111316030', '13699363090125374585452111316030', 10);
    t('10300233111311300112121130110032132331231030013122231000013222', '6329196093597682159006452132074488298', 4);
    t('g3', '275', 17);
    t('a9362a295020575', '4119405967597805', 11);
    t('4cke3ggbhkg3kkcd8c2j3e23j3h3c', '177610512943070772233329421133901768714', 22);
    t('aejfebhda5647d8hicfgg92fd62c3jbhhlk6d', '22681378063543267593175360612666532727335364021641', 22);
    t('26bk', '24462', 22);
    t('40el80h7h5998lghk0gckh9a45i20gkia1817hd', '22426986371581060650291320125302165512055992788579187', 23);
    t('0', '0', 34);
    t('3cvdf0ffw8arpgd', '9324689059447121647753', 34);
    t('7456545364015236001000', '70016530198021276160', 8);
    t('9jllkk12hej0', '35833846973541838', 26);
    t('2ksbm90w2g', '122159535406606', 33);
    t('5233', '3837', 9);
    t('25cc173935aa89717957cc690287c8ac5897114004974', '25388874872205695306782055570702284695041270251885', 13);
    t('1221222002102000210101012122211220200222100110200212021020100112111120', '1636824719836500158668182780963606', 3);
    t('1111232131122000111300020210302202321011223131010022232111131311120203011211', '1911752105791956460258073810226603098202321253', 4);
    t('8988550feh2fb19l0i6l04gjj7', '30634356015861131671092023444404629', 22);
    t('oeancnlo9ijbac77dglo1ask6ofnl4k', '1824014149455616255108864549225566262750135574', 29);
    t('11002012221102210200101112000211221121210000000111220212101', '6409268570990190943079463412', 3);
    t('36qdh85pljsmb8g98m0s', '37533975292710168814998325828', 30);
    t('170gj', '999499', 30);
    t('3932581210798432862405499987164457', '3932581210798432862405499987164457', 10);
    t('3ch7258m07q7rl16r0bg0', '7927276440553837446719503793985', 33);
    t('20257774520426157193756088561635', '20257774520426157193756088561635', 10);
    t('951ge58337f90b1fe68h7bd2d95', '4025392988076931185675982866053147', 18);
    t('1l6k7cm15ufsup', '189871394492066962875', 35);
    t('321b959d5b325b728b0326e73eaaa41', '602332697103765494715420483143314186', 15);
    t('10568796b24113372942513671b638ab2210a1b7b107011', '45581696081476450286298571130938321064311891651405', 12);
    t('3b98k8120ccc74n6ef9bd1beac3hcfa', '885608666388200390191758079174867768107634', 24);
    t('43433b2bb4b422', '1289017868139471', 13);
    t('360l0j8h2j1j45bf0k9adajhec647', '126767233401225735441881274095914648023', 22);
    t('b80kmr23044g0fh5l5faksiprorems', '28955063766509964293677139808717178701084446', 29);
    t('1da98c5a3d4h821a9k1af', '1137471209110481204473484095', 22);
    t('618450432807535130378045834820211332', '15559949571019773458768163619429673', 9);
    t('5tko940pe0jrm6', '218650082993546849990', 32);
    t('a8eq7cifdb9mhiigh5b', '599921281419889941644672261', 27);
    t('qxk39a7dx68egvn5s0h01w8', '251307205109451556038643316790309853', 35);
    t('118hndcbh9313e', '926322242353869974', 24);
    t('24440334411431203422412133041402214043204340402320114020044014', '12980997135625297861036354210265432195471759', 5);
    t('2gtre5qjheeuh5uodo4hik5005w0v37', '9025673405212440662562000938329712048049568180', 33);
    t('ghj9h0d', '4079838763', 25);
    t('3083300286348713118154344655632051', '95902949580067304421978859746787', 9);
    t('2204342431201401113411321022041242024', '35481463480601705590180889', 5);
    t('542093a55a0269031073108234aa3', '8815351536757882311286614273051', 12);
    t('7745a7c782', '5832395843129', 21);
    t('7a934244281251a48524aa43', '7150917669356406106144382', 11);
    t('2xnwqdgwrh5uecw5q8y4dbasw0', '2372398626016802230522523263083931807680', 36);
    t('45oggh72', '267833757697', 35);
    t('9d937f7', '331639225', 18);
    t('2', '2', 10);
    t('61k1g5ekbid4461', '127823767005507989905', 24);
    t('1e4a5ec1282e03ecb924350g96a9', '58781744149373563800579530600867870', 19);
    t('1b8e5095', '688404805', 17);
    t('0', '0', 10);
    t('5m5i8ff349l8bf5al1k686cgmb7mdejhjijmnm2', '166279352831336816425981143513635237161255195203340754', 24);
    t('1804736634422744877', '284505311624250607', 9);
    t('mtca98yofgyh4l8guo3u7me8qyt', '319476383658716451190075727542821418162944', 35);
    t('214', '670', 18);
    t('0', '0', 8);
    t('8e0n4lpe4qgji4aem9pk657a14ff0a4', '74359597134400809115329522029847080723202805', 27);
    t('6b', '191', 30);
    t('23e9f2fa8h8k', '1265749744976616', 22);
    t('2khe6hm38gkfb935jagneag3n', '3819659602086817228674066252275807', 24);
    t('l7fcfbh1mmg58f8lfach85k', '121103810194801760541361186598895', 25);
    t('585d36c89594115ab2da6003336c', '49406265527885526964870839515652', 14);
    t('i7hc8e6g51bh499k3d20cg6', '2254290174662249778124399696926', 21);
    t('29d730cd9c087e9', '188433258449504233', 16);
    t('4bbffc982422401d23e107db16617c0c0', '1611023225678920504550274579287300882624', 16);
    t('399eiccfdg776g8ie7ed51199aicj3c1i26', '3114217897390306876666438603763020155894866697', 21);
    t('a0408a39c0347', '233539456688506', 13);
    t('1244321202100034242200131421310423344110212023', '45404554130117615171994334460263', 5);
    t('100011011001101111', '145007', 2);
    t('m0id8e0lii79i0hamjm6j3lo0njgb8k3p1cfd', '19142712657104634174482218734811759840268764171688795', 26);
    t('2fi15dh0gj44', '4042101164149540', 24);
    t('15frc89bucts2fbt3tggm', '1485349439418814854186055680534', 32);
    t('c5fc', '169140', 24);
    t('816746485234485786017137575711607104112550441248', '5793937697453244801258576864771947865560248340', 9);
    t('131002122121310201002130312', '8173384848647990', 4);
    t('92', '92', 10);
    t('4c66j3i793d79fcl6eem85ggibmin6ff03ii0i', '5273269349565326953768769699813092661952318735852690', 24);
    t('2100112202101220211022012101010100', '13083662499139368', 3);
    t('8i6rwohm7plthofwaflkou7075t6w', '64957478046184050549268164669753853232592056', 34);
    t('3ge52j30h118a90aq1li8bqhgde42l', '9162992827240438154336690317061119953413480', 29);
    t('3pgekc3n1f5q4n7d58f', '229611421142039521550129532', 27);
    t('cqq5mc0alqf89', '14801280699144682761', 32);
    t('2i8jqk9ecjl3j7pokbi', '553717099454231407510522435', 29);
    t('d', '13', 28);
    t('3iflgoq8fkd', '1084961028184109', 28);
    t('318836651153123015848312384230506810010032857747444671', '1210321032121068276111676497142116640496938793305774', 9);
    t('110410143222242232313', '117657104649083', 5);
    t('2f1qe2qpoc09khcfaq9dfk54', '4888325003381937548488277795720464', 28);
    t('ugfkv6ssxm8bprvcbcmeld', '8115207037438171760870129030349898', 35);
    t('3p7hk8j1n1h0n69em6p863dimcr', '164991699304116139976836789916894063947', 28);
    t('b4194d586dad9d52398', '4821265933637921163698', 14);
    t('2320m01gm0j0ebo6cjq4nl82iclc2', '25308651911329509101643504949204196120222', 27);
    t('32d470005nmgog06cg', '3510779211405082452397344', 26);
    t('1biia047d46e', '190055020053562', 19);
    t('453554hf345l715n01', '1225398359686044688634305', 24);
    t('6mocq54g41kgnpb67r12lf70jb8076578e9pe', '85364451999663221329010408002474800688521919163853530', 28);
    t('26fcl84k3d2e8flkg9fbbb13db51gefj1il', '10116499145802283445045451241317675314169646973', 22);
    t('dmld1d719ge074f45', '16572445824579028888206469', 32);
    t('6dn3kga760j5d3mcng390jg1j977', '1045864553213695887738689074624417178057', 26);
    t('7c822a', '59831482', 24);
    t('3', '3', 13);
    t('7hsfag1ohnswxi6thw9sxqf0sfl1fhbcq', '76526067136899944638578262007377029250134038384950', 34);
    t('34fa796a05fee3b566107aef6fea5327c9f794ce6f2', '1238848647360391370812154035309938766206217768199922', 16);
    t('62aff0j6g27cbb62fbi6ehc8ei9707ie7', '2631513170276940677418579291672958038463487', 20);
    t('160006380611399874532975360', '160006380611399874532975360', 10);
    t('321113214233340303122034034341', '642745280323070611846', 5);
    t('0', '0', 11);
    t('939fc0e1ed37f3gfg712', '48100541569978054645730822', 20);
    t('a0778l44fno863j1kj8845kanonbjic606o', '3392085958211408076013624279917504691844418843924', 25);
    t('6h5a', '130636', 27);
    t('l9b0it50qmnedap8johl8iloks', '905661954380795627228973456176408355484', 32);
    t('bfeb5lec3g0g188i488e', '4228466062971689766442645839', 25);
    t('1b', '43', 32);
    t('3', '3', 13);
    t('7a3p2m', '440231854', 36);
    t('617748df2i664962id56755f28id9e', '73665342183530469462696099210511390428', 19);
    t('768505531614045785056572382071602027184721164318550231', '2920164631077979800661618205224712844072060341452933', 9);
    t('hm7rb8citq72i762a162cbqef', '23520916221723656411579473355413514703', 32);
    t('16ik63anb3hed098h0p70g02k6l4oi5mgfb9c', '1093730280055464079356271243419045177402000893676762', 26);
    t('1a7o19hhppbr670tea3', '1634167009538284294723516739', 32);
    t('c83i7i445c57c239d3lblijk9dggbj8gj9', '10687139874282278734927122410769711076904192751', 23);
    t('h6h905643ldje0ell031b6a7g0l', '1384376087764757994009208722127705501', 22);
    t('5463p83imndnib6bhgl8e62k5mq725', '1666904828897862368867031608875610218601012', 27);
    t('17al0j92go770fd7ccb300', '294982324454146101460571267500', 25);
    t('5030794a3a16181221353142', '4499832616666426071863261', 11);
    t('13013306320776254', '387810637118636', 8);
    t('2aba034153b7624807b6c8cc6658a84941204061a47703', '380713175788771350162354052927260664309723900025732', 13);
    t('15enpfxat367y28nww9sx', '8787844721197737785481977672788', 35);
    t('2907465cdd296accc8ab4bd', '793605010131443253911401661', 16);
    t('btd90hija', '33333612923926', 36);
    t('1100001010011011100011011010100011111100110100001111', '3423573638106383', 2);
    t('41022452241053505514431155445534332343153435032144521344023203', '1225194524811083036078094796606648972619116520691', 6);
    t('e1qmlkug6atzc2szmrgbaj', '6760472143725608443176424992006187', 36);
    t('37scnff6r4bke6blfcli', '19989390915717056236744855873', 29);
    t('334222400013230015435445313223214033', '6226915450088276574887871237', 6);
    t('7vea3c0', '10270438893', 33);
    t('1c1d81680a2af9', '16957483031426736', 17);
    t('m96mg3', '638353398', 31);
    t('ld1n9', '7148145', 24);
    t('21', '17', 8);
    t('1b1c1bsf7n72urusb', '986592048657092288475155', 31);
    t('22002021201021222120211011222121200201102111121010', '644884299955469783555760', 3);
    t('38hya9w03adpnml1wt1', '20146753328658169736251561841', 35);
    t('678900492958281937296424307391310688109544200506572255', '678900492958281937296424307391310688109544200506572255', 10);
    t('1d4353ff5f56571144g1844', '2089805731314765099203371537', 17);
    t('ir6039m4ogo6rekmap628lipn6g3i81d9j6', '303029496939924707734813747542699909042016864377194', 28);
    t('1015155663263325215616644031243334242363653236243', '38015525426091545614476127416406246189660', 7);
    t('7m8bcspos3p9n', '12799934209662533825', 33);
    t('t10i9jj6rf8d4igqh2fol97p37ue', '536606270683321487460519767895396158935512', 31);
    t('14afo4gl6', '179599291781', 25);
    t('71eg1137a13bf3hh8ab3195g31163460d7', '1885141378228919225779975457128661363992129', 18);
    t('9pfjef8fl22jchcnot331qs7j', '2782134740188232381925166871891437429', 30);
    t('372196b06930740a29ba60a7', '806032988961165618240479843', 14);
    t('7c', '152', 20);
    t('4mkcw59u2s8c6jncek076', '10990686957535604207639130208131', 33);
    t('a8gdb61okldrl0aik758e53g38aq2552hlica', '129065494496127233059548754102332462801434930608863802', 28);
    t('a1nnrn99ivdm', '705391832310469964', 34);
    t('2042221145454461340562431', '400103241982606737303', 7);
    t('11000011010212021211022010', '1131323251782', 3);
    t('4n21rlmmp3', '125431688294070', 31);
    t('m6i70g5a', '102194648194', 24);
    t('3q41d63orgmotlhgfslqc20hb82kfe4rh', '717334587965790065732270364786517943405016532427', 30);
    t('1101110000000101010111111111010', '1845669882', 2);
    t('47ol1hogcnk5', '52105694239787194', 29);
    t('1021322332210220132113300001221111002122210023222212121131012010300', '6288547997581842904727500905920033218864', 4);
    t('o23ot4tfpccbofo7nf6gboa5q3a5q', '13790372660580043232353319429756002887354620', 31);
    t('1kb6g3ibfffaf1f4a3h8d96e631h', '991195679687488764520434246680302343', 21);
    t('2158696h99hhdn1s21kt7jehj', '1264237421480805368218573017622222919', 31);
    t('x6o5jx9cv74m8', '112160215850835853303', 35);
    t('2', '2', 7);
    t('57176028a440a918503', '31415193562039976560', 11);
    t('40b80ab60400181118c', '457553993478347736554', 13);
    t('223320033212201002110210032011333011012113002031320310112331022000102', '238898959948440949613215671638042952900626', 4);
    t('11a8g8kj0fab1d1kilhh9hf', '364282053955268028963745481233', 22);
    t('11240455044265520645036360110314304240205125566156', '307183470929453944085729413338106398817956', 7);
    t('523ik6ij13kk5880ci6m59ef', '106368852856173920584075434741551', 23);
    t('1714', '1309', 9);
    t('2dcbed61b0454448ee4g201fa7gef68e59eb358184', '788683087187581292214395140742054830008036513743616', 17);
    t('101111100111001010111111110111111000111100111111110001110011', '857702623840828531', 2);
    t('5347712744236105712406353', '25750698989482171567339', 8);
    t('37g34g40d04974eccbg', '48767935869856137341083', 17);
    t('vthbi9q8o55jnbxvv3ti', '11814978679218404459790901458966', 36);
    t('8d69r3qf2ottj4c0rl72g05o1mn12uww', '2508962139336692901577954469144032904191497935832', 34);
    t('5g9fg3c9dcg1a023b712321470216gf31adee74', '341537217285112703078107777185027563591020784046', 17);
    t('ccd721fgmr5e4', '14282288858953258436', 32);
    t('a80ae46dhaea67', '438302256218022495', 19);
    t('12916146057', '166501275246', 13);
    t('6tiy2k8iyrsp6qf7xmqe9', '52080446267291461713344751743099', 35);
    t('df3f6l', '70550413', 22);
    t('6je482j', '1302612547', 24);
    t('184397303', '377967098', 11);
    t('611985c74c0c61193988409b7ac8080b859c3b9cb173', '4830410812954644160553068441629408675970314449453', 13);
    t('7r6jrt', '354387775', 34);
    t('3008fcuib88j392ucbg5869juji', '1788819762374982410062695434989906399169', 31);
    t('163437548162880523537684124013727543874884361', '1658096721479270315378604205589291844831901', 9);
    t('b9', '229', 20);
    t('b3j5bb58153c37g6e0279j', '65358334895093431573877660737', 21);
    t('11202213003212013202011130120200230100100123213301210211002', '115077606360628968095680622787709250', 4);
    t('160003100bc818c7c2475a649b', '10313273121890479048668535784', 13);
    t('659a832355510920755202a222a0813216a0599645415257580', '76738460570358936081428047041239658092598283361190466', 11);
    t('8aa7eb5be50', '9528363302480', 16);
    t('1a2a38', '311374', 11);
    t('15', '26', 21);
    t('a8qjvrqf7anvqln9b9kh', '407074332757747109859008292497', 32);
    t('qh5oal7t', '911800095997', 32);
    t('140005430425315', '130664921807', 6);
    t('41430355414103404513450514422151345210212415430454523', '124894395792287452864745586425404037844339', 6);
    t('1', '1', 4);
    t('8l1x5am4a32igljg2tls4wjxl0wrm4', '5158839313249239164751957239861646046595412099', 35);
    t('72a', '1219', 13);
    t('2h6ii2g3hb2caeaj3fjka04a3803a80fhfibdfa9', '10413494305628146258331381259290048979757145255897373', 21);
    t('2483bb318b5c', '4223782433155', 13);
    t('30472a755209b73aab2237b3b4b6ba6b4a051b066b59391b64', '229935298182638819911567178597930454480466069384927804', 12);
    t('2j0k3iq4f297gn6n38ugm398bj6', '7804799583798677561149968484488848426376', 33);
    t('10bsq5up56iew5ew2frmjp', '146381119737686760083072120059007', 34);
    t('322', '87', 5);
    t('421345344324', '1588619644', 6);
    t('55rq7fpd9510d22kgga9qt2cqdo5ju5a', '88593570103139158692015868786912788737196709657', 31);
    t('13d29b67', '3933280722', 23);
    t('1krw15t4oraf7onn0tiqqmdvon', '149796236898283951228532905796770497668', 33);
    t('3j96a36ie056hg3d9a6kg4kbhb4', '93677997263967875177503265523746296', 21);
    t('15c14f12e032624a1206', '102735615609474072056326', 16);
    t('kd250h4kcdnhmk9921m91j8b', '7181407883202320763157477055926079', 26);
    t('180a70hf7fb865533heg09', '21177926122372456937157622281', 22);
    t('2d2650f939302bf9306f3db1fd19a7666712ff8', '16109941674613560268665251639244419228113121272', 16);
    t('14042210021400013331223212044400010400022334204000342123141440202040122310414', '242980031176762892729926943688121630090892651895119484', 5);
    t('16140eamh8k8c0i', '14642806436348304641', 23);
    t('4201033713624', '292199307156', 8);
    t('2306577543183936183865665a22384343a10249a928654a561', '26737226623626911856928473582008646056500695263735591', 11);
    t('9ifb', '79511', 20);
    t('21002000210000101111101212220100202201002210221202111222122011010010000221020022211102100020112111201', '1215456332160362004993935235255673868488941612481', 3);
    t('gh4j1c8ccj0ha09a', '2297228448562517781904', 22);
    t('110602312535653306453056163441062133026363', '51720570582674121452566926758640555', 7);
    t('25hj29dkcjk21i84g5mi06ikibgj38a91gfm8a', '544909359244447938678618718321934826921483716508566', 23);
    t('1555215136316402505015533551631166', '14161948712279262986113894899', 7);
    t('2egb72aqslj7f3coqcncq2ctmrdaso5bpo', '40494263521822533022866511308330148471304529398018', 31);
    t('174d0ii9c8c', '8469481708812', 19);
    t('11eznfre', '81447352970', 36);
    t('6147402214224431303026413646714237211640331341', '270142041873110958246056630570783242040033', 8);
    t('26217103620571', '26217103620571', 10);
    t('1740c8293545021042b730c704a025b203944b24201', '95380799134993785564663731354331010215990332043', 13);
    t('hfa', '10162', 24);
    t('32312554053142020121', '2086206758458321', 6);
    t('bb', '231', 20);
    t('a652scv2d2cetnml8q07rin1bmmtnn', '2634349543405059211976189682479993087452778569', 34);
    t('28', '58', 25);
    t('4hf703dcjj8c2jdc82', '64072923883505417548962', 20);
    t('11ba86915a5600811428ca244ccc5a5788c802c91259', '910070795625285317118605406708822896222785514764', 13);
    t('23llqkf9drl9kq8', '633595908841101403781', 29);
    t('1b2gj1h2c2aekjbid916665h1jc', '36512492798947082162412228775679670', 21);
    t('10100100001000010111000101101101000100001', '1409871436321', 2);
    t('23h023952c59969gabbhe14c3ef18026b5h454icg', '24106941776124250340342392848281591922711841101639456', 20);
    t('4301240430452331524422321005351031101230421411052040101430514215', '47575980866556413314221304862772696911550410330915', 6);
    t('5028926799', '103581232435', 14);
    t('qk52htpg5s77qeeekaw2k', '62421682061116668942703365250451', 33);
    t('hx1wjtw4tu5ri84krqr3p', '239520584446386005614208719787701', 36);
    t('e8d05b12f4d1d9h5c6134h0e86fd', '113048495116012205309732881337506579', 18);
    t('22212211020210102211200022022010201211220202220112220100000200222122000120', '200105700798705299655405516905014140', 3);
    t('1k9mn0qj86h3pe0594eicn1rqigcbj1', '126683083370995227384223569141871955819814409', 29);
    t('3to5kkghh', '6917888883859', 34);
    t('c4jsebf02dii38m62j820hhlhg4mm', '1076807142156967950235640680591835512378940', 29);
    t('56420594375697116243914157706969195542878987', '56420594375697116243914157706969195542878987', 10);
    t('240343101031431344', '2160207295849', 5);
    t('2950239ba8c6665809b903936a215', '42198574579570963238277599179178', 13);
    t('472caea81c1eadce316', '6619962484583137949196', 15);
    t('1iff68050gbdi14', '3177537542453071224', 20);
    t('4nsujphp4e4oeh', '553600630574258719532', 35);
    t('403130431322252150212401000303143211423223', '328068405789131208325952848031295', 6);
    t('1101300303030', '21433548', 4);
    t('25303', '3783', 6);
    t('2071022121', '808867882', 9);
    t('6c4c0acc549735bb09904', '2268273210775487799698029', 15);
    t('32033203021201120321313110002230020201320222201010200020020', '295814627854058541670739255760126472', 4);
    t('aed9b9ri5m95mm', '845724641799698178142', 34);
    t('5o2mlgf3ak4nkcf63e3hn', '249802225714608272506459114448', 27);
    t('2i1f3', '464703', 20);
    t('ers5t39623laf5pi6e8nchq9adel1is3468', '63245054851996044208467781885652929644411675671796077', 33);
    t('41k2o04q', '54799568010', 28);
    t('2jog4c4b1ck2facnjolid4d648', '248639818689269111187343577521300733', 25);
    t('315335405243353303023000323013353153411', '1233705100662924822920998240783', 6);
    t('c0b42d10550ce0f4ea97567ede6bae89e93b', '16786869625005321512335207434991310677338427', 16);
    t('1i3sc73cm6h', '683826880532477', 29);
    t('7u506tlhc5aj1dbb', '187087416521171722983827', 31);
    t('5fh04di9lh854bg4957ed2c0ji2788', '4868812415572782947735163151740587465316', 22);
    t('13030030412302400343203111232', '60506277551461769567', 5);
    t('18423115785830864674513a49890a6a369653577', '797488530648724604221696847400592018064367', 11);
    t('mib33aik0oe', '2168445661641239', 25);
    t('4f373b2cdchh4ic9ba63aic625h989b383a48hhd', '356883101285661886815711288455781633251556555968023', 19);
    t('49645837a599899700a60', '3277077666371488259808', 11);
    t('30467e8e', '515946284', 15);
    t('f88gnqjdhnqce53g03rpde1km46qc9sb9r4', '805058822427589583306256678962040241179999133462129', 29);
    t('1mpqq', '1265644', 29);
    t('dd5d03lda1r2bjmfofid4dg4ln5j27d', '1001880008568720793424449251386638391786461149', 29);
    t('481kjai1h5e226gikj2i08g85ki810e80hj5c1ga', '16164773357903179257478471364779107060390719020084606', 21);
    t('cc312enkg34of9i', '1362114899632793344734', 27);
    t('a523a89a13', '53831004783', 12);
    t('bcb3750ecd418048f3c9a907a1', '14950433883660044294408311998369', 16);
    t('404902a03666449471524a9193353311260037114433a54294', '305850369678697383399472296340395515919908283719915920', 12);
    t('122202012113', '6955415', 4);
    t('1ush8wqys6nym91b', '410160199735843616675135', 36);
    t('am3230j9', '66436375484', 25);
    t('402524530030233354500101105335132042113514123333551524544415115012', '1550904369864527359367977424097726543505044596334704', 6);
    t('75khfam4kcnghm715bdaa6kde15ilb6jd', '1063550394889085802339598789900636157058462037', 24);
    t('15ckebn4a8bmv1jrov3jmj', '90034910889272889928459408320145', 33);
    t('74a57mj3b7oqfkjdi7qt4c', '148686083061828528921843173717108', 31);
    t('2a1cgmci7leh2e1g6h212il487aj', '1051977661293043554453465596384040119404', 27);
    t('177a7a3a9b4414a79617934', '904337669156803925941624', 12);
    t('1334504451254233444333525101252522240052410203505301300545545325', '16952109548779766921097840692944523012508999766805', 6);
    t('81jaht3g0q8ebuauk', '5857490476197292433536452', 31);
    t('a3664d6c2801a1d385947d711b40c94537786632c75cb', '2755747140622424147994575137709870068882656069074383', 14);
    t('kbk7bgdb07g5g49b8jkflig1hjaae3', '17494482520856869278705339934437230552543', 22);
    t('21cc019d87d6a38d7240d0a', '35045098625804789921638718', 14);
    t('b7677de626a96290c23c7b34d2a3d48b9d993ee5', '84740181377896568043867047475707714193154444115', 15);
    t('g72bbf12e0', '3252509311068', 18);
    t('4b63k3', '35585187', 24);
    t('441345035204314004532312424335512520451', '1749684973421935188191842585519', 6);
    t('2kecacmfnzc19d33', '567413050870791669672831', 36);
    t('6a065551905199780109695521766', '997063787222699268458056520053', 11);
    t('82a8dc8782612a', '15920695955540515', 15);
    t('14231143130424222102345535', '49386499907903489507', 6);
    t('20200331130223100331230312230310123302011310332130213210', '2763276123199138513786811130169828', 4);
    t('l8sjd62j21qtfk0bkk', '275049147514425322241710520', 30);
    t('8b5r027799go6wmw0nasgk3fm', '23196991346952529463855897995513260706', 33);
    t('514c5po1af8i0g2g508', '148726327273315469093588700', 26);
    t('db1cdc3', '103874095', 14);
    t('497a45', '2518269', 14);
    t('3rqbk84od6a', '5884908609656152', 33);
    t('1b3fu94ovmgk087q', '50894505143084876046586', 32);
    t('bf4g4g44i2bg3gafdh', '352245026857755092633435', 21);
    t('1bhb8os3jig8a0jjg509', '8544492060848011899078076234', 29);
    t('9bb889jb0boh9004ghi4ifji999', '21001275121677892617892428312654193359', 25);
    t('1', '1', 25);
    t('175cec17gd755f6cebd6d71caab7', '2387636247630379533351295291428493', 17);
    t('1q3q4d1m332m2bkaid5', '114462382134814329996673745', 27);
    t('1435cb611aagd2e35026fb46a2b9', '40981399468733686494173008403141599', 19);
    t('15qocnklsa4osrk0490', '463533209002652420364303870', 30);
    t('15240705643046435', '468452863921437', 8);
    t('73c49d6e96842ccc53a2c8b211', '1831900048463710636442691320716', 15);
    t('4a8d8f3oodsg4fy1ua4mzpsseul7o', '161563492183061675654277113651271343378498788', 36);
    t('jx0e9', '29927249', 35);
    t('l7q9fhvql7jsu1rai6g51vm8036882eun', '31048769411271240430732754144531195600735144328151', 32);
    t('12144', '924', 5);
    t('148930a291006200a1468a260360162', '25069985375355798281506802929220', 11);
    t('6646091881a040835', '1207532109684779177', 12);
    t('3e4i0f1chhb7c', '27052411261074351', 21);
    t('1312221302201230200', '127402646304', 4);
    t('f663flb3h1cm2fm7cia24hb1lh265', '2052532182599394731797271980461818317874', 23);
    t('29knujohjz5r2x38fcil', '841388446955060573107520827677', 36);
    t('1000101011', '555', 2);
    t('11ah5iab16d64e51kg0k7khkb233250fifk', '967644642858844521497590773738918042685372937', 21);
    t('17108461113891045589910352983286918980713352258990', '17108461113891045589910352983286918980713352258990', 10);
    t('1012000210011211001012102011001112011210021021220211221011222220022102122111102200001002210', '10353644175713994607088273235575881655299917', 3);
    t('1hb3083fe2j735', '283424846911969208', 21);
    t('13340672a7748b5cb36', '1794939665419760555526', 15);
    t('1321012003221112321200303121230000110100012002320330123012230210303221', '659301932561021877769528555071668952911081', 4);
    t('47013a004030970099911357a0750aa569aa72509508244576a3', '598824846543948874720639846647786926677632860889870751', 11);
    t('k59bb2gfie5g1', '149027214830542483', 21);
    t('93', '228', 25);
    t('2244514405433141213351312', '11689824549798354428', 6);
    t('3391990050', '3391990050', 10);
    t('322240420551002415103245414443533220432233513', '58925535053757685361596112546437173', 6);
    t('1448918iehd5cd705a94g4b2987603hcge1heag364a', '623766172807410187823974273716557093465964345387560462', 19);
    t('vhh8f2apoddkcbte8qd2cv6eo07qf8l', '45026967317927008054648848145141282924620758293', 32);
    t('4gcghhbpm5s', '1921232692885665', 29);
    t('a2tv2d23w5ax3vro', '2228115152562528794000532', 36);
    t('23fbge2h54fb39', '46123055007002883', 18);
    t('1211013220130122010000203133130013313230032100013112323100', '32815072429253845963147847323709136', 4);
    t('63665b4143847051bd8112a28125339', '151192052168606148985101333943415831', 14);
    t('121230151444000352035', '5018902103174711', 6);
    t('17o6rjepo7o', '379407511108636', 28);
    t('3e0jd35h9fj984ji0c952ha6a0619ei433f64b4g', '2035447414961080260067064298213540337611882480996496', 20);
    t('9qoj95o', '3872991264', 27);
    t('2ehjmmpq26', '48937594118466', 30);
    t('20203010100313111', '318125401031', 5);
    t('16624342084015440626027666617826745786663', '257801163001691389520291595409112640129', 9);
    t('99ja4077kkr89mhi7kn2lin', '642847989448256643908613736023263', 28);
    t('1200022320121322202111310132001213031202322103211003223112', '31208956033081947189359407770385110', 4);
    t('ch3n6m933c1i68nfdld7n8beni82ni', '135036167864868994578206007145405022688954', 24);
    t('850dgbj1bina77q967n3icd', '562583517839371187906929749349565', 28);
    t('1c1b6hf2b6adcf19jaf423gdf6985djb7f9b', '5511020452322809692026505861258306260094622191', 20);
    t('368h14b3a9iceii0h6837ag1g1', '310916278043275877944347017914923', 19);
    t('1498c6d696hd218ag5a38gbd23255a3056758dd', '4840693541321204605632050758615059700032223696728', 19);
    t('1vbb', '64875', 32);
    t('3337pb61glb100lncp21', '2391589725484953912041378217', 26);
    t('262523728', '116165285', 9);
    t('5dd205e2db781f491bff', '443054323304979904404479', 16);
    t('bfa04g4ghebgkae5j56ic11j', '30241293639507272594473537217404', 21);
    t('9bg1a88d', '32375211230', 23);
    t('3164e8k31407jd14algmcl79', '169629850617492399214780875675633', 24);
    t('724887434828033700521303', '64556976680043023374716', 9);
    t('1030310123113122032223011230', '21622677210575212', 4);
    t('h94dk4e', '1974926286', 22);
    t('620022671924219242429260867884371762289253', '620022671924219242429260867884371762289253', 10);
    t('637151001154473265053799092722218122', '637151001154473265053799092722218122', 10);
    t('140388a179a26299bcb19c75', '54670958388535719430386529', 13);
    t('c0q2e8ilnral78q2a1pl', '37703922421575356885249800545', 28);
    t('15e88026c3393905e6b3db31ccca6b7', '268084119743214063479478076068474022', 15);
    t('5660c7b6977c29ca6', '3658116372348412435', 13);
    t('1l', '45', 24);
    t('2meqp7a6g3d510aq97l0kd1gel3', '46566148499279171126893633952988857703', 27);
    t('10010011010001101011011101011000110001101001001001000000111111101101010000001110000111011001101110100011001010001000100001010101000100010000110100010010', '3284369793875476139142406227062347521500187922', 2);
    t('1519a3010603c6051198c8c744', '9843602098699228915851703184', 13);
    t('10210220102220222021112112110001202201210200001022000010000002210000010010100121110', '1690033786016843276059524636331001957853', 3);
    t('674', '952', 12);
    t('3530013143266263651', '66147388776605609', 8);
    t('6g9jfk60c173eb5j5a8id7j3ea8kd', '71392844079040287986961370661351593891', 21);
    t('1b5qepfq17oceqlrkb0j40l9', '2697119998800124545301978047134805', 28);
    t('4f82be1gec8c4c93080174', '1114866884635660480307604358', 18);
    t('84lb400kqln0d4ea3c504lnfc1cfnggmrp8', '429932989531641627287877704445651412410140512616235', 29);
    t('1213031124022303141133121134110403143023', '2664899547599003947569974763', 5);
    t('5972204c293a718d436', '2424395701327022173624', 14);
    t('48c05660c35831096571569584b9bb', '944525160078047876860764786207444', 13);
    t('1737j8ged2j9335f57579j018i6edde42', '583469808841264533540282982195940270989682', 20);
    t('b92a4', '3775348', 24);
    t('g0a0g3g3ed3', '57238226797917', 18);
    t('c00ile7i0a6e7059d0k8k', '8466411686951123921386451716', 22);
    t('1417a983839823752962043864a03', '198707395183668497169407615155', 11);
    t('212020002201', '457156', 3);
    t('293ge61a0554a3fg74cd4d708fbf2f4', '20837793831755445803430404484447203673', 17);
    t('31ksjf53lo5lfcelu4kbm', '2051668901240245477484691606434', 31);
    t('18b91bbda46660aa90d0bab167807cb51ddbd521d3', '159834746906390155881812965963138183604335984605', 14);
    t('a325a721', '200595880', 11);
    t('111220333303003000330232212132302100100322220331201330230213123202330231230133001331', '126510946622282313351146590205348811859694558769277', 4);
    t('3nklanafm65ed90g78koh93do226ondn7dg765', '20928977098157474166932241491953431194495934644004530', 25);
    t('8d56gggg3gl7fn7d6k273k38aaegg', '3783755977257147057647496235991570373904', 24);
    t('jvjs', '783286', 34);
    t('3', '3', 16);
    t('2dm48dk09h2mf', '57135037288325649', 23);
    t('7c58km94ogkeoecfk3oji2b64e806b', '808192629771412919893870560197459472754247', 26);
    t('108ba7dc0b83574862fffc703b989d5b578d862', '5903642409059499044928754369694490849414010978', 16);
    t('cjqnk4gdjh3vq4ddj', '15256476694176334186952115', 32);
    t('228kcgi0di3fi32idcda4hk', '259572623213169656398598069717', 21);
    t('3ce10e4g6mc3m', '77759411065315097', 23);
    t('2c7323b8', '305067694', 14);
    t('10022103330001303212', '285949828326', 4);
    t('3t7e2cawj', '6892011752699', 34);
    t('22', '28', 13);
    t('464a1', '287905', 16);
    t('5cc2576599c26', '759539534269986', 15);
    t('jbj03hlkdha41fmj4', '236168166638253520612684', 24);
    t('0', '0', 25);
    t('2sn0577s1dkxc2in2lcg9c01qif5', '1380060804894799857868555382265618092450455', 35);
    t('32h3b8bg', '2818270187', 19);
    t('255545', '23321', 6);
    t('44672701365702351354627010564700332716441663244', '1605697031030267612185423502895189353522852', 8);
    t('dg6', '6075', 21);
    t('172f', '5935', 16);
    t('ff79a62d5304f3d99d59gheb8h486g96g8ahah2191', '46385498914881808944086334290535921747293937913848583', 18);
    t('15141', '2437', 6);
    t('26460b23b58906', '270831364391958', 12);
    t('3', '3', 8);
    t('1nelh6fd2nm', '385460235648697', 27);
    t('555002132250423043321044154114553040535143212221300403502105', '48649779907252203719145936253957752216789784697', 6);
    t('502c614709d225ddf70geg70ad7', '491428972626763333617324944411991', 17);
    t('2a809', '43569', 11);
    t('231025152544454503423105544545133222512424413141345', '2044955716085193393522162227889590083649', 6);
    t('6127516', '1617742', 8);
    t('3001212', '12390', 4);
    t('61k8t4r', '5372388005', 31);
    t('558hhgfj0i392d5149cdhaj4c81b3f45c01f', '10601211512457181022617948775789014879554131318823', 24);
    t('5ai55am1f3fg3368080ag', '9386067417807853412865332671', 23);
    t('375335072413', '1049997224103', 11);
    t('3ulp5k2gfak4vwhs5xp3fp2vt91q1vvgf', '99640256815388464443077052932078228628581826390175', 35);
    t('3cb5204i8gdhk31k1ca1jl12hji103', '3039225421760116368864520168279113397031', 22);
    t('95g0pdi85jlch9', '146430211203929468319', 30);
    t('1ga94k3', '253927869', 23);
    t('17eae76fe4agb44b', '9674350126680300347', 18);
    t('731352357080453082167066163008066544870856880624501815', '2761694377915234883111996820445810369791439662349049', 9);
    t('28b42eg3fch6h17ec1f6bah7a46gg0ba8e8ge3728', '402898479377320666571762561009961282566338625627456', 18);
    t('47763aa67667199503a', '26126027821437042586', 11);
    t('1a1513a229241db1a', '3748786654473436012', 14);
    t('4j3wlppbfgjvx12bhfdraxhj8as', '30035221592107391008826387409658384272600', 34);
    t('4a', '66', 14);
    t('11dmgo0pm5844ph95n0es4r1js8oh53s531m', '1605008834095669751131228638721128071723402662779373', 29);
    t('78ac3g919991730dabf', '4671636511491254279401113', 21);
    t('3uen8v', '132603167', 32);
    t('18n1jhh534ed9kijd36h9eh926ajj98', '1176935676756916434242879253348138978824608', 25);
    t('c6lida42bb7dibkb2ai9038j1bff2i7425', '2457445295804537407775390175826401409277343241', 22);
    t('520451821452737', '119611394254600', 9);
    t('111010010000011101100011000010100001011001011101111110001001100000101101100111111110110101111100011111000010101110101001010001011010', '4955975645658396849750021048094688973914', 2);
    t('2j535maaee8', '177566375337176', 24);
    t('87doh4mu9m4upmt8jjj8ppswm8h1ntc7c4', '18709453669151556448621559262750940609280449675917604', 36);
    t('ki6g9a9c2194hjk1', '1421884784853472743133', 21);
    t('1uu682edcgoe605vg08aul', '149927190638896493897053359305001', 33);
    t('33611430560050523326063140530063215636236565634401651316012153', '12640761518619389588311599773840813250762104347169015', 7);
    t('2e7mc3jal7908e06fm', '5447254724723092802070793', 27);
    t('7i2ab92gccil8e5141e75fnpkb', '11544586496253437449398718886123580939', 28);
    t('3ch6i46h3c9hj4d4', '245970537455421763324', 21);
    t('341950453278908a8a0005', '153920651144564889561605', 12);
    t('157396461156129428907782692155506630549', '157396461156129428907782692155506630549', 10);
    t('4e8phiqe', '77509233466', 29);
    t('h61b8f3aif1921abecg1fg82', '14515588347289719209260339486562', 20);
    t('49eb10560b24720dc8d64d9a3869c21b64c7', '679348185541738001210448180139429111150087', 15);
    t('1141752865644301566854274762894601647406769493', '1141752865644301566854274762894601647406769493', 10);
    t('519569635591341326218616477948', '519569635591341326218616477948', 10);
    t('64coenh4m7nclcdok6c9', '2248552578979295785537035309', 25);
    t('57fdf4f5g0f9d84iib58b0f1edi4f1626i808', '58679471173751985874228442168831694410618065700', 19);
    t('7638a5255', '3236027681', 12);
    t('796623821741144', '2989556390158705', 11);
    t('g21m964mkm4mfjb5nn86fe0cj7k8edbha9i', '1360344415859629714125407839865176137228200369514', 24);
    t('323322023301122022303233132013010213321220101022220011321203', '1244263825928288441278865283502595683', 4);
    t('3c4gd68dhibg23f5ie91e0226c', '1212014021547517721660786028816932', 20);
    t('il2204ha0bc7mkimno87f', '171379074171212894108622645815', 25);
    t('3078kt6ygmvmjoyl', '435509192168873571302736', 35);
    t('a38', '2010', 14);
    t('665354580258', '665354580258', 10);
    t('b6iljh', '89840921', 24);
    t('12', '8', 6);
    t('1100100010101100010011010111010011011110001010011', '441284718869587', 2);
    t('103425a844c64b54a799c19a8b80b8360', '451483347908514778430800009719438373', 13);
    t('13jg1cd', '133462793', 22);
    t('15r36doe4lc5pu9bt7ajk', '799090626108561656879167065895', 31);
    t('9e6d58bifcddh8f7e8d566551gf', '17251970079387384841395849025324832', 19);
    t('1111122112221020121000000102010022221121002021122212002221002101011012121', '33917854345218936391135563425595112', 3);
    t('4990l153jqalbca5518d', '93177576163241292629115944053', 31);
    t('1010110010000010', '44162', 2);
    t('28b6338a', '98418778', 12);
    t('36503hg2d8i', '309754322695843', 25);
    t('1n96e8nk86i8', '44503394396446494', 31);
    t('sll', '33103', 34);
    t('33033011220200223', '16359262251', 4);
    t('99d3129gc76egbef4fd3gbg4g11f1d70', '1333694013824598235831401355357401336069', 17);
    t('97df0ig25e8c8bgicbda68g287ad2213be3d9h5', '36818894414378796947469929289289701562088950063034', 19);
    t('4h2d93ahb9560361i7cieif04c99da16eiad747gh', '6926899048124838337587570688835924691980039686118308', 19);
    t('1efa78a04b9cfae15i608', '66906711299008903988241970', 19);
    t('6dajh82l2h39k17l89jj06b6ij1d38l2ah4a', '638587640933730076874373620811221314023256400630', 22);
    t('29fikcgql9j9j', '1231539340753070389', 30);
    t('3da62e0cd7d5edc8b6731fc', '1192467796933113553619464700', 16);
    t('167i437dik6224', '642946919459203965', 23);
    t('2212030030033111020121122', '730913496663642', 4);
    t('0', '0', 3);
    t('a934gbe3eb6gd0686eg7ceacf3g', '1034060133939988465057499206465869', 17);
    t('b06bk9d6g0a42af4a', '15757568799670003822267', 21);
    t('11813a068978a723528a6811a04418872a25a97', '4331585506586356267499594006764356259902', 11);
    t('o3emg54n6mk8fn292gdfne0', '137241894959729632465723306108475', 25);
    t('26f70gdg0a75ge56f63g2gbda6e', '236057761685701334850732917197770', 17);
    t('8ujdov2cs356b', '14889117743117384096', 33);
    t('p0p', '28925', 34);
    t('331331554260223242', '804688549652157', 7);
    t('9m0508egpmhni5gm7aicn07dm66g911j1863f', '8556964370979913328368960003720919994571132796665125', 26);
    t('97659', '273516', 13);
    t('30841783490097007741741271081026', '30841783490097007741741271081026', 10);
    t('4q4sqdqsadn8rck7bhjsos61kniq4qo', '365053872988495536844847225543861276332385142', 29);
    t('3085581349916184a854518229397966', '589317025721598516831908960908549', 11);
    t('5r4otco7ld', '116235391074943', 30);
    t('h881s7ng42l7ktf', '8262879069644201817885', 30);
    t('722935123087', '722935123087', 10);
    t('2211424', '271870', 7);
    t('169675b23386dc66556b4', '123567084465286023095006', 14);
    t('1d1460d5', '725910715', 17);
    t('101110100110000101110000101000000100100110110100000101100000011001111010111100011101011100101010001001010011001101001010001', '7741948260639498696423377430502808145', 2);
    t('6324dl7i97ejh30h7d2d', '196908817838272957802386245', 22);
    t('1e6bdg9840bij4m6mgaif0b3a1fa800i', '2650595719449645853646782554686853038953647', 23);
    t('3op280u714f1l5c4e58d3n195wgdadon', '2722922194519046542296617636311541345690187538038', 35);
    t('4ul4gph', '10556594837', 36);
    t('neepzcrwsljpq56yw5fe1p8slc2q6h', '31768227704262634163351278216775977989668712713', 36);
    t('163508485687', '53683805509', 9);
    t('kq1f5osda769asejc2', '151662515754458740001154937', 29);
    t('2bb5kba8ij1n8kcg9i5f8d46n8425dk6l6iac8', '2896620834535199514593225193367996812104377232901032', 24);
    t('13fpo7ebe9ibo45o7f38mgcoh3705kc', '3204372840607139571307714097742381921592280', 26);
    t('fl1976f57ha23jae159kdck7e', '2636992324538165186145579853041064', 22);
    t('421d5154795bc24eee09c38bc0ebe5b8ee29273a675ab', '23184471520376505532353622062217664262369811465453661', 15);
    t('120cc7a219303044926aba2366c8a981b4704098b34', '70792117155249797617821261835217822465201863468', 13);
    t('706069779aab536435babab84561', '967362705785425743632483240473', 12);
    t('587ci2heb9f6ha5', '8878675397855255005', 20);
    t('6', '6', 22);
    t('101100000110111000111001010110010000110011', '3031053984819', 2);
    t('g402fj8dc41h', '15410872733788423', 23);
    t('384cb1e378c31062632840835ca792', '45443550340307284975305780784392962', 15);
    t('709120709950241446662286143551107773877', '709120709950241446662286143551107773877', 10);
    t('10110011010101011100010110100101111101111101110001011111101011011001101100100010000001010011011110010010010011101010001010011100101000001000000001010100111011111110001011', '1048393860009702438276451118840918885709561673793419', 2);
    t('43530143525312435203035354402132515250345350110051254130', '29245051644396815096043409979498563547760486', 6);
    t('273874118720265720003330', '25054867528860327211665', 9);
    t('75chppa1pfoc8', '5650988903040886596', 31);
    t('1o2xzq0y85nh2uz4hrq', '17214140131662303072328011254', 36);
    t('7mel09lb2a8a57gbgjajae1231gg63ifi', '300296405223222733629146932689003077500853453', 23);
    t('9h797idhg6bf82hbneffie06d7n7n6bj692', '822053978411404614899330556271321295033323274330', 24);
    t('2231451202332013234346554405060630261020301565243616052163120', '1194780384819131090196038746300735825418428054448297', 7);
    t('651308764720485861752385601247', '30955749937585936729212961915', 9);
    t('wisjnua14a5j', '3141478047294715819', 35);
    t('1f287eg4d1e96aj275810j2b76hk6', '65295279177191049973439872523750757634', 22);
    t('732jlm285a7', '452060572081207', 24);
    t('543a6a7205935', '16936274072569', 11);
    t('11d84024g1e', '2228646074688', 17);
    t('b733f14109d5b25bg0d4bc03ebag43945g86242c1bb1', '927003510624924525673202158389033192698291798479053046', 17);
    t('baabja1c5fhfjbgb7a248bkhcgk', '274413406419696811582074157627497260', 21);
    t('12rkl64f6r165mb', '201505391341491620163', 28);
    t('86nnhl7wdo3yfaupk3gxyn3b9', '93531275000126027219179909918998577069', 35);
    t('9fa97a6685f7f068fa0c7c7c', '198055880094540331320903211843', 17);
    t('53b5607598a8568405b6038b056b', '732126558636324783191109176867', 12);
    t('1d38dki3ecf4hb2c', '110820443100982410906', 21);
    t('alicf731m71ekmfb7', '132157470326092217910991', 24);
    t('2946f0f6fa', '498579612616', 18);
    t('p1m5fba4i9c8', '139351741901234288', 27);
    t('491npjfdqp5o0eok5m8k83d272p4bpa', '37843769272881591548066267248820470893488566', 27);
    t('3sp139s619h5fnr3g43075g41qrphm1274', '22020285331732361216643228764147906649510745949014', 30);
    t('1go8q2j1hfhkp8cnecdgthoma', '440682856002100886822190646729771270', 30);
    t('1l69ed12hc2i7d2xo3xp10s585gnj', '27505025872397325904081958842489980594333549', 35);
    t('7jam53fgqrsghesc', '178900402668575769571705', 31);
    t('1ta11tnjsu4sqnkctllg5r', '146148626279942060305711089820179', 33);
    t('38549293', '132726351', 12);
    t('erj', '13429', 30);
    t('0', '0', 2);
    t('aps76', '12788364', 33);
    t('i4f689483a05fg79dd459', '1912424668215298964958985709', 20);
    t('2l129l', '27751496', 25);
    t('2303412343', '25367175', 6);
    t('549b8457125278', '578041793560892', 12);
    t('120869707199141380905a805187000259a0606312a8878', '952772077272503697711661443135381708565035744224', 11);
    t('4s4ie4nc0dg8o', '5625644808984248600', 32);
    t('febb3g4036', '1881263605907', 17);
    t('24adgbd8nbf0k', '129751809901743770', 25);
    t('g27i79d5e55896i4fg7a245', '218847629102163139699173355291', 19);
    t('30529c2802a7a6500a48164', '9734582938146405358147470', 13);
    t('13a77a7280a338383a965945211402', '2159245188374564306148810546761', 11);
    t('4ahj0705e9i38hf4gjj1c4bh27jge090i1h05hi', '124928632984691876439135258471206747484391557922358', 20);
    t('440313525', '26407491', 7);
    t('kmm8mq0bl9', '1627285397199219', 35);
    t('43hqv0r126', '144649097151558', 32);
    t('1048b51ab04b2bcc558ccac705672542b3db9', '186529630154587639414052458405508817794479', 14);
    t('14423112251502214140350553421432332152103521123', '1116071013468917454980382318315110091', 6);
    t('13mn8ak8okaa5', '68944310390553380', 25);
    t('38m9915e9g1gd051akdkke5f5a27jd58ej3', '67448136771996483355341359401090802088684251372', 23);
    t('kq86qir6d1p29bfceqvf', '824785809235191997125198572527', 32);
    t('1112321020311312133310021133020222332223221101322301322220113323000222032', '30277716024835658731702957127157570855504526', 4);
    t('208408904304224157224980647150862034543184171614714', '208408904304224157224980647150862034543184171614714', 10);
    t('1342414184334047452273', '151665011409098573076', 9);
    t('1la8c107nb8105l7h8n2d4nn', '263830603401598394475203594737473', 25);
    t('luz2', '1019918', 36);
    t('9k9fm7bqw7yyerjs2k764il8lqq', '133997186940027427483405272900623275104661', 35);
    t('10x4cf7afl8kevixm3d0yxgqt4jfe', '38674921472624504070368294249321086159708250', 36);
    t('11011000100011101011010010001001101010111010000100000110100010011010100100101000110011001000000101100101', '17157448231253463055811180527973', 2);
    t('123466063012654210205425010534440020', '515748143498324939176731633807', 7);
    t('33044012241110', '4441524530', 5);
    t('1158b5a630619185', '17305771835233973', 12);
    t('7n0vvguft7mnqbir', '461401544473301116074780', 33);
    t('567a95139027a78a', '23440483786358649', 11);
    t('10002000442022441044', '19134759968274', 5);
    t('4dfc', '63156', 24);
    t('312a406aa3450a3a23912402340a01966692', '8754550707437018386514400792052318480', 11);
    t('cnddgk98jmb92cga29agigo17ij02oc44ag7k', '2740506289219815903046559261127339765453793253682070', 25);
    t('112002022001', '277237', 3);
    t('13185359b8b7cc6c', '63496717433440602', 13);
    t('rdp8', '670169', 29);
    t('a5945524a0ba9', '93456277979313', 12);
    t('2csg3gpqajhsck3', '1829362423553209975227', 31);
    t('qawko53qgbm', '54339224712711276', 34);
    t('53a8981b9513684a', '82035316765523002', 12);
    t('161b048i782', '21503214153206', 21);
    t('22102400412123042123341032122120332432011302', '2779064502733276433175230344577', 5);
    t('idlbb4187e191dd42', '114102484434631244007167', 23);
    t('b1gd8d', '88149517', 24);
    t('87aa5220276', '536130980730', 12);
    t('17813c4bee86cgad8acfa4gd6980122g0e1c2c3f', '1398872946976482742153451223578417416198761226747', 17);
    t('542516a818ab733164bb11a0b90448b54385562205002a949', '33811866838197068550203974493168709163294532080937673', 12);
    t('34', '31', 9);
    t('ulddjl1p7g33c3lfi', '243484528223299178648975166', 36);
    t('43685922830053717349636937254384863641936188539078', '43685922830053717349636937254384863641936188539078', 10);
    t('1kq', '1526', 30);
    t('h3q4', '417894', 29);
    t('2sgpnvjvimhdvfte53e', '3579393219704746078446752878', 32);
    t('2g0klh8m51d2m737719helbbmhfb13aadf52k6ba', '345403492723336949220351795875996776734586242292103572', 23);
    t('34534434531104021501132204125434', '5071162229234026722846814', 6);
    t('18728536442631514847167146206666864236812842053', '155482283694964503460685159464849077646366146', 9);
    t('1011102210012020002010101120221020201200012022022210100200120211200210212112000', '19121766375891188407348322182261750770', 3);
    t('43xd87t9i3wc5dy9urecm', '31297925864315303967241520625217', 35);
    t('6tn9585oibr', '5704387543834275', 31);
    t('1odaiw750phch8k7ghptsrbd6r', '332539724961043900901068288669103492707', 34);
    t('235a2975935301a79', '106684220535281420', 11);
    t('42ba', '33030', 20);
    t('j', '19', 21);
    t('j4rjbgf0d', '12573534055513', 30);
    t('32xshoix6xh9ccr30', '9848122710986064368393554', 34);
    t('535', '203', 6);
    t('16077c0833e289da0b', '406367684695924791819', 16);
    t('3m20fi3q3lm17gnmhqpjbpmh3eo4q284o', '235527531251668145423074205329962075938693335711', 29);
    t('132db2098c07d5c2f3db90fc9dc5969f4c5ef8', '3988017842540737733695567767722086300600078298', 17);
    t('1c85d01', '103725201', 20);
    t('1001111101111001100110000011001', '1337773081', 2);
    t('vwb7r7k3g5h2c3r97q88rp', '2475548335462435623069755240245930', 33);
    t('5qrlb4tcb76enmfllc6l944m16', '49968491826455815316033134152951067836', 30);
    t('110020012122031310100', '1383087004944', 4);
    t('132102232221032133123312103100322102332222330010331130223031113100023031010332322323113', '11333821350115864348147427574650948754682805810343639', 4);
    t('60370776342110666', '60370776342110666', 10);
    t('3h4i4ejlfjg0688l', '6140106694915716688693', 26);
    t('1dm8lihi1e26ahfa1fk6g43ibfjjmg37', '2628602474297861320421568139067733120965444', 23);
    t('aebd6h6e4h0h3g6', '17578668715830537526', 20);
    t('3v16buqvxdcu0pl580aduqh59t4p1ytyzw3', '317029270815082851172083917802213165659300395303124787', 36);
    t('ef6f9235d0afe2e5cg', '12331072171139724632698', 17);
    t('1010000101', '645', 2);
    t('687cab97212266004232ddb3d3b9e', '5597607870848036280745860522464624', 15);
    t('10212311222220113132220123112023213020301012233202002122122321233112231321220233233101003', '110312191634483651495896170224950641069551786395628611', 4);
    t('3832ac25760c6957d0a4c6d213458a5dba00029b3', '25115577925068533589911218721261542504047301873', 14);
    t('7chebcgc', '6865651019', 19);
    t('4nn', '2879', 24);
    t('a321054270b305ba0b66ba3b6b56339', '2436546585202095704641104341508957', 12);
    t('1l141elo4mkmm50cok767dgbhnl859ea223a099', '243768152347675786552797555960516182859457306417343984', 25);
    t('3gg7mpsa4mef', '43568856039788618', 29);
    t('dn', '374', 27);
    t('3000445345054', '6538448122', 6);
    t('320403212410040111002033343341141234242231423043134214130032422404322010313', '18174722812021434932358160186198714046154568563860083', 5);
    t('h7963j9697ilenpfbea65fnh3k', '4092136993515034862901357828279507182', 26);
    t('44d', '1693', 20);
    t('9lif165fb9am8i5i6df725ah5ke7kakmimc8', '4552222216377737849505813807820250518334913223674', 23);
    t('95cc0a9523c654d1d87c6c8c41da3c0', '228044297514817056310395998663259348', 14);
    t('1eb5298', '22596218', 15);
    t('18d15067c13c7b96546a0bd03811aa0648', '108794139679161970964043442876985805816', 14);
    t('10c8c5c2', '3484449218', 23);
    t('1130241183031735622176218077807830726640278265535', '7307690599679782626468030026978745315150762698', 9);
    t('147hios9h6pc49vabeeijibp7l9el4juv', '1654964473386058879615178865366866020965350002655', 32);
    t('2hehe758c84', '18001465765974', 19);
    t('27ca95172', '17128511655', 17);
    t('11a64b1364976db4501b4641', '1249071479135368641718518661', 15);
    t('oalp077scqppkgsithtf2lgmdekuhltt', '415553692412432987092587239826921522135844076896', 31);
    t('24512544314343321411051', '370182538802982343', 6);
    t('18762343i219897i8bab2a3gii7b7h8f34a', '43289966715277773748038371629470766822398253', 19);
    t('2pi', '2286', 28);
    t('1cbbe0h4g8jcjf8c1f1e5fkgc', '259324373962987253102359495935860', 22);
    t('pt', '904', 35);
    t('1pq017hmfclcb9', '7949466399349926747', 27);
    t('f7a3a6c5202h31ef64ef1a142e', '371455948373140075962244702804106', 18);
    t('5391521717249849338', '5391521717249849338', 10);
    t('115048968584225548467a166a8505a22189', '3182768778233114520385989554018322385', 11);
    t('784c5768a01120f03ef7a73160baaa0c5f', '40935359210071367599328032328982052080735', 16);
    t('a79a1616597a68813', '492505903090120637', 11);
    t('104302302000041202003342432402432', '27586639009156197153492', 5);
    t('e6', '482', 34);
    t('10a9ba011b397214372673b869154', '1772448509226592504876544881552', 12);
    t('b529388682ca681a0a211a9c291aa525a569b89', '24365646313226855959855845860118543252986104', 13);
    t('60266784078122366807652381741868036523827834044816', '345530321229050938748463990139827078607744866078', 9);
    t('nrj2wqd517bt9sf0ji8', '245119446680615904169840513472', 36);
    t('i30lg31967233dca599k9khf253', '13925405872348342338134182452445003515', 24);
    t('2ryv', '120046', 35);
    t('11a28178b2d3749352dd0688d33325000b80c1d7c21a73', '4229526571666583429911018550162020409543001093510565', 14);
    t('1hlf33b40v7pqogpco5h', '61489711252104567972030734513', 32);
    t('2ooqt4ok6crqcqoprok0e1e', '1807700340428814411931323774855651', 31);
    t('5330703347212770743451273354450142023332067068', '46881764614088473306314988288234150109880758', 9);
    t('190411146532942276953175', '190411146532942276953175', 10);
    t('1032', '78', 4);
    t('220311100310133201101213211131102122120103321313021203300230312221332102132', '910589190412628421660420436887035984747160734', 4);
    t('53aiqhbd26i4t3gpnfmpo9', '106372792078016060806151089912464', 31);
    t('1mcshrkt3vuow', '3957079661421807504', 34);
    t('11420140420313400023142434242130143320333001404323014032011441103301014244', '1457518531908973605405978898403083567207549128141824', 5);
    t('265210518039651538964229872a244598261186', '106497114458263044665001931751128560884115', 11);
    t('b5b39686', '411895686', 12);
    t('9693g67fd46443ch29bfad5', '391033997087892318025118684265', 20);
    t('6aa1787181528233441a875', '569250946715170907346131', 11);
    t('1534821551365858622483716488168', '67797697219511094422985323240', 9);
    t('2u5h5ch75t99h7ftpar8epck0uf2l2thgkp', '1512058697304555562850007013279347701338862065083953', 31);
    t('364lf34159pfld9decepegn9jnc', '19932987570255245395513434170488890598', 26);
    t('cjbxwfida', '28266954157515', 35);
    t('234422033140', '136517920', 5);
    t('5d27dhru9i0rolnl7k5cc04d', '224657379433425485580575516892987533', 32);
    t('15d96d637d18724681c68', '119388782053752864730372', 14);
    t('glgmfg19hmbiuw8gejqlushd', '2785871717038208979814744954063843071', 34);
    t('fs27q3', '327526525', 29);
    t('1aj94', '742369', 27);
    t('2rpnbci4jt3cga9b7k7ri2kq951k2l06opu3', '45679643141383333963769732373782633717189382232076574', 31);
    t('2fvp005iv45', '6770745914953620', 35);
    t('3739cfai4g37d8ehigiiaa5c5e1017hfgif34f34', '251228158449149553590458723730036424872270586078914', 19);
    t('100132020020131301313310320', '4636099868065080', 4);
    t('1hufs4gy8ux4t98q', '330662166686009999383562', 36);
    t('31141410440222032202444232140002403313304013141143142112332414', '14202859109742120451995012678655132660667859', 5);
    t('120314021231222320010021120411103223412323023', '8111041563265329020880984104763', 5);
    t('5', '5', 15);
    t('22356', '5676', 7);
    t('23', '45', 21);
    t('7lgn37jdpecj6403d0jom4jna', '71329726048559149957340654751993676', 26);
    t('113lhxiw79qpwyjdlpgn', '224270117034921406000339777208', 35);
    t('e62poemoo3e9cjo1l4', '16140263108781826392138362', 26);
    t('326167dc1c29169ddb457e2ea74da9540', '136353349886424397650412714901640659685', 15);
    t('a280710ji1he43a427k81fif1fa2g', '106423632510333355935644382252587269768', 21);
    t('0', '0', 16);
    t('4bo96rt0bo', '263786477496742', 34);
    t('111110000001000011100000110010111011001011100110111110011110111011010101010111101100101111101000000000101100011111110111100101001110000011111000010011011', '11064110199645779468713657128408705698455744667', 2);
    t('rc7', '26326', 31);
    t('9ci9486917f60e45b082chgd4c63djjhcha240d6', '5303028473960156575531077483320594119475139680352266', 20);
    t('7f6in4ffhb1flp871ipcpg545o56c5', '7001603956717371881956901400431902260257909', 28);
    t('7691c95hhipboj7rg2lj229rkmhac45b8', '147212537247130546499231460140529489308763331468', 28);
    t('1rsi5r604m7ioheb6fcl4h2bnlcfj', '173989478506881942888773260671258027309887', 29);
    t('b4om1cj2maljon40k9e6a5', '5798208632384734824227289530657', 26);
    t('11eol4ua776vdblm882h3qwa6h0', '6860908597449491750120493068938147873066', 34);
    t('12121010010220000101211121000222100022201020', '612407733641262215889', 3);
    t('5623882688c3a20370c29683af', '30933873734949067206794851517102', 17);
    t('7p3014mdoasx', '1013060656191967665', 36);
    t('2f4i8d7g63149c81', '90515183521475916961', 20);
    t('1037028086382201343445', '114527582053447761554', 9);
    t('cmj', '16363', 36);
    t('31013032010320201322221203203', '236219413687867619', 4);
    t('xrienrjyq3vi44686', '171329229726722909956091011', 35);
    t('g98pi5f5i37blbo3e619', '12538983223080485163975508379', 26);
    t('6gthi0fijlk13kg3m8recgqcsqi65h0', '1351923881091471085665472649762970950098547010', 30);
    t('48920165m2204a', '2200120683667985813', 23);
    t('ba575460a', '5104899946', 12);
    t('9eq', '6965', 27);
    t('298285791a0888b970036ab67875b9361668222', '286515785301458024010310865718090862556474', 12);
    t('32b10239083bbb27a8a9b1225534b956487365', '529271448272229707546432985555718969417502', 13);
    t('3ba90bcf292a852be', '68783684858858197694', 16);
    t('66726644', '14396836', 8);
    t('10q71', '833611', 30);
    t('hd2353gg4ahh2d5', '14134610453581815173', 19);
    t('452202163400753742090780', '452202163400753742090780', 10);
    t('3d9j3hecof6ld5a3mk35io5', '20097704011001101800560987589980', 25);
    t('1200022202010221001210111012111200222000102211101020211212121012022110012', '37817615564406149218083810637238750', 3);
    t('23454344155', '159499655', 6);
    t('bk7lb8gl2kl01k554', '72883403283874275717587', 23);
    t('112313101022313000012003220003310032321110323332332300', '115932056790344637678217394646960', 4);
    t('256ag1pilpennbnalhfgg1b', '67800097110287594251574673904676', 27);
    t('5819b9b905cb0970ce6766d5d5367907e589b9365ea713', '465231703686879290288579188172672651019623788286244093', 15);
    t('948', '2677', 17);
    t('49fgidcf2', '243740232980', 22);
    t('ba8e67fg8116agd0ecd06a07746e7b6c', '1618376196981235195559537216353877633919', 17);
    t('7p75nir4wc44', '543366534313517148', 34);
    t('207526928514479808388641363288479462', '207526928514479808388641363288479462', 10);
    t('11110010010110011110011011000110111010', '260222595514', 2);
    t('22ow3qaizvi3ml84m', '16512328963582356580908646', 36);
    t('dm8d5k9lg4jfk601434n4327ma1', '10702631860631688676459813994309897329', 24);
    t('1p4re9g4k7to1mkbxxi982qugvwfubm2wnb', '20450108624302345417065874616002109798595396729996393', 34);
    t('50a1d7df74babgeg860cf8f0cbbf', '39266851385410224911159816445537921', 18);
    t('11210021110100', '2544543', 3);
    t('409b9393847462143', '2700650788976025603', 13);
    t('7334', '19842', 14);
    t('615264ba2c91bb2d16b27657687d61cb8a68829190d5', '117133480342797205694669610294061082973100299430819', 14);
    t('101000100111110011111100111001011100001000101101110011000100111111011001111', '23979030927343490334415', 2);
    t('2bcl7chf626gjic', '15721285277159323940', 22);
    t('e8jdshpceh511akg3eh96f1n', '61724909151432021746879467844279912', 29);
    t('7ioidpi3fac69bd58h75pd2', '527856824728503952184574006672830', 28);
    t('2012210212121110221011001201', '16892157195730', 3);
    t('7669mmf310dd86flfkbh3l675akb3a4c9i63', '3328050075667048755190343358056273076421320709312', 23);
    t('cbe1kfj09id9fijfd2k4bd6if7i48f9j2a7eg', '4997329333935474233928057995322719152450533537259', 21);
    t('481df814c99e917079aeb', '5449011495668093676919531', 16);
    t('200021121011012220120110212211201112021111020012112021', '39372587067244907527609165', 3);
    t('2cuod2x5qskclq2839s0pbquc6w', '15665344596694415117114470797884328339020', 34);
    t('61d8', '41770', 19);
    t('1132d0e10b1dc7d9d4945b80da4', '4093911128145427008187373761204', 15);
    t('6jbkeffkb3c665', '1948081861707426769', 22);
    t('7839b37889659a675469b685a4774878965116', '65435909692700209089779026721746853819490', 12);
    t('4h3e0o14306am2g2a8m5a1nkkcje', '260108515968753744015241516937732742364', 25);
    t('5311555461504533675663441245372657173', '1750444240707415099769307901156987', 8);
    t('189060cb8888330b22595a73b453', '1990161334123571052468023603490', 13);
    t('d14f6c28f6b1a66f83ec00058d939e6deae057', '4667774422027164788903448529246588503172243543', 16);
    t('5757513a925222715971a799023207', '9015463886750727461068645868694', 11);
    t('10i', '547', 23);
    t('3ldfpp1i4hgel51lhl8coggl2cno09lnj8gm', '127944080850766885182905102175542189745277162709534', 26);
    t('esei2e43m92ifq3rhv23i7fvkp4cpi', '664081559838961998097945329675608329857151794', 32);
    t('aflab0b8e', '1173646657934', 24);
    t('2ag3ce11feg1d147d11', '37187897709081800814449', 17);
    t('1288928', '1288928', 10);
    t('36j3f8hj7aehd7i742i', '47593949304334976393861943', 25);
    t('70eck6mb9ckm13m5k6164hc7a3e2g703d', '264297515812027647476881571249469049684770707', 23);
    t('6al0cc485a5g84jio98ifi94aj9jppd4nkc', '8247805371919561622181081071988922761105885432992', 26);
    t('4054706260215077404512214064677061152506', '679180789158344428977587279718831430', 8);
    t('3123121033311032212223021333221101200333311110232023233201332023201101212233300', '313130279871566800608670339808906134119938157552', 4);
    t('186700d42cfi55851jf1j12ddbd90if', '1520284426625971721505976719940709352375', 20);
    t('867b3d952dd3236d30777193533ea0acd4eb217', '4144999543089127983532268234731096383836940097', 15);
    t('21607142494642a17435480244914366aa7', '546971158677056207712730953612440610', 11);
    t('2i4db77e2f9g2eh', '17593540766587374397', 22);
    t('eg7b8135ag6j0aff3b4h8455ihfb7241di86i2ce', '8146790374268511095664515210088247752112171418705054', 20);
    t('22ib', '88841', 35);
    t('1230232302031112000011113212222', '1958723707255224746', 4);
    t('3abkckh711b824d7dlc7kc50f5lfc903jh', '694110549193234127943850316292345559419640751', 22);
    t('1a6faf864dh9', '101335185654255', 18);
    t('csq', '11666', 30);
    t('peldf6n7c', '16724317232922', 30);
    t('1113212222141410102131431304441', '1180618941657064322496', 5);
    t('a79123bd80', '217898466044', 14);
    t('7c4729j', '487096999', 20);
    t('1cd49d38b6ba7ad56f0h3f69i4', '155274639330332110420080389983927', 19);
    t('101000000010010101101101001010', '671701834', 2);
    t('62246711201113702465222477417147602750116154310733', '1122306478377713902587095609358921499575161307', 8);
    t('crhab338af7bj', '10152189826006295493', 31);
    t('14a51a0a2970459f9g006c5g309806d5f', '3009456851013370386519092081927217660807', 17);
    t('2k2', '2994', 34);
    t('22022111224', '23628939', 5);
    t('21bia', '271824', 19);
    t('338h', '25377', 20);
    t('5222641636635631424', '8687773728715799', 7);
    t('7bdld', '1763687', 22);
    t('58560588242628367536365131', '4277917636306674590636902', 9);
    t('8oeo85rqhb23bn8heg', '198205969424047940045873928', 31);
    t('110112020021111122112101120211020200011100220222021000', '26979604883978349681358218', 3);
    t('40212411423333423310130132', '1219680442848911292', 5);
    t('33573674763b69438683abab62467a22164846297500ab52', '1732108517557715522209626167916098168953157629532654', 12);
    t('rhsop', '32662105', 33);
    t('2uorbofow27vtcai', '272365401628221575069518', 34);
    t('6d8ghigi559d3f7e0a56b66d2a6hc9bch8ac55d4', '498928139884483809004632946022741017481450018749395', 19);
    t('3adeb9d5cgb6c476376578c83e5787a96a', '955161261560504360368030415364335026227034', 18);
    t('31015bf359cb9', '1782296955174613', 17);
    t('10011100000110011001110110011111011101110001101011110111110011000001100001000101110111001110000010011101101001010111010010010101110111110110110000010111110111011010', '14258780956329408244620868751517156468304535191002', 2);
    t('a2ebaf', '98663390', 25);
    t('7b383jj778s', '6031015850885550', 31);
    t('cfkmcgh4e9b19c710bifcedk1', '6095263335022578606276134979387222', 23);
    t('4300224402031123300102132244311441413342', '8374896953320607531654247972', 5);
    t('23mudc42y3b866', '248890986859579133516', 35);
    t('38ge2iga36c4dicei8g', '902238930978105211639376', 20);
    t('12003010033220032023213222112', '108949482152819350', 4);
    t('8de244ec358hd24g0dgh', '6208260500151952090111781', 18);
    t('4os8a0fcvnesa9', '176262234589093130569', 32);
    t('9266oe530oj7gq', '59035236811161304202', 28);
    t('13501034310034411445543051511', '10069554545357101315747', 6);
    t('13gja52a98le74g2kc1ia2ka198484h5k', '10621239938769010401661040302635515509442950', 22);
    t('3lnfcs6hndpnr79pms4rl', '664104835931225383450432803211', 29);
    t('1x2gvx3bv3dvianrnuc7', '247269945120794324823087129439', 34);
    t('1e0m8aao3', '567086770883', 28);
    t('40jh43vsm04ag', '4633680786357227856', 32);
    t('5044045341615306051311146510', '334711131291030516548281', 7);
    t('62577dgab82cc39d', '17565163291072020168', 17);
    t('4440adcc7f', '1362287072187', 19);
    t('6649', '8765', 11);
    t('1056403052652033555205161605402426525', '2973189411870171183261703706762', 7);
    t('4l', '129', 27);
    t('431pqa0cg9ga1j50ehka8nj1nc', '2502289496753859425052816386077486242', 27);
    t('5732613240167571782367688321087552413', '131081400058592141994418041108160236', 9);
    t('962d7915a045dd7b469', '4031321067511146526693', 14);
    t('296awxtwry1ofvagrxdsne2xl5t3lki', '47488752629003449774538666832367750089164079443', 35);
    t('il6dkdf7ch5031gc2edc917jgf823g6b6b6', '83252721133987805751930856697199204387425946104', 22);
    t('4215475722134', '293885944924', 8);
    t('14235542532634022', '53950625103587', 7);
    t('36818425f9ca90bbe7a5b983c074', '1105511449492687971454561936457844', 16);
    t('122073687', '53724220', 9);
    t('2c977359c619b2a50e368272a2e12faa4', '948358531678320636918207632756786264740', 16);
    t('1ut', '2013', 32);
    t('2795131101664a797a3a020179003a156600a592623472830a', '2896979920691545032875120949083037703653537561322463', 11);
    t('io', '474', 25);
    t('529aab41b58281bcc49a806552a08a', '1050423338673734373190153676094415', 13);
    t('43g2adf3', '7527485766', 21);
    t('2bb390cbeed37eb3cc07g3e0f9eca921051g0c3b', '2609684906236620171804092629180580497183714528610', 17);
    t('2gfdk850am77j316jhh1g6dc51i95b', '8423594663327891685667172048428742806616', 23);
    t('1rc', '1722', 30);
    t('15375392648094006750a890b440ab8163', '591409515137761369963146900003400155', 12);
    t('7o5p8m8g0gk6ijm8dmthif4kpq2r', '143800041458103826053584594867124604912372', 31);
    t('2b84f927eg76786hl89h7b651a9581a701lc1199', '319331358330810708432381010329034594655582446439863946', 23);
    t('3hja70k2eg654af9i60ghcahka4cga2cge8k5fe8g', '298299391287001975026249946197438275847645771779205835', 21);
    t('g4o2h7lh4cerm0xshxhlvs', '2338404688421636123000323976076998', 34);
    t('53746157770654301215760653406471005756045764305156', '980109855734296770512774083035337723940538990', 8);
    t('1boe2lob3mb1mdia7efsfnk4a', '176313634322313784050394291476552120', 29);
    t('6102895394796612a85173242a66933', '106319505266114007488585957212707', 11);
    t('j002mpkdge8fq0l6l86ic0ac325ko8kqh7', '10838559599010796633261649462182374112236602961027', 28);
    t('1222102113020213', '1783198247', 4);
    t('4', '4', 24);
    t('223f5489h440gf6f45c9a2g5c70h3c71bb6821ebag6', '111787604760465635211456045075716599160139971202176742', 18);
    t('24010204351221200301421443', '75953507215165005411', 6);
    t('1b97c7449123344a72d6', '39363370326873603896151', 15);
    t('10011010111001101001111000001000011000111000010111000100011101110000111010000010101010', '46815908925437602817089706', 2);
    t('6786f6aaa24466c66772096948176f023b4ee4267e3', '2420882788095960105392950361690122210695410931099619', 16);
    t('f465ic7jijm9da7fd5i0m4d6', '317085199137891998237067454281872', 23);
    t('1801d483751a78d3370bb6819bd195', '2717717024003799773996202145806191', 14);
    t('223d90d52784663b8a787c45', '496625290357492852632525461', 14);
    t('67a153a65674020736842a450841b', '10968126203942490133113632912471', 12);
    t('3gc91839', '2404483767', 18);
    t('fme77w83b549ckmtrq9xaw0c3jh5e', '119174546513911048622366013545047675421136964', 34);
    t('1eon5e2p6hgwvqrmmllbuwvjvbp00o1', '5198336511245033811195969352539905871452815252', 33);
    t('999909a7b8807176b3a561590620867616b0b2410887', '249347755823438371204577699931935970503519167975', 12);
    t('1', '1', 27);
    t('210222101000211020101202011222222022221200020100021110222011201200011012', '18337051074624686676362253945875828', 3);
    t('144813', '339855', 12);
    t('468dd654d147', '77575000215879', 16);
    t('4d8d6b0d09b2e87896571e8', '367073963094640539910552193', 15);
    t('9ahg1d933fc3a72g45497a9b2fbbdc95c6h8d8265c', '257081352042987479986034962212194285056550134922156730', 19);
    t('m', '22', 23);
    t('12dcgcffk0ba841ekmfe7mlh10e1i1abbb', '962384266581672850344681457680540073681275566', 23);
    t('466d816c1a1', '4839758545313', 16);
    t('6idfak3f1', '533176825117', 23);
    t('21qydfvujgdwibqfyef2ce073b8p', '1003962989378222780097553353426096168318655', 35);
    t('hid4leab6200ddc9g0hd0778ag2dal0deamlc', '187416244122839612888287458425399312143406757414849', 23);
    t('9fgg9988817491665857f5acb06', '975227292551389311524714747927864', 17);
    t('13ibo4hcadhj4a5nbfmahje6c26bmfjeh5', '195226174949035947407967016245360627759255669140', 27);
    t('67bab', '138227', 12);
    t('1403340621202787910a0285502741823a86056950691991282a', '176407038475836628166083068850217042878816946943609943', 11);
    t('10t0oduu5hu7xeq3d5tstcm0', '171705160058240681451967384000803748', 34);
    t('2312645603023334053206206506114311', '18999669376657025727125561163', 7);
    t('352320175446067457668251036773504880876250056665', '2534236716512667558334635281810919815086530038', 9);
    t('215b44a990b5064486156753173b6213', '6052053142903698783509806567110831', 12);
    t('jh6cl8q', '7608361103', 27);
    t('ml0m012enj6ahef', '481225577733348729759', 24);
    t('66aa96i4ncuqe15p3', '4513151173544319269517148', 31);
    t('4ggc16n1l01dm5978a2', '67904639129257439505583377', 25);
    t('bdb10650kdg48ca', '37772529505037088310', 21);
    t('1pdko8mej5i32fc1c0ipfl7m19ko4b8p5', '3769138624256537961669330967608079598594202279', 26);
    t('d6bcf011b9965', '3777711518226789', 16);
    t('7f16e2f8fahf2i4ac7k76ffdj9dkf', '81208999985742760703645792450856237870', 21);
    t('597a8749344790975339207177217856893a700aa553207a7', '570862871205184623051159726110304643063426032082261', 11);
    t('1g3on4nkha0onef5mnpg53om619q5nkbod89q', '5403365419155920691028033935258064905584695189712495', 27);
    t('52028440551854348388', '7059902878123817183', 9);
    t('5d630bb7df92gfga8jc18dgih', '925999331010922039840596084374517', 22);
    t('1080144b0i1gc9d192hh987', '42782218356170060622665259767', 20);
    t('22210300330232332120020121221030032', '780256723337944142606', 4);
    t('j0g60g4jj54070gdkj', '571906447450030093189003', 21);
    t('1b', '30', 19);
    t('452b31479640239b9b639a853476a6bb44a6bbb7', '5434568005375437518663444319858934471487227', 12);
    t('1100010000000010001100111000011111100010101000010101100001010100011101111001101000001101111111101101000100', '62117604478929274751724622969668', 2);
    t('3jg9g040jnf688ahh6jcok583kdj9j6', '3284019737150995327641899557095386675302981', 25);
    t('13022133211310011123230321012030003000', '33830856903016211595456', 4);
    t('336f838e47dje06749he1ac0ffg15a45c64', '544073756599977257872783903178913691232684924', 20);
    t('46uhr61flrt37on48b1ckijk2cu', '5740347931453676082842828840069448206750', 32);
    t('112001100211101', '7467022', 3);
    t('pkdd1ik4ok5do8ffh7141bibpd2ii2193n', '1275141665523532165934940150111953342128717752497', 26);
    t('25a', '535', 15);
    t('2g4b41cb5bcbg9dadf91c08435f69', '83842838314159505886654561772317800', 17);
    t('2bs9rbjjd', '1573422884683', 30);
    t('klf8ad0', '6434826762', 26);
    t('4f85g7c4364de0bh2280', '9521123183996160458149027', 19);
    t('j5679d5hjj97', '3945663570879787', 20);
    t('3140424', '52614', 5);
    t('5461a8382b009b9483b90a440400065186a83788934', '11378348078699777667231184166670745809447683896', 12);
    t('33e4g067j05kf0i5', '433325785455399388953', 22);
    t('b5d54c2d13cbb24', '126959326916907412', 14);
    t('74411760251306275052060', '558193600905071580208', 8);
    t('3qobi0x', '8143314945', 36);
    t('bqwufrh1qns50r3q9koaqiskfw', '1084917181467100837895352646759177337651', 33);
    t('8gog7p67d210op9jd71mmrn', '591719162913780893033433711729131', 28);
    t('44ba0aa61oma07l6hj03p35fr7l', '175761910992404861930958631561896387273', 28);
    t('e55691a4ae8194023d7e8ae5e8059974432acc', '470387544390600973185133828002346243787354817', 15);
    t('200212011122002020102220210201021010110022010122021202020110212121000', '582778073711029575626711438957001', 3);
    t('3hk3l521jr4lqaig4qf0', '251179674690390315785498983554', 33);
    t('mnt5fg94627qt3qse', '16565095395068373496545234', 31);
    t('3bcobialm95oah08a5', '2014430966081121686333380', 25);
    t('4641', '4641', 10);
    t('2122002121200110101112120201201211000000201101022120010021111020112021', '2197120323515351911893330117447634', 3);
    t('13714bdkap72ac8o4e4be9mpknl1f9j', '3167116946002852306408351163567756537094769', 26);
    t('1l50bolpgp45pobdlpeh8b91mgfmoa9p214loc', '615842729217762132092179913282546237871597211241972476', 28);
    t('100210022201220022112011202221202210222121120001021112210121220221011010012', '220547687111185863624614511757145708', 3);
    t('23202303201343231214132000144124220422011033043224303012231042143040012224', '2842011217102887511723449090629059947996251803047814', 5);
    t('55963455889939073566595695050105', '55963455889939073566595695050105', 10);
    t('986a9a06406031855545a', '6582892192043057625734', 11);
    t('66mjdcnicmi516553hefq0j4h8dbic', '110427317002013536940850484529174252675024590', 31);
    t('5d6i14h30e2cd14', '4557106641352576163', 19);
    t('1c7c554b8b5b11189a66324036092ca89462bb420', '711595302242240761379226114335862270631136990', 13);
    t('2kkhh5aofpg8q74596e9drfobmj1p', '90838564499601485405393795175496213959653', 28);
    t('3034134553053502555553353040432', '686018049407535850038308', 6);
    t('23738', '15911', 9);
    t('4212222124151323425', '444042355913513', 6);
    t('a7elnbdja8nj5m2hha8gjj6', '23890454338021551829445564632206', 24);
    t('32321200100213200022011012333331112', '1099315331975916289878', 4);
    t('1eb9ee0017fk30iag8i6f3ed9d4b6e', '5039295759456928282155913550785147389669', 23);
    t('27802069423286155041889995717306694770', '27802069423286155041889995717306694770', 10);
    t('867960525699c5cb061401a', '27323968410745294080357770', 13);
    t('35d7n4q2bxot45uuxm5scro1tvo6', '706987327769754553481308742217767001081194', 34);
    t('3e5mt3q30', '4823236902825', 33);
    t('cbd3b0dd08123466b52d', '962545403373485503722797', 16);
    t('41ea3b163a5614966ae7957bde8126e0a93d4a4', '23519245104289372491020812621093511206089774244', 16);
    t('238038k8rcoor', '1658110821340608856', 31);
    t('3hg0m706l428n', '1275595457674448025', 29);
    t('35bq3c', '54966336', 28);
    t('3d42f8df046ed6958fc5b33d9fa992b492f1e', '85386222153107555893245630091838241326575390', 16);
    t('m0gmnxts4h8p6an6ku', '2386980155865318111096328630', 34);
    t('132cibe94hgc', '236874990279132', 20);
    t('lcig0galc', '30069875475102', 33);
    t('16bisddgvyhcthdd6mi3', '256735802970771139963215358583', 35);
    t('i58a6g', '58468136', 20);
    t('3525', '1293', 7);
    t('3gkh7gij7ie', '1065634675177142', 28);
    t('c6e2421', '1818992997', 23);
    t('100200100020222220100002112200122110202011112222212202000221121212001212102101221', '158966224837100078693781454905147589627', 3);
    t('f648df4cg04e1b26g221bbcf052c5ad0539cgf8cga', '4315582534924165708877106720565720519480837388903874', 17);
    t('2p6aphhakh8mc5plc5j2gp', '1539390179865627184775927891721', 26);
    t('11b4', '2513', 13);
    t('jl7kjm7n32il1d4nmk0', '584261154838235821573009240', 26);
    t('hd9ba149dh6e4gafee8', '698476730595539737056020', 18);
    t('3j1g22je8lf5bhg8ilk629ndjila21lhg0', '13370053725951634183200009583712537939441657280', 24);
    t('27u50bmqvtha', '156658788335426776', 34);
    t('516h17gbh7da3a587f9f37he33', '122298188975115485587298035337289', 18);
    t('4b2a649880a0367630759204aa1b75475b', '2024946574268874581365721289039689783', 12);
    t('254225026012443321355065156140330663234621542653300', '5040887501845594508322543821207461070163390', 7);
    t('202011012221101001100122211001000002022111011121201222', '43410492801425593645350452', 3);
    t('7', '7', 26);
    t('577115015776462242165511716153070323513627023272', '16688555517189422187103917664151515791369914', 8);
    t('506444b16828035a216871011b744a221a2315b', '514848138656395936699051891875368909651735', 12);
    t('2ao0kqth4t1pcbh7a4', '30477411673928429295975604', 30);
    t('2o35odgjn2jo1a94haaknk48h3dcnnc', '2571886141556160166724302520638175571686837', 25);
    t('67', '55', 8);
    t('7nbr75', '402672450', 35);
    t('370jc1indcji8ijma13k1938f6eg', '60716324784319268778229637859744954592', 24);
    t('72967942960049867762435665277391293551369688649986', '72967942960049867762435665277391293551369688649986', 10);
    t('6sa', '7898', 34);
    t('294174393015', '294174393015', 10);
    t('73807c73ea415707344a', '160403961758478608615470', 15);
    t('11100010001001100001', '926305', 2);
    t('235b15k4n3982ht4kq', '27196458988445840025157226', 30);
    t('88ch45e7kmfl732o6qm9dp9k29m4qnh36alc3', '28111637207061985918949614744842625868551463394743253', 27);
    t('4aibck298h47jj8c3an0eflejeh2', '82024129949273334698484088931402810138', 24);
    t('mb8n96ghp477069ld5hdqncdccpe0q', '7247302454506934271382941736372903791832556', 27);
    t('f2baa0ic94g5i1b83fd33g2hce1j', '2030554880143475280397062737673221639', 20);
    t('17465535030523', '1072356929875', 8);
    t('a3mnq3967n6c16l7cji9', '31760096086178432274519348273', 28);
    t('liiqmo', '372897696', 28);
    t('1opx6hidp8vdzknr2', '13423618670694897535417406', 36);
    t('95m4odhqe7b4h9orpf', '66756845457585399045539197', 29);
    t('13317', '5839', 8);
    t('102241442', '1794050', 6);
    t('239f68talh6mpj24fdo45g5s39e1389', '1159960371112212929883230396521680545356867105', 31);
    t('10121234300252110055303232340504321110', '64247287136397682542328003650', 6);
    t('6ml5j5lmbg9j90dba1mkbe', '1572054598386072574697608169039', 25);
    t('2hi0', '20197', 19);
    t('43cdb039b196a4010e938a308889bc6d70126ab41', '470755174678153103704950155870502047761506218161', 15);
    t('4442b058b9763', '38899171257339', 12);
    t('2b61', '5113', 12);
    t('2734162636214', '201356688524', 8);
    t('391dawskl', '4604605109961', 33);
    t('1110101110110010110010101010010011001111111011011000', '4146450184077016', 2);
    t('11132123322121103122101112223320301301100', '1654887842635132747062352', 4);
    t('morem8755ban11441j1', '2561728804654073084523891749', 28);
    t('219325241c390905b1', '18439460011248535663', 13);
    t('111660012024443044042601641430256405054463532100311152514563012', '29454939227794636720645039138734936559113026503970971', 7);
    t('2res55qjde5rbj', '30256919008754218863', 29);
    t('514235610013374235501066012045440247061144570241', '14474060683475264437751372654279118864707745', 8);
    t('2bul9j', '106774265', 34);
    t('314k24yu9p730k6hlpswsrg7lje1pyote', '192003039777745220557413924708457255464807291072290', 36);
    t('0', '0', 18);
    t('26cd5g9af76g717e867e148e28d9fgb881b', '1640454531676645570762870476133782871483910', 17);
    t('oqpeub0p', '853405543449', 32);
    t('3ebd71a02', '64015510165', 19);
    t('1ukrr02c8plk2tbsh41fmftqce1e', '36771157999423113295070824371683506360213', 31);
    t('2003430034331000233232444424241404340303121021220313202324234334410424342140', '53769918856434339956161867351165493334635002404137170', 5);
    t('544243155105110423', '98014695681615', 6);
    t('17fdc28hi', '23980123515', 19);
    t('j307ogn7m8', '145736706102857', 27);
    t('7fge3sgq9qsrsdd02rq8knk75dajgn198p3f', '11511172676350799991011065866253721863347287895012897', 29);
    t('hdeetqc', '15473116595', 31);
    t('9a8c07c15362316cb5701668', '410109005226020106060632781', 13);
    t('50n', '3668', 27);
    t('2945877220049a90093575774827929', '49828341800440814243069556167882', 11);
    t('ce45xapw3bm94bol9ughds341c', '2403991013021267385347874576469551271030', 34);
    t('423304243332410224213434434222423112', '13229055276162993153326657', 5);
    t('0', '0', 9);
    t('76f2kc270hcol', '692157402620182845', 26);
    t('3', '3', 15);
    t('6nl26h4sjjeu2o6m07bl8lafrq', '130087953347892837054523599720072286649', 31);
    t('6gh', '2487', 19);
    t('34l13l046dp2ginpqjagi9bdi', '4181142245164401129320919247203118514', 32);
    t('30413552001353013220353015331', '19152449789569897624327', 6);
    t('l3e2o0c0jm3fop5a', '62425993275542993038219', 27);
    t('djie7cl09h1fjae6jkf24hddb', '2297349384615200133513075570628245', 22);
    t('29c00c467ad2297fgcebb1ggc65623e4f930', '29909191785719748871453419197824524959368206', 17);
    t('2324a5233', '5664701748', 15);
    t('3ha44k4jux0pu2ibb3381c5r38w68nq2d6', '3144597894719011198697132550928807872754550797197661', 35);
    t('11100011100000111011000000111111001001011000011011110001011110010111101001001001000011111101000000011111101001111000010101001011100000010100000000001000000101001100101110110', '10640405756706933069932552513853268918056402456582518', 2);
    t('4hkgai2g41gjkkfk28k0b2cbc58j', '2433652428912036105474056297252338648', 21);
    t('f78gfdb425bc4dd73422de8d9hi37ahhe3c474e0e', '21750452433737224069756534727541495878338776132463249', 19);
    t('23eme2rljlt0dfr12ro8s8msak3ra7nb27hr', '10588615039451549196330996020739733471641788070870837', 30);
    t('189397lg7l47n', '79549303381971448', 25);
    t('4wo15q0rodat47qheu0i8dfsv1r6wqo', '43653736667927410786469653245862403187138436044', 34);
    t('10002120112002010100200200221222120002210222210022102002221020200011101101102', '1882808015430216703112943141384175547', 3);
    t('ip', '601', 32);
    t('301021404444300333431124040', '4535598742859239270', 5);
    t('48d54obq9brm0c9aapjhi5m3i5s6h4', '11019306556204066307913575375918358320537764', 29);
    t('50g4ll', '32379007', 23);
    t('2247560737886056563088784666', '132701908509217706410444191', 9);
    t('83f23b573f02gc6ehc9hf99a27h', '3561270466397699675623785225228503', 18);
    t('330977844350743989365961925052001832148516', '330977844350743989365961925052001832148516', 10);
    t('lrilmctn2s8x6rx3w07thrhmon', '17591718481915563097535542071461139053591', 36);
    t('l6c0458gj9ngja8k7d4', '148452363181722357676361980', 24);
    t('3534775621556047145137126527746324006765443367053164', '42036808204933511970427575795842368941701486196', 8);
    t('4efid', '623080', 19);
    t('1l6iufezrq9zhljcarptf2pvb', '35662422559916045014345714581704950391', 36);
    t('2c6d07d3g2c15730284663', '616677193007865389311834215', 18);
    t('1xuy7hnx04lukxy', '8147224799381093225064', 35);
    t('aa828911672415968', '504404529377026737', 11);
    t('423147a7a23756807a665a5', '342517176925712535575988', 11);
    t('1371035220605170410066165577113314501175100', '126452315889789497901223436832123189824', 8);
    t('10djj7hy0pn', '2789079501903648', 35);
    t('bd88a7hb69bjad4c', '382437456673894325292', 20);
    t('4rd', '4694', 31);
    t('1v7f6ffg924wrk2picsg5ttta0ia', '429364493553457680681114867558750620331758', 34);
    t('2k76jdee9', '313272045273', 24);
    t('123042434342420343211442034202400443333133410423', '1085245063387282023154479674513238', 5);
    t('131333311230232203231112021123001300113120032333023300', '152105319842008098107694289515248', 4);
    t('51450362621322470420', '749021597016944912', 8);
    t('1743281026180240084', '274931041666976077', 9);
    t('1gv5s19r8tko', '55140372098348696', 32);
    t('3110342443423203112413', '1547942848488483', 5);
    t('2u566xr8ccdaqbh6c80hxj89cpswkcu9t8', '2575249682730886757243709065864952197950034185571423', 35);
    t('100000010101', '2069', 2);
    t('401574b6g1ak1ak44m8kch', '157978187599619061617502135471', 23);
    t('2ks19ota29tyw3r5ov', '738394685619991470364891279', 36);
    t('oibk25gf4o23', '1241117724903340848', 33);
    t('4a65', '31165', 19);
    t('2020211100001120022201021222112000020', '338142311987848269', 3);
    t('1110112010011122000221200021001010120001112200122211112122201220120012102211210221', '649092111671534536930325932482290711269', 3);
    t('4d6mie8p2alme5am', '13267418111464317128518', 27);
    t('42577131133a232032662209b95408096081', '248422206977724611904731225962594664929', 12);
    t('1n', '53', 30);
    t('132103000344313341', '1288575776096', 5);
    t('6jmt943mg0umthea6pn6q9hf', '132823934112197986003728246640958089', 31);
    t('111121000010012201001001122', '3838995704177', 3);
    t('1677676576173b51b9357', '5953759059536287667635', 12);
    t('102jba5ac2cja', '95816830507621688', 26);
    t('42waoqh9taak26ebde6k2', '9594733085680997313599473375961', 33);
    t('33i3it9kgf0uhpdsrdsnsj', '64884487071552586313401842309055', 31);
    t('953158728', '953158728', 10);
    t('4gg9sat', '6927952297', 34);
    t('722e27159ecfbg10h407345c8aig598ddi654g0', '27840770996812521761625900201217611244514913752965', 19);
    t('2t03qjlt7x5twkp8qndne6wgdq0r', '638613689380489298155684957574955359701995', 34);
    t('257734a46f7icbh9fj', '29732309036426152299919', 20);
    t('c', '12', 22);
    t('5', '5', 20);
    t('4hqo477259', '49098912593397', 28);
    t('178a034d5229384107a', '659300251029847390372', 14);
    t('a3b1b80751b', '639453463079', 12);
    t('2q422mo9ap647jsdo', '726063595260133145012147', 29);
    t('2', '2', 34);
    t('24hfch7i3dh6a51k8jeii679gk4955cb55de5', '887846405096017197440980451741450143251200403470', 21);
    t('266441154454153132', '696261848866747', 7);
    t('2766c9b3d2db9ea5a577a00847a3293d8939823', '1226312698204113502459283231484488118966971583', 15);
    t('4', '4', 8);
    t('41726045554731777722315562631262755462314641246551410413772', '101522180338987737728899908294640200607836241899165690', 8);
    t('ico5im1l6gipi5mncbafaijkp1', '4379692464186729985302450182878794995', 26);
    t('10fb906', '35653938', 18);
    t('3ef7kik8nh207bh7d5j70bag3epj4mj41g', '176077548195361303192424319318361820663061066322', 26);
    t('15b0ac7a6aac2113c2db3ca1850b4387777ac7b', '50486609943116788827252878271742473022089629', 14);
    t('p', '25', 28);
    t('26jfceina94oa3454j9dhh3e6j7kejjg4234', '75531629983146118263655855521646711760476817989082', 26);
    t('31022130220010213222023033003011321112121201330333321013331222', '17496945529151877267572936509934042986', 4);
    t('o29mcf83oi4b08k', '4384699236470516280372', 28);
    t('6btaxrktbscxnb', '1079469584074493701463', 36);
    t('b7jl677jvvi7io7k8o5juejadv', '1030942310965426695181339530150102930538', 33);
    t('35ig9la7', '11075108265', 23);
    t('4682fcd', '105751964', 17);
    t('8d933590baac338cda4d9', '750978790972524648878031', 14);
    t('7p221h60dnofi1b', '513797078081391814565', 26);
    t('5814844bc69', '1613521666101', 14);
    t('2535134113102123350', '298694173861650', 6);
    t('1d1ag75228ddg644cc125539e4b5f96f6', '4192146465970754575581869917056003117055', 17);
    t('40003033353315404140', '2438896653963996', 6);
    t('21xn2vnm91ln4xmsr7lgcwth9dv6q5ukdm', '711811184545142701110316372055176235138545025034656', 34);
    t('dhkcpvs3p81dua43mg', '524235584720684984089841360', 32);
    t('495fcaa89e8bbbg646', '3763874598256486747577', 17);
    t('nahjm1ll5fh41hfjliikkid088bdmi', '249014596602561282054902123492366098035042', 24);
    t('40111000144002230310210303210044222130402132411', '575483485884632505627426105114731', 5);
    t('3726520073102165257153311', '18508139224259054327497', 8);
    t('i', '18', 33);
    t('107a5b45606177a04b292a', '48520908714351770811826', 12);
    t('32b712a55', '2628417862', 13);
    t('19h4282j092he3cj51d61fe87j49aijib625a3b', '257590807854928552405178656994213410865026962322433', 21);
    t('1lb4ep0c3a14inkjjmd9q91', '55412392011791736985105645077409', 27);
    t('546935971318244194705643405', '546935971318244194705643405', 10);
    t('35313224023324540435523050250331155210203', '52453055717382339610852843153371', 6);
    t('15193624138', '192278230399', 13);
    t('2', '2', 28);
    t('3poq733', '4086111331', 32);
    t('2atlinu3', '99312069288', 33);
    t('fkbskc5fehg9cuqdijcact', '7490176084806938114482789713939053', 36);
    t('1d9plprag6q9qcf2t8lr', '16786382574488616380634910857', 30);
    t('1ha2nsdonr7p9dyd', '327188362472580029633509', 36);
    t('111044424210411044040300133410343042444013312004333103402304423423', '3382637550594455513139626004317778571489529863', 5);
    t('acppkmiqg3tpomqk', '149640867231485432618600', 30);
    t('tf4', '38128', 36);
    t('1dh63h4o13b35ln0li033b99fklhid632c5lb', '327715658396590402208146044366411318465199249019286', 25);
    t('48', '76', 17);
    t('ae7l6k3q8w6c72qxkg2fb', '79186912232612253291296402267111', 35);
    t('e9n5bbn1i7lcbm1g05geb3dk94ep7e', '1555968092781480866983906031197226493462360', 26);
    t('7ubmw1pjt3l57oajqgrll5jph8m94g8w', '2360795619253126146184916535662718674178380996704', 34);
    t('1r65rt2trb55lq22h19eapnidnq', '484704933472164164552752255631996628416', 30);
    t('136848467048258286126300125028474625160260100577417745404', '388690899361213038703438733086886750206857769355496235', 9);
    t('g9cc', '152409', 21);
    t('1lh1ecc99m7861fik3c44lm0g', '934238414796316634228162970694355', 23);
    t('3215000045', '134002244', 7);
    t('5h6n2', '8240157', 35);
    t('e714krve8kdcbij581xc06a0440si92', '298097214434462329831651763900675946445833904117', 35);
    t('1', '1', 28);
    t('5f2ikae7i1ch6a10dch', '8289858128215684549179261', 22);
    t('110233030106104754146604170637', '174817507453714537420747167', 8);
    t('2nun96lb71g85sloh47bpp7r1sgbl9tut', '10662007558514444968621546451733698226110473802612', 33);
    t('0', '0', 22);
    t('11j09ae5i2cg', '2552089982704691', 25);
    t('bkc8e0op1mo87', '1764757861634423806', 27);
    t('2423550141325415012042301033404550435232245255441054030230', '620111545601390684890879270195626493023037962', 6);
    t('21254414445535530534202215310522321041405310511521521210', '14135465583609025304128608335209973245692774', 6);
    t('12604595560023747679439524152220210561427659802303', '12604595560023747679439524152220210561427659802303', 10);
    t('25331131324141215022', '1786353731930966', 6);
    t('8fhgfr7mfhj5l2tn', '320586536359265220332471', 32);
    t('650643875157180170d14d81c9b', '23995660583887604305815556001846', 15);
    t('a8di63mkh6j72or7e5f9p821il41q0j8fgd', '1714712023081629097084375038192551872981528239619993', 30);
    t('10331300311210202013221033', '1397536800143951', 4);
    t('5bckjekkjgc1', '30157465514958847', 27);
    t('1307pd9inl8m59809e4e9hc74cf44', '4643603931817311396953878999346150129672', 26);
    t('1cuj0rq761f8f3ruagfiku4t8r5csao8ldia', '22368007327103577567192720592619403223865279053466023', 31);
    t('3210245134450313253351101435530534', '160603316899608463616006554', 6);
    t('127392d2a4caa', '66893400725574', 14);
    t('2ikak5bkjajd9gf8h3cd565j199beg3', '13474955681660365951671452544344812602258', 21);
    t('3eao5e8450ic', '8529544513359837', 25);
    t('e9guf69', '22058758689', 34);
    t('15158180900', '7766337557396', 19);
    t('2mj44mncbs4hs2198geouq5jq19qjcduq28l', '43028515822351712961957527689171615902026923021969323', 31);
    t('30esr4bjaqcjo3p10b3js7kf7415bjsl3abn', '4609195958142232639596012908552014584998492990749496', 29);
    t('14ehrjk2', '15672492194', 28);
    t('bc2c51eabeb4d', '47540354209876493', 20);
    t('1b69d49b7b2391582a7b6a8', '29845378456995755608746436', 14);
    t('375099280174972588499969848346581', '375099280174972588499969848346581', 10);
    t('1b', '31', 20);
    t('185008621588745454705101543580381764687780441351', '1379122328542048273411929412033977767884857859', 9);
    t('1ai80571828g1l13b180f49h7b6', '373322096841196369617565471577760841', 23);
    t('365562046046280128146688864433503', '12828940182695045910972242404065', 9);
    t('1122130130022320301030133301123031201221230031', '1749448690563478934830619405', 4);
    t('27421303721506401005734534027062355252748655124456623', '118144497372701082723759261444994330066950112399602', 9);
    t('11022211200211001100222020202010111210211000211222020112201201212010222212201110', '71070272534459599139697985336272797397', 3);
    t('10a4786b212c23234b78', '1551477993551070203588', 13);
    t('6i51o82m5bgnb93011420o75b9nd470729n', '2279577849940632952238972161001397266163154407748', 25);
    t('1', '1', 31);
    t('1g', '45', 29);
    t('17llodh0p9p4omai6e01b4', '674371603170934289782308835302', 26);
    t('ld54e21eh02cbkfbaa093fl55bcg8364im7', '429238038060162231685243227854062073708831450765', 23);
    t('7mpy6nawcmhw0g2u', '1108330902717012441427200', 35);
    t('6ajf4ammhdhb71b6954hhkgmb65bh6ghg957', '2961483371926675845110593572135331590333628729021', 23);
    t('fba75c3e2c8a777f', '18133563846735591295', 16);
    t('pjcqacl5cdendipkqb70ipo5ba5nn', '307951112168204374490658438192806014671308', 27);
    t('6tun5793cse93i199uffmqgrd0kh', '128777919986710631701713272631586482084386', 31);
    t('13a5t7mjda9ou6rrbpfa', '23997647707013581885686488193', 31);
    t('7201731', '3839509', 9);
    t('11641233332213532446', '14562466660945139', 7);
    t('99a986165294448a71', '21797994356398731253', 12);
    t('2401101411122303434111302420203144', '327094274822059722428549', 5);
    t('4144619d2', '6041074356', 14);
    t('34321447613754733467632640535662447106103006103436', '633549261053883686239613232774717922594031390', 8);
    t('3xaj72k7juuw8wjlpl8ckfb', '67994205225961269732014170337721959', 36);
    t('26148k3kima2ag9i6kcoiafn3ogb1k6eo', '1215324793757930007410045265759556424912816624', 25);
    t('1025206642353532', '5014780923889', 7);
    t('knim5m76a00h2lmkoccol07f04knh3b81daj', '2614651514382553773659324279451802705234366596554065', 27);
    t('909a9a268692348781a698093878', '119072460849132927971033373039', 11);
    t('5duc4skq2rrunqptmcpc8', '3661917045452129831279130480136', 31);
    t('10470ea350e01dd0e75a7366dh77a30b', '830413508341641695220604349217566325431', 18);
    t('101000101100101111110110100100001110100101001010010100101010001100001101100011110110001001111110010010110100001011101101111010100110000000110100110101000', '7260976836577029672818019365254002054979938728', 2);
    t('q', '26', 27);
    t('1077074290508987607466933a10', '13937973055009429267248363869', 11);
    t('1lf3eee3d2sbfs9ogated9t', '538748668557436691784615710879999', 30);
    t('1h9cb8h485', '620046063560', 19);
    t('dk', '358', 26);
    t('13241431430411013330310434441310033234333013212', '243729894988914189325871229969807', 5);
    t('18917a008279a324a66a3', '1212930867843585167566', 11);
    t('gfgfe19f636c1be7', '48492131801646439905', 17);
    t('100122221110210110122111222112001022221002012020122012112011012101121100111102122211221002020001101121100021112', '32679709809245815111430154357022862731776016143211796', 3);
    t('281689658717189228532b0585c7a77384c774', '431443448247936435069993946707949525906845', 13);
    t('12502532345305244100314200520130435541150024035250011323125030', '432380196346644742357025125509064993551796602762', 6);
    t('jhf3d6ec', '35740674639', 21);
    t('281b8h03e2b4568', '3938599428744194128', 20);
    t('rra3eo9ang1nkjbgggoj8be9522j', '33118535163106500657229181745691670041643', 28);
    t('16724077876370768542274160467677713', '488519835671298139694841930475413', 9);
    t('5paaj8r2vmg77onwoimbb', '13527973399537075043951910147074', 33);
    t('12c94030', '127283226', 14);
    t('bjt39p1qaevgviriinv', '14387551065792537297755392767', 32);
    t('43', '75', 18);
    t('7ep4eb7mlkkeh37baaejlo39odlhmjp84dh', '9739053884128074552490865807121378544532459516835', 26);
    t('205168664a2c', '17495412563292', 15);
    t('qp51qp4bhxk5xpi', '110602057480221626740068', 35);
    t('5a4d12b4ii8cme6gk5llj8dj45eii', '731561718476390279418093411754616519803', 23);
    t('15gb1d3754', '160300118210', 17);
    t('5626616225462155434', '9637056328483581', 7);
    t('654a4c9aab6db6aa93cba723a2c6484', '154437158573067708419825110074369876', 14);
    t('1010010010100000101011111111110100000011101101000100100000111001100000010101011011000011111010111001000111011110101111010000110', '109413864136821966738078269201594670726', 2);
    t('mhl5jj26bffelm04k15l49fcik4j', '133104314563536506366413132367074503679', 23);
    t('9fi00bhiic06', '2006016761428806', 20);
    t('32097811179437438638590235847063', '9036190162614205241654679982433163', 12);
    t('j4r8gmegar04bpj', '9165914535009266218669', 30);
    t('fe9nphkmv', '27537217830419', 34);
    t('19km8am29a5lgf44lmgmli52jk7am859a778bdm', '7966769005196291051847190165381447220788995817722931', 23);
    t('1d98hdila12217', '1365501640827240607', 24);
    t('4', '4', 9);
    t('103408764722834675342275873a075472522265', '42290766920392525491850559747134754129335', 11);
    t('40145342023520434603630305455', '1855754698685829573314702', 7);
    t('2330143431434321023412200330441401404220433113243103233304100213', '295242550269530830933574434277185767468034433', 5);
    t('52lfpjk6gjpe8h0j5o085705enhh', '2263111846247859246807588383287598329958', 27);
    t('6', '6', 35);
    t('ckdc1n59j5hm20h2hne7', '9802463620743345899194619415', 26);
    t('74vyqpfst45qaxxjdnhre4anybk5mfljczf', '585768757405889601439917672060830645196186705764956539', 36);
    t('25333005405423404431150032421232424132311504103', '1829167166770747320900573042647616039', 6);
    t('a31a9b0c189b5604675483a87502864845b', '766374537111738699661732942419840514807', 13);
    t('p6h4o2o7prsknugn44ahp89eq3bc6quhss', '1178753525703649096388315386598744840163151378859932', 32);
    t('49opl92p19df0knm8hp4gn7252gf', '701559229806255576316878885678199202687', 26);
    t('11101001010010010000001010101001000010111010011111010011101101000010110', '2151676161178286545430', 2);
    t('c44a45536316dc7b0c353aad14b7830d09c2aaa3607c5', '3310452953174251067352010576935718387727695162512521', 14);
    t('1546474620083335460588111104874445', '49874778889357532913325826762540', 9);
    t('1338003447a222244271a09305208a90b51b1', '904051338548505527200275028870151876053', 12);
    t('33260652734712254347', '492610547748526311', 8);
    t('10643055642332651415554523356524323', '61444932294731769038022280425', 7);
    t('3e21s8lhau56242nlcla6rmjoiue9kf5f', '5026850379275392936691910666263310074025543875759', 32);
    t('4792739119043471aab4ca622058650496013c96c827', '3644595850902778704692127204892999955943240641053', 13);
    t('110cc5gb37c8', '67978664942084', 18);
    t('29615025419685937529', '29615025419685937529', 10);
    t('7lmc', '123062', 25);
    t('302702', '486664', 11);
    t('447', '367', 9);
    t('42121511051155513325202314155012551211041663406164645351603', '44712944643337807555851878205053325752326477807548', 7);
    t('12rslb2mm9188nl9wr4gc9ty7y4isn4i4vl1', '1190543759247226965370117450905999428839676647370465211', 35);
    t('14kkhbjl509ej5bhjm03mmhai72lc3fk3m0', '101720279602301692133681010267630420149945544912', 24);
    t('3dbguecegfef5bu08g0ac2', '71460045177172533150728371041297', 31);
    t('553d041d97381b8b08049209ba3', '3387541749393070534320306028403', 14);
    t('1idb05jl4446g11h344b1eaikhbg', '3248342745065968412361931577840440806', 22);
    t('391kdm2ia', '265857054704', 23);
    t('d', '13', 19);
    t('2foj', '74760', 31);
    t('15152500051251431501352430050404005030331044424233', '254129829633425094552392729656769925213', 6);
    t('93i242f842aghgi8ed018e1d', '2374115750141125588719021780660', 19);
    t('13e7e73ifh5i2g3ameacble1eaek26e2j3jgj', '12182402836527839156286030802586331869647012229654', 23);
    t('x7ann37tsvehx3q5vpxaqq1eo', '745474840780903891388495474305666096032', 36);
    t('23468822326408', '23468822326408', 10);
    t('209087', '513319', 12);
    t('ba4c030c1374033d446177d0a2d045851266', '152797075747889508739869970552336948630314', 14);
    t('b4ka', '119514', 22);
    t('1g6b8h7486qjdwajnef1', '317929058502405198044902984426', 35);
    t('1', '1', 2);
    t('8icmpii9daod', '31973718431183165', 26);
    t('2c8jhn1qg6n5', '13655372424481868', 27);
    t('3dr0y9yp1xtkd42c4fw6k3', '903807188407354488131442830742553', 35);
    t('6', '6', 29);
    t('61829970', '220025892', 12);
    t('6a7f74151fcc6ed8ed2b3f19100', '135002082526570912993917396947200', 16);
    t('a71qu3m9cxks', '716447809640070456', 34);
    t('1332111232033320011301003033232200111310000111011222210002131320330132100', '44022861335477932950560265835710759372572560', 4);
    t('12021101120202001100012212010220010100011102010110021000111202010201121222002102102122221002101102220', '905995283475954839283786144849547150961766784239', 3);
    t('dd0373aof6fk', '74945293912339265', 27);
    t('6795977293774152225212538650395631193808973258378', '6795977293774152225212538650395631193808973258378', 10);
    t('pm95ag59im21f', '9117644977445972259', 29);
    t('1b56', '3378', 12);
    t('4g8ea53b5ehd9694ih3dc838ac11c561dc0hgd5', '19047736684211855674982504436903813834471230419734', 19);
    t('11110110100000100001101001110011101100010110000110011101110010101110101010111001001000101011101101100000010000100101', '79996489761592791530139097880724517', 2);
    t('11531554acc00836794199184218445c5218c222b61', '67628655578352237505304598601215330350928553080', 13);
    t('35291', '1955549', 28);
    t('5a0d410c996ff91fce14753b986e36ed02c8038a', '514104745647653703895348991238314574953430123402', 16);
    t('98ef2d49bef8f926076d15ea07db47db', '203284532859688206391148792201594226651', 16);
    t('1101000110', '838', 2);
    t('2b1b51h6a9a23eg4gfg65hccjig37d24ai2a4b4', '70201256484595753224630835840712606388793018001824', 20);
    t('3086551513a21531959700a62389709283423440875a1a3534', '3277335942462557850196574034226034230391750988025359', 11);
    t('2xagh32n24eno24f2r8cfjn', '14679210071634068950133360692505241', 34);
    t('4605666016246640266213126434411416031022605203144100210325560055', '849411127852458866731338127021230286264433815611688357', 7);
    t('45nqegp1jrjgmjofhmn83bcr', '18133891299810930196922310944355618', 29);
    t('ssrkb0jj', '500219805132', 29);
    t('1033032010232122200222020213020010', '91334330474893046276', 4);
    t('110353378073354064510546137', '7210867946142586075586503', 9);
    t('3406105036448313018', '518252281403001236', 9);
    t('flvh3l2mdlamctv7nm9agrm133', '1438094370381119663687960958424282684125', 33);
    t('6334358463', '6334358463', 10);
    t('35c614c13a10691', '38009608424197159', 14);
    t('11010000111111110000100100100110100000110001000101010100111110', '3764941434990646590', 2);
    t('498c3d13a1d760', '3721053183465240', 14);
    t('e140rellefn9phhmfp2p0did7npg4d2a71ja', '21442464367275264053737247138139660244488577062935044', 29);
    t('2200223332021133030213020133', '45229383068316191', 4);
    t('92k2c0j8mj00', '21725079534730625', 25);
    t('38q2bdu9tnlwkgn34qhgbajcp3fk4', '10775935475547100477756815098145914310211171', 33);
    t('13212', '486', 4);
    t('1021012', '923', 3);
    t('bj3l5080jlklfibj99gl230bf6ikl76kajcjk', '124541870118109694822199814329231541722666270319503', 23);
    t('41eojig6v4m011hg3u4hyk7wc', '46139830864306341644172166605630244707', 35);
    t('be3203d11fa9ca5b4', '575872105144800539244', 17);
    t('1143442324240112302414320334333410111030143112344223421342030211131', '18863137177859377006372116620735071224799069541', 5);
    t('c2i6d6kf', '55565364591', 24);
    t('1969', '58545', 36);
    t('25d', '475', 14);
    t('596851a668739904620', '32659692732589912924', 11);
    t('lv3', '23895', 33);
    t('7a7c175', '183805569', 17);
    t('76cpgp9gim624dqmkii8d5qbqib1p5br', '15595823047616363439274756729939503861036829536', 29);
    t('dga1fafagg644g0fe', '4000702988803940637805', 19);
    t('1acba9489c62b65a4b89b66a2ca29a5a221', '138107096676865488162009424053018420376', 13);
    t('2156543644250631306263231223052110364562324313246541265', '9779427167319853821850991345749633818069902582', 7);
    t('li04', '846196', 34);
    t('h0h887omnj63lhn05cebu7b0gs9', '10146394091043760918958586860739479666458', 31);
    t('49b5633djac5d6j82i21i33dd8ac', '601048929950921960604242992843787412', 20);
    t('64246041612682857608', '8747501280912207998', 9);
    t('30j2mbl97e7eg', '66536342778013341', 23);
    t('e', '14', 31);
    t('ckqc54g4jn8ppf12', '64984930998994069460686', 28);
    t('58a8cbac11b2ab6a129d3399', '1291579933284075416907209643', 14);
    t('26vq0dek7', '2439340538503', 32);
    t('130023655', '8241595', 7);
    t('1102202120121121002222100120012012221110010110020', '114515542030739621547975', 3);
    t('1992566752847870721677784', '1992566752847870721677784', 10);
    t('1100110001010110001011110100101011101000110000011100010000110010010111010010001101111000000111110101100010111000101101001101', '16975625492382937650444877242569558861', 2);
    t('2rbbesin701sp', '1547900614446571765', 30);
    t('c5q44p3j2js3kok0asn588980a7hp', '1080508918419483023850317169372101858474032', 29);
    t('941egd5hb1f5e12481h9a', '117639049478624610284913400', 18);
    t('4655600500', '1834889031', 9);
    t('79088597835694330a29', '478556138580736188025', 11);
    t('iqlb3ql72', '5363996629763', 27);
    t('6h2ej0ckka2ke', '50134882009333016', 21);
    t('20653232085716', '20653232085716', 10);
    t('3198916b5130ba', '949252404083214', 13);
    t('1ed53c612a9ce8f563380bc006af575169', '10491910079311728745430929182060466098537', 16);
    t('cb6hcfa270ly1w8h', '1784912231557744137344247', 35);
    t('526b56b97804', '176181942855498', 17);
    t('26gem7j62i2c4ka2580d8', '9160982641229049777224024384', 24);
    t('d6e1e36jj2f4ge85ga001ig2ib', '15132464896763908208949954242501531', 21);
    t('5upfq7p41fw', '16214516102201407', 35);
    t('ca0148216a132370494579c3811c9528b2579bb', '27291858728033467909120034313500390261718897', 13);
    t('123020003', '111107', 4);
    t('a50938148a435a83', '531761988603885367', 13);
    t('1gj44qmicab', '662398178858335', 29);
    t('11102787284451943115992270196016750607834192358', '11102787284451943115992270196016750607834192358', 10);
    t('3b062213d4ed1b6d6621c4b02ee73d12a00bd436b0e5c', '20908546194267013369961168110558040107137325813741362', 15);
    t('75akcpb3de2s0jsnrh3bcu2g0', '4449836213108688141279407743308365708', 31);
    t('2b60892958b2631c6423a326', '120333156700155119670331895', 13);
    t('42400114311051151043215013041103042421240541121425125454', '27935245721852777377012293595535900324233642', 6);
    t('55qs1hj40j71ig0m3i6hh60pq5qp', '39627138353823040931217142004547884957305', 30);
    t('4003040210505622', '19032912241576', 7);
    t('223022300313310221001110032310212133130201333210100220222030031000000330332300331203', '252361472917175591010150696208672808420570612567907', 4);
    t('2o0hf18glq5mnn0jmafl78op7krr457i8k', '1630303300352983488506028827484775858825533838676', 28);
    t('hjgo156lifg', '3649805981664910', 27);
    t('2672ck1ak9j3668idig9i', '9094565766877483628951027946', 24);
    t('42558a1397719', '236437228306155', 14);
    t('50514031666626056320465152246460322326631121443656262634540', '52944692260629312711052610581234760210698420791042', 7);
    t('223645618550327621756258550420232724400738370', '2199636652234003810100969121876147258759993', 9);
    t('8ac1', '147681', 26);
    t('3ga7b38ggh0f88d744c7c9ha', '998035919010781157725464776885', 19);
    t('103211011033132223113233320333313313223201302011021123102231012121121003202', '436635316515833678899653582525236295625969890', 4);
    t('d5l4dza', '28635977926', 36);
    t('2pdtlhmse6eg26s19ucis9hfldid6i', '124654514568801370471033136141160922807350482', 32);
    t('52felh5gh4510kh106jeoj7cl5kj11il5', '2767399766384557104422717154012442967715261780', 25);
    t('k0lk', '213442', 22);
    t('11c25b068603cce9f3bbdca', '343512914478456071211695562', 16);
    t('335033424101323340423113234541353340534', '1352227850184145127759798321002', 6);
    t('9e44986ad6c5a3421885a4dd03a', '37696781807784302268353865692680', 15);
    t('395ibtl4so0egl', '52712097322785853101', 30);
    t('dh2cedf2bf587c91dci88f', '9929040065272749223553832140', 19);
    t('772a8e4b457995e13897900d8000ad6c1f7c9a1', '42519933036531441133313813110786358673933846945', 16);
    t('1d1cd508f519156', '131111610056020310', 16);
    t('ekj8dkbj6i3kga95ij22', '198679762579399342902422792', 21);
    t('41k911j29kjhdhc13ag902l30dh0a2c', '76586399715825395164280132066877039296656', 22);
    t('fpe0tn39dh6qih2sr45jhrijlc', '304283009698601976205960463944913734374', 31);
    t('273dcf23ogp2cfakgbn4fl', '1178457683913699770110878339571', 26);
    t('5da9a9bf96be6918e50', '27644363394761964490320', 16);
    t('93a089d540da7e65fbc745d', '10819104601922865145439435655', 17);
    t('1133562034346632011', '1978986750380760', 7);
    t('4ba121a43bc41383ebeed9d21e1832', '61080584384845175908009030944254597', 15);
    t('55c3008747765cb5a544430393a3400375b2', '5308482319711252523172754195251756876991', 13);
    t('5710728926a32bd8578b09d', '90281115589861012459774291', 14);
    t('124222134144321323244004220113002310334232043000124314311123034413034133433', '8364205020182315700566879525103608648610325894833618', 5);
    t('3ij6fei7ct8bditifj57qidrne', '69250254015520173234889635905422378215', 31);
    t('j84l4e35cnah4pm082jo8f23fj119754ef', '955016814986800763460011887048876324258463031587', 26);
    t('2l6hm8aomfi120xvkq64', '328810104424271657766987866856', 34);
    t('3su7i6', '200878586', 35);
    t('468713253255775056138736506054776103258272850367', '3375929477240893115892314179236945437132610304', 9);
    t('iiq2dxy', '34073294114', 35);
    t('2jh6cd8i91mia', '62648677168244333', 23);
    t('2b8f9ai9hd48207a3e05dc0ejah55j156e', '22092750538409534069194105946265366099050134', 20);
    t('404b8493a8a43b334aa439', '185609888390849041174509', 12);
    t('hjq9kjqgj848r1e98ijc0', '1553934125194558113894610790144', 28);
    t('ake308dif9ihnaem7hmm5gh6', '603396346398581702540847365854110', 24);
    t('510nddj9k3gf404c2i6gb9n7', '280271867286312020777609932859503', 24);
    t('963slghoaue5o6iajlj08do1jhmob6r', '5064387257282298335135751952618725428567377882', 31);
    t('60b558db764d03150846989b1c37', '53430936932852060459452718754345', 14);
    t('ha08mf8sid8joj6el2cfognrdspcbreh', '37455615024172541953556930974489194890334970044', 29);
    t('2341300044110340114203320234412220030412114120300123110413121412240133', '4697326942430825924898237671958542016017650118168', 5);
    t('d65a86297a7bf3c', '2251611900925702988', 17);
    t('4jh25fkmbd28lhoaod1akam9ina2onm', '4152357643144590426805411364596922347703097', 25);
    t('7h13b82d2kj6e8c4bhbjc681bf00f9ih00', '335744283433797761544495039026062289479426677', 21);
    t('79nidei4qdbvudiev0sbf9m', '9481488549331803281413309926325558', 32);
    t('3fknbt02chqbcn967adb', '75965804098331194115528214530', 31);
    t('625229929149012470971842263044', '625229929149012470971842263044', 10);
    t('17711i5p7cqf', '31331848805567615', 31);
    t('1a4314b9650544b6206b8639', '12341325556611002168638605', 12);
    t('55a7a2011dcb9c54941653aa6a35', '47723551702572572040904921974727', 14);
    t('7teqfe59j05st6pun69d', '172302167861573369948783075562', 31);
    t('33662122623', '1008274536', 7);
    t('168e9ecf225e4206e22aabe3d5de7gc1c8', '55695742667189173051412647636327754746841', 17);
    t('po0kdjoclplm33elfgn5gfnbbf9i1', '107884700371921309802125903666720535662145', 26);
    t('iiaj731mhb7icl795864e4', '742188118991708140904927327409', 23);
    t('627c5465', '389098247', 13);
    t('1110110111110101110000001100101101010101101101111111011001101011101101000010010010111101010011101111011011011110001111000001100001010010011001111010010110001001111111001', '695557780484633047451419090913265350682286538560505', 2);
    t('v1hdrpi72rxl7l', '3671512854030700329616', 35);
    t('4925aggfbh8e4gac6ae5c64254d0b415i82bd34', '17535511043608617303142367159976450528283461395046', 19);
    t('c', '12', 29);
    t('30o3fuug0ga3lqf', '12500070118039641683400', 35);
    t('387d80c474c32a591b366c5456c7a871951', '3358240678140338946789670983146684842579', 14);
    t('orw6puyc02pj561q', '3592793122578442538624286', 35);
    t('i719319aa0g22bi7f6d', '1913082545143094439790472', 19);
    t('531d70f5cb9f96h9ab282af2eegb420hgfc19', '8007055515291584323571716917746295137673084963', 18);
    t('3790218a', '72314780', 11);
    t('7', '7', 35);
    t('3652056541643012540022255', '18097097047518748877997', 8);
    t('4n39u20hj5qdditk9kdim6469sbqd9', '210607480145416873193807172344770565962590633', 32);
    t('3b', '86', 25);
    t('18gb9ffn0mcg28', '3304915001872755708', 26);
    t('a3aa73', '3822367', 13);
    t('33aa32b1a1703484200015460108a02a6b6', '246534305809775961185312195074070771144', 13);
    t('76da3o3qmka6jm9bpi1f881p1re94q0d', '5261591201984542081284964078385959485970188205', 28);
    t('f76deiaj99kaf5mdndig0m2s8gi2fs', '270557992879867684462992923067573004312715064', 31);
    t('10010011101100000110011111100100000000101001100101000101111110001101010110000010011010000001000110010001001011011001110011000010111001011110110', '6432766911463399701129205956556722425393910', 2);
    t('14028338200708615102070674515767072214', '293684470306336046607148169275151740', 9);
    t('46n11ynilo', '330255553677059', 35);
    t('gclfn6mi9d33kii', '1802574648845195012667', 27);
    t('10000010011101010000001110000110011101010111100000111010010011100001100100', '9626033841394783172708', 2);
    t('26gc07ahg33696b6b35i6875dd4bfdb84h3edaffigi', '1204775186640355894241660800988487731870565763140511756', 19);
    t('a424dhjj68k0gdfgb72e6ea7f0d5d1c70bd6a', '4057922578962802051428308232940970109455163045139', 21);
    t('7c53d48781c046a2542b2455752ca849b37', '7330016794037776721321455336599394592981', 14);
    t('12d140iel5jf', '653197596401981', 22);
    t('3j3bj63jaj3kk0iecg', '256450260218708669218880', 22);
    t('201002131031010332002230020133020100212211122313012213313001310322321211203312212123', '193142585656707088166778168268938862156435413756315', 4);
    t('49a9l40e8ekdh705bf7i66g33f5c45b60', '40178796887510802718501234793652601812654280', 22);
    t('1c3b34c3c85359aac868b5a9c15', '178508803284588917440368782394', 13);
    t('2266675470606120531031640140307074715050044204', '102669173431008960637137393788268958468228', 8);
    t('10h81l22adk0769i06e8d6cm4ca195gii2a52', '10869724195205977220549980987330530624249475503838', 23);
    t('3pi1chtc5pc4', '97193250034096933', 31);
    t('1101101000011111101101001000111', '1829755463', 2);
    t('14a08119381f59538f02a2c549605', '6693834434076143282016415621879301', 16);
    t('1', '1', 15);
    t('5f4fde7ab29b25bdfa4af', '23976578463856222590090297', 17);
    t('1g6h69i35029818e', '28255938241753109175', 19);
    t('6hrfeum2khl0zl27y24vi8ddg143duhb', '11424803451794483589056265558023874926815658466959', 36);
    t('dmsofbufuxjqg9w', '56513064049768744430947', 35);
    t('4dnefgommja0796h683m0mj57n5l', '253005180165119243199661555791691530146', 25);
    t('1713eo6', '312946856', 25);
    t('3c7b2b515538d22436336b1d3a7d4da13456d32d4a1c68', '14671861619977476398729036327299069334875111680121764', 14);
    t('4qwt9maaj3sp1inn', '288790554898254466919258', 33);
    t('22311421101332244000124243023442422133310', '23019524981022032107906052330', 5);
    t('uyyxj8cvk5a2smp23b', '5501966907140058787121075691', 35);
    t('5l9rpehrm6sng53', '1706788842927692648372', 29);
    t('d278658d7dc7', '113890822462987', 15);
    t('18dk30d14nkf391jn981h3d9m82ibhjmnp9dj', '1154145887404199057068348781766608208776338261114369', 26);
    t('18ia9ddae0ddebffjff4c84b5645c0bgil1ehl5k', '31708278802686177414795357361653618380221248289373646', 22);
    t('24531010135252224313144452221105444022014', '37699522300506678162787688219866', 6);
    t('1435a122c73911356a7046', '1526399338520071390500838', 14);
    t('402332314023014143212', '391927271631057', 5);
    t('1vew7yl00kagl6w8yf3l1o1pd4j9tbq26', '48803334327251890804125487484681131320572737671676', 35);
    t('19228cb3f0a4795bc2dg58288821', '49714879698985993220949182598831692', 19);
    t('101013510035221112224414143441513001515500033423435154345', '38806529557660171345438701910920418778114393', 6);
    t('144142024401344124331202432034204232321141334041222432422444024414311403324', '10455975472873714399055311680044207748367282684872339', 5);
    t('9907qit', '6779912969', 30);
    t('7073', '96939', 24);
    t('vhkckv2ar9oj8hd', '57275964522373642706212', 33);
    t('1233134320020124210004433032220444200021042233114014402022042432422033111444', '40945031687597829579374183757759884584950193578410249', 5);
    t('2222101020221111100022001022220200211111121222121002010121200200221010012101002222', '1320095371747740273885112117677015990623', 3);
    t('1nsitm4w6l6idtqqsi9t0v6c', '284946527389049829952915614970309188', 34);
    t('1bjfh6dmkidlb2a05gkj760gf09afd67d25m', '693461359711438949012962332381951054793856687791', 23);
    t('1467124ltbe5885tjf26dnos1ork5mfud7l8q', '554897363491883262342501037868827669091792347235392284', 31);
    t('k88unrh77le0', '729898419802592704', 32);
    t('210120111201121222002122001212220200200112', '87431386841990129633', 3);
    t('926ic79b8762gd9j810d6gi3dj9b', '1223706960610540148323952981562191791', 20);
    t('agnai6kk71ebjd1f5a', '22882320064040934814223437', 27);
    t('2cd4ghcggg8gg9b8611611li0h0h', '4527014616841415467524507113754343925', 22);
    t('2352250503021325401322130335143351', '126559545519634091287010419', 6);
    t('0', '0', 29);
    t('6h5k9b', '65325236', 25);
    t('81b43idjccodfjc4f9lbdhoa95c54i4n', '174727107340902317729886057171151789669995748', 25);
    t('argrac', '364408140', 32);
    t('10002111001001110100201112021020221212010120101101020220110110120122101000000122022101111021', '26986516589437621598399475479704475782140826', 3);
    t('5515030240151510034313345231334334552', '60696827531635769898353913092', 6);
    t('ke3fzopiit913', '96622923170020539639', 36);
    t('598e03f8e19f4379c5b70b9c15f4fa9156bcdf74116', '2094150575916241308211940593568291573516182910091542', 16);
    t('mt9', '22050', 31);
    t('9m5peb9g1fea9o8ahe3dn8kos29str8h80e', '1624329574028280261522777174783118066092425064046214', 30);
    t('6e7mjlg1m45e570i7bfhmfeg3d86jml664f0i', '69712363311376846821424071636169936838984692925273', 23);
    t('7ol', '6181', 28);
    t('99b66b61a8ab384d253b', '57978178355149351769929', 14);
    t('85jbj3h12fe7hi8i699478g89317a077244', '1425756476686551290364945510303428131201176884', 20);
    t('2f2', '1199', 21);
    t('1662b5550ad', '422372216993', 14);
    t('k7j57pdqehkc2khdli6bmen6epbqbko4j', '413053805045735653604164429634486822891282984963', 28);
    t('c7l352qiq0r6f6r9nqfqmq', '30158411446987207313594748241506', 28);
    t('36llefmp28687i', '33170031393242299676', 29);
    t('3', '3', 4);
    t('5331355335541541550413633156555041304', '14569418445448629730411478463671', 7);
    t('43i5b5kccajifo8qn6b7idg9qe8i', '4889376657622272141258689718283342404178', 28);
    t('b1', '309', 28);
    t('4a9vo4kd4hip6il3', '163290295531837842475683', 32);
    t('41706e31dj9ahhea1k3bie0i823757e87fbhba', '33963855813517146822738096038997244039390777451035', 21);
    t('2d4a3sg', '3096803308', 33);
    t('3331103101301', '66401393', 4);
    t('4362145245600312216211556654331135', '35234402549674165076345929086', 7);
    t('2bx3qg0a15e1dwf2011n8', '10024147880840790550776084418594', 34);
    t('hihd6ih05afff641', '273205768456185626265', 19);
    t('b255o', '4331399', 25);
    t('0', '0', 18);
    t('510080h0271hkaaf', '4693884914412126100265', 25);
    t('1022022320020331232330321010100110202021202322033330222311301200212213212222230111', '6774969515016529365414708362547391944587048823573', 4);
    t('c4p4ohjglla1iqosl2fqs3ps644ko', '1077352974905789650285543140145512793505236', 29);
    t('28', '36', 14);
    t('5f43e3cbdhc7q', '2925355769036300036', 30);
    t('10202211221120121102010212002220111220201021221011200112200201120012000101011121200120200', '1219399490015420262032876008368588084898218', 3);
    t('lqmqdeigiyrstjb0ptr62', '290606160250456698859096910550986', 36);
    t('140j63g8eabdhe9geig55544ea95fdb1j7g', '206573099734256434789729083818951917803375756', 20);
    t('1121333330123010230103232231300011231', '6640763429402799702381', 4);
    t('4a9732b446c3496c8b481128862c7b8736788c2', '10313718642811383413495457120072097181651548', 13);
    t('177aia9d3dd6d7fd2f400be1f5921i', '16853319484940264292799668730168052007', 19);
    t('e996ok2br25wxr812xqwewkxjs0ha7bbqj', '4935251121671834230635165665794644497506649296785915', 34);
    t('1829fj43kdnhlebado4q7qk2b', '69493606859298866281274539784122883', 28);
    t('1ug4btjsjoljqjl8ru5', '4144140361800145764282627077', 33);
    t('59141846746238', '201252640070138', 11);
    t('3dn0q439kfh3joh90glm66', '71708810576319538414890222164286', 31);
    t('424420433042212434434234410011320342132310014231', '3265300947003957321669335288360566', 5);
    t('6983s51hy35qgqnol5kr01wq', '2043620645014439781841299449690331746', 35);
    t('33503001354', '11839443619', 9);
    t('1ea715638357a4gab8f36837d2913b7b457a087', '106285010031392323780353251260419840504700665981', 17);
    t('4423326130032', '63980138511', 7);
    t('qe58jl12nirrhapb24', '1725118401903404858826766756', 33);
    t('9ctyl8vinmol1', '31654299928017819011', 35);
    t('53kkn252hrf7ip73go6kisp', '763327533894184601429521762539764', 29);
    t('rr', '864', 31);
    t('2n', '73', 25);
    t('31de58c8c77182cce2248cbb5082aedbb8e6bca34', '345951087846276854939428074890216991884992827799', 15);
    t('26ed2hii1fb68gg77jd09g9ha25fije312', '20071611461553679427803317028838458620753222', 20);
    t('b56a74b20161a13971286a946476a56a675816549046266', '503143184803276945768198832235249483823865080806894', 12);
    t('3mauq262ifqc6q6uo3k7rhcn28owuigh501', '15665089503001948796936991201084677402815300352038414', 33);
    t('8a', '114', 13);
    t('7g74hk2i1', '4947834512341', 30);
    t('2001301233012895477086277973272385359833', '2001301233012895477086277973272385359833', 10);
    t('3', '3', 35);
    t('3v3cl34ntssctbo61j8h61awuc', '758000163587568845774810157998497968616', 34);
    t('2pj6m6dn0k2f8862ad1l', '2291763978068855450334466547', 26);
    t('1275', '2631', 13);
    t('111010100011110110011011011111000100011011011111000010110000110001101011001100010110100011110000', '72493971032499161046675712240', 2);
    t('1jxwnrx4311dqk790lxyio0a', '969152182386767070760404233313656842', 36);
    t('1515213043431201', '886767999121', 6);
    t('231546954488138026339363483421', '231546954488138026339363483421', 10);
    t('63obkjao56klm71jg9eoe', '56017208321706855359322806239', 25);
    t('79cee1c1a710f200ab5d7687154a5f', '3650407151966683309370718278348943140', 17);
    t('1b8ga7fa32455ec', '282558612029627531', 17);
    t('6jh6oofb7', '1900009409713', 27);
    t('12220411', '116981', 5);
    t('6hd35cdafbaa1j6745b40614546ca0', '369523428248678589607467253915152693000', 20);
    t('31424505144046650031120545413045362312145623206003', '830451645463432810708654518843838981528671', 7);
    t('ab7d7252', '13528536902', 20);
    t('1767255257', '266164911', 8);
    t('355b5738c3cfe719582f351c17af6b629d4', '290502049209306091381681583617785118206420', 16);
    t('146984', '343540', 12);
    t('d69', '10369', 28);
    t('1110132', '5406', 4);
    t('x15mjchu7c3yp', '156518775559992462865', 36);
    t('1lb759m57kc3gek0k95h', '144338567461065415742555002', 23);
    t('6eoirrjmgwb6obmpjo61', '806330884412638477847015065941', 34);
    t('3057512050807124036250432', '245051565483871936556723', 9);
    t('1a9lrsle898kn30ra700', '15622486673307407101219146300', 30);
    t('2dff5q', '94243340', 33);
    t('1018b49ca466c70abb8bb400a59ca870252c7224184c01382', '297566178044937671004403039004634049926129648125406845', 13);
    t('g2205xofm41', '33155058894377401', 34);
    t('15a243c6d249', '23786665988681', 16);
    t('ifej8jf196156', '409370272611766206', 23);
    t('etkn2y3s9cvl6', '70229835510573528042', 36);
    t('29j6gle78lp65m8dm7i09i4k69pkn2jodkfjo7', '53655147107520605107993005320957190736069756575349851', 26);
    t('25a8', '38800', 26);
    t('1467iplsq5dslc4bj59r8kmpb53ij1', '2940974102374884746297729490325333196270210', 29);
    t('4536654164105350431016416626411512', '37076575885240993457676872428', 7);
    t('2nm62', '1531793', 27);
    t('30120131003344321043400200', '910915490646856300', 5);
    t('g5gc3h6cfg0743a72d0', '642497565387831178951530', 18);
    t('3a9e2ecf094bcff872507503010fcbac11', '19946638349599244406026473172687735467025', 16);
    t('2iifhg6ffdd44e7lbe0cl4kg2ikhi8j8j5', '569950147839903345158898327398158628782163599', 22);
    t('111321132220011110203311323001012030033333122210132333132', '7106340429083953157339766519361502', 4);
    t('1201221111210100122201012101121022010110011221222200002202020102202002202022221221201201111100', '409732885115794556739316662328279212569754192', 3);
    t('b540j', '10311549', 31);
    t('6a5641ecbfg1ea', '65437633393280157', 17);
    t('60a0k4g', '516550456', 21);
    t('6o07a19gn95qqgff1r9gea0', '471673109789461277231531949208824', 28);
    t('1mfiu6v72mratrp5prdp51', '437124683387082202034280167355051', 35);
    t('200010223200133123211221100132213031', '2366578692023700810189', 4);
    t('91o46kk', '4369067940', 28);
    t('9788582921928030343347009158567718617002', '9788582921928030343347009158567718617002', 10);
    t('10101010100001111110010100000111110011000010111011011111', '48000163788893919', 2);
    t('1127455366', '444026184', 9);
    t('kc3', '26355', 36);
    t('2lp7a3ilb6bfnlk4ogm', '3318777765483669862045868566', 32);
    t('2626066314348382334087016144874320851', '60819966203777863003542815738208343', 9);
    t('bglhm6dc2lbdk2i', '246210942857687735106', 24);
    t('104250563615655123425305223624351100434404606601061642122065', '79076976109191887382437259405911955830291672386105', 7);
    t('1421177654711484117133204549051424', '1421177654711484117133204549051424', 10);
    t('11acwiup3x7vh', '3504374201215692052', 35);
    t('65p82e8jl85ml9heap02a4nld1', '22517218879878010567520679124266724821', 29);
    t('lsje', '1016762', 36);
    t('21a393696a4', '56451375083', 11);
    t('807c981a9b4265463804343a1212a6', '1621821470894150277381748029433515', 13);
    t('46121044606131213674', '687399603768989628', 8);
    t('1222510546137173360622712725208565646586263870474284165', '4228218347033366281983071723933458237415026632421325', 9);
    t('210a273248358a3309b93', '8009667820567421769567', 12);
    t('am9m3dbgll5g2gobdl47ecfkl5n265', '1175130187214663893323173490478694625614065', 26);
    t('5051886704b13c99002d580d6629aad03', '23841202011560005570250339873422608167', 14);
    t('145h7ksh68dngfvid0d2t5sj0sock9d2h13e', '54135831669620078248540205180825147407334169234670702', 32);
    t('2', '2', 22);
    t('9', '9', 27);
    t('404m0929nhj6g3dnmk', '1165673727265105034486756', 24);
    t('15254347665284856901682080432226700882304900', '15254347665284856901682080432226700882304900', 10);
    t('33242010105400244453142514140511051333355', '47797340239896148848896357884199', 6);
    t('38842', '26201', 9);
    t('ih', '467', 25);
    t('39i07de6570i4045a00a53566h71c6c', '812073321324466799437765816797697010511', 19);
    t('1c5275eddd9d16247052052d663a452a63463075e9bae', '10204524473213180795676416372405071534170216958491764', 15);
    t('103424333140140020211212040403022', '26931963138899281575387', 5);
    t('2', '2', 6);
    t('322410403313321422041034123341223413120', '1278336783462605112004904160', 5);
    t('324', '905', 17);
    t('157016a602978573c19c34c0bbb5b99242570a479462785', '2486227056319163423119585018132170605939378769156255', 13);
    t('182803a1797819510a53305902aa92842958036542a3', '1054102736944210758101345700310507040992017617', 11);
    t('23212243001042341214134020012203124424420014304114414302140200222344', '182426131021917657349015925899722232349209773474', 5);
    t('44615', '18829', 8);
    t('0', '0', 9);
    t('16320ab4', '92882209', 13);
    t('112022211222102000100021111210120012200211012002211122100020221022020221000211210221211112002', '125052658519630718209984060103893048415853566', 3);
    t('1340023330b2816a', '19686890504051938', 12);
    t('224a38884764730225a9197021a82539496', '567834953854624641093665357593660410', 11);
    t('7a376a34653987b669615931454', '89961092718473726960191912000', 12);
    t('28750672b1a08159168b61aa4b65402a4a7bb', '1926663722022386252350512493673056478207', 12);
    t('51132b066849699663a69c23014a9', '626977183384857905326074634931325', 14);
    t('111001110111101101111011001110001110011111000010110101101', '130312977572136365', 2);
    t('32036543023423166444215212320333164', '178439557729142493094112540113', 7);
    t('2c6o1qrt', '65869267447', 31);
    t('11255025561251045231224000464003501561312', '7642441686790045418235602618854503', 7);
    t('ef3499db4bh46ed', '47755591093273946707', 21);
    t('b2b829fe48e23hc7e0h629gc5', '14916845674629231086360004118853', 18);
    t('2h42', '83074', 32);
    t('409l0boib2jnp9c3s6t', '1553857676392526343363526409', 30);
    t('1484hk4mnpcq8h7coh4s1852n5a263', '2946760199386210436099617232527112169685032', 29);
    t('1de4i757jb9efi40', '112491740329665106179', 21);
    t('411544125301', '8264748073', 7);
    t('2700af68ha3393j4lom6ffg3o49i83d8n', '1236005201183605405737692388333431118098883348', 25);
    t('260ba5decd5', '23566738197065', 20);
    t('161cbd70d0dd827d45', '43857475434041062169', 14);
    t('102102110211002002102001202210020200110020001010002121', '24605931904729883191409011', 3);
    t('261285518c13c83b80a6141c98a74515', '84082439719575951296466210805706579', 13);
    t('3l8odr3jb0rd4pikg2j9gak', '2380011848157138949995072867010228', 31);
    t('6252121061244', '88503004566', 7);
    t('4jjchql40icjqfghfun9bd', '187112850943724980990652726355309', 32);
    t('1066551671032724130551075541344416006004545251', '48210079462363778492658888113295918811817', 8);
    t('2b0142e2bc8feaa4657563be6095f30f9f787e6', '15344670653497010702533663436850880847648622566', 16);
    t('202121222120120221221121110100121101022121002112222100202', '1199573832123177666249284048', 3);
    t('165', '725', 24);
    t('7552109468745084311115076521370466702755126903852723', '7552109468745084311115076521370466702755126903852723', 10);
    t('d92409d43a71035dd1607162ac59a36', '330459364479294639582756285439419040', 14);
    t('5866087207670384282121402433586', '253132125297513316727613194688', 9);
    t('hne5k8mhl3eo7pbd173f881cpo', '4239590379457835998662721763582285498', 26);
    t('43', '115', 28);
    t('4b56a3e2e6ae07cbb13415ea5e4e6b26e91c7547c7e1', '1775440932456640417914474064580085383417183550152911', 15);
    t('52v37tbmm0idhufxl061ordug9j80hbw9', '130694367745642080024891425171303262177267298512229', 35);
    t('57b110d1a114200601b064cbc8d3d6d36d426a375', '38897697195561314890830075857936232069438002819', 14);
    t('1010114', '16284', 5);
    t('3011332032001111112012121233222333112', '14607768040300540243926', 4);
    t('12213', '1809', 6);
    t('1efko0', '15481850', 25);
    t('6146dqjn5em3m8iag3hnhgi9cqh0nh5', '156984890010244096277130750219079284286689617', 28);
    t('3853245phar6qkhopu3nhfhmdqp45dqm010', '1659449215436607323768397181970499924333501857945769', 31);
    t('1kbg', '23016', 23);
    t('349bc1ee612041071202acda5e253ee814767bdb1a58', '1235304033805275134490493701587801892224447248153208', 15);
    t('254054435232113145254243412201240513023333', '236517755592988157513186489952873', 6);
    t('3123222202033123033333133100112311110212332311000201131220301', '4562255449967943117630410467356039729', 4);
    t('20k2g1b61b9bb', '26244500043153689', 22);
    t('5301274373619a9abb075331570b44372a320b45b38', '11112964586088228654822104128277512727028281372', 12);
    t('41kt3bliuu71', '284086055727071575', 34);
    t('26je278jef63f30b4h', '70007399630130868935725', 21);
    t('661746213440700265725363254604246460427455151704051', '9677402829255135526689200426680775741960325161', 8);
    t('6175', '3197', 8);
    t('145092186943011290758112327', '145092186943011290758112327', 10);
    t('24012130142220113203333413000132130030341343340', '399568998285969726086954376512345', 5);
    t('137jb08gne02cbkl5ee1giga862', '874678313646620526970274269320064658', 24);
    t('bj49k5h', '6935833969', 29);
    t('401151407274000477346136437000', '621886148896195273543007744', 8);
    t('e62ujehl35lkp25kob1e9tvetqh972', '3668880263925499454416380147695985359306937564', 34);
    t('1221221010111012010111210000121100021121111210010222012121220002002011111', '44164600435998484951707492971081782', 3);
    t('2519ebiggfgg0k7djg2l5f32', '16752300490444701684531024329512', 22);
    t('12jrw3z5iqh6vy4hd9umfbce6u7bhmd', '52334612299904782804807790302710417391016520949', 36);
    t('m90d8calnmib3n38f82ag12c', '1243484437066565674917884244591228', 24);
    t('5o9441e1ehe6', '71232157609716713', 29);
    t('mo6ub7vjpqcd41odk309dkb6mesoudc', '32479569784999047522872481329328980918409132460', 32);
    t('99a104', '2443540', 12);
    t('1001110011011111011001111000011011000100000001110111000110110010001101010010011000100100001100111001101001100110011110001111111111110111101111010', '27331074366810509421853388280769875793670010', 2);
    t('140135470caa96563a640912c99695818a', '7530555028125352679628379917810633699', 13);
    t('1234320550101200300234201211525525033442525240545402554434330051', '15178212380235027454950908395863207673277874355183', 6);
    t('227qji77n49doii2i14mi6anfbi04np4n2', '358193257509349600441790087340361151109806798954', 27);
    t('5b1706', '13823418', 19);
    t('249c44f17568b404f004d1fab5d14', '11880762815518784994450284839918868', 16);
    t('6radrdrbdm7mhpvswkb486v4eens16w', '24529899580687594598518917969085283802959665013', 33);
    t('5496b049593863de8ab664bcf192d8aa3046b16', '30182230828157060898612488525177295598317234966', 16);
    t('3', '3', 5);
    t('dhda22ffaca6je08gg623d3egic495d0j3e301f5', '7632679632132235991964925001252763420525080557280705', 20);
    t('36ca696c54211109ac498674444579b926437', '44733871000508032307696312443457357060058', 13);
    t('15nn57058h663g02i5', '363480846432405747500597', 24);
    t('1420220341042043041130312221022231231044021124324024400213', '13072107582995750416163595291483084215683', 5);
    t('g91', '15656', 31);
    t('1000001110110010010010110000001010001001011100000010100100100100000001011101001101100100001111000010', '652129268908332354914162721730', 2);
    t('3308c774d7a9d93620db30a6dc7c3afb6245cda884b8', '19094196084927690615894155917265930659289199085651128', 16);
    t('9910587826577455047017155908954', '9910587826577455047017155908954', 10);
    t('1pn69d', '33086633', 28);
    t('56e18i5ec9bc9bcfb506', '170001599187441436937591218', 22);
    t('8dg63a351777ef27065718ede19a9g', '4251605536447843079014370453494147309', 17);
    t('3757440272647170475376331367246161235546703357147547454', '23196351263151106376071114036941254762538586787628', 8);
    t('1133102031011211111321020120221222221013303233300222001020131200322121001', '33201783315139109346417949703891666719712833', 4);
    t('111177ac156c8061a2cb9c2a11c49c9bcb1b8aa61251a', '11177922941418324255581769628452411069931934894274', 13);
    t('f5a25dlig1h8in642i5f6482bbl39ikdf1', '53647895828829728643682410481516014676799977129', 24);
    t('142103234113241523135450505', '294644752058281948745', 6);
    t('3e8u2lxxicgxl0', '579245446681359249924', 36);
    t('e1aebc286f28a4213d5b89774ba1b2c', '18748973437595317918722188262730505004', 16);
    t('14i0l6ha6', '94600891963', 23);
    t('fyi', '19583', 35);
    t('110002121111021002012011', '126535710037', 3);
    t('2ede2k53307k0le4g202kb1ka8j608e6fb', '531584620037427546349053144337530803653075325', 22);
    t('5941a2ba5123ba48823bb', '108647376527879131217663', 13);
    t('1100000101101000011101100101011100010111010011001000100000101101100111000010011000001110011111111111001000101110001', '31382251255391898419590799476887921', 2);
    t('2798b48667a9a76', '3403683742605498', 12);
    t('f0wpw0tsqxe4vg84s', '47926281420044967329301940', 34);
    t('120274183083323227016750865268186648155326604433755556', '460659788402837426091935077340365397293891092234756', 9);
    t('5165bg0dibdk', '2955698679780350', 22);
    t('4id7h78kfi5m276c856bd0d9jc01a93f0', '700749527198104432526320153790964979274223144', 24);
    t('1101111011001011000101110110110111011010111100010110001110100111000010001101101001100011101001101101101110001101110010001110000000001111', '75812640390549515698067392896804260995087', 2);
    t('1135', '605', 8);
    t('16fceb35ec78f61b7', '26503318076778308023', 16);
    t('gsh3zf', '1015286379', 36);
    t('1330803169291356585', '1330803169291356585', 10);
    t('106eg28dj4ab8gjf893371d4ic', '341198497110116667345130454665972', 20);
    t('1031332103011210202123330122302232122332133101220', '96526406143541450009541735528', 4);
    t('ak711dka02e97fd29a882gi5d42540', '2423827227910121626584716485263513891048', 21);
    t('8841418102', '3463649669', 9);
    t('190a8g5f0b22eaa29h0fd75g', '111655360963807509350164170526', 18);
    t('1101010000010110111100110000100010111001101110110100011101001010100111100101111011100110000111000011011000101011110010111011101110001011001001101000101', '2364878576296174981737730111388996744591545157', 2);
    t('a4f9f563b2hd1d', '1579563483297980704', 21);
    t('1e', '30', 16);
    t('bmj9i28fqup2rr01quj', '25168455972112565443783764925', 33);
    t('2659c2524b681b0611bc0462068277b22c4a090b6c', '11718193492167173003845518942891790726930347344', 13);
    t('95dbhv5ghj', '425304350878063', 33);
    t('70f0bfb348eelg', '1988449310602969318', 22);
    t('5601892416741275270a47a14b258b77b62ac9a', '11674083978692042300298963640315521087970772', 13);
    t('18526598951b4925686c191b82c726443', '728861732602079775340902630060883104', 13);
    t('c72f1ga78a3b', '4322248291965062', 21);
    t('43i7nlns66s', '2432989186691608', 30);
    t('umkamr', '1393260527', 34);
    t('1144311422131400141044220', '83282084180409310', 5);
    t('4336', '1546', 7);
    t('47i77', '575935', 19);
    t('260391741833138309844242694047', '260391741833138309844242694047', 10);
    t('eikcnkechdj036', '21983428280688968831', 25);
    t('399j60', '21947290', 23);
    t('547573ba0754c7d9cd26bab3c7d4b72ab562ad35b3c78', '1431614009980309658037899654407501069747983045942546', 14);
    t('1bf61n8b8gl2inhm1026c0bn93gmlmkh18c9l6m', '41658106305222335140890827573148074573365393774007782', 24);
    t('22ba4a4a22063356716285520739b82386a133', '19129802531842066466744883829679615294007', 12);
    t('208263', '1098079', 14);
    t('802a2fb0ef85471', '577202901428491377', 16);
    t('6e950otf9qieb8sqmlkdq84h0fk3fi22', '40005797156134257760904691332287629017123851262', 30);
    t('10202220200010012022120012111211001112', '566544668055011303', 3);
    t('88ofbogm6hfl2fmabbhli9jb', '2922571833986926750005829529758653', 26);
    t('254221216022520612441642424104134100642', '364163231141058677780767508382534', 7);
    t('3k6m41606ml1ik41545j853488196ac508j', '77247355295178353514512199583695660421921997280', 23);
    t('11320022231321', '98610041', 4);
    t('7c25j5c2c2h8m2e', '87247680970474478133', 23);
    t('7u79or4r9ca2aq3pq9umq4', '612755209566507170400347312382877', 33);
    t('6hae760771j1iaefc20bh5ddc12d537dg336db7j8', '75611167578444251429175163594651767050933149653371188', 20);
    t('2032r9kjbnaii717i', '501415814815568679766375', 29);
    t('367k9mu6s9hme1ngoe7gnih', '2066867889461958903697381214108212', 31);
    t('60j2m', '2001670', 24);
    t('71h62c643342', '456889209843566', 18);
    t('12312260105254421212115405048517370253420300156574618154', '38374839154335357656678955333874522222907486811128641', 9);
    t('47lkf1', '121626548', 31);
    t('5', '5', 28);
    t('1101111111100100101111001111011100000100000011110011111111010101100100011011', '66081699980324911274267', 2);
    t('eaq63c', '650488250', 34);
    t('3kh2ikk7k1i37c9h1gk1a7fj9ek', '95237913325164984575779037624604026', 21);
    t('chml54eh1dek5', '465563672539918181', 24);
    t('19650e6h06cbjihffkc67', '2407869036365245485341891710', 23);
    t('1120330254342541015412', '26871303967424288', 6);
    t('1db61d64d2aca4f8ddhg7ieb', '442324583985640572989145851962', 19);
    t('h5g0nn7g00jbq8dkal27ddppd1i', '282596981311037438532533274321771897012', 27);
    t('3cb6a74dbc0782a7c312d88129b86a1c8', '18574170307436528537867610263305518660', 14);
    t('9j93cscrm2saln1ns2d0cg', '49614136249868364997959915587716', 29);
    t('12nr6ks92puzhecioazklliu3qqhgd902mo', '88154165422723953669323639000490842970444052275022416', 36);
    t('2h', '57', 20);
    t('3', '3', 27);
    t('1aj8uhg09llocde4jsa', '938586685176702437596326906', 31);
    t('a67wb8fvo1kas0p2dtvb1pim7u', '935376131947858129999170856037964165345', 33);
    t('8cg0wsd5hc1rj2ur5xe', '86081079913939968176696159426', 36);
    t('196hca7f9h0d3de53e7dd9cd', '384908563380755640626858713681', 19);
    t('24i4f31gc45g4', '5004498340474430', 19);
    t('2p82al4l2aofjb0l433n1ma2pdcm1', '12374372390948872370836716034198336907461', 26);
    t('aickd5fc9kcijdjk', '91778300438306519322527', 29);
    t('bijb6jff785abdg50ch93jci1j07f0', '641502687123029513871412727798918243100', 20);
    t('1110000110010101101101001100110011010000100001011100100111001010010101111000000101101111101011101100000001000110000110101111111100100000101111', '4912801682953604186696386732310079951849519', 2);
    t('k4713cejo6jmooion0em218l2', '71662757397263121604346927461739902', 25);
    t('131p0ch901seflrw7hpck5u9bwvr7', '8293373983427066208235978575638533608956521', 34);
    t('11000101100000111011101101001000010010000011100010010110011000111110110101110110100001100110100100000100000000010111010', '512777157413030085980733281858093242', 2);
    t('56a0631865658b42a973787149', '38957935569902816546521273555', 13);
    t('7339fcb70cai272ic', '4691540493840057977172', 20);
    t('3302000230232200221211111131020213222022300333232222303223003331321002232012033210313', '1414797421045846182215653783000271431836488267528503', 4);
    t('1cef5g065cd4bcdfgc', '1453833012137887343510', 17);
    t('22905c', '2265180', 16);
    t('14p1aq38h5h6p3ggog8pef2nq', '146180156816301607543919347943451040', 29);
    t('fea1kjp1rk207jvbgolwua1tn6iiw7', '1680226571949963189952641105288040096752983593', 33);
    t('18gklif1hf11kk2bf5d65m3cdn16f2ih9knica3', '38229891140881220748747963138698607615755419662309363', 24);
    t('31864470241501561251518062508850', '1228037037479082758134146470778', 9);
    t('1f8h38h7ecgh286hig9bh5i20b', '594633699552685458820517879344811', 20);
    t('1558082832482056078618821', '129891586602840328457452', 9);
    t('7b2d96aeee4ce78ce5aee28', '579561875731331284066869188', 15);
    t('1210133301012212101130002013110200312222233110232023231111013020312221110011220130212021', '37600153384455208153546802413238636668955012511156617', 4);
    t('1021111102001211210012102112012020221210222022011101011110212202200102221110020211220220220220202211201102', '160009247997291013413774126585486451337226598990112', 3);
    t('13g', '716', 25);
    t('10dj', '17933', 26);
    t('jh75i', '32715126', 36);
    t('2175424561041415433353531757', '5428551387992052131083247', 8);
    t('180ka63', '255086355', 24);
    t('48a1615136', '176001170901', 15);
    t('110010000000100010010100110100001011001001100010001111011010100000', '57655736925864654496', 2);
    t('1310', '1705', 11);
    t('1zewmp49ibteo4c', '12181934920523719776924', 36);
    t('52520357630643422', '1500865557120786', 8);
    t('bbe35djn062d5b761si4ch35amf', '1199785854063018906993506866638229011140', 29);
    t('0', '0', 25);
    t('e5i7fh471g2a1', '58556310038689001', 20);
    t('8108b3', '11444879', 17);
    t('12133332000140', '1794406295', 5);
    t('233cci793322ed7d9cb8855ed24ffaicg17d', '1237217723084165492642180249762745096032841489', 19);
    t('kia626g3jjfhek7fng5d0ihn01i1cbi8mlkj', '175644053681799645945065512508851170704116634341769', 25);
    t('307id184633ff2gcecfj', '15832615175405459381237119', 20);
    t('102210122003344331140041103001322204034014044', '6239672517153332817129500298024', 5);
    t('4325101155', '46150847', 6);
    t('12003220425', '80779841', 6);
    t('k7khqonlt5b3ce9od1ouu', '25655759396523763765963618575326', 32);
    t('1a2e', '5669', 15);
    t('24642336001364105631011', '10582257656560822478', 7);
    t('4200112121043211', '134340409181', 5);
    t('dji6e981g0bmicak6nkmjldmb3', '442482125298832453947547925860696203', 24);
    t('1ouvmsmphr12ugwqkp68', '627712599848792393543454824048', 36);
    t('537gbj98e49ja89d84j9g44ch0940ga5b', '2220315485025179053502135485282739788932111', 20);
    t('714313', '423075', 9);
    t('a23c0', '290667', 13);
    t('c2g4dhaf324d15b4dfdfh8a37b24af52g3d1', '1045967377308067032554410895079596222351962039', 18);
    t('1adb02f0gf53ff9327efegda34df0ge1f5d9', '19026193308545467945661475426458835723094908', 17);
    t('236188c20edc4b0a6', '14628716301779930406', 15);
    t('16ac59431489a575d977893381e17996', '4165152233272488511477307829446785791', 15);
    t('i15f3hhg737gh49f464412', '37883791206577734258893793622', 20);
    t('143912408735308919916476067550676143993718804207', '143912408735308919916476067550676143993718804207', 10);
    t('2c84hcb3e617i308g011c2g97', '13003562015150612759615402719156', 19);
    t('1', '1', 30);
    t('24411332303104412232404024412', '110670388179331704982', 5);
    t('1933e587c735a0944325aec2059cbfc7447e', '2195466647218532976318479234926892387091582', 16);
    t('12bleplh50em72e7co2m5bc', '14743439849575623122276244494446', 26);
    t('58xh', '225347', 35);
    t('4icfie106h6bhih68cc', '1292892082246312828371452', 20);
    t('453', '299', 8);
    t('8rhpd0qch5pktpovj1glt91oct0tjlr', '12647022957479689372096487316445682624573132475', 32);
    t('2dj00qb3qpxopwossisb2g4otn9f', '2488698509088656658453543066597325211124483', 36);
    t('1010310', '4404', 4);
    t('hfq3j1a9ndbi30efh052', '27619266965177624232556247447', 27);
    t('39069027740350553286', '39069027740350553286', 10);
    t('9bi416j01ci4kj733b87334164j0igi5e6h5h', '3806996854533890953144943088476687870626549429877', 21);
    t('6ca196aaip90qn9he2g0a4i2mq3mogi', '56367196598633473854629190366616476560879928', 27);
    t('16cf7', '492257', 25);
    t('bhe1co7jjpkaj18teg3n', '134616320166471331187477282513', 30);
    t('11e0kng0kkbl3j', '934367663338406299', 24);
    t('1514314554356446416612036633020010445411545120500414631632', '2588550172153450082104301619898179441784748691764', 7);
    t('53657', '150482', 13);
    t('566a2326039100a019069468b084aa0a8a9966a', '566225725026345410347153259571357126562162', 12);
    t('192996', '296676', 11);
    t('1gf0p8he3n6f9knc95c85j1lcea3ei', '177191432101748018199118067763850396927258', 26);
    t('2j2bq68kmo136', '4299689571441867510', 33);
    t('ji1d29aeh6h4gkkc0635jefbbe853aijb', '40645713826960095513453151704998149841545850', 21);
    t('37710781838842630361512', '3806832103892449001030', 9);
    t('2442143434220532532101123222344253535005050540352', '62605961983133424986426709017621042732', 6);
    t('d518g', '6029468', 26);
    t('70n78hi8c', '1986022468452', 27);
    t('38bh61b21cga0e2ff0a0bcg4e3gea06gb3182e1hh', '565783320821525533704067328716967069896244298888023', 18);
    t('1001000100111010111111000011101100000010001110101111111011000110010001010001111001110011001', '1404582351453280869403915161', 2);
    t('333924a049a51684529a74ba87412bcbac8', '243398556912996292725156441791879362977', 13);
    t('17a55a93a040736775744561a5055a9385', '40020975700910684233413707318255946', 11);
    t('6b', '113', 17);
    t('100110101110100011110010101100010111011111101000111100001110000101011100010100111101100000011010001100111000011110', '12567788490336688088992466604707358', 2);
    t('j', '19', 33);
    t('5ea8ajhd4j34fh5hbag04g1', '240168729092027349654498561921', 20);
    t('q8mr50da1a05raqf', '226974721325958220743445', 29);
    t('e6a3363', '1620616539', 22);
    t('75503024732436207824610451700833671010674575810465066', '318007217504658857405619875262949061586268948936365', 9);
    t('34ee3cc09kkl9kf6ac60h4afc8', '11677571670551009274952367520363516', 22);
    t('1232306211304043222536154143636150212163663301143551245', '5847041463724405635992138544250779787366825652', 7);
    t('64214b1895397696b4c93', '120114256331405719997422', 13);
    t('110001100021002021111121022001121020001101021112121212002221012112202211122202112222111120', '3895174620732775849452424240420599239140176', 3);
    t('a87e916d51599b02107778980ce73', '9006992363531177743062167113009383', 15);
    t('e2eb9fg280g68256e53875a7138e16c216e6', '164829342483558859829243147407641086382111803', 17);
    t('dh7hef833', '6800973993113', 29);
    t('87ecdca16b110', '4930623993377600', 17);
    t('242664233613444510003204103241260166', '997238647098049790608059979085', 7);
    t('24865', '2524505', 33);
    t('8dg8ee', '16577402', 18);
    t('dcb0', '56496', 16);
    t('100140020240014343012103310244203321413011432220000311343', '1407800314105875865179520542356562510223', 5);
    t('8ic4cida70638r6qd24lo1eohnehq0fnq8', '4939135926415967125713934662696787505407553615760', 28);
    t('110111110010011110110111001011100010001010100001110011111111111101110001000101111100110011100110000100010110010011', '18104495725933236784651084181816723', 2);
    t('2110', '66', 3);
    t('9h553ajcj585e0fld63dk1f1fdg38bd7c4c3', '944691391197912510590336782111009994890396317899', 22);
    t('d94jspuomfb30nnigc0i9c2', '8583227698431941711284555523051436', 31);
    t('540511212211521022015430420425', '209679875672133971720897', 6);
    t('93521bc9838bc844374c6', '176011291340468000063614', 13);
    t('21111212100011211111122102212120200222', '1127735725992381629', 3);
    t('433', '118', 5);
    t('b35f3d85b', '78106650410', 17);
    t('24ad24572815556edb04e8388a3cb8dbcab', '22472704690990952783138622997610828085611', 15);
    t('ej7615a78j777d2d7a6', '3923839018485436650027006', 20);
    t('6c', '138', 21);
    t('2301032330302133212203322310000123330030112121321023221320323132221132330233000122011322', '66310958980712759741798040630188575295953581006496122', 4);
    t('3892bc32082ab81c', '187850563808306190', 13);
    t('nepn0i83d', '8890790458465', 28);
    t('27m1p4cgajmpd77n5nob5k3ckoo8172n2fl', '2959224102019221153580776647569649027089445494715', 26);
    t('2c211bi9a4i4g', '5837125451724486', 19);
    t('6finion2cknbcjclfc1maacjl3n', '277329603884172207207342214563875742203', 28);
    t('2744a2b1b6da050450ad1dc77c3c444918572d3a95c77c', '9495750905280175430367933734800935871583094331419290', 14);
    t('2540b7a2c', '1964842541', 13);
    t('29hbanag919j07i2h9fm5n5blde', '1847860763613921662545512809287537286', 24);
    t('522636df92e24188g123fb5e646fgf28g1a5e64', '292970008668785630924688679808211955559007788343', 17);
    t('165yyau6n6umgpli0rnp', '255752898934275797065342348280', 35);
    t('1110', '84', 4);
    t('293b01a935a3799a96024719b2b03915938', '13670064701193438658934893988141749244', 12);
    t('1v4r1bs1', '82842560296', 33);
    t('656babd', '48129143', 14);
    t('261351cc2663d63', '70221672594373143', 15);
    t('8glmoqrlas9stn2mi', '3683728409489953625513478', 30);
    t('c1oce8e32d', '65559511889053', 26);
    t('564031351615643266525566325521613406414624250361503461216530430', '147867740046978228024321274080345862741610052024709013', 7);
    t('230131444013022131034243004132023043040334422', '14855672849648868100497603839987', 5);
    t('12545150406353046425421123355434036032', '26016700480759035883689036134576', 7);
    t('2dlta5vhvg9qgl', '132869544199893066807', 33);
    t('2312030023204131320203', '1266940535807553', 5);
    t('2977597a8b13493692178b15b', '222825050040676849479153431', 12);
    t('385bd327542709g6e5271h7ia', '16835126876024648618550765824498', 19);
    t('1319267918888', '4042081859901', 11);
    t('hr996gwt7sli7tqw6prqc46o1', '49591308422914160460367750680805956892', 33);
    t('2m6n7a0q732oq6ax99rs99uvomu2fajwm', '26979653390318370528670832083221165119891832619810', 34);
    t('l1973bi5hak3elkl57a4bjh9167d', '37065350900219381074120392127131177415', 22);
    t('43llt8lf8l2891ttr9p85b6m', '82442096432449770071926138860460002', 31);
    t('506748004476441', '116315255825092', 9);
    t('1j73083e1ek8ek8ac12qlg', '17167767622561300310786542488046', 30);
    t('7g239db88h4f1b5807599egc321dgedce78', '37727159811971103917360167652947572210206126', 18);
    t('3h6', '1412', 19);
    t('1875061762750423705', '297528461189732876', 9);
    t('adkaja86gj', '8471456689351', 21);
    t('7edjg9684771l', '721329267732824707', 26);
    t('1655c91427gb5325f4d69a5g98fc', '10534364998017011610805677227288034', 18);
    t('1', '1', 11);
    t('980817ca67b74b4a12b53b8065a09367b8579846', '267254106995150662257373930152524132970726356', 13);
    t('3835160608814336587', '590328195439989373', 9);
    t('86aee9b70c52fb93dea1ce85e', '666919169547294519852185479262', 16);
    t('b60f869bg5d693e84g6dfe2669cbf75ea96568d6', '11034100614489305854323210870717035173423206179782', 17);
    t('13130230301232022132211111011003302312223321', '144073625444367205824948985', 4);
    t('i6k473f9cigp', '101452153263413209', 27);
    t('56d0g6d5b64f56ba74g2fb768e4g149193220g', '18148997614117285672045460339793419442793046305', 17);
    t('450g315d6c609d23dfa01bf1e3ebe', '601353401386687882116399680820562724', 18);
    t('4352502133233111221215445543', '4761333221430647953287', 6);
    t('396769e718f39e316d00bcdc49721c228ea3', '5000590150769401690668401759809188422389411', 16);
    t('ad7b683e1fc7cdea2dd3fda24f96f6ce5022803f0dd', '4056709020997348015695058837718936633645982841827549', 16);
    t('331484', '811108', 12);
    t('k3i5', '245346', 23);
    t('135cng6p', '15032544769', 28);
    t('41431552231054351454251041452441434304115015351502140424230300', '1258945994027471345472426069448355009467939191900', 6);
    t('31023c896cc216cb8959414', '9885951986278698583058420', 13);
    t('6a0d8b333b26dcd0ccaa3d3303d3732932', '446217024491807326078408464241966377488', 14);
    t('325bd1', '3300305', 16);
    t('4156172b64866980a8', '9144238910518146944', 12);
    t('1375bhcg8ddde43f7551f312', '303750588830256802292808765740', 19);
    t('1k03jqlfa4klao9jb9a3ho81cn6f2l', '562769643994858107795871822429176159838800', 27);
    t('19375332788653716726349605608924050432887719120', '19375332788653716726349605608924050432887719120', 10);
    t('24gte619dnxqqntp5kjigqo94hnpkhw1g1e', '67033488159416015091486213127299423889621915101970024', 35);
    t('79b5jfflhabec1i', '46242889680463735640', 22);
    t('3136523464465430', '15305223556763', 7);
    t('24h', '1265', 24);
    t('2eeb9a81387chlge6a82i', '1880930934491341165799127406', 22);
    t('3h2s642hee7s1mr2qfqjs9bnmi8bkp567q91d', '158997805986072348580445510192627913450430823619387102', 29);
    t('175c2ee70201e7837c5c0a0b323969d8a8749ab7', '11002072616623697244801360586654294094591597797', 15);
    t('743bg293f6bab3e91089478dfea389ah266c20', '201573045644676256310882487614494362105144963300', 18);
    t('1104154030050343015502310415254530311', '12239997207198897956935770115', 6);
    t('c', '12', 32);
    t('665fcei2a6', '11296107920224', 23);
    t('12011220313142422020144234021000241120013443341142414232113123331303104302114', '186661780639150984434609490693985841246731986480931534', 5);
    t('143333403021031322023424140200314313', '5675316520546384121885583', 5);
    t('22032030123002232430201320123040', '11303442964719339223520', 5);
    t('42wnriu9jc1d9pi6m8iiw73e5i1', '12392393408418156448684972868597198547946', 33);
    t('65jhb5kj84', '11265751641346', 23);
    t('8jboj1180100', '32109820032181892', 26);
    t('404013250231232343032', '15035328204976892', 6);
    t('f5loqa6a', '159157001341', 27);
    t('3bace918a9ac3ab0e2c9d64', '1154290724173228330560822628', 16);
    t('j1f02okrpm6braj45g6p79o9fk2ddf8e37m', '1003413309681967687472390428106527031481479140655021', 29);
    t('20246731230644474456707331224171', '20210639089554274678470944889', 8);
    t('6ada3415177d23a183a37', '567634082013543482865249', 14);
    t('80d1jdc7770i8j38jh1718e5a', '3853881204132107057348022178700165', 23);
    t('1135320202552420132423303550434554115305', '2842213632774508421222497813913', 6);
    t('4556754565', '1792468580', 9);
    t('2b3r4b9krhfmae41cjj35pk55og42r11qh', '38693692809223437015464946236160411990614992957508', 31);
    t('3d0h89gj', '6521609785', 21);
    t('1465101514516303445150635221541651513656043104', '182862618643837207841758558179961577682', 7);
    t('15hdb8f1kaghao1midm', '17870640162985488516370972', 25);
    t('1111000110100000011101011000111010010101011101010010110110111000010101110110110100010000110000001101101011011001101101101100100110110110111100011001100110010010000100010111011', '45201658205192969951078809960368998187352382503454907', 2);
    t('1364beii2hig17k8j693m2h712ag3b8', '81200218931722105270666349240310189486416', 23);
    t('40s0c831o9f90omcs700nidi9s9ga7jneal', '672278250813445369021834441413341140309396296123921', 30);
    t('b1h4kk729ddg98264250', '146882207557384251944382069', 21);
    t('an69hf2fd88ika1f0lm', '76557434096017215994674190', 24);
    t('1212102020111221212120121021021010121221210201122120101112021201122202101012122112021110222012101101020210221', '6313978818560826155486650951933487040678832450680226', 3);
    t('4ejad5', '65217425', 27);
    t('1011504405105011504344000223123003254223051533524', '23268755836632412189291409311287879196', 6);
    t('muldc', '21231788', 31);
    t('f965kejejhfkde62ca31gjk', '1894746813418880221855401179069', 21);
    t('16624bgb4j6b7i9', '2154952615997851169', 20);
    t('44778038225350466', '44778038225350466', 10);
    t('10is', '30377', 31);
    t('7m9tgv6mfbr3i5j', '9087238325403642874035', 32);
    t('17ffh3b3i2', '18276892443748', 29);
    t('1fioa', '2166650', 35);
    t('6j', '169', 25);
    t('1uj6q', '1835722', 31);
    t('4452315051414642631402123421521430165234323', '1460239514815687621335205309448665546', 7);
    t('80c6a65ec4a4e460891678c95ee0083e2aec16be1c2d09', '676377725653122531508231251848624820273960326886392184', 15);
    t('37gla290975a', '27131230954665414', 28);
    t('560542234405003554201260116626420636032150041612', '30796886684101041402274860246696545791006', 7);
    t('12kpl730it31', '39012501237101665', 32);
    t('1', '1', 22);
    t('51caee3d08a4d8c648526e2', '383313354354011387493852062', 15);
    t('120111001020020', '8228391', 3);
    t('b333sqsmq8m2q9el311hos', '116146323856091954730364462753048', 30);
    t('l', '21', 35);
    t('2a549e1fc1c63f027e4af4879d42e41d2c', '14404335589336084186051447276771435879724', 16);
    t('68615361864802033401765783131528708623121623624150567', '290764608685445070971126767459580690752903879643392', 9);
    t('324ll353j6ip451j07if0', '130593071665433916106882664211', 27);
    t('hf22669j3hbgj2cj2263j323207', '119153731039102138994504862665944807', 20);
    t('4863693778871642193596385609267335923840802058', '4863693778871642193596385609267335923840802058', 10);
    t('12', '5', 3);
    t('3022210002012101203131123121', '57016419145864921', 4);
    t('17wf', '52585', 35);
    t('glrr50o92hn5cmb8djdlrj5', '1154557453433021517715910663974537', 28);
    t('a6124c3897a09984bc448189378276c2c', '4635252028861401159639480965708427422', 13);
    t('3000523151311', '206247350985', 8);
    t('1bj4s6r9', '46813551465', 32);
    t('2iwa61pel', '3621674718177', 33);
    t('3a6ghnm5bac0ihln2fngbj3o541kehea', '73957115739832950099327264217773316424057860', 25);
    t('4bpcunf', '3888410460', 31);
    t('114224434001431', '8427640866', 5);
    t('19k3pmi2lu8b9s105c47ftfdf60laq82o', '5051715463332295990422738632378276342058129697092', 33);
    t('h9b70g8i6j4cqeqsblge0hmsn7idik1m1j', '96241136838849620955570471404790819811825290646849', 30);
    t('3646322361204aa63026', '219147633166881177589', 11);
    t('1ktnhn6cns1ud', '7479229664002588501', 36);
    t('7g2gfa6e25lof62haj9k9ih2h45a1', '10608546611840530886415289384421901237751', 25);
    t('188d375f5g640eed5die8f', '1032128844540501662690155999', 19);
    t('1g5fhj9cg0aa9j7kk3', '959847532524172458716128', 25);
    t('0', '0', 31);
    t('5rdfpt9vlkh7h086hqffidpavpaljea9rar', '8765347386525329765560210131623728090268059379756379', 32);
    t('39nij3dq0vn75y7nq', '16614188017737901319467156', 35);
    t('39c4e9074344eab09eb04b4a7d3e7', '3114724911743451144361477555664767', 15);
    t('c5aruh', '408252369', 32);
    t('405efc001ed2j67ekd4ch0h96jkfaji6i7hb8', '1597188434640792138193865275315517085324950380772', 21);
    t('rdgitjorf5omwcme', '2569695095565227618197066', 34);
    t('2841a2bfa959f226e', '120911102842184090589', 17);
    t('11681iidhhhf47j49b41ig28487c', '143077731089223004915621937671715352', 20);
    t('80a0bc97ab', '85467928206', 13);
    t('154319679383470735078149017579697301292976548', '154319679383470735078149017579697301292976548', 10);
    t('2l2l8c8djb4d940fbde6di4g47kfea2', '207494593328905984754688447749751909520475', 23);
    t('aaa72a6070701947707486871805579a247a25474980920', '8817500977665857282017186690319436997296375867085', 11);
    t('18636giec7g5cjj62g2aefai821j4f1g2e0bae1', '38906708030084175037896855329780703075886252892281', 20);
    t('lsb8tamndgn1wrnt16v5ba1etppehx5mn', '222046606335808194085660527561222477330915583202991', 34);
    t('14c54ca39de6b19610b1c1cc289a0b26e6e53', '2886541874571131971389047650134152171194728', 15);
    t('62184', '176037', 13);
    t('fch37gj2cehk4712', '1063412649849085727648', 21);
    t('13025014420320445053', '922056100333593', 6);
    t('ps5obl7uslhpb0rnn0m01b60c1fmsum63pg', '13175053317274004235425460616183284215407700766951276', 31);
    t('363701247162828065', '61927839099614975', 9);
    t('1465b8abc8413', '168027162035418', 15);
    t('k9bdgg8ejllf7', '262667689891801069', 22);
    t('123010320313322313012221200321321211020013130132032023220131021332303032', '9434743235284812342744700199923423780531406', 4);
    t('14212000224111011410232242220022111442141', '17200423635950346297631359046', 5);
    t('219003b4c2hhh8g1h31f9i9', '28192499777611999330166104608', 19);
    t('1000222100000000121201212112020001021202', '4198943923002496316', 3);
    t('ki1', '16185', 28);
    t('5lfjlpk8005pj215', '133603915990551547797011', 31);
    t('1a438995227803567077324354096', '280489817685276861500109179409', 11);
    t('a10ehgsh91b8r916op1d3p', '208937036874285900087095215604516', 31);
    t('6g3irid4iokp16', '104226752458483402536', 30);
    t('5sa078vcetk7l609is106', '7459835478504164366375430521862', 32);
    t('15a3161b39799106c3', '12501616036457500969', 13);
    t('g8p24', '21724780', 34);
    t('6f0cfb185fd93b13bfe1', '524422133844304697999329', 16);
    t('l1cffc501g6397ncj95', '306466239988961202225980855', 25);
    t('2dfhb52jnchd', '9260943760100799', 26);
    t('1ed471cbb25831d740fad016d1d3b092756e7', '42970555202513419911347877108629841551775463', 16);
    t('12010002112102113121211330123023300021102210310312012230202322331130300003031', '8653507377084930340696211927307966913814134989', 4);
    t('m8r5jh99kbea98ncemdddkj', '1535249309958690925403581682727379', 28);
    t('16dbe1e64nof2d6ghi71l55', '16848131424242679059584846180243', 26);
    t('9k97kh08be10if0bh2k2ecd9ac7cgdd712gfa1', '83361997971403184373688949366445710300829770044324', 21);
    t('imqtc', '22166475', 33);
    t('7f9d', '118988', 25);
    t('f974bd83', '4185177475', 16);
    t('1421112043421420020212223332442113204311210441024', '6714842848023828193177289953999514', 5);
    t('5118a5bda9c5261d038a', '112475404365415864605805', 15);
    t('fnxo4qnb3lw', '32422356295501310', 34);
    t('93e5657d9928e3fd12074c643179b35cg8243f1', '527318231363570231110630496178567104982477188975', 17);
    t('3i1fl4ahgleh2474j119ej4', '3436931963820318159686038917367', 23);
    t('26ihk7ci3f9l735jk930dabd49hdb714', '952831117130053200769266367664413387630926', 22);
    t('24nm8lmkc27ibal1njl3g84hgd', '70684225231749335253166543877275597', 24);
    t('7b86', '13782', 12);
    t('g3', '467', 29);
    t('67ett6tur7tgd6', '229969461645745766822', 32);
    t('2', '2', 7);
    t('42fo2fhmcnn8560o1e967aa6eo5ik21', '3560990677089860840955807820073740226856301', 25);
    t('50ge69b9c5065', '11169299770836272', 19);
    t('1emroim9bcbjb3jlpah1779kcmb2nbapmap', '24427253992307533768599615831526539311208539755089', 28);
    t('11110111101000011110000010001', '519322641', 2);
    t('11302241241113033441003123010033313434402233044414234331230110201301300', '11215699606213392429515209493735425261429502759575', 5);
    t('1gkdto3jds571f2gl47pdjuilk58', '66203436243049732688831467829307575554216', 32);
    t('7f6d06d941b729ee41ec06af76ce5284c2', '43360782010770292902695704345624074945730', 16);
    t('95e92k228c29a0f206e6h0f27mjic06gcjg1f', '97294998912929677139041351897383527563262247885142', 23);
    t('2226fcb4jb4fg9i7ccf9jb08dd3b61', '113056836222057401495768166170155708521', 20);
    t('113134637066412045754477071261275213637470', '12491631272411798853591088807340359480', 8);
    t('373b67560324387b3ba12902a68b0846', '10285568089390168608368989457924022', 12);
    t('3413502511', '145381489', 7);
    t('1322000', '7808', 4);
    t('49779304356a81a92899b9ab1232b41781a4', '283704343904838147306674158478269921804', 12);
    t('ic70g9dlj', '12077356215349', 30);
    t('351979a81875084020960', '2334517700246777830642', 11);
    t('1do8npjgkf75l92km9ed3i33hp', '921435866566322324120159754197201155', 27);
    t('12150522204302144012304143435', '8504919659789669048783', 6);
    t('ikmk', '797040', 35);
    t('2h2aa1cag5g0jgi5ehgfhdai410f37', '153347136980338866201795951450764966067', 20);
    t('6geppmmpa5f80epk2lnl2q4l165ibgf8jn', '1136083732855390230208808437587722537241518643644', 27);
    t('10100000110110110111011011110111110110111001000001001000100101000001110101001101000011111000100011011110110100111101111', '417609385350091179779636810113575407', 2);
    t('54632316365542122661224526250554320122025413431325200346', '172403155442202581292345539544844888140672862457', 7);
    t('100001010110111010111000000100010101101100010111', '146710581041943', 2);
    t('124214202121442431300322140210140142301222201200231014440034434232343414021', '8359229864672618132611974237068932716828001597248011', 5);
    t('126052261312470627317166600322300777652073650715', '3749430734838772876224746985432540515357133', 8);
    t('54kc632ht19qabr5k1d82fljbc8n', '39317638087117867171096975460673000998063', 30);
    t('4cg649834a4gfe0805d451', '1082429577946169111734611427', 18);
    t('2dbxaptbqkf9l1g3d3of1sqg472yfyu67g', '2143081075993914961942603741184451795448682536174486', 35);
    t('2156754868212718707616125201572327501277016723445525', '10122054780304258510261361631432189947078549013491', 9);
    t('a9h99e3ag2c083127d2442a9d53de87eg354754', '5293910916748687218888816990104934714816456671242', 18);
    t('5gdn1845mnh18dce', '5273404900500166539689', 25);
    t('b', '11', 30);
    t('10001111010011100001101011101100110111010100100', '78782810975908', 2);
    t('5r4li88rrsefseqtbmp65jliid6dbeh', '3235354455814832733783749566355407213876680098', 31);
    t('3d3a4927111cbb104723', '23592314824260135815291', 14);
    t('61ix6cz9s69ag9db1yumlsjxc3', '4883940813241885530407328690972629933955', 36);
    t('27bg82053fh3f68c2agg71he1bbg3ae8eha90d0h8', '394212306751663957838040335570427410296703664987266', 18);
    t('455045100512441541313240', '3929676740978264664', 6);
    t('880fh38b5h6aeje263bbd1deaak4ci', '1852428335715416475730972147092577202763', 21);
    t('7h', '192', 25);
    t('g4ilt52j5h1ds23hqolp', '187753427332679979656205394255', 30);
    t('4176a2ba095a941aa340504234063a03174b51880167b', '1260509150099956775877167423441090608940444985983', 12);
    t('2504826bh0b3deh44e63bg18', '169404321985280583053906034530', 18);
    t('629kcmkm5ik804p97p7foo46i7g64m8lnn', '301188094060622480080121017741192037465487025537', 26);
    t('175d4c5f', '13251037524', 27);
    t('5a2ca18578b968277b1a60b025949a7c20963048', '160781227675665332719698714323247199958314771', 13);
    t('10042463361643553220643436602540351641102252346210022043140655340', '1235358916306184009653528848855128388104787637282935370', 7);
    t('aoqdh7d8q05g', '191839424516082166', 30);
    t('11bg20d5g85hb21c9e98969cb', '1461738785476516432644631550663', 18);
    t('36g71jbo', '43649833020', 28);
    t('28926757219098079129718935', '28926757219098079129718935', 10);
    t('1aif04ggc10', '9677067550041', 19);
    t('5spe84tfqc6eest0f09oj6h85', '7842244574244691095548258935194731781', 32);
    t('2j5vlxc3dsnf3ybqzp2l2qefe7aj', '2652680566022137390794201796609346674664299', 36);
    t('44316700137250607462031357163634027001772445', '3096914367914270992782060024671299433765', 8);
    t('equ6neejg0bt4e', '363092673073628729020', 31);
    t('1i4h', '15297', 20);
    t('80280654445380371979110490326444540434133731', '80280654445380371979110490326444540434133731', 10);
    t('2635fee98dc2adc6d0bb9d3d2gg', '1016175556140463958965806888751984', 18);
    t('2433018197317196158128417653316133781757212131523', '2433018197317196158128417653316133781757212131523', 10);
    t('13arbcaflcuvjckqr9dlnsbpgfno', '245678666866906453273845830896602877589970', 34);
    t('0', '0', 26);
    t('1617b43cb4c1267ccb6c9a67', '61421603420165493428425457', 13);
    t('11id2614gl6f4ecbk37l', '34754434464457820201082091', 22);
    t('52b6d2313c32bd8b492b829f096003bab3ae2af0afb', '1934189728430433084118852318011260708451697369746171', 16);
    t('109589b891295cc8f907838a8ff1a1a8d085d9b5e4c', '387803793636734915816188347290438110144007551802956', 16);
    t('38h97959h6i9fh8895ja', '45316631296938641648982088', 21);
    t('145fal7gh9k16j2d0h7hb09m9ld32cmh0aa', '23568482424313596356642349423973072408497271926', 23);
    t('1nd23p72gq7slj6jcdsa0kgq', '16768688186146628617716846505518506', 30);
    t('349d0ee9ea0idcha1i67h4e64a2i92e90', '269343193465673541093888647165059275488773', 19);
    t('6854lhj1k80klcj54c787e69320k0ab2e', '57805283011680584908800630453906197594651766', 22);
    t('804', '1356', 13);
    t('5bc8ihgg0j26f98j2ab2g3j0', '4681781173320281184745635649580', 20);
    t('q3ot4m3j5ll2u6amf', '19002275427294001435167502', 31);
    t('2pqal87pf54lo7kaq02iocpokbbenqe2bp06', '370968670422455186597525315256886862435204203283442', 27);
    t('14121204025541551033435113555133500255041104211512', '229652526776877666192899652532215661412', 6);
    t('4cb80d', '63995278', 27);
    t('3g8ff677jg9g4384ie9chfci6', '64122028661030601402847337245166', 20);
    t('1to1rqarpco61sobaq03gj7mpkq', '12335682298221035964378060459101864739750', 34);
    t('4b959fg0ok', '46593656068532', 28);
    t('265gb83e9g60e9cf167852e334aff1f01d6ce379', '2306333583911925762109580082245431983946279388064', 17);
    t('101012120121102120022020112222011001221121222021211202012022201', '432669425053505639748394359655', 3);
    t('7jkpqkav978wv24g5qgube4oe49vprj12l', '980570245844506132383809249275091353381128060854310', 33);
    t('e03jkjfc1dh51njoahllfld86q65d', '1239960032059488024964338692108578276765671', 29);
    t('m783400e4ffe1aa6c6en4ckh', '1239584291259839658707406684316913', 24);
    t('fnhd7ke0gao', '1520924761338399', 25);
    t('38qgue2niuk4ribm8f', '74092686835055561528594725', 31);
    t('ne6b2l9736m6j0kia2', '26699330820578748156911374', 26);
    t('196i14lbk', '109958823703', 23);
    t('10001110110110100000011010101', '299581653', 2);
    t('4059kejh4oa8rh7qmh6a1o0n5lq80hcs250b9', '177450033973248979305599574069360735269525214008062910', 29);
    t('pj3g0e84lqw4aiwt42to', '1818225340602370091437090095360', 33);
    t('a3m7be8r9553ugsinn40phdcp109v7edh', '14783759765079103513279709123504193591994024704433', 32);
    t('1756e5g7692c9h', '111684756948660997', 20);
    t('1310214023220313413114434030010043031322341230112322140434', '11406035175438373014369495726669985740119', 5);
    t('417c1deb522fc30e36id2be1826b', '136881678478819836067507779602024299', 19);
    t('92252179669209632312214876221319317863641946757', '92252179669209632312214876221319317863641946757', 10);
    t('46372312a98707a02376aa8a10', '495759640298771450157982756', 11);
    t('30435540243430140', '102782589253365', 7);
    t('6fhdafecfi5707b46319a8i6dc04', '229779267604296881101047008482286527', 19);
    t('bbdjckf7k409d6l12d0gg', '8132684440039836441113393896', 22);
    t('7aa1ffmd443dobagk7cj5johagf9', '411676472259993059055019141270748994759', 25);
    t('8f4k91t4tjnt0fcn9du7k43s8vv', '25625379512718683322830604232552206610120', 33);
    t('93b7504c8b9c69340', '6187855604057469017', 13);
    t('1sb35x3s0k1q396aiw08vsmrbplhfn8upj', '633864643448678437738472399825285684192119995266605', 34);
    t('agua7ucjsg0iih', '578621718768720599495', 33);
    t('1110001011001100001001100110001010000110', '974087676550', 2);
    t('143144514240325455532435105401025403335453100232325214143111550101431', '144340707728293600047951401185589484227036000826020443', 6);
    t('233044', '8524', 5);
    t('582552wok', '11778038097685', 35);
    t('149f9d98ffca8gb3a9e4141', '1491232566783461596326244889', 17);
    t('22t1321rdu668p4ic3ib9q303b8j8keqfm', '34360852610107045028311793108369775693929421677085', 31);
    t('462622265601022655402232133025653611105', '638815298652167365671534920494773', 7);
    t('4230756a54234667163044394627859a924', '1074822316475608305169982087744148310', 11);
    t('f8g3c', '2015532', 19);
    t('f0i2ihgab04g1jda8fc4bjf75jm8i7ic81', '13004707395130797801783447008659194898218637369', 23);
    t('179253963a36bcb3055c8b7', '5115853635094224906866873', 13);
    t('64ijj66738659b1j31hc0820049h64g291k7egd', '6396071996445462346194349108953750662378937713977069', 22);
    t('171215002356221063407', '2184703385532655367', 8);
    t('12b92d0b3fb36a8340f2ba7', '4736076939720343041873077671', 18);
    t('18533b10492434055a895882a6bb2620a0124211a9879716', '897043158909364946043573806406449154734736512608194', 12);
    t('11100011001001011111010000101001001011001001010110110101001110000000111010110100001000011100010011010011100011000010000101101001110100011101110011110111', '5065575398273300616873996741388922355920788727', 2);
    t('2766585533096734963797354878145135898641', '2766585533096734963797354878145135898641', 10);
    t('23721121', '5218897', 8);
    t('ad9a3ee51ae483bc3c92ee9719ed', '3521077463500554185208755094231533', 16);
    t('538225767260919961504023', '538225767260919961504023', 10);
    t('8bjfla5x1ajj4pcc3pvq076xjshfu', '63473818980036415589889054621162799274007056', 34);
    t('1de1640281a9c904e09eb8', '9623171535473259745289948', 15);
    t('5b6i14i40f3j53cd20b8ga1ba', '911209787080683607634683777689488', 22);
    t('d6g6a01', '455214169', 18);
    t('2b72r5rbeigo1e8wa4ky86u1yvrrqxnze', '146380404990650204600521560022975352362017972817322', 36);
    t('1', '1', 6);
    t('2c3jan9p54e7oq7', '268026783261347839750', 27);
    t('26', '20', 7);
    t('111', '13', 3);
    t('13220232312', '2001846', 4);
    t('ggc1dvks0wznulslk6qtto', '7918026888898711931888200605892476', 36);
    t('jc9gne01itlg52i5vp6rgr848', '220966959400300968753461444338213486948', 35);
    t('b3k2b5pmj4g0g', '1063566102909702304', 26);
    t('3b7h43c4g34ig6h033g50e50ib', '12782782886402816341557428904412335', 22);
    t('14734353322620206602545731', '61062963683852360010713', 8);
    t('2b0binb0g286hblbh56dd9m62gkc97m7', '15043189108277243144346702606154391095130071', 24);
    t('403141', '31813', 6);
    t('7flc72ih3ffbhg9mk10hb', '30802551855160402027073927075', 24);
    t('230451055847842670116857431341321500872417704342', '1654015781734635936691762853372312699223635807', 9);
    t('fg5f0', '1333123', 17);
    t('3133320121122020231323', '15384999136123', 4);
    t('b732he8i04f29k1c8', '16223282627992833931091', 21);
    t('4766a43c95b203a143a5bc5a521a00a1517294545b8c79', '613814573577095538322406054851347528901593201139075', 13);
    t('475312075530063365616', '5717675808740207502', 8);
    t('16162192b5325a09229b66154994a58c0191b83346c', '89746042615495845467561696653563459924799018890', 13);
    t('bmk6fjkc882gl', '262863262963325798', 23);
    t('83k', '4321', 23);
    t('291912ga026f903h805113e1008b7', '351864600431743706976833767888152589', 18);
    t('5ij68fj1ci24781hf3bc6bc2g2jdh6b3j20fe', '2348628424621736684950599296511281097502939955369', 21);
    t('4m', '138', 29);
    t('9iomgxldnucfvk5vc94jrxkxqhg0q86lug', '3302490167238267842315194141274974765989676875973840', 34);
    t('102213220130020023311220303121213121312110302212123210023333', '386706650024275360677522460004729599', 4);
    t('6c3c7c0c0273106b49', '60090702381311935043', 13);
    t('58112gemkb46mjmnlaikgci3', '296486678920377209704264064810163', 24);
    t('3wt', '4352', 33);
    t('8epdqfehsbh2dcc17afk440pinmgkc', '21858855191422671471340155581640803606008076', 29);
    t('49c791b', '23008529', 13);
    t('1dhli5mlhe3beji4i863lc1m3c', '50343339607330193689400174698342356', 24);
    t('123031003202300213121210210010232313231132223021232113211032101221331', '148112609815368618622505037403177396804221', 4);
    t('18ce23d9jf21f2029626', '18676222308756564436417161', 21);
    t('597065210033583', '597065210033583', 10);
    t('3k26bk0ke1b07p', '9360289351819814615', 26);
    t('2955447a895348242a10734120381179706848798a081a24a', '277814985699113393836174322641904828474105999637700', 11);
    t('5', '5', 25);
    t('1d21e3d1302b26h', '647940567601800701', 18);
    t('v780', '1023232', 32);
    t('3hjf70me46ace3', '5530384201457585978', 25);
    t('mdm50i95kffa', '34359902758185778', 24);
    t('27594fe4363354706hb690h55aa751e35bh9gd', '491043964499596096790903212672593094950152072892', 19);
    t('4a89803', '35829979', 14);
    t('267015546c1d214c872ec08d7370e71', '466173270071093767519019729134792006', 15);
    t('360077158271360562586726301234510052565274063276314', '1890330141502524623802729708237946328855224484518', 9);
    t('33qw8b27i1jw96v2ng8eqobrtevma', '10278823232880451587462834430209746065248241', 33);
    t('2ffj4kk34984e1im4l961976g7mc1lfmjkf309', '3100701785176197033715745123477117444206063832592585', 24);
    t('1022341304133421140443420110010243111004132014011020330414342141', '119499096791628035571843616922889895197027796', 5);
    t('p2cmh2pk8i0iaj3e1kck', '78607604800260622873133016676', 28);
    t('19ac1eg52gah2ajc34he552f07jg', '25687840615874920182000176600011964824', 24);
    t('11', '33', 32);
    t('4c51d2353763cd99e5gb9996ecb', '463382824850947753162321910886735', 17);
    t('b4lb34kh23acelhhb0a9', '359969560591369257338660893', 22);
    t('29533b2', '85574108', 18);
    t('210230042006603033250136610531101152631005355211234231305', '454901252792917385468584025058887603070565139533', 7);
    t('1fbfd085agi2461h64f1095j86cce1', '95533836923505794150091786478042661081', 20);
    t('if7cntugmjrbee1eb8ckb3cumn3cov', '824056020452353062283203568047736986646197023', 32);
    t('d1c', '4242', 18);
    t('pe89dn', '728905472', 31);
    t('47ejfjhla3ndcebdjdcg', '723161521468601797654769776', 24);
    t('4975a52e86dihh5g2a3g5885', '1158656071841032338859418439765', 19);
    t('b2a', '2515', 15);
    t('18802049166029703a5145880531512464114a2', '6708572829867641951682044334790673523856', 11);
    t('1303', '327', 6);
    t('2b9en9mdh0ma6l3gb2mk6a7', '5730992327390802294169442362999', 24);
    t('a4om7q5', '9012380858', 31);
    t('32315145242005405042351015402414403452431515', '9890393161550519699750282408306759', 6);
    t('23d8', '7628', 15);
    t('3x65bk', '180647358', 34);
    t('11013133142310444', '185143322624', 5);
    t('11mfikagfi4937b232g8mfif81d1', '19931061357332966183661805527444530041', 24);
    t('1111111000001101100100011000', '266393880', 2);
    t('4aghegjc5deepchjn4n5k0d118le6nd981ak', '147378856393139936930504545227123321111306845601900', 26);
    t('a053581765919556968948712586810a9015', '28225998746921616615219371069369367892', 11);
    t('f20j9hkhjha1959706m391', '595569091584864335710531454901', 23);
    t('23ihb64he5a0f5ii443cg280e5hahf18ib9', '377475347206489360974272030507154369136231429', 20);
    t('1134221502523554343504155430344022131010005022402143505540202144', '13410812065491845847587964012298459020282685390768', 6);
    t('e3doam26jjll', '33718022971403046', 25);
    t('a1opuepaio9sq6lj79uv7jdsm3mu70', '448489371933662834507614222400068450749479136', 32);
    t('7dia0h6ci727h3jd5l2ih8g90jg78i9gle2h3c92', '172565724572140439608372962298001362724338507747933200', 22);
    t('185578g007dg20e80549a07g6ac256f58gcg81', '5006150941846375710425629090586415981041329547', 17);
    t('a57aa50714a5a58241591229577a12719502409006', '52377118471664082839971342562274998095676747', 11);
    t('32b2cgmbb66g07h0gam0j4', '1602756351859232543197284945538', 26);
    t('161a2b46106774', '161867200944328', 12);
    t('4hwkgw', '271937696', 36);
    t('102313011003221000033031221130002002113001313220002132132330232300021', '102686925972400425528527084594359115639817', 4);
    t('3sk4730l9qqkomev', '147136098020632457664991', 32);
    t('but6h3hj9q56eg9srihnw9hdon941rp3ots', '50854478902964517143833982141512258828988090776984054', 33);
    t('5942a269472a40200841698110c391b0b01240b23c95', '4536812636437232093232481982122462495851953165886', 13);
    t('b490gmm', '1656667712', 23);
    t('31146334332061140050113651455520142356166650613065', '816409488023628465545576155395605191426552', 7);
    t('2131301223123222330', '169410935484', 4);
    t('9co4b4k5p151', '657937061645466823', 34);
    t('h0fd72f5254f1g26c3c744h4b3f314hg490', '81461749134903178373218607627253657134879874', 18);
    t('1002233331133111021130313321223322032032232030203011000132202222132020131311130112311031', '24973910663440836930300964560676670988365943043878221', 4);
    t('2ifd83008', '75242904008', 20);
    t('7884218894543281858859629374135875813832', '7884218894543281858859629374135875813832', 10);
    t('13103023041232143', '251002289673', 5);
    t('304e49gd80298d67bfg69g02dac696bc7a8gead681', '847119008557111727693264083647354550664309377534571', 17);
    t('77440275263665614314052136204775', '78687457933212079867651754493', 8);
    t('12334424101331102324103', '3699927180120528', 5);
    t('a4g05c', '14611359', 17);
    t('5261257577514510167240362153507501754265746731563', '119228114395905189012428590020540134015611763', 8);
    t('3l4dg03eaij22al6le6d551', '1353453954185679560322791661947', 22);
    t('2bqfxxthm4', '142468042285068', 34);
    t('fiap77iheooadg8q169p6n', '38461005482942559471400836911887', 28);
    t('8a8025017961715439905021215027084a5519a3737a', '5406771714928108622296605629432833570349691892', 11);
    t('126lhlbc3j7mbbjcf38', '3568853907090242324887631', 23);
    t('7aiii2', '24151562', 20);
    t('1i7gem1uaffiis0u7et3jb', '724613157606382056196630988579111', 36);
    t('503260b17454901', '6448202932655377', 12);
    t('4850626593a5713082aa56206712900743aa7201817', '261169229231878869752098014758313048888037312', 11);
    t('3d62zhhw', '263758474580', 36);
    t('6hz40', '10916352', 36);
    t('a134e378efg25b5b709b48f25', '3418312060655617619528647783454', 17);
    t('15otpknf32t2botcfgcigfqu6gnkd32', '653730401352621635529986827040115039458290175', 31);
    t('4bg6gf9', '217552973', 19);
    t('55kd1i5i', '13144826416', 22);
    t('i4upwht7sz8semwr0m8xds89ckgj0nvcc', '1148664345372000562399006295243039757410796703394412', 36);
    t('123233222120332213211233223210103022130311300113203323200030222020321211321', '618728024794653152611181264645104903381031289', 4);
    t('222', '26', 3);
    t('17a', '304', 14);
    t('bekonj1ck7ko0m', '118074773170177241397', 29);
    t('1wbdij09m30', '3032795011029696', 33);
    t('16024a6a8524a08ab4d', '610190839032691602657', 14);
    t('792hf8bc24k6297dek1g2jfjgddc6h', '1643015926452657057435885816967287278987', 21);
    t('40120', '2535', 5);
    t('1323334411403144204202403234301133303410340324332211031', '94927992994481212046822848686698710141', 5);
    t('2a1d28a129791828054c5a9bd6b79bd9a27c8793b3', '266985353736826850080436241041352235363843789393', 14);
    t('1200022202111120001122020012101100012202122120221001021201100', '71161283691673020779124574143', 3);
    t('5977', '15589', 14);
    t('104340303411210044440320430122', '221766877905265014412', 5);
    t('11013120201312031120211130123201013011333313203123220110', '1660030361577179570818698261150228', 4);
    t('301j59773', '235204794824', 23);
    t('10110101100100101010001010111001000000011100000110110001011100011111111100000110001001010101111111010011000011100011010001110110011101101100101111101101111110', '259149353365748547676531551540644422107339619198', 2);
    t('205111503a5610828263990683193', '294498462378684194194060531477', 11);
    t('1101011110100010001011001011000010000011001011110000111100001100101100100010001111101111001110100011011000010000', '4373566857843294445861437353637392', 2);
    t('336803b72924db88985ac563199312a', '619172222915569013937138339844159765', 15);
    t('32405', '406130', 19);
    t('80j5ddg1b1dl14kjka5c6', '5671500746690810780935275986', 22);
    t('7a1881a31b06bd6451ad1b6d30a1c894c72dcbb2b1', '756847193473448614435521815498749214334384581243', 14);
    t('48mshqkulqlpne44ud', '461366817247928145199340217', 34);
    t('60779a50d1c0ddh0e446a96gee68c29', '274145136144895069895965328926167326013', 18);
    t('58', '178', 34);
    t('385g8d44f0eh76c43af5c680', '257444068870885858169187329208', 18);
    t('814495845206832393929422614995075089273212205592362', '814495845206832393929422614995075089273212205592362', 10);
    t('f3f77b3b2e9b8c8ac86ff', '18433604493853855199299327', 16);
    t('bkrtagjfbg1pno3idbmuo0nt7n7702ga2', '6177359692973648095722111400642059003569459901224', 31);
    t('1dfcsm42odexo0ktieslb4qafa35f8yy30', '3130691163505477254704987194463689878868046927467788', 36);
    t('145203764627604366316134', '933938082134087015516', 8);
    t('19h912757478f8crkkhr4og99ni73dn19aca', '600864466904483449441439149901096985867299402717370', 28);
    t('39ll9imkk0jkj0flmanno7', '771926574252593113042455452482', 25);
    t('228167317827360633087566306336123870011383433267784530', '872924535016160646996267471070001556922344992057865', 9);
    t('13340', '1095', 5);
    t('pwd8412ejz4a81edyrszibtkdcl3i', '976685155536350163623078908506832125214491342', 36);
    t('3re4fusjbcu8j5lv1l82', '272329957684893601942297513205', 33);
    t('chg0', '103120', 20);
    t('4odi3m7234bk701n297fmcejq584gk5b1oh6', '614617226825809656528595998076194516792828845237451', 27);
    t('111594024100d66', '11985349514603310', 14);
    t('76560070281357891106470860382421443497991878779506051', '76560070281357891106470860382421443497991878779506051', 10);
    t('72b8ekje0dj2l7c3af0hjgjm01bk', '41536239334041308155633538070798114142', 23);
    t('6bckt4ppt4heg95ar4di9d8lt3l', '1621907836199076168122557852891843973211', 30);
    t('6t2mq5jxqophfjfkv2', '1212339255267290424899164962', 35);
    t('e7pmg05bciepi1dofi43mbkodb', '3387641514834198687347692335687382541', 26);
    t('27a774bb8504617833802249056310167810008b70191', '809835557745463941303042632876919088150536027133', 12);
    t('100011101001110010110011110100110011010000101000100111010100101001000111110100101011010101000001111110100000100110111001001001101010011010000101001000111000110111010', '26053480661633533853821712739093750512044053131706', 2);
    t('78267h30e5ede4a049072cc', '30778804593492484652016321540', 18);
    t('qjdkoo3766l1dqpgn21ne5p9k91kp8c21cjf6', '90359581173566956884322886148109729184492339838200142', 27);
    t('fqdde1sn729mi91m6eemruutf3pr', '689302333458744601010081226005660309098299', 32);
    t('421c07ac3832988bb3a09602', '173915305366970601824607453', 13);
    t('1110010101111000001010010001101011101010001111011001101000000111111111010000000001011000011001101111010101100001101011001100011100010011010100111000100011100110001111110010', '5365917928263298552573558618072276593881915061068786', 2);
    t('242', '72', 5);
    t('538ke8j2m83cfi', '7650430109348882893', 25);
    t('lmu0mac6l44w0r9', '39403923966776686881276', 33);
    t('fh2e6opj1dni5kf749', '17753033290059290065644837', 26);
    t('1', '1', 18);
    t('26d3525', '40711461', 16);
    t('300440712774126174401451236156067007573370014604', '8387356043080138295526316927827140067465604', 8);
    t('5t4hfub0osbb99ir50', '228658754079328656695061664', 32);
    t('71ic9b6hh204d7i11', '2049179021938589824134', 19);
    t('5hddbe15gg556hi26i46d93d2af86h3g426cij', '8087180350965242088908465549595651157432077173179', 20);
    t('1300433434104342031413234234331430214242234142011003120034442112001442203422', '42553163117436041210820684828722894387321388431600487', 5);
    t('38b954141f26f2a4afe6f7a9b5e34286428e3', '79061632155013935902994702509288944969197795', 16);
    t('1332570322632', '98077615514', 8);
    t('d35odi2fdjojk7e98gfe6k35b8mf', '2100644003633488135175085159618349120211', 26);
    t('3716217572065650441626246', '18430886692014464117926', 8);
    t('29490', '41844', 11);
    t('38240bedb839f71c66a', '16569841585813541996138', 16);
    t('2bbq82tjjlboq6ut42kgo3f9lj9knij2', '40405579441757956010771252427816760128528380148', 31);
    t('781c04b2456348', '14676917899295993', 15);
    t('53dc391hc7h33dbei', '1498649871829166765405', 19);
    t('1g5h3sftq04hfnphf8f8jj1', '982528894566891028570672354176986', 31);
    t('5a5', '845', 12);
    t('178172ce93h8b664', '92075388339711112816', 21);
    t('9sr4id02', '340213183490', 32);
    t('2b8', '489', 13);
    t('2300300330330001003112022332211030330300132321001003030013210', '3671262870120598176271167818539254244', 4);
    t('4pqt2k', '161313876', 32);
    t('20jhah3e3594ic7blj5783a220edj9k2', '841249012824513777684222245238901038443798', 22);
    t('11131403031142402344414241010142321033102334', '1440321372656516822979172159719', 5);
    t('200310102202323332203003033113', '591179016791929815', 4);
    t('716521140', '121283168', 8);
    t('111010120001120220202202221201010201101101011000121121102022111210100002', '10956952452694016827581915819578357', 3);
    t('111202131303133301210221032032111320031321032312301110231', '6989651474722512359041597886371117', 4);
    t('0', '0', 2);
    t('1h5ah9abadha39h8bgc5eb78229dd6', '4960759047638296451407652673971888460', 18);
    t('2012012212100221', '31470469', 3);
    t('85g254c289ab3bg8a4273', '33936134064348767438727660', 17);
    t('agh25kbib97hb0g', '1161594685951625568670', 27);
    t('12glh92lelm40816c', '6862332277154598602249', 23);
    t('248ppji8q3gceono93bg', '24909353208658444795454586046', 30);
    t('3qpamh8c03327tq2nudhccfpc1j', '2304427318605821370197739524368941219074', 31);
    t('elimj5c2tlc2jf15sjs3ehinc1jnfp1s', '90926703087141442632989969922650276777949757558', 30);
    t('101101010011001101010001010001010000110000011111', '199232011439135', 2);
    t('411222201420220221121003', '50782833370098253', 5);
    t('2039114347726530b4b0aa421220', '278325835859819389698795043320', 12);
    t('41004131223131231131142234133411213241244344310323342404242112441330432', '35634094054178335947847642423396152869554996042617', 5);
    t('100101010000010110110111111000101111000110000101010010001001101001101000', '2748976914400602004072', 2);
    t('22230433215142110', '6780166900026', 6);
    t('8mk1at9o9r804dudopt3k8wj', '732139600050794539356052387629430435', 33);
    t('hf90c267ed759h', '371923695419188175', 18);
    t('h3dnd0i7ic0', '2419032644884024', 26);
    t('2fd', '931', 18);
    t('21k67f3ff8mdg70mc6lhkl0di4hmkl', '6434984278071506771897566744856884038406', 23);
    t('19p1httrcm79oj9rgtbcdiraloho', '1329656272867458937798290256287785742722364', 36);
    t('3212131401031111334432423124321430000330412430201342140322331330011012330404', '91550385572652543205746270772410011134482321789183229', 5);
    t('352m60pl8anklqx', '19288129733595604666905', 36);
    t('bh0b4i51g', '202042896689', 19);
    t('1119744c426471170b60025b47566cb98dd11657', '540029478576476753822278962275953374371031885', 14);
    t('334737324b022c16a12776067cb0e59', '617423186874142070437062374479797609', 15);
    t('3ar', '3624', 33);
    t('7518019e9f1b02abec44d0b94eb31e2641e59f76b', '10695796466552661793442196497637299434594286303083', 16);
    t('180pk6d6kaik7bj', '234289341354887508919', 28);
    t('lf41em56', '290649634162', 28);
    t('5edqqle17ombhpf05hego2l175f8', '2455572852658581967926750753107310477266', 27);
    t('3m63gj51o8k4iioo2n', '4371172906141889814528715', 26);
    t('3739a84a4486191653b6344395a88b34a', '123393978207073455312508389622518826', 12);
    t('5a92108b809285441b85b256002730b2', '16797817024717861380905046511444934', 12);
    t('hnge9ejgn3hocbc3fi2lgf3f3gdk1lhjk', '363506737365826966052915737077950321295612551160', 28);
    t('1h0of7r2eq988g6ggrrsreirkb187r7csprjb', '235284507762506989471049564238403899403844842607979881', 30);
    t('20253055005124511321504332435202215042331022', '6009050050525852848744537187631030', 6);
    t('255h2ie39a2fb1500f973kbeaejac1a120f1a', '896034685417542420338893072410925395756357640783', 21);
    t('k242j2c4nnangfl848h26bgnmffkekijlb', '70788268624971959173282983665178195588772935875', 24);
    t('2435301544115404035300020040304413033133225434345', '62316354829793498075260144431239712473', 6);
    t('2g2i', '62310', 29);
    t('4102', '902', 6);
    t('otj47dcmaon7keme2w12ld6s5v2eqpto7', '638854684449416351631309299374737671670073661571372', 35);
    t('heac707ba3e5de', '1452158473696594274', 20);
    t('cmah1lheg94', '1815679606647118', 26);
    t('3', '3', 15);
    t('36dg4c1fce3g01f', '5463291949613408035', 20);
    t('2gp6i28usr3ica94iw3798uwa', '14194117306000686702866639330287897138', 34);
    t('6ed', '1573', 15);
    t('5i88i38d7ja58gc', '67220527363641484650', 23);
    t('jc446gjo4ajf14bbcp7kpac9cnk44ggafg', '3341389528445632882430361472253103750301895578375', 27);
    t('5na9jcrd', '196840371053', 32);
    t('4snet0', '220080266', 34);
    t('3411042340040', '939808770', 5);
    t('1in4vg5uunmtttvicldm5195c3ape4t', '5628692971846091847621849643956512531468869964', 33);
    t('31ne0m81elc2ni378f12m78', '7137831462888106233070797205040', 24);
    t('1k33gi01c68jg90b5g2kh0f6', '5049053173243219517979291311964', 21);
    t('rcrrrmn64una', '987268935367949034', 32);
    t('1b', '24', 13);
    t('1100010100011100010100101000101110001101001001010111100010', '221926845064713698', 2);
    t('1r7pkwftlcre0ii', '4967939422698252306902', 34);
    t('61226277150121532713772501031623101', '31243593013026976686003389408833', 8);
    t('1h5hgf08i21c3bchb5hjc5cdg2dcf8g7269b08', '15235227425880825633838957695898165136395002484154', 21);
    t('3b9e252789', '436531204678', 17);
    t('k61l82d4naef4', '1206574722460321629', 25);
    t('6hcchjif0g9j237k08462f987', '369998501355671383411474631968651', 21);
    t('12d12b00ic0', '6998243180208', 19);
    t('564041k3kggc5cb91lkigf8a0b882', '708046707322052814836378156934476046910', 23);
    t('5918789824383b512946ab03655a5721426090a258275811', '3034504785879651863453500736958310166080471464555853', 12);
    t('4a28dda30874514cd66531', '1047116675864538401747740219', 18);
    t('340402203510613364531', '285913804988245316', 7);
    t('jglhl745', '49319314049', 22);
    t('75i9cih98am7fl2gg99gba7n776ifk868b6dh', '352662788590054230998768616200965729446372971897033', 24);
    t('2g575jj883c596gag3b753iek59d60fh91j0jhkk', '10225004397589075860213367077653867616378434533721837', 21);
    t('egf56c999khgk', '108840444143808488', 21);
    t('3fa622c7ed221182e769dd30636092d163', '21658621556399738720046392793916662534499', 16);
    t('107380259', '107380259', 10);
    t('a00k9ff6e863c4daegfkd99ac5616hg5kg606a4k', '226239231994177458369309950416257385004898669100608548', 22);
    t('727134513004332506', '16578205872928070', 8);
    t('8a5cb867b3273', '205132338279105', 13);
    t('q97mhi3ort3ke5dsl3v', '96850671091881098816986196009', 34);
    t('4403412514545', '63419722728', 7);
    t('36cb3cc08416821757', '30602499066114507240', 13);
    t('7d54g8', '89201328', 26);
    t('3oojso3g3392dkbbt84xvbxc0l', '2979009146895467259349827974056406782485', 36);
    t('36fbg77a0ggb0ci9hd', '18409004251720729857403', 19);
    t('2k4l', '93807', 33);
    t('1qlhdvxiwgm6cr7nsem3jalucm', '345303493069524735491170228117585524750', 34);
    t('2434042100312310041041102032432412344014', '5372241755138001316636449884', 5);
    t('hmo15lnok4fod15g', '16687884040803134578891', 25);
    t('gfiid29109b3j8jc8cc3j1eahfdd7732cic8ed', '140059672476506082851982887877581752595147028007486', 21);
    t('3c84189bk07j261he9290cjd87i7', '6268314837095821879011320392648968063', 22);
    t('1lh0b4c2e9i6kckf92e29jn6ac47dgc2878d3985', '1282419934581887287299945684653043019039515750548801285', 24);
    t('fe3', '13923', 30);
    t('1319468a4667519180593038183130808286630930', '6412675244028174355879293291613657100674876', 11);
    t('4a3', '3189', 27);
    t('402majam846193eo9ac96o6a5hg', '8892077274986800146995489100822816066', 25);
    t('10d8b3c572250152618107b2259d5608a14a3a45b2ad', '20544745080946531559142719199803291524781420432601', 14);
    t('go0sck6gotd462c2bnfafcmqtvlrcbb', '23907635617759730937515657563927387778907484523', 32);
    t('111010011101110111001010101110100000001011000', '32142349779032', 2);
    t('5d97', '59737', 22);
    t('9g9', '4314', 21);
    t('fcq1qb34ndqo3900m556lhaehdn1o1', '5004100408428511376913892098705761953181767', 27);
    t('43g65e7a8f38', '489624285606273', 19);
    t('32113334244320312400104443', '1029375448159769373', 5);
    t('310221411043332421244032101422342140', '9370827599951145560355920', 5);
    t('69hhp89in0h5jie', '695638255018079621219', 27);
    t('fc7k6b4efua79nh18eohd', '205046231015999268860758172036977', 36);
    t('684161846238401', '158778455527054', 9);
    t('180abggf7782389698', '7796408187235478919696', 19);
    t('rff01k5fpsgoa88ewo11igh9jt5dfcfs9a', '3546436014833336229063455228043873170002123415057080', 33);
    t('100110011010220120210111121202200110', '52533845531034879', 3);
    t('1hkah8eqdo36uid', '1188063720587983164130', 31);
    t('789b534735', '518002001717', 16);
    t('502233334544512511610366503153406301634260122', '77168872698190232426753092866458114298', 7);
    t('1hn', '1283', 28);
    t('1eki1s4cghp61aqj9ck5bbcqjkemr5', '3870223673450934834503736739043981885517199', 29);
    t('cao', '10406', 29);
    t('lcr', '20580', 31);
    t('44e50119b604029dbb42911105f0', '7145735262791158676522926629699807', 17);
    t('55a72a8845606a6101935b762956212030697197882721b8', '2891443867392734091987458182380459443067274109345180', 12);
    t('49', '49', 10);
    t('ectrh11nho2471jvmvx4q9trfk9hs81h4', '369444070950732839712792142856641597182627892515449', 35);
    t('rqqeq6mqpoqpasrrcuq6jt9fjt4rkq', '494957438299081733206543531712764649663268456', 31);
    t('1d35hh64e49c4h3g9954d522a58jcfg308ea93bb4g', '364650097839632030692202970098568691121387743389372496', 20);
    t('130322112032010332300220231130333210003101302000113110123311213110220133010231', '41264121145398472876534214952762106425299300653', 4);
    t('3a53c2755b1260d232bb8d62729689f9aeb62e35f60e', '21822791108317911324343501911275861646156768606549518', 16);
    t('825673232713090477952', '825673232713090477952', 10);
    t('i46jcdno2a01mk98004', '2031208929970583000541849348', 28);
    t('1205434053320310320', '138125884535976', 6);
    t('hge85la4bh0khqbbabe6igki', '14695370412094062868205499164831367', 27);
    t('133kt1cswtuwmpd5qhk24k55sa8p04it', '326448646650356344354610046025058475184987458209', 34);
    t('3236e2efal6l7h1d115264h1', '23268339383522455310975833089111', 22);
    t('804660753567512670080084580036', '37956769767951851794665023592', 9);
    t('1015752175345655', '36143524858797', 8);
    t('916aa0c1752b7ae8194', '127717282530992844422639', 17);
    t('1675967', '1675967', 10);
    t('b913', '157275', 24);
    t('10011414', '78984', 5);
    t('337bd9e8a2153571582283dc2eb03e', '41349713484510984486738119285124059', 15);
    t('121120022200112011010', '6418577568', 3);
    t('bmy944flvntaqlvlqrswu10d3uk2khti', '8564046232202665530251180136943811879121979161858', 35);
    t('c167372796bc509cd1b8363b6082', '106760449584399644261680763206674', 14);
    t('3lqb8a2m8isg56fpgrwe1u7e02wusdv', '13151181110013852579067705641818021287165798549', 33);
    t('117', '117', 10);
    t('3941c283fg135ad1273fg109bb540a607', '8390935227868619653499488684200707583861', 17);
    t('498400a895933a9307', '2470275750549750381', 11);
    t('75fhhmgajaa5nmkc4j23dmi3c5nlkhe4a53', '611871605189747040922198802979378146489796218619', 24);
    t('2e2ljgje2i4oe', '1312494953013310334', 30);
    t('2308d687g0cf657c5dc77fdha9145334cf', '575552748356204066006280555783397107050655', 18);
    t('15366300702132404747410165', '63663188402072700457077', 8);
    t('1211021110112110002201210020210210010022011102002022112112211110111110001212222211120211121000210010012011002201', '166623003788951092841186083176122549763292977336948088', 3);
    t('h6272h1dfd84f0e1hdh63bb891f297e49e40c60', '8698065705772214605732543063301832216085264908252', 18);
    t('2du59wacc1pv', '169045559446116821', 34);
    t('1104144', '19299', 5);
    t('7b7b929ib38ha0h3efd37823e2e0ff60i', '632309191486570820267877405266584767267970', 19);
    t('2607400245312045520037132356700', '3422470520825634689242488256', 8);
    t('anu0', '420648', 34);
    t('7zs9sznolivv0b261pz', '82453896793285080027030707255', 36);
    t('v0k7bjb64u08q0rj', '1171893246067812904797043', 32);
    t('164703aaab2ab8687405bc5c61aca10607055a713aac87b', '2594865872979998742750325942751781337383906323934209', 13);
    t('6j7076hgc4cb4171fiifj117c7a5d9e0f', '14163341774568096462942504854512024189875789', 21);
    t('335066305135104410516', '281945542299465302', 7);
    t('0', '0', 36);
    t('13996ae52a6d601db495cdecceab53b9549ac2e1a', '137420483326676517320231475107274395010419164300', 15);
    t('1011000111100001011000110110010011101101', '763990598893', 2);
    t('1u', '62', 32);
    t('1f2e4acgh9e01', '12654640102386115', 21);
    t('2052222130', '21667014', 6);
    t('8jb7hcm50ej9k9klm09g3a4kc53ckeef116', '176022396062062610788399163891079098715666661582', 23);
    t('20509a0235136a791180530831856481092', '521683223673880098116902682825014335', 11);
    t('3eb5dh9fehd62ge5624486338g0ggf', '9641340713490442552045610666398445487', 18);
    t('1a4bh040f9deb', '1816166780329331', 18);
    t('40648755c8337a608c0cbc7b90960072a6c5160cc6', '18958470038164827979052792005696996964594012748', 13);
    t('1', '1', 8);
    t('16a80aa482', '3853305469', 11);
    t('13mb90opa29kf', '1853733788161526583', 33);
    t('1116feff891', '2144402836934', 17);
    t('1100110021212111102212202', '381334691207', 3);
    t('6kmr999ps3rdmfota14e73kk7nct5c1t8w', '855615046083522375775633777751308402456027767363821', 33);
    t('fa5m9n4ajdig0ek53p9ak5j3', '306774699778415632661541827410190127', 31);
    t('1j', '41', 22);
    t('14232370256353054042511271041451307447', '3992139171064784961434159759593255', 8);
    t('2988540913', '2988540913', 10);
    t('1ae421bc92c6a53434324c74a65972633', '74644101775626481011978862480423290648', 15);
    t('1902619a3864973a78193b1', '966910259499607548518389', 12);
    t('4gsli', '3697848', 30);
    t('2322d2009a', '30550988649651', 29);
    t('4424240313181', '1263871046485', 9);
    t('h8bdh45okcjf9o0hd3909k6b131', '38499150432406333646220029299270094451', 25);
    t('140532020041465345104254054014206235406222630412', '8323153346263714336098983109345737707197', 7);
    t('37y978xajd', '254414505320303', 35);
    t('63108698628a4146909492', '46485268864599157788725', 11);
    t('606362645', '35360540', 7);
    t('2933a9b2c5e3c0a260072g14a7', '60459499766662642607270785339795', 18);
    t('2766j199g1gf', '822341130472107', 21);
    t('14545302124120420504244241454221314', '523836947223749155885762222', 6);
    t('6120015562805331441103', '671376316612472574141', 9);
    t('2mlb1r41o57o4o1464da0ppr', '12017943535755782808346241199775876', 29);
    t('4d4b5f1hd64a0k0adjf86i3283fc79bd0cj2ide', '25463948070963903636723374419580115004912767069913171', 23);
    t('b31qm7ci547jbnl9g7aoe618bd9rmd08ae3n', '4968565779272654017559601113501856102648368276823243', 28);
    t('b1b5a0541ba01b', '8833755076953433', 14);
    t('459037672a349796631496b5aa343b1b0436', '264580482109908454505064970141676910954', 12);
    t('12', '13', 11);
    t('27acbca85360b462b56c3a6992020a', '524707494029683596995243591366042', 13);
    t('cq7md', '10428973', 30);
    t('b205a4482e48439b767dc065d6e0d76cd6a964c', '5472159758300289441724757607228631541440203672', 15);
    t('5337ac5ca7b7ee1c', '5996450942817922588', 16);
    t('14350655634', '465416676', 7);
    t('16m3mf6fd47ahb3f3728n', '426985809555038783456824121063', 30);
    t('3ba358b358599', '490282471293894', 15);
    t('8k535ee64117gi6753e43ea', '3045443598760536171170990533130', 22);
    t('18c13ac02bh475', '30853119934409675', 18);
    t('5063500066723494917007154667', '66234080067305105030592636313', 11);
    t('186chh5mj71bk32nli72', '225231837610389033637644074', 24);
    t('117148a5a0a852043b1c50a', '3593926048415359085014726', 13);
    t('9', '9', 21);
    t('0', '0', 21);
    t('111110001111011010110111001010100111111101111001001011010101110110110011010001110010101101000011', '77050543164333814857060526915', 2);
    t('25515232513310234351525133004334443', '854103611059645825566911835', 6);
    t('53d6c0b8d7bc0c92538c72570292b169', '1790024541721718087301984827108484233', 14);
    t('2316578141127154800332364024878378', '72770916299142794014818013970582', 9);
    t('24312351554365464465465661533114621266242560401543', '677411054975350956949697408467820078793932', 7);
    t('32404015430043', '45027693963', 6);
    t('n5d8co3ojm57fc5olmok1nif3ion43m7bchme', '4917311114710343888452797906984336898319878490823689', 25);
    t('bqxrro27abrmak0px9ooq2ns5vuh5so0r', '302670621534517112486044629162358286408048774808052', 35);
    t('42hfgfolkj60fdoa', '6881729329622147179046', 26);
    t('39ci8i1eihc4lec9cm763b8i3d4j0', '459022136565872107778798075253822151324', 23);
    t('63c0mqkbp2r8dr7rlr7l', '1325268836989857485637303916216', 35);
    t('g5tvq7jp0h1adior91e2fjqslp9io8os6o', '756966247294325777176797359454729091694026239537368', 32);
    t('6a8c2f4ea19l831j8', '19490172547544158065526', 22);
    t('6462041347652128580521325524', '379213761926885851181407495', 9);
    t('gpnbyecz5edn8762pv', '4788313445419794110010788419', 36);
    t('48cc6cc6a', '3827488090', 13);
    t('64sslivyfuh', '16931440283999692', 35);
    t('2102101210121000222001002102121200202210112011102011101021', '3802992314666317441798852519', 3);
    t('21c5b3519', '1754309761', 13);
    t('110111110010111101111000100111010010001110001111111100001101100010001101000100100100011100100011011011010111010111001001001110100001100', '37973033900975016780110288277302266862860', 2);
    t('e9f4921560f07fe8d', '709589094228525375321', 17);
    t('123310120101000322131120133331230033133310220323232210330303130311010333100123223300031', '10408108193832826669272437276453612756402294521510925', 4);
    t('25731604', '25731604', 10);
    t('g2', '514', 32);
    t('223105124315354545', '40995871357025', 6);
    t('101000111010110010000111111000011000001001011001111000001100001001110001101100001111001000000000010111111101110011100011011001111111110100100010001110000000101101001110100', '1913677948341929506841492066019813618520908835609204', 2);
    t('1644024', '229485', 7);
    t('98b0862965b3834318436470061301a3', '27754417671206367867044116818436107', 12);
    t('1095204a777458309a72aa', '49018069076437376288482', 12);
    t('7hke206325ih', '28203781823823961', 26);
    t('ffkmcd2rq9563sy1xvqsc', '117533208066219358628225769982592', 35);
    t('952', '2688', 17);
    t('bm8e8138q57am0kpj8pb8plbm08c', '5244190084268927879196798208000799879232', 27);
    t('1415a41cc770527309', '11386080654330629802', 13);
    t('1i1eh', '254427', 19);
    t('45145317829278248420231253636297540283', '45145317829278248420231253636297540283', 10);
    t('2l6j1i594e0d4fijgib3e7fe8700ibdjc5glibigk', '1477333573534925171219612384777712079874272005954068612', 22);
    t('282gd2f28', '90293858348', 21);
    t('6c1074ha0e', '2140840789109', 19);
    t('18134e39226', '887329110861', 15);
    t('16471074688235670422', '16471074688235670422', 10);
    t('157b2e3d04dc2d3f2c5d24471f4ea6e', '1784586140646675991730453110223858286', 16);
    t('a86', '1304', 11);
    t('1efcc47a12967085ad8cf3e4bd18a9d6', '41189283705768995637851264202925713878', 16);
    t('1g3d785ii67i488315102d815090', '242822867207165195727104515417800180', 20);
    t('121202210222010100102010211011201220121101222100020210210201020212120101012002221101', '7436650012220024757800516842466470073650', 3);
    t('75lkce7kh36cjmf701', '1023850888444449444662304', 23);
    t('cahdf581f8h0f3eh10523f8g4g3732dak', '25614782272742316000546588041656891750618958', 21);
    t('c235rkr51obgch00s9hls25o', '52114806185494513712231850125002384', 29);
    t('512450325542104132203204311205230152424404424444', '19625794458356109522992578261777179820', 6);
    t('2938760b2268721900b061aa78147', '4575799291145190419537441899975', 12);
    t('575g1fk6gjk', '141564983017126', 22);
    t('1bnrqqhr6axy', '174253590792010726', 36);
    t('1889b9fe35e07e831ee8', '115877401735749106343656', 16);
    t('11', '4', 3);
    t('7', '7', 11);
    t('211012220220', '437343', 3);
    t('9766o7p4eago037lpdf4317jiqj5b', '306860122389219927555679423284323106653767', 28);
    t('22e602h65', '54675222925', 20);
    t('232', '46', 4);
    t('327', '463', 12);
    t('2654', '1452', 8);
    t('174kb3627', '50857395421', 21);
    t('23330n76466p54202nfg5dnpmo5b', '339324532051327829474356208074218552333', 26);
    t('1b', '35', 24);
    t('8fk3617863k1ekj3i4nbl54gjih5j8d0mcc', '11064457703744790697464223530688876525906885114476', 26);
    t('28d11a69l0c51033hl52d97ka58203cd5985', '230834132211031575077351661596124469754192074433', 22);
    t('1hq1lyqrvs', '118773335426438', 35);
    t('4h8dra5hbdhh6qoigef555994', '249026258798368156622666692897679952', 28);
    t('gm', '502', 30);
    t('6nbbg0v2ppw', '13803003606198230', 34);
    t('o8995ejolijik9ihd6h88711k5dc3', '33771583190371089624006346925091814539678', 25);
    t('4qtin436tr24bq', '78115196524110627956', 30);
    t('6ns7a0jdiaoq96ol', '254868647544300369124117', 32);
    t('xpawcvygn9kw0sjebn7sc69w3xv', '471734872338124510193818490984195329748111', 35);
    t('11g04c02ffi1jei4fhj', '285744497211343343718359', 20);
    t('3hfid1e', '557949033', 23);
    t('27366', '1203018', 27);
    t('410001534025040051252012542022342552143230432315', '15592777075391766081309283367976081239', 6);
    t('1111101001100110010101010000001000100000101001101110110100011', '2255400303091572131', 2);
    t('c928639b2d13', '429702230763951', 17);
    t('1ck', '1505', 33);
    t('1rg4slbg29', '37751233721469', 30);
    t('113223330300320211033', '1627738310991', 4);
    t('7526131ba0fe6e6d338a003af179d', '38016936118707892590533223274977181', 16);
    t('7kbia0gi223ojjok8l9ho8', '1777784215960035304259119683108', 25);
    t('9g339757c94f3653fb7g0', '126191630648724675191221284', 18);
    t('1232330203001200013211200333021302320202121321212333231320120', '2304259321047843514901283244800400920', 4);
    t('21647ibj2fg0638c34jji5jbh258h0j', '2217866954079313899427020782581575270819', 20);
    t('723532980a7a6160', '30120427896650289', 11);
    t('2838da9931dg46976fb7619a664', '1064566675009185862217875437188488', 18);
    t('9dqonc1dohg', '7743225898096948', 31);
    t('1652b10575aa9464338761', '70682923355125382861113', 12);
    t('10ii6eidbd15c683666', '109597980236249948993049', 19);
    t('dhdbjfc5f0kehfjl9neo9n70h9agm22', '38466966256495223900208674134248822954556238', 26);
    t('7icf1', '1533673', 21);
    t('e9b7a48', '166885943', 15);
    t('2l1752qdn2mabgmd', '8211555811727424645412', 27);
    t('5df602ce4dbge0', '120139111113169572', 18);
    t('222232223001210301212101233001323033013211230301222323021321', '887451886358748243322562892954055289', 4);
    t('179faejd9kk670fi99ajk0066jkadj', '299524423604818745400343490657227811143', 21);
    t('43200420031713445212602476237542777011721017120532156', '402495698817091827248733349983795241261310588014', 8);
    t('13csb24qhher85cfdcsl66g7s0ob5305m', '70068000321367559069425429652328969811703105193', 29);
    t('bbhlbl3fj6djl87bi16ig1bkb0lbk2h6k', '104622289890616799189358030121475094962525324', 22);
    t('lci64j40949l9l3ghjfe60', '2077372440260189074331803122192', 24);
    t('3234121002', '6942002', 5);
    t('5c3c18143a8d96ddbb3c3597550682d86aa344313d2', '8063490574133991241638155039025343935997707461868', 14);
    t('110100010100001101111110100010100001100101110001100011111001010001101001100010011011001110110011000010100001001011101100001011101001011010000011001010001100', '74667765260706149423652281266282011954894090892', 2);
    t('e66h2dp', '6853789541', 28);
    t('i6ga265f8fhg7ci', '30050327699762851058', 20);
    t('kpjn1g235bnqdt0pfqtpcm76p4d6fn1fl', '3864528859465205644913303289493194133427615572371', 30);
    t('8rj60u4oi36nelvsax9eqy5iihuv3', '150573930494022755146637799121836756574031088', 35);
    t('10020121120100201100102212101100211221', '487049655635708407', 3);
    t('9p8cei7opdpi65n57loob4g7nbc8ckoblec2f7', '225365305306981525279174955491083242350460825335359093', 26);
    t('10a75b1764057474656bb29', '592793221090149901308561', 12);
    t('4anfmab64n5bl8h7lgg1ie0l4ddfg25cg4e1', '9047095202662955427862645312426846850781918243409', 24);
    t('ci8i20261ji2a58h12hh08543b44gg7', '59758755425248253813800729972530250941001', 21);
    t('244q5nujetw6880uoouz1lr', '36636647742989920257650194763362527', 36);
    t('2f959fkeaf3o7o3', '281006925782093444199', 27);
    t('2dh9c4ndacn1rl', '39101896643140342731', 30);
    t('697949013', '1475458768', 11);
    t('im8', '13724', 27);
    t('6q6vhmd1iu0b8pqb80kvc', '8644518006985435630419253941228', 32);
    t('9gjbn3t7i081aggxoosngzvxjwyvefe', '462313443934060201968693839921231382427024338122', 36);
    t('1000000010111101', '32957', 2);
    t('a6c29', '300855', 13);
    t('9jk5', '120019', 23);
    t('2958324266700a89cba7a88aba7b1483a80a845394c', '166375841507718717154199653196499305551542689961', 13);
    t('8bga99e87', '146479828376', 19);
    t('552c7691213c2b1d86123c1c7caa2938d5c986da9b6c4d4', '283151423101296097641534175091523701505647270269960362', 14);
    t('9cbd4aha1ha92b2eg45jeb5eadff0ed4', '206784494673855421123664772006772082405864', 20);
    t('1d08aio5dtk7t3ok8imm0rirb5iqsj', '62732185189647697420568057030541027413945235', 32);
    t('159g201094dkhfd22bf965eb5je48ea946e84e9', '221200921967109264882569021709960008760497185134222', 21);
    t('282810456027348881588a1a6844975597a10279217', '150593766383429712523815468178854618203779472', 11);
    t('gkeel6a6k1ke899bc1ioh2pmn9', '10194974937056732227569538058731359834', 27);
    t('1h', '42', 25);
    t('1111110100011101111101100011', '265412451', 2);
    t('1cl6kj1ij107ce544', '65107429951418530980464', 26);
    t('570996141450414325391258602192009734881', '570996141450414325391258602192009734881', 10);
    t('2011220221021021120202000120200111201121001102100222011201020212020121110102021011', '967713477488275607218048209625740279136', 3);
    t('7b807441cd4ddd6b26880719b0', '1961771544630113528190880625565', 15);
    t('aka6g7bm5qcpcamgncnak34grnpqn', '355563315866230083340179532894009970687679', 28);
    t('3jon8', '1986425', 27);
    t('11110010', '242', 2);
    t('1ea4cb38dc109662aff507', '37045991477844459182355719', 16);
    t('a5202753805b262552a29a36', '69100527198804395338546314', 12);
    t('h758blfokoe2h1f6elgpdl6lb3je', '2765358558144112774392012587127708191216', 26);
    t('rvracembjfb0j0gdqetvns80gwmfi7ocn', '109408928137522865486039210206106484286615208207327', 33);
    t('c655c454468g2f2d191448bc0', '4199457544137003090436194808585', 17);
    t('16166f015f2938', '6217115507829048', 16);
    t('3a439d31a60970875bb2', '22327746714916052427152', 14);
    t('8f2149o2099e21dpbomf89sl2s8', '896954776923762691198643934470088411598', 29);
    t('2732ck508j4khfk70b9hbi1i0g51agk3kh', '100584319142432419662581113685907275800401254', 21);
    t('2293hbi1c0ibj8b04eb0a8e306363k', '467614135020365754837471336728850191984', 21);
    t('1001111110110111001001000000111011110010101101011001000011110110000001000000001101110010100000110111011000101111000100101111111001100001001100011111010100101100100', '7294509680489473516157489095568130945736908974436', 2);
    t('3pfr2ip7jnn26sdh0c7o5pp', '577698647900420975141535859962895', 29);
    t('a71022623aa8568a56574a648a6393129a75', '29914427537161064808542804258585866020', 11);
    t('1txea4tl4ioma4xhclq9hd91tcga9b', '1113049897936374448769342426122784424634168576', 35);
    t('12cjj1kh53kg5d31b8l6da', '17344044780654272896096456024', 22);
    t('6338438487154824328460106772453870408', '143776716058614716325880611403859603', 9);
    t('432001140311342041002012043', '6974394432902375898', 5);
    t('4a6', '1332', 17);
    t('1659648793588259334905356155006008342186329512002888', '1659648793588259334905356155006008342186329512002888', 10);
    t('4ff72', '2101868', 26);
    t('5f550f99', '1599410073', 16);
    t('111203231301110320313223212301010312302200122013100020102300232030232302031030313233100', '8065823905840410320894641643979945858160602700282832', 4);
    t('17cb282a436a703632a81c96c82a23b48bc5327a9857c3301', '475704029530481315157224161906654754528942922274574893', 13);
    t('a4c3', '222995', 28);
    t('163l03ajcb0ad40c442k90j0nc', '40227429932334134086127053002343476', 24);
    t('5710182695a29304279467503339a7a18', '11918193967216532512029301640127416', 11);
    t('111101001100101010011001111111100101100011110011110', '2153208033232798', 2);
    t('171d86581e06acd30671393', '110366637375726363319446063', 15);
    t('4309b', '88247', 12);
    t('12g769bj187gg86h8hf973j0a42gjd', '61252434461027682447268959845152662793', 20);
    t('1a12b67c34d57d7b7ab7bac0', '8069232682011269556707244736', 16);
    t('101111100110101010011111110100000001110001010101110001000001101101101011111010100110011011011', '7366381587271251372942380251', 2);
    t('782713006615886387770478158878371218820625', '10540317444948349549974758397221264757353', 9);
    t('er7m00fe4h1a98apn47rp7ngqof', '633071733739943048886072406486704224591', 28);
    t('5fba', '53161', 21);
    t('1', '1', 25);
    t('373a2b3ab965aab293', '8009398354430311887', 12);
    t('10', '20', 20);
    t('1430', '240', 5);
    t('74c71', '210835', 13);
    t('9xsfamo', '21634167696', 36);
    t('188222373080761752602365676404381071', '4983141020490008650128344377943701', 9);
    t('jb2e96lje1ha', '18563807355127419', 23);
    t('2cahf1g8g954b14e5894eg015bcb7g', '6829065184980377404323550915244107882', 18);
    t('11100', '28', 2);
    t('113411024302423333024433100040', '252194224967802628145', 5);
    t('f180a79f03c93c97fb35ggeb08', '87059322139486573429172839940859', 17);
    t('120efdk4bgb0262hkg872i6a', '8204646330520455780142328716598', 22);
    t('6256357393600602316105463449174016233346', '6256357393600602316105463449174016233346', 10);
    t('3212301333200210131012', '15859158501190', 4);
    t('18c1109b859b3213a88455', '1912876166082408380555931', 14);
    t('3msgodhb0', '3189281360714', 31);
    t('10110022202212111122222212200112022000', '518798912531859027', 3);
    t('1980a00544620cdd3422c116ddc9c2cac75ba9675c261', '452854399467234314582837732095548314825458988323821', 14);
    t('22120310223131300233301203123010232321121331222211100311121300112121221200320333', '948867252058170771971968589971969532899273084479', 4);
    t('8610336237073', '8610336237073', 10);
    t('1gn4sel36jcbqf58rhhhgclt8j36nht4q7mok', '752672174999009092630489286382303645479407654345444956', 31);
    t('1a6814', '671454', 13);
    t('2121004240121331213033020403240303241143321444022223', '1016205781946557654652895245042954688', 5);
    t('3krgqepgut6dd9os0', '18224259273870124042615005', 35);
    t('25535776478032142616588245811660254', '729334501710489629337454615331293', 9);
    t('6k0b066cpgf2p21bb9505ee', '91199647570792812205739943564766', 26);
    t('ap7kgeh2dn7i6388b3fcl', '218672926024286079336604110609', 26);
    t('ce4', '6120', 22);
    t('16a256605b0061a6', '24202414333303182', 12);
    t('1212102230320001', '1716178433', 4);
    t('4q1vkp65a7al9pk0', '287088200068338986362716', 33);
    t('1e', '41', 27);
    t('55510210244455351232000220243023431514140253311004235431353500150330', '81776145043668260223503433020247653436287857614658350', 6);
    t('130305050324253103313502041022443', '12053790958929773590572219', 6);
    t('83hap5gtvwyl7599', '1173538126887991015344699', 35);
    t('12881398792329044007438159548', '12881398792329044007438159548', 10);
    t('23h7ffhgeajdlfi07ha92fdcde28', '3822210589969585209003310564499412420', 22);
    t('1j011g1ocb5pge5n73n340l40m', '1036339108033766409452608824145334557', 27);
    t('211286b927780106249b51734e81a10806cb6a37', '15272908194563540988310670174159872284243270052', 15);
    t('12665330245536441266321151203103102661414103262235', '366872199782353523541963434688475998858925', 7);
    t('505432a457580', '44912120764272', 12);
    t('p2pcjfaa9kh1d7', '101755664535230532349', 27);
    t('1ca17a18211', '273370087134', 13);
    t('1a6eki24el0nmj9gfb', '415305377140894690392947', 24);
    t('3311124011032202103222400434004110041', '53121754075159082263738146', 5);
    t('757575478216a0369101a9a', '611877203654087245090193', 11);
    t('5hk707tas86j7lgepasea3a856lf', '102938253425144386832441058642305902207629', 31);
    t('0', '0', 9);
    t('23310db646fa85615a6d3a159621607b', '46777680511357499186246331786523140219', 16);
    t('330da4bd37ad5178d5d1007da898453212c6742b9407d', '865753046927137144605560690484335314112623722543359', 14);
    t('6jhid8iejf0b921d642d', '36673075507149093253329653', 20);
    t('3e', '68', 18);
    t('df', '223', 16);
    t('eca7fb1ac1f4gd0a485', '578348126662152188101397', 18);
    t('201222022102021122110002120000202022001010211011001210111020020222102120001202211101111000212202021022', '3431471172203461653218475265244817680631426808448', 3);
    t('33cb8694e7a24d9d05805', '1082956090598761200374930', 15);
    t('ca', '370', 30);
    t('8897a2162a5266', '16689805406089296', 15);
    t('2290daiad16472c0fga333889736g5f5j6c6i9', '2917258149546117962537789858395697836179581858769', 20);
    t('47451060028002207126815661', '3470450188748283358865308', 9);
    t('114r', '28047', 30);
    t('57ba054gpg66el', '13115553604473529321', 26);
    t('116214463211556364653562325626235034462421545060660', '2287347864835163237256472200746189442885120', 7);
    t('1154000440000511455342052110220205054114425', '637191928874193961970691931711985', 6);
    t('27', '47', 20);
    t('22020101201201202211222101010002200212102011', '901277883406744447207', 3);
    t('2798165243533191120056', '2798165243533191120056', 10);
    t('9dh1m6jk4486fl7ie', '58857822718096078072226', 23);
    t('14ik9ll0dgkee1ck7c0a4f313991adch88eb', '117891995927485506019012046581940014028686934255', 22);
    t('28718dncmjreg', '808197342478474568', 29);
    t('175acc70bc5338cc6b', '46636214136757771663', 14);
    t('46puu0tjk81b5ksa2oht9e1fm135', '78008186942992687166968757565746709077308', 31);
    t('26q46ph98mcbflecrd', '8982841934283065478848833', 28);
    t('7', '7', 34);
    t('sn7to1hmp60mn76nol3cqlcqbr8e20rj95eq', '1375725743077776547871273369745579120905697393330394586', 32);
    t('454k6j5ifbe412jc5jah10b488', '4828430285363354503415653711937102', 21);
    t('81ptfnrpjslw0v9ghq56q1g', '75036895810433018445880325692861026', 35);
    t('10011100111001101100', '642668', 2);
    t('377683501888313149', '377683501888313149', 10);
    t('vwlugpjwq79g6outhe5ppgq8bmejfod2k', '325037691298489231093571012113559335342031712624284', 34);
    t('1f000932fa1ca86508eaafa96ab453c29', '659300071197325571806191735253210840105', 16);
    t('68242gcbe2euld2s1apcietj94k', '3732484254314395839062129559607170449956', 31);
    t('120001333132124003241232313444414012433343014310022304413224440202344143', '59315978615169369703579038472917980021927481293673', 5);
    t('2d31429c9b278c5cg9i8aj4fa9ha8fa7379', '456580926576690928879270905384043456561657349', 20);
    t('a9803495569a337879a337a88369ab60aa4a', '638259518594740470682480348997343560026', 12);
    t('133534443423300243223404305511241424032531131434023033530', '60692847352782957146725953144004923108889662', 6);
    t('85ehgbd', '390694638', 19);
    t('3j5', '2029', 23);
    t('1012373453302574', '35905333986684', 8);
    t('1dhke7dqoqf', '440416062149351', 28);
    t('5hkpg', '5144063', 31);
    t('35ec5ce3922a7b1370', '994709174014332048240', 16);
    t('j3s32kabnnsgbnsmf89bgh92gndas64407', '34754001064750863291622215672807282090764762457400', 29);
    t('61dd8092382749b078370bb97dad5821322187', '15671002482405137501514236252535037151239851', 14);
    t('4hgwcua9d', '12653415422833', 36);
    t('30201301530031554', '8623342543966', 6);
    t('54a85400285541985', '250548156011412583', 11);
    t('i0o', '11274', 25);
    t('11ah4c5odl6', '100812863664906', 25);
    t('2b1ebn61', '80579255489', 32);
    t('102052273401065267741403121062144257736511671', '5621698349102047273384509211278621447097', 8);
    t('12m5m2g24g9ha', '40974227046315490', 24);
    t('b0316fi0fi12cc2edfgh666f4cie4h7717', '17401925878966433671042194733848449150168289', 19);
    t('1523011035032422014120125032023343524443321', '915746679762856704907142877377473', 6);
    t('e77b7374944b', '254517404013643', 16);
    t('c1h6s949befmc', '4265231138793771068', 29);
    t('8gn5neeg3j9kanelcml', '60767643491277312404351781', 24);
    t('1d0f1645dc1656b1174ce08b54fe4e40d8a45a3', '10368573985886829358840965263279576467697714595', 16);
    t('31b999', '787653', 12);
    t('59lp636iq0uipac40', '16849438009500138420303704', 34);
    t('1', '1', 25);
    t('20py9t', '106157619', 35);
    t('1nbp5hb6mhkcbl0jbej24mp2f7ie6705bn', '94059918813328332413354055079765980054543365401', 26);
    t('372828313408429453a89234335705aa93', '84982956234483079772353825488568807', 11);
    t('1', '1', 34);
    t('597599783196a239116345493271610aa304a', '181780923673444526658447231965398995472', 11);
    t('jah2d9f35eecehkhaig50k058f32dh34i17deh8', '3425329058012479254389346018958616073008108535858638', 21);
    t('3fkc5ekh02fl5l7504lf4kjch', '615443274731752854770742839505669', 22);
    t('c09g66ff3g4a', '66781941358533058', 27);
    t('8kjcadt', '7690526901', 31);
    t('216307272261', '68706452503', 9);
    t('132122213122323312233100211230220310021', '143634905030561828605193', 4);
    t('4', '4', 30);
    t('2ih8d4', '9419464', 20);
    t('5cbru2esldn7bi3r11s3slklg7', '103847118190398120797912171490899906888', 31);
    t('2756753281255824113730120138022846228121005758023353', '13214305490430474201156158495454841847969048656749', 9);
    t('535g', '25533', 17);
    t('cfdjhdbh42', '6545912574882', 20);
    t('5bae9d8572781e', '117534573740411384', 18);
    t('32a7c1783c7795016594977106', '22697848458351903229013168476', 13);
    t('5j72cag18jf7hd2438hdk4d8gebh872b1jh6i', '2356586866027928758507194750053263942297777670070', 21);
    t('29a8703347585354205108131051123', '50730942867273729841510907088926', 11);
    t('202', '74', 6);
    t('1r6n20omm758binpfhhg6o', '4846670585161045993229294323840', 28);
    t('302l1h5k25mengegj12ig4j', '6958109965429248922848549113971', 24);
    t('1i7ctk2rx8mw', '107795645888833828', 34);
    t('dma1', '408736', 31);
    t('ii27k020bh', '71425244172167', 25);
    t('3bh1h47d78cb647h695', '144161934131410544716151', 18);
    t('12l91995c6pb02ka9fojp8qr', '10264759826056914843582409364273007', 30);
    t('73kbijcfakakhjge0je9', '95249983769065885922897793', 21);
    t('231256124330320211253061220356', '7912150971698220450062992', 7);
    t('63ee15b1600gd1e7c1aa076ad2ba7cg338e2g5b', '355952630936226662025856351876918476512022045757', 17);
    t('2scs3i0nr8k2j8htv02264fgq22jike5', '131881187118274767764360147174413433678100779461', 32);
    t('79g87d5ba26if7f9hfb7495f9beb', '252650784623083713180577012193606464', 19);
    t('2446336161312425410360135603630002111211452144', '285926215543115581336289477929436470821', 7);
    t('1014', '134', 5);
    t('a7eg2ih4eg8fg', '23039629802162005', 19);
    t('fjf1fc86n391bb3fad3ja', '143555586534627347785306846110', 25);
    t('53ee0k686kk9p0adk24', '151433087203562860042013424', 26);
    t('3gde516ce', '43324547990', 18);
    t('245a76562671a079a31367a6677264a795a6a253aa3a27196036', '311589292474793017656303618319953525081276226845816579', 11);
    t('179aaa005c10bacc03', '13811640779442966125', 13);
    t('5', '5', 22);
    t('3e0d8607cegf52025ceg72fh2f1e', '29502535901784316100206946117442716', 18);
    t('bdc872482aacdb6b3878488d2bb47b4', '290245307604746958781826626029678378', 14);
    t('1022imeahr', '60825976875029', 34);
    t('231100121114223332230343030211204244131433', '120421321606190578932235536493', 5);
    t('cebsni1lh28p1a0nle3a46gnso5', '7431258037694141924732501459014099990268', 31);
    t('a90d7361iba901a3jlf9', '333807389054166765483570559', 22);
    t('a4725g0b0b2', '20684084949700', 17);
    t('p402062lc63b2o0p8ggbl3c', '777160257890411909864572085822448', 27);
    t('2303355462020425243403060', '11247570692927310923312', 8);
    t('2dbdh7fd0l32j3a82ba3licjb31i4f07f9509', '5554907043046798505631459409749348180767609870309', 22);
    t('4hlg2321bc13197g5', '204342990490417640852281', 26);
    t('236571440705332620722731730', '749616319651624136717272', 8);
    t('55bc38d17d8bb55131574b20616870b', '131116903380881919543215522786677223', 14);
    t('1634023045115006652225404137572537300225444451056550315', '10550640276770088084077930237138652035960136192205', 8);
    t('7898', '7898', 10);
    t('9t', '299', 30);
    t('10004226456290899026384452917652101828', '10004226456290899026384452917652101828', 10);
    t('10896b75jlghjj5ac303bee41', '168126786589614868323001367557489', 22);
    t('a', '10', 20);
    t('23456bb', '6811055', 12);
    t('ef557cf221b976840f876d6fb8f40', '77668303327151794801661259781214016', 16);
    t('74e7kfgi63dkjcf0g709hb342', '390828104573594513794256813228258', 21);
    t('5206807007436090535494441589318273345', '5206807007436090535494441589318273345', 10);
    t('d50ecdd40a74g6b26d', '10999913536169400117845', 17);
    t('aaom96hgek17f1', '568329567265580151340', 33);
    t('2h72if30l24m1jbhijh', '8929830333919554320478685', 23);
    t('28d312047jhhp9l6ad6bdec81bjgoce990', '115062764810939925699862575664608474748105279006', 26);
    t('65360803637634a9a320113a990530426', '13689954501985913625610550156362967', 11);
    t('26c2a5eie22a', '477248367792850', 20);
    t('11d071e8c8ed7f60c4fce894fa20a754', '23679184030321848843326203235370313556', 16);
    t('170101df', '1223323850', 19);
    t('5al863jgic19c4adgjrhelrc3k20i5bflhrk', '2408022757613879912229341990414136203114403118805720', 28);
    t('72ba45fi27d44i7831a4732di2i271agi047abfd61', '191613909069100350797661478313614413491069036280929215', 19);
    t('6304300645', '259937389', 7);
    t('9uadt2ms0g6dfj57d0keiomj6', '56331308674978903283699628034003500420', 34);
    t('616h5k6dfj11d5hc2iibedfbiga248623eic', '114913060108619059717914037645723081826728710552', 21);
    t('151e2dij79o8m161hj57pbpl638jk9jplfc1j', '1038147489563282380151219519342367976127837619996133', 26);
    t('805akctjlb4cc8aefu61', '317118938284714353937988712641', 32);
    t('343', '178', 7);
    t('7cee134a1dab3d5cff44b067e971', '2533881063347006744885016016710001', 16);
    t('10100010111000011011100101000111000010110010000101111001111001111011101110110110100101001110100100111010101010111100100001001110110100100100100', '7094500064780213519639611108740313788148004', 2);
    t('9j48ed9o4n15benq02k1mnd4jpphcmp57m', '1668040714992898949399742204953861377855573157899', 27);
    t('111110111101010100110000011010010100100111110001111001101110110001011110001111011000011001000100110101101100001010000011000001000111010100', '342777004104073921541803082899350493073876', 2);
    t('2aps9b7ceb3348dj98d64qdn67l', '250116512555563755653432147366865700291', 29);
    t('2fc6363ce8caa6f2f7d7dc022c', '3785067239745545603746923020844', 16);
    t('11100011110111111101111100110111111000010011000000101100001100000100000011111110011001110100000111001011111111010110100111111011010101110011011011101000', '5081771157073840975382845753680003415619876584', 2);
    t('5bddc1', '35425291', 23);
    t('2s9ne5s9i6tk5rl1ep', '111588862691610935453976025', 32);
    t('21012001212121112221011011010110122121021212011200201012212011200012100001110220010120111001100210202', '1234802724654414853946459041807906768113064412381', 3);
    t('3bf5488fde2e', '65924670414382', 16);
    t('u3pd7sn71e2e7c99642dxo', '4362855934107800076687165630732286', 34);
    t('242104344320311141301411342043231022024424', '131400847482479502782843939364', 5);
    t('141829b5162377b1056773629bb7a64073631', '953369605617258980018209252546165804741', 12);
    t('12bedk90926m62hc41076m84meda13mkkbf', '93314399078008522916395011917110262331060012567', 24);
    t('54c1fc9g96ageg9aibb005a5904e933ebea', '157502651794975274233660048577504724325147521', 19);
    t('133431b367b4a8b8979372b4164197204715a31079a71268369', '1158759359278975321088119115465152282863498420368213505', 12);
    t('13b', '765', 26);
    t('2ck823dg0eah37k2c8416i78850c901d3jei5k', '21878942278821174795945388165121844819343606060160', 21);
    t('8h63bi8906620568a8528f8f', '22734498086376568954341159917064', 21);
    t('3011203103330203200111103022312', '3558775854728557238', 4);
    t('2114345430422321530520332432005304354143001413014543014', '2321243578574069612613894494714592689697586', 6);
    t('313c41070cb56276a', '2062977410540325354', 13);
    t('226062710577641', '10314752130977', 8);
    t('eq', '404', 27);
    t('1rrbem3ecq3n67boi65q5', '175399218720599627675357116077', 28);
    t('9005452', '26883134', 12);
    t('48lgbngap7dk71io03', '4920463358341388158907427', 26);
    t('12b924341033230434a810', '302187810594058435801794', 13);
    t('103522531132242513144124530124313441213454020315521503313101452132405', '90987503713365214158548349492616461122244894478035413', 6);
    t('477895231156911238285', '477895231156911238285', 10);
    t('1000212202022010101222211220102100022002001020110010201210211000120121011201111012121202220002221121111222120', '3491562614859609420313071183474817621330068508271172', 3);
    t('28qrfjm8om073jm9jr3', '1598066573075108614197842742', 31);
    t('glof4tcf9be30bkk12huv', '21144602101411302851236097771487', 32);
    t('12234515554420440450423405522354121252513251541023431322250340003', '89091283215408342578048636526866275587072931600611', 6);
    t('293a2ac1719c62b6b4139', '51592970952982353881099', 13);
    t('63834852656662556175641051453321158', '1790303853240101318026187599939340', 9);
    t('32534135313343133422341503303202021011402445221134014', '101535298750522938072060693442171335418426', 6);
    t('2112212120112111200100011112212210202021000111012002022220001202002010000021100000022000001120111', '16230306822675488621342411759833456926468945274', 3);
    t('1a2d62jmlkaoj399e', '32690531722536862943364', 25);
    t('22065453526323025411333336261643566522', '42796341889415021094527192979898', 7);
    t('104167430465731064510563526155446356705', '22143034232047918382504353520541125', 8);
    t('5j3d7b3oppg6kc3mn2744ijmndkpe673k', '36321347509392283793093324752977729120040144694', 27);
    t('120414231214540521150224323551320', '10769598675773992644375360', 6);
    t('1bi9fehbj9e547c49j7a06jg7560g8765e', '5250966747722630510598487707449375086663043078', 24);
    t('82twddpskk881uha', '758314750152574060793292', 34);
    t('d52llnno6g3gh4gkdim8rms5ak', '111585313532002326992087587176446680820', 30);
    t('qkbqpb3i9tuggok45k1auq7', '17209839140980123276676359657614507', 31);
    t('2d8d0', '147120', 15);
    t('1a549702802504ab20a90371a4a264007b8490821a', '329963588381537567503898209643604670682080054', 12);
    t('1110101100001100111010010101011010001101111001100101110110011101111101110111000011101001010011110110000100011010011001001100100010111', '9997939815383461009512050917690963695895', 2);
    t('222310200', '175392', 4);
    t('amiik9pb3', '5393051815336', 29);
    t('5661a43808fca8b4914', '25495292807490092878100', 16);
    t('1bf28069b1be09e531b503126', '576881162454758851939576929685', 17);
    t('1ab6kaha802h2babna20o2d50fi8lhae', '30748760641046756957353468296768955257370264', 25);
    t('r6ngp7gp', '469799289293', 29);
    t('17apm6p9a7fbhl9el', '56058811903597689734205', 26);
    t('25ad8a6e4382e566', '2714978356557964646', 16);
    t('52hmf81bke60a1ke52184jlaafg612kibcb', '101881994750582739020029670929688842788838198590', 23);
    t('ehi4b', '4134238', 23);
    t('1315442501021345443411512242201232334120442122534143311114044131454', '3544848832557588737143248118483924586575113144263194', 6);
    t('12250151105015533254352133311311334000', '87400952959480256128641322608', 6);
    t('10202202221201002000012011112100102011112212101120000101', '219194364044464644628553410', 3);
    t('3a3', '1403', 20);
    t('4m3gia86cajgn0gdgi', '5500811188268590953027430', 26);
    t('6w3nih08nq', '323632265894876', 33);
    t('132720259751334396422683662607336', '132720259751334396422683662607336', 10);
    t('efh6fkbppc', '111175184462268', 27);
    t('n3hh8ie5go912kd01ecbooigbnobii22p2d3c', '78229552724209774917834081784752324809901456980962338', 27);
    t('1a6060e36b871e4936cabc14e31', '6414250388216682298310005961071', 15);
    t('8i4emgkdbf89m293dafa7j3c6d5', '6728193838600532021344689195469391549', 24);
    t('2014393794498', '2014393794498', 10);
    t('2119tt7n0227mjn5m9q74s8in35rh1', '36121164187835391842857679215651365416073949', 31);
    t('i194c24a44i6f4a2fgf3', '35766342361937111855098852', 19);
    t('51021d6b3743de66d02c23c15ce023cc49b9c83c8b3eb', '28365584323066293841735710762592894605506406026618021', 15);
    t('26uhc4w2e80buav4ek5lr5lrhal2p', '82594494815054016601080486021223708523042353', 36);
    t('222014311425534015230513153023430030545215', '191709426580611202017069517126955', 6);
    t('6fl2ghallhed', '3929812949532461', 22);
    t('7a337a', '1278210', 11);
    t('10001010010011111111100001110010110100110011101', '76038037662109', 2);
    t('fjk05ee4qc7djqa6hdca4l17bl8ffhe2', '11426461588103614891586213643420335678694578906', 28);
    t('1i82b85b56f04bii7f34d60515bee4b38d0e965334', '52886360111107438155328456805662247358206078055736978', 19);
    t('163a89480a79713846076141827', '1881124520769713055736991120', 11);
    t('8f2g', '331856', 34);
    t('33f49h', '7923777', 19);
    t('pmeea2d7919bb977n72ei4', '29569453750412076045125686518769', 27);
    t('10ik4q8i53n162bregsc29mt9cnnr5l', '561304419042503423943841208615348170365516275', 31);
    t('1mslct8ed9fnbton', '101475049402356215994266', 33);
    t('30616161545253435002', '35655471572473580', 7);
    t('6thgnei47c630i44', '163171243313361202379251', 31);
    t('a9i5h2mm08ijmhh7i', '63937387916914384871933', 23);
    t('35f3oh1m6c', '12299557451412', 25);
    t('43906e3351853cb2ad062c9315091712290', '367854393737791193668837913203410675507856', 16);
    t('210320', '2360', 4);
    t('1f03jb6375155cde2h3cb0a7c2e08516', '37591642929944359779790325970114732866026', 20);
    t('1101000011101001000100110101000110011011110000001000010010000011111000010000111011101001000010011111010011111111011111101101101110110110001011010111000000100001001000', '76330741559420840213970134181579220885370404866120', 2);
    t('723bbt5iw69j', '681623175196640934', 35);
    t('1111020210221212120011001102022021200002101012202000012212121201012121211021212021112002222221101', '9485666611553640815200275025119640319945611036', 3);
    t('e9230432g1a379f7', '41610888623244319513', 17);
    t('i4d5e3kpdlpfain4qip0', '28521809758740110400245059650', 27);
    t('5ep9dndi8d0s08qk5p7recji9', '690128544843296060408933983940765539', 29);
    t('bee89262200de8b67aba', '265978570932745965667300', 15);
    t('4276ibbd1hf8h', '9131409870722716', 19);
    t('85hp63929kfdcbgrbpl6i2c6bf55ni9nnk6', '130996974800003436075520961172392638886635381034470', 28);
    t('474', '2476', 24);
    t('2631ab3225463601659691', '116022131993562424814989', 12);
    t('10525030898513855313', '10525030898513855313', 10);
    t('3h7k4mqi6nd5r605gp7qjbik1', '450084426424182428475145576797678729', 29);
    t('33fd9j1dlnk497kdn8c0n4bnp5c', '19319964977974884787425260629106620314', 26);
    t('1426c7880438b', '30816340281062', 13);
    t('64321023153', '1875330978', 7);
    t('25', '23', 9);
    t('hm351b6lb7je8mlfd5g68off2', '63540723667510583038007846985931627', 25);
    t('klk6ek', '108208208', 22);
    t('208d919616a4ifc5h4765ebj38ji100778i', '347322272727940675644219270315862525504058978', 20);
    t('cpcunfpgqlk473drd1o4so4a76606', '7345383461143882582651212119039482107238312', 31);
    t('1pih4ojmpcnu704kojsv72ab6i', '162908784779725387991102787318550729815', 33);
    t('360474703465644142142614426374633517336173745433164557017', '1406659725135506145446652465678360390928078042488335', 8);
    t('10snsh0giu9p7h69iri88lfng74bb', '7799390119107220662097119983075788706149993', 34);
    t('2d4e3gbg41s2pl85qbpadg6', '365226006635397229971610827736500', 29);
    t('16ek4lh6ikh6', '761689572308220', 22);
    t('8niepouv', '300193473503', 32);
    t('101110101011111101011000011101001100011100000100001000110011101011011101110001101110110011010110010111100', '29591313602933764036329127652540', 2);
    t('7m7phem4rh16ri', '283899653498709515122', 32);
    t('ecd7559017ec', '260409597630444', 16);
    t('baccfh26e6', '2299936728858', 18);
    t('812659a6b', '6600640018', 13);
    t('3eg', '1365', 19);
    t('57i652ea9a5ki2929ajdjigjg', '290822038162647483611639195114581', 21);
    t('1mm6spj0adu7lutd63hru3578hqs92gnj94s3', '846779105368022234729976221876987821217467278988194056', 31);
    t('1077226367', '150809847', 8);
    t('363ci0ha5g0b2cafedh474d717', '309571283776743389617828368758327', 19);
    t('j3ki90fhj0am3dibmf513fl', '17403192502310050592752764662905', 23);
    t('57', '107', 20);
    t('103203234141240404420403444124340102400144443233202011123100014', '24657740989792007884797847294801892590440634', 5);
    t('2o81l8eh8bnimmbe3kff0snig', '15449657193898916995922777414678363600', 34);
    t('132220114253153453325114041000542535224210310041312131', '273473331059592249838738470025686999579223', 6);
    t('3311431340103430231230130014102', '3404424300858526016777', 5);
    t('4144044111132405001404032300314542302355012031251140414404341351', '45361153961682006879724274980338129551748231408067', 6);
    t('jog1df881f7fj1', '203639325446012074046', 29);
    t('14lbk76fofm7o02j2g5cn3f91a', '106080117489697708196077914532661910', 25);
    t('13bm05fedmkkj3cmih811g', '45512227946855270778013305435', 23);
    t('5g8cgdppge8j49f1695ifanl2oh1l', '23420870779452170989646779263011153019603', 26);
    t('6rod3d4k0l0mic61n9', '50510545435421981840252334', 29);
    t('0', '0', 31);
    t('5fq0nnj67eo9f767cih6', '8778527137266071484312465711', 27);
    t('3fhn5bl869423a69717c65m1eif50iho9j0bka', '19210103805642147226446252712767630434515948337507385', 25);
    t('269216', '637938', 12);
    t('5docn114l0a7bk2', '207097343626957148002', 25);
    t('didc6c0k28hk1551k9j6j0a547lk6ab', '259424451571890813907422054130537742940815', 22);
    t('7663148312338aa823201a0833aa4111a315026533478147a', '737078060626686169073460661351622551458807003364061', 11);
    t('f4k60afkkjh3jj8kici99jcf4l', '168030591422000297543312682719724026', 23);
    t('1tuk1gnk98sakdrj', '268546796319568703321264', 35);
    t('2fe5ec45gff89', '1708242462795110', 17);
    t('17khpqq2cba0034d4711c0n0qlk', '21146626764499735093141819532482917428', 27);
    t('54g9ge896014bc067c180', '197583741379071034909670273', 19);
    t('9bpp49hg05lgjpjfed6', '549106762305328162669533939', 27);
    t('ep0i2ceehf0hycozofuprj7c69mw', '15393314250847454087963951962903836882005576', 36);
    t('dkeko5igsti69grhta', '308044223476306846565544919', 31);
    t('533412700560147364151506123351553042070455067164', '15136684942816823221295501833940390148075124', 8);
    t('2dg4d457f', '100451031759', 21);
    t('de6ah1j792i6h94801j2i5667d91ch49h7h82aa4', '50429457718111652003697844375837041689243661530621284', 21);
    t('1c2l72df1bi98qi371hk208a31qjq', '125466201932627525943031559221363343701027', 29);
    t('977gba19e', '1417885313364', 25);
    t('140043111034404144201210434', '2693295130467600744', 5);
    t('g0a2', '390516', 29);
    t('2200230010311333101333233323021231023133021203102', '198922953943240318378080770258', 4);
    t('6353066873101558127578076017130160508', '144165800189980848048554063340548054', 9);
    t('21242641202566034126363025555154566411334600010060002214520311', '7811306433748906294071935652319422095601397419580172', 7);
    t('2jgbbv6et', '7166652508469', 36);
    t('gi1cl', '6532196', 25);
    t('5mpmf5l3qnn0d', '13529230278332772833', 34);
    t('15', '12', 7);
    t('4on8fqz2b7qt38fa2kidf3pd49fmawxwl', '296723553761811447810148760526142314377887578064293', 36);
    t('2232314414020324203112114402403134412320', '4622837608422402490924529085', 5);
    t('6rhkhhq4g0k6221s46riimbki', '1954313924165907007256835789755584518', 30);
    t('tis', '28455', 31);
    t('843220348618317110', '141498156522774510', 9);
    t('4rdmf54o561n', '41317387029108563', 28);
    t('1719c2acb576a7ac38b848daa63bb880', '511177631774649682452485037162895944', 14);
    t('11', '10', 9);
    t('d31tvva6q2', '460761943317314', 32);
    t('110011101001000110010011100', '108301468', 2);
    t('1372349637259ca9562', '143180187315524159049', 13);
    t('659717282256311982263695312406804638295363772323', '659717282256311982263695312406804638295363772323', 10);
    t('66255904a3319526575b98abb5639106a66a7', '4619304232886119691354791167430461349471', 12);
    t('fa2d', '124053', 20);
    t('18au', '37819', 31);
    t('1fe9o', '955188', 28);
    t('2d719808e11hia0i3', '1748293226855801360363', 20);
    t('34b782264683b4c8c03b489972105c', '680443750818396200684733855097238', 13);
    t('313513101344552064046222545523160040', '1219516865836938913640561312952', 7);
    t('l861', '227613', 22);
    t('1011102020222', '618380', 3);
    t('37q70clb5agn865ckd1862352', '74237408841777670888732000080865424', 27);
    t('381n0od6glk1nkho2', '77371357752513446808102', 25);
    t('393b9b61ad34', '62928172723508', 16);
    t('96boudmwjku', '33547764777497886', 36);
    t('b772g42e1e937i9e9hfeaa8fj6f2a', '119431034908791666035134911878398548328', 21);
    t('23340', '6006', 7);
    t('26', '34', 14);
    t('ia8i4el', '7121667009', 27);
    t('2b', '37', 13);
    t('10111010011000101111000011000000111000011100011010000010011000011101011011111000001100000001110001', '230735293932368005478672810097', 2);
    t('3eulm73dn0dlbv85fq0a1kww9fevjgg', '12403336167562412385040944567150574800575129761', 33);
    t('837812', '1342629', 11);
    t('234122624231456421160102414510144', '2776670000065408919554607368', 7);
    t('1333430001421122252314350034330122331524', '3566212756079222889777237710956', 6);
    t('u6g7vu3quql9i75qo8012b10j83uc8x', '633618464174594585664731042520999309975445212513', 35);
    t('927s1xbugpdet7cf0ivndfw71d0eh3d0q', '92198010959092081267985643765193993525052372840374', 34);
    t('720661003a44b8782a377b7', '22986456123373619033935096', 13);
    t('1ch1g38dhb8a9220c2aekc2k6jc4166b33edi', '640864053337562236398014189720034411222966567738', 21);
    t('3d5921bbba07fi6fi95778ig43d98f0fdjd', '629408214644536101232564875177207640880125593', 20);
    t('3ad4d290b374idhb579052e1eed452c4b40c65ceda', '95656564169281584571909173688226500498143045385593636', 19);
    t('799c83346777193da55152bb3a313d158d99845663719', '2068949030146458959617219570382689988916278523145339', 14);
    t('1355453240562410203531031534466', '34872452909171789038452198', 7);
    t('1201320221113011020033320121013312322003023301320020000213322012000202003022233201', '8941201919917841907198878463588663584033560374241', 4);
    t('9438b8aac2c05d97bd296538aba44737780930467d', '911864476827779974279651792691116485290689311431', 14);
    t('14557ca16860c7508', '891547425836696533', 13);
    t('2d661398', '494661068', 15);
    t('64ea975079b06c4e5832714dd20d', '359755626933367859228607184583713', 15);
    t('hd7o', '383596', 28);
    t('dfneaok4lo7eltlm3keflhmnj5', '114604998140550560800450290968639685275', 30);
    t('2quqi6v5ip', '130702437007387', 33);
    t('0', '0', 24);
    t('40310301140342410444003411000420304041021141232031002220022040432', '2238323181401796966396578744731682312617377617', 5);
    t('31b7ebb7e8b136deb2b30b4593ad1a775e7', '270692937955729861614382230692061625415143', 16);
    t('7cf6f4d44ihi7i', '625733239311823358', 20);
    t('117295c2222276a10451625946c486941c2312b197c874', '150143930723763569187444310649172754803478411214564', 13);
    t('1331022023133202030010033121310211001332', '591046930327775686578302', 4);
    t('101110001011101011001000111000101100110110001010110111110010110111000101000010110100000010010011101000111001010010011011010', '7673368527850305306860702856736711898', 2);
    t('1qzxuq3h8f4p1nox5tv21vi3k51', '50920381745468843583132978679805532194485', 36);
    t('a999b7a41393a14a9a5b312', '5972349927337564992006398', 12);
    t('31c49f4d6a14d5a60e3be92b6c7d09a28ef733', '1109864730568327689119301182815368410691467059', 16);
    t('bkn4e', '6256400', 27);
    t('37llr8al5bkq2885eq0qjl98f6aq56', '3042030791816242326398464933034496584602546', 28);
    t('0', '0', 5);
    t('98684568311394652b149c525bb2b8b7870c', '125020666101961535355843525380489345420216', 14);
    t('7jih', '63977', 20);
    t('56dd88a', '341387370', 20);
    t('n7p5qd', '400694517', 28);
    t('5', '5', 7);
    t('5kte56h40thm99oi9ei35', '7166982777711639280635189086309', 32);
    t('871b919770510408845b20a20', '683441136014615003034368952', 12);
    t('47321211337', '5289349855', 8);
    t('33', '27', 8);
    t('671dg', '536043', 17);
    t('1098970497529a1105663963204529a4366270', '367599383800156596794902828804760154380', 11);
    t('j1gk', '418340', 28);
    t('60163523202015310203260406350643620424355666514246323', '532226906168395704747817553933051591835925873', 7);
    t('28340466027959819372283a24801', '397312781649077687305059417953', 11);
    t('1016651ababb278b52735114a43067320725b5a4b213', '25670087069424327116744087567400672087130937199', 12);
    t('2ob9erjwdlabfl6hp9isx0pwqd', '2162440175968208142159324732902997284341', 36);
    t('58lc411umrhir', '6076908444205303387', 32);
    t('d0', '468', 36);
    t('6438156633447850200458070558', '377549095913992594176286013', 9);
    t('45', '101', 24);
    t('33de4f8d6baka5f9058ga23ef', '4199395346525371895901328042038303', 24);
    t('16408b6a2837647365594951', '10123990278705144980915533', 12);
    t('110ca', '1376058', 34);
    t('32510310126061345240566235', '4547372983380291419500', 7);
    t('165d4ce740e3046bae79a27abb9c2131020e70d73', '157696374111283237707883383886612883626999191783', 15);
    t('1e7490li81e785j9becimk2lb0o11o067ce', '532437839280281697432460793212226489874746192189', 25);
    t('1ihh485ai', '196017355842', 24);
    t('141g04patj89879', '542884791574809430419', 30);
    t('n9khp6f3l67iqfq8eaj8m66iirkk', '71244463346160860580002443985000856641849', 29);
    t('hirjvxh5jmno7f7ns', '55978446537763950133687022', 34);
    t('1044463624121b4', '1322835039891352', 12);
    t('lu4j8tgm', '933910735285', 33);
    t('9j1g51fh60kj3hk3b74g0ca3c6c8c9f5g2', '425850397149549655524432709384404177906197591', 21);
    t('2539b2b5', '151026660', 13);
    t('57a82342c455g9a17ga571f484e1b3fca0gbf7b49', '89990290894968066371722348778575965073382603807535', 17);
    t('mdpbsafb7csl4gfibc7q3d', '115378571471053973725066202243548', 29);
    t('474a338272a1a1a4a1196907567a1668494', '1194906116055811058177751679883239985', 11);
    t('18gingmssvt4ul1139dt05', '51363042207429652823989292561413', 32);
    t('2ce42c8496', '192806683798', 16);
    t('11000010011011000010100001001011111110000001111000101100100011011100000', '1793230956491923932896', 2);
    t('4f', '99', 21);
    t('9f2ibccj4bh', '162142189763270', 21);
    t('1cy0q86r37684a3f0xe9cuq5hoxk', '1424207968256042080686950649776824750523768', 36);
    t('12224530341515005031015313254204553135323542204313144542', '8811492262978145988790902373392289264937486', 6);
    t('t5wr4x', '1763445345', 36);
    t('434c5c2a2679a15a', '218057423288814210', 13);
    t('22234314204204424014101430443102442231430233043103244323130322104', '1361476455979988470036534159812062182545557779', 5);
    t('808pani', '3860596982', 28);
    t('3114060641760665307', '56720562441120455', 8);
    t('20052215130115042121', '1233946618855393', 6);
    t('18623146542a444', '675413878461414', 11);
    t('3j0ei880glmfdb76g1fgch6d6e5m876', '966695542929174813619268439440759006627502', 24);
    t('3abd', '15037', 16);
    t('321544500711356560655140', '1934109172007933532768', 8);
    t('111lwhz2sdptjhv2xz1g5fd', '17827003136890080321517837629398137', 36);
    t('l8ne8mcac9878kag0e61ni982nl7m9', '226995884117043510928077829213939988951001', 24);
    t('3tii74kkn5pj2iiomo', '254294093773044532571434347', 33);
    t('1', '1', 3);
    t('10101110101001011001101100000100111110111010000110100110110', '393269849358142774', 2);
    t('4bikp5908romjjci53378', '387494241223681393190475393084', 28);
    t('a9gn', '162298', 25);
    t('31553466646', '3450760614', 8);
    t('77992465873916625993036446511778946620300874171', '77992465873916625993036446511778946620300874171', 10);
    t('39d1', '17562', 17);
    t('25427707303456416047670142267372377104250171470', '938489360691345858919636520999045373686584', 8);
    t('233540237076312188', '39655724759031329', 9);
    t('1g10070mb0edm15gmk33870b3ga54l2f', '2775772450662354288239662524197284067896579', 23);
    t('1ip9pmsrnqt', '961402113030509', 30);
    t('33334404014320301030430142', '1118103322902592547', 5);
    t('3de5gih8i9f02ff4j2', '48309612020985608921982', 20);
    t('a59vtp', '461426503', 34);
    t('3207145150222', '912827599922', 9);
    t('17587', '17587', 10);
    t('1lci48gsc73l8srm7h14', '10614491499072743532053511413', 29);
    t('30unig', '158880696', 35);
    t('124405625444044364574470555231', '204335816074449425736587929', 8);
    t('5el9kb5ma058hilj', '1506277403735522227245', 23);
    t('22022111212012012010202100220000012121200101022021202210022201212102001010120200002010201122201022001121120011020', '759167441024557484181567645428524750251602121011253909', 3);
    t('56bo22b2rk25gnekrqt2hcbdb6rb8', '1192593196505593827607689568864200483996638', 30);
    t('6on6d5k6miquhqpydf7imhli6jvrj', '114889571277404698459666127207755422175313564', 35);
    t('1h', '45', 28);
    t('4c3d0cm6f', '354629784409', 23);
    t('km18d28ka4063o1cbdo33jah6m680nh', '58649899688819306737372660540249084938234311', 26);
    t('aa954cd38c39006a0d5d65a0b2', '13514993771256587973240014872754', 16);
    t('6f8a84d', '116959309', 16);
    t('21540300431025331403002', '305949724456401866', 6);
    t('g1h00', '1690956', 18);
    t('21d98926569b658f6028hd2fde42bh', '25351569049858465877817627105822773543', 19);
    t('28f4ybfi9bm5kiqhfdexzg6dcj4', '65002375284191780502488464831022727755440', 36);
    t('64234204142', '1870771814', 7);
    t('g6', '406', 25);
    t('11100010011101010', '115946', 2);
    t('21f7g31kje0i0c11i0eg3c002hie4a1bh79g00i0', '7675939963269437319032080266122665912099477642009377', 21);
    t('4e5de4aae42fhagcd77b1819ii2a71f7fhg8fcb0d2', '127596210502348048047227140390153976968822456518898776', 19);
    t('eedogk003clc6gei2g', '105223011043453847437536073', 29);
    t('1323314231102664064254536346523603525504340', '461558548190589236267853076121213693', 7);
    t('11110001000100001110011001100100', '4044416612', 2);
    t('7d633972a0473', '451304675159061', 14);
    t('6a83831eb7m4', '6145795507071009', 23);
    t('341534666615406346022401654625010604323314603', '55153818937912725941205585783698988590', 7);
    t('j97i92i9lld11bcrsi5b', '764101907334236165295715535019', 32);
    t('1n94df2m58nc2f292egdhj', '190478845693184355163546148587', 24);
    t('193a551506a574158808739708a326409a8232a731616', '12264564257932968384919289414304439064543308258', 11);
    t('415301137a97274285', '2089766854598334719', 11);
    t('4ldl81fik12cm3da7771d3b70bcbb8ja9692e63i', '632495479818532982131362164200507449663312253671354541', 23);
    t('1l4v5wq6v49ucf501e1aeagnbetf7s3480', '211857233605896369351266132026791700842067821353880', 33);
    t('313b62cj40gi8g2205j203kn279l7e4a85', '10738451034432329068272471398733940161160040261', 24);
    t('1012121020021200221210120121200110122122012001211002202010211102021021100111022121200222', '390318533778659728411429509673944759961196', 3);
    t('m27mglbi2lk5f5gih4ac0lgb8aicil0', '1571331400777723523482785976497721521964481', 23);
    t('5ab9da880303', '99754281796355', 16);
    t('6a1216cc363156993c7619b93bd0614a2', '31876928265786310963486391817306746230', 14);
    t('19a13581067b', '1352416871615', 12);
    t('1324', '994', 9);
    t('1i3f4a292364h6g057822', '519041051879430852117563660', 21);
    t('f4bh5e04efd4bbeaf9h7a6ee18d0faab73dc', '1312404820878713008763000090033788596202434090', 18);
    t('3nn8515hl7af', '31939448982826071', 28);
    t('101211121220201212012002012001202201102021200012112', '864510256165221257456579', 3);
    t('2knk20f4a89g98inl80hdf26kl2g7', '3938634393856186288183708257843572595407', 25);
    t('3j07djc8b21gde84120d', '51743188098385652943158566', 21);
    t('11101111111000111000010010011101000110101000100101100010', '67522678144797026', 2);
    t('139052073f74b24', '447711998083326148', 18);
    t('gfg157ac3dag139de1ff6486f98', '1661627613676505415512176639620939', 17);
    t('180', '209', 11);
    t('c0', '276', 23);
    t('99v31mgs8h9m0mi8ncqw9', '39597598618192553451515827167745', 34);
    t('1012202022110211200111', '12688938049', 3);
    t('3hpj4m7gl70rg5s986bn7l7dbjtb', '27415197316826959949133005401311879944981', 30);
    t('1g4odyx23p8fxodidmc', '9075451789279991776772493457', 35);
    t('55329abc2c3fe0m216ai7f', '206170368324589305893946138226', 23);
    t('1340009855286682649574456361871475494115109071462971870', '1340009855286682649574456361871475494115109071462971870', 10);
    t('11100000110000100010000100100100000010001111011000011001101101101101001000010011101010011110110010101111010000001100000100100100000', '2390040390567048642966647388057001920800', 2);
    t('52223564742465635082247585678534782336', '1064509718181642515244340994372031822', 9);
    t('712872119b030a5232a76660ba7', '81302736597615293178940708015', 12);
    t('ck82eq63q177e9fob2d4am9', '394072217994880709942370882654321', 27);
    t('b', '11', 34);
    t('4967a6888a214810953573018257373a97081612156a2', '32295474191633069925047732615369002936277376178', 11);
    t('818025300991552057072573', '818025300991552057072573', 10);
    t('1010000110010110100110111100111101001001101101011001111001110010000110100010000000000101100011101100010011011000000010111111000110000001', '54985654283950555052147243853162465718657', 2);
    t('3i3rcfesgl4e1pnpdl36fjst9ribl5pb1h6', '1822841056993585330595743968680994820026920032451064', 31);
    t('518835417113272363020373362806722040762766', '6945921601924648113241636640663267958543', 9);
    t('51215114114444441323115130', '148715282153752964766', 6);
    t('3gi38d7c1r2agrh', '1063253583022369377084', 29);
    t('7b3178a9bb793298669', '211348054902766508721', 12);
    t('iaej02e3j5f72623372gja8jb446af208ec0182', '509551507301561858265746542302971839802931758720562', 20);
    t('131171878520608025130476470220451332844204786553674', '694806882997751424690876571416772531272782056888', 9);
    t('kto7o2', '1094994042', 35);
    t('6hdcstaqd1tg3f1739a8plpkbbcl4baph', '1219582161259509474473107342419081037076931846767', 30);
    t('1dgf7wbm1iri95orsqjb7', '18364036674616095538201293327427', 36);
    t('13aog6neo84l11mjjqa2kk28fms9s1599kgg', '1705016958103088803360933755064603355390629893620766', 29);
    t('i76', '14314', 28);
    t('15c81512ccd18881b020', '8494230105025646245908', 14);
    t('gjebn2c57rnik5n29ojr7aqfldfm4h13', '102838449890987454302661340891009306868629443333', 30);
    t('783igc1h3b33869a72', '40730864443858836835650', 19);
    t('42a5l8c6cn', '22217784905703', 26);
    t('342j', '38682', 23);
    t('ba7282d384ii6e1ba498', '22842952907395097528788325', 19);
    t('3kob9j10mi6m70cggiba8ca9', '545573043076070981074015736460884', 25);
    t('abij88h', '1194911977', 22);
    t('7417670326016217030', '135666019698548248', 8);
    t('63687610', '123331197', 11);
    t('201120021011222022012112110220122212022110020012200210200102110222001122222120010121101100000101021212121', '90752154646385975070999099110350327711936017168706', 3);
    t('453560155', '27628396', 7);
    t('3el292bhjhjeldin8ccj225261i2fd0k7en', '1217610299685725985627264896485512835404180004748', 25);
    t('2313311021213111210010233033003000203221233313020223311311103021310113112023102012133223', '68779145291008920229511359415983281509892813113288683', 4);
    t('acbj', '184177', 26);
    t('p9c0adfhgl7pjkme65pm3c62cffmge6lf', '48235152154085152675537161376096266286876276537', 26);
    t('5gi81hd87ohf1goa0ojlc8e829gk7pmmb3', '278990742516194289085133608565402019725737015193', 26);
    t('22c61bc7b60a9c8132c791630604c6bac46c6', '28171352787129023473400908616682244220258', 13);
    t('13', '37', 34);
    t('21e006f1f9cfc', '2427921901128738', 18);
    t('103g5hi8fh49', '353276045114673', 21);
    t('4e8295q681bl6hanec562697mf63', '5339163936161554860562933482146186694683', 28);
    t('3214387157', '3214387157', 10);
    t('39ma9', '1544253', 26);
    t('3b728922be05708c343de41', '281706306025336513245142711', 15);
    t('112gj40idklam575iu', '111850377682228327449684446', 34);
    t('520424544225123253212235432303044355140441225100443352241304023533', '2034756118713909937637031846420814255105822777216881', 6);
    t('k0iolo48fl4j4lp0s5u', '24781493827610679219607072958', 32);
    t('128ggb4dh8cj8fdc566k91cki3', '1267160922429805851247593339094335', 21);
    t('1045451206214364325164', '613386390999810957', 7);
    t('1107772788549410a4414822299a234856a6016475154906', '9672542336539708087518829624662668197292765768698', 11);
    t('11000011100011000100111110110111001010010101000011001010010011101111010011110001101100110110001111011110100110010011', '63458983779334095341636694071699859', 2);
    t('41430002221022141424223400340100430110041020444223024014041003410', '2376588431552008570655123555427072543719078605', 5);
    t('8273c422025895e75c', '2406418559385510209372', 16);
    t('m2h98f7l05ai4289j5k42ink4c2ia8aab', '3246517122524761841891626370023065146892969851', 24);
    t('330112202301211213122103100103022210323100110332313310211202202013311030023331222002023', '22580453758464343463710433259085476023887934191476875', 4);
    t('2nb194h6ga8qi', '430322682063490731', 27);
    t('jpmi4moew0hzbah40iy0rgbgjkvsf7st', '34681988587068576957716048878356716190719421336893', 36);
    t('26lv2swvoi3grja39ctlr', '5165229217881148067867135922963', 33);
    t('50gf0c8e292h217h6b1g9gc7ffef4b05e0d768e', '2534050190869413489303341066801668313035183620734', 18);
    t('75742', '110035', 11);
    t('h3c9f2n', '3276752903', 24);
    t('ksmurptv0dnfdahfpv5t2ttv3qn', '28444102905166388726141858508924545634135', 32);
    t('k4g49523k4gj1ima6dgf4l9j2bhi5egmba1', '1707736842966246461835311670413679917106063130033', 24);
    t('14624322306021144203510134', '60398430088699424182364', 8);
    t('45h2d09g9jgf8km8m73d2g6i4m149ieb0', '159828027787837356457234355582069560638186013', 23);
    t('293e747', '29816392', 15);
    t('2p1h8egsiaapppbd2alcp8r', '426308484322430923493844090113709', 29);
    t('43433024234131230143201230', '1427229136114037690', 5);
    t('289a4633', '98006151', 12);
    t('41608955313b1911a62765333599a23676423', '2924108119384944390066125637461201476059', 12);
    t('diqn1r7dg7d6qsprogmqe2r6qdgja2ba', '29481647088004232174662553215167090041336899916', 29);
    t('oj', '859', 35);
    t('2gdf6532dab77840d6a5114a0gg', '293251122577439820618448012407740', 17);
    t('18rpho7m8m09qsqb0gljfei8af80j', '296852593993951607772214947149628004912219', 30);
    t('24keb7jdl94mfm', '1930409257079544574', 24);
    t('1674442410', '250758408', 8);
    t('1g7', '568', 17);
    t('4', '4', 33);
    t('5c59e4222e6bhi0djb7', '3522719264468518688329651', 21);
    t('1220560661202652130166402663055101525606330601606006331303252', '675150095126381288896084826641786137855807876233627', 7);
    t('8bdd5jmb776gh24h453cm5j7985e7gk5ma5', '169186553911260540940677935317019936465424663620', 23);
    t('527635172', '90126970', 8);
    t('277ae', '379014', 20);
    t('601248508516016121653034235336305447350802022167218600', '2260213996246938282352523423961800103525210629322720', 9);
    t('7141002130726144240353615134174321', '4556862540217805685823766591697', 8);
    t('20907952950099a0198619690a4', '2472922861761322996286447619', 11);
    t('ea36fd1clfjqe5fm1g2s83nf47g47', '1270443528906376270651074312814971947683121', 29);
    t('101111100010001011001011101011100010010111010000111100101000010011100010100001001111001100010000111111', '3766029900593721359372665013311', 2);
    t('998b3480cc2535104921e', '3205175075301584736233354', 15);
    t('a8lcaq8o84hr8k71i2nq', '62871767920054444800492313760', 29);
    t('2cng1gia0kq5mujipjbape898vl', '3263921313975839853748035663784831132661', 32);
    t('476bd81afce52', '1256456203521618', 16);
    t('5d45102dc724852d2db67b51c9b9a77d74dd3', '1084392974332641207686512234196875228047773', 14);
    t('4815230672045132', '1010606396855429', 9);
    t('1v9kekq', '2124036762', 32);
    t('74a', '3181', 21);
    t('328a53a1007307b61942065682aa46', '63859486675999658099313593314134', 12);
    t('1a2b71b61a194aa8aa308521795481514ab29a339', '27248586215670941038987160555872821966497373', 12);
    t('33310200313011302122011', '69579394459269', 4);
    t('12202221120012000022122221021211010122121121202100210120122120102', '6610763645257536623940916016153', 3);
    t('231ogcf3kkg4pig5m1haa9nr1k54a7sqq', '131862409594175767861875835443409445020844276370', 29);
    t('d6qe4em8u38u', '926445109477491562', 34);
    t('3eh2c5b9cnkai44ii8e0feb3jb0h0cf5k', '530433754311027126180546490781321137757629004', 24);
    t('315ag8333b315a8458c2e27', '3615724227326593741564426512', 17);
    t('34158', '49431', 11);
    t('3ils27oe28e7', '91557914807141968', 31);
    t('edn2gblf7n0banus753dpjdoe6h504l6a', '7642629969726378331747823898058942648773832841239', 31);
    t('708a23436b28a0331221a80a1cc36', '109326184942549365525657861606388', 13);
    t('2hk9kj1c8e569dj936kb4', '794579205969206004082283587', 21);
    t('122505415330540034050461630624613221516550102513164104620053', '97354517682441334188608404808066903954920393510893', 7);
    t('2278502839268387241756', '2278502839268387241756', 10);
    t('55t56st8qhj3c46de0e1cocd0o', '99849784143466753187227752067831344089', 31);
    t('1293', '1293', 10);
    t('8163a159h14c271id682j0419412h28j5gd', '1385631680048601439082465294762283037255834333', 20);
    t('33103002234130422102321400', '1086244791478948350', 5);
    t('o7c7dlja7qnllqglace1kl5jji', '14766346445976221588816768352790750827', 27);
    t('50581gee4ef2g5g9c5b', '522201912074626183642486', 19);
    t('132232201331030203102313022030032032030013022021203311111313320331032001132112031132231322', '735766436167284912814914395757285842906978477229337466', 4);
    t('a', '10', 23);
    t('623150750562117510607143030162837240736', '11425818336940049045139902134722023322', 9);
    t('1n9353d6cb5k404', '122447087321171523044', 26);
    t('28ldf2lb7d7cc25a33bfl4', '94283647489871424522663101176', 23);
    t('339b79a42943835492239b54023b886b38b99', '2352685629298138350299211793902313821093', 12);
    t('7703554633327072657443651371706621271374', '1309663585734465506833205292089832188', 8);
    t('nbagqkohqn57pj7r8i4i', '506352586652779671862372959634', 31);
    t('1f1c9hie6h6', '10999559699306', 19);
    t('84c5f2554693b9f5500f5bb85b158fde13e1f', '185058871763639409971122557584749513555394079', 16);
    t('21210021110102020012010220021101002010100212022120120220102111211', '8913855519363454596688827191062', 3);
    t('1k4g82kbq0i3a', '599743970399950235', 29);
    t('232221321002323112330020033132222223231021231332112', '3696354442389518199954992455574', 4);
    t('31', '13', 4);
    t('2fl289c9g37788lk851g21', '42297178746901523108180433621', 22);
    t('gm06jwlv6dqleu1dip653ubs', '10360002803920470539953905454083262792', 36);
    t('5975200c0c58b4a4209dc3bd9bd65351c4a686953', '39765261669001283521985826220442639112464102333', 14);
    t('1b7eaehgc6na27qdj', '1633286773621121735715251', 32);
    t('19c71489d18e3a0980e42cc36293cacbe3', '1071329852165428379062747217653305005688', 15);
    t('a66j4br3o', '5109925159442', 29);
    t('236k3i37fdkaca9ggce9488a', '16154458171800913743319566344714', 22);
    t('547c3cc0b090c099585c166c56caa7b0c', '2370956445374590211607145293779895329', 13);
    t('31c6l2fimcm94ehd3mfe3jmf289iamk83m54cd94', '392700371206866291770648353879270744554067295237496903', 23);
    t('49a83c6874d02a9b9b81b4', '5501733310687036523031026', 14);
    t('1i6aptg1v97t1269a9nfx6', '222397813672483505273091300846188', 34);
    t('6430553763248061224028267601063731268', '146036643954511589188331459488427555', 9);
    t('22777415000440655526', '342256872923028310', 8);
    t('3077216', '818830', 8);
    t('g0869g953a5a0689482id9ic', '4131232785565176280208325038394', 19);
    t('377805kgi96dgc9mb32fm406m0f6f39c7i2hg', '34922854162614667688896860620347909170055951885512', 23);
    t('34', '55', 17);
    t('9mo72jfoon', '53654687111919', 26);
    t('17em8okm0dmnf', '123219026310591941', 26);
    t('ojfgmec3bh5hn8e', '923316247884933873964', 25);
    t('300449c1c3e6cg7', '1124713376756150983', 18);
    t('148468717751060247811551716501887635', '3879291235122751908691549806834740', 9);
    t('2111111022002222200220201001211120011211020211120001122121112210', '2861089797219981690788113774269', 3);
    t('ba86k1hjmgc2ka1b188c3ocg8mg7', '633561834955856968092087110467408732907', 25);
    t('7', '7', 36);
    t('101111011000101011011011001000010010011111001001111010000111011111010010010100111011110010011100010011000111110011110110001010101100010110010110001111011100', '67630990462245519904689419770374213484683027420', 2);
    t('lmnopcc579rq1d1kecrck', '1913989049548883118555149674260', 28);
    t('101', '26', 5);
    t('34243442230362323775450370', '133734900702608268611832', 8);
    t('7705c09763f0c8', '33501846960337096', 16);
    t('16b68084359212420b42a0b466', '1507498439245168038118909134', 12);
    t('3422230204423244344144431342004202323331033340410420130', '216503932187688762113715510289005560665', 5);
    t('bxg1asoyef', '1211512806561831', 36);
    t('100qrn', '17231531', 28);
    t('14376376532381875', '2764823838681551', 9);
    t('341b85880261127b4a4501bb59989072003', '16474978878686249530126059882195408003', 12);
    t('34m9643moi5645kloff0lc2k8', '11353733191493162765109958504486133', 25);
    t('1gjmm4me082gf7bedmn6944a48d6c3abig', '22657993401538002512673217109094636311397819841', 25);
    t('1dbfd0l6', '4028639324', 22);
    t('443147117026070130387352', '39737724767758401461831', 9);
    t('770344133547754604246147776', '2382177288166020121939966', 8);
    t('34806170568316', '34806170568316', 10);
    t('2000220010020110122110001022122021021002202002101100222000110111011121220211211210122011102220220112121', '9430263244564363699327129166426166870352926916807', 3);
    t('0', '0', 34);
    t('1408054854833732408165393468129134240219856072', '1408054854833732408165393468129134240219856072', 10);
    t('5cb3132a8b90c8cc5c8d10243b', '266140453841238714299979326165', 14);
    t('152270', '1847985', 17);
    t('14111026000144152', '53012937079839', 7);
    t('514fb06b03ae4e191f9375228e62', '1649188801468585902988396540890722', 16);
    t('gica0712b8g45ji39dieeihj38b3c9ahdh412e', '23270135840441636506607963274541746417908332352454', 20);
    t('1fc020c94aec1d384d6939fc0b55b6275a201238e6', '46403408144166737594428754848567058468276133837030', 16);
    t('23340350340466132353555624150', '1150738817150733757069179', 7);
    t('10253000316', '298475673', 7);
    t('3el911b9jkj3eja4cd', '243839699882594291978053', 22);
    t('2l8275h1ile71nccmm511b2bdko2', '1236657450961741770578027094047122672829', 27);
    t('1j48ldn30atne4g9pm319ajs5pt', '416383185377779055815558205572990151279', 30);
    t('ef3608f1c4e83', '4208245717356163', 16);
    t('10ioej21', '6288902551', 25);
    t('120111120110220122002210020', '4378424224299', 3);
    t('97h2dfg886g4gi6b58fhfh911', '46126311918607212312965582703752', 19);
    t('d8gi6', '4433334', 24);
    t('dacb2da4o9f7k2n', '1464835209320250160295', 27);
    t('1oamd0eekoi64ehfabi4n7m2hfj5n7', '68606278289505370536462171548139088191207', 25);
    t('263595cg8acc', '81034230587588', 17);
    t('ellacdbn920kpgec5ei217h', '199907295253233852870341333748187', 26);
    t('203301330211342344224021133433344413034221', '97522914206952615171825908686', 5);
    t('26f92kg780dme5mo5g8b1pa8mlb4i5', '243826089597210290299504496901549601839025', 26);
    t('1l4k6gf03', '150535071740', 23);
    t('1fc9v2l3l3u161ewt0asv7ptco733c6f', '173787731730491489596204621593808047374649391899', 33);
    t('3d', '97', 28);
    t('10187086a12014347597a7', '7509462547837819682131', 11);
    t('142314040103301030333323', '22732398342042963', 5);
    t('51j5e99d3j48ei33dklc148ddm38hj31l7gjenb', '142386292443578000840331039336729798455275663535088563', 24);
    t('14e10g9aafbd5aeac1f8784h558ad6d4b636e14', '634827726136703092193623226005666297523516017966', 18);
    t('12laj1a9j89aed9k37b8cfh', '1023636874052341758796882576386', 23);
    t('5016208620292365704037092632106487328146733', '5016208620292365704037092632106487328146733', 10);
    t('56in43q1ql8085cdn7vopa7t3ngoed', '566008935658169643200168161957539183036996844', 33);
    t('22s35pn5i1', '96833203005232', 33);
    t('21g58a423675gb1gd43hb6ahdb5cechf4', '31056550222828623762491892131048679702550', 18);
    t('m2m7o1mk5n5iem1nhg1m60t99k', '187177916478689826036137763116654591390', 30);
    t('224bq', '1467049', 29);
    t('2i26b4g863ja2f17a857', '37922279694690532644554800', 21);
    t('r762346o82jt96r1sphc5jabqgqeajk', '5608490487827560829488032592521356647934247590', 30);
    t('ect4olb', '31249474175', 36);
    t('1020002020', '24117', 3);
    t('1dk9619', '1278426989', 31);
    t('1000101000001110001001001111100000001100000100', '37948338602756', 2);
    t('daca1a0aab47147cb69b3c70407', '8680663224967641711152705530951', 14);
    t('1303113130113203223212212221102033230300310201103302321232332332231220110012132010012302', '43163657603938060665271546922523188912463705523372466', 4);
    t('sfrieq23hnbt055don', '368445731443436833015197443', 30);
    t('i7c03j43e885j77ce94jdjahc', '308365645364868380135794239036352', 20);
    t('6nhf47ej3f2e7m808h', '4044367825426498856375217', 25);
    t('27147380099557912676606433547302', '27147380099557912676606433547302', 10);
    t('csufgg1smqp3il1ri5pcgugua0fr9kfs1', '18860343033998469134466167856463713999512137252737', 32);
    t('5gbg6d513f1cfbfb8f23e26', '7026912409111194787384092222', 17);
    t('67beb095466748i6g6f1c16e1e1c0e', '77643205100110837901641527913924838755', 19);
    t('dafoc28d4ihd844oj09', '195367712290739827433590009', 25);
    t('2kd99n7e3f7hmadjg972ie3', '6614458529250547048035239167443', 24);
    t('1110100101100011001000000000001010011000110001010101101010010', '2102165078632082258', 2);
    t('50313234404041444204313100205345520142025331140404044', '148127386264832747696142468115120225091068', 6);
    t('4frs', '122338', 30);
    t('2', '2', 5);
    t('2c7fh', '2211743', 31);
    t('521627769aa9903ca2777282a9704', '80035204419629686507847889516653', 13);
    t('1acb8e8c35bb51f0a97f', '126536489245502589675903', 16);
    t('fhgj743d66d2afb82fe3097ech3k02de59c', '69380446582614420752469037047577265610011498022', 22);
    t('13ljdao15c9kqq80lrprhomnp8h', '285719325945344921748137856736984663757', 30);
    t('aa694h8gdfc5egi29ei9d76d60bcedg95f91ci', '2172203053088265616832262859897091710533691361277', 19);
    t('117eacbdcefdf0a6a17f2fff826d4a3757e9a72', '6242361556294202529040777632205572383849749106', 16);
    t('nbron6', '784196326', 32);
    t('l61ce8p6n9mbm4eh13p2f83p4d', '5027409891709818675841213415466148689', 26);
    t('133571757441551116445813870017686612348244840615', '974429239787874369080373672137480024198248529', 9);
    t('2de56487c7306e350a2804a1c7a26a750', '126433237955384861849183674345949279775', 15);
    t('1t0eskw02w9j0787kjvhllsk0uorv3rp', '554365961922175577358851876276185152369421121763', 34);
    t('19a90b5297g', '3156751459983', 17);
    t('94af3ka81ai04agjdd1jf9eh02kcb05eh4c19j', '77019278316732820000275934466986562978818961285944', 21);
    t('2arg5f1tbbo', '1395878631103254', 30);
    t('hfol59rdpaif61d0ffs4ll5l5n', '63700684237192600496984163750362294029', 29);
    t('523215407441303043220321763763461205763333647', '28862443771771851434414707295001265420199', 8);
    t('1172558', '638333', 9);
    t('24547788612b797cca89561c91685305c', '1035822093635901600043042970084595452', 13);
    t('297357a6913a0506230864ba0a40806999b5', '165423726645441709448459506175417770841', 12);
    t('3nv1t16', '4811349054', 33);
    t('11', '3', 2);
    t('dcu7kkv', '14393004703', 32);
    t('74jd2k05b41hi19cqb0b56c4ogldk61mbnec', '898558171987652192588434184021750232818244947634099', 27);
    t('87017232bb16a097aa683d76a', '27322467806827082697027163842', 14);
    t('33315524233101', '46920839581', 6);
    t('428613775532906a631a669a07b607262', '1861425910744005080289960554061159938', 13);
    t('2032312224134213012123140122124', '1994223287446852270289', 5);
    t('d9g3jika93bf6687e', '82311084389009274810693', 23);
    t('4g3mek2', '696240109', 23);
    t('2al', '1993', 29);
    t('2790a6bb3ac09c4132a22704d2d547', '1177464169231489879646847630186327109', 17);
    t('ac85h2b60g1f1bb9443b2f6140gf3d23531c2', '16553297321499287941274783612999953493375468582', 18);
    t('84cbbe378gi408a2g24c7cc701', '767458631826801795787229605068011', 19);
    t('1', '1', 24);
    t('2545050224042355443043313126144254255442454', '876893815708574640678938176379453669', 7);
    t('96mg2bto', '253583237819', 31);
    t('103257515380518060751732276470265252833018424', '1009215289986412660969292628675150865766422', 9);
    t('9bb', '1675', 13);
    t('213061078bbaaa19a59273794a46402467905220517', '4454029219153574030222038736662990993813474531', 12);
    t('1404', '1404', 10);
    t('4hrlw7ejvwsf5ks8fw1kakn', '11598871980554104486046361604542989', 33);
    t('hwohlkmmd0wcxl496krx4kuvu', '204793993426728369555445184850179150990', 35);
    t('hxokubeca', '40450292757955', 35);
    t('3gp2122gp51e1jmnlmc6jfe69', '81710274994239238611207516341652249', 27);
    t('1742', '7006', 17);
    t('1222212003002000102423324020100242030', '21822773039447439961337140', 5);
    t('542400122414150021231341152142123', '45688850379684810973948803', 6);
    t('113142622818152826', '19181680787913279', 9);
    t('1725ab', '1516971', 16);
    t('cd590583dd0fb4d2bccab06f852', '5523664634945639953514439685775444', 18);
    t('fcqdhgpjd', '10123224125083', 30);
    t('11000000101111101111010110110101001110011010001011001011', '54253158045164235', 2);
    t('5b52e5ka259kcmfeg9bam8m', '4982195858013579020225977318933', 23);
    t('37102705430230406225007132550325075', '19731384956592254443851247364669', 8);
    t('62187847341581405083883177441', '3269223553709039612339577952', 9);
    t('1', '1', 7);
    t('34acbca', '16279598', 13);
    t('7b1dscibt14j', '186913558166857804', 31);
    t('3813872748312506470161272871424048420854', '64160413369317212332708670220456731959', 9);
    t('1b509bg3', '2000076723', 20);
    t('19', '28', 19);
    t('1e49lnh', '382576217', 25);
    t('1011101000010110000100000100111001010100101101011011101001001011001111001100101110010100100011101011', '921454163161847327849553938667', 2);
    t('26654765110654444621720', '210641979748604126160', 8);
    t('4', '4', 20);
    t('233j35tjr8i', '1242415162527558', 30);
    t('2ihc6g5', '188418725', 20);
    t('14514222035543505233324403513154511132', '112236158532531500922346262912', 6);
    t('11780822188440823003268608463462043302170765', '130234632675642352830843282842679037904699', 9);
    t('ca6g776665362g312a759d0hc289ah', '31803568025214749779356446816303550281', 18);
    t('3c2143412ahgl7gkd7dj56g4aa032edl5ab', '15579825921597836295227254929575079744069515235', 22);
    t('b688cabb4a880463a00', '1294695345930300972346', 13);
    t('7gb84b2e8ai22aeja43fhj', '16417614158933628179168670359', 20);
    t('2b29fii0ffb453799099', '5116039768857765569837805', 19);
    t('4j0fl44j0jifd0db5m1jk27lmb2j7g0', '1221597028986776804949762637681448487662400', 24);
    t('1102200110020020010111210002120102000110001011102010110012', '2249432091384144139655815631', 3);
    t('575257272', '99966650', 8);
    t('21412332322000110322224410114133331204441322340320331022', '658469531400806135753913612265079464512', 5);
    t('lbeexon7mjw0a', '72065470380896239460', 35);
    t('11002222122101102201200001002221120110010', '16658525175081901887', 3);
    t('2cbm6ghalhaf0jecd510eh8', '14205312878701722696609668368558', 25);
    t('i5f89347h0j3gi8h4677fi5a04', '583695524553451988357837938643879044', 24);
    t('2jjl4mk2ba6ab4f', '104001036849709538240', 25);
    t('11011110010110101000111111000110101111000110111001001011111', '500696147126612575', 2);
    t('11201020021211102010000011211021101021120202020210002011110222101120021', '3931899899409076416396361943543530', 3);
    t('132', '30', 4);
    t('1ah3g6f9d9df1g3ided508ia48448d6hhgbgea38a', '16965212814601045549441068611275594500781000437521370', 20);
    t('6237a6ab64112b2494bb05a722886a55a2540', '4388944420159332022712765742793042396800', 12);
    t('q72a', '859210', 32);
    t('120412252325053420430240504004014444424440120055', '5062770525903140764486411269774590627', 6);
    t('295d4bnfaqdpoc1b20aqjr1cnbdbkpe2g', '47436826040024452612254699971551679789734617832', 28);
    t('67716235176889702569725884201488570294266282909281', '67716235176889702569725884201488570294266282909281', 10);
    t('2053235221113252151103025044', '2205439986612091266100', 6);
    t('331', '127', 6);
    t('135411345210555202432511042142510325514134213144343430525350045345', '630257158895680511354194148657769220873851791365505', 6);
    t('ncgw536u3', '52596306137028', 35);
    t('1br4', '37714', 30);
    t('ar5cg3h5rj8jpdoe3q4cq3enr9', '16565568581597008816111159366077297901', 28);
    t('dgmjoauv', '464615386079', 32);
    t('4411066504304310664', '7482831387322120', 7);
    t('2ie17917j22aog9aaekd76', '3074217943693005788722019767635', 27);
    t('7jhwhw5hwfw6t8u79', '24155077979418001247241407', 34);
    t('2b8b00d67a9af7f532ff749683bb', '4464429849532419014043873313196703', 17);
    t('333201021222132001303333132200222320010300', '19197132799297047545741616', 4);
    t('1o2rba1ab625lqg2ap4tjf6db5chq', '5706946668967398466318375257987680829296303', 33);
    t('3ba90478b168103a7864b1c6b0b62960bc316', '49439560619910889109663125468488809074137', 13);
    t('uh39vdq366v29506mq74', '1209595543050368363395591923940', 32);
    t('17a5881b485a3a3729b621ed24851346eb44e526936', '37635985091401630307879776080822155210816748779826', 15);
    t('3', '3', 20);
    t('1010101001110010100011100110011111001011001010011010000110001101', '12282035710234042765', 2);
    t('3p7o5m2pspogfa4rln8kaa', '19871208148630067099353934028190', 29);
    t('444hc35i9e91', '492075654378634', 19);
    t('dee149', '14606665', 16);
    t('8d6lcpobjgcx8r79vwo91', '35747137599516159959965340852451', 34);
    t('1313a30663415072a5378a573a5004618', '2710898421116005898719133773622357', 11);
    t('1a2ufr79n7jkg', '2177788338840118042', 33);
    t('11123413012404012202014420304221', '5877498546826679463061', 5);
    t('321413111412432', '21207529117', 5);
    t('d04552edgg3j5i30d1aebcg35319h5ce', '279401733817838264163142101327955396778254', 20);
    t('65230302412105526230540564112431212010546410325343324336355', '70128063903609250369648995014131506639349252995600', 7);
    t('122135222500433255020341512552123313545535005021145045415', '52664708035958260940426227456273342924406099', 6);
    t('2405352063454611542614252613643', '58322141881707592214580663', 7);
    t('331', '469', 12);
    t('15', '19', 14);
    t('4og0nttk27itgb3kqcm6if', '50395967140764173858035932119955', 30);
    t('b163a1d14c43827424b12db', '182084380520360792772703409', 14);
    t('0', '0', 24);
    t('0', '0', 29);
    t('10bqg3q7ide7p123982defon7gd6gn4', '8871455511993695280948914558473713435679678', 27);
    t('8b5i53jdflg33amn975o4em75rl', '355133268860557842919835043492122626201', 28);
    t('iif46p31b95vumvcu7t4', '2324168331442784232456379135370', 34);
    t('2bu5a91hcjjf5bvs4llmt3mlv', '3154536200599521483056493747395222207', 32);
    t('101776827305203208883833456438314282601147', '1361051538453470393031244031499904314100', 9);
    t('a7q6ce8no836pi1dpb1h855ifag0e', '123260072425789697349589714923797010531053', 27);
    t('6an46', '4507041', 29);
    t('c85100972abcd17099d6436265a7d00037d15669c2a855', '47428482751140063971988445268995152371199255649614715', 14);
    t('1001101010011101000101110010011010001010101111001000000101010010100001100000110010100001000001111011011110001100110111101011111011000011001011000100000000011110001011111011', '3615489279593509708772217418002107077942788107657979', 2);
    t('472ac263a709338a322', '512265232277236694323', 13);
    t('3bwf', '143235', 35);
    t('lakj6bpeg7qk1jhp82j5718p7dm00', '708768256027400694345310993664646688588064', 28);
    t('3', '3', 31);
    t('3l5g1noh9km1e4lnlcmi7hk24lkfn584', '83462512429809308449012708265095091998409579', 25);
    t('1602o', '1102353', 31);
    t('bba2100668676a123b8969745542cba', '31194377870767966662985925118106525', 13);
    t('31536413040', '919850568', 7);
    t('200110021212121222001222201201221002001212122212121112101', '1073167764274370737333513450', 3);
    t('8d5kj4ppha6o5yywbpaork4lfwln3', '143529562916204167813572705035194801747117283', 35);
    t('115200231503212201324113232151432415611206413', '19119837827416003266077275103148717672', 7);
    t('h76b5b9dhebcf9bd639fe3342845c', '11099864955326032429942032083370594653', 19);
    t('278cbbef4c3b7a5cd3ae71e1', '12240052494575754714578579937', 16);
    t('200020121120002102200121210010001112121200112101112222120021001012211022021020201200122220122201211012022112', '2284936355530730650861310432484515232422851367913401', 3);
    t('730d9080c5076bbe550c4d', '35932875541587203941802773', 15);
    t('7207565613527210030', '130876365269176344', 8);
    t('55a3d', '207815', 14);
    t('3g0s38r3bt087aqrmi1tn79ia85gmeh', '1936565240398482832728717768927271259807794475', 31);
    t('1i28p44i9akoo65c8oo9f3105g8kg30gh5jg', '56680776457726013494388507242577969396880764644890', 26);
    t('40hli90fef115b2gbd', '568985677342288643620301', 23);
    t('5921161174358003708931086151189129598336753', '5921161174358003708931086151189129598336753', 10);
    t('7b9ie9g63131ge5961ckc9eigg2dij6d7jbi', '143022933563074189781666359143199930960782247692', 21);
    t('1fjnlg601b60e', '362500102776455854', 28);
    t('2570b2cd172507d801138abed2', '2966320491435734983427362569938', 16);
    t('16d7r26k9f', '13024515303115', 28);
    t('11110012020002022', '63875771', 3);
    t('44uu1', '6945049', 36);
    t('5roia7h50d72egib8dc0kbgibgc3181l', '4362559620688171285632591021024625499868373361', 28);
    t('7a61cd850ab00f4e75b8fdd', '2367212971376424991309139933', 16);
    t('2ggm3d7dbdijij6hj8dh0fk1bki55l11de80k8je', '349289245969708219829891150618982716299609391061246124', 23);
    t('6f7bissn1u9k2a2nds0jcyqf', '2099343598521464701612621568865662700', 35);
    t('1j50dok9ppnfnb712ai17q3aeogebg', '1563779391961982516054733166515013611227172', 28);
    t('100', '121', 11);
    t('152003747a37c191079b493a', '58307629840901487900667265', 13);
    t('12a550842495600aa183242674b9354cc40615469b78', '964513977187218862668336384529626864441099542359', 13);
    t('1', '1', 7);
    t('1010010111011001111100100000011001101110111101110011101010110000011011001110010010111000000110101001101000001110', '3363864999018073552305148875414030', 2);
    t('2a388957a5626004a648219068853a80843148917a', '14639334203511394499271219968495476019919238', 11);
    t('178qmhlmomjgu6n907urpggfgm22bad8t0v', '1836865714504113766258732956737909765209405609243679', 32);
    t('39qp1ndaj7i2kcors0a2q9g0c3tgco', '22852659824082944134646404893585993114827784', 30);
    t('1220243421341234055245501432452205215131515413023', '31231684169839893198944772635028600039', 6);
    t('1003331113233012121222210121312333011', '5014483212176774885317', 4);
    t('1460300646123356400652060261434153321405542062433', '62217170078805469818735068808101425405148', 7);
    t('618c3a055efhb78dfa09e5e064', '146515377058619956051290383262640', 18);
    t('3243111303430002444312342434243011132433431232433320413034233', '3110380362244237009969587203947233566143068', 5);
    t('34ckfdrm4akdmpf0nmk3g9r97m6635f', '234784623328429291304866563544367892203497462', 29);
    t('2fh2b', '446851', 20);
    t('2133221031301122232332213', '702121681547175', 4);
    t('4dj5f7a9kmdkd6ib7h9h16jl75lgdg1', '39344152861693838773867535837606678058786331', 27);
    t('386bicebii369h1kc4k00e7h6j4c85ibe8e68i2', '596047102194584014318473702865419545819037150251222', 21);
    t('252c', '34437', 25);
    t('1c46b1c9ef8122e5c0809', '2136485514231402911762441', 16);
    t('565273142344', '179884362478', 9);
    t('fg8ckmivf483', '558741734364254467', 32);
    t('3ff3kcevj5hawuhshs34x3oi3vx', '22740752524651070386437452324283746717307', 34);
    t('10110111000011100000100001000111101011000010011100010111111001001110011000000111100110101111111111111011110110111010111011010000101010100111011000100110010111001', '2090116485561415533220743961894899901833660878009', 2);
    t('agc17', '5638120', 27);
    t('eglk3j68dgack4', '12888395715127982308', 24);
    t('28gil143c52a', '5595221231831310', 25);
    t('66c152b47c14a05b3610620', '20983529061179635723774027', 13);
    t('15dokhdbb5', '70366773099039', 34);
    t('1a9501016a5512889b2993544451938993b91652b234', '48223308327186227572954772551054429866630121864', 12);
    t('159a345bdf44d369a', '24905827046438811290', 16);
    t('1461e', '65504', 15);
    t('32d7b08f520g228ece8bff5', '3716536139742781837934428348', 17);
    t('101001101001001011010001100010111111010000001111110100110010110011101000000011010111111110011100001011100011111101100100010110000001100111000010001111110', '7429426803493479456828449389493437652073153662', 2);
    t('6kc6bk6g03', '131487097676403', 30);
    t('34hvgrjns4o7', '411305032746097063', 36);
    t('45heh87j', '25806520819', 25);
    t('2b3foie8kki6eg7kg8e1j2jb83ka43', '2224972752466567394372343513970647975249171', 28);
    t('1b51n4bcb5573mk', '53946798171681752445', 25);
    t('1neq6n', '31675359', 28);
    t('1606', '643', 7);
    t('i21d7ef5b658jja4f4ch63a6i7jflah1', '29580131903402267811587112773000293466018906', 23);
    t('1crq7057b3lo5bfd1p0bmrf6i5mk0bn6bpme', '2209991301392227713894588972684184312154769557819480', 29);
    t('1tk4sj7hb1btm', '2220446801040814006', 32);
    t('2582642852065202685367571622548333884509', '2582642852065202685367571622548333884509', 10);
    t('ddeh10je03104h2gj9d297e005e25bf702', '117571564833759622294922629069619346065882802', 20);
    t('7dd0aa8c145447eb92707ad1d07', '159489590003544512404938984070407', 16);
    t('6pdn173bn9eqs25mnf7go8g6p55ii', '609026075406678657195419482812059187779088', 29);
    t('c9h8075jkbgce2bhje7ih029', '32124773769478466147508433993026', 21);
    t('5e47t7mbkd4cmfkbka1e7', '23078675295563054872571444265175', 34);
    t('1102212000221210121011', '15052511263', 3);
    t('kqnpjm9mkj41j5gq92a6en1e3p53a', '251372779390673891723478386066935182969151', 27);
    t('130c449gf', '19695443734', 19);
    t('60127615404142232301236257126373142705430101557417025270', '281610543490460264519467262765660796455848821664440', 8);
    t('d5ao0joon475j', '787826660155535769', 25);
    t('85099cba', '526401184', 13);
    t('orjl0mf2l64mih7famg', '5251853940693847762549796320', 29);
    t('24b44822469ba933aa9cc564a0b792345', '780612549310309792407655025164475245381', 16);
    t('1', '1', 12);
    t('308b94918920047775b056707915397', '726935161157046423838017053561059', 12);
    t('10101101101111010111001110101001101001100', '1492415632204', 2);
    t('1af515d2006312ae69biha', '1120313283402535131518464857', 19);
    t('13', '12', 9);
    t('4244', '1502', 7);
    t('4724f245n6f154h089', '1249114287744755126982345', 24);
    t('13243040401001003123201', '4093805177786051', 5);
    t('11020002112000000121010022202010112100222210221102110011021', '6634494201815577732081058297', 3);
    t('5b4dgd', '28394225', 22);
    t('6272ha', '15166304', 19);
    t('100011011100100000101110001000011111111010011010011001101001010010000011110000111011010001101011000010010000110110001', '92021749248802288107686447118623153', 2);
    t('2i40qec7pqjm10', '26939109963617553388', 29);
    t('402104a166592b6016aab40a2734702872958605', '4916982450386947278439429436768334682151525', 12);
    t('77c3922084b82910c3086a43cb03a4', '1533937693030670114672009321321763', 13);
    t('37f3ddigh3fa1e31g2j45d62aeg4gcdh56gg9', '232818880109822059294086716237622233513847254729', 20);
    t('151a97027746544a0007496525666a962a', '34163769708560970311913160174313395', 11);
    t('24n9g1bf55depf641q81qfgj2q3efd', '704762263092344530284533783215679804998393', 27);
    t('323079876474415845475805249641768917', '323079876474415845475805249641768917', 10);
    t('k9ghe4a66r5kt8euaf4l', '804063141258299683011907894421', 32);
    t('1ljejem5hm57gjjpflpe6kml801', '11306564293793981256004374145021939273', 26);
    t('2a0a2b05a7', '14649964111', 12);
    t('7tr60m', '412336247', 35);
    t('11777165574076763721455', '92219848663426376493', 8);
    t('4llmg19ke36037l9n', '211068244533390000747325', 26);
    t('1k9b669', '218681021', 22);
    t('a5c3b8d2b440bc7c99d', '15352022411228212540798', 15);
    t('145124424214052201111155025520222', '14423786224168117069403798', 6);
    t('78a3h7p', '11190615491', 34);
    t('110202011101011000110020211200220101100002000222001122020020221010002001210221112100221211000222100220110211220002', '1163746839236428869432018441230348532163437184859997503', 3);
    t('104502', '18426', 7);
    t('2ccl1dcoa9ke9n4acjoii97cio4g7hpn', '181430764600829521764547344057062011723425949', 26);
    t('1g999gge8f', '234124479585', 17);
    t('2102122000222201112100112012201202002102100', '265973195855731931784', 3);
    t('17pm3mbe4', '484680719548', 28);
    t('3ffd9eb2i9bjbd3kffdhi6', '145319854130204054939620248184', 23);
    t('7c6bgjabk7b77cb02365356g71462lf', '141625763379595196233525648980420679263893', 22);
    t('7hjd27j7mi072ll5dj6166b0701ffl', '24036455572105994456221585880207038384542', 23);
    t('1drm5e6qurifp4c', '2578009544187725538837', 33);
    t('hhg1ca1h1e44dehd3cbjd7', '37518475324760931197003615867', 20);
    t('1lj47hb7l5mcmbf1cd42h1hh36cjiak0hbkj', '891983220438694620232014357960845056377943934222', 23);
    t('1uhkcq0knndgar709ggbgktfq2skchn81s', '32579224663928263100000786859064490006605648315352', 31);
    t('1cacd0gjbiqo9gembo48ojrkt', '398669520541557676768031831110377929', 30);
    t('1014035244555111523450130114241515', '49986724694411884036240919', 6);
    t('k4jn6e9d6glnigblcgf0b', '183644159120719141946254946886', 25);
    t('10102311003323010321021122122111321132123020213312213323123211221121001231222322031', '25103947154379810646139325622747166556671557676685', 4);
    t('50ahfeachacka3', '776160684509952255', 21);
    t('5gf39cg6a6d30f70cdh77', '75670880512894340281508401', 18);
    t('3i', '99', 27);
    t('5799c79ib6a7119bbbf1362e2f07a3a75', '448835587235333894824032459146597136265394', 19);
    t('20199362559584384642', '123276124968958033085', 11);
    t('14f6dj7bij792d6273cija5g5j0cb9hi1ggc', '4254894585269962546595403514332354881913294732', 20);
    t('9982bc1097968c8c3b610c47a14b74b861406486124', '594597577726034824881214857458527499759845362913', 13);
    t('2542204051144325114301201212455', '653347659057319259531891', 6);
    t('8bc1fs0q6', '7136460415847', 31);
    t('12245232344501421', '3982268425045', 6);
    t('435708bc337', '587768670171', 13);
    t('9gqc89j93bfm4', '2230491747853233820', 28);
    t('a15903691c9001b323a09395906', '927480369551047749189616833196', 13);
    t('3g2uaml4gj9rdi0owqv5e3fi', '581742884070494714992134070640198076', 34);
    t('179ehi909125bc0b3i9e4a91f522dc2gfi', '2206014001526987616423852615240896648228754', 19);
    t('12010211100221020022211100000120201000000120021010221201101101212121210', '4290236792225220853841200359967002', 3);
    t('7k', '174', 22);
    t('1071610', '578592', 9);
    t('22000000001210211002100001211120100222010001111001200111000021111112122102210222212022221020110002120211', '37107607574596122561009019100775525141832001665669', 3);
    t('1nkqomm3qifm695cfra0hicrl9k6o1i2ioj', '29519803751298537211113975613679446742819642561363', 28);
    t('1158d8cc', '115976908', 14);
    t('4836398098bdb7c6cb93bd3ca2bc048a69c614c84', '32124850151621055288011165638934576325866972244', 14);
    t('ek5ag0l', '3615400646', 25);
    t('d4de8jakhg46gg8ke52hl3hl64af8h1g00', '11417779761519995781476451771964854089342166669', 23);
    t('2gbeajig4810aab745afki14', '20666612177047863663274280987634', 22);
    t('218k2c080cikh9eakdhbci94j8fgh', '79894697026629332310714396980970566525', 22);
    t('46ebc2ha', '2680633108', 18);
    t('35576422324763736', '1046634462177246', 8);
    t('crfjig2n34dsuqnh0bgco', '16300713892509942649067256791448', 32);
    t('3fljnn67qh0he798q', '2550626756903000471191471', 31);
    t('10110001100100001110111010111001010011000110010100011010110010010100110100111111101111010110100110100', '1758529900728895870358045306164', 2);
    t('105212361216153102535206354065633406325425223013011', '1993490998659291300161155678289157518972908', 7);
    t('c4244b59g5c96da003c464332', '4155898790145483848870845049775', 17);
    t('h', '17', 18);
    t('100102122000000201000211201012010010101212012201120021012102011000202002201002102221012002101001212120022121011012', '861002691662158159012861645549677449067811598994275093', 3);
    t('200000220244012526360023', '54738028206812706724', 7);
    t('45025334847078362688008185858168724', '1268020314482631821675827535583508', 9);
    t('85804d0f7992aef5f63', '862732012489613736899710', 19);
    t('5mq', '6197', 33);
    t('412165', '70411', 7);
    t('3a670f32d8a0d0c5fe1d860669e0fa790a28', '5087581870263472260351886848536796076771880', 16);
    t('14423420134', '108229018', 6);
    t('3cdhij9b1o', '36452913717412', 28);
    t('c38857c477adc786108ddc50913b', '108114098280659403543883930629969', 14);
    t('4420623bfbcg0cea952bb74', '17465324511132004366053468166', 18);
    t('76ebtvjipk64pcgeom', '469643266496008087961694799', 33);
    t('833572012939455360689846300738643973735', '833572012939455360689846300738643973735', 10);
    t('532jlutr4mkwmokrkk1spv29jpx2d', '38740672047259297073570474824972320124549357', 34);
    t('1e7lwq7lfibag8x9g7', '249581188294471901155422092', 35);
    t('16bpm7d7hh9ia9ql6', '175490655969459169683378', 28);
    t('22', '22', 10);
    t('1da6f2573623f320b0d788ecg77', '176650893165944234984783472578532', 17);
    t('b54c', '31232', 14);
    t('106d31a9f39dgg5ca5d22882606g1a166g1561937e65', '83055395658429905495429379420525542544257624906202499', 17);
    t('87167783686580b6760546286a7005', '170003347235677664923783013736773', 12);
    t('1011222012101', '629272', 3);
    t('5e4c1kg8kgb9e0j9b', '8121399895030321436429', 21);
    t('120310023320132031111031222201110323031303133', '479999663316795249342078175', 4);
    t('2581695437092034322608281300193', '2581695437092034322608281300193', 10);
    t('10b31379b4421', '9613231649881', 12);
    t('fjai0pn268g32oa21ekbl2ee9d06m1idg', '29945640848113871009545458332782939996039036978', 26);
    t('2242152541332302355454225214033201', '117239748984429205550000257', 6);
    t('515335122443035', '3564199709740', 7);
    t('143c0bb001a4313735185c73', '55571846248867914153487159', 13);
    t('b81h6f61', '28354183265', 22);
    t('b5d3ab57023c', '46265651034958', 14);
    t('3', '3', 12);
    t('5a1je9034nek74n9586cghc3', '301192022551379992935349177894755', 24);
    t('6085chb9dbadgd17ad', '13171586833706983780981', 18);
    t('4982a53ea0476cd120c6a38c8c5d964b2c068', '10126556364355015871790928748398484260463723', 15);
    t('kc9g3uegiyvlshvrtdvx64ln', '6639598343399941171297097806956821033', 35);
    t('4a4acc500818db', '3761155193407385', 14);
    t('20pcq1260k', '53578455065104', 31);
    t('321r9j1iqm9iqdd421ik', '9631620548977442780416929948', 28);
    t('244ga3cb25dbf9f00b9gf272ffg9gd46097e', '26204733276579768210781207022287836057779358', 17);
    t('9868dbdh147fceg49', '57400460873969103003533', 23);
    t('222604', '39400', 7);
    t('1001111000000', '5056', 2);
    t('ek064d', '76838973', 22);
    t('1a5188n3h1b0jod1671hbb9e9a5l422948', '19083115540402109213773674981974542272012536983', 25);
    t('338912e9130a4', '420150545582779', 15);
    t('17b6490b7ad35b949236027026ac1c55d10472d8b07', '2138281111827887420594645460315403726459746303107', 14);
    t('9xwfs0gwcyv519', '1179101895976769853419', 35);
    t('3ah4m2145foj5', '204295666789312355', 25);
    t('b02mmltnld2jnx', '1301255465101006358613', 35);
    t('bc45885577cgd2a67db35a5d14ca3c17c', '27753918928513171463189805378534573507156', 17);
    t('3141201334301213410030010112321334303004321104142122430444023001310200043002', '89237897287660630346174371948143819745060364170706002', 5);
    t('11010430110321', '1476410086', 5);
    t('dlqp8bdh7i8ldf6ii8', '55089869930926033233979040', 28);
    t('366255123122311123125', '4437634644479092309', 8);
    t('11b2b2b57830934b307aa1958', '92329386229213427978411540', 12);
    t('2a111815915', '175903352801', 12);
    t('rrfshm3nx845epw5rqh7ti', '4029249737737517853157864145330896', 34);
    t('797ssrfvu21ikjwltpjeiw6rq', '20251792508585042855691553376521064843', 33);
    t('1231751346340466252606553475546101570554617315561125473', '7603872826618045742580005490971103946545668860731', 8);
    t('1f1h2gqak41d5k0il1pbicdgpddmsr2t1b6c', '23416799607567184928718366393017760124104542135755195', 31);
    t('9l1cha2o1do4j9cma', '427797075500712961988110', 26);
    t('56322319981030', '56322319981030', 10);
    t('76cwfnedn051qhit62lftaek9t934vhhasm', '30649878915096954532359678848211944230048706163888601', 33);
    t('3iy04whwds', '279168468016683', 35);
    t('1bsjgq108cagj', '1581450458898508307', 32);
    t('4', '4', 10);
    t('a0aq6pdf859381b42of904', '24599377046503368931010489086420', 28);
    t('855c8e9b7922e67e7ba4da908010159', '1602902410787815193041624442766566559', 15);
    t('55311312112233002243402130211312155421350340514451512400', '37223961907514345278830328700560172586461424', 6);
    t('1022013123223003223300322320201010', '85450081323994286148', 4);
    t('908710466301120434499886628231275207086870624675', '908710466301120434499886628231275207086870624675', 10);
    t('8e8k8d4chg0b663e0iiikicd084ed7', '7370809038638046077658634722860915413949', 22);
    t('2bm2pe4i87cj1k2l15k0nfnnh4', '581467039424523178429739030625165794', 26);
    t('1ncooa9r', '38948697297', 30);
    t('bipk4coqlx4m5w2ixtt7153oq336', '2585657693309581263603316685828104816727144', 34);
    t('1h0aa5a1966b6ad64a4447028d107hgf7a2ah096', '17572273698356237543052229497274331150348443287504', 18);
    t('276544434422885080212460407577672', '276544434422885080212460407577672', 10);
    t('110000111100010100101000011111110101000011110011111100111010010010001111001101100000001000111111100010010101100', '1985345177021823592895244450907308', 2);
    t('1001110000100000000000110110100010010101111110010100011100010101101010', '719999719481543869802', 2);
    t('92fal9add', '1002804039109', 24);
    t('a4hp5lh4dc2npkd6fa3jjh0dm0mgg687mqa', '47185254555192750689361563819892235471735779772486', 27);
    t('15d9f04b1gef9d08fgfh', '934578487538888755916375', 18);
    t('832913', '832913', 10);
    t('4g1dq064c6ph', '430443150310562742', 35);
    t('2413dcab4dd4acf50d555c028f9dfa7', '2997208574424073828351508066743213991', 16);
    t('5lb1d', '5942317', 32);
    t('12b283c0fa13dcbgbg3b33d95g2a39482424', '13450882559601947456920748168407415837877954', 17);
    t('111100100100001100100101001110001101011010010100011010011100101000000101011011', '286012825709225924788571', 2);
    t('5312521314325345320414255524522421', '264602503512316272185020237', 6);
    t('4h910', '521982', 18);
    t('737685bb6532393c7ae4kga8k71g2b8kli2', '31388007356628532619060635382380018033403436610', 22);
    t('3fnjmf', '61371367', 28);
    t('avvrce29ic6gnaa0a8mwsl3m855im98u6b5', '46733255380075003831663039424046041165133968062385816', 33);
    t('14750145321891718544515464840373136519875', '14750145321891718544515464840373136519875', 10);
    t('535563217273266762141100234605765502234', '113492301891561204235365568461833372', 8);
    t('10403204012512222022021335534244123', '319087493465006318567376147', 6);
    t('2b518a84c986454h611221d3f687e2', '6642461774183699172360267164698027418', 18);
    t('232111223201301', '777435249', 4);
    t('2g73538gn0qj0m89ik6m', '4085811882054081271200217927', 27);
    t('j28szlkk5hwfzklssj0f', '7078218218729352925375627288383', 36);
    t('14715687608876514226036405014660867608606525724', '120428847967260029520597138950650653087280057', 9);
    t('kpp941t7q7udmnai4x57yy3602ntyg8', '435254642075720789924201732136377372350529359343', 35);
    t('11010111100100111111110100111001010000011101110110100000001100001100001011011000110100010110110001110101100111100111000110010100011', '2292419381743847793952323533642807872675', 2);
    t('1657330721157546300772313767037603015', '597965777884596169919754548479501', 8);
    t('o4', '724', 30);
    t('413310344421231413322303241330043014343010000443140423313', '6031086358432186950670068161163571029833', 5);
    t('2g5k913n7f2dlf1bb0a39fkcaa6b6bn', '682270546676077618064623251305670646415519', 24);
    t('21a71aezu3ea0izwvu7e1tluykn', '59233443885800213081870684139782121612167', 36);
    t('4e50ci4dmn55ebb3c6kg9', '18459998608205280317028086409', 24);
    t('1nb05cm44j2bd8jgcl6fi', '79142228769239865835175770884', 27);
    t('2434241221440210204311', '1409805166881831', 5);
    t('701711416205015540454465462370167111721657451163343320', '5136876924230800291846439025619119075547100858064', 8);
    t('3f8n1of2a38obnl8ep11ecd', '110253233544146089611390491118511', 27);
    t('34t', '3036', 31);
    t('tskui29ucbiu17gpko7k1a6kpdqsa', '98535358769443740139966556351639343186441328', 33);
    t('430210103354454023323444555113024234125300210122242', '3645392594482175303918584334169722751506', 6);
    t('140687lbfcib5h5', '13615044335277161621', 23);
    t('cexrtmgibat', '45391017618162101', 36);
    t('kic4b3ma5nc2plgpgkpogfoai92dng8oj0mm5', '69938518380225983695147679294614413330181200341989838', 27);
    t('ahj8kgo5925m5i0054', '12112057029207057322038214', 26);
    t('100110100001101001001110101010000101110100000100000010100110001010101111110100110101001001001011011101000111001101100001101100010011000010011010', '13424243929007150060864059623182269932449946', 2);
    t('67', '73', 11);
    t('23362457004252530156262', '2342754483992148575675', 9);
    t('3011202121101030201030100303033210301111220112030200110', '1001633711617655191899956991019028', 4);
    t('137a892549638a9837a917a7666a362251', '7350842488951219051870982842648687535', 13);
    t('b4ikcmf69e2ol9djiho334o', '63608428236453413618284599267624', 25);
    t('3t4ptor60wd4kn0n1', '30316095985110696140429053', 36);
    t('5', '5', 7);
    t('64uiq0vl3orqb2q80', '19593826409773818947256632', 34);
    t('628el9oca6cf5l', '96872666241776197671', 30);
    t('11c6027fb07', '1221383944967', 16);
    t('0', '0', 31);
    t('231302302223322220011101010202122003210', '216254277740074631799012', 4);
    t('1ejb7n9hn98fdko2b82omid', '9044494589730121024947833201713', 25);
    t('dec57b8559i0da03202fg77e7ihdfe57d24494g3', '1024122312906876955463549547517122427306089572501789', 19);
    t('oomkd0b', '6102664386', 25);
    t('1lpci5r', '1259890377', 30);
    t('f8v1bofvwns0ot46cp03bwel64nvjeut5', '155217583886970469124492270430014237032433826545559', 34);
    t('bbgb8b78016ed4cb3d5e354f5af4b0c5312c4079719', '55874981774696748806533238208646256520967064718000675', 17);
    t('2a4o3cabjeghak61a44', '35040210811575576369553229', 25);
    t('hci0h6iifld5ff5ilbk65b48426nm9lc', '107241447290727904013766223879143355844274756', 24);
    t('70nh5l498afi1gke4j26e916iaob15', '761187094370053383900135740007646208708043', 26);
    t('3c43d5cv5ddo8wv0rqjw', '727519923745015769780970587047', 35);
    t('1je3a5egj4709cdc4gfi9c2', '83275359746814050652469747842', 20);
    t('6a74799742895178b887', '2199503576725308160807', 12);
    t('7835c68b1', '6228797485', 13);
    t('4blcgo2tngsc9', '2333273210661787569', 30);
    t('1g0cc21kionpi43ajcn1bpb7i8dn7', '6725433872501710944890249791746813975217', 26);
    t('1hpbdn020l6rhf3awq0hpe09q77856', '167486908631010808846811171655656010754677429', 33);
    t('5epinj069hpeommq0p0a', '33648845471194696230841845068', 29);
    t('32k8ee4kiedel4llelc8e4ie', '23533597718626777596381780445114', 22);
    t('2c32db797c', '59370297194', 14);
    t('e65a208743664c3ba599a15ad608eab43ba6a9ab52cba7', '1211237383851901761546703849501641437474536862403847507', 15);
    t('f', '15', 16);
    t('2335738633324401748700117607031714222313587', '28474989317702039795653269668144118345370', 9);
    t('480umoz559ibt', '20009609804381113865', 36);
    t('g33g47chh933gg', '679936669195392700', 19);
    t('f3gcdd5e82542ba316483287377cf1d22f101d5448d', '72724582067825296668190966379135599043646147680532925', 17);
    t('4j3na18o4p0ceo', '30452392062677782368', 28);
    t('6g8f47d79h9f638b0h', '15118189433563577196653', 18);
    t('676j80k4dfcfe18kkh9', '4005482188146748168521174', 21);
    t('1001101010110110000', '316848', 2);
    t('137147352425256713737330565276377404642163711477430', '2123077029185636827747635674055058793964142360', 8);
    t('3132230032110133023222301010323132020003013002232133', '17643398431162255932320877652895', 4);
    t('68ugt8', '328443123', 35);
    t('89jedji105c7att4gb6atoq5n0da324cpr', '136322375391388103649786958602863047119729868881023', 31);
    t('1ect', '43646', 31);
    t('263052612663632623450322', '79933753083194935136', 7);
    t('kkncd128450dnngb4e0006jn91jke9mcem', '73549583692565773010150654459903537277634564198', 24);
    t('mlcnf05opd91', '83782165337060295', 26);
    t('fj57gm406jbl3853lg127fm46igifb5knd52bd', '18471318386634651669357017600415819167888436283401109', 24);
    t('d7cd254c4b261358f8a5ca', '260887824373193911758792138', 16);
    t('2e266h0', '94725594', 18);
    t('38d1adb1f0855eba75gac818fae4e3ada61', '2406025984446729980588911310762723226916599', 17);
    t('969vlp1nq0cmdg4p', '861520870277679404136873', 34);
    t('284357144735', '92362940285', 9);
    t('miok6n6e2', '11330609651475', 29);
    t('200010001231230121311320032101101102203020', '9690422491199883037714632', 4);
    t('86gf50d54d35gf0dc0b41ebab6847d7h2f4c5', '90668674464877887390632519960182768841029658717', 19);
    t('2ani4r0nhig1gbjh8l5kh6kk2prmpap38mkrb3', '837057992878003710672168205308141026264831823314103527', 28);
    t('i7vbrcx6k9', '1436460800474184', 35);
    t('73iah', '5767517', 30);
    t('6438038702116a311387638837207a68073a93', '2174370174074028677328289240479077494102', 11);
    t('m259bbnj7a', '320249541066343', 29);
    t('113130150532102045044452115001025205501441503430320114205434101', '2211604036567285168567876925597855231015638757749', 6);
    t('535188052007887974548621926768462151300749858328', '535188052007887974548621926768462151300749858328', 10);
    t('3e7a93dkfi27dj1bfh9i35c3abjcg9fg', '1505256982398481387593340874013583945570174', 22);
    t('1', '1', 24);
    t('gxpupp4', '26250856922', 34);
    t('at7tc8ntw2om38gg49r1o9wc', '917677889249261147737339445563028676', 33);
    t('93n', '5279', 24);
    t('1290c63c030979049c3c076649b408bb37741519bc', '5669935905784594135179408409816347268201188910', 13);
    t('258peq2trq01ocru', '129442317021809162827266', 33);
    t('254767174882833131', '43620452343308152', 9);
    t('aql4oir5djm', '3245007227292090', 28);
    t('db343e9a340d3b', '26756154339280481', 15);
    t('3220003201211133020201030', '1020589011404876', 4);
    t('3o78c', '2072046', 27);
    t('2d877kan5ldq31293oilrd82opq81gg5ae', '4464070539173170102196895822272337548717444132915', 29);
    t('e126trtmrqpdrleqkk775dcnrita15', '96328326169357847704968608549063554178472035', 30);
    t('2232fagd5ogl88h', '134278057960916371337', 26);
    t('1202112', '1283', 3);
    t('5rm3m', '7768444', 34);
    t('16a18ognkkd58hmk6k884imbg8ae3a9mo8jn', '10639470795815794263674183939356306402456151552373', 25);
    t('17hk3j53', '10405409225', 26);
    t('3', '3', 29);
    t('30882179734', '30882179734', 10);
    t('6ggg25h82da25ge6bj4bf7a43ijeabg5hhf0a9ecf', '75228743181702840807285203704272617023859657921677855', 20);
    t('112001120124433010232210444042123440330342432210210431102401110143313320', '54227490505239760641941694866809573616876524197960', 5);
    t('15427672061537656436340433201663652647551672', '1152417987539763660190335375077130818490', 8);
    t('10i2p38hnf5i1dfprkdo83i2pg10kmqq3', '63970988722559728762937017576893997855744155811', 29);
    t('h1b117o20np01tdi5jaekbg', '5349088060367663935485224075196346', 30);
    t('86b34a14a2582b132', '1586003464764431606', 12);
    t('74342', '30946', 8);
    t('436m5fa847c7m1kjplgh05cd3822mic3', '971009368598280732378011474082406690927211238', 27);
    t('8f2zzdeenejdkr209z38mtkvdch2906lz', '533260676773267340578452417326723669642107198382711', 36);
    t('1hi9r2c9ronogk6csdqdeh4ruho04djiiqdf', '24708859854809466983372602857862889522307039320807326', 31);
    t('947sq', '10825610', 33);
    t('885526373854872554336133526465', '42192813046514552728772042462', 9);
    t('3faa3h9c205g13aacfc0269bb', '18706722517747698176671987201674', 19);
    t('227467610c43e85', '63224810139562775', 15);
    t('123031112100212312320002001132001331012220023220231232232010013003013032', '9480799240652897962878990342506933303128526', 4);
    t('23345022', '729446', 6);
    t('101011111101010101011011110011001000000010110011111100010001101110000000011001110011010011', '850278303532391505837792467', 2);
    t('2300003300310202100220321330023', '3171593279030664971', 4);
    t('11d138c113205e6bh7359f4a', '280728756129469210482775394960', 19);
    t('hadfml2', '26734017388', 34);
    t('54k7jf718dd', '87347282076592', 21);
    t('1ne8fda3abm60jc04fg2', '332195869682574442832526146', 24);
    t('101011100110000111000010001011101100100110001110011000100000001011001101011101100101000010000000001000011010100011110011000110101100110110', '237356300857539012126250205765532327373622', 2);
    t('1o271fchb00ol4dkhem17', '38390328656608000668455077433', 26);
    t('525314545', '9216929', 6);
    t('aa64c64c793e8364a', '70247576439398188420', 15);
    t('a8pfj97f0435', '125741271124301512', 29);
    t('ggh534c6ggbha518e08d25f05d0012f509', '4497422234177618704742490604901750978647125', 18);
    t('22311232113211320312012333000330312102011322032221', '858789346873481805128057463721', 4);
    t('1200113112201030310210113101120123', '111101134074076272155', 4);
    t('1200121112221000122200012020202121102020111', '184849475168462687158', 3);
    t('872983082774482983787518618800', '872983082774482983787518618800', 10);
    t('5mlim4nidil98ff5n', '72148072134153551039567', 24);
    t('1652585ba300b5380364870b504a1a7', '364646790364235488156172628236431', 12);
    t('978h66d8caahcd0', '58089002636112249670', 22);
    t('1kkla3a015jnhj', '1638687175226099563', 24);
    t('746213261004212350555277277331633603', '308211597500827039469103368058755', 8);
    t('4gp292pk42doc', '443983278306821408', 26);
    t('180b294564700829387', '44545269922505572567', 12);
    t('kk7d84p3dka3nreccq1m609d0gr00p', '19233251736714867892517505234457736796220249', 28);
    t('110201102002110220120012121000002001000110221212100202020001102001212122', '10612477178427271665625741528055207', 3);
    t('73363c6892d237', '5740049763623441', 14);
    t('n4ckfns3mrno2dp0hlasg', '4097962887367983122115091338600', 29);
    t('14431533104233134255102', '236018374533878510', 6);
    t('34ca18064bb40237671722a6', '141266261546214472896454219', 13);
    t('28391e59d70ch7', '102217702033516445', 19);
    t('3', '3', 35);
    t('9qgi', '241849', 29);
    t('113250532', '2121752', 6);
    t('7599788542b594096a5b87a5', '49584486067719553446039917', 12);
    t('8s3t8ils7jfnndobdlaemqj250g3', '164631635071927317444094845929001081303849', 31);
    t('4h2iacf43m', '17869487346347', 25);
    t('110201121', '9277', 3);
    t('12177711606432104883357', '1226392108651838512159', 9);
    t('373256e2e8b17b56chg3a54', '45826692083221550917290789196', 19);
    t('0', '0', 19);
    t('11n8j', '359059', 24);
    t('12202002002000122002221112122012222001112120002110000120001212201210220211221100001211221220111021000', '986705214174978834196213675086407606233888004604', 3);
    t('10111110111011011100010100010100101010100010101001001000001101001000', '220125906067706381128', 2);
    t('68fdii14l', '700119936693', 24);
    t('3egk0140j5c1f5k', '229866340801816690810', 26);
    t('e5degigka838d2205ilfi7gil479', '25083920445727826356901122508495429259', 22);
    t('13320313301210112230203120320113320132003233132311213212213233333002202111302', '11259010157049734086345735286363460728682849650', 4);
    t('5h62g38ge626f81', '2235184586731991197', 18);
    t('1011001011101100001110000011', '187614083', 2);
    t('xkemny6t', '2630437657301', 36);
    t('10b0413250819386b108351290b73226b6a1590b34b05a6366', '81645102709884483913181829243891844511840914769743998', 12);
    t('6372c', '315492', 15);
    t('dj473h8cah3hid55dj1249a426g8f94bjf9603g', '383754275040977617362152965924589307652725745488076', 20);
    t('22210332111320213210032300131133223121', '49951871347577207519961', 4);
    t('6be', '7749', 35);
    t('1b73282h0bii5031f4d542ee31ea46h635', '2527326396121816469210042873835773485296097', 19);
    t('66227115432070273523772053651452513083354117373625624', '279494516756655179230331728401746874479009481968914', 9);
    t('166qn1tp23j3vaxo0ojf', '435136933431911116389704144955', 36);
    t('a28coq79j', '8591402127987', 31);
    t('65irso', '150361164', 30);
    t('73e98ddhgj831i1jeg8g329e451b8', '19290253118088978042039590991981480628', 20);
    t('526622b5h943db7fa86hab06', '381454244000888974479231073170', 18);
    t('43168a72fi0dt3h3ms', '52964818504140944984592388', 30);
    t('hmmbmq09oh26', '216989280041265574', 29);
    t('3c8k8kehcghg', '5349260598820264', 24);
    t('6cj60m6fb50mb', '143719450210177075', 23);
    t('146bi1debcfhsf97ci41rgm758201', '101427316663798701296660111279977667209213', 29);
    t('1iihdci3d2d0872j6c4c44dagi1', '45334034109911611232603135189813584', 21);
    t('8degg41934b83bih61i664a36j2hf', '91051501141223799965271020952208632909', 21);
    t('16c786802b79020cb457cb593382714a0c641aa02400b78', '2677894540962015624580557265698048634806854048320936', 13);
    t('52oi3aq54pojstedhf89eip6b', '14140583748705894224928943574695025684', 33);
    t('61590172645abb69183b233b54b5747962b19', '4340185485693521080055289170225554068933', 12);
    t('110682585501136724772506418006240605818072213886', '792229254764182331069673929338255216691773278', 9);
    t('43qxp7', '248160283', 36);
    t('c9uhlcfbn1c9q5', '300876274501077613973', 31);
    t('694t1v4aaosluu3ljg2ijqu', '8159750513846010634274540700127070', 32);
    t('21795846019a487881188a37130208', '3419949453251184532031131805419', 11);
    t('1001010100111011001111111101000001111111111010110111001001100', '1344157337501134412', 2);
    t('2mgd3m04rb98mva', '10936422713010831976670', 35);
    t('40210655551020225312633630466450665625251450544442661653456430', '14381574785226902109942073009116714912332534395284510', 7);
    t('u7en0vpl65blxi80te38tryfsku', '422618140589562267742993269570998416915030', 35);
    t('11000001011001010001100111001000110011000110001011001101111001001101100001', '14270026723513393976161', 2);
    t('ebpceco7pxldgb4onagjoht4k7', '5729256960747607579936416329466508315857', 35);
    t('b9081qbq5sqxvik2xumnthjash', '4499212750032844054690121752205782394747', 35);
    t('32j5g5095nln6naok9e3qaps68rn9o015adk0', '136942195680745271283041728157055292644430490770829675', 29);
    t('725497617273767332245236077173508191481447722770385', '725497617273767332245236077173508191481447722770385', 10);
    t('4or2dg2hagf0f9s876jn30gbjq59f4hhen141', '215251212904058918759190014904099329610351440654544226', 29);
    t('rqo92bmij', '39112462451422', 33);
    t('64238346686567353403826531363543727200', '1312747209333613899473709033496633239', 9);
    t('62637563245765352276624303141602613364172154133241311371742', '152088100153270232559520172242319908695772301728543714', 8);
    t('1333330113211232222022003003', '36012825892135107', 4);
    t('3001031311233030312333010130233233313100113031012022130310211203220122223211011120221031', '72290779573970253392304372068058964937709043831900749', 4);
    t('10041140324543315', '2876139957791', 6);
    t('135561883015772', '32093135289974', 9);
    t('715pfikbdn64049b0e329iebmee2p8a8l', '13402036795732724143888377560374564804041015517', 26);
    t('7653b61a4a0', '466672013112', 12);
    t('110321332122033332003323233102303213230320211320101123133032', '434197763291942311469426951196096462', 4);
    t('2tge8uy8p3ve', '274389336133434774', 35);
    t('155151710526047560257027505415470777132176305054012751404', '638423785977537057303063374808031230555869057635076', 8);
    t('a765fadf402kk307f64imh08ca0a', '60279477718441090640145794037158399941', 23);
    t('3hm6lg129la75k37c3jjk51l60c9h0', '11688186075235252346472073838202560002816', 23);
    t('19dogfgr62cjraj17fo', '1602752867648709555962027512', 32);
    t('kegju4tfeei9b048hsvot7pu4', '56859703342713352624670750416660729636', 33);
    t('83034086469954352644240830031237890715772719822', '83034086469954352644240830031237890715772719822', 10);
    t('3203202223033322231020001321', '64047325323231353', 4);
    t('i2d0', '318058', 26);
    t('4n6n4e77px75', '328641670161001487', 34);
    t('1vtmkpr6qhospuplepvg09blp', '2655480572001125819849416161655828153', 32);
    t('1ihow717r0rgjvmy7l29beg2bzww8pz6u6o', '124254102510606623034672266738595978367467100361745744', 36);
    t('2m5gba', '33915216', 26);
    t('hf654cg5bb3idigh9c', '232857980165918636614992', 20);
    t('35443340144063542115553', '14892674299147846407', 7);
    t('2112220110102011210112101020202110011021112200011221000102210102201020022', '57494075722004273256340780908238154', 3);
    t('5lci5gb', '4165510991', 30);
    t('11', '9', 8);
    t('14f90cecc7171ac6437641b5ac089688db33909', '7483364180601064196936956248122321436304161033', 16);
    t('o4jfagol6io', '2307070478457349', 25);
    t('7b8a012ba0c5381568b3435c3654475cc62009135804b27a', '179001727269993328584512210018248776292093962282697712', 13);
    t('a03b513b148787c4cbb10177a873b4182989', '9750173084845230278730830143332448339989', 13);
    t('1iairpl57sp8n6033ge2rodf75f6gdori8g', '86022733789177873849337430569285876925456258265210', 29);
    t('11kdb6p2md0hdgd8bm18i19k7di080', '344319303571314782580067280084060158221399', 27);
    t('ik2jnjkj9m2e1og5gdmt1p72', '3113905142614984871455941391842734124', 34);
    t('1d6k39adlb79a9pdfagh', '2340516863066457913428999698', 27);
    t('ioqrojfmm7gea8rljr0f4pe5rbtt3', '10772975501661450017818524272575556265371968', 31);
    t('21040', '1395', 5);
    t('ei4mlt7tmgt7b7m', '6985663203740380489132', 30);
    t('bb8cd4', '12291284', 16);
    t('20504664240177812000285235681063216130278276', '222234624997451365651218301513111340426529', 9);
    t('166432654201456360026451202162050312312114151254', '10448295064112667804382843649392154179282', 7);
    t('mgc3ap914ff0379i98klj8d1hgc1pdm60ga8kp', '511401910152592553129845047866126227176299771468553809', 26);
    t('15570', '30180', 12);
    t('4df0e5fb247bf16f43c6776ccd60df556f502a', '1738142587398168829725897493959473887005593642', 16);
    t('974e2c60da2db82a6314561004ee7da6fa4', '823784761827070684801624947985460569468836', 16);
    t('7lofr8ub6g11ql13l34', '9507591535540334154075984996', 32);
    t('87hjr15kg78kshbwf1ou45pkg8gs91p8uu2g', '1156903500550024753523548410979938002404617165251289196', 33);
    t('2211212002220100021221212011011202102022210202101210111000211110122121110102112020021', '34079911752189551791157867491366350579586', 3);
    t('43am2o6euumfbant06', '267667501385619931196518341', 33);
    t('1d7cj1ceege23', '20652593811671495', 22);
    t('4240243333000422254145314244201530204403151510530441', '21564520097455639497199309296429090214969', 6);
    t('11869794193a97004899a475670a23182', '2453835010791845353960456267792399', 11);
    t('ici00emcdk9p4', '14497585545174247457', 31);
    t('313323041432211', '20435889681', 5);
    t('4487649166275510951938a48870316aa5872476aa88a9674', '430315194065841472277550412799061686011884707425398', 11);
    t('cfgip9i9js6mdsocjjmbqk56', '54118901185544030982279736369588342', 29);
    t('78020k4bda5k787af0719j46', '19018189936144091928181332395673', 21);
    t('1dnihd7g4pjvg9p2', '304917124976447619715094', 36);
    t('5yk7ssas3wgmlx7ahwxjm1yayifvlwa7v7', '13590391589834916615774355195549723338258732720949843', 36);
    t('7rsibsdr8eolqbkot9ehpnef1hacb1b', '68787249568298723121694457609989013843031697593', 34);
    t('122101012101101001101011122022010011221011220120202110202022121101210101200211110122102201022201101001211112122', '58761003770056410036945132714314493878941158522889874', 3);
    t('247oh4fpjh652m53aqpm09pk2g8h', '957358665081700123817860607985546969611', 27);
    t('10110110010001101011010101000010011011110110110111101110111001000101101011110011000011011001000011011010001111110001110110001000010010', '15506344473128630453531168072244872569362', 2);
    t('1ba4f196d2', '1836378562944', 22);
    t('q85m56jde1ijaqvrspbmep65lf', '5080889917612367493209814869041589214701', 34);
    t('28k3', '32739', 24);
    t('2b24473632', '15134113478', 12);
    t('206804748241013587542373', '18480377731997813950830', 9);
    t('1429', '22662', 27);
    t('12002012011120110010122201110112020120202102122002101222', '295468412871856185863944127', 3);
    t('12000310142032111034412433113144010123022231141211420323444332011201', '94937406117061099909537623729787566702636203926', 5);
    t('3ca1ab294586c19884478cc5562b0594a11', '298052963486521030604056025307425922825', 13);
    t('1321573434316', '96870480078', 8);
    t('200468a73553a18804a80927308663a07', '4230083436897722239837342629998453', 11);
    t('0', '0', 34);
    t('e823de9c24d78d3a4a31709137519b7a', '41830648502807920110953412072000880465', 15);
    t('1mioj28ohgl5e57ir43p9h1l18rrf7h86', '36871182090696202519639887715662651503934529590', 28);
    t('559t1wf8tqjcf4hsqigapgu931b67', '39236251530838046870605814177749092966502359', 34);
    t('8gk8kganb8739cebk6ig8k791c4aami8', '632357147598558623973831444596664388969242660', 26);
    t('f5ll4689f0cb7a', '7691005216002972700', 23);
    t('67a0a27079b1453', '8542256755875903', 12);
    t('33cic9ej8', '1560004667550', 29);
    t('11101101000100000111011', '7768123', 2);
    t('1469a870266b763900a2151605815894732009c0581', '82262652821492357872492374378244010360002277967', 13);
    t('87kt32mchjk5c29d8ba4jp1r4doni392fc', '45899125404340044355369226957575208740733387075262', 30);
    t('17ogc78hqfdol3m79f', '2784763002896554190331327', 27);
    t('1b354c90c', '7303645452', 16);
    t('333414', '11734', 5);
    t('2ig1gj5ahfecb49e9h8jb6hb4ac96bd6e0g912a', '507895713729619956403077058830524059107852124474504', 21);
    t('43214ba9635', '584965373374', 13);
    t('3nncigsq19', '74651509139439', 30);
    t('104m0kiom60lgfom9nd', '29690896309147298930418935', 26);
    t('6dddo7nuhlpt80n7qr', '693283167208501106539919907', 34);
    t('44323004044422212', '753914451557', 5);
    t('2kjbagdd936cdihgl3di2iehcf3cha', '8983928381495948321401576478563586947687', 23);
    t('15417724275812361346116783338045428115075362702', '126271823583933789437986560482347810218604565', 9);
    t('4424434032402310351550243455031032530001231250544545401045032010023', '10818193299861878243790076799343621945293694027382815', 6);
    t('3lm0hbfkkf', '10338045823215', 24);
    t('lnihn1q', '19313199759', 31);
    t('98476750d3abd781768003d843d02ca1c1cbb54', '342681225614809442677626946848997427648271550', 14);
    t('57in', '171607', 32);
    t('4l0', '4230', 30);
    t('13zqljn2h5210jch67r9n', '14850078065778626446235105210315', 36);
    t('17pcmfkig62aeakj4bbpp6abe3', '787221900286688152294317969622892409', 27);
    t('ca12c1g899b', '128028933827791', 20);
    t('1442561330613212634115655230112622234401141505', '177775307843218888019761099117675922373', 7);
    t('1322323203230232302322231320313023000300232211112003322223102', '2553168476684154228725217265795967698', 4);
    t('95bb', '38331', 16);
    t('7knm', '228492', 31);
    t('6d80b3e4ai96l315j64fffj4a2b', '528476806561481039995566993561707151', 22);
    t('28598oa3', '18598623319', 26);
    t('1', '1', 33);
    t('57434427908678899a19616398a30a5aa9', '131732495350301681645134300922039080', 11);
    t('ugvsalo6lid801bhequ2j3gm69md02dg1', '310169070310248176158440173181169510159391272861573', 34);
    t('22021210220020120001110112211201111212022000100020002000222220201210111220', '186744606233199646302344057916276861', 3);
    t('1mdbdo81sittch2c9pqmq23', '548604384913200011277372830177463', 30);
    t('23160307511727067463554413', '90761577315987134273803', 8);
    t('200011211221200112210021201112020211002012110102110112021211', '28542801355511656365238383949', 3);
    t('37992', '539782', 20);
    t('24kcglcnbq2n412', '238120258337878748231', 27);
    t('42ol3e', '99487004', 30);
    t('403734699498096870624883', '403734699498096870624883', 10);
    t('211321053050604411', '505485346237719', 7);
    t('78a27309357a327', '2966574256778513', 11);
    t('461020385428b040b79533921bab8', '69259761610665370549777502991976', 13);
    t('b1fr2rp41mbx3xncb0xfmra2d6oqw', '84042654646449163888200240417821757512098356', 34);
    t('3005013424350503040343321122301430430201', '6735784675050747106650763807609', 6);
    t('38pg3n2r', '139184565195', 33);
    t('184786kd5415bn82eg8152hkhj0kgcne6n91gk', '1567411026865786158336358856957759587592645854583252', 24);
    t('212303112311202220301131213210110230010201122003312032111011323000202002300331130310', '226839378801283979800479091211239181319725606229812', 4);
    t('308432779036791936833307501538813', '308432779036791936833307501538813', 10);
    t('5000a91de6305', '1407420280496901', 16);
    t('be8a37712eafed235251de23df', '15096126834474288185885113328607', 16);
    t('11110101000010010000001010101000011110000111000111011111111001111100110001101001111111', '74057344034249031021697663', 2);
    t('4agdca9f536a3bg7367905192f0aa7cf28bade5026', '1304733992727463155067887261543758863312332333333468', 17);
    t('1595', '2040', 11);
    t('mfjh4f16g9qlgi1l6qokhf', '55420676304645035287654438132523', 28);
    t('1', '1', 16);
    t('28425704a041274a5416a3555399', '36212667591400568262055481715', 11);
    t('4866ad25280b1764', '5217047593452509028', 16);
    t('388555g50d2d369g7faa273cc55a6e8f35f2gd', '11765155725634973359235955063513317904611001160', 17);
    t('212cj736k0c', '34252959577044', 21);
    t('1202a1124e4e326e05d05e1de7bdc94fd25', '765196471729486476120236447628523003605404', 17);
    t('79c17a306185a475639c20019c', '54786259681378319011782543509', 13);
    t('1011000001', '705', 2);
    t('11112122011212', '2413850', 3);
    t('3413223330301224020104103042124113333023103342330044234', '214721484670156988481537697242134221819', 5);
    t('4081922', '4081922', 10);
    t('9dcgef01fh13h9066', '1185510195771990049194', 18);
    t('7ec1421d879ad37189383a', '39838461593516143724886355', 15);
    t('4556620513242533005444500602162053362636156165231420513026553350', '842757530742166745590516121006132571018257988845461487', 7);
    t('887583326a0a09533114847045a6', '115229604461058273430446100080', 11);
    t('soh3nc0r2a', '2912725556543746', 36);
    t('1041143200233250', '525242817246', 6);
    t('p8ihzekylx3yw1ndrradu1xvdoq80b8', '1233400406203421024397148451955822220091322400148', 36);
    t('7h73garbjseceg8ekhef152cr2699', '672439504915616762220698973393004587395750', 29);
    t('ml9je258hk2ie6gfed9igkpn5fi0', '3652887835869131415590854688229822429384', 26);
    t('1b7e942f819b', '30230465970587', 16);
    t('112341204334112423241230302230433023330333431030430', '116427771469295513780567588074080115', 5);
    t('50g66a1fr6k1ck41broj1mcg69g9lik', '130468150434356532266429210273257638981218844', 28);
    t('3cfd5e832db0e5g118297bc8f985g58de7gg3210', '3653875188901914332922344609876154431472747363931', 17);
    t('263a85b3', '641369523', 16);
    t('4842428884713208430441876574523584564054565420170316', '22921456423834362632075410365760509919770550726785', 9);
    t('59m4bs422rhhaaml8j07o6ls8so0gn1e80i', '281062888625341158814391292979611212560325630954348', 29);
    t('b1bb', '30545', 14);
    t('abh35f', '296959741', 31);
    t('19aq117k2sk88', '468204151297586117', 29);
    t('19lcg0g7k3khl8e4ak109843a5kk1c5', '27236272682373056800446620591828837123057', 22);
    t('e8alej65ca3j32e9kh9gh', '24658599960999816341036277260', 23);
    t('455919786b458acd526635037dca6075d88804346', '30703490401628056566732211795733293107803742570', 14);
    t('7txkbf0ec3obw', '26547103232126519067', 35);
    t('38', '56', 16);
    t('5dhefbac0e6bj26', '9329618703405855646', 20);
    t('101e9b30e17e', '17723638735230', 16);
    t('2obir141170utjb3pdqeq1g2ld', '53587818951559954153548512220759128235', 31);
    t('1114b1711481a37b40ab782', '603474625470367571048594', 12);
    t('10122212212210020011210200001010010102020011201011220002110102200111122002120001110', '1623999922600731648116424421855627143570', 3);
    t('a93ac3066111a691314c6b5b3ba516270747a9199a08b7', '1436959793947238532222831766204822671586011493120070', 13);
    t('58480962a86729768482180130940604', '1106822665412898914406602330090165', 11);
    t('131301223210133302302302221021', '536401454673111625', 4);
    t('evfp0fsfkrpfirrmh2jnau895v', '1372783108572463878894831856355242799710', 33);
    t('afijc5fbwglvb1', '1235206740707162508111', 35);
    t('310011232113023311032211012023002203301013101011212', '4126950927538421833835204120934', 4);
    t('6e8ngmahe', '1844460496346', 27);
    t('1bpo5h74agrcgoo6b51cshgl', '6086700625232934820042018053764608', 29);
    t('24351022035415021620230332665631431152316000314500', '680247907196347864914631461520709331522883', 7);
    t('df8661ghcbaahg6h0i5abi257', '67664436903091499279834668430129', 19);
    t('5a3282a143771e795d87ee5', '425024233293429042801085115', 15);
    t('404244212412030422302034330214300441441432', '190258475138999060530910108992', 5);
    t('5on', '4027', 26);
    t('6cffj7ihad83nfiiehd63bh', '15113784949593526393490088172505', 24);
    t('23k322g0c7h9', '2066164244508171', 23);
    t('689hd3303cd606f1f99f5afe0a725890a85bf07', '3247974309774379895380706745511795262908184133739', 18);
    t('27358340790499664c9a9c5b910121320b13cb22', '71092424548919054827902632131879373254277531', 13);
    t('5hki', '198876', 33);
    t('bclp4mbe1djj2b5o', '33899350519431680218890', 27);
    t('bpgdh6iee75ooge827a', '353340952670231280445716776', 26);
    t('d8bk206fjkj15ie4dhcl3cc', '12138152877944519436661702674041', 23);
    t('333ljh5b6m79h6', '1581616916999395997', 23);
    t('d2qxawll1gbiiij6e7ln3', '99526840765015723857527315388533', 35);
    t('11876187218c934699c6057131c808b5c45c9ca0503b65740', '332245795948615376820642052747656044479282749839696434', 13);
    t('5atv', '191563', 33);
    t('1', '1', 26);
    t('311', '375', 11);
    t('ae7b24afb7a1dd2ad59ef565c636f4af', '231925067868680755427379099063532582063', 16);
    t('1222000221102020001212001011021122', '10919408154431444', 3);
    t('1256216662445441356235433665015445002263033', '438697014198691047518334542836935784', 7);
    t('626gmncl3ms71p6opdash', '4078656173551560415187079606707', 31);
    t('9ghhakhf1f0bi35d5c4kdh73k433fdk8h2ih23j', '1720533821779021495938138198647013851872290282091672', 21);
    t('5ei7ke0hj52j00eki3pr06cqodpifoon9', '1016743133813841084879455508016504611887385220299', 30);
    t('21titq3hucthn6f0of2616njf40', '1230037399641719218164443592833669976942', 31);
    t('2biej', '1933639', 30);
    t('q', '26', 30);
    t('67978744699025702245219518654', '67978744699025702245219518654', 10);
    t('1253111112541554232', '151023434718764', 6);
    t('111011000010100011011110010000000000010110111001001100010010101101000001000010111010110001110010010101', '4677623609407056260314308484245', 2);
    t('201211021000021122202201112210212212210200202100', '58567569643036490851386', 3);
    t('5a88292b44c720421cb894b3a12', '533915890363656397491382509270', 13);
    t('2h3e9hh2ib08c86bi0f0', '5747634541497108642678548', 19);
    t('37567a0687g4258ga436c778d3h95h2818c8dh9', '1708150384691444782060059038629023779853876775407', 18);
    t('givc5j13vrst', '597831052538408861', 32);
    t('4131234010544202445323324233414', '941033209809342819174418', 6);
    t('1619m9di82d46o18hnd1m3e1a36576530', '673416020131515842532807516881375904836815700', 25);
    t('9m0', '8760', 30);
    t('88xp', '353980', 35);
    t('rbn8ep3b3rlj980chlm8qq4jleq8', '1191977843977043837841082225345577902324552', 32);
    t('d3eahfcacbd146d48496hhah3667h', '1856055109840344885967358014189889063', 18);
    t('640ee4mvnfj118ko5o7osb3arkd', '85533992399600604195850584300979623830038', 35);
    t('20', '62', 31);
    t('4012233002114142114422214001201340442021313142420204432130402210244423', '6878505816170177212464782885897033424143266493738', 5);
    t('13e52klc4l', '3037222455669', 24);
    t('r10qcmspcqekq3kpvdbqgbbtfa5aj867l2', '9346556545971537223317971555464781544415436716699000', 34);
    t('14mjb3el6fba077gln', '350780406639162972508175', 24);
    t('hiigh749709hij318ad53c27b64f5eaj7', '36632370970561829556172951184321651113284751', 21);
    t('2b207beb5089ejh85kib9', '703442893999669422870353721', 21);
    t('2', '2', 18);
    t('4g8h9d7qkcst30925i7lrjbcn76qnlr', '16140733323463101968248981740436855171786353768', 33);
    t('3602178', '1248395201', 27);
    t('26jfj0fch02309bk10k', '1470277628960362858087031', 21);
    t('h771za89m9jsnkj3e8', '4927970904269521731241666544', 36);
    t('1hafgfbe', '10357681539', 25);
    t('4250d1c09bbb3867368b696bd811d490115', '3875741601165944284125909641413718735527', 14);
    t('339ef7a5f81e079987fa8c3ae71', '65437348931585993956193860824689', 16);
    t('7cco5bfijg64cmcm1kc7hnck83k46', '10409381677342479533995796423788528575106', 25);
    t('7cf5td85bcllkqq98pdui1', '154169249902641839102789533784495', 31);
    t('20621a550a42279185769998249a3', '295806720939573663643677166305', 11);
    t('1mb6d83m4c50sle0oc7pd18ca', '1067940877091749641918965208695920032', 31);
    t('54b6ca52773', '741121768884', 13);
    t('10225075515717745075', '1388960944958441156', 9);
    t('12033e19', '458883185', 17);
    t('155430719053377666277386799088760775939080', '155430719053377666277386799088760775939080', 10);
    t('206142346532535062330364656312416520634234521450614502', '1312201569241680518802305709945691263438445736', 7);
    t('111011121211', '259249', 3);
    t('4a0687a7a455a92b8101638727', '212245593684005354604310715375', 14);
    t('15fhdb8gcg17ca4daai4b', '49141072391005691770808896', 19);
    t('35bmllo0filj87hmoe', '3639448929253283009287022', 26);
    t('30cd1039500b4ab6dac54a49c614bd3a851b1b4', '1502423755197224198218677083417578305925869394', 15);
    t('19ck0a7476b8146ci0k7b3e6', '10784621227701209583410027023454', 22);
    t('jh821e8t4onq', '703971165467730682', 32);
    t('2ccih998858bf1f1h4gefdh98a9kf38ljgb', '11288708847794836487628299578289569053830362671', 22);
    t('136030', '136030', 10);
    t('621301550003036553464635301440623601534020222336132356653', '1336170888382484501976014506902352076175198389248', 7);
    t('c7xk9wfj3838o6su0eikx', '93045511580118968344881438576158', 35);
    t('npj', '21469', 30);
    t('21a58906c334d0208cd37b20b0602', '262325768672641862422584585884490', 14);
    t('l8h7nee7wqtpfw0fxhdj', '2663559215161630225508053538953', 34);
    t('2', '2', 8);
    t('1010001000000011111000000101001100001011100000011111111001101000100001001011010110000010011011111111000011110101010001110011', '13459691377936385656205820498694591603', 2);
    t('6aonr', '5152317', 30);
    t('141023221242233231310523004', '289378994775032790796', 6);
    t('1220120200002120122020021', '539548971703', 3);
    t('b24med8f1f2dfge0c', '483364700771293735772052', 26);
    t('1840p1', '15608139', 26);
    t('ztl1vn37v062ms6t', '7919265633809577167295029', 36);
    t('20425420504320415140035236441560246636135235', '4563739435349096802532430020917212365', 7);
    t('1m5ccvktskp5', '157659130001415880', 35);
    t('8o', '288', 33);
    t('240c65a596', '24532236839', 13);
    t('983763db8j57bchehcd435bga0e9h0bac', '4040882893213836419463664776313088927524612', 20);
    t('2201200102221110020000022201221010', '15170686366681812', 3);
    t('456374', '1109896', 12);
    t('70m8mn2ba', '1073573407785', 25);
    t('451aakninemmhcb6b2h1p227g0n56od8dfs1', '20853955252647719617988537600784407469238338538745341', 30);
    t('j14k513fd1elhc79agqssuepkbcr2ju7', '324947526914571293920860403904607004779325895507', 31);
    t('22680488', '11036006', 9);
    t('5c3bg11jf751fh0jg60i7gfjfdi2kgkl3', '50354032529134077402872376698216146306223649', 22);
    t('3c650110b937028a4799a6b1a55b772c718182', '651168490122119567243142061008190429370417', 13);
    t('1221032311120020101101033230200302323202011313101001003132221111121303133100023322101132', '39371883765686973625144887114028494953808808960304222', 4);
    t('4099gl', '25860025', 23);
    t('25e8g63gff11gc17d08ea34826ddbgdfagga', '27273517546344897300623839432182770845480659', 17);
    t('12a96edb754d4d6dca', '116318229977030547115', 15);
    t('a7r01598mcsok', '3634911087742907341', 29);
    t('8lugnnh', '18735214013', 36);
    t('462338084841', '462338084841', 10);
    t('3203123', '14555', 4);
    t('1jhwtj2p4rl', '3250085526472387', 34);
    t('23044346313736', '1310562293726', 8);
    t('5lpf0fh0l9fn7li', '15558130210796154919424', 34);
    t('13do6afq9o84jnaggjan11gq8ihgmqo49ko18', '3821564988333362537058780890229032055458378165509784', 27);
    t('18193e4c8dlc5hk7iib', '38609061493103824129546527', 26);
    t('1h02g1kj7832642l6d', '117460092015601351103221', 22);
    t('72186117768166364743807116578515315415805223867883384053', '220528602283214676716138238392247863019093407607117978', 9);
    t('6ik6bc2k96gmi0', '3438006927862011506', 23);
    t('762722210536357403530500', '4601638793217664004416', 8);
    t('2dh3ha273465c12f', '41472924050752232897', 19);
    t('104413305412351302314043503540052212312', '419908180423076828270954660852', 6);
    t('6', '6', 13);
    t('1g3hh6bfde4f35', '77925319234957436', 19);
    t('49ig78819he', '27748810576749', 19);
    t('22412142010434432110021004244121', '11975887279273703196786', 5);
    t('2bogi', '1703507', 29);
    t('101111100101010010010101000010100111111101111011110111100110', '857171914848189926', 2);
    t('gtnjivuoj64ki9', '624581256882734387785', 32);
    t('9h8f5nh1ph3qe9glh8lft06p1oc5k0', '65721260945294966804233759504775006489069100', 30);
    t('151132121055324332334031340133105132441504412305001233331', '70457366252732538353135178251613420869315383', 6);
    t('f145aggec1e7jjga4i97279ef', '252676495567805480924286038779895', 20);
    t('7de7cag27639158g0b565910d1b0be23c', '18504577862769439979869071005055514681936', 17);
    t('475294666089764828847579973438', '475294666089764828847579973438', 10);
    t('2301', '834', 7);
    t('k8e4b4jkmhrmdp6rp1n7ec38o555275b', '14773238036137641376439746063291883553488634503', 28);
    t('fc3f66gd3m6db132bahaji2b0', '7457653487404061820814558204897923', 23);
    t('111222200010332331131301121103332210223130202030200012032230321111220103200021113', '1978880662522375880691401912877401491165359768151', 4);
    t('75899793636343882742', '75899793636343882742', 10);
    t('eo8496ka6glj6c9g4uv7cbnq2q0cd4jpg', '377805709401704966595895997759561079844005820122541', 35);
    t('7nacmugtp8k6xm66a543', '963315084681439473869691613071', 34);
    t('7', '7', 17);
    t('47cle2eajl4d4li7ahg', '6332844204194445871554582', 22);
    t('12107170aj5f52ielll1be', '16962840667954795901484794380', 22);
    t('55bww8w0t0eghb8ls55dcl6ixlwv15olhaq', '162308148448278373157076294786164277284790340959530326', 35);
    t('484ja34e81gf135j3e2ac56e0i7hij', '236890988768063667108553222280578943179', 20);
    t('2243232540752434710611323210536463', '1469808842581774120550500842803', 8);
    t('p575eb5ca5038d3ok8idllf2e899b5', '2726961239011011355236144568961137638537999', 26);
    t('2b1bd606021a1b', '707917646595659841', 22);
    t('2ed9f432ejd0f11jcfj1f5al9b2bk5nm27280', '2223214645127163142355016653760898495984516506656464', 26);
    t('152bc54129052ac50', '2987450448112457894', 14);
    t('46066728688271603364', '6316495850515234477', 9);
    t('2g5d0h7g0gbmf78c79243nn9', '148727643469245968217529721296881', 24);
    t('15lf11bf87j7jci121kma4nkhn', '39880191485245317293588274721343663', 24);
    t('hh577s4nnlha0gi0s', '4402448697185571173522937', 29);
    t('ca713dba8442e', '1647538652528819', 15);
    t('284dfddhg', '27099949678', 18);
    t('1610kf97j8i041bb', '174505901776678878593', 22);
    t('8kt18kxjdwg4q3kuvknkwf2m23fnogq', '180423804171461723659383672666400155952750669236', 35);
    t('g1abca5091b2cfd77a42559cfa1705882e81', '187251468917148330282582773146445435959176796', 17);
    t('3303131212212212001121223303303323000100022312113322022110101221231332303213132', '347481362131991515099107296900808626703171271134', 4);
    t('10718a989932057354a4601117981469033274a', '3961930126752739711210993249170997323907', 11);
    t('113e4g13546f6i9ej14ii', '111073560433528497263849978', 20);
    t('2li2i2lfj3', '5308535621389', 23);
    t('54knqyisd3f1qtn5lcsrqimc5', '58593465649571042522289076646796218500', 35);
    t('2010022010120011221220010122020200001020022101222000', '4570711546653019923644655', 3);
    t('6042532553115031666', '109306485388096438', 8);
    t('6ah6ehccca1ed30ch49f3chbb6', '611921790018452815367943572833440', 19);
    t('960087e1ab29243087', '926162178026733465877', 15);
    t('l2lhfda4f8c2kpecq9e', '4439523739653117128740893076', 29);
    t('3a8fq8un9i68qu7nfu8g9m6rne', '64072841936979423961636673759087451780', 31);
    t('20865277352048389955531777302333293367153791034484', '20865277352048389955531777302333293367153791034484', 10);
    t('74s3lnibf977jg6r2kfq0785hco5qf6ghsjq', '10952987102780656964577606541072916821267549127588375', 29);
    t('aqrwo4u14gmsqb80p606l9c', '53151205860039125228759211533105730', 34);
    t('212222211102121102002220202102221012012001100010', '70884984454458032820162', 3);
    t('2db1hciffk0hm0e6k40', '8389881219953798948711887', 23);
    t('2kcgcdj47ii9fo9d63dk', '4330238080712124271959724007', 27);
    t('6e7hc7ii81j52091i8', '88076484386866246472768', 20);
    t('e7772iik87lc17dmagacj1hi282c7fl', '1017940669032249205173001354895673774197894', 23);
    t('e9ee099c86950e5cd055c3', '73154233593336417594233808', 15);
    t('114320330134242422200031242123411112401023032042310442412142213311341204321', '7345000213858373240721280688086693345479506507366211', 5);
    t('j88o3pi34mb99l', '78248748988488054576', 27);
    t('15d1fe6b5dfe7e1a87573a3946b42cb4437be39c6', '1993149199833169001344544884949567309662274861510', 16);
    t('1ar5ld7bhpweb', '2214925368227004290', 33);
    t('2sa2atrt1bhh1a', '71145664465186679354', 31);
    t('18rgp8mhc3g6cvfamnrnkev61i0lpr', '56950731880511586745670579431418877456701243', 32);
    t('54750443750225316571406736430512671452166747632', '1958033248391176678532214751521115754712986', 8);
    t('10033312210131414322321312324022212541331410155345315450', '6389651250992348768646795839155231300106070', 6);
    t('2001', '55', 3);
    t('110110001001110001101001101001011100110000000100111101101000111101100100110101001110010001', '1047466460252578697656357777', 2);
    t('24dc49e9660gcd', '183011576916166653', 20);
    t('42122277123352400676', '615387804455272894', 8);
    t('0', '0', 16);
    t('1110024243220212030313224420010414040224', '2257245111890157772228268189', 5);
    t('5433a', '111070', 12);
    t('4dd96b56229865b89a161511122a14600007', '65059146911706674028661393829083246616519', 14);
    t('4m9', '4269', 30);
    t('1', '1', 32);
    t('34233430413121304312422', '9322841380150987', 5);
    t('61mp8fo48jlan56in9gmkdhfg9c0alh', '17083001674217793608388954599991083027738235', 26);
    t('32hvfwcdfgexkaw0n6ifo45nvnu7j', '52637066972675961314961424822511197998983139', 35);
    t('noodmkbwaj9tm528epefa87', '60668696101764660552956150804345518', 33);
    t('50d7k398dfikdc954iic8bjbfe3jcb0i98e81c', '42044682017147219899812045714230284465317216035715', 21);
    t('57c89kfq15fd3pkco0', '67759519628186541120701520', 30);
    t('53176', '77402', 11);
    t('101211210202121000001100112010', '82697070088632', 3);
    t('12d633', '905898', 15);
    t('b2rtvc8g61c437iddjuthv8', '28319832096437414138598301478368955', 33);
    t('6ga8d5h5g9f2f1fe4hbc9c5b7', '9262426469570471976898418380753', 18);
    t('17110233227503265253014384471688317133280470764448630707', '54520949680778856452144908392364747704157731362612641', 9);
    t('36a7c7709df98c98d9bf0d8037e2e374f003c1', '11394536016349300502893187504942759921712585249', 17);
    t('211100001220021021121201201002200101', '124166832733905544', 3);
    t('1l1qjc84j7pqdb5o8lnp2js1qo', '6267531622610675770077756739540891303', 29);
    t('7bi', '4314', 24);
    t('1d58555c755829deb105aca86ad2add', '362671265369959944822892451673948583', 15);
    t('10000101011010001000100001111111001110010010110100011000111101001010000001001011001000111010010000011010101111001111101101010001', '177330090800059334179372876785623300945', 2);
    t('5rmq1hja3i2htok977', '76520833163682115657688317', 30);
    t('d2brswannhgj3dlq5n05', '929158307404877629186032129341', 33);
    t('4pc21d0595qm6akekaffschk', '45628774689731521025778390467417330', 30);
    t('jpa', '19044', 31);
    t('1691716c0670488844023aa40c20188381b82cc302', '7115945393660134960643716538173622961377844730', 13);
    t('djrpok3d6kkfg', '3184685238921417716', 28);
    t('18shakkersigg179aaslnd1', '6207140351700911819450122511814847', 34);
    t('16gii99hma3mili3he91m', '11521470163607970255895536922', 25);
    t('4uk404fu5r5bdwu1ak9gand07697', '1096743830617243267478450024447881641715561', 34);
    t('177a69e65c0d5c23b', '9858342665710869131', 15);
    t('20a772797373a501749a', '127724571524906942090', 11);
    t('10e5a57g96279ah', '391367132694107585', 18);
    t('1h7hhhfe2bd6i11d96326g7d', '494193280655696512736123393974', 19);
    t('7672ff747c781c06ec82bf84418073cc9158fdb', '42264090573810039509111928267687533762028343259', 16);
    t('33908b093481777ab43bb5271273b0755570243606', '584310085758916620977709600135575563060196262', 12);
    t('123231331132230331312022003', '7801961318933123', 4);
    t('1', '1', 32);
    t('66je9gr0ha23vrljqp2tr', '14542761384658132443821891589168', 33);
    t('50tr39qo5m9eja', '594238253683306042450', 35);
    t('1010', '10', 2);
    t('2c7d4bd1cd6167cbb', '6311101283107439389', 14);
    t('23e20bfb8hhed30c2c843a87badi184297f567f', '8599266531496302272627406261206189142556716915261', 19);
    t('41526780b9a5a17239720c92a3a0b54135bd39b09', '28686410109773337194021152769532941934256864189', 14);
    t('ecml001aqoe9jiq', '4296982938641008844248', 29);
    t('9c9294297137cb8c4b01j957', '8072196030039931406649024315707', 20);
    t('710b006a61846c1b6485b9a2', '295698290243613321492343567', 13);
    t('lof0hf', '448075216', 29);
    t('1492380631939476422', '1492380631939476422', 10);
    t('18617787217', '6853402807', 9);
    t('28', '28', 10);
    t('233025524522200322430510512000143324053140010223351404541514313402', '982649847712429965283271312633628451452240511169738', 6);
    t('1c1a6cbb', '308835626', 15);
    t('3i', '114', 32);
    t('1i6chph3robe3ko60b1gd3fleqf6hdcfo9j6', '738415477605791828889810374125732142138172965238442', 28);
    t('416d94816d6c7feh0cde02eiaa6iagf01770c', '44142204501594531372888971214564230677789639395', 19);
    t('5fdf6andc0cblgci248bob183k', '499314055028383130819138235346114470', 25);
    t('b1219a76298532a168636973ab', '10587337000034099908821844595', 12);
    t('1rg6o01h5oi0njeqkb7o1r88gafndlan7', '40440720236650984662808240649217148711435143915', 28);
    t('kc7k2ddbdg5m4fg777geg1i89fajf1fe', '33580873055276588035833179463849652564714137', 23);
    t('4c7', '2807', 25);
    t('50d68', '256148', 15);
    t('3j8lfa0', '921431500', 25);
    t('4d21233cfh9h2he4', '314977287497448880315', 21);
    t('22ptrk21dlua2difpbga7nqfoo17nif', '2979844012644061261709624973913718814284176975', 32);
    t('18ccbk9mn8', '13768771588524', 28);
    t('3akf5a1okjdf9i2', '220305847680983116834', 26);
    t('b52', '7002', 25);
    t('20f293dah58dhi6591774if90', '10002849645651587260522047835251', 19);
    t('nirh2c1rlp2k3', '8368956114944618930', 29);
    t('141671751106136325535453330430775232437321543', '8325279825157794222097655945192898667363', 8);
    t('58a2b3d05b929508b18', '2400541066384412592866', 14);
    t('31023001203013012002021120200330112321120213130122023130020222330', '1120571363755739421100727158868165036732', 4);
    t('72e7bed4eb579abe8684d4908b0184cb45ee3b33dd', '11938380317430849854727246010136297539608439111633', 15);
    t('66d1', '26321', 16);
    t('8j24l7eh5a14576ddaaj9i3dabcifhh', '166156615220176117320330888289725612288371', 22);
    t('9i', '207', 21);
    t('1110000101111000100101111000000001000100111010100110100101100011001010000101101001100000000100101011101001110000001110011101000001110', '9590478319392434269891419865097211165198', 2);
    t('115156027', '481106335', 12);
    t('1144850cc6', '41741581011', 15);
    t('1487132dabd4006942ea4621e5753f54520400535ef3', '7680300593500415724655977000547063327920546737512179', 16);
    t('10546275881470641020601788147547482777581620632', '83907179991104098938515481963287844552882413', 9);
    t('334cfdf0g8g0dd78084a1e9c9fcdef78ag8e7', '4924973649792829875901725536375255033046058627', 18);
    t('2948fb1b9376', '161562182577000', 18);
    t('21042a641728100chad9ef8h6d7b7c3098dbhf0', '1031417459611470715458453074567717343310137625146', 18);
    t('15f2bjhmi3jane4l65kn803d0dhjmjhmf3bh48', '1443199917648326594528212198138420579039397582219432', 24);
    t('492c38263b15288875198043a58417aa27a2322', '10065688820077810586833059893292051419004944', 13);
    t('33233013302021011031220010112', '283479533598179606', 4);
    t('4od7gmh2e', '1032178487094', 26);
    t('9g08hgf', '463091841', 19);
    t('3do7n1lfh7m4m57onajanrnhqn', '5277516132422516396735738514310367807', 28);
    t('2322ca44cbeca009cecc2dabc607c253c0ede', '4826418133925788145647532256925808902342109', 15);
    t('1101010001110100011011010010011010100010111111101000101011111111111011011100001000010100011100010000111011001011000101100010010001111011101111010100100011000010001', '9703219505953893074023234217532878016916428047889', 2);
    t('8ca', '2250', 16);
    t('1101000001100011011001110000010011000100110001000011010110000100', '15015958852762088836', 2);
    t('dvjl87viis0gkrmcghlrd7q', '240395536768968656611032877948245158', 36);
    t('2a', '82', 36);
    t('111210120022010000110211002221221220000021220211121211021120001', '584945674767242374610105648344', 3);
    t('1ai9132i20a5fgi721037icd8ag64g', '19134774517743882367815280823402029739', 19);
    t('11110011111110100111011111001010001010010100010010110', '8584226467555478', 2);
    t('g703h2dca60', '272444928079086', 21);
    t('10210020120001121102010211101102021200220021222120101121200121202022202101220210110', '1679155601670174046538269979766608832201', 3);
    t('2d4c0a43168909a302959c729a7d61dac88c6787673418', '242496727538337888410218936739166557375410421370281048', 15);
    t('44182a6d51a945a6a5cbe', '1421060022593917761957254', 15);
    t('322125', '55977', 7);
    t('7263581986004721570413a2739a67aa83484237817a00a2a', '701827631601858999302922019818257157812697798613760', 11);
    t('5c42b9c7003c24696620468954b29cbb3800b450', '165259584116068790832545074144076581971429835', 13);
    t('1fako8578e8uy8bvlnj95', '10936625165885490373805378810345', 35);
    t('ess', '14350', 31);
    t('nqs63sn7ska0afpfj9ob2b5', '3562053305005166648568447677059132', 29);
    t('4153913738413582813112676402665839356882390406053', '4153913738413582813112676402665839356882390406053', 10);
    t('10', '11', 11);
    t('21ni3ig3fdm5ak24qbg9faqpnc648bgofgpa', '923922508138801830427813012811681004567930200769030', 28);
    t('c5063b871', '31613731531', 15);
    t('133113123230232030111101031013101303211010113000130302330313013222211013123100', '44767247228757594878589756004233521788175546064', 4);
    t('ggjfk4cp1', '3475798835003', 26);
    t('c25q', '237815', 27);
    t('10c362c311ac7a583b35bdc6c2989b90d6abcc84c73b427', '56002849258572207947726688091124294570134439897478763', 14);
    t('177c59d0fc389g3340g71f79a2b811444e5f1355f', '23761033881708446864722030370719581689404930279586', 17);
    t('122212220012221002101022101210102112212101012222120021111202110222220100022220211102202012122002022020222021', '2239868430693007918519867980663532667540649890303176', 3);
    t('v9uwm7cslow8gxma0vyq6hlymtxplqg', '656661129725170073836410425741911682455436847276', 35);
    t('7x08xllu24op4byosm9ltihxjewibl', '10747943758603250784828832033535923549465833153', 36);
    t('3ajic8h4jji8ahfadkd71', '979685512478696901448807321', 21);
    t('39904l73ja8jd608cg076m3anbb7k2dhglcl4i5', '95128101998246343813523478731453034388462265997768885', 24);
    t('13d75b964659495122b477d3253b201b8', '6087380592454876448304034029996695910', 14);
    t('239bo8qho9dbdf187i8f6h33i', '114276554361298256463392230807709014', 28);
    t('r', '27', 31);
    t('22439348a809183a88a50', '1492002089284103770835', 11);
    t('11502245241132103500255402550454540604341255554516024022114521111', '1519687960622981585676593638948280395813952883484605445', 7);
    t('178ac7i56c101dagac80g7', '994276001910959615043844218', 19);
    t('ab32097dd97de47c4f76930046f32a1', '14222362164666534040463596276719497889', 16);
    t('h70nie89fkng', '41202353353372466', 25);
    t('8dodbheltf29ensgfend90tmv1pe', '367182433456718603593958892406561938835246', 32);
    t('2ro6d78uogvvqatywvhy', '1028055008673794181515446812022', 36);
    t('a0je', '80394', 20);
    t('b0a7m1cbobk4rln', '8334455843425820422974', 31);
    t('350', '1562', 22);
    t('ad5285g52hdica4c1a0', '1113997739784091562392939', 19);
    t('1266513240443235025011542435215551161116052', '445444030178987216515247159044782503', 7);
    t('i9fhkgc7a8fehb8', '3339213521202402120908', 28);
    t('5pkrtcfr8cerqo8ipka8kme49p6ndm13nj', '32557148939358327987280716163959952063457820750409', 30);
    t('d881c3d55a3d9a1ab22155bcba6880a32c831', '2480623568212133413145101410008494284467243', 14);
    t('1i181nlbf4ihf2n181jlbc7mjl8kf7ki4n', '6174255537646104877910561539949873285987455223', 24);
    t('12100211221201110111200012210221200011120011200201111022212012001101022221120021220010211101212', '1264246371202182024824489688458885819892007097', 3);
    t('18p04j', '26779257', 29);
    t('175smiphiert0icrad6h69j43ktrobas6tscr', '186110422740954237972811643773335017903308645946068587', 30);
    t('j31jf849bhd8ge7ik3', '5562425811185304078419043', 24);
    t('aa26298a', '4348115833', 17);
    t('a', '10', 20);
    t('2005de18a020a0de6882170bc1b43298acb4', '291477737292846364616559097414390155525994', 15);
    t('889879000997066842936930294683621095', '889879000997066842936930294683621095', 10);
    t('bj0bq0nbka9482gnfj6i', '18376271230937994256598748855', 27);
    t('11210022002100211112121001', '1352518851547', 3);
    t('5cdb', '28265', 17);
    t('wgq0sm8v88qipu4jl55wdmfs3', '185048329912249256046507375601716367543', 34);
    t('3hhbfa26a6ag0h657jngjne0gm', '119674172072479416223149913309701526', 24);
    t('966fak005ekj9e91ke3ilf7h6', '1534617368221003391050212773784944', 22);
    t('1d4ih6d3hgaib', '11991106508998187', 21);
    t('40gvpk43a0i7x94g8oo501ccbpu', '26430135653734764560098269423411491767516', 34);
    t('240ba639a2b64033773588e7b763b5135', '97942534619350353663913105286511742775', 15);
    t('683808a457ab1b61b6d60339831515', '11391383242216318199571205789803407', 14);
    t('9gg6j4k35je53jaj150', '6181958445081757496538513', 21);
    t('321313001000320223101101313301230313301132212222023131032222013000300000331221311103', '338247732186199822617132923037597361245860046216531', 4);
    t('12013123311342314233134100', '421194664960052400', 5);
    t('12030220120032122033320002313313221213332313221231133300', '2011157666555401095987816028362736', 4);
    t('8a3l4gafc0m2a513hciechb1m1ieh782ijcb', '17095480346983415895985102058484502145825487853547', 24);
    t('198c811986971ccf4c7ae1d257bd14617', '543363838528230108444050115794098538007', 16);
    t('38o49', '2667729', 30);
    t('1da10785dba094271a0853133', '6364020275909582230507693161', 14);
    t('25625405646456255440253434530105642535166540551600530343', '85992026238312929162701996737786316819479861911', 7);
    t('3bgf2ef5afaa7', '127353903362695543', 24);
    t('68dex1o32tn0l6t33k', '677341342496752070722244590', 34);
    t('c326c455446c1846b028650b142a90', '2467988856215900113554830957527735', 13);
    t('27153a0209195a12442144002943717a72417001a1684', '17551046277853328651208735650016780160738798650', 11);
    t('1553004033284', '1553004033284', 10);
    t('20', '6', 3);
    t('10020022210212022100200110222220122202022001200211121202011221102021101022211', '1967321487242019672711309698612514787', 3);
    t('daf3b6d57572ab962da81ba7100ea1c01geb5', '2697762624776499737414767670932022089986035272', 17);
    t('2a95800', '13635934', 13);
    t('1077854802720401556208188660715424', '33911117740835848829495038574110', 9);
    t('7335121015337612327750625531460025777262', '1234844453153886969183275916721651378', 8);
    t('253272123047374812418881680107', '12229562920471835831260364707', 9);
    t('28246143458208570507420470627448606245', '592047740537531029039695756680392592', 9);
    t('88g3531ghe47l3bhg8fe', '6385854850376914436410648932', 26);
    t('cg91b18d8ffe17fdda67c94gaf1dcbbe84g', '8877530717131611365758781215750878707501327', 17);
    t('11423126362025406', '40931493129918', 7);
    t('fnnab926fl7h311dh89ael4', '90707709949122827343223226337404', 25);
    t('22041030131244423101', '46420979686026', 5);
    t('12lg639iclme7a8jjkfb5m3038hm7c6m2m31andm', '754799287626894199405656579173085804877204040517935374', 24);
    t('3l2b3qi100mukf', '89853492206992969252', 31);
    t('1fh4g40f1530810bbeh343d2gbfe4h3ag1', '500820818178766703373445527247524807984049', 18);
    t('9293939', '9293939', 10);
    t('1llcfack6ghai5db9mdcci', '77118891790688562859651405532', 23);
    t('11432112034140244342124413210203012021241020023114341233', '385139582158041869703117414736354058943', 5);
    t('8308a74a959243410a89116259a', '9867615035253851484907098008', 11);
    t('4g99', '44298', 21);
    t('2jcht42joa2bkcp8a63agkc', '830760916763039680706280898515012', 30);
    t('4ln1cj15bihk299i28fgj27hlmm489md', '30066001737656440754502736608642901647230557', 24);
    t('3oea68q9bpjs3eknag8', '8056944497162955537298825205', 33);
    t('63eh66a67665gad92fa3eg756eh66gc4', '5090244877148186916553478619985250564812', 18);
    t('11111001001000111101010101111010100110110100011001001110111101011011100101010101001111001011', '4819067998434611218882057163', 2);
    t('32332430464240256001146045200236310562160661444160', '862436561440195610645043053487346040135069', 7);
    t('3033310222001233103003', '14281471358147', 4);
    t('1talc3of6pgvtfnki60c319qhip45', '2671445363930637285453293589205968592921733', 32);
    t('14b88h2a64h9eb7b180h55d2cc0958cfe', '18546971486428099560785204564726497876220', 18);
    t('8bb780bee008d95bb46c61a3', '9858567156569511176401293753', 15);
    t('1517cc674d47eaa', '218748902058933633', 17);
    t('3h59993b1e5', '14144442895085', 18);
    t('2iatvo7gf', '2829242342927', 32);
    t('11d21cdf4g8hgbc86h', '14191954690468981059337', 20);
    t('12vpsc2rqq', '38476342980442', 32);
    t('115bgd5b5f988dag', '7239369780823995736', 18);
    t('409n59ne8533o12rh9d7cl', '9856837668406974868410246784661', 28);
    t('35076930aa392955480a62237a1a6014710a', '9724207798767279949903395457416695518', 11);
    t('425500504', '7550680', 6);
    t('kkf221beom61jh2gobcj2k00c9be4', '86524752967035174099147414982995233177380', 26);
    t('1', '1', 15);
    t('1vuhc0b', '2994074691', 34);
    t('53235442050545103344550', '733647565874904402', 6);
    t('2j47eqcorpexvwt8k84flrvjj74pa359ja06', '1024286329198622500448450238532515199584215260718394422', 34);
    t('1hi4mlgwh5', '71093615250905', 33);
    t('4dh68l874m1b2g0k7g8cc1jj23o2l0elmefa', '151263649369190377647518450909854496784718245462152', 26);
    t('1240', '469', 7);
    t('7kbh51nf8nd4b', '466030895657789486', 25);
    t('1000', '8', 2);
    t('12wxdup8db', '109782501177503', 36);
    t('digcef32fc533448e8aif8db8k3de8a', '64480886700586659856294991683281947655160', 21);
    t('4o2', '5150', 33);
    t('6008876027824378607323267735681760411', '135448018472400810939023044683257641', 9);
    t('3hf', '4285', 35);
    t('1d5jockj5o28f3', '2278802922177380378', 25);
    t('1eh7b4bnak4elc', '3880602947847388294', 26);
    t('4m48kr7afep', '7153362074610172', 33);
    t('11fe', '6440', 18);
    t('4bd2646ba67c1c8601d579', '5684511546512382995795239', 14);
    t('jbb3o', '22939908', 33);
    t('441432102412423022113230434443230222200444340410212211422241103', '105764167603788002379416021764167189320118278', 5);
    t('693ua2pac7t5', '823025751705624713', 36);
    t('1d15a1', '1422151', 15);
    t('1858534', '1042906', 9);
    t('79342dd90631361gcc54c053875ebb2b3e984aeg1e30', '611944223012432862605426228702591634892516011343824314', 17);
    t('ohs99', '41140557', 36);
    t('blmkda2', '2276931122', 24);
    t('102420314023322220', '850994354685', 5);
    t('23', '33', 15);
    t('3eaa4c7cfgd88b77', '11049592928959128173', 17);
    t('7s2r7enh4klqsg', '432126166790924355568', 33);
    t('af4', '5639', 23);
    t('f01b522dmn9e7kp0b5g4bheln7mnefbc6jl96', '13037461943521682948211857727883424231962156108335356', 26);
    t('kqlwbq282j8u9q9ffxgp468ist7ap3rt', '6216832805199435867202542241926072963789701207623', 34);
    t('d96fkii7i20d255i9g6k534', '1649490761867743340632538678272', 21);
    t('fcg8ue48', '655411007435', 33);
    t('24289nd', '414836341', 24);
    t('22122002213302203113021210110221302123', '49145148846184613452955', 4);
    t('6vph0up640u4', '251974013283337156', 32);
    t('f8cikf0681l0hf8e9g5di6g', '5254646220406358219380292021220', 22);
    t('kwao6um7be5rs1h', '86611757767034532188852', 35);
    t('e1bl972i5k2l', '78122648549972001', 27);
    t('9747', '12877', 11);
    t('1lksrr7u', '85911461456', 34);
    t('1223322120330131002223033013', '30374623384875975', 4);
    t('443214453', '7996065', 6);
    t('43c', '2587', 25);
    t('2fes8aol48bh81ohpabrasajhmscge2', '518146223108772795960839685944410913480618822', 30);
    t('20203024323143413012343010', '621374920377074755', 5);
    t('1', '1', 12);
    t('aa0lg6h9l', '573814360943', 22);
    t('bd70012bbdb53b5d2', '573663294778570368519', 17);
    t('239ed10cbbhee855g9', '4802380765995946947237', 18);
    t('22uis68', '3221309812', 34);
    t('ak7mfor2d869gpkhl505f4e5g0ogeat', '5865849748702540844254563979641472462990066379', 31);
    t('5724a97a2c28c9239b4c82c24b86892', '14547506169643477096795713397236176', 13);
    t('4328b574c61866', '1286203061783399', 13);
    t('104431344433103242341404300000304013211223033122340424034413420031101', '405686721914999412775855564051467307713591564526', 5);
    t('2c4sg1lkami', '1017993753533358', 29);
    t('1960489310a11299202664431547939a38a48745556a085a1125', '241227213092126499005003956230016230527788026414070835', 11);
    t('24s7i5i30os0d914bg1f84d885qe7hh', '161698974156390625196048193402829173858804514', 29);
    t('b3908e88kfe9c73hj6g646eh', '83789782476702429147335816721501', 22);
    t('240k0f8emlca9mbhl7f1im4gh9e', '4799009126114249598188047801242057739', 25);
    t('2l2hdimhe9ghhrlp004ilucb72lo', '49535259940385235819597981796368276475008', 31);
    t('0', '0', 31);
    t('1bdi1h0be', '58823658866', 21);
    t('212122120101112200020020222112010102111210100110121102100101100221220222122120111211100002120022202', '150482228156175231923706170828095340312341047317', 3);
    t('94839aa9789403917659313531965350768976a1910078477', '915133389834165806424172578480631193246796372988381', 11);
    t('2c6c7bbc371b70c910847334aa68044002', '17063007174308160689263160442437073677', 13);
    t('lhvd4rd7wrsutd4trqqkto1n', '1816128740873245045862646604444664981', 33);
    t('517lkfo86mjk1n7n2', '117639937337022657004952', 25);
    t('44440410224320021021102404200343344202100', '45414259359901534405710537775', 5);
    t('1377', '5906', 17);
    t('432515211531405012421143504541653342665233161034344', '8065571726594635162433197674859531479206439', 7);
    t('81em8f45tl24dc6hd0y', '82918246775638900170726875698', 36);
    t('1cnwccs22o75v29bqdwio4n', '3539668494095448715446596413354433', 33);
    t('54gl2dtvn42594hv23mq0', '12048842304748264619401149083853', 33);
    t('1nddnha9cdm1dn3k7881fefn', '110139605060745517578151640980223', 24);
    t('1a57a67650755493', '28851425417366895', 12);
    t('699813005753897145482303531413094', '699813005753897145482303531413094', 10);
    t('ag69c388dj8i408ha8c7cgj7j0c5', '1451725933112051761879128259646072245', 20);
    t('13222222210031111130232321233012312', '565698333742480159158', 4);
    t('101110001000011100101111000001100011100000100010101011101011110', '6648324064296392542', 2);
    t('65ef9iie9cdh76bab6hiahbciaf251g4f2bdea20g5', '169249660939047170839859107567643191800346320651365749', 19);
    t('38f1l', '1114605', 24);
    t('7dfga9g84e281b', '77453725087312278', 17);
    t('2002430262261656351626655', '384633596358941967644', 7);
    t('ca5b8a672pf5ippj', '106581144305861002491231', 29);
    t('206114a28e5g9aa12bce3gg', '2373768079789299543687455581', 17);
    t('hbga737h34ga1daa', '267564050311526319341', 19);
    t('c04129c1c5b256985547a2d5b4', '3034717347366835137853819740169', 15);
    t('2038b8395145018b1859143', '6493696699375975441988366', 13);
    t('g1lj7d5645g04f425gcjc48h08licbefg36', '320008217406229552036847710020507416486827465931', 23);
    t('0', '0', 13);
    t('3ac7aa3d08329a2154488194b8a4', '33324072746206645734229083957496', 14);
    t('4e4b59ed1eh29bacge4fe', '494027070921698549161073914', 20);
    t('4w1yb8rmjxi6pyb73n9mllie3m', '3952815466325008300997301039270247882978', 36);
    t('36e657d3mn946713ah31', '548520023861409567040008841', 24);
    t('16a7ch7e0a912ldfe', '7852157934742461265249', 23);
    t('31301312021120333121103330013313023110303031011300311233032200020', '1172174447792103378391730954993204520968', 4);
    t('asb258hmcq158giujfa45rmp1oc2c7h', '6009860777245419450358424932959970683463301731', 31);
    t('c72aa5983434a402bd4495bda1a2b0b09c43', '162885167490333694639671517686243008655363', 14);
    t('191eg78dadib3g89j7jijeddj53e76ghf0jd', '4997116531571833235829685607931752303798040393', 20);
    t('30', '24', 8);
    t('16on5ubnnlffa686qdtlv84lis', '476230604866451011428299429332274193508', 35);
    t('ft9cwj7p33d7', '1113269202350042901', 34);
    t('222925790439a6b0311', '58195492412230313149', 12);
    t('17', '20', 13);
    t('8', '8', 23);
    t('10dbaki28p1n', '36498654162609207', 32);
    t('100000001011010111010101110111110011000100', '2211226025156', 2);
    t('bdh73e61326i8efc123dajd4gh', '13247082642257436461441956203094688', 21);
    t('dic', '14763', 33);
    t('475ljmi', '638863244', 23);
    t('pmwlato5p5kr38kv5ivw2db2', '2166192468219479078300821352145682277', 33);
    t('58888742714214050', '11118073401333810', 9);
    t('0', '0', 10);
    t('4c2593', '1833263', 13);
    t('2blc074gcf338l8jlk2c3j67k5ecc1laa19', '11168027403783839957537190770067466250018138023', 22);
    t('306', '873', 17);
    t('659aalndqj5fq7ak3i21ar8ms261diqc', '13352886232933446314462823844898280803350736370', 29);
    t('5lb81ea5k97h88k55k84b5em3', '20812208971366572877903871625478053', 25);
    t('28061a7b781b7', '60998561699095', 13);
    t('6el', '4441', 26);
    t('12104124041124403124230300122242310313212010422204440432', '401595807449332275707879384828100468242', 5);
    t('210643566004062304052414653362624656513146316044622', '3888722318739881008495486311537716495435048', 7);
    t('7656785', '7656785', 10);
    t('3gc5b628c', '291221927885', 23);
    t('5d8dl8f9oi7jao90jc3ok85p0d178d6h0e78p', '4790696230811013371387757230147247746151708935785013', 26);
    t('45a355325a01', '3334702939489', 12);
    t('el2332dj142d8g5e209ic7l1g044', '274326948468708524021808420509292687460', 24);
    t('2bb4acc4577310d1dc56ddc5', '652844989883241073588460089', 14);
    t('3434042fa72b6bd086b5f583063b090b', '69389940122557978795038540059404601611', 16);
    t('10', '12', 12);
    t('59lfgd01ajhfgcl50pa7m777oci1fpold8oka', '18134178311410518122324250615259547644252541479219723', 27);
    t('22863533366602308470', '3147168928563013941', 9);
    t('11101321001230312030213211322212211323102102121300201321020230123221032313033012020', '30864269282351344438300145758376863318773480616328', 4);
    t('ka5jkl9jmgi1l20ib7', '2883890885775240798488435', 23);
    t('16a', '257', 13);
    t('22290a2215173a54a2866671510381', '3498085275681756354531507766449', 11);
    t('4ateqc7a602u7gk5nc', '468363582187112718878299310', 34);
    t('2jwrhlp1l2vqwimc', '242669198145793186437824', 34);
    t('5180a950fe82c6376276a586c25b5c5c5b4bb8a21e0e', '30493736786942864405814520647491453938628818133720590', 16);
    t('7gc9dhde97qh7jrkk9m8k', '1339208418660774078243962406520', 29);
    t('2', '2', 35);
    t('2hqggl57gf4car', '296547907725312545952', 35);
    t('1obhfn', '44052773', 30);
    t('220b1g837h468i0k8jacj0e99aiacggab3gah6i', '367971859156278151681088478078597463542565116078876', 21);
    t('3slhbeqb4fs', '2336752270561078', 30);
    t('9fba9dfiic', '5006751007572', 20);
    t('b', '11', 12);
    t('2110202112212000201220021021210110220212212212112010001001010121202000211210122220021011022122100020', '424779974687314802132686329219551262844631379471', 3);
    t('31203310131012230200332011301222023130222203021231301133221212022012002311220', '19353023903212453342031170287295730056309517672', 4);
    t('12001011211102022121100010111200221002020222001222102222110', '7918767309016358932950862671', 3);
    t('1kn191giko39rmnanmami0d1okcpop', '1618267741799710951160698245596470368688201', 28);
    t('g274590g3d339433f5409g57aa', '93153789439900839502721798769381', 17);
    t('114355421113441052252531344454145320425502543355542230230341301', '2280710056712985171545633285649256127813531828005', 6);
    t('1qljg9b4onpip210ejgjhqnefbi4o5qgqf171h', '181934681040486653100111314188490441438192036830569569', 27);
    t('1f3ln0rfhp32cpc2k2beaal9n', '83073842895898744962751209714293987', 28);
    t('3044620105315260006022454051154200600403020322442401', '38975248796668312873816449082327954581130266', 7);
    t('qarcu5jd9g', '926730400937264', 32);
    t('iadt27f', '39809934699', 36);
    t('as5j6jwsn2wuwu6dqvfwj9n2h1fso', '35806720670061293860275908093366493122960685', 33);
    t('132d1db', '13814306', 15);
    t('411012421314204032222021003244034241431110203114102110230332323023140', '1437423683089410133923877953778402432419614657920', 5);
    t('102011112011201122022120122011110120022212111021022121002011012101002120201211000012102001', '3610012680809677846077512759850762511638841', 3);
    t('sko63peesntu0s4c1', '20855468818550929727982949', 31);
    t('h101l8itb07n6mnp5g7kggk8', '340873021541152980574045898573575730', 31);
    t('gigfd6gchl594h48', '4483240787334541323255', 23);
    t('2', '2', 26);
    t('112202120112212021201212101012112122', '82063252134576179', 3);
    t('56tlfci3sa3hqhpffc0q', '206645898643826543326651723802', 32);
    t('2121101511515344340504024322521', '492478309307736431418289', 6);
    t('233422333052445505304550245302554', '20722197983174609053233382', 6);
    t('o0o6891a38fja50', '4375044340632128174956', 28);
    t('120', '15', 3);
    t('21df8f125ccc4e84669f376gb7ge01', '1015491273332046568254634184570102293', 17);
    t('35', '23', 6);
    t('76106836474581565261076641176', '4019346106874600080591778073', 9);
    t('3242036325015165633012605001064', '76034468686471006247354977', 7);
    t('13853', '19660', 11);
    t('352228197670828676ba38543645b14c8cb97381390186', '455621468378412697751523794288599424284167924062650', 13);
    t('310021201233200323033001011', '14678599968550981', 4);
    t('37695a9a311a90591393119a455327061a70971a303844', '269193409032346768263122865173174114039542613433', 11);
    t('646633456716673131010714325300106141144242503123341513', '4827567010183340607788016828465978158946284585803', 8);
    t('22b4ii1ja8al3k7k', '289377107308771432278', 22);
    t('ih9d74iag888edgh9353249gjee8de', '4161419813368104831931925475084453352109', 21);
    t('162h6a56', '1183359545', 19);
    t('2aec2jgh06a44k1e618ufe6f', '46782205842419322443177514531945486', 31);
    t('10i0', '7201', 19);
    t('6e1b6e52c50', '7566505880656', 16);
    t('1303233011232220000220310210110013123101110100121332', '9169532676641029580010283927166', 4);
    t('2021221000010221012012111012002211011020001111221121012221010112201220', '1913712624254749235264041459373475', 3);
    t('12cb0870cg1d44ceaj86117c6je3bd', '60740372923005851819292324387350353433', 20);
    t('fqh3nncclo676i9r13', '63746881387506157315801231', 28);
    t('2081ba3de80c6bc3d9a207a9e6e5bdge7', '4802181797263059228848555176663651746850', 17);
    t('3ns0n2ko3or9r6mj771nfjtq2fn0k5n3b6lp', '523414838800055605983731383323409728575668144200587581', 33);
    t('91mtn4gb7wnu7cfccs83s1itjh13avveqgs', '38564386619239951649280680768419728687062773517031904', 33);
    t('2507b59222357', '21588297587059', 12);
    t('1106210331', '46860486', 7);
    t('1sm2mcchi19gi0cbhlkqdg', '10223546271608775170591367519586', 29);
    t('a69782f103d9079c642dab9f5f67ae95g', '24592196044693731193607035015722190314492', 17);
    t('dheh2fkd58g6d717k', '19803533608478567457194', 21);
    t('977a3cf2b2f06c31b3d', '44708264591227581831997', 16);
    t('bd', '332', 29);
    t('8f9d8f622523e29d1a5he3gee466b7', '22413217136939225587842352555546632085', 18);
    t('34647345400115736740552300416234100512013623645', '1255594995624059221065714883120130755078053', 8);
    t('7oil9emi1ohrf04kd6kaedpi7rmd', '23966690311520969626701508915977431159381', 29);
    t('95061gh908e', '33129740894198', 18);
    t('110323', '110323', 10);
    t('111000010011100011011111000001110100100', '483660891044', 2);
    t('1122330122230000320332100231301', '1638301738278128497', 4);
    t('3031312222103303', '3453658355', 4);
    t('b9050a53cb2c53da260601ac128b1473b5', '773309649386529398888490649351437452755', 14);
    t('46f36cjc8ig0l46k', '21581257987125141435836', 28);
    t('21112102102121201212112112010221211020210222102201', '600976178399514404402164', 3);
    t('55031522323232530221104331123', '35916460467127317955419', 6);
    t('210111220001111021222122101100100112110120020211111112000111121201101102200211101100012', '257582427859456290317258827836081071349119', 3);
    t('cai', '6046', 22);
    t('238d459b304a504cc07bde524ffcae', '184595724574603234807440528928406702', 16);
    t('2951804f7cc040bcabed937dfc07518ebf0c31156972', '15459035341493840021436449671050677487751991559285106', 16);
    t('151441535252450114333525025131221241533434151002030110022341253', '3312988709769295474234430270673909304036864754721', 6);
    t('12pf7eg0pst560r56145b38oobrssdgp7p', '17896886417737298981574606954732052710804772615521', 31);
    t('102120201012022112102002220002111020022000011', '1267278558139797333142', 3);
    t('20723mjbpikg211', '219900549758957593129', 27);
    t('1ba7469629c55971709096531a043', '29589979360351359186903406966085', 13);
    t('43cd87pke82', '583569798239066', 26);
    t('2f3b', '32349', 23);
    t('1damenblocm6ab16mkhflkln51l80g0gl3', '20836281970872115708071405659370250984625401153', 25);
    t('6460334362676710', '232026545028552', 8);
    t('eh5eu5yo4r85a4frk38fd1upg', '325027824752333280420002134397968014004', 36);
    t('1312782233174508777', '1312782233174508777', 10);
    t('13341105311220530305055542233251', '2125986301582477786880095', 6);
    t('28urr93jo6qpp', '7615780104185501875', 35);
    t('f3kc6d1oa2', '57803286359002', 25);
    t('196d506730f12e3862g428100f99b6351d9683230', '25650422510765543578389928836906473834731647075211', 17);
    t('6in', '3911', 24);
    t('c662fh1059662042ac1bfa666892d54g4c19', '1062397772598878889201653207165639773092410283', 18);
    t('1100110100110100011011000', '26896600', 2);
    t('1reie79ejmki9eqggo2e8mom', '8410869246547671114783597667970876', 29);
    t('a26h7h373038ek', '25026850135788158392', 26);
    t('2003411221003313233000121410241302', '236418010553527903993327', 5);
    t('50', '65', 13);
    t('jdw2giryepgsnq', '2294207897977458246131', 35);
    t('76510257774b970163b3c8c8a', '4066438635725967850597253288', 13);
    t('881261b58a1a705b4412aa7', '4789169271296447376594079', 12);
    t('8172b1296abb', '32834523435949', 14);
    t('m7kj0jj6rfhi3q', '144843484516465224782', 28);
    t('16gb3e90d946cg4ba661f59d2ag3eb817ef0', '16410164287267896045565877674991970376204845', 17);
    t('30441908a9', '7159171908', 11);
    t('1110110001001101110110101111110100001000011011100111000000100111110010011011000010011001111011101010010010111111101000001011011', '157051027737987715731727950696316653659', 2);
    t('j7dfe8bgehjc2824', '635190155180670739244', 20);
    t('17586g4dc5508hbe66', '3072863740457400701010', 18);
    t('mfdhdib7gopble944bpae1cp7ka', '139110764181166732714408251267873085654', 26);
    t('4bk1', '54948', 23);
    t('4ldem65kinihnm8ca0d920pp4l13cnkh', '1130287125754563991765159720269473592208232147', 27);
    t('d', '13', 32);
    t('22021020021202211022121010121222010211120', '33506058087887919765', 3);
    t('206f4gc65g7egi54j3974j3', '247259714587053476909557142490', 21);
    t('4340502440403450033340223225211113442201423010504331313333', '1044228835950034098828612572961883231947980025', 6);
    t('2pfsk9mg1br1i1h075eo63s662hr6gf', '214533693113801145357049577189458281793615667', 29);
    t('habul6f3kihm3iw1r4', '1130144535004513737852095539', 33);
    t('106142331346752221011206', '647409104513791169158', 8);
    t('26kb58ddmhgb9tla', '131895300538724358011221', 33);
    t('362mijf4bm4mf45jgl0mg37ae6b2h7dfhklhgj', '790707811699113166404310250374840626288935161894479', 23);
    t('24aa9ha47hnegimefm9pdj52qko', '35513399551075834816632034861432466181', 27);
    t('1a9m96mie3djkfg667h9eje4c0lm50icmc3ikc3', '8093079648301893331997032028152019456512853100012045', 23);
    t('cjbdn0gtpput38l6uojrop6umhqebl1dm1p', '6419814410380460676020581102194375113413420245954298', 31);
    t('1ueohaa067uco1pdgqrvmhu0vaa8leo', '2785874481951992854286001892766607754475623896', 32);
    t('10101101101110101011101100011100010010011011011011000110111000010000001001110111010100111', '420051957077295313153486503', 2);
    t('85hcg94l7j', '14860540241390', 23);
    t('4a2976868d892ba0b7bd344d', '1085472931427423803725237293', 14);
    t('7kkh3nb7lo', '59243621828973', 27);
    t('1', '1', 26);
    t('1ibd5pfbokd6440j', '2866994109825495814339', 26);
    t('86ng8fec', '349615744710', 33);
    t('1143620362656535460140621434022160305663163240152242650105202', '627843320628203251128147470398864437340326997590198', 7);
    t('11262714046100646006', '168424020893715462', 8);
    t('15c8h01dg8f65ed11cdh7c83ig045e9724641af1fc7', '661948366072223304375223910664218120820427365067153516', 19);
    t('80a3b23b04454916925a67938b576c75b198719c3a44', '6396600297150246995243740339198009449377618885444', 13);
    t('1h8g5ebb0', '21730642290', 18);
    t('15121883734821931848157630403646710115517496961539', '15121883734821931848157630403646710115517496961539', 10);
    t('157qf44ko15e72hl', '3533762244672772908501', 27);
    t('9fe9i2fce0b23165bj', '128270183554062217810239', 20);
    t('204d4d06851de5e6c3b5c782368be873d2c2c6772', '223548940289723451071978777163310740220641882557', 15);
    t('hk05hcaki071ibakf80d42la0h51le5a19', '15457671916002610271027881255899341664819386332', 23);
    t('12758858347410587602318353440470122424758747174736144', '54973361258053823259500795020716385085006902031623', 9);
    t('1j0dq', '1489979', 31);
    t('24aa49b2669b4253417185039422b', '3970774336620668082561214323011', 12);
    t('1j3k0h752f1i35178l4a8892l49hl8g72le7', '3649735432337234577942518835984846875540064046231', 24);
    t('u946d', '31756493', 32);
    t('11d', '319', 17);
    t('a', '10', 20);
    t('85857450422153021232718260', '6218664865094656817286525', 9);
    t('b3bi9egmaa489d8j912m1j7f', '1582915351549542449793908963699565', 25);
    t('8c94c1101a3', '2575764487747', 14);
    t('21333351424', '137058856', 6);
    t('24ouud1zekrdeh0jduf8dlol67v2rf', '2892087283574736646554249773057595661742288571', 36);
    t('6tcd6nql2v4g2eiigj17qoti', '287377925910774326349880592997114802', 32);
    t('1ibdb8g6j16hfd23ec0ic3if6e89h483a07c', '6628668718711417889748955044148576508442160152', 20);
    t('200221012011220100010', '7335045156', 3);
    t('19l7ie1', '425580221', 26);
    t('5bjl8kdk9qeo3njnlq745io7offama41ho', '933615638563870486919671786607965571836873833306', 27);
    t('10232113020220300130312200101010', '5446860259502720068', 4);
    t('2b0a983ec857ac84ef5f', '203257196630153042915167', 16);
    t('44eo3qm2rj1egr54tcsdw', '31399246023982509778025476029912', 35);
    t('5hl2j3n9lqrf4ht', '15223157365873501989655', 34);
    t('1j61dcjc28ng223fdle5pd53a562b', '20497069428386502186259631448700342382939', 27);
    t('92m0p9wswvxpbygoscf0iyvma0gw33re', '6667479639141447629959640648792959413993639675134', 35);
    t('44ebf64ca6d7048632dc366985bacf6ca72f55bb89cb3', '412586872136786946015831424411703662517991501351918771', 16);
    t('2231322212032013010310223312202202203233202032131202213103310320', '231173459396011136566504537253511773496', 4);
    t('102222033224112043100201233424410310321401141431030120233342110002', '2981250760563381516328738717816795815564019377', 5);
    t('bna8v0dm7nj6ukvl14guf5jd86sdur8fqs9b', '561697417712642337267267807468369856115722296542196011', 32);
    t('246765a34371a64810230863090826259630999766341a98', '21334345633150250304537292228376342238910313741910', 11);
    t('dd6', '3126', 15);
    t('rj1kox5jiucmuo9sln77v', '209599559372534093290729866417476', 35);
    t('8pamgcke1q3dcfa43rji8gdg5r5bno', '8266027891125368114649885016554443139962892', 28);
    t('15877a7a507508a5380306', '67933623548690544541110', 12);
    t('310576032000120564437670443150', '485374511652821184626706024', 8);
    t('2k304b20fii7', '1036543616885140', 21);
    t('rvv6dkvip7h2', '1413563599986560420', 33);
    t('7s2rncsirvsn0zf', '47775999829788212268219', 36);
    t('5', '5', 8, 29);
    t('2010', '57', 3);
    t('3', '3', 35);
    t('1', '1', 20);
    t('b', '11', 29);
    t('a', '10', 13);
    t('7996x17', '11234850765', 34);
    t('31020102013113030130222221321300302', '968780395378242985010', 4);
    t('193629493c71666081307a037a449b05b732ad8a97dc96', '6251429966945048736162286407414968313191335468772060', 14);
    t('102', '27', 5);
    t('36471522780078332870256412616321566881211129236', '36471522780078332870256412616321566881211129236.0', 10);
    t('2u', '100', 35);
    */

    // Base conversion of numbers with fraction digits

    BigNumber.config({DECIMAL_PLACES: 40});

    t('111010110111100110100010101.1110000001100101001000101100010001111011', '123456789.87654321', 2);
    t('22121022020212200.21220000000000000000102121210212220222', '123456789.87654321', 3);
    t('13112330310111.3200121102023010132301212212301102120322', '123456789.87654321', 4);
    t('223101104124.4142404432120310240400022100414412423341', '123456789.87654321', 5);
    t('20130035113.5132000000001340141333022243243025133004', '123456789.87654321', 6);
    t('3026236221.6064403011334606121545601461612144044112', '123456789.87654321', 7);
    t('726746425.7006244261075431515424461645053746213677', '123456789.87654321', 8);
    t('277266780.7800000000377725827886511007881184436767', '123456789.87654321', 9);
    t('123456789.87654321', '123456789.87654321', 10);
    t('63762a05.97075184709912960846746215397a86192585a2', '123456789.87654321', 11);
    t('35418a99.a628000007789055192b3628390573a7a2093441', '123456789.87654321', 12);
    t('1c767471.b519c4868b1097b4ab6aa9a1723b0b21a6834568', '123456789.87654321', 13);
    t('12579781.c3b33d92601697558b8c4217cc4256dc8d8251c2', '123456789.87654321', 14);
    t('ac89bc9.d23500004b2d0ee1c3a587694b2d0ee1c3a58769', '123456789.87654321', 15);
    t('75bcd15.e06522c47b19a6c5263a515f9917be8d99dc09ac', '123456789.87654321', 16);
    t('51g2a21.ef57d03a8cgd3agbgc44442b7d2c05fc56078b69', '123456789.87654321', 17);
    t('3b60f89.fe00000168e6c74b51df90hacd964c0b952hf19h', '123456789.87654321', 18);
    t('2bg64ae.gc83iea83dahi6920iec351gdb575cb1i205e999', '123456789.87654321', 19);
    t('1ibc1j9.hac6i58g', '123456789.87654321', 20);
    t('194gh7f.i8be0004e152hj60858if8541gfd51d14c1cjh46', '123456789.87654321', 21);
    t('11l0805.j659b300hckla2kfh6791k6e489lja79665cd85d', '123456789.87654321', 22);
    t('j43jfb.k3fkgh7iaikallm5ld5l47c0lh1b394iiha9mjj5', '123456789.87654321', 23);
    t('fc2egl.l0l8000de3dkkk84l18cfhfj5k6ng87104gm68de', '123456789.87654321', 24);
    t('cg15le.lmkoh735e402b0lo7mil4jfi1gcend9bka68h736', '123456789.87654321', 25);
    t('aa44a1.mke35bnk8b6ae897kbonpl0638c53p7k0ibnicnf', '123456789.87654321', 26);
    t('8g86ni.ni000017nbhknqjj30nq3hdckfjimd6cg8362di', '123456789.87654321', 27);
    t('74nqb1.of5of5q5no17dm376akr5mnoq4fk7he0jd67r8gq', '123456789.87654321', 28);
    t('60fshj.pc50ab4snn27loqe7k2s613d49gjaqrd4946b13h', '123456789.87654321', 29);
    t('52ce69.q8qk002l', '123456789.87654321', 30);
    t('49l302.r5b31sdanlg0n9b2jbo82q36ktamkp3n44t0m3n8', '123456789.87654321', 31);
    t('3lnj8l.s1ii5h3r36jca9hqa5fpi5tuhmcto2dbklfsmr55', '123456789.87654321', 32);
    t('353c3r.suib0058kqr7q9iohe4pas21t9v8rffjah1e8oes', '123456789.87654321', 33);
    t('2od2i1.tr9m8dl5x4jwgbkmsvo3lb5k6sd50xl474rb0n5w', '123456789.87654321', 34);
    t('2c9g1t.unqrmvqxffpa8v182bc5uqn3o6y1hm9yb2kw4hvu', '123456789.87654321', 35);
    t('21i3v9.vk00009oa9l2ergih9i3ifctpatt1sllqhw4o9hj', '123456789.87654321', 36);

    t('-0.000000000000000000000010000100100011111', '-0.000000123456789', 2);
    t('-0.00000000000000120221110121121000110122', '-0.000000123456789', 3);
    t('-0.0000000000020102033202303032333033113213', '-0.000000123456789', 4);
    t('-0.0000000001100323001142032114244204230204', '-0.000000123456789', 5);
    t('-0.00000000112442331005030241312503143243', '-0.000000123456789', 6);
    t('-0.000000004660541461650644523626454412226', '-0.000000123456789', 7);
    t('-0.0000000204437054635763657165267673054542', '-0.000000123456789', 8);
    t('-0.0000000527417530418033652056622672708124', '-0.000000123456789', 9);
    t('-0.000000123456789', '-0.000000123456789', 10);
    t('-0.000000245117320941291484571aaa0235019322', '-0.000000123456789', 11);
    t('-0.00000045101516b79ab1643486a1288795277265', '-0.000000123456789', 12);
    t('-0.000000799274a18803c248320ac075c404ba5975', '-0.000000123456789', 13);
    t('-0.000000d02a645405ac4b02291d9cbb648b47158c', '-0.000000123456789', 14);
    t('-0.0000016161613d9213b1295d5d28b0123018bd3d', '-0.000000123456789', 15);
    t('-0.000002123e2ccefcf5e755beec5961bda3d5a3b9', '-0.000000123456789', 16);
    t('-0.000002gb3824a5dgc3c94740391g0b68g0b0d3a6', '-0.000000123456789', 17);
    t('-0.0000043a8e79ddh532d9ah5e95b67f4fde164c7f', '-0.000000123456789', 18);
    t('-0.000005f6die5i258a658924f283g9hda0546dbbd', '-0.000000123456789', 19);
    t('-0.000007i09ha7ehc', '-0.000000123456789', 20);
    t('-0.00000ac7a5b9ki452k9b6hc6g5de80gijbgdfhk6', '-0.000000123456789', 21);
    t('-0.00000dlkhch59368552ebd4aefei934f6f9gg6ah', '-0.000000123456789', 22);
    t('-0.00000i680c15bl2f7jf4eem12mh044d0kf6bbhdf', '-0.000000123456789', 23);
    t('-0.00000ne5d1jjel1l33b9mea8f6hc5e688d15bb27', '-0.000000123456789', 24);
    t('-0.0000153d06m3b9em4d244h8obma81364m9lf0h6d', '-0.000000123456789', 25);
    t('-0.00001c3f328n1m7gim7p3bggi0jca71ij39p0p52', '-0.000000123456789', 26);
    t('-0.00001kmaml1ao3b565k28789obc8mnh07mp5jlkq', '-0.000000123456789', 27);
    t('-0.000023dm65kb1mq249apf333lel8j10r4bb7apmp', '-0.000000123456789', 28);
    t('-0.00002fchnj3o82292e8l6bdfb8oo4jn8cnii16rg', '-0.000000123456789', 29);
    t('-0.00002ttttta2se3', '-0.000000123456789', 30);
    t('-0.00003ghj5qf0acg3e8d7gu5nejhkdkuijosts68f', '-0.000000123456789', 31);
    t('-0.000044hu5j7fptf7amveomb1nmhtb8tpa44tetc7', '-0.000000123456789', 32);
    t('-0.00004rehmrkfsfqvq5pm8qifcooiapip4rww68ii', '-0.000000123456789', 33);
    t('-0.00005koccwr5vqq0bsl049v1qwqp9h8tshw38asu', '-0.000000123456789', 34);
    t('-0.00006gx4anjwlqb0xla3iwgv0548y4t32r88wwxm', '-0.000000123456789', 35);
    t('-0.00007gql6532pjh3akr03dh8iwkobdh4sshi00s9', '-0.000000123456789', 36);

    t('1111100111.11111111101111100111011011001000101101', '999.999', 2);
    t('1101000.2222220210221200021112101120001001102122', '999.999', 3);
    t('33213.3333233213123020231003211120010012021032', '999.999', 4);
    t('12444.4444141414141414141414141414141414141414', '999.999', 5);
    t('4343.5554412021453552313300510342441202145355', '999.999', 6);
    t('2625.6664412312515410253566644123125154102536', '999.999', 7);
    t('1747.7773716662132071260101422335136152375747', '999.999', 8);
    t('1330.8882385024534603137817105667427164213206', '999.999', 9);
    t('999.999', '999.999', 10);
    t('829.aa973a4913443083925788751826a12209617036', '999.999', 11);
    t('6b3.bba3320237938b1770119a7a5699606ab3b294a9', '999.999', 12);
    t('5bb.ccaa5926381c699320b4278283cb62c494684889', '999.999', 13);
    t('515.ddb38266d3049bdac14b5d165539a5b770ad942', '999.999', 14);
    t('469.eeb9595959595959595959595959595959595959', '999.999', 15);
    t('3e7.ffbe76c8b4395810624dd2f1a9fbe76c8b439581', '999.999', 16);
    t('37d.ggc18275989641138dge6d54eg08g529aeb6faa1', '999.999', 17);
    t('319.hhc307dh7b6deeha40a6b43307dh7b6deeha40a7', '999.999', 18);
    t('2eb.iic2ch24i43efhgd61307b0e199g6fb74a55dcac', '999.999', 19);
    t('29j.jjc', '999.999', 20);
    t('25c.kkbfaii9d8gg7b6ee594cc372aa15087k2j65i0h', '999.999', 21);
    t('219.llb7g822a4ceh5a0fag44k937cak18la89ii6f3', '999.999', 22);
    t('1ka.mmaj3f2cgc81fe490kebi8f9m173blcfb08mj6j3', '999.999', 23);
    t('1hf.nna4590djiena4590djiena4590djiena4590djj', '999.999', 24);
    t('1eo.oo99999999999999999999999999999999999999', '999.999', 25);
    t('1cb.pp8b0g5lb0g5lb0g5lb0g5lb0g5lb0g5lb0g5lb1', '999.999', 26);
    t('1a0.qq78f2dle09cnjl9h6mblfcj9ij58geni8qkbn0n', '999.999', 27);
    t('17j.rr619hjdigg3g9nr2pf067h6qc2j7ar95474jjq6', '999.999', 28);
    t('15d.ss4hkojk13n4rnf1dpo9ham09782ifbgg63d28cl', '999.999', 29);
    t('139.tt3', '999.999', 30);
    t('117.uu16eq9rha657cl1g2ngcbdir7m8tmihjp2dsf4t', '999.999', 31);
    t('v7.vuv7di5k75c10oidqboqjuv7di5k75c10oidqbor', '999.999', 32);
    t('u9.wvu22k10p1i619fhuaq3d5gsfqkr584weg2bahcu', '999.999', 33);
    t('td.xwsnmjjt3i7kw38x68nvs0igtcqmabee4ufqd1up', '999.999', 34);
    t('sj.yxr4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4d4', '999.999', 35);
    t('rr.zypcdtnwjl0v3qs82axzf9i56mgpcdtnwjl0v3qs', '999.999', 36);

    t('-11111100001000110000100000101.010000000010101111110001111101011011111', '-528769285.2506705498654986754987694357629487612132293856', 2);
    t('-1100211222021002121.0202022012211211020000112211222001122022', '-528769285.2506705498654986754987694357629487612132293856', 3);
    t('-133201012010011.100002233301331123320132210223310233313', '-528769285.2506705498654986754987694357629487612132293856', 4);
    t('-2040331104120.1111313304243240343040303403011030102242', '-528769285.2506705498654986754987694357629487612132293856', 5);
    t('-124245205541.1300511413330341000202421140342015422521', '-528769285.2506705498654986754987694357629487612132293856', 6);
    t('-16050315262.151660065566343455213220110101053003165', '-528769285.2506705498654986754987694357629487612132293856', 7);
    t('-3741060405.2002576175337036445364576675624305775126', '-528769285.2506705498654986754987694357629487612132293856', 8);
    t('-1324867077.2226575420048486156768436757465017711084', '-528769285.2506705498654986754987694357629487612132293856', 9);
    t('-528769285.2506705498654986754987694357629487612132', '-528769285.2506705498654986754987694357629487612132293856', 10);
    t('-251527210.283708196291157004318811823a797729578835', '-528769285.2506705498654986754987694357629487612132293856', 11);
    t('-1291008b1.3011aa3020304260b7471b3b999021bb3a506156', '-528769285.2506705498654986754987694357629487612132293856', 12);
    t('-85718b45.334952b34b55677529b07439635a477982384a29', '-528769285.2506705498654986754987694357629487612132293856', 13);
    t('-50324269.371ba8d021dbbc4126c65231444dc79c599697d2', '-528769285.2506705498654986754987694357629487612132293856', 14);
    t('-3164c5aa.3b602e37331cb4ab53c1d9ea705a303460358648', '-528769285.2506705498654986754987694357629487612132293856', 15);
    t('-1f846105.402bf1f5be1e92bd2fdbdca317fa561bb1faaa3c', '-528769285.2506705498654986754987694357629487612132293856', 16);
    t('-14f6g98a.447945bd7f0c37e8e036c8fbc7a1d008497609c1', '-528769285.2506705498654986754987694357629487612132293856', 17);
    t('-f9f0fh7.493g70g118a7h80g41g45g3gg949bgd4f09b38c', '-528769285.2506705498654986754987694357629487612132293856', 18);
    t('-b4a85g7.4e96c1g631eg54cf768317heedhbdda82ahibb33', '-528769285.2506705498654986754987694357629487612132293856', 19);
    t('-854g345.50575f3gb2e2b9ieh985jejd269643cd6jej3864', '-528769285.2506705498654986754987694357629487612132293856', 20);
    t('-639i76g.55b9dhejadf10886ckb3i4j5k98665g2fha9gg01', '-528769285.2506705498654986754987694357629487612132293856', 21);
    t('-4ed50bb.5b731gj7dd9h3glc4l0klc9a045ge23kk7bd6j92', '-528769285.2506705498654986754987694357629487612132293856', 22);
    t('-3d3c6jl.5hdkkefmkeehafcj40549634532b5d5h71086igg', '-528769285.2506705498654986754987694357629487612132293856', 23);
    t('-2i9i25d.6096b81j2ibkf632ij9im7mn99i4eh131a5e1m2g', '-528769285.2506705498654986754987694357629487612132293856', 24);
    t('-243g5la.66gi4ehkjfkfj315f5clhm4245dlc3ej08if7c3l', '-528769285.2506705498654986754987694357629487612132293856', 25);
    t('-1id2j25.6dbkb1b61h5bnlbjp2j2427877ij0pg9c1o83n6b', '-528769285.2506705498654986754987694357629487612132293856', 26);
    t('-19mq72g.6kjpgb04phiekfpckemff1na38d6ch6h415ooqlj', '-528769285.2506705498654986754987694357629487612132293856', 27);
    t('-12k7eh9.70ek4bdb4kl74bh5qkdp80knqo3mrdkk9gg8372j', '-528769285.2506705498654986754987694357629487612132293856', 28);
    t('-pmhili.77nhesre540gfoa1jc92cjc1a4m9rsn2pbe50ol2', '-528769285.2506705498654986754987694357629487612132293856', 29);
    t('-lmo1cp.7fi34apgmi9bi550j3l1bdrd6kqge8q96omh2p3c', '-528769285.2506705498654986754987694357629487612132293856', 30);
    t('-ieh95m.7nrmg0mdld46iuei3r1iqfti50kmeh6qjrjqushs', '-528769285.2506705498654986754987694357629487612132293856', 31);
    t('-fo8o85.80lv3tdu3q9bqburrihhfuim3eovlahs5v6issil', '-528769285.2506705498654986754987694357629487612132293856', 32);
    t('-dgsptm.88wbffuf1iuge976daspjacn1ukmb6oj3hrd5n1e', '-528769285.2506705498654986754987694357629487612132293856', 33);
    t('-blnatr.8hqc2odcp1864oww4beqbp7icwpn958xqlrrjxwp', '-528769285.2506705498654986754987694357629487612132293856', 34);
    t('-a2csdu.8r2hha0ljcurhoj7k0mxnog67x20nouvourt0a0h', '-528769285.2506705498654986754987694357629487612132293856', 35);
    t('-8qtczp.90va9l3p022q7omcbqhd0lglz0rlmrd2cbt4mg5a', '-528769285.2506705498654986754987694357629487612132293856', 36);

    t('316.6', '696.4', 15);

    BigNumber.config({DECIMAL_PLACES: 18});
    t('50960021014244268687a1886463130.16672a1420499a6247', '88623581339673073949500137313245.1455', 11);

    BigNumber.config({DECIMAL_PLACES: 39});
    t('ma.5i9g6fhdj9d8laa7kel9gjlf93c8f746i7mci28', '516.25221568916508446316309948501759661238267291', 23);

    BigNumber.config({DECIMAL_PLACES: 100});
    t('h9rdl18jd.q051dhn7aspg6k8dmp5l63g18ge2cj8c1n08biondk1ni2ksir9chonjaoqc0fnr8sh3a6o01d470fccm00pjj9kkl8gr886b2ic', '8675779666304.89675881218833', 29);

    BigNumber.config({DECIMAL_PLACES: 16});
    t('1669699d2446c13b6032b4859b851db2c71996094896.03cc46a11973cc47', '28095859731039155813921318494826179694928140368916.02', 14);

    BigNumber.config({DECIMAL_PLACES: 44});
    t('433eejca0g5g2hi3h81hfa8j5b.784a9id7lifghgg1kalc2d99j7jc674bh0a6ka4b6hci', '15065394735668576931388972794395685.335131', 22);

    BigNumber.config({DECIMAL_PLACES: 92});
    t('35076567745235671502.6773342626436061433365155137731076310010275236050103305437451411644055625324564421515511562', '524624822785241922.8738874407101262195488876445', 8);

    BigNumber.config({DECIMAL_PLACES: 23});
    t('11006433654634662212602033613520122341643062434012145010.52425140460600403610425', '34628562545096914224971102777355168736669856771.7679078074649', 7);

    BigNumber.config({DECIMAL_PLACES: 60});
    t('1p66mbi9fn3c1lmpqm9alc3n108lp111949qmoqj.arca8c1fkqqd9nibi2aqg5gm8a86rgfo831godj8q1gcqdjcbh62fih9fbd3', '522521559789778545185676538833457746453383246746454589675.392145039', 28);

    BigNumber.config({DECIMAL_PLACES: 44});
    t('5605470434246053632363152113440650264426323520.33525466364076204553563061761202201336001507', '250925107172835956608925073908081234650960.4323', 8);

    BigNumber.config({DECIMAL_PLACES: 47});
    t('5jljm2eeb7a91jaf55dm6de44.iddl2d32kn3cnlif2ggdemk41h1mibm7gh560403846n52c', '7775100815978012670733930388143588.77357345356039222606783162331270073', 24);

    BigNumber.config({DECIMAL_PLACES: 66});
    t('15jhag4hd9gfb34e9k3h28642al6.g515a6bg2ige2kekcji73f69khefeeg3d0k8gb641g73a3kk75dl3lld08l8047j1b', '2231466155455967642494664913445902444.737720562308164842135964809152', 22);

    BigNumber.config({DECIMAL_PLACES: 59});
    t('922957026721a93.35228440098a1382a5360815162596954a2352084859a278208a1929945', '3495784831845804.315740956312801540001007380273089678135993838516', 11);

    BigNumber.config({DECIMAL_PLACES: 31});
    t('2321136.6635426603020156550074200106655', '631390.850962999306313972719936135603917', 8);

    BigNumber.config({DECIMAL_PLACES: 42});
    t('4122015524443344205255.532130505243523353120213333531354112005131', '92831400808748387.9271017366', 6);

    BigNumber.config({DECIMAL_PLACES: 7});
    t('f.8gkgp2r', '15.28520597106195746386586', 30);

    BigNumber.config({DECIMAL_PLACES: 64});
    t('4.3453j4kjj0gld74h3kf2eh7kiabgdfj91lm47df8knn08mlmg34llmen8b70nfgg', '4.1323175881243', 24);

    BigNumber.config({DECIMAL_PLACES: 16});
    t('11fci0nrj42co0h.p63gsr4rg512kr8a', '502434965914740165617.8401320537228150118206441', 30);

    BigNumber.config({DECIMAL_PLACES: 59});
    t('2jpeg4chfcljgn44g7ljm696j7ecfng2hifi79d5fk9e.naaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', '19324647245541042665522682085850732286789183586270685673003472.9', 26);

    BigNumber.config({DECIMAL_PLACES: 72});
    t('4ki4c4d5ha22d8925b4005bh88m7ki.30kg3hdo30h263k596n8ca1bfd4eig7hljakomdo30h263k596n8ca1bfd4eig7hljakomdo', '167542618104881367375225493908762776911143.12132133912', 25);

    BigNumber.config({DECIMAL_PLACES: 78});
    t('4544322.235145104224010425054333530135545110521301445400530023102335504152042532410303', '231674.441212', 6);

    BigNumber.config({DECIMAL_PLACES: 12});
    t('111011.001010010001', '59.160508253119229720226315984803348705', 2);

    BigNumber.config({DECIMAL_PLACES: 28});
    t('454102.5412541254125412541254125413', '80656.8', 7);

    BigNumber.config({DECIMAL_PLACES: 33});
    t('1isk023dlf.55crlo17qlse1p84be9gabpp9h51e244s', '42579766052911.166926038969790620314532268407622', 31);

    BigNumber.config({DECIMAL_PLACES: 54});
    t('429qi6dl4h.ph4ne1d18jgkilepdj3ogaj6dimknhh8n29cph914lcg4bc4moocg8', '31171726864736.9494930209622872734578329709751045672992053779391489601493', 27);

    BigNumber.config({DECIMAL_PLACES: 18});
    t('172299c4276c26163a846222898294acb1.42584081aa022b93ab', '8930913218627080059774919041327808207.322093463032', 13);

    BigNumber.config({DECIMAL_PLACES: 61});
    t('91.6860869813842881163577889544084877062924216598567628502407164', '91.6860869813842881163577889544084877062924216598567628502407164280', 10);

    BigNumber.config({DECIMAL_PLACES: 42});
    t('4521234205002101435221121250354315.053033313232425310135400154551251430143114', '233771706142581818269027271.15323953306272130041055911181', 6);

    BigNumber.config({DECIMAL_PLACES: 74});
    t('1l8itelfm9stl7fmkawlh8km80pd30g1.uv0bkrja2onchcpf3iavufmbsgj6888q93ij858tkgngrwgn09gu8g031v0g7ku6pt57if84m4', '194937846823553447809511256180608590361394349744.9375672', 33);

    BigNumber.config({DECIMAL_PLACES: 22});
    t('14477210981224.2476134315993452402663', '14477210981224.247613431599345240266280695', 10);

    BigNumber.config({DECIMAL_PLACES: 64});
    t('3j51pir33eok5rcga8.ci6c5a89mckjehlco1mngdb09rqhdrdqf9pci83rqri96b1c0sbeaj7979d3adc3', '26569832927198243633766552.435459435', 29);

    BigNumber.config({DECIMAL_PLACES: 51});
    t('1048563153471333165888a4428a560371303035158.922a919092343141a34289759683671530130a320a939a7a275', '56924066996327539534686550864239220405952031.8369533', 11);

    BigNumber.config({DECIMAL_PLACES: 62});
    t('3.5kel2e1gfiac70j7k563b9el2e1gfiac70j7k563b9el2e1gfiac70j7k563ba', '3.27', 22);

    BigNumber.config({DECIMAL_PLACES: 22});
    t('5gfg.df5gbcd10a347d4cg76326', '29460.8178265494875692701718973279612977910871', 17);

    BigNumber.config({DECIMAL_PLACES: 75});
    t('1faem.cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj6cpj', '1550806.4', 32);

    BigNumber.config({DECIMAL_PLACES: 93});
    t('1000001001001100110111.101011101111000111000101011111000010001111111011100010001100111111100100011010100001010111111', '2134839.683376639182809009377393376566052153774412236905434', 2);

    BigNumber.config({DECIMAL_PLACES: 70});
    t('68.0418148343760086652557726847074054512880223633116204181483437600866526', '62.052', 9);

    BigNumber.config({DECIMAL_PLACES: 84});
    t('1ameoekdm.p5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gmb5gm', '523588890434.9', 28);

    BigNumber.config({DECIMAL_PLACES: 72});
    t('g837j86d57fcia.f5d06i2iaeaad500b87071eggcg', '1344184021329245170.764127158536574868775285152', 20);

    BigNumber.config({DECIMAL_PLACES: 37});
    t('45hjj171bb9ee1gehmgc5l9k5nj.a0hiel28el28el28el28el28el28el28el28f', '9389077895851446839665690077113206844.4011356', 25);

    BigNumber.config({DECIMAL_PLACES: 29});
    t('5afd883.0kb4ikl7aaic00mb6d7j6g9kcm0be', '808903080.0387285', 23);

    BigNumber.config({DECIMAL_PLACES: 30});
    t('uoa.p77777777777777777777777777777', '39754.7', 36);

    BigNumber.config({DECIMAL_PLACES: 57});
    t('314211431344264.161502550605320604600021123244242566302151242210124322565', '2191226569123.270328', 7);

    BigNumber.config({DECIMAL_PLACES: 83});
    t('350np900cjrpa7h7d2rm58e17o89em3qar381c.sb61e7ka19m19dt39t24790llrnb4drfn650aukk22ralqg7145dpgmpkek9itu5ka53sho1mkqndi7a23f', '47902354964172156474611081338049003753298795073166899865.9148752', 31);

    BigNumber.config({DECIMAL_PLACES: 10});
    t('243.4465610031', '163.575626396226555033529183865411120656777021626883', 8);

    BigNumber.config({DECIMAL_PLACES: 13});
    t('2ef7g1b5a7f2gec76ceg9.5b5d811g8fg79', '11692997210770248710254595.333358969', 17);

    BigNumber.config({DECIMAL_PLACES: 26});
    t('21mc1klprud5o4tgld2uo779vi7uo4lwed232a1qla9', '12289022125709080817960517361047704480115521701286675767213581699', 33);

    BigNumber.config({DECIMAL_PLACES: 54});
    t('1biha8e7fg.9ehdffb8dcagd4g9i98hchibbbh22093e1bi069e343ae8c7d8f50d', '526422264921.5150500126270316229746944036', 19);

    BigNumber.config({DECIMAL_PLACES: 87});
    t('6c21ldjdn0e.d7ki8442k6ec8b5njjgm067jj6cac5l46l7gfh7km77bn9iehd7f2l7c934md3b6ecfk8afh15je0jndbk7nf9a', '412350836548046.555321483698953780254564895313985703', 24);

    BigNumber.config({DECIMAL_PLACES: 76});
    t('r39e056mi.tjxo1e4pd49qkvkendhphptkqsp0fyyomdcv5ophw9lfaogq769ommmk1rpc3xlbawek1iy9d95v', '61010933356888.8448673320184616605284885898', 35);

    BigNumber.config({DECIMAL_PLACES: 93});
    t('4q3je2kkc.v0oitmoa0vse0m2sgqid4w2ntjy10b3gqbqsu5u4c84d0m78gmlgqcbhyhbs18r04wxljbi6ypi2mtkvasu60n4gpp3l2', '10686857113462.886286611976383309575531841252170238', 35);

    BigNumber.config({DECIMAL_PLACES: 36});
    t('32.rhf24b66142ioncpkpn6ije1k8s9cka3f9ro', '89.951866586639896895259517645524', 29);

    BigNumber.config({DECIMAL_PLACES: 14});
    t('34a1765329aa0b27358236536.c1082175680a06', '1827925782415763778360259679.929279897145404964833315', 13);

    BigNumber.config({DECIMAL_PLACES: 61});
    t('a6742646212221a88046886505480aa41030547a37a67236.41964a1417296a0a24a93660a5329032846329a7984251058490591662579', '93546552298402617258257881206314223917463535762053.37910302', 11);

    BigNumber.config({DECIMAL_PLACES: 9});
    t('3pt6cise0p638ff8tq9hiomp2.sjof1dciu', '2380426328731894461017956020638721447.923818782906918215432585338', 31);

    BigNumber.config({DECIMAL_PLACES: 34});
    t('7b16db7c13e5g542iefad5hhg6hh43jg83dgdad74c70c0fa8', '2126074738690043302211139064073553459984418855049352822209926208', 20);

    BigNumber.config({DECIMAL_PLACES: 100});
    t('5c38ll2df8cc.ea8k9i40l7d3kibk457clf53bbeldgdlc376aj7a7472855h5iccb7ja0kk9dklch184b0jllda2843hf3je91ia0ba05eg2gfd8', '3244426171205484.6578633915920657537140922935', 22);

    BigNumber.config({DECIMAL_PLACES: 52});
    t('59k16a247.61737g31dc0g774g83dg8dc9fd8fiihda667i040f6b2244682jb', '207044760664.2887550452070736178915046269946', 21);

    BigNumber.config({DECIMAL_PLACES: 82});
    t('110100110001101011110111011000010000110100000011111011110000111111110101000111000110001111011110111110111000010111001110000001101.1101111001111010101101110101011001000011000000101011010000001111011001101010010101', '561214248546542162784739085096665717773.86906', 2);

    BigNumber.config({DECIMAL_PLACES: 11});
    t('36f.deg45023nic', '1887.5671423143628136523074608843', 24);

    BigNumber.config({DECIMAL_PLACES: 2});
    t('2.a7', '2.61389199970000056196530570', 17);

    BigNumber.config({DECIMAL_PLACES: 61});
    t('40212435243045.4130510342441202145355231330051034244120214535523133005103425', '53056804709.709', 6);

    BigNumber.config({DECIMAL_PLACES: 44});
    t('1200.12140430444103413343343041420032110122444122', '175.2946969442501136', 5);

    BigNumber.config({DECIMAL_PLACES: 45});
    t('1a.cma7ce1fa7198f4l4136e24icdfjfem8175em64fele14', '33.564175901106526786865243352786443610109137364324033383', 23);

    BigNumber.config({DECIMAL_PLACES: 24});
    t('83.82j8j7mk5gj08fc90d7dmj96', '187.3532', 23);

    BigNumber.config({DECIMAL_PLACES: 28});
    t('29542da7aj1.aa6f5b4e5gb561gc34', '25221291260381.525845488058258131', 20);

    BigNumber.config({DECIMAL_PLACES: 21});
    t('23310314004100214404201444.42442021424124041211', '813327917597334624.91907050113787247', 5);

    BigNumber.config({DECIMAL_PLACES: 76});
    t('180ka8gcb2e52gg3ml8590.8lkaji90g4cl8dkinef0h0e13hlf1b54bngb9dfm1ehmalmakidmk6l6n0fe4anbf7gn8754j59a', '128782235162920368437352533016.3712710490503878', 24);

    BigNumber.config({DECIMAL_PLACES: 77});
    t('cj55j1abk1.11a00dib00e885bkdhb71ea8hkdjhih7b6cic84710dihedh58efg803i563e6ae2k9270773geih', '10259507050423.0509665801731862583991348047581595376734117515727774395', 21);

    BigNumber.config({DECIMAL_PLACES: 88});
    t('1120201122111211001102121220012202000221001011102210121000011121101210002.2100011212012221101021000112120122211010210001121201222110102100011212012221101021000112', '35651380254013249383472036570828775.78', 3);

    BigNumber.config({DECIMAL_PLACES: 61});
    t('nde8jl8filiabpp1ebiome1gng72ajlc05pcje.58k83pnpnnln1c250flhhe10i0aecl3kemo51i13ckj0ieji243nkh44bbafk', '531463579683815787587099214787456214450843210757585380.2052977699752', 26);

    BigNumber.config({DECIMAL_PLACES: 49});
    t('2423132320143244255320031342044542022.4021501234514001305003110201140332234405515452435', '28233915554941230658978083038.67734567636065289541', 6);

    BigNumber.config({DECIMAL_PLACES: 20});
    t('b8b057c619.881cda90778727315519', '240240367775.61294728461437827', 14);

    BigNumber.config({DECIMAL_PLACES: 57});
    t('3uke1r.qog7jpuls3wumhw9r6ij66xbtr9fxmcxo7pjkdsets6obc03cdkpohtp4', '177198677.78587988442236198004', 34);

    BigNumber.config({DECIMAL_PLACES: 53});
    t('rxp7iouofqsa.5xr0ytex5w3u84ss4bmqr4d2r58uk0w6vou7okvti3sqaf8xdt7m4', '2699846669670878465.17042631933406076262750289627556', 35);

    BigNumber.config({DECIMAL_PLACES: 10});
    t('71.4dadah84a6', '127.26419', 18);

    BigNumber.config({DECIMAL_PLACES: 62});
    t('pho3b9iei6hp0dcf72fih.ph9881jc7d7c0c0mgpgd1ji1k02ola0l976leng417ng4dma8k5jj95gommail', '511945071604551808598197283361.9872166378092262156654881169655510', 26);

    BigNumber.config({DECIMAL_PLACES: 16});
    t('98.1902712204800298', '107.16547', 11);

    BigNumber.config({DECIMAL_PLACES: 70});
    t('12042214055152101441031134141544140013031204153503340.0001441130201520422300253055330454111450024335001352533025215001340303', '39389800555908783850258185920663768281644.00137621307644652979797336', 6);

    BigNumber.config({DECIMAL_PLACES: 85});
    t('10110111000101011010101011100011110110000011100101000100101000111000001101110001010010110011101100101000001100011111010111011100.000110111100110011011100001111010100110111000100110000100000010010100101100011001101', '243361227524012342673912659288240813532.10859467026399996528383947490', 2);

    BigNumber.config({DECIMAL_PLACES: 43});
    t('20320a9e1c.e13d8f38akka6fadl8ihb6l130aja4facgc892b7ik1', '2422250714258.6387686759191563066716078918648006468135734011652', 22);

    BigNumber.config({DECIMAL_PLACES: 6});
    t('fk3tfaumol70.nbu11t', '397624194336432136.7543900599912174983420474207', 31);

    BigNumber.config({DECIMAL_PLACES: 93});
    t('bndw.ia76eoij11afbtfap0nweobn9p3ukq3ykdaqhg9p3eh2kj95e8c82jarbuo6ng1v0uqvxgmx0oephdvyf26oxydy1cg2a', '500287.522616523131590467026372561556', 35);

    BigNumber.config({DECIMAL_PLACES: 38});
    t('12.00222221021111110122211020211211122011', '5.110848610746726114', 3);

    BigNumber.config({DECIMAL_PLACES: 39});
    t('2781hhhb8a83ai.1ia3900g8i4534743692hfa4d2idid3hbie71b4', '100543014641347157.1039776690679366009661209140071615314125301', 19);

    BigNumber.config({DECIMAL_PLACES: 4});
    t('idrt.8pi8', '788649.2494047472', 35);

    BigNumber.config({DECIMAL_PLACES: 32});
    t('101553444.31404145323333511432344434343404', '1772452.5468497396', 6);

    BigNumber.config({DECIMAL_PLACES: 26});
    t('11913e.k48gaghi0bda65ca2fad6g3fe3', '4362449.9624', 21);

    BigNumber.config({DECIMAL_PLACES: 95});
    t('b.1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h1h2', '11.1', 19);

    BigNumber.config({DECIMAL_PLACES: 41});
    t('504.30415304153041530415304153041530415304153', '184.52', 6);

    BigNumber.config({DECIMAL_PLACES: 10});
    t('1040tqefd1.kagvh6rc13', '79074558629081.5799860', 35);

    BigNumber.config({DECIMAL_PLACES: 66});
    t('88k7o8ik5jj36le.hi5i7pd4bnbijdamio535d2ch6dbd8fa810ha390f3nnm50k35598nk6j8d608p206', '537866727524277202000.680797912718430834', 26);

    BigNumber.config({DECIMAL_PLACES: 52});
    t('99a841081466974763476a2a94.8685193793416832964036250573858a28991099751a42161366', '1073406972360901510248908534.783223009295755306594680823047214404631', 11);

    BigNumber.config({DECIMAL_PLACES: 23});
    t('2824bb685415692c3454de3ba6ecdee2e64731e30386.251d7e62e78419d5bbd2e91', '949248114155968376205888968663100056112678439830801.156119125437472', 15);

    BigNumber.config({DECIMAL_PLACES: 22});
    t('1.pm8mgslg4329n9f3afrstm', '1.803', 32);

    BigNumber.config({DECIMAL_PLACES: 64});
    t('1lpcq5lrlgmpeong4rhi33osk7e7.19rmrhsmn87lo1pr6fa0r87ae562legcl56ocse5ikm0icck2hjhob5cjl174idm', '5356399442861089801562327577317285912011.0463238125', 29);

    BigNumber.config({DECIMAL_PLACES: 75});
    t('82m1.1a4md6p9e92i4ghlb2gj6kqbihjpjjo7a0cagdb8c4l0o1eep3infb6qlo5ohffh2c943edckm2', '159517.051', 27);

    BigNumber.config({DECIMAL_PLACES: 33});
    t('2a.0ad1489a72438d6051a3cdb85a945c279', '38.055792640673814942897183865707181090111098818987279667501', 14);

    BigNumber.config({DECIMAL_PLACES: 85});
    t('110001011001101010010100100001011011001101010101111001010011100010110001001010010110100000111000000000001101000000110000100011100001101001100011010100110101111010110001.1011100011010100100011101101101100101011000110000110111110001100000110011000111100001', '288798319290142875873517012221913212736305288666801.721993378169914151', 2);

    BigNumber.config({DECIMAL_PLACES: 38});
    t('g578.d61b0da144ckf2jkcl10949664b9ea332i2l3a', '172950.603446775338659784933', 22);

    BigNumber.config({DECIMAL_PLACES: 60});
    t('gded9gk7jid6iknja1a5f2lajbj3nfoa.e2k009337h0ebkh40nl0685da83m99d7dok0nhob24fn21mnf3d0m4hji27l', '358724698418163432084126450455461239444900610.564480037377194308738297', 25);

    BigNumber.config({DECIMAL_PLACES: 21});
    t('1fml4uksb7ix1y.sso3bn1tfwq3hlccisodr', '171143420517125729119.8234191307649657940877', 35);

    BigNumber.config({DECIMAL_PLACES: 36});
    t('14c760d6m2.1nananananananananananananananananan', '4500058801177.0775', 25);

    BigNumber.config({DECIMAL_PLACES: 17});
    t('9fljfli8208i7bh3c7dde.4gk2g45kjjhk7i0jf', '6861754532912253293306011016.216766', 22);

    BigNumber.config({DECIMAL_PLACES: 88});
    t('3001121003203231320200201312003303213331113131100133213110032113.31330121313330323023210010122131021011200033322313113211233321203033223010323212313121', '257061387534308407753785204466907956119.8714885597106', 4);

    BigNumber.config({DECIMAL_PLACES: 53});
    t('1011222022.1122002202122110002010210020010111221010102200200022', '23309.54447401648241096074553786074233187398795698903', 3);

    BigNumber.config({DECIMAL_PLACES: 22});
    t('5.9194l4cb9fa8bah8b2m654', '5.393952', 23);

    BigNumber.config({DECIMAL_PLACES: 27});
    t('33010330211130.020232012002043243340030201', '4405710165.084291592965', 5);

    BigNumber.config({DECIMAL_PLACES: 92});
    t('13jdf.chee8klh511i494ffk6799ec193bj23lefd62576edd4ah8dhe956lg0jlg6k3081fh7b90kkc2jch552h2c92j018i', '275697.58195481441', 22);

    BigNumber.config({DECIMAL_PLACES: 73});
    t('479nerl5qc9.9gg9mhjlia0lpqpfmbo61gkfk3m8nang7qra73jkm205ffji6djibilkpg7beb94ddgk755q4', '1262554037978809.342581555046588836259033201946517724', 28);

    BigNumber.config({DECIMAL_PLACES: 77});
    t('2abe54cdahg4cfg73.a32gh72hhedf8b362afced335ff3a2934a3g88h1807c480g2623738bbhdb29da52fhae3bbf49d', '314766023685470770233.56531937360626278654', 18);

    BigNumber.config({DECIMAL_PLACES: 53});
    t('44fk73cgelq38ai1jl6mef2johb8aqigpghe6.41pe15mojjjf3nnhpfponasg5cgikcfick4ip43bp8e6l7m13mna4', '184105112778080215283996929747816484069365074433262524.140165', 29);

    BigNumber.config({DECIMAL_PLACES: 32});
    t('a.d6rkjt25eclbttos5e86st98ui7pplg2', '10.4002177231432347386440520809', 33);

    BigNumber.config({DECIMAL_PLACES: 89});
    t('1.2b072cjjl73700ahilibdmjn9hikf536njnmd3bdnbbg161m7bma9bjkap2p03h71debo18h91obc8iilpamae4fd', '1.093210794', 26);

    BigNumber.config({DECIMAL_PLACES: 25});
    t('429130757970568370597933312039338574250814304378587454538.54123403', '429130757970568370597933312039338574250814304378587454538.54123403', 10);

    BigNumber.config({DECIMAL_PLACES: 90});
    t('4egk9mo5.nq9mpjg1mdgkn9a91fbo96klk0h7chndjbekikrg28g34n0boclh3jl8che73a1opaef0op0bi470embme8jn16423', '61006052805.855039107767', 28);

    BigNumber.config({DECIMAL_PLACES: 41});
    t('fl8n7g92l609nr89o0c.pdebbgbbmcg2ie112887jb22kh16fc3mcjd20ao0l', '1763744254574742835397196108.9100951', 28);

    BigNumber.config({DECIMAL_PLACES: 71});
    t('69761d43jbifb3.5hjgbjff0b193hgae658f84hgdgja17a37i8f74', '529879890174710223.294978746680768846329827392297854102963', 20);
    t('4e8ba596e760723db17586b2141fce3b37f803587c2c09a7f054e80000000000000000000000', '9999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999.999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999', 16);

    // Test rounding

    BigNumber.config({DECIMAL_PLACES: 0, ROUNDING_MODE: 0});
    t('1', '0.5', 2);
    t('-1', '-0.5', 2);
    t('1000', '999.5', 10);
    t('-1000', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 1});
    t('0', '0.5', 2);
    t('0', '-0', 2);
    t('-0', '-0.5', 2);
    t('999', '999.5', 10);
    t('-999', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 2});
    t('1', '0.5', 2);
    t('-0', '-0.5', 2);
    t('1000', '999.5', 10);
    t('-999', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 3});
    t('0', '0.5', 2);
    t('-1', '-0.5', 2);
    t('999', '999.5', 10);
    t('-1000', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 4});
    t('1', '0.5', 2);
    t('-1', '-0.5', 2);
    t('1000', '999.5', 10);
    t('-1000', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 5});
    t('0', '0.5', 2);
    t('-0', '-0.5', 2);
    t('999', '999.5', 10);
    t('-999', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 6});
    t('0', '0.5', 2);
    t('-0', '-0.5', 2);
    t('1000', '999.5', 10);
    t('-1000', '-999.5', 10);
    t('10101110010111011110001100000', '365673567.5', 2);
    t('10', '1.5', 2);
    t('-10', '-1.5', 2);
    t('-1110', '-14.5', 2);
    t('11011001000000111', '111111.11111101', 2);

    BigNumber.config({ROUNDING_MODE: 7});
    t('1', '0.5', 2);
    t('-0', '-0.5', 2);
    t('1000', '999.5', 10);
    t('-999', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 8});
    t('0', '0.5', 2);
    t('-1', '-0.5', 2);
    t('999', '999.5', 10);
    t('-1000', '-999.5', 10);

    BigNumber.config({ROUNDING_MODE: 4});
    t('0', '0', 2);
    t('0', '0', 10);
    t('1', '0.5', 10);
    t('10', '9.9', 10);
    t('100', '9.414403549937069229622318379677', 3);
    t('2e', '85.724', 36);
    t('1049a8925138111404333bb594303b3', '245329273960717287023167550190902.7196', 12);
    t('10024012', '79882.1397169', 5);
    t('bf8pijdqj7eaee8plp', '24913576091923713226797784', 27);
    t('92ede36', '221315101.4486109701151', 17);
    t('2tphhgbu3tfp', '201793843613197922.7289680244023879849892761206083518171246', 34);
    t('334304414323442111042', '361019216753897.578090634736893396795045144615285524664717189351698468', 5);
    t('101111111100000110101111100000101000111011101010001100001110', '863594881689232141.62881568577668460977625904', 2);
    t('113aa38477', '2650149344.4439337077845022587667990', 11);
    t('16234a9a69395843a26073599', '15410678383317464407550663.2765', 11);
    t('1h744d4aeb313h3bcf327e3b6ff77f452', '29005210991102584193184888994590829162676.36864180128775308524399848', 18);
    t('7fd', '3414.796182310782697496', 21);
    t('1h61i9i6j802dh7e3c7hia36', '1564677221233470232427033268065.9552132872311604979708', 20);
    t('298a2036a57a567510698a8209', '313334205044060726367000938.043033074655734794248199', 11);
    t('1cc6e75ll568fh0kd56dje1af49489aooadc', '12702280403687491014084375085832810818379990225336.732151263602252539155', 25);
    t('b359476583b5', '8388678747448.862', 12);
    t('8781fe7e4176fc66a66ca5730090c7', '703596669768604729463688604501971142.9176994711280241981325903319', 16);
    t('101110011110011', '23794.501525', 2);
    t('1001201202222202101000012002121220021201110220122020110022211', '45111254165346649183259916415.393038562469348926338378', 3);
    t('221', '25.3631', 3);
    t('121201', '450.79905', 3);
    t('202001221001121011021210021222001', '4132525698405883.4635374792891809964908659831439118', 3);
    t('1000', '7.792303494645702446763290630498884400068339335428470929289382355', 2);
    t('10110001101000000001011000001011111010111100011101101011011001001001011011010111110000111101001001110101110101011011011100010', '29513071238598351326634077220532565729.753116233815194468461197227952', 2);
    t('110010', '50.3', 2);

    // BigNumber.config({DECIMAL_PLACES: 1000});
    // t('0.9tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn39tn3', '0.3', 33);
    // t('-755788719654700625.3724b27a98ab8461015aa3993106b7425561a7947a368a886a729ba36b9b21b3401602995ab641085846038360478a6a4a4b138161a926592b703882799057b605a209854367054112a0a805489089a2b81929842754b24477344a744498b65462136aa293a42922b87343b4473317594350832086048739518722163986b5aab086006b0b3264730478069bb598131768954235054677799442a1a645a56702707497428a71984310838281214a110605a4996316582806434651aa2413a4a35477a48b9076b7752598932ab2a0437237887a86633a04a10817a64a5a8bb4906786542a7a31891230045250203b18986684b7582a8b5130322b399145b9b6a97143ab27b1768b3a698057060ba2b3373a7292653a64b314947862b78142a6ba28321513a350b833950438b137737a5a21861a2944132837498282314b91930079a7881464a2b0b9180b47aaba43581348189636298868b0364532b7777a2446a916666159b8b430b73345246b481937638714a820046765214436a192052813a993944190b7717b76ba0a82853bba355255173747ab49a904191b6660a08820098bb900192429401b010016224a7201a1a847a6151b636509738288245a83261829041354787a89b02211247204a98648346a695053b91856537472426160045438425446599a19a7208b913449438743351393', '-16541654165416351613.3000065165841541556784990494619761', 12);
    // t('-0.000000000000000000000000000000000000f4j4ftgo2kfkig1lu51ni9cfe9d119suj2gl2ujs6ks78mesor2qpihm6m2g4oo7t1jd44b7gf0hrdhjd9p0th4jc9idjm9jm9qulcqo0p43atotsgmqaeiqfo6q6ipc0dgje0jjpho9ugphegqbto5se29hksk22dq5q5i97be5cgsuj13c85c4tb7inc1a1i153rfpcbp65103n13466sslre6263di7rbmcsd9q1esffdtmu7mdt77ra9gf1rhknleod4id6jbhqq90hppj08bkqa5b3ob0a688iop5n66kspaa4dlqolfl9us0dng6ou0a2t9kpjnngoblo1sain3rg7ulaadd6s78n0s2tr6rbdel0627p5imf7q3plnud3prlldun19e198jikr2f39gb2p7qmd25hi6npbt3okgpfp299n9048bugt4d6g6c4063di2oltdu5i4j7ogph0mnq0o0n7g33ekbf64k7ui31ocjr93i1jojbja5b6j4593qnlh8q5b949n7pbjpsh8mdcs8uslfpnjj1pgk6jihp2848a01agg1nu4be04j2saiqfa77toh8cd17e3ecq9i4mot7e82m2mpbmbbm980i5aqlgce92ofkbchbshprhmp0c33m1tjuf73jp17molqmn51m1n86dc0hc5hgtf6en3glecgr8nsttn3ta4i0j6iionu70utapfuik1sm37hdu0h4cpl60lqmr2n5q8k9jo5866pehctkringti5eeqoi1i7ar3j4tars7q1kciok8itki5jeruq636tmal83ii9fd2kh83aota9hei3jn72777up8kpoo3g60rd1ujj3f7seic20c0jkpdpamh4bpidupl35ccnljfr6b29sl16cclgtkankajrfgki8c5u3qddal0lgp0rhhdl0bctc5rcqlpqf289iknm8ua0m', '-0.000000000000000000000000000000000000000000000000000001', 31);
    // t('0.000000000000hpwlejv37aqn2neqd4iy0sm7unmppfy1apey9u9p927prbdsbgd1b45t3p7vyifb6l4dut1s5vei3atsmdfap8nv6tirtwdjf220klsbwsc00lrraupr876e51kdbmsq137te8jbjs06j97obx9ftyncxbcneopuyolubo9r1ue2o84jpl1bkl4rlnun434yav93cxyne0infiidgt1ef1kn544ces10yn4ii2o0l8dxs5e5km9odb0yim3qbte11085r0csniyxr3qv20q6fefqr7stu78yewk04r12kwbncdljuyfulbtyuv9myvkv6f51lcnrdde2iyx72idqv38ntmg5pweqahxa6rax0w76bwqrlmju9nlsngdd39pjr5ypv0wjiipyq72biby5r2yecd1a1xible9do3ilv80hqrtsrllndbbfvcevlxs1s7r8l045400pdp49eghd3dmxaej7sajpclialpo46tqmlxundvl9w9xvjje8kxsc9khjqa8j4r89gj40pvxdu09anqyxyxiwj4p0ynrewrfkwftbfhiovjj5n2be09qg695obvaqkudlyo1khnc81wsghfdilwfx5xtjrwsj412cn8prwedxb5286v6ctvmdi8qmcsarh9grx4vxopnuo6afqeovo7ar83vw1hrgpklwtck2tm7061i460y54tg4ajadt18lsyhrbvp5c3xbqpp8foy36s3epjw2pdo7rg4bfrc675wug8vskgopu37ni5qxpk49l0gk5yg5es5l9l2tkb634osunbu1tkir9mjihi2300lj6r8bf8d50mw1636c2ewpscd6fd4xwsao7rd958avhwh51epte3b574wiyjos8681clhmpayclij79biitko0g07l52qkv4dkl9lh5gdibg37tsjfdw1bjx8cvwabvmrbxqorfoidmp46rusj22d3ixyta3b19qeaf2ril0dy',  '1.5e-19', 35);
    //
    // BigNumber.config({DECIMAL_PLACES: 8000});
    // t('3221311113213312301200121312331120223133103222310312200003.10133120021030102300130322112333011231122301021302213211200122102011112233031000222132211020000222030131132332123112032011231212023103002033233331010100311003202212321120132003300212303030201300012330123122330011010023120011231133131303033221010022110332233211122331110100033103213302033302020221302320001301133313100221130221110131313232030210310233030230201333031103331101332213032210010121132231001111300311120000210222020003220013031331132302223232211202000331120203120223002210103102123033103022323122102020231133012110000113330301003121100102101202202232102133333103113312030101330301302113232310200111011321101012102020322322011321031233202033213210030201210230303023302301220122030220120322011211011100022123210023332223110102130033003120330021302022232222322102021002331133033202210011201331101022101021302331003321111310101133200012320210131131120122333303103103330203000020230111101312103232123002323102110012331121022103300032132101102103320030200001120033320130221133320000331310233101121023130032302213030223101131033310231010131233311202122331223233132210233023201113213330330102303103130222321020110211100311231310123332211301331000320233100223202313100101331122003112132130213011201211301323000002121223132122002222312231332022010323332211130132213331031010202301331120113332201302330020311301100203132020000121122232000131231313113320133322320023011123023010232031130201203313013031131330022010102113231021020120130032110122131213203120023133323223312031122123111323103013302011120122210331110021201303311023203333121113231121322013322233001321103310301003132213320200123011300132232131101313210100120202023133310332112122303233203030001002103331232311130232210000231100122302131223110332003331230110120303211200102032230000122120131120020320022101011012103212313313022112302311320030310021313213230200001231232101120023230000301313230221100101123312210121131001221121013022123110300020300201231231323321302300132211232323233120113130332103333013122303210021002301122021201010312231001300212310202123103311011023331333230203303103212233020310032212330330220330221022010021221113000330133200222130321300010000201200303021321332230023110110013213000002213012131333100002130030202111001023101233230330020032312023113210022000200301310223113233321220021111201110022133203030312232102102210103302220310230132031213123133201112010220120333131023110020231131300122130221310000200111220302221213001230221021203330003331231222102113103221002301233213322000120321022201200230130122030011133201210311201201322331201111300133321213221013323322313031112003133322123110033323023020122123232300123330213213122203013313331030032312303220202321220213202100113320210213201220012321310333122313223031110022230332030123323221320002313331211003333220132010323301022130321122211213211332213001021010310101111123313030222123301101133313212013311210312222000133012130232232010330330110310021302100012101021022230011021231231201003303212003312203332213002132332113333132030122100101323121031000321033132100330022202133012300313031130300333231002000002222131031320203120111210023113300033012202101003200103100131010300231022202332221121132221222211313202002013031001011110210102123121113122213110103310310122032201023312110131121201131201012222020113300212211301202022321210311330113322013330010323131001331201212202033120020112212302020010320221023130233000030211332203222121023200323130010032021323113330132323300032003123103021131131111010033321333332003023113011331101131003233213002332201000212322122033020012323200113113201112021333333032111232112110323323232322022231322211322003012002023201200112103010132230033000202121311320020013200122212031312013001010002230123120123001021030313222223300223233330301132033033130230101231223122311313301332022231030331111010211120120321211113133312313021113002213313131110013312123320201321002231203030002120031201130332031101213220030320112103133110223121123101210303000131333333000322232301013210112100111333301223102233302220201321320121201200313312203123231221332032310101032232113122003233332202031302020000023333232123100112101321110110332220313323022231210130210111230301222133010222221101220223103312100112111100010032101332301102303300103200121020100321002203132330112132023311112003011010130021311030000023102011312101311220012230121333311222103213311212202001331020301121122202212110132033031123311330020132102001102112232232303323122313002330111123010313130000033021003110332132303223132303202300131122210210133000230332103021123130132232222230313021131300013222003333322211231332000000230102223122302201002010313113103211230001312110210013001100013302130313221312010231123013103020110332300323110201002120333312223121233122010022310201120030313023021020010103232330212122033111201323011210233012310232022323131220320212302130031120000333200013032002312120322213020210031023312201320121012222320230020230202230311320323302220121312133003030230110210031232233322121020222121020022023202300320100203232321233313323123133103323011003023213313230233331301032131100030030103232313032310000130332320321112101020111000012310320033023021202322102321113111211030131313303210023003213233232232031223102131000002231303331301312232032323310122133102323110311022320113222232301331100110211023132013211203123203211232202322033202213130101312210200022201123333302331022212311212320023102312022221323211002000020002003130301012122201302221112033331022220312131031300133332333033112310131321121210201132122021120112200210311313223100222322212101202111103102322301323302113220013000202133031132113000003130302130110011200302012303000302020132120232302021111122212222230330201003333000031012030021003230131232010302320011020033300203333112000331200212302001113120312210300330100322200200130000310003102023103033222233202101220122202012301311213301032001010103132022312323232220003010320113003303230301112112211102311032100131131211311333120200223202001210103220210211000210023323110210121020321022001103013003012321320112022300332203031202112000323133300130130022100001333111230311001032331331333023000110112211110023013310023212112121003000000103131202211330332333330110130222202332332313313211030302000102323333012333331210332220002033030120232332032123130011321201320001213123213210233122331031202233201001012131002312210110300120030113220200200220011322010301122020023023102332321000003300322323223321210022110221101030133123020013132121233320100321320033131101023330201233212232312001220302313002001101312201021122220020221321211201210012203003120232232302211201103110303210320001033330120103220001223220003130113212110323012002323311320130033333302122101032110313110131003120013303231121213111110322323332230021332122203320313102010002312133220012323022320332211303331313032110131310113130223201121103110320330132100020133122133312133222013301200132023232220203102131300113011321322231022130101021212313331313312211130203333203123331011310021212311331001201000033123022332000231221322320010113323120132002122231033132120333203320303323110021203021232233102020021322301001121233312100003202222100020113113012200022311210133022301031333003131020211221302322002213311130131302101032233231103213132013102300311233133303323033130321230231100220031131100202111221130100133111002320222202230030102003133102022111200103010113332233031323232003020312002002102330220231320100323032021000333110231010303032032131331021310200120130221022121220002102203020220101210110303232330100323312121333232330303311032322233102223003103101300331132011232012120320123203002022031213220322200323101333332132001112100120000220000313330323131013111013311122302122110211010300213302330233300312130131130013321002110003012123223213013002321132320300331121121010221113121301220111133332323320212323022203200030320123223011203203330131131303100332331232003013200020132210303320022310221123212031133331223112221123322111333111133122001221300212121230130021122112001000313112223110231102032031303223110233103010203120320131203320133302310301233012112201123313233203310102001003211311211320123010311', '75883436516535445385952265101338627.28064184', 4);
    // t('c77g12a7326d2dgf821eegb03bfac9c0d.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', '29455060024714386814004539395764145766251.71334340573066029478166351919', 17);
    // t('23.23002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331130022033113002203311300220331', '11.69', 4);
    // t('120061a508.249577ab453213141118532579b5aab698b136731a654722605a56b4186564888369ab19408913065b21300b2a52216a4871491852b940695439b35428b808a49869a0b3b95750b4a45ba57738b898520349070074053a62ba67b85174887927179692101a8b3097a8b38741ba2aa0b1901312b01903248830787b488aa435514b1120b4b9985a8861670b0226677a86463a199180861b5881503242a25abb1a2870b02308931382b26550a6b5a71196ba1744b9a0b488419953a81604003636a75920011839ab69514396b4b9aa567989686b6174481659815011b1924a998086506bb827939ba9ab75625005a8716813460829894b1b848bb541bb80894b451596731308104974692350a3b114b91224bb035a5048919001b5a3313a712142214344235a559131b681425277245a068a3178612425b0902134212bb65876588135198ba5b611b9617a3b878b354236731975420144b8b7888781602168a430953a00460856317b49b12b87067a4963912601102a5a021489b500130964b9320269391888b33949510454b84a66934ab828972a00540194745660bb89771618603a92a5160444883119105843786965783125a13b02b5aaa88a26b9264b36685303b561b53bb782212948b7148344176985318232a38b41b81a19a421968072909b23255a9566639612b67a59b943ba9a5432b103087b69a8aa51102664731292a0832a65545100152192290738220371a58403611a43a989193311132236423573b86509866762584947b8527b74883594436b5409560b00398111018057b51965878457723ab43682392318a29a539a007417bb2366050a7a76a5b43046524b28b812973333b931196718741b6148742743b11575842b15977109881b187b19887a6959a4428b42a769471a356099486a3170a43b33492a78289019818b013649ab02a7427886ab757248939aa84aa12a76713472aa0880775154447862a6211763b40ba71b735b7b31b257773413a0022018631012403b20199a93a5688077a77142a8409369a64a29820569b769bb1400b4994a855671357b4254121611254b901916a2738899936250b3a09a491695720101ab201aa5b144b495511a00b92089118605214032a615a039a73034915553b88275975037a1852510b00b4380828860465a608ab8365500a1483853596461a7836b1a74993aa41129803a126035701689158795a83429977b20386b4430641140977714351832625811443b4b669206393a5a14731497b8a018b032a79602242413b88607609aa35ab8a780932480023a8b535586384b36422b66340732119b8697a86123a955b964813b3a93a1a6bb987361a489a51343710bb1792a67b19567612731724b7060338a96781270a00457501aa9b0b7309160368135550351a84472882871657207a506a65b77b5779680068b3b2566a72a8a1707b584b541b0424922a7990b28b363a755a84b86724568b56387415900450758812974586682177351088b13b429ab35783171225b62ba33a6672b342204710b678b8b8565224a92a3b4075014b05031300a9321b50ab26248313a42a011a229553a7184227a7977a6a6232298700a3a83b01a96430a153097541734043765151b4b2216a96298059a701b689649973263b35340626694376085787021b0947b24bb5755504678825a487719a8255553309339b3877a245401580aab69aa238b7348837933315018030866b13a302490925a44041520156005b6120b47167a755023078a174b0578857b218511708896a1993b356874393627237bb347a72452ab35158077911492909a535a06444a5439840a525987461aa4448a4b41a40136629908687473a445526b72249ab2873b9808725094161a4552041965273aa69424a18b75529015403a5005904ba9588427ba12a36409b76265925ab369b062a966602b5995365ba4a07235b9986789a14a642226049b160132340b07ab06764bab162446a884792913612130784749a90363b82ba56a0611329778888ba4076a279a15a7539266b511b50132a5b1b6988762a00b4502807a2470859035b63b157ab25a6698455223a5655a5895063a020161a8670484b8211bab5831606a098a30521b67a31407716045a862952b6707a497b555392b32498b94678a797b46a1bb276ba7267753b79b67a947657643885735062762a291422b351a772b9b0513b4b1598419768b5410260142991521890716a87750651a296041887b2901b843013688142329b2b164302097840735a84140158582607b3025093487907326181587aa09a08b034843510b646430518051bbb533504685b85bb985895aa4aa7a655a9a389076a17367259343a7107769146a4505524b1773037507578a5b179916105b718aaa69b305008309211a01a23629934b73573396aa4410644abaa274053720bb077a91b1a0898b9677795246288951221bb47080226052832918548499352b4209b78538a398052a56b03002679075321330a59a900192b2146b944976094109a047a367590972a409167760668279bb16b866671b2798991b61407770b3ba67a8889077b5124b657244b949b36062389702383a117583053102175081866232635ab4824239a53554652920a58ab5b51291a5a42a49b488211a2932ba8320000640b0237810a995647467238544155a8717335829293b232a6664840ba6ba66954b5202abbb135813224708976101210a7042a301a4677101b3367765796287b4a1ab791602a769a62207a84153a16857271a9a4849986243b6a6b1735469492993a52349447b2b850ab793201a112053254a8a34ba01377a12543594045735815272561132577824032932a8172281b20b09703857459186b7aa422165103a2423a826127648976b58a22122ba7091480496291124a66671434b18715295545a43b587955755ab780564a3a5a601614553145aa16357282ba9955b0b84255951a9b62a7423a120b008b8739a76a86599774a4967b6209b193ba013b116881b078903a907379608a48a5958a9657694ab9942299a92b1884040667487108a2556968004612386970b020044a1763216658265586b8901a4259172b992519ba2194ab8bb4a84a7a6b936370842254a32b5801612418b4805ba4512b1aa9b3985358a358a0a0843606827b5941774642b846b46ab3526542ba952374736b54ab608a40b9bb18a896178b26999503b9a63486003684255884907311039200b90a30705515a6b3b5933b87429842720b841004078a07691b3006014ba97217b96439539406840bab24a70b35a264718bb6a0502021a4217345660535a40b638a88170222383524b04a2b1440b40b94413b7b69804169199744383bb9b5255b80a0999a13715770075351a6a7579544b30a8970a64599b3968297632a501413499867a6a457a05781229b8179710440559b57a03338950bb4160463b6a81554b3190329955b069054b17b5218233125186098888279248485b3a01b27359890727435188a28485882708318a593a7036514560b65b8248013a51381403b96bb205883992484b49901078ab7654937516138480a39501a7624946822a4641905500782285807092051265b12a9759391425934053b863a94839137573b000b737a9909b3627297009484220a8543277116973311550588830a59303462b4a5703471773a3407266948561528443a2b95208b96307900356228b177bab91a67281b330829683116b0792b803a031087163374539b50b988b75575a109a312992b66a2919731054333205269390a991586734a327272814ba95b5880ab30a8203415623216801207a4343b30a3469b902b0246b5ba8a7a26a8904aa72a3866611897443295064aa71bb573b7b738b20830382b3012100a865ba199a8bb44763932497477042537162a613810514bbb818323aa9172a773952624651918aa9043b3364512b2400491a3800a1a1239507141228a9324228345414b0a31a8956997a6128a80794047662a46308a7b394b00648797a61221855a0746a29b32a971ba55b52a96b153b2575073bb8045077b75b263b43733619a7b12bbb1a483654ba584b1193146521133995438b122a89b50498939145b77aaa01b76594a6413aa84a3b42842a9200503a5138b27007b95a1a5b140198319606467b40961a89574b34055733b2193918b87a99994297757809287245ab5586986066720bbb5ab922527304349a011831678b29bb623400ab52870ab1a414114754210088996b82a82a43b175427216094363394b71a71997561a63485a13ba06519165a85948a652168a684a23aa8b8428a592249b259a64666a34b8937b36536450b013abb126b56027305191a8b3bb2a6491982a903a7ba733b9a20b702b39553a634438687020a585b0b3316a20b749171b41a09b5817532213521b072bb15871825b0a275636a0b9901328404b1189983852468b3a942551382301669bb248286958131579054a30b47628a9807a3b014842099346845673028634726526809503b7126435830587aaa58a6a0aa712a464676380bb4424b0b74925808bb4a8011a38740a69678855693262850a4903aa98402871a53655a08794b680240110b399455b1152478a55b254908b839378846351320b8994a3092556561a2878b791a09486892a0414510938840b1a2881132353445b5095880488b81502b7b3ba93b5a82b4820187a4a1a517854679983b0821b8066a761368a5a850621025b592b57010718605b42277966a1353349473a46809696808214aa7716b368429471a764634747a86308a9317511a02a80567463a052ba29a77410835403815b979347989475919631324110588119b702593aa590a1682bb8b1773bb7aa244869a4a5633900a876a57892505a359373b208088a9805ba791564055396074116523893494b31a9949b8983701425b3651aa67210611108b59b4a73100508b481467a399b05393208769134496817527a214238169177065015370964830190138425556997798060960894533410274065287a08b9bb004233555115084b2116054034406b912099554306202a0a22b88494879241443a5316792b6a4b9bb603b908a1ab327aa685267b24a87a145643134b2a001b25a6a64917148b27476a4b3814831261127b4ab996b79092405578737a304849369b06667593a47066a74168a713a759399647b350648a452011ba895695a471896b91825b756833794946060b540818bb4a5b0462242a01aa444076a535b2077388860a506ba6477789752a4b8144458a372131399b7294706a053363078105261ab5808737621a19754256a7805206ba5ab72516b72a1085a65b096807508bb05776877331857378439790711a6b608358182834361b90169786b86546088836088346b76a87b097826194a47b8a488a60bab29bb708379b086280592a5710601908b0980ba9b1a3530b1b26a77815b82b4b4a2401bb9b460000a480873b5322435295837353644693860767589100b307054615a791650840199b8122b0138b2b41007374a441322243367a341335b9335766186b333b9a515877598b42612738a36a4571', '6021275480.19992468556125044489507', 12);
    // t('3203001330102013.21130321012302133220331003232330122103203301112100203330232322130110130100232123110222112233321113010300311221303100223100220003133232311223111122202300331320123002102212012310230132322003033131231212020000123100033313033011121012110101000120331113033033223012323213003130323010323001322210131131003300101220322331110202100320100121202012332232311330013101003220231301111311112301312012032112222032203301103200110232000133232210330301001122322320123031012132313230322320230311321133313323002012300020201311130101020130002333021133101231212122032222121110213303112203111320130330002333033320233002012133101310320330031300232120023030123103031130130200212222222300321123121021133202122110030202031112003303322003001201202013001103311132101200300133122302112221330320013331223030231200212122313323322320303210012021201132023003103201132300202322130322310010311113332133232223313213011232113232223011211011211201120033112332323010031010231310330012022210311023112312220131323203230111021202221330013333313320132000132301300013330201232332121312333321222023330202312102122333313302123020000123313301022113213000112231331132331221331020200310000031231022121323101100130020011330231200312023311013011100212230013122120303212313331032031200213201230013320203103121100333112300110131211121012113202202332331201311011201120233322230020302222002230211012233033000133120120013000022221101132223212233331222102321103202202110301223303032100312313221223331003322110021022102133103003320231112202331221100011022033113023101203002133013123321031230330013310031112222033132320302102311331103313210031300111222112133302112020020202320002011122331003011321333312212023301333132332331232221313011132033200001322323000211332013103312011332012032131311331122313012211022322312000231333002000311302013312103103211012113200012131332013302030121132321120211011032200102030323211023010120131332101212110103113002011322302112220332032302313300312231310021302030100221111002133331312100233323020221321123021212120311112012313121121033230223310323103023313312012220111331110123310333212030321201011102003012312011301232320123112311011131000111212122232310002303002111301201323030331301000130230010232313301222103321121101311301110012103313121023321013201310023003131100323212013330312031120200123113221100122101203212223001103003011001010301223310320222313032202022200021110223320121331303110013021303303320003313133203132312232121200300232130033320110333222233120312132113321013300020100023203300310232022103300122121002003132100331203013100011121330331221331002222303113300331003022322032223133000200110103200320223022231213012033011022211022220113102320331121101100213220121021233123333123111313021210102130310113012101020132211220001130102112133323203320201110002102133112021000230231103132112010302131201103000301302331223023221121231230210122000231223103022202122223000311200121002100312312302121013002102312100323132332321302222003011203333101232132213233210011222101200330200212221202321212022000133121301300213322231130012230130330200302333231121131332211003232303121201201132220010213310002300233023130133303201012010333011212100011322222031210022310011023132022301210133132112011321300323232321331110200132320320131220120202021303331033030223032121203002000320101133303010111010011221133310000322233032202212123000120211120112222031021012112022112223202332021133002111302002213100332312110120013301220002101131331313311010020231322210223212133231202012023202200130322012301223331020012223131233211001201110303230332100113010100303032121232321303011230001213031221101132213233323211213131032222102231103001231011122002211233013220321213203002101213323022231231331013131333201220030110310201122310122023022202100011233012031102200300021233112223022323022212121221122203120002333232102130101002123203210020223101333103203302023200220002030201031330011331101000323121100333032101112230000013221031213333301000310201101011213031032210211020011132323200232333013130320113212010220332230031302103232012302111302133302331311121333212130103123312301131230320320332002313000022100123102321212000330122202230311030103233002020020123113120120312001032132131123003311321213201120203301210312021022320123020031232003301002221322022010220033301223033131322011121313020321030023121031221222111020000133113022111032102023213113011310212233320232120113303102122233300201102222232201111220130230213230232332010122332130013320123113332113301223231231321331203211033230213031200031001001222001213110310221321010003221123100001222232213311110032311031010031131002131311302112221213000222220010123230120312113121222322221010332321201330311301221032332322011012131102002102331002223021033221110002121221231023212333023133232330330130303100133001300230301100303033133100021021030212323313010332210213013231022003023311303012010000031102222221213220232130010330310013210200231330320031302201330120113123321223202023032112210231030322032001201032231000033322312001331333211230233022223110122212002200230121022213020222230201302102323232112100133011302320032300000003030200212011333203121001322130313003331320203000202200311020313120120031101012023312300230133003110321222100211311331112023031011112130101213032303131312031022010031300222301332200302310331210013213220223231212010011133301033221132210330320010330311013213133121113023000103020030211203021103333231301300013133310022032132133121033023233000203313023000103030121223110012221213213021102312310200301301221301011010202022023010301301131031102000001223011213013020331301013130223310121220212332012201221121223000002301230022110322032032111220300320302332313112331011330313320023321033312112233300122302100100033321210220010123030313232223222303003103230211213220022022123201012320211203300001102311003331021230013203013220230221031202320301320010120110320220301320013332030131030020321302201201321312221111132111202113111322020203223303102103112133122320330012221020131020300302131010323013101311032233111312021131202230010303013023203112023102302100133123011022013220310331120030113122122112032203200222223333223021102123300102111233202311311112121220233011333111023103300322233201100223001103131003321220302320333331320023221103112222103211210032300312320303123133312330322020210323210102230111123302323232020130310000302133022221210000311313103100031301133012123010010332210221033213313001113100121232010001030231110133000221313201002221101321333022203030212010222220021120302001330202310113112101130220202013302113212220220032200023223031331321130030301023111321233030121133321313033323102211310312331013211233120220103231103011312113201102100000102001311003221003032111013103132002010110010330223323211313102310011212331221113310231000230110311022101031201102003021031233233032222200322030102302010301301301230000103020022120112223010000233232233033021231203302100220021121330233021213232130333201113110332310022330102000123303232330111233121120312231102322301312301332233031033122121211120011333020012121231301003200330122103123210110321232122203313130300233230130121031002022112202203223013003110221303320322331031232220302011113201313232122213103013222122110023321321220012032022203000103110010021223311300333231322100133211301013230310213130312131100313101120233012133112231131213101321212212020323101113212101303013111332322120203011300000333112101120312320132222103011113023123103012232231132332012302020331010231300122310123201302113011230232101003120120313210033023212302321130133002331131111210301102212011330222120231233020101201321121330003103112333030203010232231332303312323322311132303322320110010121330132011212221213030302210230300300011202213303210202321102312202310330030030203212210111010123120010210202033220330321311233111102312230223012220100002210111212233222213320013321112332123130230213210230300000330222003000101111220202121023022032133021133020033013000223023111212101333130121300222223110311202032311123113320321110320021112123221210122020030010021011033210002222203132122111221103033313333103023210330321030211023120003002011113120313221020213012022', '3808937095.590715119594237', 4);
    // t('54653.68070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358303680700465732615411218625176475507872284014433583036807004657326154112186251764755078722840144335830368070046573261541121862517647550787228401443358304', '36255.76650', 9);
    // t('11010010101101010001100111001000.0000100001111101011001101100101010010010111001010010000010110101100011111100011011111010100001111111110100010010010011101010010101110011100001010011100110100010010110000101010000100000101110110000001000100000110011010101001100011101110110101000000011001010000100001111011000001000010000011001010001101111111110100101010010100001101000101001010000111011111001011101000011011101101000110000110101000011001100101001001001000011100000101100000110011000101011111001010101010111011010101110110011100011011100101000110011000010011111011000110111101011110011000100010001011000111010011011001101101010010011111001000100110010100100000111001011010000001000100111000111100001010101101100011001000100100010000111110001001101111011001010100100111100100111000010110101001011011101001000110000100000000010101111101111011011101101111000111100101000100100011011001010110101001011101001101000110101011000001111111001001111001000001011011100111110001100100101111101100011001101111101011111110011110101010011101011100010100011010001000100001111101011111101001110110010110111010111100010000000111111010010001101010010000010001110111101010100000010101011101011111001001001111110010000100110000011011110101011111110110010111101101101011111101001011001010001010110100111000000000011100111000100010011100011111011011001001100110001111111000010111001000110011011011010111010001101000110011011100000111110101100100100100101011110111101100101001010011100100110111010111010100001111110100111010010001010100001101110110101011001011001101111000111111000101100001001101000011011111001000000101001000111110101010110100100010011100100100000100110011011110001100001011011111110100001110010000000001000101001100101100110011101101100011011100111010010100000011110010010111010000101000010001000011011111101100101011000100001101101101110011001010010001010010000100111101001010010100000100010010100011111100100011100011111101000100100101110110001110011110100101101011001010110110001001111111110111011100011100011100101111000110111000010001110111111011110010001111001101101100001001110000010011101110100010001111010011101110001010010000101111101001110001110111111000001110100110100001001011001111010001100010111001100010101101111101111010010010000011001000101111101000101000001101011101001100110101101000011101001010111000000011011010110010110100000110011001001110001011001001110001001000100111000011010000101000101011001101010000111001111011011010000110110010111010011011110011011010111001101001101110100010111000110100110111001110110110000111100101100000100100111110111110111011001101101010000100010010010100011011011011011110111010000111010101001000001011011100011111010111110100011111101100110101000111010110110000111001011011101101100100011010101110011001001011001100110100111010111100000011000100011111011010110101111011100001010101001000011100011001111011110111010010100000001011000001000011110100011110001011000100000011111110000000101000011011100001000000010011101011110100101110100101100010101100000011110011001101010101000101111100011011000000001100110110011100011011110101011101111111001010011101110001000010101010001010010101110101111000001111101100110110100000100001001010000110110111000001000011111010101011001010000110001001000001001101001011000101001000111101111010010110110111001001100110101100100001101100110101100010010111110101010111011001011100110100111100011010100101111010001111100001101111101101100000010111010101010010011101110100111001101000010100010010010000111011001101001100010101110100001101010110011111110101100001001100111101110101110111011010011011001000010000010010101111110100000010111010110100101011010111000111011001010010111110100000000100101110111101100110101011000110001101101000010100010000011111111101110111100010000000111110001001110011101010101010000011110011100001100110111001110001010011100000101100011111110111100101001110110010000110101011100110111010011100011110000010110111110111101100110011101011111001100100101011111010001001110110000101011010101100000100010000011000111010001101010011100110111011100111001110010001000010100100100000000111000100001011010000011010000001101101000000011011111011000101110100101101101000000110001100010000101100001000000110000100110000010100001100000110000000110000000100001000000110010001010111010110100111110000101100111001100111000111010010110010100111010100100111100000010010011101000101010101100000010011110110000001000011000001111111010001001000001101111011000110101000011010101000100001000000100000001011101111110111001000011001110100101011001010010110000101110100010111011111001110101111011010011101000010000110110101100101100101101100011101100100011001110100110010010110110101110010110001001010000110111100010100100001100001011010001011000000001010100011000010001011110010000001111001011010111110110110001111011110000110101111111010110101011011001101000100111010111111110010010001101110111010100100110011110110111000100001111101010011010100000001001111011110111011001011110100001001010111011111000000110010111110000110111011101001111010000111011011000010010110110110011110101110010100100001100100101000000011100000001000001110100110110010111110111101110010000111101000101111011100011101001100110101001101000010111110000010101000111111000001110000010011010001110101011000111101101100001010100000000111110010000011000100110001101101001011001100111001000110110111011101110001101101001111100000010111010111100101100101001011110010100000001100000010001111101010111100011110001100110110000011001101010111011110000100101110100100000100111001001101011000010010110100001000100110101111101111001010001011100100010101011000010011111111110100101000101000100000011110010101000010001100110010001010101011000100011011111011010100111010111101111111010111000110101100111111001001100011010111000101110000111100101010011100000111100010010100000000100010001111110000001000011011000010110010001110111101111101101110110000101101010101110110110101110011010110101001001010000010000011001101010111011110011010001110011101010110010111111110000011000010010101101001001011101100000110000111000100101110111110100100100000011000101100100111011111011110001110101010101001010010010010110011111110011011110111001110110010011010101001000011111011010000010000110001010101110100101001101110111010100001001011110101100100110110011100010001101101001001100000000111100001001000101000011001000011111000111100101101010001110010111011011100100011110110111011000001111110100001111010001100111111100010111010000010010101100001110001100011001000110010100100011011110010111010011100010011010000001010010101010000101011101111110110100010010000010100001100101101101110111010110011110010101010111100001101001110111111110110100011110111000100101100111001000001110101001011011010100101001111011110000111110111110011100110110011001111100100100000111010110001000010111101110100011011110010111000010111101100000000111100000000001101101111011110001110001001110010100010011111100100001110101110010001111011111010101011101111010000011000100101100110000100001111101101011001010000110111010010011001111011000010101111011101001011010001101100010001100111110111111101000110000010001001001111110110101010011011100100111100101101011101111010101010001000001101010000110101000100100011011000100011111000001000000000001100001011100011110110110000000100110111000010101011101101110010000110100110111001001010010100100100100000101010000100000010110000001100010111100110010100010010000010100101100011111011000111111100011001000001100001110100100101001111111000010111001101011010100100010010011011000100100010011101011111110000111000101000110011100011001001100000110001101011101111100110101001110010110110100111111001111011001010001101101011000011011110111010101110000010111011010001010110001010001001111101101011111101100101101001000101100111000001010011111110110111011101110010100101110110111110110110111101100111000001000100101111110001110000000011101011011001010110110111000010101000010110011011111111011010001000010010010111011101101101010010010100101111110101000010111100001111111010001000101111100110011100000001', '3535083976.0331634754719698597483934067029600647308860151850713734', 2);

    BigNumber.config({DECIMAL_PLACES: 20});

    Test.isException(function () {new BigNumber('2').toString(0)}, "('2').toString(0)");
    Test.isException(function () {new BigNumber('2').toString(1)}, "('2').toString(1)");
    Test.isException(function () {new BigNumber('1').toString('-2')}, "('1').toString('-2')");
    Test.isException(function () {new BigNumber('1').toString('1.9')}, "('1').toString('1.9')");
    Test.isException(function () {new BigNumber('1.23').toString(36.01)}, "('1.23').toString(36.01)");
    Test.isException(function () {new BigNumber('1.23').toString(65)}, "('1.23').toString(65)");

    Test.isException(function () {new BigNumber('1.23').toString(NaN)}, "('1.23').toString(NaN)");
    Test.isException(function () {new BigNumber('1.23').toString('NaN')}, "('1.23').toString('NaN')");
    Test.isException(function () {new BigNumber('1.23').toString([])}, "('1.23').toString([])");
    Test.isException(function () {new BigNumber('1.23').toString({})}, "('1.23').toString({})");
    Test.isException(function () {new BigNumber('1.23').toString('')}, "('1.23').toString('')");
    Test.isException(function () {new BigNumber('1.23').toString(' ')}, "('1.23').toString(' ')");
    Test.isException(function () {new BigNumber('1.23').toString('hello')}, "('1.23').toString('hello')");
    Test.isException(function () {new BigNumber('1.23').toString('\t')}, "('1.23').toString('\t')");
    Test.isException(function () {new BigNumber('1.23').toString(new Date)}, "('1.23').toString(new Date)");
    Test.isException(function () {new BigNumber('1.23').toString(new RegExp)}, "('1.23').toString(new RegExp)");
    Test.isException(function () {new BigNumber('1.23').toString(2.01)}, "('1.23').toString(2.01)");
    Test.isException(function () {new BigNumber('1.23').toString(10.5)}, "('1.23').toString(10.5)");
    Test.isException(function () {new BigNumber('1.23').toString(true)}, "('1.23').toString(true)");
    Test.isException(function () {new BigNumber('1.23').toString(false)}, "('1.23').toString(false)");
    Test.isException(function () {new BigNumber('1.23').toString(function (){})}, "('1.23').toString(function (){})");

    t('NaN', 'NaN', undefined);
    t('NaN', 'NaN', null);
    t('NaN', NaN, 2);
    t('NaN', '-NaN', 2);
    t('NaN', -NaN, 10);
    t('NaN', 'NaN', 10);
    t('12.345', 12.345, null);
    t('12.345', 12.345, undefined);
    t('Infinity', 'Infinity', 2);
    t('Infinity', 'Infinity', 10);
    t('-Infinity', '-Infinity', 2);
    t('-Infinity', '-Infinity', 10);
    t('101725686101180', '101725686101180', undefined);
    t('101725686101180', '101725686101180', 10);

    // Test ALPHABET

    // function t(expected, value, base) {
    //     T.areEqual(expected, new BigNumber(value).toString(base))
    // }

    BigNumber.config({ALPHABET: 'xy'});

    t('y', '1', 2);    // 1
    t('yx', 2, 2);     // 10           y0
    t('yy', '3', 2);   // 11
    t('yxx', 4, 2);    // 100          y00
    t('yxy', '5', 2);  // 101

    BigNumber.config({ALPHABET: '0123456789*#'});

    t('*', '10', 12);
    t('#', 11, 12);
    t('100', 144, 12);

    t('144', '144', 10);

    // TODO: more ALPHABET tests.

    BigNumber.config({ALPHABET: '0123456789abcdefghijklmnopqrstuvwxyz'});
});
