/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2PARSER_H_INCLUDED
#define FB2PARSER_H_INCLUDED

class WPXDocumentInterface;
class WPXInputStream;

namespace libebook
{

class FB2XMLParserContext;

class FB2Parser
{
  // no copying
  FB2Parser(const FB2Parser &other);
  FB2Parser &operator=(const FB2Parser &other);

public:
  explicit FB2Parser(WPXInputStream *input);

  bool parse(FB2XMLParserContext *context) const;
  bool parse(WPXDocumentInterface *document) const;

private:
  WPXInputStream *const m_input;
};

}

#endif // FB2PARSER_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
