/// Generated by rustemo. Do not edit manually!
use std::fmt::Debug;
use std::hash::Hash;
use rustemo::{
    Result, Input as InputT, Lexer, Token, TokenRecognizer as TokenRecognizerT, Parser,
    ParserDefinition, State as StateT, Builder,
};
use rustemo::regex::Regex;
use rustemo::once_cell::sync::Lazy;
use rustemo::StringLexer;
use rustemo::LRBuilder;
use super::pg_actions;
use rustemo::{LRParser, LRContext};
use rustemo::Action::{self, Shift, Reduce, Accept};
#[allow(unused_imports)]
use rustemo::debug::{log, logn};
#[allow(unused_imports)]
#[cfg(debug_assertions)]
use rustemo::colored::*;
pub type Input = str;
const STATE_COUNT: usize = 85usize;
const MAX_RECOGNIZERS: usize = 6usize;
#[allow(dead_code)]
const TERMINAL_COUNT: usize = 40usize;
#[allow(clippy::upper_case_acronyms)]
#[derive(Debug, Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum TokenKind {
    #[default]
    STOP,
    WS,
    CommentLine,
    NotComment,
    START_COMMENT,
    END_COMMENT,
    QUOTED_STRING,
    IDENTIFIER,
    SEMICOLON,
    CREATE,
    NODE,
    EDGE,
    GRAPH,
    TYPE,
    OPEN_PAREN,
    CLOSE_PAREN,
    OPEN_ARROW,
    CLOSE_ARROW,
    OPEN_CURLY,
    CLOSE_CURLY,
    COLON,
    COMMA,
    BAR,
    PLUS,
    STAR,
    QUESTION,
    INTEGER_NAME,
    STRING_NAME,
    DATE_NAME,
    NUMBER,
    OPTIONAL,
    QUOTE,
    AMPERSAND,
    OPENSQUAREBRACKET,
    CLOSESQUAREBRACKET,
    START_ARROW,
    END_ARROW,
    TRUE,
    FALSE,
    DATE,
}
use TokenKind as TK;
impl From<TokenKind> for usize {
    fn from(t: TokenKind) -> Self {
        t as usize
    }
}
#[allow(clippy::enum_variant_names)]
#[derive(Clone, Copy, PartialEq)]
pub enum ProdKind {
    PgP1,
    StatementsP1,
    Statement1P1,
    Statement1P2,
    StatementP1,
    StatementP2,
    NodeP1,
    EdgeP1,
    EdgeIdOptP1,
    EdgeIdOptP2,
    NodeIdP1,
    EdgeIdP1,
    IdP1,
    LabelsRecordP1,
    LabelsOptP1,
    LabelsOptP2,
    RecordOptP1,
    RecordOptP2,
    LabelsP1,
    identifier1P1,
    identifier1P2,
    RecordP1,
    PropertiesP1,
    Property1P1,
    Property1P2,
    PropertyP1,
    keyP1,
    ValuesP1,
    ValuesListValue,
    ListValuesP1,
    SingleValue1P1,
    SingleValue1P2,
    SingleValue0P1,
    SingleValue0P2,
    SingleValueStringValue,
    SingleValueNumberValue,
    SingleValueDateValue,
    SingleValueBooleanValue,
    BOOLP1,
    BOOLP2,
    identifierP1,
    identifierP2,
    LayoutP1,
    LayoutItem1P1,
    LayoutItem1P2,
    LayoutItem0P1,
    LayoutItem0P2,
    LayoutItemP1,
    LayoutItemP2,
    CommentP1,
    CommentP2,
    CorncsP1,
    Cornc1P1,
    Cornc1P2,
    Cornc0P1,
    Cornc0P2,
    CorncP1,
    CorncP2,
    CorncP3,
}
use ProdKind as PK;
impl std::fmt::Debug for ProdKind {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let name = match self {
            ProdKind::PgP1 => "Pg: Statements",
            ProdKind::StatementsP1 => "Statements: Statement1",
            ProdKind::Statement1P1 => "Statement1: Statement1 Statement",
            ProdKind::Statement1P2 => "Statement1: Statement",
            ProdKind::StatementP1 => "Statement: Edge",
            ProdKind::StatementP2 => "Statement: Node",
            ProdKind::NodeP1 => "Node: OPEN_PAREN NodeId LabelsRecord CLOSE_PAREN",
            ProdKind::EdgeP1 => {
                "Edge: OPEN_PAREN IDENTIFIER CLOSE_PAREN START_ARROW OPEN_PAREN EdgeIdOpt LabelsRecord CLOSE_PAREN END_ARROW OPEN_PAREN IDENTIFIER CLOSE_PAREN"
            }
            ProdKind::EdgeIdOptP1 => "EdgeIdOpt: EdgeId",
            ProdKind::EdgeIdOptP2 => "EdgeIdOpt: ",
            ProdKind::NodeIdP1 => "NodeId: Id",
            ProdKind::EdgeIdP1 => "EdgeId: Id",
            ProdKind::IdP1 => "Id: IDENTIFIER",
            ProdKind::LabelsRecordP1 => "LabelsRecord: LabelsOpt RecordOpt",
            ProdKind::LabelsOptP1 => "LabelsOpt: Labels",
            ProdKind::LabelsOptP2 => "LabelsOpt: ",
            ProdKind::RecordOptP1 => "RecordOpt: Record",
            ProdKind::RecordOptP2 => "RecordOpt: ",
            ProdKind::LabelsP1 => "Labels: OPEN_CURLY identifier1 CLOSE_CURLY",
            ProdKind::identifier1P1 => "identifier1: identifier1 COMMA identifier",
            ProdKind::identifier1P2 => "identifier1: identifier",
            ProdKind::RecordP1 => {
                "Record: OPENSQUAREBRACKET Properties CLOSESQUAREBRACKET"
            }
            ProdKind::PropertiesP1 => "Properties: Property1",
            ProdKind::Property1P1 => "Property1: Property1 COMMA Property",
            ProdKind::Property1P2 => "Property1: Property",
            ProdKind::PropertyP1 => "Property: key COLON Values",
            ProdKind::keyP1 => "key: identifier",
            ProdKind::ValuesP1 => "Values: SingleValue",
            ProdKind::ValuesListValue => {
                "Values: OPENSQUAREBRACKET ListValues CLOSESQUAREBRACKET"
            }
            ProdKind::ListValuesP1 => "ListValues: SingleValue0",
            ProdKind::SingleValue1P1 => "SingleValue1: SingleValue1 COMMA SingleValue",
            ProdKind::SingleValue1P2 => "SingleValue1: SingleValue",
            ProdKind::SingleValue0P1 => "SingleValue0: SingleValue1",
            ProdKind::SingleValue0P2 => "SingleValue0: ",
            ProdKind::SingleValueStringValue => "SingleValue: QUOTED_STRING",
            ProdKind::SingleValueNumberValue => "SingleValue: NUMBER",
            ProdKind::SingleValueDateValue => "SingleValue: DATE QUOTED_STRING",
            ProdKind::SingleValueBooleanValue => "SingleValue: BOOL",
            ProdKind::BOOLP1 => "BOOL: TRUE",
            ProdKind::BOOLP2 => "BOOL: FALSE",
            ProdKind::identifierP1 => "identifier: IDENTIFIER",
            ProdKind::identifierP2 => "identifier: QUOTED_STRING",
            ProdKind::LayoutP1 => "Layout: LayoutItem0",
            ProdKind::LayoutItem1P1 => "LayoutItem1: LayoutItem1 LayoutItem",
            ProdKind::LayoutItem1P2 => "LayoutItem1: LayoutItem",
            ProdKind::LayoutItem0P1 => "LayoutItem0: LayoutItem1",
            ProdKind::LayoutItem0P2 => "LayoutItem0: ",
            ProdKind::LayoutItemP1 => "LayoutItem: WS",
            ProdKind::LayoutItemP2 => "LayoutItem: Comment",
            ProdKind::CommentP1 => "Comment: START_COMMENT Corncs END_COMMENT",
            ProdKind::CommentP2 => "Comment: CommentLine",
            ProdKind::CorncsP1 => "Corncs: Cornc0",
            ProdKind::Cornc1P1 => "Cornc1: Cornc1 Cornc",
            ProdKind::Cornc1P2 => "Cornc1: Cornc",
            ProdKind::Cornc0P1 => "Cornc0: Cornc1",
            ProdKind::Cornc0P2 => "Cornc0: ",
            ProdKind::CorncP1 => "Cornc: Comment",
            ProdKind::CorncP2 => "Cornc: NotComment",
            ProdKind::CorncP3 => "Cornc: WS",
        };
        write!(f, "{name}")
    }
}
#[allow(clippy::upper_case_acronyms)]
#[allow(dead_code)]
#[derive(Clone, Copy, Debug)]
pub enum NonTermKind {
    EMPTY,
    AUG,
    AUGL,
    Pg,
    Statements,
    Statement1,
    Statement,
    Node,
    Edge,
    EdgeIdOpt,
    NodeId,
    EdgeId,
    Id,
    LabelsRecord,
    LabelsOpt,
    RecordOpt,
    Labels,
    identifier1,
    Record,
    Properties,
    Property1,
    Property,
    key,
    Values,
    ListValues,
    SingleValue1,
    SingleValue0,
    SingleValue,
    BOOL,
    identifier,
    Layout,
    LayoutItem1,
    LayoutItem0,
    LayoutItem,
    Comment,
    Corncs,
    Cornc1,
    Cornc0,
    Cornc,
}
impl From<ProdKind> for NonTermKind {
    fn from(prod: ProdKind) -> Self {
        match prod {
            ProdKind::PgP1 => NonTermKind::Pg,
            ProdKind::StatementsP1 => NonTermKind::Statements,
            ProdKind::Statement1P1 => NonTermKind::Statement1,
            ProdKind::Statement1P2 => NonTermKind::Statement1,
            ProdKind::StatementP1 => NonTermKind::Statement,
            ProdKind::StatementP2 => NonTermKind::Statement,
            ProdKind::NodeP1 => NonTermKind::Node,
            ProdKind::EdgeP1 => NonTermKind::Edge,
            ProdKind::EdgeIdOptP1 => NonTermKind::EdgeIdOpt,
            ProdKind::EdgeIdOptP2 => NonTermKind::EdgeIdOpt,
            ProdKind::NodeIdP1 => NonTermKind::NodeId,
            ProdKind::EdgeIdP1 => NonTermKind::EdgeId,
            ProdKind::IdP1 => NonTermKind::Id,
            ProdKind::LabelsRecordP1 => NonTermKind::LabelsRecord,
            ProdKind::LabelsOptP1 => NonTermKind::LabelsOpt,
            ProdKind::LabelsOptP2 => NonTermKind::LabelsOpt,
            ProdKind::RecordOptP1 => NonTermKind::RecordOpt,
            ProdKind::RecordOptP2 => NonTermKind::RecordOpt,
            ProdKind::LabelsP1 => NonTermKind::Labels,
            ProdKind::identifier1P1 => NonTermKind::identifier1,
            ProdKind::identifier1P2 => NonTermKind::identifier1,
            ProdKind::RecordP1 => NonTermKind::Record,
            ProdKind::PropertiesP1 => NonTermKind::Properties,
            ProdKind::Property1P1 => NonTermKind::Property1,
            ProdKind::Property1P2 => NonTermKind::Property1,
            ProdKind::PropertyP1 => NonTermKind::Property,
            ProdKind::keyP1 => NonTermKind::key,
            ProdKind::ValuesP1 => NonTermKind::Values,
            ProdKind::ValuesListValue => NonTermKind::Values,
            ProdKind::ListValuesP1 => NonTermKind::ListValues,
            ProdKind::SingleValue1P1 => NonTermKind::SingleValue1,
            ProdKind::SingleValue1P2 => NonTermKind::SingleValue1,
            ProdKind::SingleValue0P1 => NonTermKind::SingleValue0,
            ProdKind::SingleValue0P2 => NonTermKind::SingleValue0,
            ProdKind::SingleValueStringValue => NonTermKind::SingleValue,
            ProdKind::SingleValueNumberValue => NonTermKind::SingleValue,
            ProdKind::SingleValueDateValue => NonTermKind::SingleValue,
            ProdKind::SingleValueBooleanValue => NonTermKind::SingleValue,
            ProdKind::BOOLP1 => NonTermKind::BOOL,
            ProdKind::BOOLP2 => NonTermKind::BOOL,
            ProdKind::identifierP1 => NonTermKind::identifier,
            ProdKind::identifierP2 => NonTermKind::identifier,
            ProdKind::LayoutP1 => NonTermKind::Layout,
            ProdKind::LayoutItem1P1 => NonTermKind::LayoutItem1,
            ProdKind::LayoutItem1P2 => NonTermKind::LayoutItem1,
            ProdKind::LayoutItem0P1 => NonTermKind::LayoutItem0,
            ProdKind::LayoutItem0P2 => NonTermKind::LayoutItem0,
            ProdKind::LayoutItemP1 => NonTermKind::LayoutItem,
            ProdKind::LayoutItemP2 => NonTermKind::LayoutItem,
            ProdKind::CommentP1 => NonTermKind::Comment,
            ProdKind::CommentP2 => NonTermKind::Comment,
            ProdKind::CorncsP1 => NonTermKind::Corncs,
            ProdKind::Cornc1P1 => NonTermKind::Cornc1,
            ProdKind::Cornc1P2 => NonTermKind::Cornc1,
            ProdKind::Cornc0P1 => NonTermKind::Cornc0,
            ProdKind::Cornc0P2 => NonTermKind::Cornc0,
            ProdKind::CorncP1 => NonTermKind::Cornc,
            ProdKind::CorncP2 => NonTermKind::Cornc,
            ProdKind::CorncP3 => NonTermKind::Cornc,
        }
    }
}
#[allow(clippy::enum_variant_names)]
#[derive(Default, Clone, Copy, PartialEq, Eq, PartialOrd, Ord)]
pub enum State {
    #[default]
    AUGS0,
    OPEN_PARENS1,
    PgS2,
    StatementsS3,
    Statement1S4,
    StatementS5,
    NodeS6,
    EdgeS7,
    IDENTIFIERS8,
    NodeIdS9,
    IdS10,
    StatementS11,
    CLOSE_PARENS12,
    OPEN_CURLYS13,
    LabelsRecordS14,
    LabelsOptS15,
    LabelsS16,
    START_ARROWS17,
    QUOTED_STRINGS18,
    IDENTIFIERS19,
    identifier1S20,
    identifierS21,
    CLOSE_PARENS22,
    OPENSQUAREBRACKETS23,
    RecordOptS24,
    RecordS25,
    OPEN_PARENS26,
    CLOSE_CURLYS27,
    COMMAS28,
    PropertiesS29,
    Property1S30,
    PropertyS31,
    keyS32,
    identifierS33,
    IDENTIFIERS34,
    EdgeIdOptS35,
    EdgeIdS36,
    IdS37,
    identifierS38,
    CLOSESQUAREBRACKETS39,
    COMMAS40,
    COLONS41,
    LabelsRecordS42,
    PropertyS43,
    QUOTED_STRINGS44,
    NUMBERS45,
    OPENSQUAREBRACKETS46,
    TRUES47,
    FALSES48,
    DATES49,
    ValuesS50,
    SingleValueS51,
    BOOLS52,
    CLOSE_PARENS53,
    ListValuesS54,
    SingleValue1S55,
    SingleValue0S56,
    SingleValueS57,
    QUOTED_STRINGS58,
    END_ARROWS59,
    CLOSESQUAREBRACKETS60,
    COMMAS61,
    OPEN_PARENS62,
    SingleValueS63,
    IDENTIFIERS64,
    CLOSE_PARENS65,
    AUGLS66,
    WSS67,
    CommentLineS68,
    START_COMMENTS69,
    LayoutS70,
    LayoutItem1S71,
    LayoutItem0S72,
    LayoutItemS73,
    CommentS74,
    WSS75,
    NotCommentS76,
    CommentS77,
    CorncsS78,
    Cornc1S79,
    Cornc0S80,
    CorncS81,
    LayoutItemS82,
    END_COMMENTS83,
    CorncS84,
}
impl StateT for State {
    fn default_layout() -> Option<Self> {
        Some(State::AUGLS66)
    }
}
impl From<State> for usize {
    fn from(s: State) -> Self {
        s as usize
    }
}
impl std::fmt::Debug for State {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let name = match self {
            State::AUGS0 => "0:AUG",
            State::OPEN_PARENS1 => "1:OPEN_PAREN",
            State::PgS2 => "2:Pg",
            State::StatementsS3 => "3:Statements",
            State::Statement1S4 => "4:Statement1",
            State::StatementS5 => "5:Statement",
            State::NodeS6 => "6:Node",
            State::EdgeS7 => "7:Edge",
            State::IDENTIFIERS8 => "8:IDENTIFIER",
            State::NodeIdS9 => "9:NodeId",
            State::IdS10 => "10:Id",
            State::StatementS11 => "11:Statement",
            State::CLOSE_PARENS12 => "12:CLOSE_PAREN",
            State::OPEN_CURLYS13 => "13:OPEN_CURLY",
            State::LabelsRecordS14 => "14:LabelsRecord",
            State::LabelsOptS15 => "15:LabelsOpt",
            State::LabelsS16 => "16:Labels",
            State::START_ARROWS17 => "17:START_ARROW",
            State::QUOTED_STRINGS18 => "18:QUOTED_STRING",
            State::IDENTIFIERS19 => "19:IDENTIFIER",
            State::identifier1S20 => "20:identifier1",
            State::identifierS21 => "21:identifier",
            State::CLOSE_PARENS22 => "22:CLOSE_PAREN",
            State::OPENSQUAREBRACKETS23 => "23:OPENSQUAREBRACKET",
            State::RecordOptS24 => "24:RecordOpt",
            State::RecordS25 => "25:Record",
            State::OPEN_PARENS26 => "26:OPEN_PAREN",
            State::CLOSE_CURLYS27 => "27:CLOSE_CURLY",
            State::COMMAS28 => "28:COMMA",
            State::PropertiesS29 => "29:Properties",
            State::Property1S30 => "30:Property1",
            State::PropertyS31 => "31:Property",
            State::keyS32 => "32:key",
            State::identifierS33 => "33:identifier",
            State::IDENTIFIERS34 => "34:IDENTIFIER",
            State::EdgeIdOptS35 => "35:EdgeIdOpt",
            State::EdgeIdS36 => "36:EdgeId",
            State::IdS37 => "37:Id",
            State::identifierS38 => "38:identifier",
            State::CLOSESQUAREBRACKETS39 => "39:CLOSESQUAREBRACKET",
            State::COMMAS40 => "40:COMMA",
            State::COLONS41 => "41:COLON",
            State::LabelsRecordS42 => "42:LabelsRecord",
            State::PropertyS43 => "43:Property",
            State::QUOTED_STRINGS44 => "44:QUOTED_STRING",
            State::NUMBERS45 => "45:NUMBER",
            State::OPENSQUAREBRACKETS46 => "46:OPENSQUAREBRACKET",
            State::TRUES47 => "47:TRUE",
            State::FALSES48 => "48:FALSE",
            State::DATES49 => "49:DATE",
            State::ValuesS50 => "50:Values",
            State::SingleValueS51 => "51:SingleValue",
            State::BOOLS52 => "52:BOOL",
            State::CLOSE_PARENS53 => "53:CLOSE_PAREN",
            State::ListValuesS54 => "54:ListValues",
            State::SingleValue1S55 => "55:SingleValue1",
            State::SingleValue0S56 => "56:SingleValue0",
            State::SingleValueS57 => "57:SingleValue",
            State::QUOTED_STRINGS58 => "58:QUOTED_STRING",
            State::END_ARROWS59 => "59:END_ARROW",
            State::CLOSESQUAREBRACKETS60 => "60:CLOSESQUAREBRACKET",
            State::COMMAS61 => "61:COMMA",
            State::OPEN_PARENS62 => "62:OPEN_PAREN",
            State::SingleValueS63 => "63:SingleValue",
            State::IDENTIFIERS64 => "64:IDENTIFIER",
            State::CLOSE_PARENS65 => "65:CLOSE_PAREN",
            State::AUGLS66 => "66:AUGL",
            State::WSS67 => "67:WS",
            State::CommentLineS68 => "68:CommentLine",
            State::START_COMMENTS69 => "69:START_COMMENT",
            State::LayoutS70 => "70:Layout",
            State::LayoutItem1S71 => "71:LayoutItem1",
            State::LayoutItem0S72 => "72:LayoutItem0",
            State::LayoutItemS73 => "73:LayoutItem",
            State::CommentS74 => "74:Comment",
            State::WSS75 => "75:WS",
            State::NotCommentS76 => "76:NotComment",
            State::CommentS77 => "77:Comment",
            State::CorncsS78 => "78:Corncs",
            State::Cornc1S79 => "79:Cornc1",
            State::Cornc0S80 => "80:Cornc0",
            State::CorncS81 => "81:Cornc",
            State::LayoutItemS82 => "82:LayoutItem",
            State::END_COMMENTS83 => "83:END_COMMENT",
            State::CorncS84 => "84:Cornc",
        };
        write!(f, "{name}")
    }
}
#[derive(Debug)]
pub enum Symbol {
    Terminal(Terminal),
    NonTerminal(NonTerminal),
}
#[allow(clippy::upper_case_acronyms)]
#[derive(Debug)]
pub enum Terminal {
    QUOTED_STRING(pg_actions::QUOTED_STRING),
    IDENTIFIER(pg_actions::IDENTIFIER),
    OPEN_PAREN,
    CLOSE_PAREN,
    OPEN_CURLY,
    CLOSE_CURLY,
    COLON,
    COMMA,
    NUMBER(pg_actions::NUMBER),
    OPENSQUAREBRACKET,
    CLOSESQUAREBRACKET,
    START_ARROW,
    END_ARROW,
    TRUE,
    FALSE,
    DATE,
}
#[derive(Debug)]
pub enum NonTerminal {
    Pg(pg_actions::Pg),
    Statements(pg_actions::Statements),
    Statement1(pg_actions::Statement1),
    Statement(pg_actions::Statement),
    Node(pg_actions::Node),
    Edge(pg_actions::Edge),
    EdgeIdOpt(pg_actions::EdgeIdOpt),
    NodeId(pg_actions::NodeId),
    EdgeId(pg_actions::EdgeId),
    Id(pg_actions::Id),
    LabelsRecord(pg_actions::LabelsRecord),
    LabelsOpt(pg_actions::LabelsOpt),
    RecordOpt(pg_actions::RecordOpt),
    Labels(pg_actions::Labels),
    identifier1(pg_actions::identifier1),
    Record(pg_actions::Record),
    Properties(pg_actions::Properties),
    Property1(pg_actions::Property1),
    Property(pg_actions::Property),
    key(pg_actions::key),
    Values(pg_actions::Values),
    ListValues(pg_actions::ListValues),
    SingleValue1(pg_actions::SingleValue1),
    SingleValue0(pg_actions::SingleValue0),
    SingleValue(pg_actions::SingleValue),
    BOOL(pg_actions::BOOL),
    identifier(pg_actions::identifier),
}
type ActionFn = fn(token: TokenKind) -> Vec<Action<State, ProdKind>>;
pub struct PgParserDefinition {
    actions: [ActionFn; STATE_COUNT],
    gotos: [fn(nonterm: NonTermKind) -> State; STATE_COUNT],
    token_kinds: [[Option<(TokenKind, bool)>; MAX_RECOGNIZERS]; STATE_COUNT],
}
fn action_aug_s0(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::OPEN_PAREN => Vec::from(&[Shift(State::OPEN_PARENS1)]),
        _ => vec![],
    }
}
fn action_open_paren_s1(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS8)]),
        _ => vec![],
    }
}
fn action_pg_s2(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Accept]),
        _ => vec![],
    }
}
fn action_statements_s3(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::PgP1, 1usize)]),
        _ => vec![],
    }
}
fn action_statement1_s4(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::StatementsP1, 1usize)]),
        TK::OPEN_PAREN => Vec::from(&[Shift(State::OPEN_PARENS1)]),
        _ => vec![],
    }
}
fn action_statement_s5(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::Statement1P2, 1usize)]),
        TK::OPEN_PAREN => Vec::from(&[Reduce(PK::Statement1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_node_s6(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::StatementP2, 1usize)]),
        TK::OPEN_PAREN => Vec::from(&[Reduce(PK::StatementP2, 1usize)]),
        _ => vec![],
    }
}
fn action_edge_s7(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::StatementP1, 1usize)]),
        TK::OPEN_PAREN => Vec::from(&[Reduce(PK::StatementP1, 1usize)]),
        _ => vec![],
    }
}
fn action_identifier_s8(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Shift(State::CLOSE_PARENS12)]),
        TK::OPEN_CURLY => Vec::from(&[Reduce(PK::IdP1, 1usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::IdP1, 1usize)]),
        _ => vec![],
    }
}
fn action_nodeid_s9(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::LabelsOptP2, 0usize)]),
        TK::OPEN_CURLY => Vec::from(&[Shift(State::OPEN_CURLYS13)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::LabelsOptP2, 0usize)]),
        _ => vec![],
    }
}
fn action_id_s10(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::NodeIdP1, 1usize)]),
        TK::OPEN_CURLY => Vec::from(&[Reduce(PK::NodeIdP1, 1usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::NodeIdP1, 1usize)]),
        _ => vec![],
    }
}
fn action_statement_s11(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::Statement1P1, 2usize)]),
        TK::OPEN_PAREN => Vec::from(&[Reduce(PK::Statement1P1, 2usize)]),
        _ => vec![],
    }
}
fn action_close_paren_s12(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::START_ARROW => Vec::from(&[Shift(State::START_ARROWS17)]),
        _ => vec![],
    }
}
fn action_open_curly_s13(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS18)]),
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS19)]),
        _ => vec![],
    }
}
fn action_labelsrecord_s14(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Shift(State::CLOSE_PARENS22)]),
        _ => vec![],
    }
}
fn action_labelsopt_s15(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::RecordOptP2, 0usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Shift(State::OPENSQUAREBRACKETS23)]),
        _ => vec![],
    }
}
fn action_labels_s16(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::LabelsOptP1, 1usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::LabelsOptP1, 1usize)]),
        _ => vec![],
    }
}
fn action_start_arrow_s17(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::OPEN_PAREN => Vec::from(&[Shift(State::OPEN_PARENS26)]),
        _ => vec![],
    }
}
fn action_quoted_string_s18(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_CURLY => Vec::from(&[Reduce(PK::identifierP2, 1usize)]),
        TK::COLON => Vec::from(&[Reduce(PK::identifierP2, 1usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::identifierP2, 1usize)]),
        _ => vec![],
    }
}
fn action_identifier_s19(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_CURLY => Vec::from(&[Reduce(PK::identifierP1, 1usize)]),
        TK::COLON => Vec::from(&[Reduce(PK::identifierP1, 1usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::identifierP1, 1usize)]),
        _ => vec![],
    }
}
fn action_identifier1_s20(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_CURLY => Vec::from(&[Shift(State::CLOSE_CURLYS27)]),
        TK::COMMA => Vec::from(&[Shift(State::COMMAS28)]),
        _ => vec![],
    }
}
fn action_identifier_s21(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_CURLY => Vec::from(&[Reduce(PK::identifier1P2, 1usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::identifier1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_close_paren_s22(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::NodeP1, 4usize)]),
        TK::OPEN_PAREN => Vec::from(&[Reduce(PK::NodeP1, 4usize)]),
        _ => vec![],
    }
}
fn action_opensquarebracket_s23(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS18)]),
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS19)]),
        _ => vec![],
    }
}
fn action_recordopt_s24(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::LabelsRecordP1, 2usize)]),
        _ => vec![],
    }
}
fn action_record_s25(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::RecordOptP1, 1usize)]),
        _ => vec![],
    }
}
fn action_open_paren_s26(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS34)]),
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::EdgeIdOptP2, 0usize)]),
        TK::OPEN_CURLY => Vec::from(&[Reduce(PK::EdgeIdOptP2, 0usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::EdgeIdOptP2, 0usize)]),
        _ => vec![],
    }
}
fn action_close_curly_s27(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::LabelsP1, 3usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::LabelsP1, 3usize)]),
        _ => vec![],
    }
}
fn action_comma_s28(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS18)]),
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS19)]),
        _ => vec![],
    }
}
fn action_properties_s29(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSESQUAREBRACKET => Vec::from(&[Shift(State::CLOSESQUAREBRACKETS39)]),
        _ => vec![],
    }
}
fn action_property1_s30(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Shift(State::COMMAS40)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::PropertiesP1, 1usize)]),
        _ => vec![],
    }
}
fn action_property_s31(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::Property1P2, 1usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::Property1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_key_s32(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COLON => Vec::from(&[Shift(State::COLONS41)]),
        _ => vec![],
    }
}
fn action_identifier_s33(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COLON => Vec::from(&[Reduce(PK::keyP1, 1usize)]),
        _ => vec![],
    }
}
fn action_identifier_s34(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::IdP1, 1usize)]),
        TK::OPEN_CURLY => Vec::from(&[Reduce(PK::IdP1, 1usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::IdP1, 1usize)]),
        _ => vec![],
    }
}
fn action_edgeidopt_s35(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::LabelsOptP2, 0usize)]),
        TK::OPEN_CURLY => Vec::from(&[Shift(State::OPEN_CURLYS13)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::LabelsOptP2, 0usize)]),
        _ => vec![],
    }
}
fn action_edgeid_s36(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::EdgeIdOptP1, 1usize)]),
        TK::OPEN_CURLY => Vec::from(&[Reduce(PK::EdgeIdOptP1, 1usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::EdgeIdOptP1, 1usize)]),
        _ => vec![],
    }
}
fn action_id_s37(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::EdgeIdP1, 1usize)]),
        TK::OPEN_CURLY => Vec::from(&[Reduce(PK::EdgeIdP1, 1usize)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Reduce(PK::EdgeIdP1, 1usize)]),
        _ => vec![],
    }
}
fn action_identifier_s38(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_CURLY => Vec::from(&[Reduce(PK::identifier1P1, 3usize)]),
        TK::COMMA => Vec::from(&[Reduce(PK::identifier1P1, 3usize)]),
        _ => vec![],
    }
}
fn action_closesquarebracket_s39(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Reduce(PK::RecordP1, 3usize)]),
        _ => vec![],
    }
}
fn action_comma_s40(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS18)]),
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS19)]),
        _ => vec![],
    }
}
fn action_colon_s41(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS44)]),
        TK::NUMBER => Vec::from(&[Shift(State::NUMBERS45)]),
        TK::OPENSQUAREBRACKET => Vec::from(&[Shift(State::OPENSQUAREBRACKETS46)]),
        TK::TRUE => Vec::from(&[Shift(State::TRUES47)]),
        TK::FALSE => Vec::from(&[Shift(State::FALSES48)]),
        TK::DATE => Vec::from(&[Shift(State::DATES49)]),
        _ => vec![],
    }
}
fn action_labelsrecord_s42(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Shift(State::CLOSE_PARENS53)]),
        _ => vec![],
    }
}
fn action_property_s43(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::Property1P1, 3usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::Property1P1, 3usize)]),
        _ => vec![],
    }
}
fn action_quoted_string_s44(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::SingleValueStringValue, 1usize)]),
        TK::CLOSESQUAREBRACKET => {
            Vec::from(&[Reduce(PK::SingleValueStringValue, 1usize)])
        }
        _ => vec![],
    }
}
fn action_number_s45(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::SingleValueNumberValue, 1usize)]),
        TK::CLOSESQUAREBRACKET => {
            Vec::from(&[Reduce(PK::SingleValueNumberValue, 1usize)])
        }
        _ => vec![],
    }
}
fn action_opensquarebracket_s46(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS44)]),
        TK::NUMBER => Vec::from(&[Shift(State::NUMBERS45)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::SingleValue0P2, 0usize)]),
        TK::TRUE => Vec::from(&[Shift(State::TRUES47)]),
        TK::FALSE => Vec::from(&[Shift(State::FALSES48)]),
        TK::DATE => Vec::from(&[Shift(State::DATES49)]),
        _ => vec![],
    }
}
fn action_true_s47(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::BOOLP1, 1usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::BOOLP1, 1usize)]),
        _ => vec![],
    }
}
fn action_false_s48(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::BOOLP2, 1usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::BOOLP2, 1usize)]),
        _ => vec![],
    }
}
fn action_date_s49(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS58)]),
        _ => vec![],
    }
}
fn action_values_s50(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::PropertyP1, 3usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::PropertyP1, 3usize)]),
        _ => vec![],
    }
}
fn action_singlevalue_s51(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::ValuesP1, 1usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::ValuesP1, 1usize)]),
        _ => vec![],
    }
}
fn action_bool_s52(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::SingleValueBooleanValue, 1usize)]),
        TK::CLOSESQUAREBRACKET => {
            Vec::from(&[Reduce(PK::SingleValueBooleanValue, 1usize)])
        }
        _ => vec![],
    }
}
fn action_close_paren_s53(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::END_ARROW => Vec::from(&[Shift(State::END_ARROWS59)]),
        _ => vec![],
    }
}
fn action_listvalues_s54(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSESQUAREBRACKET => Vec::from(&[Shift(State::CLOSESQUAREBRACKETS60)]),
        _ => vec![],
    }
}
fn action_singlevalue1_s55(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Shift(State::COMMAS61)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::SingleValue0P1, 1usize)]),
        _ => vec![],
    }
}
fn action_singlevalue0_s56(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::ListValuesP1, 1usize)]),
        _ => vec![],
    }
}
fn action_singlevalue_s57(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::SingleValue1P2, 1usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::SingleValue1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_quoted_string_s58(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::SingleValueDateValue, 2usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::SingleValueDateValue, 2usize)]),
        _ => vec![],
    }
}
fn action_end_arrow_s59(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::OPEN_PAREN => Vec::from(&[Shift(State::OPEN_PARENS62)]),
        _ => vec![],
    }
}
fn action_closesquarebracket_s60(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::ValuesListValue, 3usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::ValuesListValue, 3usize)]),
        _ => vec![],
    }
}
fn action_comma_s61(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::QUOTED_STRING => Vec::from(&[Shift(State::QUOTED_STRINGS44)]),
        TK::NUMBER => Vec::from(&[Shift(State::NUMBERS45)]),
        TK::TRUE => Vec::from(&[Shift(State::TRUES47)]),
        TK::FALSE => Vec::from(&[Shift(State::FALSES48)]),
        TK::DATE => Vec::from(&[Shift(State::DATES49)]),
        _ => vec![],
    }
}
fn action_open_paren_s62(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::IDENTIFIER => Vec::from(&[Shift(State::IDENTIFIERS64)]),
        _ => vec![],
    }
}
fn action_singlevalue_s63(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::COMMA => Vec::from(&[Reduce(PK::SingleValue1P1, 3usize)]),
        TK::CLOSESQUAREBRACKET => Vec::from(&[Reduce(PK::SingleValue1P1, 3usize)]),
        _ => vec![],
    }
}
fn action_identifier_s64(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::CLOSE_PAREN => Vec::from(&[Shift(State::CLOSE_PARENS65)]),
        _ => vec![],
    }
}
fn action_close_paren_s65(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::EdgeP1, 12usize)]),
        TK::OPEN_PAREN => Vec::from(&[Reduce(PK::EdgeP1, 12usize)]),
        _ => vec![],
    }
}
fn action_augl_s66(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem0P2, 0usize)]),
        TK::WS => Vec::from(&[Shift(State::WSS67)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS68)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS69)]),
        _ => vec![],
    }
}
fn action_ws_s67(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItemP1, 1usize)]),
        _ => vec![],
    }
}
fn action_commentline_s68(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CommentP2, 1usize)]),
        _ => vec![],
    }
}
fn action_start_comment_s69(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Shift(State::WSS75)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS68)]),
        TK::NotComment => Vec::from(&[Shift(State::NotCommentS76)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS69)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc0P2, 0usize)]),
        _ => vec![],
    }
}
fn action_layout_s70(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Accept]),
        _ => vec![],
    }
}
fn action_layoutitem1_s71(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem0P1, 1usize)]),
        TK::WS => Vec::from(&[Shift(State::WSS67)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS68)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS69)]),
        _ => vec![],
    }
}
fn action_layoutitem0_s72(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutP1, 1usize)]),
        _ => vec![],
    }
}
fn action_layoutitem_s73(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItem1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_comment_s74(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItemP2, 1usize)]),
        _ => vec![],
    }
}
fn action_ws_s75(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncP3, 1usize)]),
        _ => vec![],
    }
}
fn action_notcomment_s76(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncP2, 1usize)]),
        _ => vec![],
    }
}
fn action_comment_s77(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncP1, 1usize)]),
        _ => vec![],
    }
}
fn action_corncs_s78(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::END_COMMENT => Vec::from(&[Shift(State::END_COMMENTS83)]),
        _ => vec![],
    }
}
fn action_cornc1_s79(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Shift(State::WSS75)]),
        TK::CommentLine => Vec::from(&[Shift(State::CommentLineS68)]),
        TK::NotComment => Vec::from(&[Shift(State::NotCommentS76)]),
        TK::START_COMMENT => Vec::from(&[Shift(State::START_COMMENTS69)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc0P1, 1usize)]),
        _ => vec![],
    }
}
fn action_cornc0_s80(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CorncsP1, 1usize)]),
        _ => vec![],
    }
}
fn action_cornc_s81(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc1P2, 1usize)]),
        _ => vec![],
    }
}
fn action_layoutitem_s82(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        TK::WS => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::LayoutItem1P1, 2usize)]),
        _ => vec![],
    }
}
fn action_end_comment_s83(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::STOP => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::WS => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::CommentP1, 3usize)]),
        _ => vec![],
    }
}
fn action_cornc_s84(token_kind: TokenKind) -> Vec<Action<State, ProdKind>> {
    match token_kind {
        TK::WS => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::CommentLine => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::NotComment => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::START_COMMENT => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        TK::END_COMMENT => Vec::from(&[Reduce(PK::Cornc1P1, 2usize)]),
        _ => vec![],
    }
}
fn goto_aug_s0(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Pg => State::PgS2,
        NonTermKind::Statements => State::StatementsS3,
        NonTermKind::Statement1 => State::Statement1S4,
        NonTermKind::Statement => State::StatementS5,
        NonTermKind::Node => State::NodeS6,
        NonTermKind::Edge => State::EdgeS7,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::AUGS0
            )
        }
    }
}
fn goto_open_paren_s1(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::NodeId => State::NodeIdS9,
        NonTermKind::Id => State::IdS10,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::OPEN_PARENS1
            )
        }
    }
}
fn goto_statement1_s4(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Statement => State::StatementS11,
        NonTermKind::Node => State::NodeS6,
        NonTermKind::Edge => State::EdgeS7,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::Statement1S4
            )
        }
    }
}
fn goto_nodeid_s9(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::LabelsRecord => State::LabelsRecordS14,
        NonTermKind::LabelsOpt => State::LabelsOptS15,
        NonTermKind::Labels => State::LabelsS16,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::NodeIdS9
            )
        }
    }
}
fn goto_open_curly_s13(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::identifier1 => State::identifier1S20,
        NonTermKind::identifier => State::identifierS21,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::OPEN_CURLYS13
            )
        }
    }
}
fn goto_labelsopt_s15(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::RecordOpt => State::RecordOptS24,
        NonTermKind::Record => State::RecordS25,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::LabelsOptS15
            )
        }
    }
}
fn goto_opensquarebracket_s23(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Properties => State::PropertiesS29,
        NonTermKind::Property1 => State::Property1S30,
        NonTermKind::Property => State::PropertyS31,
        NonTermKind::key => State::keyS32,
        NonTermKind::identifier => State::identifierS33,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::OPENSQUAREBRACKETS23
            )
        }
    }
}
fn goto_open_paren_s26(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::EdgeIdOpt => State::EdgeIdOptS35,
        NonTermKind::EdgeId => State::EdgeIdS36,
        NonTermKind::Id => State::IdS37,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::OPEN_PARENS26
            )
        }
    }
}
fn goto_comma_s28(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::identifier => State::identifierS38,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::COMMAS28
            )
        }
    }
}
fn goto_edgeidopt_s35(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::LabelsRecord => State::LabelsRecordS42,
        NonTermKind::LabelsOpt => State::LabelsOptS15,
        NonTermKind::Labels => State::LabelsS16,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::EdgeIdOptS35
            )
        }
    }
}
fn goto_comma_s40(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Property => State::PropertyS43,
        NonTermKind::key => State::keyS32,
        NonTermKind::identifier => State::identifierS33,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::COMMAS40
            )
        }
    }
}
fn goto_colon_s41(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Values => State::ValuesS50,
        NonTermKind::SingleValue => State::SingleValueS51,
        NonTermKind::BOOL => State::BOOLS52,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::COLONS41
            )
        }
    }
}
fn goto_opensquarebracket_s46(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::ListValues => State::ListValuesS54,
        NonTermKind::SingleValue1 => State::SingleValue1S55,
        NonTermKind::SingleValue0 => State::SingleValue0S56,
        NonTermKind::SingleValue => State::SingleValueS57,
        NonTermKind::BOOL => State::BOOLS52,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::OPENSQUAREBRACKETS46
            )
        }
    }
}
fn goto_comma_s61(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::SingleValue => State::SingleValueS63,
        NonTermKind::BOOL => State::BOOLS52,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::COMMAS61
            )
        }
    }
}
fn goto_augl_s66(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Layout => State::LayoutS70,
        NonTermKind::LayoutItem1 => State::LayoutItem1S71,
        NonTermKind::LayoutItem0 => State::LayoutItem0S72,
        NonTermKind::LayoutItem => State::LayoutItemS73,
        NonTermKind::Comment => State::CommentS74,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::AUGLS66
            )
        }
    }
}
fn goto_start_comment_s69(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Comment => State::CommentS77,
        NonTermKind::Corncs => State::CorncsS78,
        NonTermKind::Cornc1 => State::Cornc1S79,
        NonTermKind::Cornc0 => State::Cornc0S80,
        NonTermKind::Cornc => State::CorncS81,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::START_COMMENTS69
            )
        }
    }
}
fn goto_layoutitem1_s71(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::LayoutItem => State::LayoutItemS82,
        NonTermKind::Comment => State::CommentS74,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::LayoutItem1S71
            )
        }
    }
}
fn goto_cornc1_s79(nonterm_kind: NonTermKind) -> State {
    match nonterm_kind {
        NonTermKind::Comment => State::CommentS77,
        NonTermKind::Cornc => State::CorncS84,
        _ => {
            panic!(
                "Invalid terminal kind ({nonterm_kind:?}) for GOTO state ({:?}).",
                State::Cornc1S79
            )
        }
    }
}
fn goto_invalid(_nonterm_kind: NonTermKind) -> State {
    panic!("Invalid GOTO entry!");
}
pub(crate) static PARSER_DEFINITION: PgParserDefinition = PgParserDefinition {
    actions: [
        action_aug_s0,
        action_open_paren_s1,
        action_pg_s2,
        action_statements_s3,
        action_statement1_s4,
        action_statement_s5,
        action_node_s6,
        action_edge_s7,
        action_identifier_s8,
        action_nodeid_s9,
        action_id_s10,
        action_statement_s11,
        action_close_paren_s12,
        action_open_curly_s13,
        action_labelsrecord_s14,
        action_labelsopt_s15,
        action_labels_s16,
        action_start_arrow_s17,
        action_quoted_string_s18,
        action_identifier_s19,
        action_identifier1_s20,
        action_identifier_s21,
        action_close_paren_s22,
        action_opensquarebracket_s23,
        action_recordopt_s24,
        action_record_s25,
        action_open_paren_s26,
        action_close_curly_s27,
        action_comma_s28,
        action_properties_s29,
        action_property1_s30,
        action_property_s31,
        action_key_s32,
        action_identifier_s33,
        action_identifier_s34,
        action_edgeidopt_s35,
        action_edgeid_s36,
        action_id_s37,
        action_identifier_s38,
        action_closesquarebracket_s39,
        action_comma_s40,
        action_colon_s41,
        action_labelsrecord_s42,
        action_property_s43,
        action_quoted_string_s44,
        action_number_s45,
        action_opensquarebracket_s46,
        action_true_s47,
        action_false_s48,
        action_date_s49,
        action_values_s50,
        action_singlevalue_s51,
        action_bool_s52,
        action_close_paren_s53,
        action_listvalues_s54,
        action_singlevalue1_s55,
        action_singlevalue0_s56,
        action_singlevalue_s57,
        action_quoted_string_s58,
        action_end_arrow_s59,
        action_closesquarebracket_s60,
        action_comma_s61,
        action_open_paren_s62,
        action_singlevalue_s63,
        action_identifier_s64,
        action_close_paren_s65,
        action_augl_s66,
        action_ws_s67,
        action_commentline_s68,
        action_start_comment_s69,
        action_layout_s70,
        action_layoutitem1_s71,
        action_layoutitem0_s72,
        action_layoutitem_s73,
        action_comment_s74,
        action_ws_s75,
        action_notcomment_s76,
        action_comment_s77,
        action_corncs_s78,
        action_cornc1_s79,
        action_cornc0_s80,
        action_cornc_s81,
        action_layoutitem_s82,
        action_end_comment_s83,
        action_cornc_s84,
    ],
    gotos: [
        goto_aug_s0,
        goto_open_paren_s1,
        goto_invalid,
        goto_invalid,
        goto_statement1_s4,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_nodeid_s9,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_open_curly_s13,
        goto_invalid,
        goto_labelsopt_s15,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_opensquarebracket_s23,
        goto_invalid,
        goto_invalid,
        goto_open_paren_s26,
        goto_invalid,
        goto_comma_s28,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_edgeidopt_s35,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_comma_s40,
        goto_colon_s41,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_opensquarebracket_s46,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_comma_s61,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_augl_s66,
        goto_invalid,
        goto_invalid,
        goto_start_comment_s69,
        goto_invalid,
        goto_layoutitem1_s71,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_cornc1_s79,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
        goto_invalid,
    ],
    token_kinds: [
        [Some((TK::OPEN_PAREN, true)), None, None, None, None, None],
        [Some((TK::IDENTIFIER, false)), None, None, None, None, None],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [Some((TK::START_ARROW, true)), None, None, None, None, None],
        [
            Some((TK::QUOTED_STRING, false)),
            Some((TK::IDENTIFIER, false)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::CLOSE_PAREN, true)), None, None, None, None, None],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::OPEN_PAREN, true)), None, None, None, None, None],
        [
            Some((TK::CLOSE_CURLY, true)),
            Some((TK::COLON, true)),
            Some((TK::COMMA, true)),
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_CURLY, true)),
            Some((TK::COLON, true)),
            Some((TK::COMMA, true)),
            None,
            None,
            None,
        ],
        [Some((TK::CLOSE_CURLY, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::CLOSE_CURLY, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [
            Some((TK::QUOTED_STRING, false)),
            Some((TK::IDENTIFIER, false)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::CLOSE_PAREN, true)), None, None, None, None, None],
        [Some((TK::CLOSE_PAREN, true)), None, None, None, None, None],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            Some((TK::IDENTIFIER, false)),
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::QUOTED_STRING, false)),
            Some((TK::IDENTIFIER, false)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::CLOSESQUAREBRACKET, true)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::COLON, true)), None, None, None, None, None],
        [Some((TK::COLON, true)), None, None, None, None, None],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [
            Some((TK::CLOSE_PAREN, true)),
            Some((TK::OPEN_CURLY, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            None,
            None,
            None,
        ],
        [Some((TK::CLOSE_CURLY, true)), Some((TK::COMMA, true)), None, None, None, None],
        [Some((TK::CLOSE_PAREN, true)), None, None, None, None, None],
        [
            Some((TK::QUOTED_STRING, false)),
            Some((TK::IDENTIFIER, false)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::FALSE, true)),
            Some((TK::TRUE, true)),
            Some((TK::DATE, true)),
            Some((TK::OPENSQUAREBRACKET, true)),
            Some((TK::QUOTED_STRING, false)),
            Some((TK::NUMBER, false)),
        ],
        [Some((TK::CLOSE_PAREN, true)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::FALSE, true)),
            Some((TK::TRUE, true)),
            Some((TK::DATE, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            Some((TK::QUOTED_STRING, false)),
            Some((TK::NUMBER, false)),
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::QUOTED_STRING, false)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::END_ARROW, true)), None, None, None, None, None],
        [Some((TK::CLOSESQUAREBRACKET, true)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::CLOSESQUAREBRACKET, true)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::OPEN_PAREN, true)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [
            Some((TK::FALSE, true)),
            Some((TK::TRUE, true)),
            Some((TK::DATE, true)),
            Some((TK::QUOTED_STRING, false)),
            Some((TK::NUMBER, false)),
            None,
        ],
        [Some((TK::IDENTIFIER, false)), None, None, None, None, None],
        [
            Some((TK::COMMA, true)),
            Some((TK::CLOSESQUAREBRACKET, true)),
            None,
            None,
            None,
            None,
        ],
        [Some((TK::CLOSE_PAREN, true)), None, None, None, None, None],
        [Some((TK::STOP, true)), Some((TK::OPEN_PAREN, true)), None, None, None, None],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [Some((TK::STOP, false)), None, None, None, None, None],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [Some((TK::END_COMMENT, true)), None, None, None, None, None],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [Some((TK::END_COMMENT, true)), None, None, None, None, None],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            None,
            None,
        ],
        [
            Some((TK::STOP, true)),
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
        ],
        [
            Some((TK::START_COMMENT, true)),
            Some((TK::END_COMMENT, true)),
            Some((TK::WS, false)),
            Some((TK::CommentLine, false)),
            Some((TK::NotComment, false)),
            None,
        ],
    ],
};
impl ParserDefinition<State, ProdKind, TokenKind, NonTermKind> for PgParserDefinition {
    fn actions(&self, state: State, token: TokenKind) -> Vec<Action<State, ProdKind>> {
        PARSER_DEFINITION.actions[state as usize](token)
    }
    fn goto(&self, state: State, nonterm: NonTermKind) -> State {
        PARSER_DEFINITION.gotos[state as usize](nonterm)
    }
    fn expected_token_kinds(&self, state: State) -> Vec<(TokenKind, bool)> {
        PARSER_DEFINITION.token_kinds[state as usize].iter().map_while(|t| *t).collect()
    }
    fn longest_match() -> bool {
        true
    }
    fn grammar_order() -> bool {
        true
    }
}
pub(crate) type Context<'i, I> = LRContext<'i, I, State, TokenKind>;
pub struct PgParser<
    'i,
    I: InputT + ?Sized,
    L: Lexer<'i, Context<'i, I>, State, TokenKind, Input = I>,
    B,
>(
    LRParser<
        'i,
        Context<'i, I>,
        State,
        ProdKind,
        TokenKind,
        NonTermKind,
        PgParserDefinition,
        L,
        B,
        I,
    >,
);
#[allow(dead_code)]
impl<
    'i,
> PgParser<
    'i,
    Input,
    StringLexer<Context<'i, Input>, State, TokenKind, TokenRecognizer, TERMINAL_COUNT>,
    DefaultBuilder,
> {
    pub fn new() -> Self {
        Self(
            LRParser::new(
                &PARSER_DEFINITION,
                State::default(),
                false,
                true,
                StringLexer::new(false, &RECOGNIZERS),
                DefaultBuilder::new(),
            ),
        )
    }
}
#[allow(dead_code)]
impl<'i, I, L, B> Parser<'i, I, Context<'i, I>, State, TokenKind>
for PgParser<'i, I, L, B>
where
    I: InputT + ?Sized + Debug,
    L: Lexer<'i, Context<'i, I>, State, TokenKind, Input = I>,
    B: LRBuilder<'i, I, Context<'i, I>, State, ProdKind, TokenKind>,
{
    type Output = B::Output;
    fn parse(&self, input: &'i I) -> Result<Self::Output> {
        self.0.parse(input)
    }
    fn parse_with_context(
        &self,
        context: &mut Context<'i, I>,
        input: &'i I,
    ) -> Result<Self::Output> {
        self.0.parse_with_context(context, input)
    }
    fn parse_file<'a, F: AsRef<std::path::Path>>(
        &'a mut self,
        file: F,
    ) -> Result<Self::Output>
    where
        'a: 'i,
    {
        self.0.parse_file(file)
    }
}
#[allow(dead_code)]
#[derive(Debug)]
pub enum Recognizer {
    Stop,
    StrMatch(&'static str),
    RegexMatch(Lazy<Regex>),
}
#[allow(dead_code)]
#[derive(Debug)]
pub struct TokenRecognizer(TokenKind, Recognizer);
impl<'i> TokenRecognizerT<'i> for TokenRecognizer {
    fn recognize(&self, input: &'i str) -> Option<&'i str> {
        match &self {
            #[allow(unused_variables)]
            TokenRecognizer(token_kind, Recognizer::StrMatch(s)) => {
                logn!("{} {:?} -- ", "    Recognizing".green(), token_kind);
                if input.starts_with(s) {
                    log!("{}", "recognized".bold().green());
                    Some(s)
                } else {
                    log!("{}", "not recognized".red());
                    None
                }
            }
            #[allow(unused_variables)]
            TokenRecognizer(token_kind, Recognizer::RegexMatch(r)) => {
                logn!("{} {:?} -- ", "    Recognizing".green(), token_kind);
                let match_str = r.find(input);
                match match_str {
                    Some(x) => {
                        let x_str = x.as_str();
                        log!("{} '{}'", "recognized".bold().green(), x_str);
                        Some(x_str)
                    }
                    _ => {
                        log!("{}", "not recognized".red());
                        None
                    }
                }
            }
            TokenRecognizer(_, Recognizer::Stop) => {
                logn!("{} STOP -- ", "    Recognizing".green());
                if input.is_empty() {
                    log!("{}", "recognized".bold().green());
                    Some("")
                } else {
                    log!("{}", "not recognized".red());
                    None
                }
            }
        }
    }
}
pub(crate) static RECOGNIZERS: [TokenRecognizer; TERMINAL_COUNT] = [
    TokenRecognizer(TokenKind::STOP, Recognizer::Stop),
    TokenRecognizer(
        TokenKind::WS,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "\\s+")).unwrap() }),
        ),
    ),
    TokenRecognizer(
        TokenKind::CommentLine,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "#.*")).unwrap() }),
        ),
    ),
    TokenRecognizer(
        TokenKind::NotComment,
        Recognizer::RegexMatch(
            Lazy::new(|| {
                Regex::new(concat!("^", "((\\*[^/])|[^\\s*/]|/[^\\*])+")).unwrap()
            }),
        ),
    ),
    TokenRecognizer(TokenKind::START_COMMENT, Recognizer::StrMatch("/*")),
    TokenRecognizer(TokenKind::END_COMMENT, Recognizer::StrMatch("*/")),
    TokenRecognizer(
        TokenKind::QUOTED_STRING,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "\"((\\\\\")|[^\"])*\"")).unwrap() }),
        ),
    ),
    TokenRecognizer(
        TokenKind::IDENTIFIER,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "\\w+")).unwrap() }),
        ),
    ),
    TokenRecognizer(TokenKind::SEMICOLON, Recognizer::StrMatch(";")),
    TokenRecognizer(TokenKind::CREATE, Recognizer::StrMatch("CREATE")),
    TokenRecognizer(TokenKind::NODE, Recognizer::StrMatch("NODE")),
    TokenRecognizer(TokenKind::EDGE, Recognizer::StrMatch("EDGE")),
    TokenRecognizer(TokenKind::GRAPH, Recognizer::StrMatch("GRAPH")),
    TokenRecognizer(TokenKind::TYPE, Recognizer::StrMatch("TYPE")),
    TokenRecognizer(TokenKind::OPEN_PAREN, Recognizer::StrMatch("(")),
    TokenRecognizer(TokenKind::CLOSE_PAREN, Recognizer::StrMatch(")")),
    TokenRecognizer(TokenKind::OPEN_ARROW, Recognizer::StrMatch("-[")),
    TokenRecognizer(TokenKind::CLOSE_ARROW, Recognizer::StrMatch("]->")),
    TokenRecognizer(TokenKind::OPEN_CURLY, Recognizer::StrMatch("{")),
    TokenRecognizer(TokenKind::CLOSE_CURLY, Recognizer::StrMatch("}")),
    TokenRecognizer(TokenKind::COLON, Recognizer::StrMatch(":")),
    TokenRecognizer(TokenKind::COMMA, Recognizer::StrMatch(",")),
    TokenRecognizer(TokenKind::BAR, Recognizer::StrMatch("|")),
    TokenRecognizer(TokenKind::PLUS, Recognizer::StrMatch("+")),
    TokenRecognizer(TokenKind::STAR, Recognizer::StrMatch("*")),
    TokenRecognizer(TokenKind::QUESTION, Recognizer::StrMatch("?")),
    TokenRecognizer(TokenKind::INTEGER_NAME, Recognizer::StrMatch("INTEGER")),
    TokenRecognizer(TokenKind::STRING_NAME, Recognizer::StrMatch("STRING")),
    TokenRecognizer(TokenKind::DATE_NAME, Recognizer::StrMatch("DATE")),
    TokenRecognizer(
        TokenKind::NUMBER,
        Recognizer::RegexMatch(
            Lazy::new(|| { Regex::new(concat!("^", "\\d+")).unwrap() }),
        ),
    ),
    TokenRecognizer(TokenKind::OPTIONAL, Recognizer::StrMatch("OPTIONAL")),
    TokenRecognizer(TokenKind::QUOTE, Recognizer::StrMatch("\\\"")),
    TokenRecognizer(TokenKind::AMPERSAND, Recognizer::StrMatch("&")),
    TokenRecognizer(TokenKind::OPENSQUAREBRACKET, Recognizer::StrMatch("[")),
    TokenRecognizer(TokenKind::CLOSESQUAREBRACKET, Recognizer::StrMatch("]")),
    TokenRecognizer(TokenKind::START_ARROW, Recognizer::StrMatch("-")),
    TokenRecognizer(TokenKind::END_ARROW, Recognizer::StrMatch("->")),
    TokenRecognizer(TokenKind::TRUE, Recognizer::StrMatch("TRUE")),
    TokenRecognizer(TokenKind::FALSE, Recognizer::StrMatch("FALSE")),
    TokenRecognizer(TokenKind::DATE, Recognizer::StrMatch("DATE")),
];
pub struct DefaultBuilder {
    res_stack: Vec<Symbol>,
}
impl DefaultBuilder {
    #[allow(dead_code)]
    pub fn new() -> Self {
        Self { res_stack: vec![] }
    }
}
impl Builder for DefaultBuilder {
    type Output = pg_actions::Pg;
    fn get_result(&mut self) -> Self::Output {
        match self.res_stack.pop().unwrap() {
            Symbol::NonTerminal(NonTerminal::Pg(r)) => r,
            _ => panic!("Invalid result on the parse stack!"),
        }
    }
}
impl<'i> LRBuilder<'i, Input, Context<'i, Input>, State, ProdKind, TokenKind>
for DefaultBuilder {
    #![allow(unused_variables)]
    fn shift_action(
        &mut self,
        context: &Context<'i, Input>,
        token: Token<'i, Input, TokenKind>,
    ) {
        let val = match token.kind {
            TokenKind::STOP => panic!("Cannot shift STOP token!"),
            TokenKind::QUOTED_STRING => {
                Terminal::QUOTED_STRING(pg_actions::quoted_string(context, token))
            }
            TokenKind::IDENTIFIER => {
                Terminal::IDENTIFIER(pg_actions::identifier(context, token))
            }
            TokenKind::OPEN_PAREN => Terminal::OPEN_PAREN,
            TokenKind::CLOSE_PAREN => Terminal::CLOSE_PAREN,
            TokenKind::OPEN_CURLY => Terminal::OPEN_CURLY,
            TokenKind::CLOSE_CURLY => Terminal::CLOSE_CURLY,
            TokenKind::COLON => Terminal::COLON,
            TokenKind::COMMA => Terminal::COMMA,
            TokenKind::NUMBER => Terminal::NUMBER(pg_actions::number(context, token)),
            TokenKind::OPENSQUAREBRACKET => Terminal::OPENSQUAREBRACKET,
            TokenKind::CLOSESQUAREBRACKET => Terminal::CLOSESQUAREBRACKET,
            TokenKind::START_ARROW => Terminal::START_ARROW,
            TokenKind::END_ARROW => Terminal::END_ARROW,
            TokenKind::TRUE => Terminal::TRUE,
            TokenKind::FALSE => Terminal::FALSE,
            TokenKind::DATE => Terminal::DATE,
            _ => panic!("Shift of unreachable terminal!"),
        };
        self.res_stack.push(Symbol::Terminal(val));
    }
    fn reduce_action(
        &mut self,
        context: &Context<'i, Input>,
        prod: ProdKind,
        prod_len: usize,
    ) {
        let prod = match prod {
            ProdKind::PgP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Statements(p0)) => {
                        NonTerminal::Pg(pg_actions::pg_statements(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::StatementsP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Statement1(p0)) => {
                        NonTerminal::Statements(
                            pg_actions::statements_statement1(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::Statement1P1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 2usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::Statement1(p0)),
                        Symbol::NonTerminal(NonTerminal::Statement(p1)),
                    ) => {
                        NonTerminal::Statement1(
                            pg_actions::statement1_c1(context, p0, p1),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::Statement1P2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Statement(p0)) => {
                        NonTerminal::Statement1(
                            pg_actions::statement1_statement(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::StatementP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Edge(p0)) => {
                        NonTerminal::Statement(pg_actions::statement_edge(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::StatementP2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Node(p0)) => {
                        NonTerminal::Statement(pg_actions::statement_node(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::NodeP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 4usize)
                    .into_iter();
                match (
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                ) {
                    (
                        _,
                        Symbol::NonTerminal(NonTerminal::NodeId(p0)),
                        Symbol::NonTerminal(NonTerminal::LabelsRecord(p1)),
                        _,
                    ) => NonTerminal::Node(pg_actions::node_c1(context, p0, p1)),
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::EdgeP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 12usize)
                    .into_iter();
                match (
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                    i.next().unwrap(),
                ) {
                    (
                        _,
                        Symbol::Terminal(Terminal::IDENTIFIER(p0)),
                        _,
                        _,
                        _,
                        Symbol::NonTerminal(NonTerminal::EdgeIdOpt(p1)),
                        Symbol::NonTerminal(NonTerminal::LabelsRecord(p2)),
                        _,
                        _,
                        _,
                        Symbol::Terminal(Terminal::IDENTIFIER(p3)),
                        _,
                    ) => NonTerminal::Edge(pg_actions::edge_c1(context, p0, p1, p2, p3)),
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::EdgeIdOptP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::EdgeId(p0)) => {
                        NonTerminal::EdgeIdOpt(
                            pg_actions::edge_id_opt_edge_id(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::EdgeIdOptP2 => {
                NonTerminal::EdgeIdOpt(pg_actions::edge_id_opt_empty(context))
            }
            ProdKind::NodeIdP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Id(p0)) => {
                        NonTerminal::NodeId(pg_actions::node_id_id(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::EdgeIdP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Id(p0)) => {
                        NonTerminal::EdgeId(pg_actions::edge_id_id(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::IdP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::IDENTIFIER(p0)) => {
                        NonTerminal::Id(pg_actions::id_identifier(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::LabelsRecordP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 2usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::LabelsOpt(p0)),
                        Symbol::NonTerminal(NonTerminal::RecordOpt(p1)),
                    ) => {
                        NonTerminal::LabelsRecord(
                            pg_actions::labels_record_c1(context, p0, p1),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::LabelsOptP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Labels(p0)) => {
                        NonTerminal::LabelsOpt(
                            pg_actions::labels_opt_labels(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::LabelsOptP2 => {
                NonTerminal::LabelsOpt(pg_actions::labels_opt_empty(context))
            }
            ProdKind::RecordOptP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Record(p0)) => {
                        NonTerminal::RecordOpt(
                            pg_actions::record_opt_record(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::RecordOptP2 => {
                NonTerminal::RecordOpt(pg_actions::record_opt_empty(context))
            }
            ProdKind::LabelsP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (_, Symbol::NonTerminal(NonTerminal::identifier1(p0)), _) => {
                        NonTerminal::Labels(pg_actions::labels_identifier1(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::identifier1P1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::identifier1(p0)),
                        _,
                        Symbol::NonTerminal(NonTerminal::identifier(p1)),
                    ) => {
                        NonTerminal::identifier1(
                            pg_actions::identifier1_c1(context, p0, p1),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::identifier1P2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::identifier(p0)) => {
                        NonTerminal::identifier1(
                            pg_actions::identifier1_identifier(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::RecordP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (_, Symbol::NonTerminal(NonTerminal::Properties(p0)), _) => {
                        NonTerminal::Record(pg_actions::record_properties(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::PropertiesP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Property1(p0)) => {
                        NonTerminal::Properties(
                            pg_actions::properties_property1(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::Property1P1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::Property1(p0)),
                        _,
                        Symbol::NonTerminal(NonTerminal::Property(p1)),
                    ) => {
                        NonTerminal::Property1(pg_actions::property1_c1(context, p0, p1))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::Property1P2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::Property(p0)) => {
                        NonTerminal::Property1(
                            pg_actions::property1_property(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::PropertyP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::key(p0)),
                        _,
                        Symbol::NonTerminal(NonTerminal::Values(p1)),
                    ) => NonTerminal::Property(pg_actions::property_c1(context, p0, p1)),
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::keyP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::identifier(p0)) => {
                        NonTerminal::key(pg_actions::key_identifier(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::ValuesP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::SingleValue(p0)) => {
                        NonTerminal::Values(pg_actions::values_single_value(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::ValuesListValue => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (_, Symbol::NonTerminal(NonTerminal::ListValues(p0)), _) => {
                        NonTerminal::Values(pg_actions::values_list_value(context, p0))
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::ListValuesP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::SingleValue0(p0)) => {
                        NonTerminal::ListValues(
                            pg_actions::list_values_single_value0(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValue1P1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 3usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap(), i.next().unwrap()) {
                    (
                        Symbol::NonTerminal(NonTerminal::SingleValue1(p0)),
                        _,
                        Symbol::NonTerminal(NonTerminal::SingleValue(p1)),
                    ) => {
                        NonTerminal::SingleValue1(
                            pg_actions::single_value1_c1(context, p0, p1),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValue1P2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::SingleValue(p0)) => {
                        NonTerminal::SingleValue1(
                            pg_actions::single_value1_single_value(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValue0P1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::SingleValue1(p0)) => {
                        NonTerminal::SingleValue0(
                            pg_actions::single_value0_single_value1(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValue0P2 => {
                NonTerminal::SingleValue0(pg_actions::single_value0_empty(context))
            }
            ProdKind::SingleValueStringValue => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::QUOTED_STRING(p0)) => {
                        NonTerminal::SingleValue(
                            pg_actions::single_value_string_value(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValueNumberValue => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::NUMBER(p0)) => {
                        NonTerminal::SingleValue(
                            pg_actions::single_value_number_value(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValueDateValue => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 2usize)
                    .into_iter();
                match (i.next().unwrap(), i.next().unwrap()) {
                    (_, Symbol::Terminal(Terminal::QUOTED_STRING(p0))) => {
                        NonTerminal::SingleValue(
                            pg_actions::single_value_date_value(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::SingleValueBooleanValue => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::NonTerminal(NonTerminal::BOOL(p0)) => {
                        NonTerminal::SingleValue(
                            pg_actions::single_value_boolean_value(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::BOOLP1 => {
                let _ = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                NonTerminal::BOOL(pg_actions::bool_true(context))
            }
            ProdKind::BOOLP2 => {
                let _ = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                NonTerminal::BOOL(pg_actions::bool_false(context))
            }
            ProdKind::identifierP1 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::IDENTIFIER(p0)) => {
                        NonTerminal::identifier(
                            pg_actions::identifier_identifier(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            ProdKind::identifierP2 => {
                let mut i = self
                    .res_stack
                    .split_off(self.res_stack.len() - 1usize)
                    .into_iter();
                match i.next().unwrap() {
                    Symbol::Terminal(Terminal::QUOTED_STRING(p0)) => {
                        NonTerminal::identifier(
                            pg_actions::identifier_quoted_string(context, p0),
                        )
                    }
                    _ => panic!("Invalid symbol parse stack data."),
                }
            }
            _ => panic!("Reduce of unreachable nonterminal!"),
        };
        self.res_stack.push(Symbol::NonTerminal(prod));
    }
}
