% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptype.R
\name{recipes_ptype_validate}
\alias{recipes_ptype_validate}
\title{Validate prototype of recipe object}
\usage{
recipes_ptype_validate(
  x,
  new_data,
  ...,
  stage = "prep",
  call = rlang::caller_env()
)
}
\arguments{
\item{x}{A \code{recipe} object.}

\item{new_data}{A data.frame. To be patched aganist ptype of \code{x}.}

\item{...}{currently not used.}

\item{stage}{A single character. Must be one of \code{"prep"} or \code{"bake"}. See
details for more. Defaults to \code{"prep"}.}

\item{call}{The execution environment of a currently running function, e.g.
\code{caller_env()}. The function will be mentioned in error messages as the
source of the error. See the call argument of \code{\link[rlang:abort]{rlang::abort()}} for more
information.}
}
\value{
Nothing or an error.
}
\description{
This helper function validates a dataframe against the ptype of a recipe.
}
\examples{
rec <- recipe(mpg ~ disp, data = mtcars)

recipes_ptype_validate(rec, mtcars)

}
\seealso{
\link{developer_functions} \link{recipes_ptype}
}
\keyword{internal}
