% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut.R
\name{step_cut}
\alias{step_cut}
\alias{tidy.step_cut}
\title{Cut a numeric variable into a factor}
\usage{
step_cut(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  breaks,
  include_outside_range = FALSE,
  skip = FALSE,
  id = rand_id("cut")
)

\method{tidy}{step_cut}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{breaks}{A numeric vector with at least one cut point.}

\item{include_outside_range}{Logical, indicating if values outside the
range in the train set should be included in the lowest or highest bucket.
Defaults to \code{FALSE}, values outside the original range will be set to \code{NA}.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked
by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked when \code{\link[=prep.recipe]{prep.recipe()}} is
run, some operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it may affect the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_cut} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any).
}
\description{
\code{step_cut()} creates a \emph{specification} of a recipe step that cuts a numeric
variable into a factor based on provided boundary values
}
\details{
Unlike the \code{base::cut()} function there is no need to specify the
min and the max values in the breaks. All values before the lowest break
point will end up in the first bucket, all values after the last break
points will end up in the last.

\code{step_cut()} will call \code{base::cut()} in the baking step with
\code{include.lowest} set to \code{TRUE}.
}
\examples{
df <- data.frame(x = 1:10, y = 5:14)
rec <- recipe(df)

# The min and max of the variable are used as boundaries
# if they exceed the breaks
rec \%>\%
  step_cut(x, breaks = 5) \%>\%
  prep() \%>\%
  bake(df)

# You can use the same breaks on multiple variables
# then for each variable the boundaries are set separately
rec \%>\%
  step_cut(x, y, breaks = c(6, 9)) \%>\%
  prep() \%>\%
  bake(df)

# It is up to you if you want values outside the
# range learned at prep to be included
new_df <- data.frame(x = 1:11)
rec \%>\%
  step_cut(x, breaks = 5, include_outside_range = TRUE) \%>\%
  prep() \%>\%
  bake(new_df)

rec \%>\%
  step_cut(x, breaks = 5, include_outside_range = FALSE) \%>\%
  prep() \%>\%
  bake(new_df)
}
\concept{preprocessing}
\keyword{datagen}
