% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{check_class}
\alias{check_class}
\alias{tidy.check_class}
\title{Check Variable Class}
\usage{
check_class(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  class_nm = NULL,
  allow_additional = FALSE,
  skip = FALSE,
  class_list = NULL,
  id = rand_id("class")
)

\method{tidy}{check_class}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The check will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the check. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Not used by this check since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{class_nm}{A character vector that will be used in \code{inherits} to
check the class. If \code{NULL} the classes will be learned in \code{prep}.
Can contain more than one class.}

\item{allow_additional}{If \code{TRUE} a variable is allowed to
have additional classes to the one(s) that are checked.}

\item{skip}{A logical. Should the check be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{class_list}{A named list of column classes. This is
\code{NULL} until computed by \code{\link[=prep.recipe]{prep.recipe()}}.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{check_class} object.}
}
\value{
An updated version of \code{recipe} with the new check
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and \code{value} (the type).
}
\description{
\code{check_class} creates a \emph{specification} of a recipe
check that will check if a variable is of a designated class.
}
\details{
This function can check the classes of the variables
in two ways. When the \code{class} argument is provided
it will check if all the variables specified are of the
given class. If this argument is \code{NULL}, the check will
learn the classes of each of the specified variables in \code{prep}.
Both ways will break \code{bake} if the variables are not of
the requested class. If a variable has multiple
classes in \code{prep}, all the classes are checked. Please note
that in \code{prep} the argument \code{strings_as_factors} defaults to
\code{TRUE}. If the train set contains character variables
the check will be break \code{bake} when \code{strings_as_factors} is
\code{TRUE}.
}
\examples{
library(dplyr)
library(modeldata)
data(okc)

# Learn the classes on the train set
train <- okc[1:1000, ]
test  <- okc[1001:2000, ]
recipe(train, age ~ . ) \%>\%
  check_class(everything()) \%>\%
  prep(train, strings_as_factors = FALSE) \%>\%
  bake(test)

# Manual specification
recipe(train, age ~ .) \%>\%
  check_class(age, class_nm = "integer") \%>\%
  check_class(diet, location, class_nm = "character") \%>\%
  check_class(date, class_nm = "Date") \%>\%
  prep(train, strings_as_factors = FALSE) \%>\%
  bake(test)

# By default only the classes that are specified
#   are allowed.
x_df <- tibble(time = c(Sys.time() - 60, Sys.time()))
x_df$time \%>\% class()
\dontrun{
recipe(x_df) \%>\%
  check_class(time, class_nm = "POSIXt") \%>\%
  prep(x_df) \%>\%
  bake_(x_df)
}

# Use allow_additional = TRUE if you are fine with it
recipe(x_df) \%>\%
  check_class(time, class_nm = "POSIXt", allow_additional = TRUE) \%>\%
  prep(x_df) \%>\%
  bake(x_df)

}
\seealso{
\code{\link[=recipe]{recipe()}} \code{\link[=prep.recipe]{prep.recipe()}}
\code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{preprocessing normalization_methods}
\keyword{datagen}
