% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{guess_chunks}
\alias{guess_chunks}
\title{Guess the dimension of a chunk}
\usage{
guess_chunks(space_maxdims, dtype_size,
  chunk_size = getOption("hdf5r.chunk_size"))
}
\arguments{
\item{space_maxdims}{Maximal dimensions of the dataset}

\item{dtype_size}{Size of the datatype that is stored}

\item{chunk_size}{Size of each chunk in bytes}
}
\value{
An integer vector giving the dimension of the chunk
}
\description{
Guess the dimension of a chunk
}
\details{
The size of the chunk in bytes is first divided by the size of the datatype, giving the number of elements
to be stored in each chunk. This is taken as a rough guideline. Then, the number of dimensions of the dataset is used.
By default, the chunk is assumed to have the same size in each dimension, yielding an initial guess.

If the resulting chunk is larger than the entire dataset for a maximal dimension, this dimension of the chunk is reduced and
redistributed to the other dimensions.

As a chunk is never allowed to be larger than the maximum dimension of the dataset itself,
}
\author{
Holger Hoefling
}
