package sam

import (
	"net/url"
	"time"
)

func init() {
	for _, ref := range headerHG00096_1000.refs {
		ref.owner = headerHG00096_1000
	}
	for _, rg := range headerHG00096_1000.rgs {
		rg.owner = headerHG00096_1000
	}
	for _, prog := range headerHG00096_1000.progs {
		prog.owner = headerHG00096_1000
	}
}

var (
	// This is the header of the file
	// ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/data/HG00096/alignment/HG00096.unmapped.ILLUMINA.bwa.GBR.low_coverage.20120522.bam
	//
	// samtools view HG00096.unmapped.ILLUMINA.bwa.GBR.low_coverage.20120522.bam -H | sed -e 's/ \{7,8\}/\t/g'> HG00096_1000.sam # The sed sub is required due to broken format in original data.
	// samtools view HG00096.unmapped.ILLUMINA.bwa.GBR.low_coverage.20120522.bam | head -n 1000 >> HG00096_1000.sam
	// samtools view -Sb HG00096_1000.sam > HG00096_1000.bam
	headerHG00096_1000 = &Header{
		Version:   "1.0",
		SortOrder: 3,
		Comments: []string{
			"$known_indels_file(s) = ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/phase2_mapping_resources/ALL.wgs.indels_mills_devine_hg19_leftAligned_collapsed_double_hit.indels.sites.vcf.gz",
			"$known_indels_file(s) .= ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/phase2_mapping_resources/ALL.wgs.low_coverage_vqsr.20101123.indels.sites.vcf.gz",
			"$known_sites_file(s) = ftp://ftp.1000genomes.ebi.ac.uk/vol1/ftp/technical/reference/phase2_mapping_resources/ALL.wgs.dbsnp.build135.snps.sites.vcf.gz",
		},
		refs: []*Reference{
			{
				id:      0,
				name:    "1",
				lRef:    249250621,
				md5:     "\x1b\x22\xb9\x8c\xde\xb4\xa9\x30\x4c\xb5\xd4\x80\x26\xa8\x51\x28",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      1,
				name:    "2",
				lRef:    243199373,
				md5:     "\xa0\xd9\x85\x1d\xa0\x04\x00\xde\xc1\x09\x8a\x92\x55\xac\x71\x2e",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      2,
				name:    "3",
				lRef:    198022430,
				md5:     "\xfd\xfd\x81\x18\x49\xcc\x2f\xad\xeb\xc9\x29\xbb\x92\x59\x02\xe5",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      3,
				name:    "4",
				lRef:    191154276,
				md5:     "\x23\xdc\xcd\x10\x68\x97\x54\x2a\xd8\x7d\x27\x65\xd2\x8a\x19\xa1",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      4,
				name:    "5",
				lRef:    180915260,
				md5:     "\x07\x40\x17\x3d\xb9\xff\xd2\x64\xd7\x28\xf3\x27\x84\x84\x5c\xd7",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      5,
				name:    "6",
				lRef:    171115067,
				md5:     "\x1d\x3a\x93\xa2\x48\xd9\x2a\x72\x9e\xe7\x64\x82\x3a\xcb\xbc\x6b",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      6,
				name:    "7",
				lRef:    159138663,
				md5:     "\x61\x83\x66\xe9\x53\xd6\xaa\xad\x97\xdb\xe4\x77\x7c\x29\x37\x5e",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      7,
				name:    "8",
				lRef:    146364022,
				md5:     "\x96\xf5\x14\xa9\x92\x9e\x41\x0c\x66\x51\x69\x7b\xde\xd5\x9a\xec",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      8,
				name:    "9",
				lRef:    141213431,
				md5:     "\x3e\x27\x31\x17\xf1\x5e\x0a\x40\x0f\x01\x05\x5d\x9f\x39\x37\x68",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      9,
				name:    "10",
				lRef:    135534747,
				md5:     "\x98\x8c\x28\xe0\x00\xe8\x4c\x26\xd5\x52\x35\x9a\xf1\xea\x2e\x1d",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      10,
				name:    "11",
				lRef:    135006516,
				md5:     "\x98\xc5\x90\x49\xa2\xdf\x28\x5c\x76\xff\xb1\xc6\xdb\x8f\x8b\x96",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      11,
				name:    "12",
				lRef:    133851895,
				md5:     "\x51\x85\x1a\xc0\xe1\xa1\x15\x84\x7a\xd3\x64\x49\xb0\x01\x58\x64",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      12,
				name:    "13",
				lRef:    115169878,
				md5:     "\x28\x3f\x8d\x78\x92\xba\xa8\x1b\x51\x0a\x01\x57\x19\xca\x7b\x0b",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      13,
				name:    "14",
				lRef:    107349540,
				md5:     "\x98\xf3\xca\xe3\x2b\x2a\x2e\x95\x24\xbc\x19\x81\x39\x27\x54\x2e",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      14,
				name:    "15",
				lRef:    102531392,
				md5:     "\xe5\x64\x5a\x79\x4a\x82\x38\x21\x5b\x2c\xd7\x7a\xcb\x95\xa0\x78",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      15,
				name:    "16",
				lRef:    90354753,
				md5:     "\xfc\x9b\x1a\x7b\x42\xb9\x7a\x86\x4f\x56\xb3\x48\xb0\x60\x95\xe6",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      16,
				name:    "17",
				lRef:    81195210,
				md5:     "\x35\x1f\x64\xd4\xf4\xf9\xdd\xd4\x5b\x35\x33\x6a\xd9\x7a\xa6\xde",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      17,
				name:    "18",
				lRef:    78077248,
				md5:     "\xb1\x5d\x4b\x2d\x29\xdd\xe9\xd3\xe4\xf9\x3d\x1d\x0f\x2c\xbc\x9c",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      18,
				name:    "19",
				lRef:    59128983,
				md5:     "\x1a\xac\xd7\x1f\x30\xdb\x8e\x56\x18\x10\x91\x3e\x0b\x72\x63\x6d",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      19,
				name:    "20",
				lRef:    63025520,
				md5:     "\x0d\xec\x96\x60\xec\x1e\xfa\xaf\x33\x28\x1c\x0d\x5e\xa2\x56\x0f",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      20,
				name:    "21",
				lRef:    48129895,
				md5:     "\x29\x79\xa6\x08\x5b\xfe\x28\xe3\xad\x6f\x55\x2f\x36\x1e\xd7\x4d",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      21,
				name:    "22",
				lRef:    51304566,
				md5:     "\xa7\x18\xac\xaa\x61\x35\xfd\xca\x83\x57\xd5\xbf\xe9\x42\x11\xdd",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      22,
				name:    "X",
				lRef:    155270560,
				md5:     "\x7e\x0e\x2e\x58\x02\x97\xb7\x76\x4e\x31\xdb\xc8\x0c\x25\x40\xdd",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      23,
				name:    "Y",
				lRef:    59373566,
				md5:     "\x1f\xa3\x47\x47\x50\xaf\x09\x48\xbd\xf9\x7d\x5a\x0e\xe5\x2e\x51",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      24,
				name:    "MT",
				lRef:    16569,
				md5:     "\xc6\x8f\x52\x67\x4c\x9f\xb3\x3a\xef\x52\xdc\xf3\x99\x75\x55\x19",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      25,
				name:    "GL000207.1",
				lRef:    4262,
				md5:     "\xf3\x81\x48\x41\xf1\x93\x9d\x3c\xa1\x90\x72\xd9\xe8\x9f\x3f\xd7",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      26,
				name:    "GL000226.1",
				lRef:    15008,
				md5:     "\x1c\x1b\x2c\xd1\xfc\xcb\xc0\xa9\x9b\x6a\x44\x7f\xa2\x4d\x15\x04",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      27,
				name:    "GL000229.1",
				lRef:    19913,
				md5:     "\xd0\xf4\x0e\xc8\x7d\xe3\x11\xd8\xe7\x15\xb5\x2e\x4c\x70\x62\xe1",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      28,
				name:    "GL000231.1",
				lRef:    27386,
				md5:     "\xba\x88\x82\xce\x3a\x1e\xfa\x20\x80\xe5\xd2\x9b\x95\x65\x68\xa4",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      29,
				name:    "GL000210.1",
				lRef:    27682,
				md5:     "\x85\x11\x06\xa7\x42\x38\x04\x41\x26\x13\x1c\xe2\xa8\xe5\x84\x7c",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      30,
				name:    "GL000239.1",
				lRef:    33824,
				md5:     "\x99\x79\x5f\x15\x70\x2c\xae\xc4\xfa\x1c\x4e\x15\xf8\xa2\x9c\x07",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      31,
				name:    "GL000235.1",
				lRef:    34474,
				md5:     "\x11\x8a\x25\xca\x21\x0c\xfb\xcd\xfb\x6c\x2e\xbb\x24\x9f\x96\x80",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      32,
				name:    "GL000201.1",
				lRef:    36148,
				md5:     "\xdf\xb7\xe7\xec\x60\xff\xdc\xb8\x5c\xb3\x59\xea\x28\x45\x4e\xe9",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      33,
				name:    "GL000247.1",
				lRef:    36422,
				md5:     "\x7d\xe0\x02\x26\xbb\x7d\xf1\xc5\x72\x76\xca\x6b\xaa\xba\xfd\x15",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      34,
				name:    "GL000245.1",
				lRef:    36651,
				md5:     "\x89\xbc\x61\x96\x0f\x37\xd9\x4a\xbf\x0d\xf2\xd4\x81\xad\xa0\xec",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      35,
				name:    "GL000197.1",
				lRef:    37175,
				md5:     "\x6f\x5e\xfd\xd3\x66\x43\xa9\xb8\xc8\xcc\xad\x6f\x2f\x1e\xdc\x7b",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      36,
				name:    "GL000203.1",
				lRef:    37498,
				md5:     "\x96\x35\x8c\x32\x5f\xe0\xe7\x0b\xee\x73\x43\x6e\x8b\xb1\x4d\xbd",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      37,
				name:    "GL000246.1",
				lRef:    38154,
				md5:     "\xe4\xaf\xcd\x31\x91\x2a\xf9\xd9\xc2\x54\x6a\xcf\x1c\xb2\x3a\xf2",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      38,
				name:    "GL000249.1",
				lRef:    38502,
				md5:     "\x1d\x78\xab\xec\x37\xc1\x5f\xe2\x9a\x27\x5e\xb0\x8d\x5a\xf2\x36",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      39,
				name:    "GL000196.1",
				lRef:    38914,
				md5:     "\xd9\x22\x06\xd1\xbb\x4c\x3b\x40\x19\xc4\x3c\x08\x75\xc0\x6d\xc0",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      40,
				name:    "GL000248.1",
				lRef:    39786,
				md5:     "\x5a\x8e\x43\xbe\xc9\xbe\x36\xc7\xb4\x9c\x84\xd5\x85\x10\x77\x76",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      41,
				name:    "GL000244.1",
				lRef:    39929,
				md5:     "\x09\x96\xb4\x47\x5f\x35\x3c\xa9\x8b\xac\xb7\x56\xac\x47\x91\x40",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      42,
				name:    "GL000238.1",
				lRef:    39939,
				md5:     "\x13\x1b\x1e\xfc\x32\x70\xcc\x83\x86\x86\xb5\x4e\x7c\x34\xb1\x7b",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      43,
				name:    "GL000202.1",
				lRef:    40103,
				md5:     "\x06\xcb\xf1\x26\x24\x7d\x89\x66\x4a\x4f\xae\xba\xd1\x30\xfe\x9c",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      44,
				name:    "GL000234.1",
				lRef:    40531,
				md5:     "\x93\xf9\x98\x53\x6b\x61\xa5\x6f\xd0\xff\x47\x32\x2a\x91\x1d\x4b",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      45,
				name:    "GL000232.1",
				lRef:    40652,
				md5:     "\x3e\x06\xb6\x74\x10\x61\xad\x93\xa8\x58\x75\x31\x30\x70\x57\xd8",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      46,
				name:    "GL000206.1",
				lRef:    41001,
				md5:     "\x43\xf6\x9e\x42\x35\x33\xe9\x48\xbf\xae\x5c\xe1\xd4\x5b\xd3\xf1",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      47,
				name:    "GL000240.1",
				lRef:    41933,
				md5:     "\x44\x5a\x86\x17\x3d\xa9\xf2\x37\xd7\xbc\xf4\x1c\x6c\xb8\xcc\x62",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      48,
				name:    "GL000236.1",
				lRef:    41934,
				md5:     "\xfd\xcd\x73\x99\x13\xef\xa1\xfd\xc6\x4b\x6c\x0c\xd7\x01\x67\x79",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      49,
				name:    "GL000241.1",
				lRef:    42152,
				md5:     "\xef\x42\x58\xcd\xc5\xa4\x5c\x20\x6c\xea\x8f\xc3\xe1\xd8\x58\xcf",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      50,
				name:    "GL000243.1",
				lRef:    43341,
				md5:     "\xcc\x34\x27\x9a\x7e\x35\x31\x36\x74\x1c\x9f\xce\x79\xbc\x43\x96",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      51,
				name:    "GL000242.1",
				lRef:    43523,
				md5:     "\x2f\x86\x94\xfc\x47\x57\x6b\xc8\x1b\x5f\xe9\xe7\xde\x0b\xa4\x9e",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      52,
				name:    "GL000230.1",
				lRef:    43691,
				md5:     "\xb4\xeb\x71\xee\x87\x8d\x37\x06\x24\x6b\x7c\x1d\xbe\xf6\x92\x99",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      53,
				name:    "GL000237.1",
				lRef:    45867,
				md5:     "\xe0\xc8\x2e\x77\x51\xdf\x73\xf4\xf6\xd0\xed\x30\xcd\xc8\x53\xc0",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      54,
				name:    "GL000233.1",
				lRef:    45941,
				md5:     "\x7f\xed\x60\x29\x8a\x8d\x62\xff\x80\x8b\x74\xb6\xce\x82\x00\x01",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      55,
				name:    "GL000204.1",
				lRef:    81310,
				md5:     "\xef\xc4\x9c\x87\x15\x36\xfa\x8d\x79\xcb\x0a\x06\xfa\x73\x97\x22",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      56,
				name:    "GL000198.1",
				lRef:    90085,
				md5:     "\x86\x8e\x77\x84\x04\x0d\xa9\x0d\x90\x0d\x2d\x1b\x66\x7a\x13\x83",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      57,
				name:    "GL000208.1",
				lRef:    92689,
				md5:     "\xaa\x81\xbe\x49\xbf\x3f\xe6\x3a\x79\xbd\xc6\xa6\xf2\x79\xab\xf6",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      58,
				name:    "GL000191.1",
				lRef:    106433,
				md5:     "\xd7\x5b\x43\x6f\x50\xa8\x21\x4e\xe9\xc2\xa5\x1d\x30\xb2\xc2\xcc",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      59,
				name:    "GL000227.1",
				lRef:    128374,
				md5:     "\xa4\xae\xad\x23\xf8\x05\x3f\x26\x55\xe4\x68\xbc\xc6\xec\xdc\xeb",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      60,
				name:    "GL000228.1",
				lRef:    129120,
				md5:     "\xc5\xa1\x7c\x97\xe2\xc1\xa0\xb6\xa9\xcc\x5a\x6b\x06\x4b\x71\x4f",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      61,
				name:    "GL000214.1",
				lRef:    137718,
				md5:     "\x46\xc2\x03\x2c\x37\xf2\xed\x89\x9e\xb4\x1c\x04\x73\x31\x9a\x69",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      62,
				name:    "GL000221.1",
				lRef:    155397,
				md5:     "\x32\x38\xfb\x74\xea\x87\xae\x85\x7f\x9c\x75\x08\xd3\x15\xba\xbb",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      63,
				name:    "GL000209.1",
				lRef:    159169,
				md5:     "\xf4\x05\x98\xe2\xa5\xa6\xb2\x6e\x84\xa3\x77\x5e\x0d\x1e\x2c\x81",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      64,
				name:    "GL000218.1",
				lRef:    161147,
				md5:     "\x1d\x70\x8b\x54\x64\x4c\x26\xc7\xe0\x1c\x2d\xad\x54\x26\xd3\x8c",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      65,
				name:    "GL000220.1",
				lRef:    161802,
				md5:     "\xfc\x35\xde\x96\x3c\x57\xbf\x76\x48\x42\x9e\x64\x54\xf1\xc9\xdb",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      66,
				name:    "GL000213.1",
				lRef:    164239,
				md5:     "\x9d\x42\x4f\xdc\xc9\x88\x66\x65\x0b\x58\xf0\x04\x08\x0a\x99\x2a",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      67,
				name:    "GL000211.1",
				lRef:    166566,
				md5:     "\x7d\xaa\xa4\x5c\x66\xb2\x88\x84\x7b\x9b\x32\xb9\x64\xe6\x23\xd3",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      68,
				name:    "GL000199.1",
				lRef:    169874,
				md5:     "\x56\x9a\xf3\xb7\x35\x22\xfa\xb4\xb4\x09\x95\xae\x49\x44\xe7\x8e",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      69,
				name:    "GL000217.1",
				lRef:    172149,
				md5:     "\x6d\x24\x3e\x18\xde\xa1\x94\x5f\xb7\xf2\x51\x76\x15\xb8\xf5\x2e",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      70,
				name:    "GL000216.1",
				lRef:    172294,
				md5:     "\x64\x2a\x23\x2d\x91\xc4\x86\xac\x33\x92\x63\x82\x0a\xef\x7f\xe0",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      71,
				name:    "GL000215.1",
				lRef:    172545,
				md5:     "\x5e\xb3\xb4\x18\x48\x0a\xe6\x7a\x99\x79\x57\xc9\x09\x37\x5a\x73",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      72,
				name:    "GL000205.1",
				lRef:    174588,
				md5:     "\xd2\x24\x41\x39\x8d\x99\xca\xf6\x73\xe9\xaf\xb9\xa1\x90\x8e\xc5",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      73,
				name:    "GL000219.1",
				lRef:    179198,
				md5:     "\xf9\x77\xed\xd1\x3b\xac\x45\x9c\xb2\xed\x4a\x54\x57\xdb\xa1\xb3",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      74,
				name:    "GL000224.1",
				lRef:    179693,
				md5:     "\xd5\xb2\xfc\x04\xf6\xb4\x1b\x21\x2a\x41\x98\xa0\x7f\x45\x0e\x20",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      75,
				name:    "GL000223.1",
				lRef:    180455,
				md5:     "\x39\x9d\xfa\x03\xbf\x32\x02\x2a\xb5\x2a\x84\x6f\x7c\xa3\x5b\x30",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      76,
				name:    "GL000195.1",
				lRef:    182896,
				md5:     "\x5d\x9e\xc0\x07\x86\x8d\x51\x7e\x73\x54\x3b\x00\x5b\xa4\x85\x35",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      77,
				name:    "GL000212.1",
				lRef:    186858,
				md5:     "\x56\x35\x31\x68\x9f\x3d\xbd\x69\x13\x31\xfd\x6c\x57\x30\xa8\x8b",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      78,
				name:    "GL000222.1",
				lRef:    186861,
				md5:     "\x6f\xe9\xab\xac\x45\x51\x69\xf5\x04\x70\xf5\xa6\xb0\x1d\x0f\x59",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      79,
				name:    "GL000200.1",
				lRef:    187035,
				md5:     "\x75\xe4\xc8\xd1\x7c\xd4\xad\xdf\x39\x17\xd1\x70\x3c\xac\xaf\x25",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:   80,
				name: "GL000193.1",
				lRef: 189789, md5: "\xdb\xb6\xe8\xec\xe0\xb5\xde\x29\xda\x56\x60\x16\x13\x00\x7c\x2a",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      81,
				name:    "GL000194.1",
				lRef:    191469,
				md5:     "\x6a\xc8\xf8\x15\xbf\x8e\x84\x5b\xb3\x03\x1b\x73\xf8\x12\xc0\x12",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      82,
				name:    "GL000225.1",
				lRef:    211173,
				md5:     "\x63\x94\x5c\x3e\x69\x62\xf2\x8f\xfd\x46\x97\x19\xa7\x47\xe7\x3c",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      83,
				name:    "GL000192.1",
				lRef:    547496,
				md5:     "\x32\x5b\xa9\xe8\x08\xf6\x69\xdf\xee\xe2\x10\xfd\xd7\xb4\x70\xac",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      84,
				name:    "NC_007605",
				lRef:    171823,
				md5:     "\x67\x43\xbd\x63\xb3\xff\x2b\x5b\x89\x85\xd8\x93\x3c\x53\x29\x0a",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
			{
				id:      85,
				name:    "hs37d5",
				lRef:    35477943,
				md5:     "\x5b\x6a\x4b\x3a\x81\xa2\xd3\xc1\x34\xb7\xd1\x4b\xf6\xad\x39\xf1",
				assemID: "NCBI37",
				species: "Human",
				uri: &url.URL{
					Scheme: "ftp",
					Host:   "ftp.1000genomes.ebi.ac.uk",
					Path:   "/vol1/ftp/technical/reference/phase2_reference_assembly_sequence/hs37d5.fa.gz",
				},
			},
		},
		rgs: []*ReadGroup{
			{
				id:           0,
				name:         "SRR062634",
				center:       "WUGSC",
				description:  "SRP001294",
				date:         time.Time{},
				flowOrder:    "",
				keySeq:       "",
				library:      "2845856850",
				program:      "",
				insertSize:   206,
				platform:     "ILLUMINA",
				platformUnit: "",
				sample:       "HG00096",
			},
			{
				id:           1,
				name:         "SRR062635",
				center:       "WUGSC",
				description:  "SRP001294",
				date:         time.Time{},
				flowOrder:    "",
				keySeq:       "",
				library:      "2845856850",
				program:      "",
				insertSize:   206,
				platform:     "ILLUMINA",
				platformUnit: "",
				sample:       "HG00096",
			},
			{
				id:           2,
				name:         "SRR062641",
				center:       "WUGSC",
				description:  "SRP001294",
				date:         time.Time{},
				flowOrder:    "",
				keySeq:       "",
				library:      "2845856850",
				program:      "",
				insertSize:   206,
				platform:     "ILLUMINA",
				platformUnit: "",
				sample:       "HG00096",
			},
		},
		progs: []*Program{
			{
				id:       0,
				uid:      "bwa_index",
				previous: "",
				name:     "bwa",
				command:  "bwa index -a bwtsw $reference_fasta",
				version:  "0.5.9-r16",
			},
			{
				id:       1,
				uid:      "bwa_aln_fastq",
				previous: "bwa_index",
				name:     "bwa",
				command:  "bwa aln -q 15 -f $sai_file $reference_fasta $fastq_file",
				version:  "0.5.9-r16",
			},
			{
				id:       2,
				uid:      "bwa_sam",
				previous: "bwa_aln_fastq",
				name:     "bwa",
				command:  "bwa sampe -a 618 -r $rg_line -f $sam_file $reference_fasta $sai_file(s) $fastq_file(s)",
				version:  "0.5.9-r16",
			},
			{
				id:       3,
				uid:      "sam_to_fixed_bam",
				previous: "bwa_sam",
				name:     "samtools",
				command:  "samtools view -bSu $sam_file | samtools sort -n -o - samtools_nsort_tmp | samtools fixmate /dev/stdin /dev/stdout | samtools sort -o - samtools_csort_tmp | samtools fillmd -u - $reference_fasta > $fixed_bam_file",
				version:  "0.1.17 (r973:277)",
			},
			{
				id:       4,
				uid:      "gatk_target_interval_creator",
				previous: "sam_to_fixed_bam",
				name:     "GenomeAnalysisTK",
				command:  "java $jvm_args -jar GenomeAnalysisTK.jar -T RealignerTargetCreator -R $reference_fasta -o $intervals_file -known $known_indels_file(s)",
				version:  "1.2-29-g0acaf2d",
			},
			{
				id:       5,
				uid:      "bam_realignment_around_known_indels",
				previous: "gatk_target_interval_creator",
				name:     "GenomeAnalysisTK",
				command:  "java $jvm_args -jar GenomeAnalysisTK.jar -T IndelRealigner -R $reference_fasta -I $bam_file -o $realigned_bam_file -targetIntervals $intervals_file -known $known_indels_file(s) -LOD 0.4 -model KNOWNS_ONLY -compress 0 --disable_bam_indexing",
				version:  "1.2-29-g0acaf2d",
			},
			{
				id:       6,
				uid:      "bam_count_covariates",
				previous: "bam_realignment_around_known_indels",
				name:     "GenomeAnalysisTK",
				command:  "java $jvm_args -jar GenomeAnalysisTK.jar -T CountCovariates -R $reference_fasta -I $bam_file -recalFile $bam_file.recal_data.csv -knownSites $known_sites_file(s) -l INFO -L '1;2;3;4;5;6;7;8;9;10;11;12;13;14;15;16;17;18;19;20;21;22;X;Y;MT' -cov ReadGroupCovariate -cov QualityScoreCovariate -cov CycleCovariate -cov DinucCovariate",
				version:  "1.2-29-g0acaf2d",
			},
			{
				id:       7,
				uid:      "bam_recalibrate_quality_scores",
				previous: "bam_count_covariates",
				name:     "GenomeAnalysisTK",
				command:  "java $jvm_args -jar GenomeAnalysisTK.jar -T TableRecalibration -R $reference_fasta -recalFile $bam_file.recal_data.csv -I $bam_file -o $recalibrated_bam_file -l INFO -compress 0 --disable_bam_indexing",
				version:  "1.2-29-g0acaf2d",
			},
			{
				id:       8,
				uid:      "bam_calculate_bq",
				previous: "bam_recalibrate_quality_scores",
				name:     "samtools",
				command:  "samtools calmd -Erb $bam_file $reference_fasta > $bq_bam_file",
				version:  "0.1.17 (r973:277)",
			},
			{
				id:       9,
				uid:      "bam_merge",
				previous: "bam_calculate_bq",
				name:     "picard",
				command:  "java $jvm_args -jar MergeSamFiles.jar INPUT=$bam_file(s) OUTPUT=$merged_bam VALIDATION_STRINGENCY=SILENT",
				version:  "1.53",
			},
			{
				id:       10,
				uid:      "bam_mark_duplicates",
				previous: "bam_merge",
				name:     "picard",
				command:  "java $jvm_args -jar MarkDuplicates.jar INPUT=$bam_file OUTPUT=$markdup_bam_file ASSUME_SORTED=TRUE METRICS_FILE=/dev/null VALIDATION_STRINGENCY=SILENT",
				version:  "1.53",
			},
			{
				id:       11,
				uid:      "bam_merge.1",
				previous: "bam_mark_duplicates",
				name:     "picard",
				command:  "java $jvm_args -jar MergeSamFiles.jar INPUT=$bam_file(s) OUTPUT=$merged_bam VALIDATION_STRINGENCY=SILENT",
				version:  "1.53",
			},
		},
		seenRefs: set{
			"12":         11,
			"GL000238.1": 42,
			"GL000191.1": 58,
			"GL000227.1": 59,
			"GL000209.1": 63,
			"GL000246.1": 37,
			"GL000202.1": 43,
			"GL000233.1": 54,
			"GL000211.1": 67,
			"1":          0,
			"GL000207.1": 25,
			"GL000229.1": 27,
			"GL000236.1": 48,
			"GL000243.1": 50,
			"GL000214.1": 61,
			"2":          1,
			"GL000231.1": 28,
			"GL000244.1": 41,
			"GL000198.1": 56,
			"GL000213.1": 66,
			"GL000200.1": 79,
			"NC_007605":  84,
			"3":          2,
			"GL000234.1": 44,
			"GL000241.1": 49,
			"GL000216.1": 70,
			"GL000205.1": 72,
			"4":          3,
			"19":         18,
			"GL000196.1": 39,
			"GL000220.1": 65,
			"5":          4,
			"18":         17,
			"MT":         24,
			"GL000210.1": 29,
			"GL000247.1": 33,
			"GL000203.1": 36,
			"GL000232.1": 45,
			"6":          5,
			"GL000248.1": 40,
			"GL000222.1": 78,
			"GL000194.1": 81,
			"7":          6,
			"GL000201.1": 32,
			"GL000245.1": 34,
			"GL000230.1": 52,
			"GL000199.1": 68,
			"GL000212.1": 77,
			"8":          7,
			"15":         14,
			"X":          22,
			"GL000219.1": 73,
			"GL000224.1": 74,
			"GL000192.1": 83,
			"9":          8,
			"14":         13,
			"Y":          23,
			"GL000197.1": 35,
			"GL000221.1": 62,
			"17":         16,
			"GL000226.1": 26,
			"GL000239.1": 30,
			"GL000208.1": 57,
			"hs37d5":     85,
			"16":         15,
			"GL000249.1": 38,
			"GL000223.1": 75,
			"GL000195.1": 76,
			"11":         10,
			"20":         19,
			"GL000206.1": 46,
			"GL000242.1": 51,
			"GL000237.1": 53,
			"GL000228.1": 60,
			"GL000215.1": 71,
			"10":         9,
			"21":         20,
			"GL000218.1": 64,
			"GL000193.1": 80,
			"GL000225.1": 82,
			"13":         12,
			"22":         21,
			"GL000235.1": 31,
			"GL000240.1": 47,
			"GL000204.1": 55,
			"GL000217.1": 69,
		},
		seenGroups: set{
			"SRR062634": 0,
			"SRR062635": 1,
			"SRR062641": 2,
		},
		seenProgs: set{
			"bwa_index":                           0,
			"sam_to_fixed_bam":                    3,
			"bam_realignment_around_known_indels": 5,
			"bam_recalibrate_quality_scores":      7,
			"bam_calculate_bq":                    8,
			"bam_merge":                           9,
			"bam_mark_duplicates":                 10,
			"bwa_aln_fastq":                       1,
			"bwa_sam":                             2,
			"gatk_target_interval_creator":        4,
			"bam_count_covariates":                6,
			"bam_merge.1":                         11,
		},
	}
)
