/* c-isr library stuff of Andes NDS32 cpu for GNU compiler
   Copyright (C) 2012-2018 Free Software Foundation, Inc.
   Contributed by Andes Technology Corporation.

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 3, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   Under Section 7 of GPL version 3, you are granted additional
   permissions described in the GCC Runtime Library Exception, version
   3.1, as published by the Free Software Foundation.

   You should have received a copy of the GNU General Public License and
   a copy of the GCC Runtime Library Exception along with this program;
   see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
   <http://www.gnu.org/licenses/>.  */

.macro SAVE_PARTIAL_4B
#ifdef __NDS32_REDUCED_REGS__
	smw.adm $r15, [$sp], $r15, #0x2
#else /* not __NDS32_REDUCED_REGS__ */
	smw.adm $r15, [$sp], $r27, #0x2
#endif /* not __NDS32_REDUCED_REGS__ */
	smw.adm $r0, [$sp], $r5, #0x0
#ifdef NDS32_EXT_IFC
	mfusr   $r1, $IFC_LP
	smw.adm $r1, [$sp], $r2, #0x0	/* Save extra $r2 to keep
					   stack 8-byte alignment.  */
#endif
	SAVE_MAC_REGS
	SAVE_FPU_REGS
#if defined(NDS32_NESTED) || defined(NDS32_NESTED_READY)
       mfsr    $r1, $IPC       /* Get IPC.  */
       mfsr    $r2, $IPSW      /* Get IPSW.  */
       smw.adm $r1, [$sp], $r2, #0x0   /* Push IPC, IPSW.  */
#endif
	mfsr	$r0, $ITYPE	/* Get VID to $r0.  */
	srli	$r0, $r0, #5
#ifdef __NDS32_ISA_V2__
	andi	$r0, $r0, #127
#else
	fexti33	$r0, #6
#endif
.endm

.macro SAVE_PARTIAL
/* SAVE_CALLER_REGS code has been moved to
   vector table generated by compiler.  */
#ifdef NDS32_EXT_IFC
	mfusr   $r1, $IFC_LP
	smw.adm $r1, [$sp], $r2, #0x0	/* Save extra $r2 to keep
					   stack 8-byte alignment.  */
#endif
	SAVE_MAC_REGS
	SAVE_FPU_REGS
#if defined(NDS32_NESTED) || defined(NDS32_NESTED_READY)
       mfsr    $r1, $IPC       /* Get IPC.  */
       mfsr    $r2, $IPSW      /* Get IPSW.  */
       smw.adm $r1, [$sp], $r2, #0x0   /* Push IPC, IPSW.  */
#endif
.endm
